/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.test;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.infinispan.Cache;
import org.infinispan.server.memcached.TextServer;

public class MemcachedTestingUtil {
    private static final String HOST = "127.0.0.1";
    private static final ThreadLocal<Integer> threadMemcachedPort = new ThreadLocal<Integer>(){
        private final AtomicInteger uniqueAddr = new AtomicInteger(11211);

        @Override
        protected Integer initialValue() {
            return this.uniqueAddr.getAndAdd(100);
        }
    };

    public static String k(Method method, String prefix) {
        return prefix + method.getName();
    }

    public static Object v(Method method, String prefix) {
        return prefix + method.getName();
    }

    public static String k(Method method) {
        return MemcachedTestingUtil.k(method, "k-");
    }

    public static Object v(Method method) {
        return MemcachedTestingUtil.v(method, "v-");
    }

    public static MemcachedClient createMemcachedClient(final long timeout, int port) throws IOException {
        DefaultConnectionFactory d = new DefaultConnectionFactory(){

            public long getOperationTimeout() {
                return timeout;
            }
        };
        return new MemcachedClient((ConnectionFactory)d, Arrays.asList(new InetSocketAddress(HOST, port)));
    }

    public static TextServer createMemcachedTextServer(Cache cache) throws IOException {
        return new TextServer(HOST, threadMemcachedPort.get().intValue(), cache, 0, 0);
    }

    public static TextServer createMemcachedTextServer(Cache cache, int port) throws IOException {
        return new TextServer(HOST, port, cache, 0, 0);
    }
}

