/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.RequestHeader;
import org.infinispan.server.core.ServerException;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers$;
import org.infinispan.server.memcached.DelayedFlushAll;
import org.infinispan.server.memcached.MemcachedDecoder$;
import org.infinispan.server.memcached.MemcachedOperation$;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.MemcachedValue;
import org.infinispan.server.memcached.RequestResolver$;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.TextProtocolUtil$class;
import org.infinispan.stats.Stats;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t}d\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003!5+WnY1dQ\u0016$G)Z2pI\u0016\u0014(BA\u0002\u0005\u0003%iW-\\2bG\",GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0002I\u0012\u0011\t5\u0001\"\u0003H\u0007\u0002\u001d)\u0011q\u0002B\u0001\u0005G>\u0014X-\u0003\u0002\u0012\u001d\t9\u0012IY:ue\u0006\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c#fG>$WM\u001d\t\u0003'eq!\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\ta\u0001\u0015:fI\u00164\u0017B\u0001\u000e\u001c\u0005\u0019\u0019FO]5oO*\u0011\u0001$\u0006\t\u0003;yi\u0011AA\u0005\u0003?\t\u0011a\"T3nG\u0006\u001c\u0007.\u001a3WC2,X\r\u0005\u0002\u001eC%\u0011!E\u0001\u0002\u0011)\u0016DH\u000f\u0015:pi>\u001cw\u000e\\+uS2\u0004\"\u0001\u0006\u0013\n\u0005\u0015*\"aC*dC2\fwJ\u00196fGRD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0006G\u0006\u001c\u0007.\u001a\t\u0005S)\u0012B$D\u0001\u0007\u0013\tYcAA\u0003DC\u000eDW\r\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003%\u00198\r[3ek2,'\u000f\u0005\u00020m5\t\u0001G\u0003\u00022e\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005M\"\u0014\u0001B;uS2T\u0011!N\u0001\u0005U\u00064\u0018-\u0003\u00028a\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u000be\u0002A\u0011\u0001\u001e\u0002\rqJg.\u001b;?)\rYD(\u0010\t\u0003;\u0001AQa\n\u001dA\u0002!BQ!\f\u001dA\u00029*\u0001b\u0010\u0001\u0005\u0002\u0003\u0005\t\u0001\u0011\u0002\u0013'VLG/\u00192mKB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0002\u001e\u0003&\u0011!I\u0001\u0002\u0014\u001b\u0016l7-Y2iK\u0012\u0004\u0016M]1nKR,'o]\u0003\t\t\u0002!\t\u0011!A\u0001\u000b\nq1+^5uC\ndW\rS3bI\u0016\u0014\bCA\u0007G\u0013\t9eBA\u0007SKF,Xm\u001d;IK\u0006$WM\u001d\u0005\t\u0013\u0002A)\u0019!C\u0005\u0015\u0006q\u0011n]*uCR\u001cXI\\1cY\u0016$W#A&\u0011\u0005Qa\u0015BA'\u0016\u0005\u001d\u0011un\u001c7fC:D\u0001b\u0014\u0001\t\u0002\u0003\u0006KaS\u0001\u0010SN\u001cF/\u0019;t\u000b:\f'\r\\3eA!9\u0011\u000b\u0001b\u0001\n\u001b\u0011\u0016AC5oGJl\u0015n]:fgV\t1\u000b\u0005\u0002U/6\tQK\u0003\u0002Wa\u00051\u0011\r^8nS\u000eL!\u0001W+\u0003\u0015\u0005#x.\\5d\u0019>tw\r\u0003\u0004[\u0001\u0001\u0006iaU\u0001\fS:\u001c'/T5tg\u0016\u001c\b\u0005C\u0004]\u0001\t\u0007IQ\u0002*\u0002\u0011%t7M\u001d%jiNDaA\u0018\u0001!\u0002\u001b\u0019\u0016!C5oGJD\u0015\u000e^:!\u0011\u001d\u0001\u0007A1A\u0005\u000eI\u000b!\u0002Z3de6K7o]3t\u0011\u0019\u0011\u0007\u0001)A\u0007'\u0006YA-Z2s\u001b&\u001c8/Z:!\u0011\u001d!\u0007A1A\u0005\u000eI\u000b\u0001\u0002Z3de\"KGo\u001d\u0005\u0007M\u0002\u0001\u000bQB*\u0002\u0013\u0011,7M\u001d%jiN\u0004\u0003b\u00025\u0001\u0005\u0004%iAU\u0001\u001ae\u0016\u0004H.Y2f\u0013\u001a,f.\\8eS\u001aLW\rZ'jgN,7\u000f\u0003\u0004k\u0001\u0001\u0006iaU\u0001\u001be\u0016\u0004H.Y2f\u0013\u001a,f.\\8eS\u001aLW\rZ'jgN,7\u000f\t\u0005\bY\u0002\u0011\r\u0011\"\u0004S\u0003]\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0011&$8\u000f\u0003\u0004o\u0001\u0001\u0006iaU\u0001\u0019e\u0016\u0004H.Y2f\u0013\u001a,f.\\8eS\u001aLW\r\u001a%jiN\u0004\u0003b\u00029\u0001\u0005\u0004%iAU\u0001\u001ae\u0016\u0004H.Y2f\u0013\u001a,f.\\8eS\u001aLW\r\u001a\"bIZ\fG\u000e\u0003\u0004s\u0001\u0001\u0006iaU\u0001\u001be\u0016\u0004H.Y2f\u0013\u001a,f.\\8eS\u001aLW\r\u001a\"bIZ\fG\u000e\t\u0005\u0006i\u0002!\t%^\u0001\u000be\u0016\fG\rS3bI\u0016\u0014HCA#w\u0011\u001598\u000f1\u0001y\u0003\u0019\u0011WO\u001a4feB\u0011\u0011\u0010`\u0007\u0002u*\u00111PD\u0001\niJ\fgn\u001d9peRL!! >\u0003\u001b\rC\u0017M\u001c8fY\n+hMZ3s\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\u00059!/Z1e\u0017\u0016LH#\u0002\n\u0002\u0004\u0005\u001d\u0001BBA\u0003}\u0002\u0007Q)A\u0001i\u0011\u0019\tIA a\u0001q\u0006\t!\rC\u0004\u0002\u000e\u0001!\t%a\u0004\u0002\u0011I,\u0017\rZ&fsN$b!!\u0005\u0002\u0018\u0005e\u0001\u0003\u0002\u000b\u0002\u0014II1!!\u0006\u0016\u0005\u0015\t%O]1z\u0011\u001d\t)!a\u0003A\u0002\u0015Cq!!\u0003\u0002\f\u0001\u0007\u0001\u0010C\u0004\u0002\u001e\u0001!\t%a\b\u0002\u001dI,\u0017\r\u001a)be\u0006lW\r^3sgR1\u0011\u0011EA\u0014\u0003S\u0001B\u0001FA\u0012\u0001&\u0019\u0011QE\u000b\u0003\r=\u0003H/[8o\u0011\u001d\t)!a\u0007A\u0002\u0015Cq!!\u0003\u0002\u001c\u0001\u0007\u0001\u0010C\u0004\u0002.\u0001!\t%a\f\u0002\u0017\r\u0014X-\u0019;f-\u0006dW/\u001a\u000b\b9\u0005E\u0012qGA\u001e\u0011!\t)!a\u000bA\u0002\u0005M\u0002cAA\u001b\u00076\t\u0001\u0001C\u0004\u0002:\u0005-\u0002\u0019\u0001!\u0002\u0003AD\u0001\"!\u0010\u0002,\u0001\u0007\u0011qH\u0001\f]\u0016DHOV3sg&|g\u000eE\u0002\u0015\u0003\u0003J1!a\u0011\u0016\u0005\u0011auN\\4\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J\u0005Aq-\u001a;GY\u0006<7\u000f\u0006\u0003\u0002L\u0005E\u0003c\u0001\u000b\u0002N%\u0019\u0011qJ\u000b\u0003\u0007%sG\u000fC\u0004\u0002T\u0005\u0015\u0003\u0019\u0001\n\u0002\u000b\u0019d\u0017mZ:\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z\u0005Yq-\u001a;MS\u001a,7\u000f]1o)\u0011\tY%a\u0017\t\u000f\u0005u\u0013Q\u000ba\u0001%\u0005AA.\u001b4fgB\fg\u000eC\u0004\u0002b\u0001!I!a\u0019\u0002\u0013\u001d,G\u000fT3oORDG\u0003BA&\u0003KBq!a\u001a\u0002`\u0001\u0007!#\u0001\u0004mK:<G\u000f\u001b\u0005\b\u0003W\u0002A\u0011BA7\u0003)9W\r\u001e,feNLwN\u001c\u000b\u0005\u0003\u007f\ty\u0007C\u0004\u0002r\u0005%\u0004\u0019\u0001\n\u0002\u000fY,'o]5p]\"9\u0011Q\u000f\u0001\u0005\n\u0005]\u0014\u0001\u00049beN,gj\u001c*fa2LH#B&\u0002z\u0005u\u0004\u0002CA>\u0003g\u0002\r!a\u0013\u0002\u001b\u0015D\b/Z2uK\u0012Le\u000eZ3y\u0011!\ty(a\u001dA\u0002\u0005E\u0011\u0001B1sONDq!a!\u0001\t\u0013\t))\u0001\fqCJ\u001cX\rR3mCf,G\rR3mKR,G+[7f)\u0019\tY%a\"\u0002\n\"A\u00111PAA\u0001\u0004\tY\u0005\u0003\u0005\u0002\u0000\u0005\u0005\u0005\u0019AA\t\u0011\u001d\ti\t\u0001C!\u0003\u001f\u000b\u0001bZ3u\u0007\u0006\u001c\u0007.\u001a\u000b\u0004Q\u0005E\u0005bBA\u0003\u0003\u0017\u0003\r!\u0012\u0005\b\u0003+\u0003A\u0011IAL\u0003MA\u0017M\u001c3mK\u000e+8\u000f^8n%\u0016\fX/Z:u)!\tI*a(\u0002\"\u0006\r\u0006c\u0001\u000b\u0002\u001c&\u0019\u0011QT\u000b\u0003\r\u0005s\u0017PU3g\u0011\u001d\t)!a%A\u0002\u0015Cq!!\u0003\u0002\u0014\u0002\u0007\u0001\u0010\u0003\u0004(\u0003'\u0003\r\u0001\u000b\u0005\b\u0003O\u0003A\u0011IAU\u0003U\u0019'/Z1uKN+8mY3tgJ+7\u000f]8og\u0016$\u0002\"!'\u0002,\u00065\u0016\u0011\u0017\u0005\b\u0003\u000b\t)\u000b1\u0001F\u0011!\ty+!*A\u0002\u0005\u0005\u0012A\u00029be\u0006l7\u000fC\u0004\u00024\u0006\u0015\u0006\u0019\u0001\u000f\u0002\tA\u0014XM\u001e\u0005\b\u0003o\u0003A\u0011IA]\u0003e\u0019'/Z1uK:{G/\u0012=fGV$X\r\u001a*fgB|gn]3\u0015\u0011\u0005e\u00151XA_\u0003\u007fCq!!\u0002\u00026\u0002\u0007Q\t\u0003\u0005\u00020\u0006U\u0006\u0019AA\u0011\u0011\u001d\t\u0019,!.A\u0002qAq!a1\u0001\t\u0003\n)-\u0001\fde\u0016\fG/\u001a(pi\u0016C\u0018n\u001d;SKN\u0004xN\\:f)\u0019\tI*a2\u0002J\"A\u0011QAAa\u0001\u0004\t\u0019\u0004\u0003\u0005\u00020\u0006\u0005\u0007\u0019AA\u0011\u0011\u001d\ti\r\u0001C!\u0003\u001f\f\u0011c\u0019:fCR,w)\u001a;SKN\u0004xN\\:f)!\tI*!5\u0002T\u0006]\u0007bBA\u0003\u0003\u0017\u0004\r!\u0012\u0005\b\u0003+\fY\r1\u0001\u0013\u0003\u0005Y\u0007bBAm\u0003\u0017\u0004\r\u0001H\u0001\u0002m\"9\u0011Q\u001c\u0001\u0005B\u0005}\u0017AF2sK\u0006$X-T;mi&<U\r\u001e*fgB|gn]3\u0015\r\u0005e\u0015\u0011]Ar\u0011\u001d\t)!a7A\u0002\u0015C\u0001\"!:\u0002\\\u0002\u0007\u0011q]\u0001\u0006a\u0006L'o\u001d\t\u0006'\u0005%(\u0003H\u0005\u0004\u0003W\\\"aA'ba\"9\u0011q\u001e\u0001\u0005B\u0005E\u0018aE2sK\u0006$X-\u0012:s_J\u0014Vm\u001d9p]N,G\u0003BAM\u0003gD\u0001\"!>\u0002n\u0002\u0007\u0011q_\u0001\u0002iB!\u0011\u0011 B\u0005\u001d\u0011\tYP!\u0002\u000f\t\u0005u(1A\u0007\u0003\u0003\u007fT1A!\u0001\u000b\u0003\u0019a$o\\8u}%\ta#C\u0002\u0003\bU\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003\f\t5!!\u0003+ie><\u0018M\u00197f\u0015\r\u00119!\u0006\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0003M\u0019'/Z1uKN#\u0018\r^:SKN\u0004xN\\:f)\u0019\tIJ!\u0006\u0003\u001a!9!q\u0003B\b\u0001\u0004)\u0015A\u00025fC\u0012,'\u000f\u0003\u0005\u0003\u001c\t=\u0001\u0019\u0001B\u000f\u0003\u0015\u0019H/\u0019;t!\u0011\u0011yBa\t\u000e\u0005\t\u0005\"b\u0001B\u000e\r%!!Q\u0005B\u0011\u0005\u0015\u0019F/\u0019;t\u0011\u001d\u0011I\u0003\u0001C\u0005\u0005W\t\u0011BY;jY\u0012\u001cF/\u0019;\u0015\u000fa\u0014iC!\r\u0003<!9!q\u0006B\u0014\u0001\u0004\u0011\u0012\u0001B:uCRD\u0001Ba\r\u0003(\u0001\u0007!QG\u0001\u0006m\u0006dW/\u001a\t\u0004)\t]\u0012b\u0001B\u001d+\t\u0019\u0011I\\=\t\u0011\tu\"q\u0005a\u0001\u0005\u007f\t!a\u001d2\u0011\t\u0005e(\u0011I\u0005\u0005\u0005\u0007\u0012iAA\u0007TiJLgn\u001a\"vS2$WM\u001d\u0005\b\u0003[\u0001A\u0011\u0002B$)\u001da\"\u0011\nB+\u0005/B\u0001Ba\u0013\u0003F\u0001\u0007!QJ\u0001\u0005I\u0006$\u0018\rE\u0003\u0015\u0003'\u0011y\u0005E\u0002\u0015\u0005#J1Aa\u0015\u0016\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005u\"Q\ta\u0001\u0003\u007fA\u0001\"a\u0015\u0003F\u0001\u0007\u00111\n\u0005\b\u00057\u0002A\u0011\u0002B/\u0003A\u0011W/\u001b7e\u000f\u0016$(+Z:q_:\u001cX\rF\u0004y\u0005?\u0012yG!\u001d\t\u0011\t\u0005$\u0011\fa\u0001\u0005G\n!a\u001c9\u0011\t\t\u0015$1\u000e\t\u0004)\t\u001d\u0014b\u0001B5+\tYQI\\;nKJ\fG/[8o\u0013\u0011\u0011iGa\u001a\u0003\u000bY\u000bG.^3\t\u000f\u0005U'\u0011\fa\u0001%!9\u0011\u0011\u001cB-\u0001\u0004a\u0002b\u0002B;\u0001\u0011%!qO\u0001\u0017EVLG\u000eZ$fiJ+7\u000f]8og\u0016DU-\u00193feR9!C!\u001f\u0003|\tu\u0004bBAk\u0005g\u0002\rA\u0005\u0005\b\u00033\u0014\u0019\b1\u0001\u001d\u0011!\u0011\tGa\u001dA\u0002\t\r\u0004")
public class MemcachedDecoder
extends AbstractProtocolDecoder<String, MemcachedValue>
implements TextProtocolUtil,
ScalaObject {
    private final Cache<String, MemcachedValue> cache;
    private final ScheduledExecutorService scheduler;
    private boolean isStatsEnabled;
    private final AtomicLong incrMisses;
    private final AtomicLong incrHits;
    private final AtomicLong decrMisses;
    private final AtomicLong decrHits;
    private final AtomicLong replaceIfUnmodifiedMisses;
    private final AtomicLong replaceIfUnmodifiedHits;
    private final AtomicLong replaceIfUnmodifiedBadval;
    private final String CRLF;
    private final byte[] CRLFBytes;
    private final byte[] END;
    private final byte[] DELETED;
    private final byte[] NOT_FOUND;
    private final byte[] EXISTS;
    private final byte[] STORED;
    private final byte[] NOT_STORED;
    private final byte[] OK;
    private final byte[] ERROR;
    private final int CR;
    private final int LF;
    public volatile int bitmap$0;

    @Override
    public String CRLF() {
        return this.CRLF;
    }

    @Override
    public byte[] CRLFBytes() {
        return this.CRLFBytes;
    }

    @Override
    public byte[] END() {
        return this.END;
    }

    @Override
    public byte[] DELETED() {
        return this.DELETED;
    }

    @Override
    public byte[] NOT_FOUND() {
        return this.NOT_FOUND;
    }

    @Override
    public byte[] EXISTS() {
        return this.EXISTS;
    }

    @Override
    public byte[] STORED() {
        return this.STORED;
    }

    @Override
    public byte[] NOT_STORED() {
        return this.NOT_STORED;
    }

    @Override
    public byte[] OK() {
        return this.OK;
    }

    @Override
    public byte[] ERROR() {
        return this.ERROR;
    }

    @Override
    public int CR() {
        return this.CR;
    }

    @Override
    public int LF() {
        return this.LF;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CRLF_$eq(String string) {
        this.CRLF = string;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CRLFBytes_$eq(byte[] byArray) {
        this.CRLFBytes = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$END_$eq(byte[] byArray) {
        this.END = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$DELETED_$eq(byte[] byArray) {
        this.DELETED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$NOT_FOUND_$eq(byte[] byArray) {
        this.NOT_FOUND = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$EXISTS_$eq(byte[] byArray) {
        this.EXISTS = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$STORED_$eq(byte[] byArray) {
        this.STORED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$NOT_STORED_$eq(byte[] byArray) {
        this.NOT_STORED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$OK_$eq(byte[] byArray) {
        this.OK = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$ERROR_$eq(byte[] byArray) {
        this.ERROR = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CR_$eq(int n) {
        this.CR = n;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$LF_$eq(int n) {
        this.LF = n;
    }

    @Override
    public String readElement(ChannelBuffer buffer) {
        return TextProtocolUtil$class.readElement(this, buffer);
    }

    @Override
    public String readLine(ChannelBuffer buffer) {
        return TextProtocolUtil$class.readLine(this, buffer);
    }

    @Override
    public byte[] concat(byte[] a, byte[] b) {
        return TextProtocolUtil$class.concat(this, a, b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStatsEnabled() {
        if ((this.bitmap$0 & 1) != 0) return this.isStatsEnabled;
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if ((this.bitmap$0 & 1) == 0) {
                this.isStatsEnabled = this.cache.getConfiguration().isExposeJmxStatistics();
                this.bitmap$0 |= 1;
            }
            return this.isStatsEnabled;
        }
    }

    private final AtomicLong incrMisses() {
        return this.incrMisses;
    }

    private final AtomicLong incrHits() {
        return this.incrHits;
    }

    private final AtomicLong decrMisses() {
        return this.decrMisses;
    }

    private final AtomicLong decrHits() {
        return this.decrHits;
    }

    private final AtomicLong replaceIfUnmodifiedMisses() {
        return this.replaceIfUnmodifiedMisses;
    }

    private final AtomicLong replaceIfUnmodifiedHits() {
        return this.replaceIfUnmodifiedHits;
    }

    private final AtomicLong replaceIfUnmodifiedBadval() {
        return this.replaceIfUnmodifiedBadval;
    }

    public RequestHeader readHeader(ChannelBuffer buffer) {
        Option<Enumeration.Value> op;
        String streamOp = this.readElement(buffer);
        Option<Enumeration.Value> option = op = RequestResolver$.MODULE$.toRequest(streamOp);
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
            String line = this.readLine(buffer);
            throw new UnknownOperationException(new StringBuilder().append((Object)"Unknown operation: ").append((Object)streamOp).toString());
        }
        return new RequestHeader((Enumeration.Value)op.get());
    }

    public String readKey(RequestHeader h, ChannelBuffer b) {
        return this.readElement(b);
    }

    public String[] readKeys(RequestHeader h, ChannelBuffer b) {
        String line = this.readLine(b);
        return line.trim().split(" +");
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<MemcachedParameters> readParameters(RequestHeader h, ChannelBuffer b) {
        Enumeration.Value temp1;
        Enumeration.Value temp2;
        int index;
        String[] args;
        None$ none$;
        block7: {
            block6: {
                String line = this.readLine(b);
                if (line.isEmpty()) {
                    none$ = None$.MODULE$;
                    return none$;
                }
                RequestResolver$.MODULE$.trace((Function0)new $anonfun$readParameters$1(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line}));
                args = line.trim().split(" +");
                index = 0;
                Enumeration.Value value = temp2 = h.op();
                Enumeration.Value value2 = Operation$.MODULE$.RemoveRequest();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    int delayedDeleteTime = this.parseDelayedDeleteTime(index, args);
                    boolean noReply = delayedDeleteTime == -1 ? this.parseNoReply(index, args) : false;
                    none$ = new Some((Object)new MemcachedParameters(null, -1, -1, -1L, noReply, 0, "", 0));
                    return none$;
                }
                Enumeration.Value value3 = temp2;
                Enumeration.Value value4 = MemcachedOperation$.MODULE$.IncrementRequest();
                if (!(value3 == null ? value4 != null : !value3.equals(value4))) break block6;
                Enumeration.Value value5 = temp2;
                Enumeration.Value value6 = MemcachedOperation$.MODULE$.DecrementRequest();
                if (value5 != null ? !value5.equals(value6) : value6 != null) break block7;
            }
            String delta = args[index];
            none$ = new Some((Object)new MemcachedParameters(null, -1, -1, -1L, this.parseNoReply(++index, args), 0, delta, 0));
            return none$;
        }
        Enumeration.Value value = temp2;
        Enumeration.Value value7 = MemcachedOperation$.MODULE$.FlushAllRequest();
        if (!(value != null ? !value.equals(value7) : value7 != null)) {
            int flushDelay = Predef$.MODULE$.augmentString(args[index]).toInt();
            none$ = new Some((Object)new MemcachedParameters(null, -1, -1, -1L, this.parseNoReply(++index, args), 0, "", flushDelay));
            return none$;
        }
        int flags = this.getFlags(args[index]);
        int streamLifespan = this.getLifespan(args[++index]);
        int lifespan = streamLifespan <= 0 ? -1 : streamLifespan;
        int length = this.getLength(args[++index]);
        Enumeration.Value value8 = temp1 = h.op();
        Enumeration.Value value9 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
        long streamVersion = !(value8 != null ? !value8.equals(value9) : value9 != null) ? this.getVersion(args[++index]) : -1L;
        boolean noReply = this.parseNoReply(++index, args);
        byte[] data = new byte[length];
        b.readBytes(data, 0, data.length);
        this.readLine(b);
        none$ = new Some((Object)new MemcachedParameters(data, lifespan, -1, streamVersion, noReply, flags, "", 0));
        return none$;
    }

    public MemcachedValue createValue(RequestHeader h, MemcachedParameters p, long nextVersion) {
        return new MemcachedValue(p.data(), nextVersion, p.flags());
    }

    private int getFlags(String flags) {
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        return Predef$.MODULE$.augmentString(flags).toInt();
    }

    private int getLifespan(String lifespan) {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return Predef$.MODULE$.augmentString(lifespan).toInt();
    }

    private int getLength(String length) {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return Predef$.MODULE$.augmentString(length).toInt();
    }

    private long getVersion(String version) {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return Predef$.MODULE$.augmentString(version).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNoReply(int expectedIndex, String[] args) {
        if (args.length <= expectedIndex) return false;
        String string = args[expectedIndex];
        if ("noreply" != null) {
            if (!"noreply".equals(string)) throw new StreamCorruptedException("Unable to parse noreply optional argument");
            return true;
        }
        if (string == null) return true;
        throw new StreamCorruptedException("Unable to parse noreply optional argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDelayedDeleteTime(int expectedIndex, String[] args) {
        int n;
        if (args.length <= expectedIndex) return 0;
        int exceptionResult1 = 0;
        try {
            n = exceptionResult1 = Predef$.MODULE$.augmentString(args[expectedIndex]).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public Cache<String, MemcachedValue> getCache(RequestHeader h) {
        return this.cache;
    }

    public Object handleCustomRequest(RequestHeader h, ChannelBuffer b, Cache<String, MemcachedValue> cache) {
        Enumeration.Value temp5;
        block22: {
            Object object;
            block10: {
                block21: {
                    block15: {
                        Enumeration.Value temp4;
                        block19: {
                            String prevCounter;
                            block20: {
                                Object object2;
                                long l;
                                MemcachedValue prev;
                                Option<MemcachedParameters> params;
                                String k;
                                block18: {
                                    block17: {
                                        block16: {
                                            Object object3;
                                            block14: {
                                                block8: {
                                                    Enumeration.Value temp3;
                                                    block13: {
                                                        byte[] byArray;
                                                        MemcachedValue prev2;
                                                        Option<MemcachedParameters> params2;
                                                        String k2;
                                                        block12: {
                                                            block11: {
                                                                block9: {
                                                                    block7: {
                                                                        Enumeration.Value value = temp5 = h.op();
                                                                        Enumeration.Value value2 = MemcachedOperation$.MODULE$.AppendRequest();
                                                                        if (!(value == null ? value2 != null : !value.equals(value2))) break block7;
                                                                        Enumeration.Value value3 = temp5;
                                                                        Enumeration.Value value4 = MemcachedOperation$.MODULE$.PrependRequest();
                                                                        if (value3 != null ? !value3.equals(value4) : value4 != null) break block8;
                                                                    }
                                                                    k2 = this.readKey(h, b);
                                                                    params2 = this.readParameters(h, b);
                                                                    prev2 = (MemcachedValue)((Object)cache.get(k2));
                                                                    if (prev2 != null) break block9;
                                                                    object = ((MemcachedParameters)((Object)params2.get())).noReply() ? null : this.NOT_STORED();
                                                                    break block10;
                                                                }
                                                                Enumeration.Value value = temp3 = h.op();
                                                                Enumeration.Value value5 = MemcachedOperation$.MODULE$.AppendRequest();
                                                                if (value != null ? !value.equals(value5) : value5 != null) break block11;
                                                                byArray = this.concat(prev2.data(), ((MemcachedParameters)((Object)params2.get())).data());
                                                                break block12;
                                                            }
                                                            Enumeration.Value value = temp3;
                                                            Enumeration.Value value6 = MemcachedOperation$.MODULE$.PrependRequest();
                                                            if (value != null ? !value.equals(value6) : value6 != null) break block13;
                                                            byArray = this.concat(((MemcachedParameters)((Object)params2.get())).data(), prev2.data());
                                                        }
                                                        byte[] concatenated = byArray;
                                                        MemcachedValue next = this.createValue(concatenated, this.generateVersion(cache), ((MemcachedParameters)((Object)params2.get())).flags());
                                                        boolean replaced = cache.replace(k2, prev2, next);
                                                        object = replaced ? (Object)(((MemcachedParameters)((Object)params2.get())).noReply() ? null : this.STORED()) : (Object)(((MemcachedParameters)((Object)params2.get())).noReply() ? null : this.NOT_STORED());
                                                        break block10;
                                                    }
                                                    throw new MatchError((Object)temp3);
                                                }
                                                Enumeration.Value value = temp5;
                                                Enumeration.Value value7 = MemcachedOperation$.MODULE$.IncrementRequest();
                                                if (!(value == null ? value7 != null : !value.equals(value7))) break block14;
                                                Enumeration.Value value8 = temp5;
                                                Enumeration.Value value9 = MemcachedOperation$.MODULE$.DecrementRequest();
                                                if (value8 != null ? !value8.equals(value9) : value9 != null) break block15;
                                            }
                                            k = this.readKey(h, b);
                                            params = this.readParameters(h, b);
                                            prev = (MemcachedValue)((Object)cache.get(k));
                                            if (prev != null) break block16;
                                            if (this.isStatsEnabled()) {
                                                Enumeration.Value value = h.op();
                                                Enumeration.Value value10 = MemcachedOperation$.MODULE$.IncrementRequest();
                                                object3 = BoxesRunTime.boxToLong((long)(!(value != null ? !value.equals(value10) : value10 != null) ? this.incrMisses().incrementAndGet() : this.decrMisses().incrementAndGet()));
                                            } else {
                                                object3 = BoxedUnit.UNIT;
                                            }
                                            object = ((MemcachedParameters)((Object)params.get())).noReply() ? null : this.NOT_FOUND();
                                            break block10;
                                        }
                                        prevCounter = new String(prev.data());
                                        Enumeration.Value value = temp4 = h.op();
                                        Enumeration.Value value11 = MemcachedOperation$.MODULE$.IncrementRequest();
                                        if (value != null ? !value.equals(value11) : value11 != null) break block17;
                                        l = Predef$.MODULE$.augmentString(prevCounter).toLong() + Predef$.MODULE$.augmentString(((MemcachedParameters)((Object)params.get())).delta()).toLong();
                                        break block18;
                                    }
                                    Enumeration.Value value = temp4;
                                    Enumeration.Value value12 = MemcachedOperation$.MODULE$.DecrementRequest();
                                    if (value != null ? !value.equals(value12) : value12 != null) break block19;
                                    long candidateCounter = Predef$.MODULE$.augmentString(prevCounter).toLong() - Predef$.MODULE$.augmentString(((MemcachedParameters)((Object)params.get())).delta()).toLong();
                                    l = candidateCounter < 0L ? 0L : candidateCounter;
                                }
                                long newCounter = l;
                                MemcachedValue next = this.createValue(((Object)BoxesRunTime.boxToLong((long)newCounter)).toString().getBytes(), this.generateVersion(cache), ((MemcachedParameters)((Object)params.get())).flags());
                                boolean replaced = cache.replace(k, prev, next);
                                if (!replaced) break block20;
                                if (this.isStatsEnabled()) {
                                    Enumeration.Value value = h.op();
                                    Enumeration.Value value13 = MemcachedOperation$.MODULE$.IncrementRequest();
                                    object2 = BoxesRunTime.boxToLong((long)(!(value != null ? !value.equals(value13) : value13 != null) ? this.incrHits().incrementAndGet() : this.decrHits().incrementAndGet()));
                                } else {
                                    object2 = BoxedUnit.UNIT;
                                }
                                object = ((MemcachedParameters)((Object)params.get())).noReply() ? null : (Object)new StringBuilder().append((Object)new String(next.data())).append((Object)this.CRLF()).toString();
                                break block10;
                            }
                            throw new CacheException(new StringBuilder().append((Object)"Value modified since we retrieved from the cache, old value was ").append((Object)prevCounter).toString());
                        }
                        throw new MatchError((Object)temp4);
                    }
                    Enumeration.Value value = temp5;
                    Enumeration.Value value14 = MemcachedOperation$.MODULE$.FlushAllRequest();
                    if (value != null ? !value.equals(value14) : value14 != null) break block21;
                    Option<MemcachedParameters> params = this.readParameters(h, b);
                    $anonfun$1 flushFunction = new $anonfun$1(this);
                    Option<MemcachedParameters> option = params;
                    None$ none$ = None$.MODULE$;
                    int flushDelay = !(option != null ? !option.equals((Object)none$) : none$ != null) ? 0 : ((MemcachedParameters)((Object)params.get())).flushDelay();
                    ScheduledFuture<?> scheduledFuture = flushDelay == 0 ? flushFunction.apply(cache.getAdvancedCache()) : this.scheduler.schedule(new DelayedFlushAll(cache, (Function1<AdvancedCache<String, MemcachedValue>, Object>)flushFunction), (long)flushDelay, TimeUnit.SECONDS);
                    Option<MemcachedParameters> option2 = params;
                    None$ none$2 = None$.MODULE$;
                    object = (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) && ((MemcachedParameters)((Object)params.get())).noReply() ? null : this.OK();
                    break block10;
                }
                Enumeration.Value value = temp5;
                Enumeration.Value value15 = MemcachedOperation$.MODULE$.VersionRequest();
                if (value != null ? !value.equals(value15) : value15 != null) break block22;
                object = new StringBuilder().append("VERSION ").append("4.1.0.BETA1").append(this.CRLF());
            }
            return object;
        }
        throw new MatchError((Object)temp5);
    }

    public Object createSuccessResponse(RequestHeader h, Option<MemcachedParameters> params, MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value temp6;
            Enumeration.Value value = temp6 = h.op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value != null ? !value.equals(value2) : value2 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedHits().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<MemcachedParameters> option = params;
        None$ none$ = None$.MODULE$;
        if ((option == null ? none$ != null : !option.equals((Object)none$)) && ((MemcachedParameters)((Object)params.get())).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value temp7;
            Enumeration.Value value = temp7 = h.op();
            Enumeration.Value value3 = Operation$.MODULE$.RemoveRequest();
            byArray = !(value != null ? !value.equals(value3) : value3 != null) ? this.DELETED() : this.STORED();
        }
        return byArray;
    }

    public Object createNotExecutedResponse(RequestHeader h, Option<MemcachedParameters> params, MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value temp8;
            Enumeration.Value value = temp8 = h.op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value != null ? !value.equals(value2) : value2 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedBadval().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<MemcachedParameters> option = params;
        None$ none$ = None$.MODULE$;
        if ((option == null ? none$ != null : !option.equals((Object)none$)) && ((MemcachedParameters)((Object)params.get())).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value temp9;
            Enumeration.Value value = temp9 = h.op();
            Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            byArray = !(value != null ? !value.equals(value3) : value3 != null) ? this.EXISTS() : this.NOT_STORED();
        }
        return byArray;
    }

    public Object createNotExistResponse(RequestHeader h, Option<MemcachedParameters> params) {
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value temp10;
            Enumeration.Value value = temp10 = h.op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value != null ? !value.equals(value2) : value2 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedMisses().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<MemcachedParameters> option = params;
        None$ none$ = None$.MODULE$;
        return (byte[])((option == null ? none$ != null : !option.equals((Object)none$)) && ((MemcachedParameters)((Object)params.get())).noReply() ? null : this.NOT_FOUND());
    }

    public Object createGetResponse(RequestHeader h, String k, MemcachedValue v) {
        return v == null ? this.END() : (byte[])List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(h.op(), k, v), ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()}))}));
    }

    public Object createMultiGetResponse(RequestHeader h$1, Map<String, MemcachedValue> pairs) {
        Enumeration.Value temp14;
        block3: {
            ListBuffer elements$1;
            block2: {
                elements$1 = new ListBuffer();
                Enumeration.Value value = temp14 = h$1.op();
                Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
                if (!(value == null ? value2 != null : !value.equals(value2))) break block2;
                Enumeration.Value value3 = temp14;
                Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
                if (value3 != null ? !value3.equals(value4) : value4 != null) break block3;
            }
            pairs.foreach((Function1)new $anonfun$createMultiGetResponse$1(this, h$1, elements$1));
            elements$1.$plus$eq((Object)ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{"END\r\n".getBytes()})));
            return elements$1.toList();
        }
        throw new MatchError((Object)temp14);
    }

    public Object createErrorResponse(Throwable t) {
        Object object;
        StringBuilder sb = new StringBuilder();
        Throwable temp20 = t;
        if (temp20 instanceof ServerException) {
            ServerException temp21 = (ServerException)temp20;
            ServerException se = temp21;
            Throwable temp17 = se.getCause();
            if (temp17 instanceof UnknownOperationException) {
                object = this.ERROR();
            } else if (temp17 instanceof ClosedChannelException) {
                object = null;
            } else {
                Throwable temp15 = t;
                StringBuilder stringBuilder = temp15 instanceof IOException ? sb.append("CLIENT_ERROR ") : sb.append("SERVER_ERROR ");
                object = sb.append((Object)t).append(this.CRLF());
            }
        } else {
            object = temp20 instanceof ClosedChannelException ? null : sb.append("SERVER_ERROR ").append((Object)t).append(this.CRLF());
        }
        return object;
    }

    public Object createStatsResponse(RequestHeader header, Stats stats) {
        StringBuilder sb = new StringBuilder();
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.buildStat("pid", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("time", BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())), sb), this.buildStat("version", this.cache.getVersion(), sb), this.buildStat("pointer_size", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_user", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_system", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_items", BoxesRunTime.boxToInteger((int)stats.getCurrentNumberOfEntries()), sb), this.buildStat("total_items", BoxesRunTime.boxToLong((long)stats.getTotalNumberOfEntries()), sb), this.buildStat("bytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("total_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("connection_structures", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("cmd_get", BoxesRunTime.boxToLong((long)stats.getRetrievals()), sb), this.buildStat("cmd_set", BoxesRunTime.boxToLong((long)stats.getStores()), sb), this.buildStat("get_hits", BoxesRunTime.boxToLong((long)stats.getHits()), sb), this.buildStat("get_misses", BoxesRunTime.boxToLong((long)stats.getMisses()), sb), this.buildStat("delete_misses", BoxesRunTime.boxToLong((long)stats.getRemoveMisses()), sb), this.buildStat("delete_hits", BoxesRunTime.boxToLong((long)stats.getRemoveHits()), sb), this.buildStat("incr_misses", this.incrMisses(), sb), this.buildStat("incr_hits", this.incrHits(), sb), this.buildStat("decr_misses", this.decrMisses(), sb), this.buildStat("decr_hits", this.decrHits(), sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses(), sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits(), sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval(), sb), this.buildStat("auth_cmds", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("auth_errors", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("evictions", BoxesRunTime.boxToLong((long)stats.getEvictions()), sb), this.buildStat("bytes_read", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("bytes_written", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("limit_maxbytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("threads", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("conn_yields", BoxesRunTime.boxToInteger((int)0), sb), ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()}))}));
    }

    private ChannelBuffer buildStat(String stat, Object value, StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append(this.CRLF());
        ChannelBuffer buffer = ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sb.toString().getBytes()}));
        sb.setLength(0);
        return buffer;
    }

    private MemcachedValue createValue(byte[] data, long nextVersion, int flags) {
        return new MemcachedValue(data, nextVersion, flags);
    }

    public final ChannelBuffer org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(Enumeration.Value op, String k, MemcachedValue v) {
        String header = this.buildGetResponseHeader(k, v, op);
        return ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{header.getBytes(), v.data(), this.CRLFBytes()}));
    }

    private String buildGetResponseHeader(String k, MemcachedValue v, Enumeration.Value op) {
        StringBuilder sb = new StringBuilder();
        sb.append("VALUE ").append(k).append(" ").append(v.flags()).append(" ").append(v.data().length).append(" ");
        Enumeration.Value value = op;
        Enumeration.Value value2 = Operation$.MODULE$.GetWithVersionRequest();
        Object object = !(value != null ? !value.equals(value2) : value2 != null) ? sb.append(v.version()).append(" ") : BoxedUnit.UNIT;
        sb.append(this.CRLF());
        return sb.toString();
    }

    public MemcachedDecoder(Cache<String, MemcachedValue> cache, ScheduledExecutorService scheduler) {
        this.cache = cache;
        this.scheduler = scheduler;
        TextProtocolUtil$class.$init$(this);
        this.incrMisses = new AtomicLong(0L);
        this.incrHits = new AtomicLong(0L);
        this.decrMisses = new AtomicLong(0L);
        this.decrHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedMisses = new AtomicLong(0L);
        this.replaceIfUnmodifiedHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedBadval = new AtomicLong(0L);
    }
}

