/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import org.infinispan.server.memcached.MemcachedFunctionalTest$;
import org.infinispan.server.memcached.MemcachedSingleNodeTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;

@Test(groups={"functional"}, testName="server.memcached.MemcachedFunctionalTest")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003/5+WnY1dQ\u0016$g)\u001e8di&|g.\u00197UKN$(BA\u0002\u0005\u0003%iW-\\2bG\",GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0002\u0005\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u0011q#T3nG\u0006\u001c\u0007.\u001a3TS:<G.\u001a(pI\u0016$Vm\u001d;\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"!\u0004\u0001\t\u000bm\u0001A\u0011\u0001\u000f\u0002\u0019Q,7\u000f^*fi\n\u000b7/[2\u0015\u0005u\u0001\u0003CA\t\u001f\u0013\ty\"C\u0001\u0003V]&$\b\"B\u0011\u001b\u0001\u0004\u0011\u0013!A7\u0011\u0005\rRS\"\u0001\u0013\u000b\u0005\u00152\u0013a\u0002:fM2,7\r\u001e\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016%\u0005\u0019iU\r\u001e5pI\")Q\u0006\u0001C\u0001]\u0005AB/Z:u'\u0016$x+\u001b;i\u000bb\u0004\u0018N]=TK\u000e|g\u000eZ:\u0015\u0005uy\u0003\"B\u0011-\u0001\u0004\u0011\u0003\"B\u0019\u0001\t\u0003\u0011\u0014!\u0007;fgR\u001cV\r^,ji\",\u0005\u0010]5ssVs\u0017\u000e\u001f+j[\u0016$\"!H\u001a\t\u000b\u0005\u0002\u0004\u0019\u0001\u0012\t\u000bU\u0002A\u0011\u0001\u001c\u0002'Q,7\u000f^$fi6+H\u000e^5qY\u0016\\U-_:\u0015\u0005u9\u0004\"B\u00115\u0001\u0004\u0011\u0003\"B\u001d\u0001\t\u0003Q\u0014\u0001\u0004;fgR\fE\r\u001a\"bg&\u001cGCA\u000f<\u0011\u0015\t\u0003\b1\u0001#\u0011\u0015i\u0004\u0001\"\u0001?\u0003a!Xm\u001d;BI\u0012<\u0016\u000e\u001e5FqBL'/_*fG>tGm\u001d\u000b\u0003;}BQ!\t\u001fA\u0002\tBQ!\u0011\u0001\u0005\u0002\t\u000b\u0011\u0004^3ti\u0006#GmV5uQ\u0016C\b/\u001b:z+:L\u0007\u0010V5nKR\u0011Qd\u0011\u0005\u0006C\u0001\u0003\rA\t\u0005\u0006\u000b\u0002!\tAR\u0001\u0014i\u0016\u001cHOT8u\u0003\u0012$\u0017J\u001a)sKN,g\u000e\u001e\u000b\u0003;\u001dCQ!\t#A\u0002\tBQ!\u0013\u0001\u0005\u0002)\u000b\u0001\u0003^3tiJ+\u0007\u000f\\1dK\n\u000b7/[2\u0015\u0005uY\u0005\"B\u0011I\u0001\u0004\u0011\u0003\"B'\u0001\t\u0003q\u0015A\u0007;fgRtu\u000e\u001e*fa2\f7-Z%g\u001d>$\bK]3tK:$HCA\u000fP\u0011\u0015\tC\n1\u0001#\u0011\u0015\t\u0006\u0001\"\u0001S\u0003q!Xm\u001d;SKBd\u0017mY3XSRDW\t\u001f9jef\u001cVmY8oIN$\"!H*\t\u000b\u0005\u0002\u0006\u0019\u0001\u0012\t\u000bU\u0003A\u0011\u0001,\u0002;Q,7\u000f\u001e*fa2\f7-Z,ji\",\u0005\u0010]5ssVs\u0017\u000e\u001f+j[\u0016$\"!H,\t\u000b\u0005\"\u0006\u0019\u0001\u0012\t\u000be\u0003A\u0011\u0001.\u0002\u001fQ,7\u000f^!qa\u0016tGMQ1tS\u000e$\"!H.\t\u000b\u0005B\u0006\u0019\u0001\u0012\t\u000bu\u0003A\u0011\u00010\u0002%Q,7\u000f^!qa\u0016tGMT8u\r>,h\u000e\u001a\u000b\u0003;}CQ!\t/A\u0002\tBQ!\u0019\u0001\u0005\u0002\t\f\u0001\u0003^3tiB\u0013X\r]3oI\n\u000b7/[2\u0015\u0005u\u0019\u0007\"B\u0011a\u0001\u0004\u0011\u0003\"B3\u0001\t\u00031\u0017a\u0005;fgR\u0004&/\u001a9f]\u0012tu\u000e\u001e$pk:$GCA\u000fh\u0011\u0015\tC\r1\u0001#\u0011\u0015I\u0007\u0001\"\u0001k\u00035!Xm\u001d;HKR\u001c()Y:jGR\u0011Qd\u001b\u0005\u0006C!\u0004\rA\t\u0005\u0006[\u0002!\tA\\\u0001\ri\u0016\u001cHoQ1t\u0005\u0006\u001c\u0018n\u0019\u000b\u0003;=DQ!\t7A\u0002\tBQ!\u001d\u0001\u0005\u0002I\fq\u0002^3ti\u000e\u000b7OT8u\r>,h\u000e\u001a\u000b\u0003;MDQ!\t9A\u0002\tBQ!\u001e\u0001\u0005\u0002Y\fQ\u0002^3ti\u000e\u000b7/\u0012=jgR\u001cHCA\u000fx\u0011\u0015\tC\u000f1\u0001#\u0011\u0015I\b\u0001\"\u0001{\u0003=!Xm\u001d;EK2,G/\u001a\"bg&\u001cGCA\u000f|\u0011\u0015\t\u0003\u00101\u0001#\u0011\u0015i\b\u0001\"\u0001\u007f\u0003Y!Xm\u001d;EK2,G/\u001a#pKNtu\u000e^#ySN$HCA\u000f\u0000\u0011\u0015\tC\u00101\u0001#\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003\u000b\t!\u0003^3ti&s7M]3nK:$()Y:jGR\u0019Q$a\u0002\t\r\u0005\n\t\u00011\u0001#\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\t1\u0003^3ti&s7M]3nK:$HK]5qY\u0016$2!HA\b\u0011\u0019\t\u0013\u0011\u0002a\u0001E!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011!\u0006;fgRLen\u0019:f[\u0016tGOT8u\u000bbL7\u000f\u001e\u000b\u0004;\u0005]\u0001BB\u0011\u0002\u0012\u0001\u0007!\u0005C\u0004\u0002\u001c\u0001!\t!!\b\u0002/Q,7\u000f^%oGJ,W.\u001a8u\u0013:$XmZ3s\u001b\u0006DHcA\u000f\u0002 !1\u0011%!\u0007A\u0002\tBq!a\t\u0001\t\u0003\t)#A\u000fuKN$\u0018J\\2sK6,g\u000e\u001e\"fs>tG-\u00138uK\u001e,'/T1y)\ri\u0012q\u0005\u0005\u0007C\u0005\u0005\u0002\u0019\u0001\u0012\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.\u0005\u0011B/Z:u\t\u0016\u001c'/Z7f]R\u0014\u0015m]5d)\ri\u0012q\u0006\u0005\u0007C\u0005%\u0002\u0019\u0001\u0012\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\u0005\u0019B/Z:u\t\u0016\u001c'/Z7f]R$&/\u001b9mKR\u0019Q$a\u000e\t\r\u0005\n\t\u00041\u0001#\u0011\u001d\tY\u0004\u0001C\u0001\u0003{\tQ\u0003^3ti\u0012+7M]3nK:$hj\u001c;Fq&\u001cH\u000fF\u0002\u001e\u0003\u007fAa!IA\u001d\u0001\u0004\u0011\u0003bBA\"\u0001\u0011\u0005\u0011QI\u0001\u0017i\u0016\u001cH\u000fR3de\u0016lWM\u001c;CK2|wOW3s_R\u0019Q$a\u0012\t\r\u0005\n\t\u00051\u0001#\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001b\nA\u0002^3ti\u001acWo\u001d5BY2$2!HA(\u0011\u0019\t\u0013\u0011\na\u0001E!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0013a\u0005;fgR4E.^:i\u00032dG)\u001a7bs\u0016$GcA\u000f\u0002X!1\u0011%!\u0015A\u0002\tBq!a\u0017\u0001\t\u0003\ti&A\u0006uKN$h+\u001a:tS>tW#A\u000f\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d\u0005I\u0011\r\u001a3B]\u0012<U\r\u001e\u000b\u0004;\u0005\u0015\u0004BB\u0011\u0002`\u0001\u0007!\u0005K\u0006\u0001\u0003S\nI(a\u001f\u0002\u0002\u0006\r\u0005\u0003BA6\u0003kj!!!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\fC:tw\u000e^1uS>t7OC\u0002\u0002t!\ta\u0001^3ti:<\u0017\u0002BA<\u0003[\u0012A\u0001V3ti\u00061qM]8vaNd#!! \"\u0005\u0005}\u0014A\u00034v]\u000e$\u0018n\u001c8bY\u0006AA/Z:u\u001d\u0006lW-\t\u0002\u0002\u0006\u0006A3/\u001a:wKJtS.Z7dC\u000eDW\r\u001a\u0018NK6\u001c\u0017m\u00195fI\u001a+hn\u0019;j_:\fG\u000eV3ti\u0002")
public class MemcachedFunctionalTest
extends MemcachedSingleNodeTest
implements ScalaObject {
    public void testSetBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    public void testSetWithExpirySeconds(Method m) {
        Future f = this.client().set(this.k(m), 1, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testSetWithExpiryUnixTime(Method m) {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().set(this.k(m), future, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testGetMultipleKeys(Method m) {
        Future f1 = this.client().set(this.k(m, "k1-"), 0, (Object)this.v(m, "v1-"));
        Future f2 = this.client().set(this.k(m, "k2-"), 0, (Object)this.v(m, "v2-"));
        Future f3 = this.client().set(this.k(m, "k3-"), 0, (Object)this.v(m, "v3-"));
        Assert.assertTrue((boolean)((Boolean)f1.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f2.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f3.get(this.timeout(), TimeUnit.SECONDS)));
        List keys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.k(m, "k1-"), this.k(m, "k2-"), this.k(m, "k3-")}));
        Map ret = this.client().getBulk((String[])keys.toArray(ClassManifest$.MODULE$.classType(String.class)));
        Assert.assertEquals(ret.get(this.k(m, "k1-")), (Object)this.v(m, "v1-"));
        Assert.assertEquals(ret.get(this.k(m, "k2-")), (Object)this.v(m, "v2-"));
        Assert.assertEquals(ret.get(this.k(m, "k3-")), (Object)this.v(m, "v3-"));
    }

    public void testAddBasic(Method m) {
        this.addAndGet(m);
    }

    public void testAddWithExpirySeconds(Method m) {
        Future f = this.client().add(this.k(m), 1, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
        f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testAddWithExpiryUnixTime(Method m) {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().add(this.k(m), future, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
        f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testNotAddIfPresent(Method m) {
        this.addAndGet(m);
        Future f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    public void testReplaceBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().replace(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testNotReplaceIfNotPresent(Method m) {
        Future f = this.client().replace(this.k(m), 0, (Object)this.v(m));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testReplaceWithExpirySeconds(Method m) {
        this.addAndGet(m);
        Future f = this.client().replace(this.k(m), 1, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testReplaceWithExpiryUnixTime(Method m) {
        this.addAndGet(m);
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().replace(this.k(m), future, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testAppendBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().append(0L, this.k(m), (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)this.v(m)).append((Object)this.v(m, "v1-")).toString();
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)expected);
    }

    public void testAppendNotFound(Method m) {
        this.addAndGet(m);
        Future f = this.client().append(0L, this.k(m, "k2-"), (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        Assert.assertNull((Object)this.client().get(this.k(m, "k2-")));
    }

    public void testPrependBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().prepend(0L, this.k(m), (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)this.v(m, "v1-")).append((Object)this.v(m)).toString();
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)expected);
    }

    public void testPrependNotFound(Method m) {
        this.addAndGet(m);
        Future f = this.client().prepend(0L, this.k(m, "k2-"), (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        Assert.assertNull((Object)this.client().get(this.k(m, "k2-")));
    }

    public void testGetsBasic(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
    }

    public void testCasBasic(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v1-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testCasNotFound(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client().cas(this.k(m, "k1-"), value.getCas(), (Object)this.v(m, "v1-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.NOT_FOUND);
    }

    public void testCasExists(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        long old = value.getCas();
        CASResponse resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v1-"));
        value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m, "v1-"));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((value.getCas() != old ? 1 : 0) != 0);
        resp = this.client().cas(this.k(m), old, (Object)this.v(m, "v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.EXISTS);
        resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testDeleteBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().delete(this.k(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testDeleteDoesNotExist(Method m) {
        Future f = this.client().delete(this.k(m));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
    }

    public void testIncrementBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long result = this.client().incr(this.k(m), 1);
        Assert.assertEquals((long)result, (long)2L);
    }

    public void testIncrementTriple(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().incr(this.k(m), 1), (long)2L);
        Assert.assertEquals((long)this.client().incr(this.k(m), 2), (long)4L);
        Assert.assertEquals((long)this.client().incr(this.k(m), 4), (long)8L);
    }

    public void testIncrementNotExist(Method m) {
        Assert.assertEquals((long)this.client().incr(this.k(m), 1), (long)-1L);
    }

    public void testIncrementIntegerMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().incr(this.k(m), Integer.MAX_VALUE), (long)Integer.MAX_VALUE);
    }

    public void testIncrementBeyondIntegerMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long newValue = this.client().incr(this.k(m), Integer.MAX_VALUE);
        Assert.assertEquals((long)newValue, (long)((long)Integer.MAX_VALUE + 1L));
    }

    public void testDecrementBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)0L);
    }

    public void testDecrementTriple(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"8");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)7L);
        Assert.assertEquals((long)this.client().decr(this.k(m), 2), (long)5L);
        Assert.assertEquals((long)this.client().decr(this.k(m), 4), (long)1L);
    }

    public void testDecrementNotExist(Method m) {
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)-1L);
    }

    public void testDecrementBelowZero(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long newValue = this.client().decr(this.k(m), 2);
        Assert.assertEquals((long)newValue, (long)0L);
    }

    public void testFlushAll(Method m$1) {
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$testFlushAll$1(this, m$1));
        Future f = this.client().flush();
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$testFlushAll$2(this, m$1));
    }

    public void testFlushAllDelayed(Method m$2) {
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$testFlushAllDelayed$1(this, m$2));
        Future f = this.client().flush(2);
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)2200L);
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$testFlushAllDelayed$2(this, m$2));
    }

    public void testVersion() {
        Map versions = this.client().getVersions();
        Assert.assertEquals((int)versions.size(), (int)1);
        String version = (String)versions.values().iterator().next();
        Assert.assertEquals((String)version, (String)"4.1.0.CR2");
    }

    private void addAndGet(Method m) {
        Future f = this.client().add(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }
}

