/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import org.infinispan.server.memcached.MemcachedFunctionalTest$;
import org.infinispan.server.memcached.MemcachedSingleNodeTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Test(groups={"functional"}, testName="server.memcached.MemcachedFunctionalTest")
@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003/5+WnY1dQ\u0016$g)\u001e8di&|g.\u00197UKN$(BA\u0002\u0005\u0003%iW-\\2bG\",GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0002\u0005\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u0011q#T3nG\u0006\u001c\u0007.\u001a3TS:<G.\u001a(pI\u0016$Vm\u001d;\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"!\u0004\u0001\t\u000bm\u0001A\u0011\u0001\u000f\u0002\u0019Q,7\u000f^*fi\n\u000b7/[2\u0015\u0005u\u0001\u0003CA\t\u001f\u0013\ty\"C\u0001\u0003V]&$\b\"B\u0011\u001b\u0001\u0004\u0011\u0013!A7\u0011\u0005\rRS\"\u0001\u0013\u000b\u0005\u00152\u0013a\u0002:fM2,7\r\u001e\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016%\u0005\u0019iU\r\u001e5pI\")Q\u0006\u0001C\u0001]\u0005AB/Z:u'\u0016$x+\u001b;i\u000bb\u0004\u0018N]=TK\u000e|g\u000eZ:\u0015\u0005uy\u0003\"B\u0011-\u0001\u0004\u0011\u0003\"B\u0019\u0001\t\u0003\u0011\u0014!\u0007;fgR\u001cV\r^,ji\",\u0005\u0010]5ssVs\u0017\u000e\u001f+j[\u0016$\"!H\u001a\t\u000b\u0005\u0002\u0004\u0019\u0001\u0012\t\u000bU\u0002A\u0011\u0001\u001c\u0002?Q,7\u000f^*fi^KG\u000f[#ya&\u0014\u00180\u00168jqRKW.Z%o!\u0006\u001cH\u000f\u0006\u0002\u001eo!)\u0011\u0005\u000ea\u0001E!)\u0011\b\u0001C\u0001u\u0005\u0019B/Z:u\u000f\u0016$X*\u001e7uSBdWmS3zgR\u0011Qd\u000f\u0005\u0006Ca\u0002\rA\t\u0005\u0006{\u0001!\tAP\u0001\ri\u0016\u001cH/\u00113e\u0005\u0006\u001c\u0018n\u0019\u000b\u0003;}BQ!\t\u001fA\u0002\tBQ!\u0011\u0001\u0005\u0002\t\u000b\u0001\u0004^3ti\u0006#GmV5uQ\u0016C\b/\u001b:z'\u0016\u001cwN\u001c3t)\ti2\tC\u0003\"\u0001\u0002\u0007!\u0005C\u0003F\u0001\u0011\u0005a)A\ruKN$\u0018\t\u001a3XSRDW\t\u001f9jef,f.\u001b=US6,GCA\u000fH\u0011\u0015\tC\t1\u0001#\u0011\u0015I\u0005\u0001\"\u0001K\u0003M!Xm\u001d;O_R\fE\rZ%g!J,7/\u001a8u)\ti2\nC\u0003\"\u0011\u0002\u0007!\u0005C\u0003N\u0001\u0011\u0005a*\u0001\tuKN$(+\u001a9mC\u000e,')Y:jGR\u0011Qd\u0014\u0005\u0006C1\u0003\rA\t\u0005\u0006#\u0002!\tAU\u0001\u001bi\u0016\u001cHOT8u%\u0016\u0004H.Y2f\u0013\u001atu\u000e\u001e)sKN,g\u000e\u001e\u000b\u0003;MCQ!\t)A\u0002\tBQ!\u0016\u0001\u0005\u0002Y\u000bA\u0004^3tiJ+\u0007\u000f\\1dK^KG\u000f[#ya&\u0014\u0018pU3d_:$7\u000f\u0006\u0002\u001e/\")\u0011\u0005\u0016a\u0001E!)\u0011\f\u0001C\u00015\u0006iB/Z:u%\u0016\u0004H.Y2f/&$\b.\u0012=qSJLXK\\5y)&lW\r\u0006\u0002\u001e7\")\u0011\u0005\u0017a\u0001E!)Q\f\u0001C\u0001=\u0006yA/Z:u\u0003B\u0004XM\u001c3CCNL7\r\u0006\u0002\u001e?\")\u0011\u0005\u0018a\u0001E!)\u0011\r\u0001C\u0001E\u0006\u0011B/Z:u\u0003B\u0004XM\u001c3O_R4u.\u001e8e)\ti2\rC\u0003\"A\u0002\u0007!\u0005C\u0003f\u0001\u0011\u0005a-\u0001\tuKN$\bK]3qK:$')Y:jGR\u0011Qd\u001a\u0005\u0006C\u0011\u0004\rA\t\u0005\u0006S\u0002!\tA[\u0001\u0014i\u0016\u001cH\u000f\u0015:fa\u0016tGMT8u\r>,h\u000e\u001a\u000b\u0003;-DQ!\t5A\u0002\tBQ!\u001c\u0001\u0005\u00029\fQ\u0002^3ti\u001e+Go\u001d\"bg&\u001cGCA\u000fp\u0011\u0015\tC\u000e1\u0001#\u0011\u0015\t\b\u0001\"\u0001s\u00031!Xm\u001d;DCN\u0014\u0015m]5d)\ti2\u000fC\u0003\"a\u0002\u0007!\u0005C\u0003v\u0001\u0011\u0005a/A\buKN$8)Y:O_R4u.\u001e8e)\tir\u000fC\u0003\"i\u0002\u0007!\u0005C\u0003z\u0001\u0011\u0005!0A\u0007uKN$8)Y:Fq&\u001cHo\u001d\u000b\u0003;mDQ!\t=A\u0002\tBQ! \u0001\u0005\u0002y\fq\u0002^3ti\u0012+G.\u001a;f\u0005\u0006\u001c\u0018n\u0019\u000b\u0003;}DQ!\t?A\u0002\tBq!a\u0001\u0001\t\u0003\t)!\u0001\fuKN$H)\u001a7fi\u0016$u.Z:O_R,\u00050[:u)\ri\u0012q\u0001\u0005\u0007C\u0005\u0005\u0001\u0019\u0001\u0012\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u0005\u0011B/Z:u\u0013:\u001c'/Z7f]R\u0014\u0015m]5d)\ri\u0012q\u0002\u0005\u0007C\u0005%\u0001\u0019\u0001\u0012\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005\u0019B/Z:u\u0013:\u001c'/Z7f]R$&/\u001b9mKR\u0019Q$a\u0006\t\r\u0005\n\t\u00021\u0001#\u0011\u001d\tY\u0002\u0001C\u0001\u0003;\tQ\u0003^3ti&s7M]3nK:$hj\u001c;Fq&\u001cH\u000fF\u0002\u001e\u0003?Aa!IA\r\u0001\u0004\u0011\u0003bBA\u0012\u0001\u0011\u0005\u0011QE\u0001\u0018i\u0016\u001cH/\u00138de\u0016lWM\u001c;J]R,w-\u001a:NCb$2!HA\u0014\u0011\u0019\t\u0013\u0011\u0005a\u0001E!9\u00111\u0006\u0001\u0005\u0002\u00055\u0012!\b;fgRLen\u0019:f[\u0016tGOQ3z_:$\u0017J\u001c;fO\u0016\u0014X*\u0019=\u0015\u0007u\ty\u0003\u0003\u0004\"\u0003S\u0001\rA\t\u0005\b\u0003g\u0001A\u0011AA\u001b\u0003i!Xm\u001d;J]\u000e\u0014X-\\3oi\n+\u0017p\u001c8e\u0019>tw-T1y)\ri\u0012q\u0007\u0005\u0007C\u0005E\u0002\u0019\u0001\u0012\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\u0005YB/Z:u\u0013:\u001c'/Z7f]R\u001cVO\u001d9bgNduN\\4NCb$2!HA \u0011\u0019\t\u0013\u0011\ba\u0001E!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013!\b;fgRLen\u0019:f[\u0016tGoU;sa\u0006\u001c8OQ5h\u0013:$X*\u0019=\u0015\u0007u\t9\u0005\u0003\u0004\"\u0003\u0003\u0002\rA\t\u0005\b\u0003\u0017\u0002A\u0011BA'\u0003\u0011Ign\u0019:\u0015\u0011\u0005=\u0013QLA0\u0003S\u0002B!!\u0015\u0002X9\u0019\u0011#a\u0015\n\u0007\u0005U##\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\nYF\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003+\u0012\u0002BB\u0011\u0002J\u0001\u0007!\u0005\u0003\u0005\u0002b\u0005%\u0003\u0019AA2\u0003\t\u0011\u0017\u0010E\u0002\u0012\u0003KJ1!a\u001a\u0013\u0005\rIe\u000e\u001e\u0005\t\u0003W\nI\u00051\u0001\u0002d\u0005qQ\r\u001f9fGR,G\rT3oORD\u0007bBA8\u0001\u0011\u0005\u0011\u0011O\u0001\u0013i\u0016\u001cH\u000fR3de\u0016lWM\u001c;CCNL7\rF\u0002\u001e\u0003gBa!IA7\u0001\u0004\u0011\u0003bBA<\u0001\u0011\u0005\u0011\u0011P\u0001\u0014i\u0016\u001cH\u000fR3de\u0016lWM\u001c;Ue&\u0004H.\u001a\u000b\u0004;\u0005m\u0004BB\u0011\u0002v\u0001\u0007!\u0005C\u0004\u0002\u0000\u0001!\t!!!\u0002+Q,7\u000f\u001e#fGJ,W.\u001a8u\u001d>$X\t_5tiR\u0019Q$a!\t\r\u0005\ni\b1\u0001#\u0011\u001d\t9\t\u0001C\u0001\u0003\u0013\u000ba\u0003^3ti\u0012+7M]3nK:$()\u001a7poj+'o\u001c\u000b\u0004;\u0005-\u0005BB\u0011\u0002\u0006\u0002\u0007!\u0005C\u0004\u0002\u0010\u0002!\t!!%\u0002\u0019Q,7\u000f\u001e$mkND\u0017\t\u001c7\u0015\u0007u\t\u0019\n\u0003\u0004\"\u0003\u001b\u0003\rA\t\u0005\b\u0003/\u0003A\u0011AAM\u0003M!Xm\u001d;GYV\u001c\b.\u00117m\t\u0016d\u0017-_3e)\ri\u00121\u0014\u0005\u0007C\u0005U\u0005\u0019\u0001\u0012\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\u0006YA/Z:u-\u0016\u00148/[8o+\u0005i\u0002bBAS\u0001\u0011%\u0011qU\u0001\nC\u0012$\u0017I\u001c3HKR$2!HAU\u0011\u0019\t\u00131\u0015a\u0001E!Z\u0001!!,\u0002>\u0006}\u0016QYAd!\u0011\ty+!/\u000e\u0005\u0005E&\u0002BAZ\u0003k\u000b1\"\u00198o_R\fG/[8og*\u0019\u0011q\u0017\u0005\u0002\rQ,7\u000f\u001e8h\u0013\u0011\tY,!-\u0003\tQ+7\u000f^\u0001\u0007OJ|W\u000f]:-\u0005\u0005\u0005\u0017EAAb\u0003)1WO\\2uS>t\u0017\r\\\u0001\ti\u0016\u001cHOT1nK\u0006\u0012\u0011\u0011Z\u0001)g\u0016\u0014h/\u001a:/[\u0016l7-Y2iK\u0012tS*Z7dC\u000eDW\r\u001a$v]\u000e$\u0018n\u001c8bYR+7\u000f\u001e")
public class MemcachedFunctionalTest
extends MemcachedSingleNodeTest
implements ScalaObject {
    public void testSetBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    public void testSetWithExpirySeconds(Method m) {
        Future f = this.client().set(this.k(m), 1, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testSetWithExpiryUnixTime(Method m) {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().set(this.k(m), future, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testSetWithExpiryUnixTimeInPast(Method m) {
        Future f = this.client().set(this.k(m), 2592001, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testGetMultipleKeys(Method m) {
        Future f1 = this.client().set(this.k(m, "k1-"), 0, (Object)this.v(m, "v1-"));
        Future f2 = this.client().set(this.k(m, "k2-"), 0, (Object)this.v(m, "v2-"));
        Future f3 = this.client().set(this.k(m, "k3-"), 0, (Object)this.v(m, "v3-"));
        Assert.assertTrue((boolean)((Boolean)f1.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f2.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f3.get(this.timeout(), TimeUnit.SECONDS)));
        List keys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.k(m, "k1-"), this.k(m, "k2-"), this.k(m, "k3-")}));
        Map ret = this.client().getBulk((String[])keys.toArray(ClassManifest$.MODULE$.classType(String.class)));
        Assert.assertEquals(ret.get(this.k(m, "k1-")), (Object)this.v(m, "v1-"));
        Assert.assertEquals(ret.get(this.k(m, "k2-")), (Object)this.v(m, "v2-"));
        Assert.assertEquals(ret.get(this.k(m, "k3-")), (Object)this.v(m, "v3-"));
    }

    public void testAddBasic(Method m) {
        this.addAndGet(m);
    }

    public void testAddWithExpirySeconds(Method m) {
        Future f = this.client().add(this.k(m), 1, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
        f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testAddWithExpiryUnixTime(Method m) {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().add(this.k(m), future, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
        f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testNotAddIfPresent(Method m) {
        this.addAndGet(m);
        Future f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    public void testReplaceBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().replace(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testNotReplaceIfNotPresent(Method m) {
        Future f = this.client().replace(this.k(m), 0, (Object)this.v(m));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testReplaceWithExpirySeconds(Method m) {
        this.addAndGet(m);
        Future f = this.client().replace(this.k(m), 1, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testReplaceWithExpiryUnixTime(Method m) {
        this.addAndGet(m);
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().replace(this.k(m), future, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testAppendBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().append(0L, this.k(m), (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)this.v(m)).append((Object)this.v(m, "v1-")).toString();
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)expected);
    }

    public void testAppendNotFound(Method m) {
        this.addAndGet(m);
        Future f = this.client().append(0L, this.k(m, "k2-"), (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        Assert.assertNull((Object)this.client().get(this.k(m, "k2-")));
    }

    public void testPrependBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().prepend(0L, this.k(m), (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)this.v(m, "v1-")).append((Object)this.v(m)).toString();
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)expected);
    }

    public void testPrependNotFound(Method m) {
        this.addAndGet(m);
        Future f = this.client().prepend(0L, this.k(m, "k2-"), (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        Assert.assertNull((Object)this.client().get(this.k(m, "k2-")));
    }

    public void testGetsBasic(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
    }

    public void testCasBasic(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v1-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testCasNotFound(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client().cas(this.k(m, "k1-"), value.getCas(), (Object)this.v(m, "v1-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.NOT_FOUND);
    }

    public void testCasExists(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        long old = value.getCas();
        CASResponse resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v1-"));
        value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m, "v1-"));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((value.getCas() != old ? 1 : 0) != 0);
        resp = this.client().cas(this.k(m), old, (Object)this.v(m, "v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.EXISTS);
        resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testDeleteBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().delete(this.k(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testDeleteDoesNotExist(Method m) {
        Future f = this.client().delete(this.k(m));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
    }

    public void testIncrementBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long result = this.client().incr(this.k(m), 1);
        Assert.assertEquals((long)result, (long)2L);
    }

    public void testIncrementTriple(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().incr(this.k(m), 1), (long)2L);
        Assert.assertEquals((long)this.client().incr(this.k(m), 2), (long)4L);
        Assert.assertEquals((long)this.client().incr(this.k(m), 4), (long)8L);
    }

    public void testIncrementNotExist(Method m) {
        Assert.assertEquals((long)this.client().incr(this.k(m), 1), (long)-1L);
    }

    public void testIncrementIntegerMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().incr(this.k(m), Integer.MAX_VALUE), (long)Integer.MAX_VALUE);
    }

    public void testIncrementBeyondIntegerMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long newValue = this.client().incr(this.k(m), Integer.MAX_VALUE);
        Assert.assertEquals((long)newValue, (long)((long)Integer.MAX_VALUE + 1L));
    }

    public void testIncrementBeyondLongMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"9223372036854775808");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1, 19);
        Assert.assertEquals((Object)package$.MODULE$.BigInt().apply(newValue), (Object)package$.MODULE$.BigInt().apply("9223372036854775809"));
    }

    public void testIncrementSurpassLongMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"9223372036854775807");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1, 19);
        Assert.assertEquals((Object)package$.MODULE$.BigInt().apply(newValue), (Object)package$.MODULE$.BigInt().apply("9223372036854775808"));
    }

    public void testIncrementSurpassBigIntMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"18446744073709551615");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1, 1);
        Assert.assertEquals((String)newValue, (String)"0");
    }

    private String incr(Method m, int by, int expectedLength) {
        String req = new StringBuilder().append((Object)"incr ").append((Object)this.k(m)).append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)by)).append((Object)"\r\n").toString();
        Socket socket = new Socket(this.server().getHost(), this.server().getPort());
        Object exceptionResult1 = null;
        try {
            socket.getOutputStream().write(req.getBytes());
            byte[] resp = new byte[expectedLength];
            socket.getInputStream().read(resp);
            String string = new String(resp);
            socket.close();
            return string;
        }
        catch (Throwable throwable) {
            socket.close();
            throw throwable;
        }
    }

    public void testDecrementBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)0L);
    }

    public void testDecrementTriple(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"8");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)7L);
        Assert.assertEquals((long)this.client().decr(this.k(m), 2), (long)5L);
        Assert.assertEquals((long)this.client().decr(this.k(m), 4), (long)1L);
    }

    public void testDecrementNotExist(Method m) {
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)-1L);
    }

    public void testDecrementBelowZero(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long newValue = this.client().decr(this.k(m), 2);
        Assert.assertEquals((long)newValue, (long)0L);
    }

    public void testFlushAll(Method m$1) {
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$testFlushAll$1(this, m$1));
        Future f = this.client().flush();
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$testFlushAll$2(this, m$1));
    }

    public void testFlushAllDelayed(Method m$2) {
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$testFlushAllDelayed$1(this, m$2));
        Future f = this.client().flush(2);
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)2200L);
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$testFlushAllDelayed$2(this, m$2));
    }

    public void testVersion() {
        Map versions = this.client().getVersions();
        Assert.assertEquals((int)versions.size(), (int)1);
        String version = (String)versions.values().iterator().next();
        Assert.assertEquals((String)version, (String)"4.2.0.SNAPSHOT");
    }

    private void addAndGet(Method m) {
        Future f = this.client().add(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }
}

