/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASValue;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedSingleNodeTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.ScalaObject;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="server.memcached.MemcachedStatsTest")
@ScalaSignature(bytes="\u0006\u0001-4\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\ta\u0003\u0002\u0013\u001b\u0016l7-Y2iK\u0012\u001cF/\u0019;t)\u0016\u001cHO\u0003\u0002\u0004\t\u0005IQ.Z7dC\u000eDW\r\u001a\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\t\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!aF'f[\u000e\f7\r[3e'&tw\r\\3O_\u0012,G+Z:u!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000b]\u0001A\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005I\u0002CA\u0007\u0001\u0011\u001dY\u0002\u00011A\u0005\nq\t\u0011B[7y\t>l\u0017-\u001b8\u0016\u0003u\u0001\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\t1\fgn\u001a\u0006\u0002E\u0005!!.\u0019<b\u0013\t!sD\u0001\u0004TiJLgn\u001a\u0005\bM\u0001\u0001\r\u0011\"\u0003(\u00035QW\u000e\u001f#p[\u0006Lgn\u0018\u0013fcR\u0011\u0001f\u000b\t\u0003#%J!A\u000b\n\u0003\tUs\u0017\u000e\u001e\u0005\bY\u0015\n\t\u00111\u0001\u001e\u0003\rAH%\r\u0005\u0007]\u0001\u0001\u000b\u0015B\u000f\u0002\u0015)l\u0007\u0010R8nC&t\u0007\u0005C\u00031\u0001\u0011\u0005\u0013'\u0001\fde\u0016\fG/\u001a+fgR\u001c\u0015m\u00195f\u001b\u0006t\u0017mZ3s+\u0005\u0011\u0004CA\u001a7\u001b\u0005!$BA\u001b\u0007\u0003\u001di\u0017M\\1hKJL!a\u000e\u001b\u0003)\u0015k'-\u001a3eK\u0012\u001c\u0015m\u00195f\u001b\u0006t\u0017mZ3s\u0011\u0015I\u0004\u0001\"\u0001;\u0003Q!Xm\u001d;V]N,\b\u000f]8si\u0016$7\u000b^1ugR\u0011\u0001f\u000f\u0005\u0006ya\u0002\r!P\u0001\u0002[B\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iH\u0001\be\u00164G.Z2u\u0013\t\u0011uH\u0001\u0004NKRDw\u000e\u001a\u0005\u0006\t\u0002!\t!R\u0001\u0016i\u0016\u001cH/\u00168d_6\u0004\u0018M]1cY\u0016\u001cF/\u0019;t)\tAc\tC\u0003=\u0007\u0002\u0007Q\bC\u0003I\u0001\u0011\u0005\u0011*A\buKN$8\u000b^1uS\u000e\u001cF/\u0019;t)\tA#\nC\u0003=\u000f\u0002\u0007Q\bC\u0003M\u0001\u0011\u0005Q*A\u0007uKN$Hk\u001c3p'R\fGo]\u000b\u0002Q!)q\n\u0001C\u0001!\u0006IA/Z:u'R\fGo\u001d\u000b\u0003QECQ\u0001\u0010(A\u0002uBQa\u0015\u0001\u0005\nQ\u000b\u0001bZ3u'R\fGo\u001d\u000b\u0002+B!a+W\u000f\u001e\u001b\u00059&B\u0001-\"\u0003\u0011)H/\u001b7\n\u0005i;&aA'ba\"2\u0001\u0001\u00183fQ&\u0004\"!\u00182\u000e\u0003yS!a\u00181\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0003C\"\ta\u0001^3ti:<\u0017BA2_\u0005\u0011!Vm\u001d;\u0002\r\u001d\u0014x.\u001e9tY\u00051\u0017%A4\u0002\u0015\u0019,hn\u0019;j_:\fG.\u0001\u0005uKN$h*Y7fC\u0005Q\u0017aI:feZ,'OL7f[\u000e\f7\r[3e]5+WnY1dQ\u0016$7\u000b^1ugR+7\u000f\u001e")
public class MemcachedStatsTest
extends MemcachedSingleNodeTest
implements ScalaObject {
    private String jmxDomain = MemcachedStatsTest.class.getSimpleName();

    private String jmxDomain() {
        return this.jmxDomain;
    }

    private void jmxDomain_$eq(String string) {
        this.jmxDomain = string;
    }

    @Override
    public EmbeddedCacheManager createTestCacheManager() {
        return TestCacheManagerFactory.createCacheManagerEnforceJmxDomain((String)this.jmxDomain());
    }

    public void testUnsupportedStats(Method m) {
        Map<String, String> stats = this.getStats();
        Assert.assertEquals((String)stats.get("pid"), (String)"0");
        Assert.assertEquals((String)stats.get("pointer_size"), (String)"0");
        Assert.assertEquals((String)stats.get("rusage_user"), (String)"0");
        Assert.assertEquals((String)stats.get("rusage_system"), (String)"0");
        Assert.assertEquals((String)stats.get("bytes"), (String)"0");
        Assert.assertEquals((String)stats.get("connection_structures"), (String)"0");
        Assert.assertEquals((String)stats.get("auth_cmds"), (String)"0");
        Assert.assertEquals((String)stats.get("auth_errors"), (String)"0");
        Assert.assertEquals((String)stats.get("limit_maxbytes"), (String)"0");
        Assert.assertEquals((String)stats.get("conn_yields"), (String)"0");
    }

    public void testUncomparableStats(Method m) {
        TestingUtil.sleepThread((long)TimeUnit.SECONDS.toMillis(1L));
        Map<String, String> stats = this.getStats();
        Assert.assertNotSame((Object)stats.get("uptime"), (Object)"0");
        Assert.assertNotSame((Object)stats.get("time"), (Object)"0");
        Assert.assertNotSame((Object)stats.get("uptime"), (Object)stats.get("time"));
    }

    public void testStaticStats(Method m) {
        Map<String, String> stats = this.getStats();
        Assert.assertEquals((String)stats.get("version"), (String)"4.2.0.SNAPSHOT");
    }

    public void testTodoStats() {
        Map<String, String> stats = this.getStats();
        Assert.assertEquals((String)stats.get("curr_connections"), (String)"0");
        Assert.assertEquals((String)stats.get("total_connections"), (String)"0");
        Assert.assertEquals((String)stats.get("bytes_read"), (String)"0");
        Assert.assertEquals((String)stats.get("bytes_written"), (String)"0");
        Assert.assertEquals((String)stats.get("threads"), (String)"0");
    }

    public void testStats(Method m) {
        Map<String, String> stats = this.getStats();
        Assert.assertEquals((String)stats.get("cmd_set"), (String)"0");
        Assert.assertEquals((String)stats.get("cmd_get"), (String)"0");
        Assert.assertEquals((String)stats.get("get_hits"), (String)"0");
        Assert.assertEquals((String)stats.get("get_misses"), (String)"0");
        Assert.assertEquals((String)stats.get("delete_hits"), (String)"0");
        Assert.assertEquals((String)stats.get("delete_misses"), (String)"0");
        Assert.assertEquals((String)stats.get("curr_items"), (String)"0");
        Assert.assertEquals((String)stats.get("total_items"), (String)"0");
        Assert.assertEquals((String)stats.get("incr_misses"), (String)"0");
        Assert.assertEquals((String)stats.get("incr_hits"), (String)"0");
        Assert.assertEquals((String)stats.get("decr_misses"), (String)"0");
        Assert.assertEquals((String)stats.get("decr_hits"), (String)"0");
        Assert.assertEquals((String)stats.get("cas_misses"), (String)"0");
        Assert.assertEquals((String)stats.get("cas_hits"), (String)"0");
        Assert.assertEquals((String)stats.get("cas_badval"), (String)"0");
        Future f = this.client().set(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        f = this.client().set(this.k(m, "k1-"), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m, "k1-")), (Object)this.v(m, "v1-"));
        stats = this.getStats();
        Assert.assertEquals((String)stats.get("cmd_set"), (String)"2");
        Assert.assertEquals((String)stats.get("cmd_get"), (String)"2");
        Assert.assertEquals((String)stats.get("get_hits"), (String)"2");
        Assert.assertEquals((String)stats.get("get_misses"), (String)"0");
        Assert.assertEquals((String)stats.get("delete_hits"), (String)"0");
        Assert.assertEquals((String)stats.get("delete_misses"), (String)"0");
        Assert.assertEquals((String)stats.get("curr_items"), (String)"2");
        Assert.assertEquals((String)stats.get("total_items"), (String)"2");
        f = this.client().delete(this.k(m, "k1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        stats = this.getStats();
        Assert.assertEquals((String)stats.get("curr_items"), (String)"1");
        Assert.assertEquals((String)stats.get("total_items"), (String)"2");
        Assert.assertEquals((String)stats.get("delete_hits"), (String)"1");
        Assert.assertEquals((String)stats.get("delete_misses"), (String)"0");
        Assert.assertNull((Object)this.client().get(this.k(m, "k99-")));
        stats = this.getStats();
        Assert.assertEquals((String)stats.get("get_hits"), (String)"2");
        Assert.assertEquals((String)stats.get("get_misses"), (String)"1");
        f = this.client().delete(this.k(m, "k99-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        stats = this.getStats();
        Assert.assertEquals((String)stats.get("delete_hits"), (String)"1");
        Assert.assertEquals((String)stats.get("delete_misses"), (String)"1");
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        f = this.client().set(this.k(m, "k3-"), future, (Object)this.v(m, "v3-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m, "k3-")));
        stats = this.getStats();
        Assert.assertEquals((String)stats.get("curr_items"), (String)"1");
        Assert.assertEquals((String)stats.get("total_items"), (String)"3");
        this.client().incr(this.k(m, "k4-"), 1);
        stats = this.getStats();
        Assert.assertEquals((String)stats.get("incr_misses"), (String)"1");
        Assert.assertEquals((String)stats.get("incr_hits"), (String)"0");
        f = this.client().set(this.k(m, "k4-"), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.client().incr(this.k(m, "k4-"), 1);
        this.client().incr(this.k(m, "k4-"), 2);
        this.client().incr(this.k(m, "k4-"), 4);
        stats = this.getStats();
        Assert.assertEquals((String)stats.get("incr_misses"), (String)"1");
        Assert.assertEquals((String)stats.get("incr_hits"), (String)"3");
        this.client().decr(this.k(m, "k5-"), 1);
        stats = this.getStats();
        Assert.assertEquals((String)stats.get("decr_misses"), (String)"1");
        Assert.assertEquals((String)stats.get("decr_hits"), (String)"0");
        f = this.client().set(this.k(m, "k5-"), 0, (Object)"8");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.client().decr(this.k(m, "k5-"), 1);
        this.client().decr(this.k(m, "k5-"), 2);
        this.client().decr(this.k(m, "k5-"), 4);
        stats = this.getStats();
        Assert.assertEquals((String)stats.get("decr_misses"), (String)"1");
        Assert.assertEquals((String)stats.get("decr_hits"), (String)"3");
        this.client().cas(this.k(m, "k6-"), 1234L, (Object)this.v(m, "v6-"));
        stats = this.getStats();
        Assert.assertEquals((String)stats.get("cas_misses"), (String)"1");
        Assert.assertEquals((String)stats.get("cas_hits"), (String)"0");
        Assert.assertEquals((String)stats.get("cas_badval"), (String)"0");
        f = this.client().set(this.k(m, "k6-"), 0, (Object)this.v(m, "v6-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        CASValue value = this.client().gets(this.k(m, "k6-"));
        long old = value.getCas();
        this.client().cas(this.k(m, "k6-"), value.getCas(), (Object)this.v(m, "v66-"));
        stats = this.getStats();
        Assert.assertEquals((String)stats.get("cas_misses"), (String)"1");
        Assert.assertEquals((String)stats.get("cas_hits"), (String)"1");
        Assert.assertEquals((String)stats.get("cas_badval"), (String)"0");
        this.client().cas(this.k(m, "k6-"), old, (Object)this.v(m, "v66-"));
        stats = this.getStats();
        Assert.assertEquals((String)stats.get("cas_misses"), (String)"1");
        Assert.assertEquals((String)stats.get("cas_hits"), (String)"1");
        Assert.assertEquals((String)stats.get("cas_badval"), (String)"1");
    }

    private Map<String, String> getStats() {
        Map stats = this.client().getStats();
        Assert.assertEquals((int)stats.size(), (int)1);
        return (Map)stats.values().iterator().next();
    }
}

