/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ChannelBuffer;
import org.infinispan.server.core.transport.ChannelBuffers$;
import org.infinispan.server.core.transport.ChannelHandlerContext;
import org.infinispan.server.memcached.DelayedFlushAll;
import org.infinispan.server.memcached.MemcachedDecoder$;
import org.infinispan.server.memcached.MemcachedException;
import org.infinispan.server.memcached.MemcachedHeader;
import org.infinispan.server.memcached.MemcachedOperation$;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.MemcachedValue;
import org.infinispan.server.memcached.RequestResolver$;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.TextProtocolUtil$class;
import org.infinispan.stats.Stats;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\r]b\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003!5+WnY1dQ\u0016$G)Z2pI\u0016\u0014(BA\u0002\u0005\u0003%iW-\\2bG\",GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0002I\u0012\u0011\t5\u0001\"\u0003H\u0007\u0002\u001d)\u0011q\u0002B\u0001\u0005G>\u0014X-\u0003\u0002\u0012\u001d\t9\u0012IY:ue\u0006\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c#fG>$WM\u001d\t\u0003'eq!\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\ta\u0001\u0015:fI\u00164\u0017B\u0001\u000e\u001c\u0005\u0019\u0019FO]5oO*\u0011\u0001$\u0006\t\u0003;yi\u0011AA\u0005\u0003?\t\u0011a\"T3nG\u0006\u001c\u0007.\u001a3WC2,X\r\u0005\u0002\u001eC%\u0011!E\u0001\u0002\u0011)\u0016DH\u000f\u0015:pi>\u001cw\u000e\\+uS2\u0004\"\u0001\u0006\u0013\n\u0005\u0015*\"aC*dC2\fwJ\u00196fGRD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0006G\u0006\u001c\u0007.\u001a\t\u0005S)\u0012B$D\u0001\u0007\u0013\tYcAA\u0003DC\u000eDW\r\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003%\u00198\r[3ek2,'\u000f\u0005\u00020m5\t\u0001G\u0003\u00022e\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005M\"\u0014\u0001B;uS2T\u0011!N\u0001\u0005U\u00064\u0018-\u0003\u00028a\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u000be\u0002A\u0011\u0001\u001e\u0002\rqJg.\u001b;?)\rYD(\u0010\t\u0003;\u0001AQa\n\u001dA\u0002!BQ!\f\u001dA\u00029*\u0001b\u0010\u0001\u0005\u0002\u0003\u0005\t\u0001\u0011\u0002\u0013'VLG/\u00192mKB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0002\u001e\u0003&\u0011!I\u0001\u0002\u0014\u001b\u0016l7-Y2iK\u0012\u0004\u0016M]1nKR,'o]\u0003\t\t\u0002!\t\u0011!A\u0001\u000b\nq1+^5uC\ndW\rS3bI\u0016\u0014\bCA\u000fG\u0013\t9%AA\bNK6\u001c\u0017m\u00195fI\"+\u0017\rZ3s\u0011!I\u0005\u0001#b\u0001\n\u0013Q\u0015AD5t'R\fGo]#oC\ndW\rZ\u000b\u0002\u0017B\u0011A\u0003T\u0005\u0003\u001bV\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005P\u0001!\u0005\t\u0015)\u0003L\u0003=I7o\u0015;biN,e.\u00192mK\u0012\u0004\u0003bB)\u0001\u0005\u0004%iAU\u0001\u000bS:\u001c'/T5tg\u0016\u001cX#A*\u0011\u0005Q;V\"A+\u000b\u0005Y\u0003\u0014AB1u_6L7-\u0003\u0002Y+\nQ\u0011\t^8nS\u000eduN\\4\t\ri\u0003\u0001\u0015!\u0004T\u0003-Ign\u0019:NSN\u001cXm\u001d\u0011\t\u000fq\u0003!\u0019!C\u0007%\u0006A\u0011N\\2s\u0011&$8\u000f\u0003\u0004_\u0001\u0001\u0006iaU\u0001\nS:\u001c'\u000fS5ug\u0002Bq\u0001\u0019\u0001C\u0002\u00135!+\u0001\u0006eK\u000e\u0014X*[:tKNDaA\u0019\u0001!\u0002\u001b\u0019\u0016a\u00033fGJl\u0015n]:fg\u0002Bq\u0001\u001a\u0001C\u0002\u00135!+\u0001\u0005eK\u000e\u0014\b*\u001b;t\u0011\u00191\u0007\u0001)A\u0007'\u0006IA-Z2s\u0011&$8\u000f\t\u0005\bQ\u0002\u0011\r\u0011\"\u0004S\u0003e\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u001b&\u001c8/Z:\t\r)\u0004\u0001\u0015!\u0004T\u0003i\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u001b&\u001c8/Z:!\u0011\u001da\u0007A1A\u0005\u000eI\u000bqC]3qY\u0006\u001cW-\u00134V]6|G-\u001b4jK\u0012D\u0015\u000e^:\t\r9\u0004\u0001\u0015!\u0004T\u0003a\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0011&$8\u000f\t\u0005\ba\u0002\u0011\r\u0011\"\u0004S\u0003e\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0005\u0006$g/\u00197\t\rI\u0004\u0001\u0015!\u0004T\u0003i\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0005\u0006$g/\u00197!\u0011\u0015!\b\u0001\"\u0011v\u0003)\u0011X-\u00193IK\u0006$WM\u001d\u000b\u0003mf\u00042\u0001F<F\u0013\tAXC\u0001\u0004PaRLwN\u001c\u0005\u0006uN\u0004\ra_\u0001\u0007EV4g-\u001a:\u0011\u0005q|X\"A?\u000b\u0005yt\u0011!\u0003;sC:\u001c\bo\u001c:u\u0013\r\t\t! \u0002\u000e\u0007\"\fgN\\3m\u0005V4g-\u001a:\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\b\u00059!/Z1e\u0017\u0016LHCBA\u0005\u0003\u001f\t\u0019\u0002E\u0003\u0015\u0003\u0017\u00112*C\u0002\u0002\u000eU\u0011a\u0001V;qY\u0016\u0014\u0004bBA\t\u0003\u0007\u0001\r!R\u0001\u0002Q\"9\u0011QCA\u0002\u0001\u0004Y\u0018!\u00012\t\u000f\u0005e\u0001\u0001\"\u0003\u0002\u001c\u0005A!/Z1e\u0017\u0016L8\u000f\u0006\u0003\u0002\u001e\u0005\r\u0002\u0003\u0002\u000b\u0002 II1!!\t\u0016\u0005\u0015\t%O]1z\u0011\u001d\t)\"a\u0006A\u0002mDq!a\n\u0001\t#\nI#A\u0002hKR$\u0002\"a\u000b\u00022\u0005M\u0012Q\u0007\t\u0004)\u00055\u0012bAA\u0018+\t1\u0011I\\=SK\u001aDq!!\u0005\u0002&\u0001\u0007Q\t\u0003\u0004{\u0003K\u0001\ra\u001f\u0005\u0007O\u0005\u0015\u0002\u0019\u0001\u0015\t\u000f\u0005e\u0002\u0001\"\u0003\u0002<\u0005q1\r[3dW.+\u0017\u0010T3oORDG#\u0003\n\u0002>\u0005}\u00121IA$\u0011\u001d\t\t\"a\u000eA\u0002\u0015Cq!!\u0011\u00028\u0001\u0007!#A\u0001l\u0011\u001d\t)%a\u000eA\u0002-\u000bq!\u001a8e\u001f\u001a|\u0005\u000fC\u0004\u0002\u0016\u0005]\u0002\u0019A>\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N\u0005q!/Z1e!\u0006\u0014\u0018-\\3uKJ\u001cHCBA(\u0003#\n\u0019\u0006E\u0002\u0015o\u0002Cq!!\u0005\u0002J\u0001\u0007Q\tC\u0004\u0002\u0016\u0005%\u0003\u0019A>\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z\u0005!\"/Z1e%\u0016lwN^3QCJ\fW.\u001a;feN$b!a\u0014\u0002\\\u0005\u0015\u0004\u0002CA/\u0003+\u0002\r!a\u0018\u0002\u000b%tG-\u001a=\u0011\u0007Q\t\t'C\u0002\u0002dU\u00111!\u00138u\u0011!\t9'!\u0016A\u0002\u0005u\u0011\u0001B1sONDq!a\u001b\u0001\t\u0013\ti'\u0001\fsK\u0006$\u0017J\\2s\t\u0016\u001c'\u000fU1sC6,G/\u001a:t)\u0019\ty%a\u001c\u0002t!A\u0011\u0011OA5\u0001\u0004\ty&A\u0005j]&$\u0018J\u001c3fq\"A\u0011qMA5\u0001\u0004\ti\u0002C\u0004\u0002x\u0001!I!!\u001f\u0002-I,\u0017\r\u001a$mkND\u0017\t\u001c7QCJ\fW.\u001a;feN$b!a\u0014\u0002|\u0005u\u0004\u0002CA9\u0003k\u0002\r!a\u0018\t\u0011\u0005\u001d\u0014Q\u000fa\u0001\u0003;Aq!!!\u0001\t\u0013\t\u0019)A\u000bsK\u0006$7\u000b^8sC\u001e,\u0007+\u0019:b[\u0016$XM]:\u0015\u0015\u0005=\u0013QQAD\u0003\u0013\u000bY\t\u0003\u0005\u0002r\u0005}\u0004\u0019AA0\u0011!\t9'a A\u0002\u0005u\u0001bBA\t\u0003\u007f\u0002\r!\u0012\u0005\b\u0003+\ty\b1\u0001|\u0011\u001d\ty\t\u0001C!\u0003#\u000b1b\u0019:fCR,g+\u00197vKR9A$a%\u0002\u001a\u0006u\u0005\u0002CA\t\u0003\u001b\u0003\r!!&\u0011\u0007\u0005]5)D\u0001\u0001\u0011\u001d\tY*!$A\u0002\u0001\u000b\u0011\u0001\u001d\u0005\t\u0003?\u000bi\t1\u0001\u0002\"\u0006Ya.\u001a=u-\u0016\u00148/[8o!\r!\u00121U\u0005\u0004\u0003K+\"\u0001\u0002'p]\u001eDq!!+\u0001\t\u0013\tY+\u0001\u0005hKR4E.Y4t)\u0011\t\t+!,\t\u000f\u0005=\u0016q\u0015a\u0001%\u0005)a\r\\1hg\"9\u00111\u0017\u0001\u0005\n\u0005U\u0016aC4fi2Kg-Z:qC:$B!a\u0018\u00028\"9\u0011\u0011XAY\u0001\u0004\u0011\u0012\u0001\u00037jM\u0016\u001c\b/\u00198\t\u000f\u0005u\u0006\u0001\"\u0003\u0002@\u0006Iq-\u001a;MK:<G\u000f\u001b\u000b\u0005\u0003?\n\t\rC\u0004\u0002D\u0006m\u0006\u0019\u0001\n\u0002\r1,gn\u001a;i\u0011\u001d\t9\r\u0001C\u0005\u0003\u0013\f!bZ3u-\u0016\u00148/[8o)\u0011\t\t+a3\t\u000f\u00055\u0017Q\u0019a\u0001%\u00059a/\u001a:tS>t\u0007bBAi\u0001\u0011%\u00111[\u0001\ra\u0006\u00148/\u001a(p%\u0016\u0004H.\u001f\u000b\u0006\u0017\u0006U\u0017\u0011\u001c\u0005\t\u0003/\fy\r1\u0001\u0002`\u0005iQ\r\u001f9fGR,G-\u00138eKbD\u0001\"a\u001a\u0002P\u0002\u0007\u0011Q\u0004\u0005\b\u0003;\u0004A\u0011BAp\u0003Y\u0001\u0018M]:f\t\u0016d\u0017-_3e\t\u0016dW\r^3US6,GCBA0\u0003C\f\u0019\u000f\u0003\u0005\u0002X\u0006m\u0007\u0019AA0\u0011!\t9'a7A\u0002\u0005u\u0001bBAt\u0001\u0011\u0005\u0013\u0011^\u0001\tO\u0016$8)Y2iKR\u0019\u0001&a;\t\u000f\u0005E\u0011Q\u001da\u0001\u000b\"9\u0011q\u001e\u0001\u0005B\u0005E\u0018a\u00055b]\u0012dWmQ;ti>l'+Z9vKN$HCCA\u0016\u0003g\f)0a>\u0002z\"9\u0011\u0011CAw\u0001\u0004)\u0005bBA\u000b\u0003[\u0004\ra\u001f\u0005\u0007O\u00055\b\u0019\u0001\u0015\t\u0011\u0005m\u0018Q\u001ea\u0001\u0003{\f1a\u0019;y!\ra\u0018q`\u0005\u0004\u0005\u0003i(!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\b\u0005\u000b\u0001A\u0011\u0002B\u0004\u000351\u0018\r\\5eCR,G)\u001a7uCR!!\u0011\u0002B\u0011!\u0011\u0011YAa\u0007\u000f\t\t5!q\u0003\b\u0005\u0005\u001f\u0011)\"\u0004\u0002\u0003\u0012)\u0019!1\u0003\u0006\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0012b\u0001B\r+\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u000f\u0005?\u0011aAQ5h\u0013:$(b\u0001B\r+!9!1\u0005B\u0002\u0001\u0004\u0011\u0012!\u00023fYR\f\u0007b\u0002B\u0014\u0001\u0011\u0005#\u0011F\u0001\u0016GJ,\u0017\r^3Tk\u000e\u001cWm]:SKN\u0004xN\\:f)!\tYCa\u000b\u0003.\tE\u0002bBA\t\u0005K\u0001\r!\u0012\u0005\t\u0005_\u0011)\u00031\u0001\u0002P\u00051\u0001/\u0019:b[NDqAa\r\u0003&\u0001\u0007A$\u0001\u0003qe\u00164\bb\u0002B\u001c\u0001\u0011\u0005#\u0011H\u0001\u001aGJ,\u0017\r^3O_R,\u00050Z2vi\u0016$'+Z:q_:\u001cX\r\u0006\u0005\u0002,\tm\"Q\bB \u0011\u001d\t\tB!\u000eA\u0002\u0015C\u0001Ba\f\u00036\u0001\u0007\u0011q\n\u0005\b\u0005g\u0011)\u00041\u0001\u001d\u0011\u001d\u0011\u0019\u0005\u0001C!\u0005\u000b\nac\u0019:fCR,gj\u001c;Fq&\u001cHOU3ta>t7/\u001a\u000b\u0007\u0003W\u00119E!\u0013\t\u0011\u0005E!\u0011\ta\u0001\u0003+C\u0001Ba\f\u0003B\u0001\u0007\u0011q\n\u0005\b\u0005\u001b\u0002A\u0011\tB(\u0003E\u0019'/Z1uK\u001e+GOU3ta>t7/\u001a\u000b\t\u0003W\u0011\tFa\u0015\u0003V!9\u0011\u0011\u0003B&\u0001\u0004)\u0005bBA!\u0005\u0017\u0002\rA\u0005\u0005\b\u0005/\u0012Y\u00051\u0001\u001d\u0003\u00051\bb\u0002B.\u0001\u0011\u0005#QL\u0001\u0017GJ,\u0017\r^3Nk2$\u0018nR3u%\u0016\u001c\bo\u001c8tKR1\u00111\u0006B0\u0005CBq!!\u0005\u0003Z\u0001\u0007Q\t\u0003\u0005\u0003d\te\u0003\u0019\u0001B3\u0003\u0015\u0001\u0018-\u001b:t!\u0015\u0019\"q\r\n\u001d\u0013\r\u0011Ig\u0007\u0002\u0004\u001b\u0006\u0004\bb\u0002B7\u0001\u0011\u0005#qN\u0001\u0014GJ,\u0017\r^3FeJ|'OU3ta>t7/\u001a\u000b\u0005\u0003W\u0011\t\b\u0003\u0005\u0003t\t-\u0004\u0019\u0001B;\u0003\u0005!\b\u0003\u0002B\u0006\u0005oJAA!\u001f\u0003 \tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\b\u0005{\u0002A\u0011\u000bB@\u0003U\u0019'/Z1uKN+'O^3s\u000bb\u001cW\r\u001d;j_:$\u0002B!!\u0003\n\nM%Q\u0013\t\u0007)\u0005-!1Q&\u0011\u0007u\u0011))C\u0002\u0003\b\n\u0011!#T3nG\u0006\u001c\u0007.\u001a3Fq\u000e,\u0007\u000f^5p]\"A!1\u0012B>\u0001\u0004\u0011i)A\u0001f!\u0011\u0011YAa$\n\t\tE%q\u0004\u0002\n\u000bb\u001cW\r\u001d;j_:Dq!!\u0005\u0003|\u0001\u0007a\u000fC\u0004\u0002\u0016\tm\u0004\u0019A>\t\u000f\te\u0005\u0001\"\u0001\u0003\u001c\u0006\u00192M]3bi\u0016\u001cF/\u0019;t%\u0016\u001c\bo\u001c8tKR1\u00111\u0006BO\u0005CCqAa(\u0003\u0018\u0002\u0007Q)\u0001\u0004iK\u0006$WM\u001d\u0005\t\u0005G\u00139\n1\u0001\u0003&\u0006)1\u000f^1ugB!!q\u0015BV\u001b\t\u0011IKC\u0002\u0003$\u001aIAA!,\u0003*\n)1\u000b^1ug\"9!\u0011\u0017\u0001\u0005\n\tM\u0016!\u00032vS2$7\u000b^1u)\u001dY(Q\u0017B]\u0005\u0007DqAa.\u00030\u0002\u0007!#\u0001\u0003ti\u0006$\b\u0002\u0003B^\u0005_\u0003\rA!0\u0002\u000bY\fG.^3\u0011\u0007Q\u0011y,C\u0002\u0003BV\u00111!\u00118z\u0011!\u0011)Ma,A\u0002\t\u001d\u0017AA:c!\u0011\u0011YA!3\n\t\t-'q\u0004\u0002\u000e'R\u0014\u0018N\\4Ck&dG-\u001a:\t\u000f\u0005=\u0005\u0001\"\u0003\u0003PR9AD!5\u0003^\n}\u0007\u0002\u0003Bj\u0005\u001b\u0004\rA!6\u0002\t\u0011\fG/\u0019\t\u0006)\u0005}!q\u001b\t\u0004)\te\u0017b\u0001Bn+\t!!)\u001f;f\u0011!\tyJ!4A\u0002\u0005\u0005\u0006\u0002CAX\u0005\u001b\u0004\r!!)\t\u000f\t\r\b\u0001\"\u0003\u0003f\u0006\u0001\"-^5mI\u001e+GOU3ta>t7/\u001a\u000b\bw\n\u001d(q\u001fB}\u0011!\u0011IO!9A\u0002\t-\u0018AA8q!\u0011\u0011iOa=\u0011\u0007Q\u0011y/C\u0002\u0003rV\u00111\"\u00128v[\u0016\u0014\u0018\r^5p]&!!Q\u001fBx\u0005\u00151\u0016\r\\;f\u0011\u001d\t\tE!9A\u0002IAqAa\u0016\u0003b\u0002\u0007A\u0004C\u0004\u0003~\u0002!IAa@\u0002-\t,\u0018\u000e\u001c3HKR\u0014Vm\u001d9p]N,\u0007*Z1eKJ$rAEB\u0001\u0007\u0007\u0019)\u0001C\u0004\u0002B\tm\b\u0019\u0001\n\t\u000f\t]#1 a\u00019!A!\u0011\u001eB~\u0001\u0004\u0011Y\u000fC\u0004\u0004\n\u0001!Iaa\u0003\u0002'\u0019\u0014\u0018.\u001a8eYfl\u0015\r_%oi\u000eCWmY6\u0015\r\u0005}3QBB\t\u0011\u001d\u0019yaa\u0002A\u0002I\taA\\;nE\u0016\u0014\bbBB\n\u0007\u000f\u0001\rAE\u0001\b[\u0016\u001c8/Y4f\u0011\u001d\u00199\u0002\u0001C\u0005\u00073\t\u0011C\\;nKJL7\rT5nSR\u001c\u0005.Z2l))\tyfa\u0007\u0004\u001e\r\u000521\u0005\u0005\b\u0007\u001f\u0019)\u00021\u0001\u0013\u0011!\u0019yb!\u0006A\u0002\u0005\u0005\u0016\u0001C7bqZ\u000bG.^3\t\u000f\rM1Q\u0003a\u0001%!A1QEB\u000b\u0001\u0004\u00199#A\u0001o!\u0011\u0011Ya!\u000b\n\t\r-\"q\u0004\u0002\u0016\u001dVl'-\u001a:G_Jl\u0017\r^#yG\u0016\u0004H/[8o\u0011\u001d\u00199\u0002\u0001C\u0005\u0007_!\u0002\"!)\u00042\rM2Q\u0007\u0005\b\u0007\u001f\u0019i\u00031\u0001\u0013\u0011!\u0019yb!\fA\u0002\u0005\u0005\u0006bBB\n\u0007[\u0001\rA\u0005")
public class MemcachedDecoder
extends AbstractProtocolDecoder<String, MemcachedValue>
implements TextProtocolUtil,
ScalaObject {
    private final Cache<String, MemcachedValue> cache;
    private final ScheduledExecutorService scheduler;
    private boolean isStatsEnabled;
    private final AtomicLong incrMisses;
    private final AtomicLong incrHits;
    private final AtomicLong decrMisses;
    private final AtomicLong decrHits;
    private final AtomicLong replaceIfUnmodifiedMisses;
    private final AtomicLong replaceIfUnmodifiedHits;
    private final AtomicLong replaceIfUnmodifiedBadval;
    private final String CRLF;
    private final byte[] CRLFBytes;
    private final byte[] END;
    private final byte[] DELETED;
    private final byte[] NOT_FOUND;
    private final byte[] EXISTS;
    private final byte[] STORED;
    private final byte[] NOT_STORED;
    private final byte[] OK;
    private final byte[] ERROR;
    private final String CLIENT_ERROR_BAD_FORMAT;
    private final String SERVER_ERROR;
    private final int CR;
    private final int LF;
    private final BigInt MAX_UNSIGNED_LONG;
    private final BigInt MIN_UNSIGNED;
    public volatile int bitmap$0;

    @Override
    public String CRLF() {
        return this.CRLF;
    }

    @Override
    public byte[] CRLFBytes() {
        return this.CRLFBytes;
    }

    @Override
    public byte[] END() {
        return this.END;
    }

    @Override
    public byte[] DELETED() {
        return this.DELETED;
    }

    @Override
    public byte[] NOT_FOUND() {
        return this.NOT_FOUND;
    }

    @Override
    public byte[] EXISTS() {
        return this.EXISTS;
    }

    @Override
    public byte[] STORED() {
        return this.STORED;
    }

    @Override
    public byte[] NOT_STORED() {
        return this.NOT_STORED;
    }

    @Override
    public byte[] OK() {
        return this.OK;
    }

    @Override
    public byte[] ERROR() {
        return this.ERROR;
    }

    @Override
    public String CLIENT_ERROR_BAD_FORMAT() {
        return this.CLIENT_ERROR_BAD_FORMAT;
    }

    @Override
    public String SERVER_ERROR() {
        return this.SERVER_ERROR;
    }

    @Override
    public int CR() {
        return this.CR;
    }

    @Override
    public int LF() {
        return this.LF;
    }

    @Override
    public BigInt MAX_UNSIGNED_LONG() {
        return this.MAX_UNSIGNED_LONG;
    }

    @Override
    public BigInt MIN_UNSIGNED() {
        return this.MIN_UNSIGNED;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CRLF_$eq(String string) {
        this.CRLF = string;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CRLFBytes_$eq(byte[] byArray) {
        this.CRLFBytes = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$END_$eq(byte[] byArray) {
        this.END = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$DELETED_$eq(byte[] byArray) {
        this.DELETED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$NOT_FOUND_$eq(byte[] byArray) {
        this.NOT_FOUND = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$EXISTS_$eq(byte[] byArray) {
        this.EXISTS = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$STORED_$eq(byte[] byArray) {
        this.STORED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$NOT_STORED_$eq(byte[] byArray) {
        this.NOT_STORED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$OK_$eq(byte[] byArray) {
        this.OK = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$ERROR_$eq(byte[] byArray) {
        this.ERROR = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CLIENT_ERROR_BAD_FORMAT_$eq(String string) {
        this.CLIENT_ERROR_BAD_FORMAT = string;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$SERVER_ERROR_$eq(String string) {
        this.SERVER_ERROR = string;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CR_$eq(int n) {
        this.CR = n;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$LF_$eq(int n) {
        this.LF = n;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$MAX_UNSIGNED_LONG_$eq(BigInt bigInt) {
        this.MAX_UNSIGNED_LONG = bigInt;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$MIN_UNSIGNED_$eq(BigInt bigInt) {
        this.MIN_UNSIGNED = bigInt;
    }

    @Override
    public Tuple2<String, Boolean> readElement(ChannelBuffer buffer) {
        return TextProtocolUtil$class.readElement(this, buffer);
    }

    @Override
    public String readLine(ChannelBuffer buffer) {
        return TextProtocolUtil$class.readLine(this, buffer);
    }

    @Override
    public byte[] concat(byte[] a, byte[] b) {
        return TextProtocolUtil$class.concat(this, a, b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStatsEnabled() {
        if ((this.bitmap$0 & 1) != 0) return this.isStatsEnabled;
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if ((this.bitmap$0 & 1) == 0) {
                this.isStatsEnabled = this.cache.getConfiguration().isExposeJmxStatistics();
                this.bitmap$0 |= 1;
            }
            return this.isStatsEnabled;
        }
    }

    private final AtomicLong incrMisses() {
        return this.incrMisses;
    }

    private final AtomicLong incrHits() {
        return this.incrHits;
    }

    private final AtomicLong decrMisses() {
        return this.decrMisses;
    }

    private final AtomicLong decrHits() {
        return this.decrHits;
    }

    private final AtomicLong replaceIfUnmodifiedMisses() {
        return this.replaceIfUnmodifiedMisses;
    }

    private final AtomicLong replaceIfUnmodifiedHits() {
        return this.replaceIfUnmodifiedHits;
    }

    private final AtomicLong replaceIfUnmodifiedBadval() {
        return this.replaceIfUnmodifiedBadval;
    }

    public Option<MemcachedHeader> readHeader(ChannelBuffer buffer) {
        Option<Enumeration.Value> op;
        Tuple2<String, Boolean> tuple2 = this.readElement(buffer);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String streamOp = (String)tuple22._1();
        boolean endOfOp = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
        Option<Enumeration.Value> option = op = RequestResolver$.MODULE$.toRequest(streamOp);
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
            Object object = endOfOp ? BoxedUnit.UNIT : this.readLine(buffer);
            throw new UnknownOperationException(new StringBuilder().append((Object)"Unknown operation: ").append((Object)streamOp).toString());
        }
        Object object = op.get();
        Enumeration.Value value = Operation$.MODULE$.StatsRequest();
        if (!(object != null ? !object.equals(value) : value != null)) {
            String line;
            if (!endOfOp && !(line = this.readLine(buffer).trim()).isEmpty()) {
                throw new StreamCorruptedException(new StringBuilder().append((Object)"Stats command does not accept arguments: ").append((Object)line).toString());
            }
        }
        Object object2 = op.get();
        Enumeration.Value value2 = MemcachedOperation$.MODULE$.VerbosityRequest();
        if (!(object2 != null ? !object2.equals(value2) : value2 != null)) {
            Object object3 = endOfOp ? BoxedUnit.UNIT : this.readLine(buffer);
            throw new StreamCorruptedException("Memcached 'verbosity' command is unsupported");
        }
        return new Some((Object)new MemcachedHeader((Enumeration.Value)op.get(), endOfOp));
    }

    public Tuple2<String, Boolean> readKey(MemcachedHeader h, ChannelBuffer b) {
        Tuple2<String, Boolean> tuple2 = this.readElement(b);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String k = (String)tuple22._1();
        boolean endOfOp = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
        this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(h, k, endOfOp, b);
        return new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    private String[] readKeys(ChannelBuffer b) {
        return this.readLine(b).trim().split(" +");
    }

    public Object get(MemcachedHeader h$1, ChannelBuffer buffer$1, Cache<String, MemcachedValue> cache$1) {
        Object object;
        String[] keys = this.readKeys(buffer$1);
        if (keys.length > 1) {
            scala.collection.mutable.HashMap map$1 = new scala.collection.mutable.HashMap();
            Predef$.MODULE$.refArrayOps((Object[])keys).foreach((Function1)new $anonfun$get$1(this, h$1, buffer$1, cache$1, map$1));
            object = this.createMultiGetResponse(h$1, (Map<String, MemcachedValue>)new HashMap().$plus$plus((TraversableOnce)map$1));
        } else {
            object = this.createGetResponse(h$1, (String)Predef$.MODULE$.refArrayOps((Object[])keys).head(), (MemcachedValue)((Object)cache$1.get(this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(h$1, (String)Predef$.MODULE$.refArrayOps((Object[])keys).head(), true, buffer$1))));
        }
        return object;
    }

    public final String org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(MemcachedHeader h, String k, boolean endOfOp, ChannelBuffer b) {
        if (k.length() > 250) {
            Object object = endOfOp ? BoxedUnit.UNIT : this.readLine(b);
            throw new StreamCorruptedException("Key length over the 250 character limit");
        }
        return k;
    }

    /*
     * Unable to fully structure code
     */
    public Option<MemcachedParameters> readParameters(MemcachedHeader h, ChannelBuffer b) {
        block6: {
            block7: {
                block5: {
                    if (!h.endOfOp()) break block5;
                    v0 = None$.MODULE$;
                    break block6;
                }
                line = this.readLine(b);
                if (!line.isEmpty()) break block7;
                v0 = None$.MODULE$;
                break block6;
            }
            if (RequestResolver$.MODULE$.isTraceEnabled()) {
                RequestResolver$.MODULE$.trace((Function0)new $anonfun$readParameters$1(this), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{line}));
            }
            args = line.trim().split(" +");
            exceptionResult1 = null;
            try {
                block9: {
                    block8: {
                        index = 0;
                        v1 = var7_7 = h.op();
                        var8_8 = Operation$.MODULE$.RemoveRequest();
                        if (v1 != null ? v1.equals(var8_8) == false : var8_8 != null) break block8;
                        v2 = this.readRemoveParameters(index, args);
                        break block9;
                    }
                    v3 = var7_7;
                    var9_9 = MemcachedOperation$.MODULE$.IncrementRequest();
                    if (!(v3 == null ? var9_9 != null : v3.equals(var9_9) == false)) ** GOTO lbl-1000
                    v4 = var7_7;
                    var10_10 = MemcachedOperation$.MODULE$.DecrementRequest();
                    if (!(v4 != null ? v4.equals(var10_10) == false : var10_10 != null)) lbl-1000:
                    // 2 sources

                    {
                        v2 = this.readIncrDecrParameters(index, args);
                    } else {
                        v5 = var7_7;
                        var11_11 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        v2 = !(v5 != null ? v5.equals(var11_11) == false : var11_11 != null) ? this.readFlushAllParameters(index, args) : this.readStorageParameters(index, args, h, b);
                    }
                }
                v0 = exceptionResult1 = v2;
            }
            catch (ArrayIndexOutOfBoundsException v6) {
                throw new IOException(new StringBuilder().append((Object)"Missing content in command line ").append((Object)line).toString());
            }
        }
        return v0;
    }

    private Option<MemcachedParameters> readRemoveParameters(int index, String[] args) {
        int delayedDeleteTime = this.parseDelayedDeleteTime(index, args);
        boolean noReply = delayedDeleteTime == -1 ? this.parseNoReply(index, args) : false;
        return new Some((Object)new MemcachedParameters(null, -1, -1, -1L, noReply, 0L, "", 0));
    }

    private Option<MemcachedParameters> readIncrDecrParameters(int initIndex, String[] args) {
        int index = initIndex;
        String delta = args[index];
        return new Some((Object)new MemcachedParameters(null, -1, -1, -1L, this.parseNoReply(++index, args), 0L, delta, 0));
    }

    private Option<MemcachedParameters> readFlushAllParameters(int initIndex, String[] args) {
        NumberFormatException numberFormatException2;
        block2: {
            int index = initIndex;
            boolean noReplyFound = false;
            int exceptionResult2 = 0;
            try {
                exceptionResult2 = this.friendlyMaxIntCheck(args[index], "Flush delay");
            }
            catch (NumberFormatException numberFormatException2) {
                if (!numberFormatException2.getMessage().contains("noreply")) break block2;
                noReplyFound = true;
                exceptionResult2 = 0;
            }
            int flushDelay = exceptionResult2;
            boolean noReply = noReplyFound ? true : this.parseNoReply(++index, args);
            return new Some((Object)new MemcachedParameters(null, -1, -1, -1L, noReply, 0L, "", flushDelay));
        }
        throw numberFormatException2;
    }

    private Option<MemcachedParameters> readStorageParameters(int initIndex, String[] args, MemcachedHeader h, ChannelBuffer b) {
        Enumeration.Value value;
        int length;
        int streamLifespan;
        int index = initIndex;
        long flags = this.getFlags(args[index]);
        if (flags < 0L) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Flags cannot be negative: ").append((Object)BoxesRunTime.boxToLong((long)flags)).toString());
        }
        int lifespan = (streamLifespan = this.getLifespan(args[++index])) <= 0 ? -1 : streamLifespan;
        if ((length = this.getLength(args[++index])) < 0) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Negative bytes length provided: ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString());
        }
        Enumeration.Value value2 = value = h.op();
        Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
        long streamVersion = !(value2 != null ? !value2.equals(value3) : value3 != null) ? this.getVersion(args[++index]) : -1L;
        boolean noReply = this.parseNoReply(++index, args);
        byte[] data = new byte[length];
        b.readBytes(data, 0, data.length);
        this.readLine(b);
        return new Some((Object)new MemcachedParameters(data, lifespan, -1, streamVersion, noReply, flags, "", 0));
    }

    public MemcachedValue createValue(MemcachedHeader h, MemcachedParameters p, long nextVersion) {
        return new MemcachedValue(p.data(), nextVersion, p.flags());
    }

    /*
     * WARNING - void declaration
     */
    private long getFlags(String flags) {
        void var2_2;
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        long exceptionResult3 = 0L;
        try {
            exceptionResult3 = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags");
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult3 = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags", numberFormatException);
        }
        return (long)var2_2;
    }

    private int getLifespan(String lifespan) {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return this.friendlyMaxIntCheck(lifespan, "Lifespan");
    }

    private int getLength(String length) {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return this.friendlyMaxIntCheck(length, "The number of bytes");
    }

    private long getVersion(String version) {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return Predef$.MODULE$.augmentString(version).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNoReply(int expectedIndex, String[] args) {
        if (args.length <= expectedIndex) return false;
        String string = args[expectedIndex];
        if ("noreply" != null) {
            if (!"noreply".equals(string)) throw new StreamCorruptedException("Unable to parse noreply optional argument");
            return true;
        }
        if (string == null) return true;
        throw new StreamCorruptedException("Unable to parse noreply optional argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDelayedDeleteTime(int expectedIndex, String[] args) {
        int n;
        if (args.length <= expectedIndex) return 0;
        int exceptionResult4 = 0;
        try {
            n = exceptionResult4 = Predef$.MODULE$.augmentString(args[expectedIndex]).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public Cache<String, MemcachedValue> getCache(MemcachedHeader h) {
        return this.cache;
    }

    public Object handleCustomRequest(MemcachedHeader h, ChannelBuffer b, Cache<String, MemcachedValue> cache, ChannelHandlerContext ctx) {
        Enumeration.Value value;
        block25: {
            Object object;
            block12: {
                block24: {
                    block23: {
                        block17: {
                            Enumeration.Value value2;
                            block21: {
                                BigInt prevCounter;
                                block22: {
                                    Object object2;
                                    Object object3;
                                    MemcachedValue prev;
                                    Option params;
                                    String k;
                                    block20: {
                                        BigInt delta;
                                        block19: {
                                            block18: {
                                                Object object4;
                                                Tuple2 tuple2;
                                                block16: {
                                                    block10: {
                                                        Enumeration.Value value3;
                                                        block15: {
                                                            byte[] byArray;
                                                            MemcachedValue prev2;
                                                            Option params2;
                                                            String k2;
                                                            block14: {
                                                                block13: {
                                                                    block11: {
                                                                        Tuple2 tuple22;
                                                                        block9: {
                                                                            Enumeration.Value value4 = value = h.op();
                                                                            Enumeration.Value value5 = MemcachedOperation$.MODULE$.AppendRequest();
                                                                            if (!(value4 == null ? value5 != null : !value4.equals(value5))) break block9;
                                                                            Enumeration.Value value6 = value;
                                                                            Enumeration.Value value7 = MemcachedOperation$.MODULE$.PrependRequest();
                                                                            if (value6 != null ? !value6.equals(value7) : value7 != null) break block10;
                                                                        }
                                                                        if ((tuple22 = this.readKeyAndParams(h, b)) == null) {
                                                                            throw new MatchError((Object)tuple22);
                                                                        }
                                                                        Tuple2 tuple23 = new Tuple2(tuple22._1(), tuple22._2());
                                                                        k2 = (String)tuple23._1();
                                                                        params2 = (Option)tuple23._2();
                                                                        prev2 = (MemcachedValue)((Object)cache.get(k2));
                                                                        if (prev2 != null) break block11;
                                                                        object = ((MemcachedParameters)((Object)params2.get())).noReply() ? null : this.NOT_STORED();
                                                                        break block12;
                                                                    }
                                                                    Enumeration.Value value8 = value3 = h.op();
                                                                    Enumeration.Value value9 = MemcachedOperation$.MODULE$.AppendRequest();
                                                                    if (value8 != null ? !value8.equals(value9) : value9 != null) break block13;
                                                                    byArray = this.concat(prev2.data(), ((MemcachedParameters)((Object)params2.get())).data());
                                                                    break block14;
                                                                }
                                                                Enumeration.Value value10 = value3;
                                                                Enumeration.Value value11 = MemcachedOperation$.MODULE$.PrependRequest();
                                                                if (value10 != null ? !value10.equals(value11) : value11 != null) break block15;
                                                                byArray = this.concat(((MemcachedParameters)((Object)params2.get())).data(), prev2.data());
                                                            }
                                                            byte[] concatenated = byArray;
                                                            MemcachedValue next = this.createValue(concatenated, this.generateVersion(cache), ((MemcachedParameters)((Object)params2.get())).flags());
                                                            boolean replaced = cache.replace(k2, prev2, next);
                                                            object = replaced ? (Object)(((MemcachedParameters)((Object)params2.get())).noReply() ? null : this.STORED()) : (Object)(((MemcachedParameters)((Object)params2.get())).noReply() ? null : this.NOT_STORED());
                                                            break block12;
                                                        }
                                                        throw new MatchError((Object)value3);
                                                    }
                                                    Enumeration.Value value12 = value;
                                                    Enumeration.Value value13 = MemcachedOperation$.MODULE$.IncrementRequest();
                                                    if (!(value12 == null ? value13 != null : !value12.equals(value13))) break block16;
                                                    Enumeration.Value value14 = value;
                                                    Enumeration.Value value15 = MemcachedOperation$.MODULE$.DecrementRequest();
                                                    if (value14 != null ? !value14.equals(value15) : value15 != null) break block17;
                                                }
                                                if ((tuple2 = this.readKeyAndParams(h, b)) == null) {
                                                    throw new MatchError((Object)tuple2);
                                                }
                                                Tuple2 tuple24 = new Tuple2(tuple2._1(), tuple2._2());
                                                k = (String)tuple24._1();
                                                params = (Option)tuple24._2();
                                                prev = (MemcachedValue)((Object)cache.get(k));
                                                if (prev != null) break block18;
                                                if (this.isStatsEnabled()) {
                                                    Enumeration.Value value16 = h.op();
                                                    Enumeration.Value value17 = MemcachedOperation$.MODULE$.IncrementRequest();
                                                    object4 = BoxesRunTime.boxToLong((long)(!(value16 != null ? !value16.equals(value17) : value17 != null) ? this.incrMisses().incrementAndGet() : this.decrMisses().incrementAndGet()));
                                                } else {
                                                    object4 = BoxedUnit.UNIT;
                                                }
                                                object = ((MemcachedParameters)((Object)params.get())).noReply() ? null : this.NOT_FOUND();
                                                break block12;
                                            }
                                            prevCounter = package$.MODULE$.BigInt().apply(new String(prev.data()));
                                            delta = this.validateDelta(((MemcachedParameters)((Object)params.get())).delta());
                                            Enumeration.Value value18 = value2 = h.op();
                                            Enumeration.Value value19 = MemcachedOperation$.MODULE$.IncrementRequest();
                                            if (value18 != null ? !value18.equals(value19) : value19 != null) break block19;
                                            BigInt candidateCounter = prevCounter.$plus(delta);
                                            object3 = candidateCounter.$greater(this.MAX_UNSIGNED_LONG()) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                                            break block20;
                                        }
                                        Enumeration.Value value20 = value2;
                                        Enumeration.Value value21 = MemcachedOperation$.MODULE$.DecrementRequest();
                                        if (value20 != null ? !value20.equals(value21) : value21 != null) break block21;
                                        BigInt candidateCounter = prevCounter.$minus(delta);
                                        object3 = candidateCounter.$less(BigInt$.MODULE$.int2bigInt(0)) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                                    }
                                    Object newCounter = object3;
                                    MemcachedValue next = this.createValue(newCounter.toString().getBytes(), this.generateVersion(cache), ((MemcachedParameters)((Object)params.get())).flags());
                                    boolean replaced = cache.replace(k, prev, next);
                                    if (!replaced) break block22;
                                    if (this.isStatsEnabled()) {
                                        Enumeration.Value value22 = h.op();
                                        Enumeration.Value value23 = MemcachedOperation$.MODULE$.IncrementRequest();
                                        object2 = BoxesRunTime.boxToLong((long)(!(value22 != null ? !value22.equals(value23) : value23 != null) ? this.incrHits().incrementAndGet() : this.decrHits().incrementAndGet()));
                                    } else {
                                        object2 = BoxedUnit.UNIT;
                                    }
                                    object = ((MemcachedParameters)((Object)params.get())).noReply() ? null : (Object)new StringBuilder().append((Object)new String(next.data())).append((Object)this.CRLF()).toString();
                                    break block12;
                                }
                                throw new CacheException(new StringBuilder().append((Object)"Value modified since we retrieved from the cache, old value was ").append((Object)prevCounter).toString());
                            }
                            throw new MatchError((Object)value2);
                        }
                        Enumeration.Value value24 = value;
                        Enumeration.Value value25 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        if (value24 != null ? !value24.equals(value25) : value25 != null) break block23;
                        Option<MemcachedParameters> params = this.readParameters(h, b);
                        $anonfun$1 flushFunction = new $anonfun$1(this);
                        Option<MemcachedParameters> option = params;
                        None$ none$ = None$.MODULE$;
                        int flushDelay = !(option != null ? !option.equals((Object)none$) : none$ != null) ? 0 : ((MemcachedParameters)((Object)params.get())).flushDelay();
                        ScheduledFuture<?> scheduledFuture = flushDelay == 0 ? flushFunction.apply(cache.getAdvancedCache()) : this.scheduler.schedule(new DelayedFlushAll(cache, (Function1<AdvancedCache<String, MemcachedValue>, Object>)flushFunction), this.toMillis(flushDelay), TimeUnit.MILLISECONDS);
                        Option<MemcachedParameters> option2 = params;
                        None$ none$2 = None$.MODULE$;
                        object = (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) && ((MemcachedParameters)((Object)params.get())).noReply() ? null : this.OK();
                        break block12;
                    }
                    Enumeration.Value value26 = value;
                    Enumeration.Value value27 = MemcachedOperation$.MODULE$.VersionRequest();
                    if (value26 != null ? !value26.equals(value27) : value27 != null) break block24;
                    object = new StringBuilder().append("VERSION ").append("4.2.1.CR2").append(this.CRLF());
                    break block12;
                }
                Enumeration.Value value28 = value;
                Enumeration.Value value29 = MemcachedOperation$.MODULE$.QuitRequest();
                if (value28 != null ? !value28.equals(value29) : value29 != null) break block25;
                object = ctx.getChannel().close();
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    /*
     * WARNING - void declaration
     */
    private BigInt validateDelta(String delta) {
        void var2_2;
        BigInt bigIntDelta = package$.MODULE$.BigInt().apply(delta);
        if (bigIntDelta.$greater(this.MAX_UNSIGNED_LONG())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta sent (").append((Object)delta).append((Object)") exceeds unsigned limit (").append((Object)this.MAX_UNSIGNED_LONG()).append((Object)")").toString());
        }
        if (bigIntDelta.$less(this.MIN_UNSIGNED())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta cannot be negative: ").append((Object)delta).toString());
        }
        return var2_2;
    }

    public Object createSuccessResponse(MemcachedHeader h, Option<MemcachedParameters> params, MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value;
            Enumeration.Value value2 = value = h.op();
            Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedHits().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<MemcachedParameters> option = params;
        None$ none$ = None$.MODULE$;
        if ((option == null ? none$ != null : !option.equals((Object)none$)) && ((MemcachedParameters)((Object)params.get())).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value;
            Enumeration.Value value4 = value = h.op();
            Enumeration.Value value5 = Operation$.MODULE$.RemoveRequest();
            byArray = !(value4 != null ? !value4.equals(value5) : value5 != null) ? this.DELETED() : this.STORED();
        }
        return byArray;
    }

    public Object createNotExecutedResponse(MemcachedHeader h, Option<MemcachedParameters> params, MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value;
            Enumeration.Value value2 = value = h.op();
            Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedBadval().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<MemcachedParameters> option = params;
        None$ none$ = None$.MODULE$;
        if ((option == null ? none$ != null : !option.equals((Object)none$)) && ((MemcachedParameters)((Object)params.get())).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value;
            Enumeration.Value value4 = value = h.op();
            Enumeration.Value value5 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            byArray = !(value4 != null ? !value4.equals(value5) : value5 != null) ? this.EXISTS() : this.NOT_STORED();
        }
        return byArray;
    }

    public Object createNotExistResponse(MemcachedHeader h, Option<MemcachedParameters> params) {
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value;
            Enumeration.Value value2 = value = h.op();
            Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedMisses().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        Option<MemcachedParameters> option = params;
        None$ none$ = None$.MODULE$;
        return (byte[])((option == null ? none$ != null : !option.equals((Object)none$)) && ((MemcachedParameters)((Object)params.get())).noReply() ? null : this.NOT_FOUND());
    }

    public Object createGetResponse(MemcachedHeader h, String k, MemcachedValue v) {
        return v == null ? this.END() : (byte[])List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(h.op(), k, v), ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()}))}));
    }

    public Object createMultiGetResponse(MemcachedHeader h$2, Map<String, MemcachedValue> pairs) {
        Enumeration.Value value;
        block3: {
            ListBuffer elements$1;
            block2: {
                elements$1 = new ListBuffer();
                Enumeration.Value value2 = value = h$2.op();
                Enumeration.Value value3 = Operation$.MODULE$.GetRequest();
                if (!(value2 == null ? value3 != null : !value2.equals(value3))) break block2;
                Enumeration.Value value4 = value;
                Enumeration.Value value5 = Operation$.MODULE$.GetWithVersionRequest();
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block3;
            }
            pairs.foreach((Function1)new $anonfun$createMultiGetResponse$1(this, h$2, elements$1));
            elements$1.$plus$eq((Object)ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()})));
            return elements$1.toList();
        }
        throw new MatchError((Object)value);
    }

    public Object createErrorResponse(Throwable t) {
        MemcachedException memcachedException;
        MemcachedException m;
        Throwable throwable;
        StringBuilder sb = new StringBuilder();
        Throwable throwable2 = t;
        return throwable2 instanceof MemcachedException ? ((throwable = (m = (memcachedException = (MemcachedException)throwable2)).getCause()) instanceof UnknownOperationException ? this.ERROR() : (throwable instanceof ClosedChannelException ? null : (throwable instanceof IOException ? (Object)sb.append(m.getMessage()).append(this.CRLF()) : (throwable instanceof NumberFormatException ? (Object)sb.append(m.getMessage()).append(this.CRLF()) : (Object)sb.append(m.getMessage()).append(this.CRLF()))))) : (throwable2 instanceof ClosedChannelException ? null : (Object)sb.append(this.SERVER_ERROR()).append(t.getMessage()).append(this.CRLF()));
    }

    public Tuple2<MemcachedException, Boolean> createServerException(Exception e, Option<MemcachedHeader> h, ChannelBuffer b) {
        Tuple2 tuple2;
        Exception exception = e;
        if (exception instanceof IOException) {
            IOException iOException;
            IOException i = iOException = (IOException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)this.CLIENT_ERROR_BAD_FORMAT()).append((Object)i.getMessage()).toString(), i), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (exception instanceof NumberFormatException) {
            NumberFormatException numberFormatException;
            NumberFormatException n = numberFormatException = (NumberFormatException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)this.CLIENT_ERROR_BAD_FORMAT()).append((Object)n.getMessage()).toString(), n), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)this.SERVER_ERROR()).append((Object)e).toString(), e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple2;
    }

    public Object createStatsResponse(MemcachedHeader header, Stats stats) {
        StringBuilder sb = new StringBuilder();
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.buildStat("pid", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("time", BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())), sb), this.buildStat("version", this.cache.getVersion(), sb), this.buildStat("pointer_size", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_user", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_system", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_items", BoxesRunTime.boxToInteger((int)stats.getCurrentNumberOfEntries()), sb), this.buildStat("total_items", BoxesRunTime.boxToLong((long)stats.getTotalNumberOfEntries()), sb), this.buildStat("bytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("total_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("connection_structures", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("cmd_get", BoxesRunTime.boxToLong((long)stats.getRetrievals()), sb), this.buildStat("cmd_set", BoxesRunTime.boxToLong((long)stats.getStores()), sb), this.buildStat("get_hits", BoxesRunTime.boxToLong((long)stats.getHits()), sb), this.buildStat("get_misses", BoxesRunTime.boxToLong((long)stats.getMisses()), sb), this.buildStat("delete_misses", BoxesRunTime.boxToLong((long)stats.getRemoveMisses()), sb), this.buildStat("delete_hits", BoxesRunTime.boxToLong((long)stats.getRemoveHits()), sb), this.buildStat("incr_misses", this.incrMisses(), sb), this.buildStat("incr_hits", this.incrHits(), sb), this.buildStat("decr_misses", this.decrMisses(), sb), this.buildStat("decr_hits", this.decrHits(), sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses(), sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits(), sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval(), sb), this.buildStat("auth_cmds", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("auth_errors", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("evictions", BoxesRunTime.boxToLong((long)stats.getEvictions()), sb), this.buildStat("bytes_read", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("bytes_written", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("limit_maxbytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("threads", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("conn_yields", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("reclaimed", BoxesRunTime.boxToInteger((int)0), sb), ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()}))}));
    }

    private ChannelBuffer buildStat(String stat, Object value, StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append(this.CRLF());
        ChannelBuffer buffer = ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sb.toString().getBytes()}));
        sb.setLength(0);
        return buffer;
    }

    private MemcachedValue createValue(byte[] data, long nextVersion, long flags) {
        return new MemcachedValue(data, nextVersion, flags);
    }

    public final ChannelBuffer org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(Enumeration.Value op, String k, MemcachedValue v) {
        String header = this.buildGetResponseHeader(k, v, op);
        return ChannelBuffers$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{header.getBytes(), v.data(), this.CRLFBytes()}));
    }

    private String buildGetResponseHeader(String k, MemcachedValue v, Enumeration.Value op) {
        StringBuilder sb = new StringBuilder();
        sb.append("VALUE ").append(k).append(" ").append(v.flags()).append(" ").append(v.data().length);
        Enumeration.Value value = op;
        Enumeration.Value value2 = Operation$.MODULE$.GetWithVersionRequest();
        Object object = !(value != null ? !value.equals(value2) : value2 != null) ? sb.append(" ").append(v.version()) : BoxedUnit.UNIT;
        sb.append(this.CRLF());
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private int friendlyMaxIntCheck(String number, String message) {
        void var3_3;
        int exceptionResult5 = 0;
        try {
            exceptionResult5 = Predef$.MODULE$.augmentString(number).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult5 = this.numericLimitCheck(number, Integer.MAX_VALUE, message, numberFormatException);
        }
        return (int)var3_3;
    }

    private int numericLimitCheck(String number, long maxValue, String message, NumberFormatException n) {
        if (Predef$.MODULE$.augmentString(number).toLong() > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        throw n;
    }

    private long numericLimitCheck(String number, long maxValue, String message) {
        long numeric = Predef$.MODULE$.augmentString(number).toLong();
        if (Predef$.MODULE$.augmentString(number).toLong() > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        return numeric;
    }

    public MemcachedDecoder(Cache<String, MemcachedValue> cache, ScheduledExecutorService scheduler) {
        this.cache = cache;
        this.scheduler = scheduler;
        TextProtocolUtil$class.$init$(this);
        this.incrMisses = new AtomicLong(0L);
        this.incrHits = new AtomicLong(0L);
        this.decrMisses = new AtomicLong(0L);
        this.decrHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedMisses = new AtomicLong(0L);
        this.replaceIfUnmodifiedHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedBadval = new AtomicLong(0L);
    }
}

