/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import org.infinispan.Version;
import org.infinispan.server.memcached.MemcachedFunctionalTest$;
import org.infinispan.server.memcached.MemcachedSingleNodeTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="server.memcached.MemcachedFunctionalTest")
@ScalaSignature(bytes="\u0006\u0001\tUc\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003/5+WnY1dQ\u0016$g)\u001e8di&|g.\u00197UKN$(BA\u0002\u0005\u0003%iW-\\2bG\",GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0002\u0005\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u0011q#T3nG\u0006\u001c\u0007.\u001a3TS:<G.\u001a(pI\u0016$Vm\u001d;\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"!\u0004\u0001\t\u000bm\u0001A\u0011\u0001\u000f\u0002\u0019Q,7\u000f^*fi\n\u000b7/[2\u0015\u0005u\u0001\u0003CA\t\u001f\u0013\ty\"C\u0001\u0003V]&$\b\"B\u0011\u001b\u0001\u0004\u0011\u0013!A7\u0011\u0005\rRS\"\u0001\u0013\u000b\u0005\u00152\u0013a\u0002:fM2,7\r\u001e\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016%\u0005\u0019iU\r\u001e5pI\")Q\u0006\u0001C\u0001]\u0005AB/Z:u'\u0016$x+\u001b;i\u000bb\u0004\u0018N]=TK\u000e|g\u000eZ:\u0015\u0005uy\u0003\"B\u0011-\u0001\u0004\u0011\u0003\"B\u0019\u0001\t\u0003\u0011\u0014!\u0007;fgR\u001cV\r^,ji\",\u0005\u0010]5ssVs\u0017\u000e\u001f+j[\u0016$\"!H\u001a\t\u000b\u0005\u0002\u0004\u0019\u0001\u0012\t\u000bU\u0002A\u0011\u0001\u001c\u0002?Q,7\u000f^*fi^KG\u000f[#ya&\u0014\u00180\u00168jqRKW.Z%o!\u0006\u001cH\u000f\u0006\u0002\u001eo!)\u0011\u0005\u000ea\u0001E!)\u0011\b\u0001C\u0001u\u0005\u0019B/Z:u\u000f\u0016$X*\u001e7uSBdWmS3zgR\u0011Qd\u000f\u0005\u0006Ca\u0002\rA\t\u0005\u0006{\u0001!\tAP\u0001\ri\u0016\u001cH/\u00113e\u0005\u0006\u001c\u0018n\u0019\u000b\u0003;}BQ!\t\u001fA\u0002\tBQ!\u0011\u0001\u0005\u0002\t\u000b\u0001\u0004^3ti\u0006#GmV5uQ\u0016C\b/\u001b:z'\u0016\u001cwN\u001c3t)\ti2\tC\u0003\"\u0001\u0002\u0007!\u0005C\u0003F\u0001\u0011\u0005a)A\ruKN$\u0018\t\u001a3XSRDW\t\u001f9jef,f.\u001b=US6,GCA\u000fH\u0011\u0015\tC\t1\u0001#\u0011\u0015I\u0005\u0001\"\u0001K\u0003M!Xm\u001d;O_R\fE\rZ%g!J,7/\u001a8u)\ti2\nC\u0003\"\u0011\u0002\u0007!\u0005C\u0003N\u0001\u0011\u0005a*\u0001\tuKN$(+\u001a9mC\u000e,')Y:jGR\u0011Qd\u0014\u0005\u0006C1\u0003\rA\t\u0005\u0006#\u0002!\tAU\u0001\u001bi\u0016\u001cHOT8u%\u0016\u0004H.Y2f\u0013\u001atu\u000e\u001e)sKN,g\u000e\u001e\u000b\u0003;MCQ!\t)A\u0002\tBQ!\u0016\u0001\u0005\u0002Y\u000bA\u0004^3tiJ+\u0007\u000f\\1dK^KG\u000f[#ya&\u0014\u0018pU3d_:$7\u000f\u0006\u0002\u001e/\")\u0011\u0005\u0016a\u0001E!)\u0011\f\u0001C\u00015\u0006iB/Z:u%\u0016\u0004H.Y2f/&$\b.\u0012=qSJLXK\\5y)&lW\r\u0006\u0002\u001e7\")\u0011\u0005\u0017a\u0001E!)Q\f\u0001C\u0001=\u0006yA/Z:u\u0003B\u0004XM\u001c3CCNL7\r\u0006\u0002\u001e?\")\u0011\u0005\u0018a\u0001E!)\u0011\r\u0001C\u0001E\u0006\u0011B/Z:u\u0003B\u0004XM\u001c3O_R4u.\u001e8e)\ti2\rC\u0003\"A\u0002\u0007!\u0005C\u0003f\u0001\u0011\u0005a-\u0001\tuKN$\bK]3qK:$')Y:jGR\u0011Qd\u001a\u0005\u0006C\u0011\u0004\rA\t\u0005\u0006S\u0002!\tA[\u0001\u0014i\u0016\u001cH\u000f\u0015:fa\u0016tGMT8u\r>,h\u000e\u001a\u000b\u0003;-DQ!\t5A\u0002\tBQ!\u001c\u0001\u0005\u00029\fQ\u0002^3ti\u001e+Go\u001d\"bg&\u001cGCA\u000fp\u0011\u0015\tC\u000e1\u0001#\u0011\u0015\t\b\u0001\"\u0001s\u00031!Xm\u001d;DCN\u0014\u0015m]5d)\ti2\u000fC\u0003\"a\u0002\u0007!\u0005C\u0003v\u0001\u0011\u0005a/A\buKN$8)Y:O_R4u.\u001e8e)\tir\u000fC\u0003\"i\u0002\u0007!\u0005C\u0003z\u0001\u0011\u0005!0A\u0007uKN$8)Y:Fq&\u001cHo\u001d\u000b\u0003;mDQ!\t=A\u0002\tBQ! \u0001\u0005\u0002y\fa\u0002^3ti&sg/\u00197jI\u000e\u000b7/F\u0001\u001e\u0011\u0019\t\t\u0001\u0001C\u0001}\u0006\u0019B/Z:u\u0013:4\u0018\r\\5e\u0007\u0006\u001ch+\u00197vK\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0011a\u0004;fgR$U\r\\3uK\n\u000b7/[2\u0015\u0007u\tI\u0001\u0003\u0004\"\u0003\u0007\u0001\rA\t\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003Y!Xm\u001d;EK2,G/\u001a#pKNtu\u000e^#ySN$HcA\u000f\u0002\u0012!1\u0011%a\u0003A\u0002\tBa!!\u0006\u0001\t\u0003q\u0018a\u0005;fgR\u0004\u0016\u000e]3mS:,G\rR3mKR,\u0007BBA\r\u0001\u0011\u0005a0A\u0010uKN$\b+\u001b9fY&tW\rZ$fi\u00063G/\u001a:J]Z\fG.\u001b3DCNDq!!\b\u0001\t\u0003\ty\"\u0001\nuKN$\u0018J\\2sK6,g\u000e\u001e\"bg&\u001cGcA\u000f\u0002\"!1\u0011%a\u0007A\u0002\tBq!!\n\u0001\t\u0003\t9#A\nuKN$\u0018J\\2sK6,g\u000e\u001e+sSBdW\rF\u0002\u001e\u0003SAa!IA\u0012\u0001\u0004\u0011\u0003bBA\u0017\u0001\u0011\u0005\u0011qF\u0001\u0016i\u0016\u001cH/\u00138de\u0016lWM\u001c;O_R,\u00050[:u)\ri\u0012\u0011\u0007\u0005\u0007C\u0005-\u0002\u0019\u0001\u0012\t\u000f\u0005U\u0002\u0001\"\u0001\u00028\u00059B/Z:u\u0013:\u001c'/Z7f]RLe\u000e^3hKJl\u0015\r\u001f\u000b\u0004;\u0005e\u0002BB\u0011\u00024\u0001\u0007!\u0005C\u0004\u0002>\u0001!\t!a\u0010\u0002;Q,7\u000f^%oGJ,W.\u001a8u\u0005\u0016LxN\u001c3J]R,w-\u001a:NCb$2!HA!\u0011\u0019\t\u00131\ba\u0001E!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0013A\u0007;fgRLen\u0019:f[\u0016tGOQ3z_:$Gj\u001c8h\u001b\u0006DHcA\u000f\u0002J!1\u0011%a\u0011A\u0002\tBq!!\u0014\u0001\t\u0003\ty%A\u000euKN$\u0018J\\2sK6,g\u000e^*veB\f7o\u001d'p]\u001el\u0015\r\u001f\u000b\u0004;\u0005E\u0003BB\u0011\u0002L\u0001\u0007!\u0005C\u0004\u0002V\u0001!\t!a\u0016\u0002;Q,7\u000f^%oGJ,W.\u001a8u'V\u0014\b/Y:t\u0005&<\u0017J\u001c;NCb$2!HA-\u0011\u0019\t\u00131\u000ba\u0001E!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0013A\u0005;fgR$Um\u0019:f[\u0016tGOQ1tS\u000e$2!HA1\u0011\u0019\t\u00131\fa\u0001E!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0014a\u0005;fgR$Um\u0019:f[\u0016tG\u000f\u0016:ja2,GcA\u000f\u0002j!1\u0011%a\u0019A\u0002\tBq!!\u001c\u0001\t\u0003\ty'A\u000buKN$H)Z2sK6,g\u000e\u001e(pi\u0016C\u0018n\u001d;\u0015\u0007u\t\t\b\u0003\u0004\"\u0003W\u0002\rA\t\u0005\b\u0003k\u0002A\u0011AA<\u0003Y!Xm\u001d;EK\u000e\u0014X-\\3oi\n+Gn\\<[KJ|GcA\u000f\u0002z!1\u0011%a\u001dA\u0002\tBq!! \u0001\t\u0003\ty(\u0001\u0007uKN$h\t\\;tQ\u0006cG\u000eF\u0002\u001e\u0003\u0003Ca!IA>\u0001\u0004\u0011\u0003bBAC\u0001\u0011\u0005\u0011qQ\u0001\u0014i\u0016\u001cHO\u00127vg\"\fE\u000e\u001c#fY\u0006LX\r\u001a\u000b\u0004;\u0005%\u0005BB\u0011\u0002\u0004\u0002\u0007!\u0005C\u0004\u0002\u000e\u0002!\t!a$\u00027Q,7\u000f\u001e$mkND\u0017\t\u001c7EK2\f\u00170\u001a3V]&DH+[7f)\ri\u0012\u0011\u0013\u0005\u0007C\u0005-\u0005\u0019\u0001\u0012\t\u000f\u0005U\u0005\u0001\"\u0003\u0002\u0018\u0006ya\r\\;tQ\u0006cG\u000eR3mCf,G\rF\u0004\u001e\u00033\u000bY*!*\t\r\u0005\n\u0019\n1\u0001#\u0011!\ti*a%A\u0002\u0005}\u0015!\u00023fY\u0006L\bcA\t\u0002\"&\u0019\u00111\u0015\n\u0003\u0007%sG\u000f\u0003\u0005\u0002(\u0006M\u0005\u0019AAU\u0003\u0015\u0019H.Z3q!\r\t\u00121V\u0005\u0004\u0003[\u0013\"\u0001\u0002'p]\u001eDq!!-\u0001\t\u0003\t\u0019,A\nuKN$h\t\\;tQ\u0006cGNT8SKBd\u00170\u0006\u0002\u00026B1\u0011qWAd\u0003\u001btA!!/\u0002D:!\u00111XAa\u001b\t\tiLC\u0002\u0002@*\ta\u0001\u0010:p_Rt\u0014\"A\n\n\u0007\u0005\u0015'#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00171\u001a\u0002\u0005\u0019&\u001cHOC\u0002\u0002FJ\u0001B!a4\u0002V:\u0019\u0011#!5\n\u0007\u0005M'#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003/\fIN\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003'\u0014\u0002BBAo\u0001\u0011\u0005a0\u0001\u000buKN$h\t\\;tQ\u0006cG\u000eU5qK2Lg.\u001a\u0005\u0007\u0003C\u0004A\u0011\u0001@\u0002\u0017Q,7\u000f\u001e,feNLwN\u001c\u0005\u0007\u0003K\u0004A\u0011\u0001@\u0002-Q,7\u000f^%oGJ\\U-\u001f'f]\u001e$\b\u000eT5nSRDa!!;\u0001\t\u0003q\u0018!\u0006;fgR<U\r^&fs2+gn\u001a;i\u0019&l\u0017\u000e\u001e\u0005\u0007\u0003[\u0004A\u0011\u0001@\u0002%Q,7\u000f^+oW:|wO\\\"p[6\fg\u000e\u001a\u0005\u0007\u0003c\u0004A\u0011\u0001@\u00027Q,7\u000f^+oW:|wO\\\"p[6\fg\u000e\u001a)ja\u0016d\u0017N\\3e\u0011\u0019\t)\u0010\u0001C\u0001}\u0006aB/Z:u%\u0016\fGMR;mY2Kg.Z!gi\u0016\u0014Hj\u001c8h\u0017\u0016L\bBBA}\u0001\u0011\u0005a0\u0001\u000fuKN$h*Z4bi&4XMQ=uKNdUM\\4uQZ\u000bG.^3\t\u000f\u0005u\b\u0001\"\u0001\u0002\u0000\u0006\u0019B/Z:u\r2\fwm]%t+:\u001c\u0018n\u001a8fIR\u0019QD!\u0001\t\r\u0005\nY\u00101\u0001#\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u000f\ta\u0003^3ti&s7M\u001d#fGJL5/\u00168tS\u001etW\r\u001a\u000b\u0004;\t%\u0001BB\u0011\u0003\u0004\u0001\u0007!\u0005\u0003\u0004\u0003\u000e\u0001!\tA`\u0001\u000ei\u0016\u001cHOV3sE>\u001c\u0018\u000e^=\t\u000f\tE\u0001\u0001\"\u0001\u0003\u0014\u0005AA/Z:u#VLG\u000fF\u0002\u001e\u0005+Aa!\tB\b\u0001\u0004\u0011\u0003b\u0002B\r\u0001\u0011%!1D\u0001\nC\u0012$\u0017I\u001c3HKR$2!\bB\u000f\u0011\u0019\t#q\u0003a\u0001E!9!\u0011\u0005\u0001\u0005\n\t\r\u0012\u0001B5oGJ$b!!4\u0003&\t\u001d\u0002BB\u0011\u0003 \u0001\u0007!\u0005\u0003\u0005\u0003*\t}\u0001\u0019AAP\u0003\t\u0011\u0017\u0010C\u0004\u0003\"\u0001!IA!\f\u0015\r\u00055'q\u0006B\u001a\u0011!\u0011\tDa\u000bA\u0002\u00055\u0017!A6\t\u0011\t%\"1\u0006a\u0001\u0003?C3\u0002\u0001B\u001c\u0005\u000f\u0012IEa\u0014\u0003RA!!\u0011\bB\"\u001b\t\u0011YD\u0003\u0003\u0003>\t}\u0012aC1o]>$\u0018\r^5p]NT1A!\u0011\t\u0003\u0019!Xm\u001d;oO&!!Q\tB\u001e\u0005\u0011!Vm\u001d;\u0002\r\u001d\u0014x.\u001e9tY\t\u0011Y%\t\u0002\u0003N\u0005Qa-\u001e8di&|g.\u00197\u0002\u0011Q,7\u000f\u001e(b[\u0016\f#Aa\u0015\u0002QM,'O^3s]5,WnY1dQ\u0016$g&T3nG\u0006\u001c\u0007.\u001a3Gk:\u001cG/[8oC2$Vm\u001d;")
public class MemcachedFunctionalTest
extends MemcachedSingleNodeTest
implements ScalaObject {
    public void testSetBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    public void testSetWithExpirySeconds(Method m) {
        Future f = this.client().set(this.k(m), 1, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testSetWithExpiryUnixTime(Method m) {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().set(this.k(m), future, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testSetWithExpiryUnixTimeInPast(Method m) {
        Future f = this.client().set(this.k(m), 2592001, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testGetMultipleKeys(Method m) {
        Future f1 = this.client().set(this.k(m, "k1-"), 0, (Object)this.v(m, "v1-"));
        Future f2 = this.client().set(this.k(m, "k2-"), 0, (Object)this.v(m, "v2-"));
        Future f3 = this.client().set(this.k(m, "k3-"), 0, (Object)this.v(m, "v3-"));
        Assert.assertTrue((boolean)((Boolean)f1.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f2.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f3.get(this.timeout(), TimeUnit.SECONDS)));
        List keys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.k(m, "k1-"), this.k(m, "k2-"), this.k(m, "k3-")}));
        Map ret = this.client().getBulk((String[])keys.toArray(ClassManifest$.MODULE$.classType(String.class)));
        Assert.assertEquals(ret.get(this.k(m, "k1-")), (Object)this.v(m, "v1-"));
        Assert.assertEquals(ret.get(this.k(m, "k2-")), (Object)this.v(m, "v2-"));
        Assert.assertEquals(ret.get(this.k(m, "k3-")), (Object)this.v(m, "v3-"));
    }

    public void testAddBasic(Method m) {
        this.addAndGet(m);
    }

    public void testAddWithExpirySeconds(Method m) {
        Future f = this.client().add(this.k(m), 1, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
        f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testAddWithExpiryUnixTime(Method m) {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().add(this.k(m), future, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
        f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testNotAddIfPresent(Method m) {
        this.addAndGet(m);
        Future f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    public void testReplaceBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().replace(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testNotReplaceIfNotPresent(Method m) {
        Future f = this.client().replace(this.k(m), 0, (Object)this.v(m));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testReplaceWithExpirySeconds(Method m) {
        this.addAndGet(m);
        Future f = this.client().replace(this.k(m), 1, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testReplaceWithExpiryUnixTime(Method m) {
        this.addAndGet(m);
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().replace(this.k(m), future, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testAppendBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().append(0L, this.k(m), (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)this.v(m)).append((Object)this.v(m, "v1-")).toString();
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)expected);
    }

    public void testAppendNotFound(Method m) {
        this.addAndGet(m);
        Future f = this.client().append(0L, this.k(m, "k2-"), (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        Assert.assertNull((Object)this.client().get(this.k(m, "k2-")));
    }

    public void testPrependBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().prepend(0L, this.k(m), (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)this.v(m, "v1-")).append((Object)this.v(m)).toString();
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)expected);
    }

    public void testPrependNotFound(Method m) {
        this.addAndGet(m);
        Future f = this.client().prepend(0L, this.k(m, "k2-"), (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        Assert.assertNull((Object)this.client().get(this.k(m, "k2-")));
    }

    public void testGetsBasic(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
    }

    public void testCasBasic(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v1-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testCasNotFound(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client().cas(this.k(m, "k1-"), value.getCas(), (Object)this.v(m, "v1-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.NOT_FOUND);
    }

    public void testCasExists(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        long old = value.getCas();
        CASResponse resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v1-"));
        value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m, "v1-"));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((value.getCas() != old ? 1 : 0) != 0);
        resp = this.client().cas(this.k(m), old, (Object)this.v(m, "v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.EXISTS);
        resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testInvalidCas() {
        String resp = this.send("cas bad blah 0 0 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 blah 0 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 0 blah 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 0 0 blah\r\n\r\n");
        this.assertClientError(resp);
    }

    public void testInvalidCasValue() {
        String resp = this.send("cas foo 0 0 6 \r\nbarva2\r\n");
        this.assertClientError(resp);
    }

    public void testDeleteBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().delete(this.k(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testDeleteDoesNotExist(Method m) {
        Future f = this.client().delete(this.k(m));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
    }

    public void testPipelinedDelete() {
        List<String> responses = this.sendMulti("delete a\r\ndelete a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        responses.foreach((Function1)new $anonfun$testPipelinedDelete$1(this));
    }

    public void testPipelinedGetAfterInvalidCas() {
        List<String> responses = this.sendMulti("cas bad 0 0 1 0 0\r\nget a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertTrue((boolean)((String)responses.head()).contains("CLIENT_ERROR"));
        Object object = ((IterableLike)responses.tail()).head();
        String string = "END";
        Assert.assertTrue((!(object != null ? !object.equals(string) : string != null) ? 1 : 0) != 0, (String)new StringBuilder().append((Object)"Instead response was: ").append(((IterableLike)responses.tail()).head()).toString());
    }

    public void testIncrementBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long result = this.client().incr(this.k(m), 1);
        Assert.assertEquals((long)result, (long)2L);
    }

    public void testIncrementTriple(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().incr(this.k(m), 1), (long)2L);
        Assert.assertEquals((long)this.client().incr(this.k(m), 2), (long)4L);
        Assert.assertEquals((long)this.client().incr(this.k(m), 4), (long)8L);
    }

    public void testIncrementNotExist(Method m) {
        Assert.assertEquals((long)this.client().incr(this.k(m), 1), (long)-1L);
    }

    public void testIncrementIntegerMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().incr(this.k(m), Integer.MAX_VALUE), (long)Integer.MAX_VALUE);
    }

    public void testIncrementBeyondIntegerMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long newValue = this.client().incr(this.k(m), Integer.MAX_VALUE);
        Assert.assertEquals((long)newValue, (long)((long)Integer.MAX_VALUE + 1L));
    }

    public void testIncrementBeyondLongMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"9223372036854775808");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        Assert.assertEquals((Object)package$.MODULE$.BigInt().apply(newValue), (Object)package$.MODULE$.BigInt().apply("9223372036854775809"));
    }

    public void testIncrementSurpassLongMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"9223372036854775807");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        Assert.assertEquals((Object)package$.MODULE$.BigInt().apply(newValue), (Object)package$.MODULE$.BigInt().apply("9223372036854775808"));
    }

    public void testIncrementSurpassBigIntMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"18446744073709551615");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        Assert.assertEquals((String)newValue, (String)"0");
    }

    public void testDecrementBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)0L);
    }

    public void testDecrementTriple(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"8");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)7L);
        Assert.assertEquals((long)this.client().decr(this.k(m), 2), (long)5L);
        Assert.assertEquals((long)this.client().decr(this.k(m), 4), (long)1L);
    }

    public void testDecrementNotExist(Method m) {
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)-1L);
    }

    public void testDecrementBelowZero(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long newValue = this.client().decr(this.k(m), 2);
        Assert.assertEquals((long)newValue, (long)0L);
    }

    public void testFlushAll(Method m$1) {
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$testFlushAll$1(this, m$1));
        Future f = this.client().flush();
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$testFlushAll$2(this, m$1));
    }

    public void testFlushAllDelayed(Method m) {
        this.flushAllDelayed(m, 2, 2200L);
    }

    public void testFlushAllDelayedUnixTime(Method m) {
        int delay = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 2000L);
        this.flushAllDelayed(m, delay, 2200L);
    }

    private void flushAllDelayed(Method m$2, int delay, long sleep) {
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$flushAllDelayed$1(this, m$2));
        Future f = this.client().flush(delay);
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)sleep);
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$flushAllDelayed$2(this, m$2));
    }

    public List<String> testFlushAllNoReply() {
        return this.sendNoWait("flush_all noreply\r\n");
    }

    public void testFlushAllPipeline() {
        List<String> responses = this.sendMulti("flush_all\r\nget a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertEquals((String)((String)responses.head()), (String)"OK");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"END");
    }

    public void testVersion() {
        Map versions = this.client().getVersions();
        Assert.assertEquals((int)versions.size(), (int)1);
        String version = (String)versions.values().iterator().next();
        Assert.assertEquals((String)version, (String)Version.VERSION);
    }

    public void testIncrKeyLengthLimit() {
        String keyUnderLimit = TestingUtil.generateRandomString((int)249);
        Future f = this.client().set(keyUnderLimit, 0, (Object)"78");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(keyUnderLimit), (Object)"78");
        String keyInLimit = TestingUtil.generateRandomString((int)250);
        f = this.client().set(keyInLimit, 0, (Object)"89");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(keyInLimit), (Object)"89");
        String keyAboveLimit = TestingUtil.generateRandomString((int)251);
        String resp = this.incr(keyAboveLimit, 1);
        this.assertClientError(resp);
    }

    public void testGetKeyLengthLimit() {
        String tooLongKey = TestingUtil.generateRandomString((int)251);
        String resp = this.send(new StringBuilder().append((Object)"get ").append((Object)tooLongKey).append((Object)"\r\n").toString());
        this.assertClientError(resp);
        tooLongKey = TestingUtil.generateRandomString((int)251);
        resp = this.send(new StringBuilder().append((Object)"get k1 k2 k3 ").append((Object)tooLongKey).append((Object)"\r\n").toString());
        this.assertClientError(resp);
    }

    public void testUnknownCommand() {
        this.assertError(this.send("blah\r\n"));
    }

    public void testUnknownCommandPipelined() {
        List<String> responses = this.sendMulti("bogus\r\ndelete a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertEquals((String)((String)responses.head()), (String)"ERROR");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"NOT_FOUND");
    }

    public void testReadFullLineAfterLongKey() {
        String key = TestingUtil.generateRandomString((int)300);
        String command = new StringBuilder().append((Object)"add ").append((Object)key).append((Object)" 0 0 1\r\nget a\r\n").toString();
        List<String> responses = this.sendMulti(command, 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertTrue((boolean)((String)responses.head()).contains("CLIENT_ERROR"));
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"END");
    }

    public void testNegativeBytesLengthValue() {
        this.assertClientError(this.send("set boo1 0 0 -1\r\n"));
        this.assertClientError(this.send("add boo2 0 0 -1\r\n"));
    }

    public void testFlagsIsUnsigned(Method m) {
        String k = m.getName();
        this.assertClientError(this.send("set boo1 -1 0 0\r\n"));
        this.assertStored(this.send(new StringBuilder().append((Object)"set ").append((Object)k).append((Object)" 4294967295 0 0\r\n").toString()));
        this.assertClientError(this.send("set boo2 4294967296 0 0\r\n"));
        this.assertClientError(this.send("set boo2 18446744073709551615 0 0\r\n"));
    }

    public void testIncrDecrIsUnsigned(Method m) {
        String k = m.getName();
        Future f = this.client().set(k, 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.assertClientError(this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" -1\r\n").toString()));
        this.assertClientError(this.send(new StringBuilder().append((Object)"decr ").append((Object)k).append((Object)" -1\r\n").toString()));
        k = new StringBuilder().append((Object)k).append((Object)"-1").toString();
        f = this.client().set(k, 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.assertExpectedResponse(this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" 18446744073709551615\r\n").toString()), "18446744073709551615", true);
        k = new StringBuilder().append((Object)k).append((Object)"-1").toString();
        f = this.client().set(k, 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.assertClientError(this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" 18446744073709551616\r\n").toString()));
        this.assertClientError(this.send(new StringBuilder().append((Object)"decr ").append((Object)k).append((Object)" 18446744073709551616\r\n").toString()));
    }

    public void testVerbosity() {
        this.assertClientError(this.send("verbosity\r\n"));
        this.assertClientError(this.send("verbosity 5\r\n"));
        this.assertClientError(this.send("verbosity 10 noreply\r\n"));
    }

    public void testQuit(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.sendNoWait("quit\r\n");
    }

    private void addAndGet(Method m) {
        Future f = this.client().add(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    private String incr(Method m, int by) {
        return this.incr(this.k(m), by);
    }

    private String incr(String k, int by) {
        return this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)by)).append((Object)"\r\n").toString());
    }
}

