/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.DecoderState;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.RequestHeader;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ExtendedChannelBuffer$;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.memcached.DelayedFlushAll;
import org.infinispan.server.memcached.MemcachedDecoder$;
import org.infinispan.server.memcached.MemcachedException;
import org.infinispan.server.memcached.MemcachedOperation$;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.MemcachedValue;
import org.infinispan.server.memcached.RequestResolver$;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.TextProtocolUtil$class;
import org.infinispan.stats.Stats;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\r\u0005c\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003!5+WnY1dQ\u0016$G)Z2pI\u0016\u0014(BA\u0002\u0005\u0003%iW-\\2bG\",GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0002I\u0012\u0011\t5\u0001\"\u0003H\u0007\u0002\u001d)\u0011q\u0002B\u0001\u0005G>\u0014X-\u0003\u0002\u0012\u001d\t9\u0012IY:ue\u0006\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c#fG>$WM\u001d\t\u0003'eq!\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\ta\u0001\u0015:fI\u00164\u0017B\u0001\u000e\u001c\u0005\u0019\u0019FO]5oO*\u0011\u0001$\u0006\t\u0003;yi\u0011AA\u0005\u0003?\t\u0011a\"T3nG\u0006\u001c\u0007.\u001a3WC2,X\r\u0005\u0002\u001eC%\u0011!E\u0001\u0002\u0011)\u0016DH\u000f\u0015:pi>\u001cw\u000e\\+uS2\u0004\"\u0001\u0006\u0013\n\u0005\u0015*\"aC*dC2\fwJ\u00196fGRD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u000f[\u0016l7-Y2iK\u0012\u001c\u0015m\u00195f!\u0011I#F\u0005\u000f\u000e\u0003\u0019I!a\u000b\u0004\u0003\u000b\r\u000b7\r[3\t\u00115\u0002!\u0011!Q\u0001\n9\n\u0011b]2iK\u0012,H.\u001a:\u0011\u0005=2T\"\u0001\u0019\u000b\u0005E\u0012\u0014AC2p]\u000e,(O]3oi*\u00111\u0007N\u0001\u0005kRLGNC\u00016\u0003\u0011Q\u0017M^1\n\u0005]\u0002$\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\"A\u0011\b\u0001B\u0001B\u0003%!(A\u0005ue\u0006t7\u000f]8siB\u00111(P\u0007\u0002y)\u0011\u0011HD\u0005\u0003}q\u0012aBT3uif$&/\u00198ta>\u0014H\u000fC\u0003A\u0001\u0011\u0005\u0011)\u0001\u0004=S:LGO\u0010\u000b\u0005\u0005\u000e#U\t\u0005\u0002\u001e\u0001!)qe\u0010a\u0001Q!)Qf\u0010a\u0001]!)\u0011h\u0010a\u0001u\u0015Aq\t\u0001C\u0001\u0002\u0003\u0005\u0001J\u0001\nTk&$\u0018M\u00197f!\u0006\u0014\u0018-\\3uKJ\u001c\bCA\u000fJ\u0013\tQ%AA\nNK6\u001c\u0017m\u00195fIB\u000b'/Y7fi\u0016\u00148/\u0002\u0005M\u0001\u0011\u0005\t\u0011!\u0001N\u00059\u0019V/\u001b;bE2,\u0007*Z1eKJ\u0004\"!\u0004(\n\u0005=s!!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000f\u0003\u0005R\u0001!\u0015\r\u0011\"\u0003S\u00039I7o\u0015;biN,e.\u00192mK\u0012,\u0012a\u0015\t\u0003)QK!!V\u000b\u0003\u000f\t{w\u000e\\3b]\"Aq\u000b\u0001E\u0001B\u0003&1+A\bjgN#\u0018\r^:F]\u0006\u0014G.\u001a3!\u0011\u001dI\u0006A1A\u0005\u000ei\u000b!\"\u001b8de6K7o]3t+\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u000101\u0003\u0019\tGo\\7jG&\u0011\u0001-\u0018\u0002\u000b\u0003R|W.[2M_:<\u0007B\u00022\u0001A\u000351,A\u0006j]\u000e\u0014X*[:tKN\u0004\u0003b\u00023\u0001\u0005\u0004%iAW\u0001\tS:\u001c'\u000fS5ug\"1a\r\u0001Q\u0001\u000em\u000b\u0011\"\u001b8de\"KGo\u001d\u0011\t\u000f!\u0004!\u0019!C\u00075\u0006QA-Z2s\u001b&\u001c8/Z:\t\r)\u0004\u0001\u0015!\u0004\\\u0003-!Wm\u0019:NSN\u001cXm\u001d\u0011\t\u000f1\u0004!\u0019!C\u00075\u0006AA-Z2s\u0011&$8\u000f\u0003\u0004o\u0001\u0001\u0006iaW\u0001\nI\u0016\u001c'\u000fS5ug\u0002Bq\u0001\u001d\u0001C\u0002\u00135!,A\rsKBd\u0017mY3JMVsWn\u001c3jM&,G-T5tg\u0016\u001c\bB\u0002:\u0001A\u000351,\u0001\u000esKBd\u0017mY3JMVsWn\u001c3jM&,G-T5tg\u0016\u001c\b\u0005C\u0004u\u0001\t\u0007IQ\u0002.\u0002/I,\u0007\u000f\\1dK&3WK\\7pI&4\u0017.\u001a3ISR\u001c\bB\u0002<\u0001A\u000351,\u0001\rsKBd\u0017mY3JMVsWn\u001c3jM&,G\rS5ug\u0002Bq\u0001\u001f\u0001C\u0002\u00135!,A\rsKBd\u0017mY3JMVsWn\u001c3jM&,GMQ1em\u0006d\u0007B\u0002>\u0001A\u000351,\u0001\u000esKBd\u0017mY3JMVsWn\u001c3jM&,GMQ1em\u0006d\u0007\u0005C\u0003}\u0001\u0011\u0005S0\u0001\u0006sK\u0006$\u0007*Z1eKJ$2A`A\u0005!\u0015!r0a\u0001T\u0013\r\t\t!\u0006\u0002\u0007)V\u0004H.\u001a\u001a\u0011\tQ\t)!T\u0005\u0004\u0003\u000f)\"AB(qi&|g\u000eC\u0004\u0002\fm\u0004\r!!\u0004\u0002\r\t,hMZ3s!\u0011\ty!a\u0007\u000e\u0005\u0005E!\u0002BA\u0006\u0003'QA!!\u0006\u0002\u0018\u0005)a.\u001a;us*\u0019\u0011\u0011\u0004\u0005\u0002\u000b)\u0014wn]:\n\t\u0005u\u0011\u0011\u0003\u0002\u000e\u0007\"\fgN\\3m\u0005V4g-\u001a:\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$\u00059!/Z1e\u0017\u0016LH\u0003BA\u0013\u0003O\u0001B\u0001F@\u0013'\"A\u0011\u0011FA\u0010\u0001\u0004\ti!A\u0001c\u0011\u001d\ti\u0003\u0001C\u0005\u0003_\t\u0001B]3bI.+\u0017p\u001d\u000b\u0005\u0003c\t9\u0004\u0005\u0003\u0015\u0003g\u0011\u0012bAA\u001b+\t)\u0011I\u001d:bs\"A\u0011\u0011FA\u0016\u0001\u0004\ti\u0001C\u0004\u0002<\u0001!\t&!\u0010\u0002\u0007\u001d,G\u000f\u0006\u0003\u0002@\u0005\u0015\u0003c\u0001\u000b\u0002B%\u0019\u00111I\u000b\u0003\r\u0005s\u0017PU3g\u0011!\tY!!\u000fA\u0002\u00055\u0001bBA%\u0001\u0011%\u00111J\u0001\u000fG\",7m[&fs2+gn\u001a;i)\u001d\u0011\u0012QJA)\u0003+Bq!a\u0014\u0002H\u0001\u0007!#A\u0001l\u0011\u001d\t\u0019&a\u0012A\u0002M\u000bq!\u001a8e\u001f\u001a|\u0005\u000f\u0003\u0005\u0002*\u0005\u001d\u0003\u0019AA\u0007\u0011\u001d\tI\u0006\u0001C!\u00037\naB]3bIB\u000b'/Y7fi\u0016\u00148\u000fF\u0003T\u0003;\ni\u0007\u0003\u0005\u0002`\u0005]\u0003\u0019AA1\u0003\t\u0019\u0007\u000e\u0005\u0003\u0002d\u0005%TBAA3\u0015\u0011\t9'a\u0005\u0002\u000f\rD\u0017M\u001c8fY&!\u00111NA3\u0005\u001d\u0019\u0005.\u00198oK2D\u0001\"!\u000b\u0002X\u0001\u0007\u0011Q\u0002\u0005\b\u0003c\u0002A\u0011BA:\u0003Q\u0011X-\u00193SK6|g/\u001a)be\u0006lW\r^3sgR\u0019\u0001*!\u001e\t\u0011\u0005]\u0014q\u000ea\u0001\u0003c\tA!\u0019:hg\"9\u00111\u0010\u0001\u0005\n\u0005u\u0014A\u0006:fC\u0012Len\u0019:EK\u000e\u0014\b+\u0019:b[\u0016$XM]:\u0015\u0007!\u000by\b\u0003\u0005\u0002x\u0005e\u0004\u0019AA\u0019\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000b\u000baC]3bI\u001acWo\u001d5BY2\u0004\u0016M]1nKR,'o\u001d\u000b\u0004\u0011\u0006\u001d\u0005\u0002CA<\u0003\u0003\u0003\r!!\r\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\u0006)\"/Z1e'R|'/Y4f!\u0006\u0014\u0018-\\3uKJ\u001cH#\u0002%\u0002\u0010\u0006E\u0005\u0002CA<\u0003\u0013\u0003\r!!\r\t\u0011\u0005%\u0012\u0011\u0012a\u0001\u0003\u001bAq!!&\u0001\t#\n9*A\u0005sK\u0006$g+\u00197vKR!\u0011\u0011TAP!\r!\u00121T\u0005\u0004\u0003;+\"\u0001B+oSRD\u0001\"!\u000b\u0002\u0014\u0002\u0007\u0011Q\u0002\u0005\b\u0003G\u0003A\u0011IAS\u0003-\u0019'/Z1uKZ\u000bG.^3\u0015\u0007q\t9\u000b\u0003\u0005\u0002*\u0006\u0005\u0006\u0019AAV\u0003-qW\r\u001f;WKJ\u001c\u0018n\u001c8\u0011\u0007Q\ti+C\u0002\u00020V\u0011A\u0001T8oO\"9\u00111\u0017\u0001\u0005\n\u0005U\u0016\u0001C4fi\u001ac\u0017mZ:\u0015\t\u0005-\u0016q\u0017\u0005\b\u0003s\u000b\t\f1\u0001\u0013\u0003\u00151G.Y4t\u0011\u001d\ti\f\u0001C\u0005\u0003\u007f\u000b1bZ3u\u0019&4Wm\u001d9b]R!\u0011\u0011YAd!\r!\u00121Y\u0005\u0004\u0003\u000b,\"aA%oi\"9\u0011\u0011ZA^\u0001\u0004\u0011\u0012\u0001\u00037jM\u0016\u001c\b/\u00198\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\u0006Iq-\u001a;MK:<G\u000f\u001b\u000b\u0005\u0003\u0003\f\t\u000eC\u0004\u0002T\u0006-\u0007\u0019\u0001\n\u0002\r1,gn\u001a;i\u0011\u001d\t9\u000e\u0001C\u0005\u00033\f!bZ3u-\u0016\u00148/[8o)\u0011\tY+a7\t\u000f\u0005u\u0017Q\u001ba\u0001%\u00059a/\u001a:tS>t\u0007bBAq\u0001\u0011%\u00111]\u0001\ra\u0006\u00148/\u001a(p%\u0016\u0004H.\u001f\u000b\u0006'\u0006\u0015\u0018\u0011\u001e\u0005\t\u0003O\fy\u000e1\u0001\u0002B\u0006iQ\r\u001f9fGR,G-\u00138eKbD\u0001\"a\u001e\u0002`\u0002\u0007\u0011\u0011\u0007\u0005\b\u0003[\u0004A\u0011BAx\u0003Y\u0001\u0018M]:f\t\u0016d\u0017-_3e\t\u0016dW\r^3US6,G\u0003BAa\u0003cD\u0001\"a\u001e\u0002l\u0002\u0007\u0011\u0011\u0007\u0005\b\u0003k\u0004A\u0011IA|\u0003!9W\r^\"bG\",W#\u0001\u0015\t\u000f\u0005m\b\u0001\"\u0015\u0002~\u0006\u00112-^:u_6$UmY8eK\"+\u0017\rZ3s)\u0019\ty$a@\u0003\u0002!A\u0011qLA}\u0001\u0004\t\t\u0007\u0003\u0005\u0002\f\u0005e\b\u0019AA\u0007\u0011\u001d\u0011)\u0001\u0001C)\u0005\u000f\tqbY;ti>lG)Z2pI\u0016\\U-\u001f\u000b\u0007\u0003\u007f\u0011IAa\u0003\t\u0011\u0005}#1\u0001a\u0001\u0003CB\u0001\"a\u0003\u0003\u0004\u0001\u0007\u0011Q\u0002\u0005\b\u0005\u001f\u0001A\u0011\u000bB\t\u0003E\u0019Wo\u001d;p[\u0012+7m\u001c3f-\u0006dW/\u001a\u000b\u0007\u0003\u007f\u0011\u0019B!\u0006\t\u0011\u0005}#Q\u0002a\u0001\u0003CB\u0001\"a\u0003\u0003\u000e\u0001\u0007\u0011Q\u0002\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0003!Ign\u0019:EK\u000e\u0014H\u0003BA \u0005;A\u0001\"a\u0018\u0003\u0018\u0001\u0007\u0011\u0011\r\u0005\b\u0005C\u0001A\u0011\u0002B\u0012\u0003!1G.^:i\u00032dG\u0003CA \u0005K\u00119C!\u000b\t\u0011\u0005%\"q\u0004a\u0001\u0003\u001bA\u0001\"a\u0018\u0003 \u0001\u0007\u0011\u0011\r\u0005\b\u0005W\u0011y\u00021\u0001T\u00031I7OU3bIB\u000b'/Y7t\u0011\u001d\u0011y\u0003\u0001C\u0005\u0005c\tQB^1mS\u0012\fG/\u001a#fYR\fG\u0003\u0002B\u001a\u0005\u0017\u0002BA!\u000e\u0003F9!!q\u0007B!\u001d\u0011\u0011IDa\u0010\u000e\u0005\tm\"b\u0001B\u001f\u0015\u00051AH]8pizJ\u0011AF\u0005\u0004\u0005\u0007*\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005\u000f\u0012IE\u0001\u0004CS\u001eLe\u000e\u001e\u0006\u0004\u0005\u0007*\u0002b\u0002B'\u0005[\u0001\rAE\u0001\u0006I\u0016dG/\u0019\u0005\b\u0005#\u0002A\u0011\tB*\u0003U\u0019'/Z1uKN+8mY3tgJ+7\u000f]8og\u0016$B!a\u0010\u0003V!9!q\u000bB(\u0001\u0004a\u0012\u0001\u00029sKZDqAa\u0017\u0001\t\u0003\u0012i&A\rde\u0016\fG/\u001a(pi\u0016CXmY;uK\u0012\u0014Vm\u001d9p]N,G\u0003BA \u0005?BqAa\u0016\u0003Z\u0001\u0007A\u0004C\u0004\u0003d\u0001!\tE!\u001a\u0002-\r\u0014X-\u0019;f\u001d>$X\t_5tiJ+7\u000f]8og\u0016,\"!a\u0010\t\u000f\t%\u0004\u0001\"\u0011\u0003l\u0005\t2M]3bi\u0016<U\r\u001e*fgB|gn]3\u0015\r\u0005}\"Q\u000eB8\u0011\u001d\tyEa\u001aA\u0002IAqA!\u001d\u0003h\u0001\u0007A$A\u0001w\u0011\u001d\u0011)\b\u0001C!\u0005o\nac\u0019:fCR,W*\u001e7uS\u001e+GOU3ta>t7/\u001a\u000b\u0005\u0003\u007f\u0011I\b\u0003\u0005\u0003|\tM\u0004\u0019\u0001B?\u0003\u0015\u0001\u0018-\u001b:t!\u0015\u0019\"q\u0010\n\u001d\u0013\r\u0011\ti\u0007\u0002\u0004\u001b\u0006\u0004\bb\u0002BC\u0001\u0011\u0005#qQ\u0001\u0014GJ,\u0017\r^3FeJ|'OU3ta>t7/\u001a\u000b\u0005\u0003\u007f\u0011I\t\u0003\u0005\u0003\f\n\r\u0005\u0019\u0001BG\u0003\u0005!\b\u0003\u0002B\u001b\u0005\u001fKAA!%\u0003J\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\b\u0005+\u0003A\u0011\u000bBL\u0003U\u0019'/Z1uKN+'O^3s\u000bb\u001cW\r\u001d;j_:$bA!'\u0003\"\n-\u0006#\u0002\u000b\u0000\u00057\u001b\u0006cA\u000f\u0003\u001e&\u0019!q\u0014\u0002\u0003%5+WnY1dQ\u0016$W\t_2faRLwN\u001c\u0005\t\u0005G\u0013\u0019\n1\u0001\u0003&\u0006\tQ\r\u0005\u0003\u00036\t\u001d\u0016\u0002\u0002BU\u0005\u0013\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\t\u0011\u0005%\"1\u0013a\u0001\u0003\u001bAqAa,\u0001\t\u0013\u0011\t,\u0001\u0007dY>\u001cXm\u00115b]:,G\u000e\u0006\u0003\u0002@\tM\u0006\u0002CA0\u0005[\u0003\r!!\u0019\t\u000f\t]\u0006\u0001\"\u0011\u0003f\u0005\u00192M]3bi\u0016\u001cF/\u0019;t%\u0016\u001c\bo\u001c8tK\"9!1\u0018\u0001\u0005\n\tu\u0016!\u00032vS2$7\u000b^1u)!\tiAa0\u0003D\n5\u0007b\u0002Ba\u0005s\u0003\rAE\u0001\u0005gR\fG\u000f\u0003\u0005\u0003F\ne\u0006\u0019\u0001Bd\u0003\u00151\u0018\r\\;f!\r!\"\u0011Z\u0005\u0004\u0005\u0017,\"aA!os\"A!q\u001aB]\u0001\u0004\u0011\t.\u0001\u0002tEB!!Q\u0007Bj\u0013\u0011\u0011)N!\u0013\u0003\u001bM#(/\u001b8h\u0005VLG\u000eZ3s\u0011\u001d\t\u0019\u000b\u0001C\u0005\u00053$r\u0001\bBn\u0005O\u0014I\u000f\u0003\u0005\u0003^\n]\u0007\u0019\u0001Bp\u0003\u0011!\u0017\r^1\u0011\u000bQ\t\u0019D!9\u0011\u0007Q\u0011\u0019/C\u0002\u0003fV\u0011AAQ=uK\"A\u0011\u0011\u0016Bl\u0001\u0004\tY\u000b\u0003\u0005\u0002:\n]\u0007\u0019AAV\u0011\u001d\u0011i\u000f\u0001C\u0005\u0005_\f\u0001CY;jY\u0012<U\r\u001e*fgB|gn]3\u0015\u0011\u00055!\u0011_B\u0001\u0007\u0007A\u0001Ba=\u0003l\u0002\u0007!Q_\u0001\u0003_B\u0004BAa>\u0003~B\u0019AC!?\n\u0007\tmXCA\u0006F]VlWM]1uS>t\u0017\u0002\u0002B\u0000\u0005s\u0014QAV1mk\u0016Dq!a\u0014\u0003l\u0002\u0007!\u0003C\u0004\u0003r\t-\b\u0019\u0001\u000f\t\u000f\r\u001d\u0001\u0001\"\u0003\u0004\n\u00051\"-^5mI\u001e+GOU3ta>t7/\u001a%fC\u0012,'\u000fF\u0004\u0013\u0007\u0017\u0019iaa\u0004\t\u000f\u0005=3Q\u0001a\u0001%!9!\u0011OB\u0003\u0001\u0004a\u0002\u0002\u0003Bz\u0007\u000b\u0001\rA!>\t\u000f\rM\u0001\u0001\"\u0003\u0004\u0016\u0005\u0019bM]5f]\u0012d\u00170T1y\u0013:$8\t[3dWR1\u0011\u0011YB\f\u00077Aqa!\u0007\u0004\u0012\u0001\u0007!#\u0001\u0004ok6\u0014WM\u001d\u0005\b\u0007;\u0019\t\u00021\u0001\u0013\u0003\u001diWm]:bO\u0016Dqa!\t\u0001\t\u0013\u0019\u0019#A\tok6,'/[2MS6LGo\u00115fG.$\"\"!1\u0004&\r\u001d21FB\u0017\u0011\u001d\u0019Iba\bA\u0002IA\u0001b!\u000b\u0004 \u0001\u0007\u00111V\u0001\t[\u0006Dh+\u00197vK\"91QDB\u0010\u0001\u0004\u0011\u0002\u0002CB\u0018\u0007?\u0001\ra!\r\u0002\u00039\u0004BA!\u000e\u00044%!1Q\u0007B%\u0005UqU/\u001c2fe\u001a{'/\\1u\u000bb\u001cW\r\u001d;j_:Dqa!\t\u0001\t\u0013\u0019I\u0004\u0006\u0005\u0002,\u000em2QHB \u0011\u001d\u0019Iba\u000eA\u0002IA\u0001b!\u000b\u00048\u0001\u0007\u00111\u0016\u0005\b\u0007;\u00199\u00041\u0001\u0013\u0001")
public class MemcachedDecoder
extends AbstractProtocolDecoder<String, MemcachedValue>
implements TextProtocolUtil,
ScalaObject {
    private final ScheduledExecutorService scheduler;
    private final NettyTransport transport;
    private boolean isStatsEnabled;
    private final AtomicLong incrMisses;
    private final AtomicLong incrHits;
    private final AtomicLong decrMisses;
    private final AtomicLong decrHits;
    private final AtomicLong replaceIfUnmodifiedMisses;
    private final AtomicLong replaceIfUnmodifiedHits;
    private final AtomicLong replaceIfUnmodifiedBadval;
    private final String CRLF;
    private final byte[] CRLFBytes;
    private final byte[] END;
    private final byte[] DELETED;
    private final byte[] NOT_FOUND;
    private final byte[] EXISTS;
    private final byte[] STORED;
    private final byte[] NOT_STORED;
    private final byte[] OK;
    private final byte[] ERROR;
    private final String CLIENT_ERROR_BAD_FORMAT;
    private final String SERVER_ERROR;
    private final int CR;
    private final int LF;
    private final BigInt MAX_UNSIGNED_LONG;
    private final BigInt MIN_UNSIGNED;
    public volatile int bitmap$0;

    @Override
    public String CRLF() {
        return this.CRLF;
    }

    @Override
    public byte[] CRLFBytes() {
        return this.CRLFBytes;
    }

    @Override
    public byte[] END() {
        return this.END;
    }

    @Override
    public byte[] DELETED() {
        return this.DELETED;
    }

    @Override
    public byte[] NOT_FOUND() {
        return this.NOT_FOUND;
    }

    @Override
    public byte[] EXISTS() {
        return this.EXISTS;
    }

    @Override
    public byte[] STORED() {
        return this.STORED;
    }

    @Override
    public byte[] NOT_STORED() {
        return this.NOT_STORED;
    }

    @Override
    public byte[] OK() {
        return this.OK;
    }

    @Override
    public byte[] ERROR() {
        return this.ERROR;
    }

    @Override
    public String CLIENT_ERROR_BAD_FORMAT() {
        return this.CLIENT_ERROR_BAD_FORMAT;
    }

    @Override
    public String SERVER_ERROR() {
        return this.SERVER_ERROR;
    }

    @Override
    public int CR() {
        return this.CR;
    }

    @Override
    public int LF() {
        return this.LF;
    }

    @Override
    public BigInt MAX_UNSIGNED_LONG() {
        return this.MAX_UNSIGNED_LONG;
    }

    @Override
    public BigInt MIN_UNSIGNED() {
        return this.MIN_UNSIGNED;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CRLF_$eq(String string) {
        this.CRLF = string;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CRLFBytes_$eq(byte[] byArray) {
        this.CRLFBytes = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$END_$eq(byte[] byArray) {
        this.END = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$DELETED_$eq(byte[] byArray) {
        this.DELETED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$NOT_FOUND_$eq(byte[] byArray) {
        this.NOT_FOUND = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$EXISTS_$eq(byte[] byArray) {
        this.EXISTS = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$STORED_$eq(byte[] byArray) {
        this.STORED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$NOT_STORED_$eq(byte[] byArray) {
        this.NOT_STORED = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$OK_$eq(byte[] byArray) {
        this.OK = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$ERROR_$eq(byte[] byArray) {
        this.ERROR = byArray;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CLIENT_ERROR_BAD_FORMAT_$eq(String string) {
        this.CLIENT_ERROR_BAD_FORMAT = string;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$SERVER_ERROR_$eq(String string) {
        this.SERVER_ERROR = string;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$CR_$eq(int n) {
        this.CR = n;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$LF_$eq(int n) {
        this.LF = n;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$MAX_UNSIGNED_LONG_$eq(BigInt bigInt) {
        this.MAX_UNSIGNED_LONG = bigInt;
    }

    @Override
    public void org$infinispan$server$memcached$TextProtocolUtil$_setter_$MIN_UNSIGNED_$eq(BigInt bigInt) {
        this.MIN_UNSIGNED = bigInt;
    }

    @Override
    public Tuple2<String, Boolean> readElement(ChannelBuffer buffer) {
        return TextProtocolUtil$class.readElement(this, buffer);
    }

    @Override
    public String readLine(ChannelBuffer buffer) {
        return TextProtocolUtil$class.readLine(this, buffer);
    }

    @Override
    public byte[] concat(byte[] a, byte[] b) {
        return TextProtocolUtil$class.concat(this, a, b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStatsEnabled() {
        if ((this.bitmap$0 & 4) != 0) return this.isStatsEnabled;
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if ((this.bitmap$0 & 4) == 0) {
                this.isStatsEnabled = this.cache().getConfiguration().isExposeJmxStatistics();
                this.bitmap$0 |= 4;
            }
            return this.isStatsEnabled;
        }
    }

    private final AtomicLong incrMisses() {
        return this.incrMisses;
    }

    private final AtomicLong incrHits() {
        return this.incrHits;
    }

    private final AtomicLong decrMisses() {
        return this.decrMisses;
    }

    private final AtomicLong decrHits() {
        return this.decrHits;
    }

    private final AtomicLong replaceIfUnmodifiedMisses() {
        return this.replaceIfUnmodifiedMisses;
    }

    private final AtomicLong replaceIfUnmodifiedHits() {
        return this.replaceIfUnmodifiedHits;
    }

    private final AtomicLong replaceIfUnmodifiedBadval() {
        return this.replaceIfUnmodifiedBadval;
    }

    public Tuple2<Option<RequestHeader>, Boolean> readHeader(ChannelBuffer buffer) {
        Option<Enumeration.Value> op;
        Tuple2<String, Boolean> tuple2 = this.readElement(buffer);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String streamOp = (String)tuple22._1();
        boolean endOfOp = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
        Option<Enumeration.Value> option = op = RequestResolver$.MODULE$.toRequest(streamOp);
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
            Object object = endOfOp ? BoxedUnit.UNIT : this.readLine(buffer);
            throw new UnknownOperationException(new StringBuilder().append((Object)"Unknown operation: ").append((Object)streamOp).toString());
        }
        Object object = op.get();
        Enumeration.Value value = Operation$.MODULE$.StatsRequest();
        if (!(object != null ? !object.equals(value) : value != null) && !endOfOp) {
            String line = this.readLine(buffer).trim();
            if (line.isEmpty()) {
                endOfOp = true;
            } else {
                throw new StreamCorruptedException(new StringBuilder().append((Object)"Stats command does not accept arguments: ").append((Object)line).toString());
            }
        }
        Object object2 = op.get();
        Enumeration.Value value2 = MemcachedOperation$.MODULE$.VerbosityRequest();
        if (!(object2 != null ? !object2.equals(value2) : value2 != null)) {
            Object object3 = endOfOp ? BoxedUnit.UNIT : this.readLine(buffer);
            throw new StreamCorruptedException("Memcached 'verbosity' command is unsupported");
        }
        return new Tuple2((Object)new Some((Object)new RequestHeader((Enumeration.Value)op.get())), (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    public Tuple2<String, Boolean> readKey(ChannelBuffer b) {
        Tuple2<String, Boolean> tuple2 = this.readElement(b);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String k = (String)tuple22._1();
        boolean endOfOp = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
        this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, endOfOp, b);
        return new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    private String[] readKeys(ChannelBuffer b) {
        return this.readLine(b).trim().split(" +");
    }

    public Object get(ChannelBuffer buffer$1) {
        Object object;
        String[] keys = this.readKeys(buffer$1);
        if (keys.length > 1) {
            scala.collection.mutable.HashMap map$1 = new scala.collection.mutable.HashMap();
            Predef$.MODULE$.refArrayOps((Object[])keys).foreach((Function1)new $anonfun$get$1(this, buffer$1, map$1));
            object = this.createMultiGetResponse((Map<String, MemcachedValue>)new HashMap().$plus$plus((TraversableOnce)map$1));
        } else {
            object = this.createGetResponse((String)Predef$.MODULE$.refArrayOps((Object[])keys).head(), (MemcachedValue)this.cache().get(this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength((String)Predef$.MODULE$.refArrayOps((Object[])keys).head(), true, buffer$1)));
        }
        return object;
    }

    public final String org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(String k, boolean endOfOp, ChannelBuffer b) {
        if (k.length() > 250) {
            Object object = endOfOp ? BoxedUnit.UNIT : this.readLine(b);
            throw new StreamCorruptedException("Key length over the 250 character limit");
        }
        return k;
    }

    public boolean readParameters(Channel ch, ChannelBuffer b$1) {
        MemcachedParameters memcachedParameters;
        String line$1 = this.readLine(b$1);
        BooleanRef endOfOp$1 = new BooleanRef(false);
        if (line$1.isEmpty()) {
            memcachedParameters = null;
        } else {
            if (this.isTraceEnabled()) {
                this.trace((Function0)new $anonfun$readParameters$1(this), line$1);
            }
            String[] args$1 = line$1.trim().split(" +");
            memcachedParameters = this.liftedTree1$1(b$1, line$1, endOfOp$1, args$1);
        }
        this.params_$eq(memcachedParameters);
        return endOfOp$1.elem;
    }

    private MemcachedParameters readRemoveParameters(String[] args) {
        int delayedDeleteTime = this.parseDelayedDeleteTime(args);
        boolean noReply = delayedDeleteTime == -1 ? this.parseNoReply(0, args) : false;
        return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", 0);
    }

    private MemcachedParameters readIncrDecrParameters(String[] args) {
        String delta = args[0];
        return new MemcachedParameters(-1, -1, -1, -1L, this.parseNoReply(1, args), 0L, delta, 0);
    }

    private MemcachedParameters readFlushAllParameters(String[] args) {
        NumberFormatException numberFormatException2;
        block2: {
            boolean noReplyFound = false;
            int exceptionResult1 = 0;
            try {
                exceptionResult1 = this.friendlyMaxIntCheck(args[0], "Flush delay");
            }
            catch (NumberFormatException numberFormatException2) {
                if (!numberFormatException2.getMessage().contains("noreply")) break block2;
                noReplyFound = true;
                exceptionResult1 = 0;
            }
            int flushDelay = exceptionResult1;
            boolean noReply = noReplyFound ? true : this.parseNoReply(1, args);
            return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", flushDelay);
        }
        throw numberFormatException2;
    }

    private MemcachedParameters readStorageParameters(String[] args, ChannelBuffer b) {
        Enumeration.Value value;
        int length;
        int streamLifespan;
        int index = 0;
        long flags = this.getFlags(args[index]);
        if (flags < 0L) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Flags cannot be negative: ").append((Object)BoxesRunTime.boxToLong((long)flags)).toString());
        }
        int lifespan = (streamLifespan = this.getLifespan(args[++index])) <= 0 ? -1 : streamLifespan;
        if ((length = this.getLength(args[++index])) < 0) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Negative bytes length provided: ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString());
        }
        Enumeration.Value value2 = value = this.header().op();
        Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
        long streamVersion = !(value2 != null ? !value2.equals(value3) : value3 != null) ? this.getVersion(args[++index]) : -1L;
        boolean noReply = this.parseNoReply(++index, args);
        return new MemcachedParameters(length, lifespan, -1, streamVersion, noReply, flags, "", 0);
    }

    public void readValue(ChannelBuffer b) {
        b.readBytes(this.rawValue());
        this.readLine(b);
    }

    public MemcachedValue createValue(long nextVersion) {
        return new MemcachedValue(this.rawValue(), nextVersion, ((MemcachedParameters)this.params()).flags());
    }

    /*
     * WARNING - void declaration
     */
    private long getFlags(String flags) {
        void var2_2;
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        long exceptionResult2 = 0L;
        try {
            exceptionResult2 = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags");
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult2 = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags", numberFormatException);
        }
        return (long)var2_2;
    }

    private int getLifespan(String lifespan) {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return this.friendlyMaxIntCheck(lifespan, "Lifespan");
    }

    private int getLength(String length) {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return this.friendlyMaxIntCheck(length, "The number of bytes");
    }

    private long getVersion(String version) {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return Predef$.MODULE$.augmentString(version).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNoReply(int expectedIndex, String[] args) {
        if (args.length <= expectedIndex) return false;
        String string = args[expectedIndex];
        if ("noreply" != null) {
            if (!"noreply".equals(string)) throw new StreamCorruptedException("Unable to parse noreply optional argument");
            return true;
        }
        if (string == null) return true;
        throw new StreamCorruptedException("Unable to parse noreply optional argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDelayedDeleteTime(String[] args) {
        int n;
        if (args.length <= 0) return 0;
        int exceptionResult3 = 0;
        try {
            n = exceptionResult3 = Predef$.MODULE$.augmentString(args[0]).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public Cache<String, MemcachedValue> getCache() {
        return this.cache();
    }

    public Object customDecodeHeader(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        Enumeration.Value value2 = value = this.header().op();
                        Enumeration.Value value3 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        object = this.flushAll(buffer, ch, false);
                        break block3;
                    }
                    Enumeration.Value value4 = value;
                    Enumeration.Value value5 = MemcachedOperation$.MODULE$.VersionRequest();
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    StringBuilder ret = new StringBuilder().append("VERSION ").append(Version.VERSION).append(this.CRLF());
                    object = this.writeResponse(ch, ret);
                    break block3;
                }
                Enumeration.Value value6 = value;
                Enumeration.Value value7 = MemcachedOperation$.MODULE$.QuitRequest();
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                object = this.closeChannel(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeKey(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block5: {
            Object object;
            block4: {
                block3: {
                    block2: {
                        Enumeration.Value value2 = value = this.header().op();
                        Enumeration.Value value3 = MemcachedOperation$.MODULE$.AppendRequest();
                        if (!(value2 == null ? value3 != null : !value2.equals(value3))) break block2;
                        Enumeration.Value value4 = value;
                        Enumeration.Value value5 = MemcachedOperation$.MODULE$.PrependRequest();
                        if (!(value4 == null ? value5 != null : !value4.equals(value5))) break block2;
                        Enumeration.Value value6 = value;
                        Enumeration.Value value7 = MemcachedOperation$.MODULE$.IncrementRequest();
                        if (!(value6 == null ? value7 != null : !value6.equals(value7))) break block2;
                        Enumeration.Value value8 = value;
                        Enumeration.Value value9 = MemcachedOperation$.MODULE$.DecrementRequest();
                        if (value8 != null ? !value8.equals(value9) : value9 != null) break block3;
                    }
                    this.key_$eq(this.readKey(buffer)._1());
                    object = this.checkpointTo(DecoderState.DECODE_PARAMETERS);
                    break block4;
                }
                Enumeration.Value value10 = value;
                Enumeration.Value value11 = MemcachedOperation$.MODULE$.FlushAllRequest();
                if (value10 != null ? !value10.equals(value11) : value11 != null) break block5;
                object = this.flushAll(buffer, ch, true);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeValue(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block15: {
            Object object;
            block13: {
                block14: {
                    block7: {
                        Enumeration.Value value2;
                        block12: {
                            Object object2;
                            block9: {
                                byte[] byArray;
                                MemcachedValue prev;
                                block11: {
                                    block10: {
                                        block8: {
                                            block6: {
                                                Enumeration.Value op;
                                                Enumeration.Value value3 = value = (op = this.header().op());
                                                Enumeration.Value value4 = MemcachedOperation$.MODULE$.AppendRequest();
                                                if (!(value3 == null ? value4 != null : !value3.equals(value4))) break block6;
                                                Enumeration.Value value5 = value;
                                                Enumeration.Value value6 = MemcachedOperation$.MODULE$.PrependRequest();
                                                if (value5 != null ? !value5.equals(value6) : value6 != null) break block7;
                                            }
                                            this.readValue(buffer);
                                            prev = (MemcachedValue)this.cache().get(this.key());
                                            if (prev != null) break block8;
                                            object2 = ((MemcachedParameters)this.params()).noReply() ? null : this.NOT_STORED();
                                            break block9;
                                        }
                                        Enumeration.Value value7 = value2 = this.header().op();
                                        Enumeration.Value value8 = MemcachedOperation$.MODULE$.AppendRequest();
                                        if (value7 != null ? !value7.equals(value8) : value8 != null) break block10;
                                        byArray = this.concat(prev.data(), this.rawValue());
                                        break block11;
                                    }
                                    Enumeration.Value value9 = value2;
                                    Enumeration.Value value10 = MemcachedOperation$.MODULE$.PrependRequest();
                                    if (value9 != null ? !value9.equals(value10) : value10 != null) break block12;
                                    byArray = this.concat(this.rawValue(), prev.data());
                                }
                                byte[] concatenated = byArray;
                                MemcachedValue next = this.createValue(concatenated, this.generateVersion(this.cache()), ((MemcachedParameters)this.params()).flags());
                                boolean replaced = this.cache().replace(this.key(), prev, next);
                                object2 = replaced ? (Object)(((MemcachedParameters)this.params()).noReply() ? null : this.STORED()) : (Object)(((MemcachedParameters)this.params()).noReply() ? null : this.NOT_STORED());
                            }
                            byte[] ret = object2;
                            object = this.writeResponse(ch, ret);
                            break block13;
                        }
                        throw new MatchError((Object)value2);
                    }
                    Enumeration.Value value11 = value;
                    Enumeration.Value value12 = MemcachedOperation$.MODULE$.IncrementRequest();
                    if (!(value11 == null ? value12 != null : !value11.equals(value12))) break block14;
                    Enumeration.Value value13 = value;
                    Enumeration.Value value14 = MemcachedOperation$.MODULE$.DecrementRequest();
                    if (value13 != null ? !value13.equals(value14) : value14 != null) break block15;
                }
                object = this.incrDecr(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    private Object incrDecr(Channel ch) {
        Enumeration.Value value;
        block9: {
            BigInt prevCounter;
            block10: {
                Object object;
                block6: {
                    Object object2;
                    Enumeration.Value op;
                    MemcachedValue prev;
                    block8: {
                        BigInt delta;
                        block7: {
                            block5: {
                                Object object3;
                                prev = (MemcachedValue)this.cache().get(this.key());
                                op = this.header().op();
                                if (prev != null) break block5;
                                if (this.isStatsEnabled()) {
                                    Enumeration.Value value2 = op;
                                    Enumeration.Value value3 = MemcachedOperation$.MODULE$.IncrementRequest();
                                    object3 = BoxesRunTime.boxToLong((long)(!(value2 != null ? !value2.equals(value3) : value3 != null) ? this.incrMisses().incrementAndGet() : this.decrMisses().incrementAndGet()));
                                } else {
                                    object3 = BoxedUnit.UNIT;
                                }
                                object = ((MemcachedParameters)this.params()).noReply() ? null : this.NOT_FOUND();
                                break block6;
                            }
                            prevCounter = package$.MODULE$.BigInt().apply(new String(prev.data()));
                            delta = this.validateDelta(((MemcachedParameters)this.params()).delta());
                            Enumeration.Value value4 = value = op;
                            Enumeration.Value value5 = MemcachedOperation$.MODULE$.IncrementRequest();
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block7;
                            BigInt candidateCounter = prevCounter.$plus(delta);
                            object2 = candidateCounter.$greater(this.MAX_UNSIGNED_LONG()) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                            break block8;
                        }
                        Enumeration.Value value6 = value;
                        Enumeration.Value value7 = MemcachedOperation$.MODULE$.DecrementRequest();
                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block9;
                        BigInt candidateCounter = prevCounter.$minus(delta);
                        object2 = candidateCounter.$less(BigInt$.MODULE$.int2bigInt(0)) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                    }
                    Object newCounter = object2;
                    MemcachedValue next = this.createValue(newCounter.toString().getBytes(), this.generateVersion(this.cache()), ((MemcachedParameters)this.params()).flags());
                    boolean replaced = this.cache().replace(this.key(), prev, next);
                    if (replaced) {
                        Object object4;
                        if (this.isStatsEnabled()) {
                            Enumeration.Value value8 = op;
                            Enumeration.Value value9 = MemcachedOperation$.MODULE$.IncrementRequest();
                            object4 = BoxesRunTime.boxToLong((long)(!(value8 != null ? !value8.equals(value9) : value9 != null) ? this.incrHits().incrementAndGet() : this.decrHits().incrementAndGet()));
                        } else {
                            object4 = BoxedUnit.UNIT;
                        }
                        object = ((MemcachedParameters)this.params()).noReply() ? null : (Object)new StringBuilder().append((Object)new String(next.data())).append((Object)this.CRLF()).toString();
                    }
                    break block10;
                }
                byte[] ret = object;
                return this.writeResponse(ch, ret);
            }
            throw new CacheException(new StringBuilder().append((Object)"Value modified since we retrieved from the cache, old value was ").append((Object)prevCounter).toString());
        }
        throw new MatchError((Object)value);
    }

    private Object flushAll(ChannelBuffer b, Channel ch, boolean isReadParams) {
        Object object = isReadParams ? BoxesRunTime.boxToBoolean((boolean)this.readParameters(ch, b)) : BoxedUnit.UNIT;
        $anonfun$1 flushFunction = new $anonfun$1(this);
        int flushDelay = this.params() == null ? 0 : ((MemcachedParameters)this.params()).flushDelay();
        ScheduledFuture<?> scheduledFuture = flushDelay == 0 ? flushFunction.apply(this.cache().getAdvancedCache()) : this.scheduler.schedule(new DelayedFlushAll((Cache<String, MemcachedValue>)this.cache(), (Function1<AdvancedCache<String, MemcachedValue>, Object>)flushFunction), this.toMillis(flushDelay), TimeUnit.MILLISECONDS);
        byte[] ret = (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : this.OK());
        return this.writeResponse(ch, ret);
    }

    /*
     * WARNING - void declaration
     */
    private BigInt validateDelta(String delta) {
        void var2_2;
        BigInt bigIntDelta = package$.MODULE$.BigInt().apply(delta);
        if (bigIntDelta.$greater(this.MAX_UNSIGNED_LONG())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta sent (").append((Object)delta).append((Object)") exceeds unsigned limit (").append((Object)this.MAX_UNSIGNED_LONG()).append((Object)")").toString());
        }
        if (bigIntDelta.$less(this.MIN_UNSIGNED())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta cannot be negative: ").append((Object)delta).toString());
        }
        return var2_2;
    }

    public Object createSuccessResponse(MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value;
            Enumeration.Value value2 = value = this.header().op();
            Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedHits().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value;
            Enumeration.Value value4 = value = this.header().op();
            Enumeration.Value value5 = Operation$.MODULE$.RemoveRequest();
            byArray = !(value4 != null ? !value4.equals(value5) : value5 != null) ? this.DELETED() : this.STORED();
        }
        return byArray;
    }

    public Object createNotExecutedResponse(MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value;
            Enumeration.Value value2 = value = this.header().op();
            Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedBadval().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value;
            Enumeration.Value value4 = value = this.header().op();
            Enumeration.Value value5 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            byArray = !(value4 != null ? !value4.equals(value5) : value5 != null) ? this.EXISTS() : this.NOT_STORED();
        }
        return byArray;
    }

    public Object createNotExistResponse() {
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value;
            Enumeration.Value value2 = value = this.header().op();
            Enumeration.Value value3 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedMisses().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : this.NOT_FOUND());
    }

    public Object createGetResponse(String k, MemcachedValue v) {
        return v == null ? this.END() : (byte[])List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(this.header().op(), k, v), ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()}))}));
    }

    public Object createMultiGetResponse(Map<String, MemcachedValue> pairs) {
        Enumeration.Value value;
        block3: {
            Enumeration.Value op$1;
            ListBuffer elements$1;
            block2: {
                elements$1 = new ListBuffer();
                Enumeration.Value value2 = value = (op$1 = this.header().op());
                Enumeration.Value value3 = Operation$.MODULE$.GetRequest();
                if (!(value2 == null ? value3 != null : !value2.equals(value3))) break block2;
                Enumeration.Value value4 = value;
                Enumeration.Value value5 = Operation$.MODULE$.GetWithVersionRequest();
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block3;
            }
            pairs.foreach((Function1)new $anonfun$createMultiGetResponse$1(this, elements$1, op$1));
            elements$1.$plus$eq((Object)ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()})));
            return elements$1.toList();
        }
        throw new MatchError((Object)value);
    }

    public Object createErrorResponse(Throwable t) {
        Object object;
        StringBuilder sb = new StringBuilder();
        Throwable throwable = t;
        if (throwable instanceof MemcachedException) {
            MemcachedException memcachedException = (MemcachedException)throwable;
            MemcachedException m = memcachedException;
            Throwable throwable2 = m.getCause();
            if (throwable2 instanceof UnknownOperationException) {
                this.logExceptionReported((Throwable)((UnknownOperationException)throwable2));
                object = this.ERROR();
            } else if (throwable2 instanceof ClosedChannelException) {
                this.logExceptionReported((ClosedChannelException)throwable2);
                object = null;
            } else if (throwable2 instanceof IOException) {
                this.logExceptionReported((IOException)throwable2);
                object = sb.append(m.getMessage()).append(this.CRLF());
            } else if (throwable2 instanceof NumberFormatException) {
                this.logExceptionReported((NumberFormatException)throwable2);
                object = sb.append(m.getMessage()).append(this.CRLF());
            } else {
                object = sb.append(m.getMessage()).append(this.CRLF());
            }
        } else if (throwable instanceof ClosedChannelException) {
            this.logExceptionReported((ClosedChannelException)throwable);
            object = null;
        } else {
            object = sb.append(this.SERVER_ERROR()).append(t.getMessage()).append(this.CRLF());
        }
        return object;
    }

    public Tuple2<MemcachedException, Boolean> createServerException(Exception e, ChannelBuffer b) {
        Tuple2 tuple2;
        Exception exception = e;
        if (exception instanceof IOException) {
            IOException iOException;
            IOException i = iOException = (IOException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)this.CLIENT_ERROR_BAD_FORMAT()).append((Object)i.getMessage()).toString(), i), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (exception instanceof NumberFormatException) {
            NumberFormatException numberFormatException;
            NumberFormatException n = numberFormatException = (NumberFormatException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)this.CLIENT_ERROR_BAD_FORMAT()).append((Object)n.getMessage()).toString(), n), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)this.SERVER_ERROR()).append((Object)e).toString(), e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple2;
    }

    private Object closeChannel(Channel ch) {
        ch.close();
        return null;
    }

    public Object createStatsResponse() {
        Stats stats = this.cache().getAdvancedCache().getStats();
        StringBuilder sb = new StringBuilder();
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.buildStat("pid", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("time", BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())), sb), this.buildStat("version", this.cache().getVersion(), sb), this.buildStat("pointer_size", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_user", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_system", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_items", BoxesRunTime.boxToInteger((int)stats.getCurrentNumberOfEntries()), sb), this.buildStat("total_items", BoxesRunTime.boxToLong((long)stats.getTotalNumberOfEntries()), sb), this.buildStat("bytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("total_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("connection_structures", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("cmd_get", BoxesRunTime.boxToLong((long)stats.getRetrievals()), sb), this.buildStat("cmd_set", BoxesRunTime.boxToLong((long)stats.getStores()), sb), this.buildStat("get_hits", BoxesRunTime.boxToLong((long)stats.getHits()), sb), this.buildStat("get_misses", BoxesRunTime.boxToLong((long)stats.getMisses()), sb), this.buildStat("delete_misses", BoxesRunTime.boxToLong((long)stats.getRemoveMisses()), sb), this.buildStat("delete_hits", BoxesRunTime.boxToLong((long)stats.getRemoveHits()), sb), this.buildStat("incr_misses", this.incrMisses(), sb), this.buildStat("incr_hits", this.incrHits(), sb), this.buildStat("decr_misses", this.decrMisses(), sb), this.buildStat("decr_hits", this.decrHits(), sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses(), sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits(), sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval(), sb), this.buildStat("auth_cmds", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("auth_errors", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("evictions", BoxesRunTime.boxToLong((long)stats.getEvictions()), sb), this.buildStat("bytes_read", this.transport.getTotalBytesRead(), sb), this.buildStat("bytes_written", this.transport.getTotalBytesWritten(), sb), this.buildStat("limit_maxbytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("threads", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("conn_yields", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("reclaimed", BoxesRunTime.boxToInteger((int)0), sb), ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()}))}));
    }

    private ChannelBuffer buildStat(String stat, Object value, StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append(this.CRLF());
        ChannelBuffer buffer = ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sb.toString().getBytes()}));
        sb.setLength(0);
        return buffer;
    }

    private MemcachedValue createValue(byte[] data, long nextVersion, long flags) {
        return new MemcachedValue(data, nextVersion, flags);
    }

    public final ChannelBuffer org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(Enumeration.Value op, String k, MemcachedValue v) {
        String header = this.buildGetResponseHeader(k, v, op);
        return ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{header.getBytes(), v.data(), this.CRLFBytes()}));
    }

    private String buildGetResponseHeader(String k, MemcachedValue v, Enumeration.Value op) {
        StringBuilder sb = new StringBuilder();
        sb.append("VALUE ").append(k).append(" ").append(v.flags()).append(" ").append(v.data().length);
        Enumeration.Value value = op;
        Enumeration.Value value2 = Operation$.MODULE$.GetWithVersionRequest();
        Object object = !(value != null ? !value.equals(value2) : value2 != null) ? sb.append(" ").append(v.version()) : BoxedUnit.UNIT;
        sb.append(this.CRLF());
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private int friendlyMaxIntCheck(String number, String message) {
        void var3_3;
        int exceptionResult4 = 0;
        try {
            exceptionResult4 = Predef$.MODULE$.augmentString(number).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult4 = this.numericLimitCheck(number, Integer.MAX_VALUE, message, numberFormatException);
        }
        return (int)var3_3;
    }

    private int numericLimitCheck(String number, long maxValue, String message, NumberFormatException n) {
        if (Predef$.MODULE$.augmentString(number).toLong() > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        throw n;
    }

    private long numericLimitCheck(String number, long maxValue, String message) {
        long numeric = Predef$.MODULE$.augmentString(number).toLong();
        if (Predef$.MODULE$.augmentString(number).toLong() > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        return numeric;
    }

    /*
     * Unable to fully structure code
     */
    private final MemcachedParameters liftedTree1$1(ChannelBuffer var1_1, String var2_2, BooleanRef var3_3, String[] var4_4) {
        exceptionResult5 = null;
        try {
            block5: {
                block4: {
                    v0 = var6_6 = this.header().op();
                    var7_7 = Operation$.MODULE$.RemoveRequest();
                    if (v0 != null ? v0.equals(var7_7) == false : var7_7 != null) break block4;
                    v1 = this.readRemoveParameters(var4_4);
                    break block5;
                }
                v2 = var6_6;
                var8_8 = MemcachedOperation$.MODULE$.IncrementRequest();
                if (!(v2 == null ? var8_8 != null : v2.equals(var8_8) == false)) ** GOTO lbl-1000
                v3 = var6_6;
                var9_9 = MemcachedOperation$.MODULE$.DecrementRequest();
                if (!(v3 != null ? v3.equals(var9_9) == false : var9_9 != null)) lbl-1000:
                // 2 sources

                {
                    var3_3.elem = true;
                    v1 = this.readIncrDecrParameters(var4_4);
                } else {
                    v4 = var6_6;
                    var10_10 = MemcachedOperation$.MODULE$.FlushAllRequest();
                    v1 = !(v4 != null ? v4.equals(var10_10) == false : var10_10 != null) ? this.readFlushAllParameters(var4_4) : this.readStorageParameters(var4_4, var1_1);
                }
            }
            exceptionResult5 = v1;
            return exceptionResult5;
        }
        catch (ArrayIndexOutOfBoundsException v5) {
            throw new IOException(new StringBuilder().append((Object)"Missing content in command line ").append((Object)var2_2).toString());
        }
    }

    public MemcachedDecoder(Cache<String, MemcachedValue> memcachedCache, ScheduledExecutorService scheduler, NettyTransport transport) {
        this.scheduler = scheduler;
        this.transport = transport;
        super(transport);
        TextProtocolUtil$class.$init$(this);
        this.cache_$eq(memcachedCache);
        this.incrMisses = new AtomicLong(0L);
        this.incrHits = new AtomicLong(0L);
        this.decrMisses = new AtomicLong(0L);
        this.decrHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedMisses = new AtomicLong(0L);
        this.replaceIfUnmodifiedHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedBadval = new AtomicLong(0L);
    }
}

