/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedFunctionalTest$;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.MemcachedServer$;
import org.infinispan.server.memcached.MemcachedSingleNodeTest;
import org.infinispan.server.memcached.NoReplyListener;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Range;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Test(groups={"functional"}, testName="server.memcached.MemcachedFunctionalTest")
@ScalaSignature(bytes="\u0006\u0001\t=d\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003/5+WnY1dQ\u0016$g)\u001e8di&|g.\u00197UKN$(BA\u0002\u0005\u0003%iW-\\2bG\",GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001A\u0002\u0005\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u0011q#T3nG\u0006\u001c\u0007.\u001a3TS:<G.\u001a(pI\u0016$Vm\u001d;\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"!\u0004\u0001\t\u000bm\u0001A\u0011\u0001\u000f\u0002\u0019Q,7\u000f^*fi\n\u000b7/[2\u0015\u0005u\u0001\u0003CA\t\u001f\u0013\ty\"C\u0001\u0003V]&$\b\"B\u0011\u001b\u0001\u0004\u0011\u0013!A7\u0011\u0005\rRS\"\u0001\u0013\u000b\u0005\u00152\u0013a\u0002:fM2,7\r\u001e\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016%\u0005\u0019iU\r\u001e5pI\")Q\u0006\u0001C\u0001]\u0005AB/Z:u'\u0016$x+\u001b;i\u000bb\u0004\u0018N]=TK\u000e|g\u000eZ:\u0015\u0005uy\u0003\"B\u0011-\u0001\u0004\u0011\u0003\"B\u0019\u0001\t\u0003\u0011\u0014!\u0007;fgR\u001cV\r^,ji\",\u0005\u0010]5ssVs\u0017\u000e\u001f+j[\u0016$\"!H\u001a\t\u000b\u0005\u0002\u0004\u0019\u0001\u0012\t\u000bU\u0002A\u0011\u0001\u001c\u0002?Q,7\u000f^*fi^KG\u000f[#ya&\u0014\u00180\u00168jqRKW.Z%o!\u0006\u001cH\u000f\u0006\u0002\u001eo!)\u0011\u0005\u000ea\u0001E!)\u0011\b\u0001C\u0001u\u0005\u0019B/Z:u\u000f\u0016$X*\u001e7uSBdWmS3zgR\u0011Qd\u000f\u0005\u0006Ca\u0002\rA\t\u0005\u0006{\u0001!\tAP\u0001\ri\u0016\u001cH/\u00113e\u0005\u0006\u001c\u0018n\u0019\u000b\u0003;}BQ!\t\u001fA\u0002\tBQ!\u0011\u0001\u0005\u0002\t\u000b\u0001\u0004^3ti\u0006#GmV5uQ\u0016C\b/\u001b:z'\u0016\u001cwN\u001c3t)\ti2\tC\u0003\"\u0001\u0002\u0007!\u0005C\u0003F\u0001\u0011\u0005a)A\ruKN$\u0018\t\u001a3XSRDW\t\u001f9jef,f.\u001b=US6,GCA\u000fH\u0011\u0015\tC\t1\u0001#\u0011\u0015I\u0005\u0001\"\u0001K\u0003M!Xm\u001d;O_R\fE\rZ%g!J,7/\u001a8u)\ti2\nC\u0003\"\u0011\u0002\u0007!\u0005C\u0003N\u0001\u0011\u0005a*\u0001\tuKN$(+\u001a9mC\u000e,')Y:jGR\u0011Qd\u0014\u0005\u0006C1\u0003\rA\t\u0005\u0006#\u0002!\tAU\u0001\u001bi\u0016\u001cHOT8u%\u0016\u0004H.Y2f\u0013\u001atu\u000e\u001e)sKN,g\u000e\u001e\u000b\u0003;MCQ!\t)A\u0002\tBQ!\u0016\u0001\u0005\u0002Y\u000bA\u0004^3tiJ+\u0007\u000f\\1dK^KG\u000f[#ya&\u0014\u0018pU3d_:$7\u000f\u0006\u0002\u001e/\")\u0011\u0005\u0016a\u0001E!)\u0011\f\u0001C\u00015\u0006iB/Z:u%\u0016\u0004H.Y2f/&$\b.\u0012=qSJLXK\\5y)&lW\r\u0006\u0002\u001e7\")\u0011\u0005\u0017a\u0001E!)Q\f\u0001C\u0001=\u0006yA/Z:u\u0003B\u0004XM\u001c3CCNL7\r\u0006\u0002\u001e?\")\u0011\u0005\u0018a\u0001E!)\u0011\r\u0001C\u0001E\u0006\u0011B/Z:u\u0003B\u0004XM\u001c3O_R4u.\u001e8e)\ti2\rC\u0003\"A\u0002\u0007!\u0005C\u0003f\u0001\u0011\u0005a-\u0001\tuKN$\bK]3qK:$')Y:jGR\u0011Qd\u001a\u0005\u0006C\u0011\u0004\rA\t\u0005\u0006S\u0002!\tA[\u0001\u0014i\u0016\u001cH\u000f\u0015:fa\u0016tGMT8u\r>,h\u000e\u001a\u000b\u0003;-DQ!\t5A\u0002\tBQ!\u001c\u0001\u0005\u00029\fQ\u0002^3ti\u001e+Go\u001d\"bg&\u001cGCA\u000fp\u0011\u0015\tC\u000e1\u0001#\u0011\u0015\t\b\u0001\"\u0001s\u00031!Xm\u001d;DCN\u0014\u0015m]5d)\ti2\u000fC\u0003\"a\u0002\u0007!\u0005C\u0003v\u0001\u0011\u0005a/A\buKN$8)Y:O_R4u.\u001e8e)\tir\u000fC\u0003\"i\u0002\u0007!\u0005C\u0003z\u0001\u0011\u0005!0A\u0007uKN$8)Y:Fq&\u001cHo\u001d\u000b\u0003;mDQ!\t=A\u0002\tBQ! \u0001\u0005\u0002y\fa\u0002^3ti&sg/\u00197jI\u000e\u000b7/F\u0001\u001e\u0011\u0019\t\t\u0001\u0001C\u0001}\u0006\u0019B/Z:u\u0013:4\u0018\r\\5e\u0007\u0006\u001ch+\u00197vK\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0011a\u0004;fgR$U\r\\3uK\n\u000b7/[2\u0015\u0007u\tI\u0001\u0003\u0004\"\u0003\u0007\u0001\rA\t\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003Y!Xm\u001d;EK2,G/\u001a#pKNtu\u000e^#ySN$HcA\u000f\u0002\u0012!1\u0011%a\u0003A\u0002\tBq!!\u0006\u0001\t\u0003\t9\"A\tuKN$H)\u001a7fi\u0016tuNU3qYf$2!HA\r\u0011\u0019\t\u00131\u0003a\u0001E!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0011!\u0006;fgR\u001cV\r^!oI6+H\u000e^5EK2,G/\u001a\u000b\u0004;\u0005\u0005\u0002BB\u0011\u0002\u001c\u0001\u0007!\u0005C\u0004\u0002&\u0001!\t!a\n\u00023Q,7\u000f^*fi:{'+\u001a9ms6+H\u000e^5EK2,G/\u001a\u000b\u0004;\u0005%\u0002BB\u0011\u0002$\u0001\u0007!\u0005C\u0004\u0002.\u0001!I!a\f\u0002\u0017]LG\u000f\u001b(p%\u0016\u0004H.\u001f\u000b\u0006;\u0005E\u00121\u0007\u0005\u0007C\u0005-\u0002\u0019\u0001\u0012\t\u0011\u0005U\u00121\u0006a\u0001\u0003o\t!a\u001c9\u0011\t\u0005e\u0012q\b\b\u0004#\u0005m\u0012bAA\u001f%\u00051\u0001K]3eK\u001aLA!!\u0011\u0002D\t11\u000b\u001e:j]\u001eT1!!\u0010\u0013\u0011\u0019\t9\u0005\u0001C\u0001}\u0006\u0019B/Z:u!&\u0004X\r\\5oK\u0012$U\r\\3uK\"1\u00111\n\u0001\u0005\u0002y\fq\u0004^3tiBK\u0007/\u001a7j]\u0016$w)\u001a;BMR,'/\u00138wC2LGmQ1t\u0011\u001d\ty\u0005\u0001C\u0001\u0003#\n!\u0003^3ti&s7M]3nK:$()Y:jGR\u0019Q$a\u0015\t\r\u0005\ni\u00051\u0001#\u0011\u001d\t9\u0006\u0001C\u0001\u00033\n1\u0003^3ti&s7M]3nK:$HK]5qY\u0016$2!HA.\u0011\u0019\t\u0013Q\u000ba\u0001E!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014!\u0006;fgRLen\u0019:f[\u0016tGOT8u\u000bbL7\u000f\u001e\u000b\u0004;\u0005\r\u0004BB\u0011\u0002^\u0001\u0007!\u0005C\u0004\u0002h\u0001!\t!!\u001b\u0002/Q,7\u000f^%oGJ,W.\u001a8u\u0013:$XmZ3s\u001b\u0006DHcA\u000f\u0002l!1\u0011%!\u001aA\u0002\tBq!a\u001c\u0001\t\u0003\t\t(A\u000fuKN$\u0018J\\2sK6,g\u000e\u001e\"fs>tG-\u00138uK\u001e,'/T1y)\ri\u00121\u000f\u0005\u0007C\u00055\u0004\u0019\u0001\u0012\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z\u0005QB/Z:u\u0013:\u001c'/Z7f]R\u0014U-_8oI2{gnZ'bqR\u0019Q$a\u001f\t\r\u0005\n)\b1\u0001#\u0011\u001d\ty\b\u0001C\u0001\u0003\u0003\u000b1\u0004^3ti&s7M]3nK:$8+\u001e:qCN\u001cHj\u001c8h\u001b\u0006DHcA\u000f\u0002\u0004\"1\u0011%! A\u0002\tBq!a\"\u0001\t\u0003\tI)A\u000fuKN$\u0018J\\2sK6,g\u000e^*veB\f7o\u001d\"jO&sG/T1y)\ri\u00121\u0012\u0005\u0007C\u0005\u0015\u0005\u0019\u0001\u0012\t\u000f\u0005=\u0005\u0001\"\u0001\u0002\u0012\u0006\u0011B/Z:u\t\u0016\u001c'/Z7f]R\u0014\u0015m]5d)\ri\u00121\u0013\u0005\u0007C\u00055\u0005\u0019\u0001\u0012\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\u0006\u0019B/Z:u\t\u0016\u001c'/Z7f]R$&/\u001b9mKR\u0019Q$a'\t\r\u0005\n)\n1\u0001#\u0011\u001d\ty\n\u0001C\u0001\u0003C\u000bQ\u0003^3ti\u0012+7M]3nK:$hj\u001c;Fq&\u001cH\u000fF\u0002\u001e\u0003GCa!IAO\u0001\u0004\u0011\u0003bBAT\u0001\u0011\u0005\u0011\u0011V\u0001\u0017i\u0016\u001cH\u000fR3de\u0016lWM\u001c;CK2|wOW3s_R\u0019Q$a+\t\r\u0005\n)\u000b1\u0001#\u0011\u001d\ty\u000b\u0001C\u0001\u0003c\u000bA\u0002^3ti\u001acWo\u001d5BY2$2!HAZ\u0011\u0019\t\u0013Q\u0016a\u0001E!9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0016a\u0005;fgR4E.^:i\u00032dG)\u001a7bs\u0016$GcA\u000f\u0002<\"1\u0011%!.A\u0002\tBq!a0\u0001\t\u0003\t\t-A\u000euKN$h\t\\;tQ\u0006cG\u000eR3mCf,G-\u00168jqRKW.\u001a\u000b\u0004;\u0005\r\u0007BB\u0011\u0002>\u0002\u0007!\u0005C\u0004\u0002H\u0002!I!!3\u0002\u001f\u0019dWo\u001d5BY2$U\r\\1zK\u0012$r!HAf\u0003\u001b\f9\u000e\u0003\u0004\"\u0003\u000b\u0004\rA\t\u0005\t\u0003\u001f\f)\r1\u0001\u0002R\u0006)A-\u001a7bsB\u0019\u0011#a5\n\u0007\u0005U'CA\u0002J]RD\u0001\"!7\u0002F\u0002\u0007\u00111\\\u0001\u0006g2,W\r\u001d\t\u0004#\u0005u\u0017bAAp%\t!Aj\u001c8h\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003K\f1\u0003^3ti\u001acWo\u001d5BY2tuNU3qYf$2!HAt\u0011\u0019\t\u0013\u0011\u001da\u0001E!1\u00111\u001e\u0001\u0005\u0002y\fA\u0003^3ti\u001acWo\u001d5BY2\u0004\u0016\u000e]3mS:,\u0007BBAx\u0001\u0011\u0005a0A\u0006uKN$h+\u001a:tS>t\u0007BBAz\u0001\u0011\u0005a0\u0001\fuKN$\u0018J\\2s\u0017\u0016LH*\u001a8hi\"d\u0015.\\5u\u0011\u0019\t9\u0010\u0001C\u0001}\u0006)B/Z:u\u000f\u0016$8*Z=MK:<G\u000f\u001b'j[&$\bBBA~\u0001\u0011\u0005a0\u0001\nuKN$XK\\6o_^t7i\\7nC:$\u0007BBA\u0000\u0001\u0011\u0005a0A\u000euKN$XK\\6o_^t7i\\7nC:$\u0007+\u001b9fY&tW\r\u001a\u0005\u0007\u0005\u0007\u0001A\u0011\u0001@\u00029Q,7\u000f\u001e*fC\u00124U\u000f\u001c7MS:,\u0017I\u001a;fe2{gnZ&fs\"1!q\u0001\u0001\u0005\u0002y\fA\u0004^3ti:+w-\u0019;jm\u0016\u0014\u0015\u0010^3t\u0019\u0016tw\r\u001e5WC2,X\rC\u0004\u0003\f\u0001!\tA!\u0004\u0002'Q,7\u000f\u001e$mC\u001e\u001c\u0018j]+og&<g.\u001a3\u0015\u0007u\u0011y\u0001\u0003\u0004\"\u0005\u0013\u0001\rA\t\u0005\b\u0005'\u0001A\u0011\u0001B\u000b\u0003Y!Xm\u001d;J]\u000e\u0014H)Z2s\u0013N,fn]5h]\u0016$GcA\u000f\u0003\u0018!1\u0011E!\u0005A\u0002\tBaAa\u0007\u0001\t\u0003q\u0018!\u0004;fgR4VM\u001d2pg&$\u0018\u0010C\u0004\u0003 \u0001!\tA!\t\u0002\u0011Q,7\u000f^)vSR$2!\bB\u0012\u0011\u0019\t#Q\u0004a\u0001E!9!q\u0005\u0001\u0005\u0002\t%\u0012a\u0005;fgR\u001cV\r\u001e\"jONK'0\u001a,bYV,GcA\u000f\u0003,!1\u0011E!\nA\u0002\tBaAa\f\u0001\t\u0003q\u0018!\u0007;fgR\u001cFo\u001c:f\u0003N\u0014\u0015N\\1ss>3XM\u001d:jI\u0016DqAa\r\u0001\t\u0013\u0011)$A\u0005bI\u0012\fe\u000eZ$fiR\u0019QDa\u000e\t\r\u0005\u0012\t\u00041\u0001#\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{\tA!\u001b8deR1\u0011q\u0007B \u0005\u0003Ba!\tB\u001d\u0001\u0004\u0011\u0003\u0002\u0003B\"\u0005s\u0001\r!!5\u0002\u0005\tL\bb\u0002B\u001e\u0001\u0011%!q\t\u000b\u0007\u0003o\u0011IE!\u0014\t\u0011\t-#Q\ta\u0001\u0003o\t\u0011a\u001b\u0005\t\u0005\u0007\u0012)\u00051\u0001\u0002R\"Z\u0001A!\u0015\u0003b\t\r$\u0011\u000eB6!\u0011\u0011\u0019F!\u0018\u000e\u0005\tU#\u0002\u0002B,\u00053\n1\"\u00198o_R\fG/[8og*\u0019!1\f\u0005\u0002\rQ,7\u000f\u001e8h\u0013\u0011\u0011yF!\u0016\u0003\tQ+7\u000f^\u0001\u0007OJ|W\u000f]:-\u0005\t\u0015\u0014E\u0001B4\u0003)1WO\\2uS>t\u0017\r\\\u0001\ti\u0016\u001cHOT1nK\u0006\u0012!QN\u0001)g\u0016\u0014h/\u001a:/[\u0016l7-Y2iK\u0012tS*Z7dC\u000eDW\r\u001a$v]\u000e$\u0018n\u001c8bYR+7\u000f\u001e")
public class MemcachedFunctionalTest
extends MemcachedSingleNodeTest
implements ScalaObject {
    public void testSetBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    public void testSetWithExpirySeconds(Method m) {
        Future f = this.client().set(this.k(m), 1, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testSetWithExpiryUnixTime(Method m) {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().set(this.k(m), future, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testSetWithExpiryUnixTimeInPast(Method m) {
        Future f = this.client().set(this.k(m), 2592001, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testGetMultipleKeys(Method m) {
        Future f1 = this.client().set(this.k(m, "k1-"), 0, (Object)this.v(m, "v1-"));
        Future f2 = this.client().set(this.k(m, "k2-"), 0, (Object)this.v(m, "v2-"));
        Future f3 = this.client().set(this.k(m, "k3-"), 0, (Object)this.v(m, "v3-"));
        Assert.assertTrue((boolean)((Boolean)f1.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f2.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f3.get(this.timeout(), TimeUnit.SECONDS)));
        List keys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.k(m, "k1-"), this.k(m, "k2-"), this.k(m, "k3-")}));
        Map ret = this.client().getBulk((String[])keys.toArray(ClassManifest$.MODULE$.classType(String.class)));
        Assert.assertEquals(ret.get(this.k(m, "k1-")), (Object)this.v(m, "v1-"));
        Assert.assertEquals(ret.get(this.k(m, "k2-")), (Object)this.v(m, "v2-"));
        Assert.assertEquals(ret.get(this.k(m, "k3-")), (Object)this.v(m, "v3-"));
    }

    public void testAddBasic(Method m) {
        this.addAndGet(m);
    }

    public void testAddWithExpirySeconds(Method m) {
        Future f = this.client().add(this.k(m), 1, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
        f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testAddWithExpiryUnixTime(Method m) {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().add(this.k(m), future, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
        f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testNotAddIfPresent(Method m) {
        this.addAndGet(m);
        Future f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    public void testReplaceBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().replace(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testNotReplaceIfNotPresent(Method m) {
        Future f = this.client().replace(this.k(m), 0, (Object)this.v(m));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testReplaceWithExpirySeconds(Method m) {
        this.addAndGet(m);
        Future f = this.client().replace(this.k(m), 1, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testReplaceWithExpiryUnixTime(Method m) {
        this.addAndGet(m);
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().replace(this.k(m), future, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testAppendBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().append(0L, this.k(m), (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)this.v(m)).append((Object)this.v(m, "v1-")).toString();
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)expected);
    }

    public void testAppendNotFound(Method m) {
        this.addAndGet(m);
        Future f = this.client().append(0L, this.k(m, "k2-"), (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        Assert.assertNull((Object)this.client().get(this.k(m, "k2-")));
    }

    public void testPrependBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().prepend(0L, this.k(m), (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)this.v(m, "v1-")).append((Object)this.v(m)).toString();
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)expected);
    }

    public void testPrependNotFound(Method m) {
        this.addAndGet(m);
        Future f = this.client().prepend(0L, this.k(m, "k2-"), (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        Assert.assertNull((Object)this.client().get(this.k(m, "k2-")));
    }

    public void testGetsBasic(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
    }

    public void testCasBasic(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v1-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testCasNotFound(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client().cas(this.k(m, "k1-"), value.getCas(), (Object)this.v(m, "v1-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.NOT_FOUND);
    }

    public void testCasExists(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        long old = value.getCas();
        CASResponse resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v1-"));
        value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m, "v1-"));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((value.getCas() != old ? 1 : 0) != 0);
        resp = this.client().cas(this.k(m), old, (Object)this.v(m, "v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.EXISTS);
        resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testInvalidCas() {
        String resp = this.send("cas bad blah 0 0 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 blah 0 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 0 blah 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 0 0 blah\r\n\r\n");
        this.assertClientError(resp);
    }

    public void testInvalidCasValue() {
        String resp = this.send("cas foo 0 0 6 \r\nbarva2\r\n");
        this.assertClientError(resp);
    }

    public void testDeleteBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().delete(this.k(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testDeleteDoesNotExist(Method m) {
        Future f = this.client().delete(this.k(m));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
    }

    public void testDeleteNoReply(Method m) {
        this.withNoReply(m, Predef$.MODULE$.augmentString("delete %s noreply\r\n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.k(m)})));
    }

    public void testSetAndMultiDelete(Method m) {
        String key = this.k(m);
        List<String> responses = this.sendMulti(Predef$.MODULE$.augmentString("set %s 0 0 1\r\na\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, key, key, key, key})), 5, true);
        Assert.assertEquals((int)responses.length(), (int)5);
        Assert.assertEquals((String)((String)responses.head()), (String)"STORED");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"DELETED");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)responses.tail()).tail()).head()), (String)"NOT_FOUND");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)((TraversableLike)responses.tail()).tail()).tail()).head()), (String)"NOT_FOUND");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)((TraversableLike)((TraversableLike)responses.tail()).tail()).tail()).tail()).head()), (String)"NOT_FOUND");
    }

    public void testSetNoReplyMultiDelete(Method m) {
        String key = this.k(m);
        List<String> responses = this.sendMulti(Predef$.MODULE$.augmentString("set %s 0 0 1 noreply\r\na\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, key, key, key, key})), 4, true);
        Assert.assertEquals((int)responses.length(), (int)4);
        Assert.assertEquals((String)((String)responses.head()), (String)"DELETED");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"NOT_FOUND");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)responses.tail()).tail()).head()), (String)"NOT_FOUND");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)((TraversableLike)responses.tail()).tail()).tail()).head()), (String)"NOT_FOUND");
    }

    private void withNoReply(Method m, String op) {
        Future f = this.client().set(this.k(m), 0, (Object)"blah");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        CountDownLatch latch = new CountDownLatch(1);
        NoReplyListener listener = new NoReplyListener(latch);
        this.cache.addListener((Object)listener);
        try {
            this.sendNoWait(op);
            ((AbstractCacheTest)this).log.debug((Object)"No reply delete sent, wait...");
            boolean completed = latch.await(10L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)completed, (String)"Timed out waiting for remove to be executed");
            return;
        }
        finally {
            this.cache.removeListener((Object)listener);
        }
    }

    public void testPipelinedDelete() {
        List<String> responses = this.sendMulti("delete a\r\ndelete a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        responses.foreach((Function1)new $anonfun$testPipelinedDelete$1(this));
    }

    public void testPipelinedGetAfterInvalidCas() {
        List<String> responses = this.sendMulti("cas bad 0 0 1 0 0\r\nget a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertTrue((boolean)((String)responses.head()).contains("CLIENT_ERROR"));
        Object object = ((IterableLike)responses.tail()).head();
        String string = "END";
        Assert.assertTrue((!(object != null ? !object.equals(string) : string != null) ? 1 : 0) != 0, (String)new StringBuilder().append((Object)"Instead response was: ").append(((IterableLike)responses.tail()).head()).toString());
    }

    public void testIncrementBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long result = this.client().incr(this.k(m), 1);
        Assert.assertEquals((long)result, (long)2L);
    }

    public void testIncrementTriple(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().incr(this.k(m), 1), (long)2L);
        Assert.assertEquals((long)this.client().incr(this.k(m), 2), (long)4L);
        Assert.assertEquals((long)this.client().incr(this.k(m), 4), (long)8L);
    }

    public void testIncrementNotExist(Method m) {
        Assert.assertEquals((long)this.client().incr(this.k(m), 1), (long)-1L);
    }

    public void testIncrementIntegerMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().incr(this.k(m), Integer.MAX_VALUE), (long)Integer.MAX_VALUE);
    }

    public void testIncrementBeyondIntegerMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long newValue = this.client().incr(this.k(m), Integer.MAX_VALUE);
        Assert.assertEquals((long)newValue, (long)((long)Integer.MAX_VALUE + 1L));
    }

    public void testIncrementBeyondLongMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"9223372036854775808");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        Assert.assertEquals((Object)package$.MODULE$.BigInt().apply(newValue), (Object)package$.MODULE$.BigInt().apply("9223372036854775809"));
    }

    public void testIncrementSurpassLongMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"9223372036854775807");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        Assert.assertEquals((Object)package$.MODULE$.BigInt().apply(newValue), (Object)package$.MODULE$.BigInt().apply("9223372036854775808"));
    }

    public void testIncrementSurpassBigIntMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"18446744073709551615");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        Assert.assertEquals((String)newValue, (String)"0");
    }

    public void testDecrementBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)0L);
    }

    public void testDecrementTriple(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"8");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)7L);
        Assert.assertEquals((long)this.client().decr(this.k(m), 2), (long)5L);
        Assert.assertEquals((long)this.client().decr(this.k(m), 4), (long)1L);
    }

    public void testDecrementNotExist(Method m) {
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)-1L);
    }

    public void testDecrementBelowZero(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long newValue = this.client().decr(this.k(m), 2);
        Assert.assertEquals((long)newValue, (long)0L);
    }

    public void testFlushAll(Method m$1) {
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$testFlushAll$1(this, m$1));
        Future f = this.client().flush();
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$testFlushAll$2(this, m$1));
    }

    public void testFlushAllDelayed(Method m) {
        this.flushAllDelayed(m, 2, 2200L);
    }

    public void testFlushAllDelayedUnixTime(Method m) {
        int delay = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 2000L);
        this.flushAllDelayed(m, delay, 2200L);
    }

    private void flushAllDelayed(Method m$2, int delay, long sleep) {
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$flushAllDelayed$1(this, m$2));
        Future f = this.client().flush(delay);
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)sleep);
        ((Range.ByOne)Predef$.MODULE$.intWrapper(1).to(5)).foreach$mVc$sp((Function1)new $anonfun$flushAllDelayed$2(this, m$2));
    }

    public void testFlushAllNoReply(Method m) {
        this.withNoReply(m, "flush_all noreply\r\n");
    }

    public void testFlushAllPipeline() {
        List<String> responses = this.sendMulti("flush_all\r\nget a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertEquals((String)((String)responses.head()), (String)"OK");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"END");
    }

    public void testVersion() {
        Map versions = this.client().getVersions();
        Assert.assertEquals((int)versions.size(), (int)1);
        String version = (String)versions.values().iterator().next();
        Assert.assertEquals((String)version, (String)Version.VERSION);
    }

    public void testIncrKeyLengthLimit() {
        String keyUnderLimit = TestingUtil.generateRandomString((int)249);
        Future f = this.client().set(keyUnderLimit, 0, (Object)"78");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(keyUnderLimit), (Object)"78");
        String keyInLimit = TestingUtil.generateRandomString((int)250);
        f = this.client().set(keyInLimit, 0, (Object)"89");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(keyInLimit), (Object)"89");
        String keyAboveLimit = TestingUtil.generateRandomString((int)251);
        String resp = this.incr(keyAboveLimit, 1);
        this.assertClientError(resp);
    }

    public void testGetKeyLengthLimit() {
        String tooLongKey = TestingUtil.generateRandomString((int)251);
        String resp = this.send(new StringBuilder().append((Object)"get ").append((Object)tooLongKey).append((Object)"\r\n").toString());
        this.assertClientError(resp);
        tooLongKey = TestingUtil.generateRandomString((int)251);
        resp = this.send(new StringBuilder().append((Object)"get k1 k2 k3 ").append((Object)tooLongKey).append((Object)"\r\n").toString());
        this.assertClientError(resp);
    }

    public void testUnknownCommand() {
        this.assertError(this.send("blah\r\n"));
    }

    public void testUnknownCommandPipelined() {
        List<String> responses = this.sendMulti("bogus\r\ndelete a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertEquals((String)((String)responses.head()), (String)"ERROR");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"NOT_FOUND");
    }

    public void testReadFullLineAfterLongKey() {
        String key = TestingUtil.generateRandomString((int)300);
        String command = new StringBuilder().append((Object)"add ").append((Object)key).append((Object)" 0 0 1\r\nget a\r\n").toString();
        List<String> responses = this.sendMulti(command, 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertTrue((boolean)((String)responses.head()).contains("CLIENT_ERROR"));
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"END");
    }

    public void testNegativeBytesLengthValue() {
        this.assertClientError(this.send("set boo1 0 0 -1\r\n"));
        this.assertClientError(this.send("add boo2 0 0 -1\r\n"));
    }

    public void testFlagsIsUnsigned(Method m) {
        String k = m.getName();
        this.assertClientError(this.send("set boo1 -1 0 0\r\n"));
        this.assertStored(this.send(new StringBuilder().append((Object)"set ").append((Object)k).append((Object)" 4294967295 0 0\r\n").toString()));
        this.assertClientError(this.send("set boo2 4294967296 0 0\r\n"));
        this.assertClientError(this.send("set boo2 18446744073709551615 0 0\r\n"));
    }

    public void testIncrDecrIsUnsigned(Method m) {
        String k = m.getName();
        Future f = this.client().set(k, 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.assertClientError(this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" -1\r\n").toString()));
        this.assertClientError(this.send(new StringBuilder().append((Object)"decr ").append((Object)k).append((Object)" -1\r\n").toString()));
        k = new StringBuilder().append((Object)k).append((Object)"-1").toString();
        f = this.client().set(k, 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.assertExpectedResponse(this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" 18446744073709551615\r\n").toString()), "18446744073709551615", true);
        k = new StringBuilder().append((Object)k).append((Object)"-1").toString();
        f = this.client().set(k, 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.assertClientError(this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" 18446744073709551616\r\n").toString()));
        this.assertClientError(this.send(new StringBuilder().append((Object)"decr ").append((Object)k).append((Object)" 18446744073709551616\r\n").toString()));
    }

    public void testVerbosity() {
        this.assertClientError(this.send("verbosity\r\n"));
        this.assertClientError(this.send("verbosity 5\r\n"));
        this.assertClientError(this.send("verbosity 10 noreply\r\n"));
    }

    public void testQuit(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.sendNoWait("quit\r\n");
    }

    public void testSetBigSizeValue(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)TestingUtil.generateRandomString((int)0x100000).getBytes());
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
    }

    public void testStoreAsBinaryOverride() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager();
        Configuration cfg = new Configuration().fluent().storeAsBinary().build();
        cm.defineConfiguration(MemcachedServer$.MODULE$.cacheName(), cfg);
        Assert.assertTrue((boolean)cfg.isStoreAsBinary());
        MemcachedServer testServer = this.startMemcachedTextServer(cm, this.server().getPort() + 33);
        try {
            Cache memcachedCache = cm.getCache(MemcachedServer$.MODULE$.cacheName());
            Assert.assertFalse((boolean)memcachedCache.getConfiguration().isStoreAsBinary());
            return;
        }
        finally {
            cm.stop();
            testServer.stop();
        }
    }

    private void addAndGet(Method m) {
        Future f = this.client().add(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    private String incr(Method m, int by) {
        return this.incr(this.k(m), by);
    }

    private String incr(String k, int by) {
        return this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)by)).append((Object)"\r\n").toString());
    }
}

