/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.spy.memcached.CASValue;
import org.infinispan.Version;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedSingleNodeTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="server.memcached.MemcachedStatsTest")
@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003%5+WnY1dQ\u0016$7\u000b^1ugR+7\u000f\u001e\u0006\u0003\u0007\u0011\t\u0011\"\\3nG\u0006\u001c\u0007.\u001a3\u000b\u0005\u00151\u0011AB:feZ,'O\u0003\u0002\b\u0011\u0005Q\u0011N\u001c4j]&\u001c\b/\u00198\u000b\u0003%\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0007\u0011!\tia\"D\u0001\u0003\u0013\ty!AA\fNK6\u001c\u0017m\u00195fINKgn\u001a7f\u001d>$W\rV3tiB\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\tY1kY1mC>\u0013'.Z2u\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u000e\u0001!91\u0004\u0001a\u0001\n\u0013a\u0012!\u00036nq\u0012{W.Y5o+\u0005i\u0002C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0011a\u0017M\\4\u000b\u0003\t\nAA[1wC&\u0011Ae\b\u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0019\u0002\u0001\u0019!C\u0005O\u0005i!.\u001c=E_6\f\u0017N\\0%KF$\"\u0001K\u0016\u0011\u0005EI\u0013B\u0001\u0016\u0013\u0005\u0011)f.\u001b;\t\u000f1*\u0013\u0011!a\u0001;\u0005\u0019\u0001\u0010J\u0019\t\r9\u0002\u0001\u0015)\u0003\u001e\u0003)QW\u000e\u001f#p[\u0006Lg\u000e\t\u0005\u0006a\u0001!\t%M\u0001\u0017GJ,\u0017\r^3UKN$8)Y2iK6\u000bg.Y4feV\t!\u0007\u0005\u00024m5\tAG\u0003\u00026\r\u00059Q.\u00198bO\u0016\u0014\u0018BA\u001c5\u0005Q)UNY3eI\u0016$7)Y2iK6\u000bg.Y4fe\")\u0011\b\u0001C\u0001u\u0005!B/Z:u+:\u001cX\u000f\u001d9peR,Gm\u0015;biN$\"\u0001K\u001e\t\u000bqB\u0004\u0019A\u001f\u0002\u00035\u0004\"AP!\u000e\u0003}R!\u0001Q\u0010\u0002\u000fI,g\r\\3di&\u0011!i\u0010\u0002\u0007\u001b\u0016$\bn\u001c3\t\u000b\u0011\u0003A\u0011A#\u0002+Q,7\u000f^+oG>l\u0007/\u0019:bE2,7\u000b^1ugR\u0011\u0001F\u0012\u0005\u0006y\r\u0003\r!\u0010\u0005\u0006\u0011\u0002!\t!S\u0001\u0010i\u0016\u001cHo\u0015;bi&\u001c7\u000b^1ugR\u0011\u0001F\u0013\u0005\u0006y\u001d\u0003\r!\u0010\u0005\u0006\u0019\u0002!\t!T\u0001\u000ei\u0016\u001cH\u000fV8e_N#\u0018\r^:\u0016\u0003!BQa\u0014\u0001\u0005\u0002A\u000b\u0011\u0002^3tiN#\u0018\r^:\u0015\u0005!\n\u0006\"\u0002\u001fO\u0001\u0004i\u0004\"B*\u0001\t\u0003i\u0015A\t;fgR\u001cF/\u0019;t'B,7-\u001b4jGR{W*Z7dC\u000eDW\r\u001a,jC*k\u0007\u0010C\u0003V\u0001\u0011\u0005Q*A\tuKN$8\u000b^1ug^KG\u000f[!sONDQa\u0016\u0001\u0005\na\u000b\u0001bZ3u'R\fGo\u001d\u000b\u00043\u0016<\u0007#B\t[9\n\u0014\u0017BA.\u0013\u0005\u0019!V\u000f\u001d7fgA!Q\fY\u000f\u001e\u001b\u0005q&BA0\"\u0003\u0011)H/\u001b7\n\u0005\u0005t&aA'baB\u0011\u0011cY\u0005\u0003IJ\u00111!\u00138u\u0011\u00151g\u000b1\u0001c\u0003A\u0019WO\u001d:f]R\u0014\u0015\u0010^3t%\u0016\fG\rC\u0003i-\u0002\u0007!-A\ndkJ\u0014XM\u001c;CsR,7o\u0016:jiR,g\u000eC\u0003k\u0001\u0011%1.A\tbgN,'\u000f\u001e%jO\",'OQ=uKN$2A\u00197n\u0011\u00151\u0017\u000e1\u0001c\u0011\u0015q\u0017\u000e1\u0001p\u0003!\u0011\u0017\u0010^3t'R\u0014\bC\u00019t\u001d\t\t\u0012/\u0003\u0002s%\u00051\u0001K]3eK\u001aL!\u0001\n;\u000b\u0005I\u0014\u0002\u0006\u0003\u0001w}~\f)!a\u0002\u0011\u0005]dX\"\u0001=\u000b\u0005eT\u0018aC1o]>$\u0018\r^5p]NT!a\u001f\u0005\u0002\rQ,7\u000f\u001e8h\u0013\ti\bP\u0001\u0003UKN$\u0018AB4s_V\u00048\u000f\f\u0002\u0002\u0002\u0005\u0012\u00111A\u0001\u000bMVt7\r^5p]\u0006d\u0017\u0001\u0003;fgRt\u0015-\\3\"\u0005\u0005%\u0011aI:feZ,'OL7f[\u000e\f7\r[3e]5+WnY1dQ\u0016$7\u000b^1ugR+7\u000f\u001e")
public class MemcachedStatsTest
extends MemcachedSingleNodeTest
implements ScalaObject {
    private String jmxDomain = MemcachedStatsTest.class.getSimpleName();

    private String jmxDomain() {
        return this.jmxDomain;
    }

    private void jmxDomain_$eq(String string) {
        this.jmxDomain = string;
    }

    @Override
    public EmbeddedCacheManager createTestCacheManager() {
        return TestCacheManagerFactory.createCacheManagerEnforceJmxDomain((String)this.jmxDomain());
    }

    public void testUnsupportedStats(Method m) {
        Tuple3<Map<String, String>, Integer, Integer> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats._1()).get("pid")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("pointer_size")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("rusage_user")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("rusage_system")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("bytes")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("connection_structures")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("auth_cmds")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("auth_errors")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("limit_maxbytes")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("conn_yields")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("reclaimed")), (String)"0");
    }

    public void testUncomparableStats(Method m) {
        TestingUtil.sleepThread((long)TimeUnit.SECONDS.toMillis(1L));
        Tuple3<Map<String, String>, Integer, Integer> stats = this.getStats(-1, -1);
        Assert.assertNotSame(((Map)stats._1()).get("uptime"), (Object)"0");
        Assert.assertNotSame(((Map)stats._1()).get("time"), (Object)"0");
        Assert.assertNotSame(((Map)stats._1()).get("uptime"), ((Map)stats._1()).get("time"));
    }

    public void testStaticStats(Method m) {
        Tuple3<Map<String, String>, Integer, Integer> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats._1()).get("version")), (String)Version.VERSION);
    }

    public void testTodoStats() {
        Tuple3<Map<String, String>, Integer, Integer> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_connections")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_connections")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("threads")), (String)"0");
    }

    public void testStats(Method m) {
        Tuple3<Map<String, String>, Integer, Integer> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cmd_set")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cmd_get")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_items")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_items")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_badval")), (String)"0");
        Future f = this.client().set(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        f = this.client().set(this.k(m, "k1-"), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m, "k1-")), (Object)this.v(m, "v1-"));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cmd_set")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cmd_get")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_hits")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_items")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_items")), (String)"2");
        f = this.client().delete(this.k(m, "k1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_items")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_items")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_misses")), (String)"0");
        Assert.assertNull((Object)this.client().get(this.k(m, "k99-")));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_hits")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_misses")), (String)"1");
        f = this.client().delete(this.k(m, "k99-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_misses")), (String)"1");
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        f = this.client().set(this.k(m, "k3-"), future, (Object)this.v(m, "v3-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m, "k3-")));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_items")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_items")), (String)"3");
        this.client().incr(this.k(m, "k4-"), 1);
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_hits")), (String)"0");
        f = this.client().set(this.k(m, "k4-"), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.client().incr(this.k(m, "k4-"), 1);
        this.client().incr(this.k(m, "k4-"), 2);
        this.client().incr(this.k(m, "k4-"), 4);
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_hits")), (String)"3");
        this.client().decr(this.k(m, "k5-"), 1);
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_hits")), (String)"0");
        f = this.client().set(this.k(m, "k5-"), 0, (Object)"8");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.client().decr(this.k(m, "k5-"), 1);
        this.client().decr(this.k(m, "k5-"), 2);
        this.client().decr(this.k(m, "k5-"), 4);
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_hits")), (String)"3");
        this.client().cas(this.k(m, "k6-"), 1234L, (Object)this.v(m, "v6-"));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_badval")), (String)"0");
        f = this.client().set(this.k(m, "k6-"), 0, (Object)this.v(m, "v6-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        CASValue value = this.client().gets(this.k(m, "k6-"));
        long old = value.getCas();
        this.client().cas(this.k(m, "k6-"), value.getCas(), (Object)this.v(m, "v66-"));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_badval")), (String)"0");
        this.client().cas(this.k(m, "k6-"), old, (Object)this.v(m, "v66-"));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_badval")), (String)"1");
    }

    public void testStatsSpecificToMemcachedViaJmx() {
        this.getStats(-1, -1);
        MBeanServer server = PerThreadMBeanServerLookup.getThreadMBeanServer();
        ObjectName on = new ObjectName(Predef$.MODULE$.augmentString("%s:type=Server,name=Memcached,component=Transport").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jmxDomain()})));
        Assert.assertTrue((Predef$.MODULE$.augmentString(server.getAttribute(on, "TotalBytesRead").toString()).toInt() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((Predef$.MODULE$.augmentString(server.getAttribute(on, "TotalBytesWritten").toString()).toInt() > 0 ? 1 : 0) != 0);
    }

    public void testStatsWithArgs() {
        String resp = this.send("stats\r\n");
        this.assertExpectedResponse(resp, "STAT", false);
        resp = this.send("stats \r\n");
        this.assertExpectedResponse(resp, "STAT", false);
        resp = this.send("stats boo\r\n");
        this.assertClientError(resp);
        resp = this.send("stats boo boo2 boo3\r\n");
        this.assertClientError(resp);
    }

    private Tuple3<Map<String, String>, Integer, Integer> getStats(int currentBytesRead, int currentBytesWritten) {
        Map globalStats = this.client().getStats();
        Assert.assertEquals((int)globalStats.size(), (int)1);
        Map stats = (Map)globalStats.values().iterator().next();
        int bytesRead = this.assertHigherBytes(currentBytesRead, (String)stats.get("bytes_read"));
        int bytesWritten = this.assertHigherBytes(currentBytesRead, (String)stats.get("bytes_written"));
        return new Tuple3((Object)stats, (Object)BoxesRunTime.boxToInteger((int)bytesRead), (Object)BoxesRunTime.boxToInteger((int)bytesWritten));
    }

    /*
     * WARNING - void declaration
     */
    private int assertHigherBytes(int currentBytesRead, String bytesStr) {
        void var3_3;
        int bytesRead = Predef$.MODULE$.augmentString(bytesStr).toInt();
        Assert.assertTrue((bytesRead > currentBytesRead ? 1 : 0) != 0);
        return (int)var3_3;
    }
}

