/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.server.memcached.test.MemcachedTestingUtil$class;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;

@Test(groups={"functional"}, testName="server.memcached.MemcachedReplicationTest")
@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001-\u0011\u0001$T3nG\u0006\u001c\u0007.\u001a3SKBd\u0017nY1uS>tG+Z:u\u0015\t\u0019A!A\u0005nK6\u001c\u0017m\u00195fI*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u001dA\u0011AC5oM&t\u0017n\u001d9b]*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u0019I9\u0002CA\u0007\u0011\u001b\u0005q!BA\b\u0007\u0003\u0011!Xm\u001d;\n\u0005Eq!!G'vYRL\u0007\u000f\\3DC\u000eDW-T1oC\u001e,'o\u001d+fgR\u0004\"aE\u000b\u000e\u0003QQ!a\u0004\u0002\n\u0005Y!\"\u0001F'f[\u000e\f7\r[3e)\u0016\u001cH/\u001b8h+RLG\u000e\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012DA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"\u0002\u0010\u0001\t\u0003y\u0012A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u0003\u0011\u001d\u0019\u0003A1A\u0005\n\u0011\n\u0011bY1dQ\u0016t\u0015-\\3\u0016\u0003\u0015\u0002\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\t1\fgn\u001a\u0006\u0002U\u0005!!.\u0019<b\u0013\tasE\u0001\u0004TiJLgn\u001a\u0005\u0007]\u0001\u0001\u000b\u0011B\u0013\u0002\u0015\r\f7\r[3OC6,\u0007\u0005\u0003\u00041\u0001\u0001\u0006K!M\u0001\bg\u0016\u0014h/\u001a:t!\r\u0011$(\u0010\b\u0003gar!\u0001N\u001c\u000e\u0003UR!A\u000e\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012BA\u001d\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u000f\u001f\u0003\t1K7\u000f\u001e\u0006\u0003se\u0001\"!\t \n\u0005}\u0012!aD'f[\u000e\f7\r[3e'\u0016\u0014h/\u001a:\t\r\u0005\u0003\u0001\u0015)\u0003C\u0003\u001d\u0019G.[3oiN\u00042A\r\u001eD!\t!%*D\u0001F\u0015\t\u0019aI\u0003\u0002H\u0011\u0006\u00191\u000f]=\u000b\u0003%\u000b1A\\3u\u0013\tYUIA\bNK6\u001c\u0017m\u00195fI\u000ec\u0017.\u001a8u\u0011\u001di\u0005A1A\u0005\n9\u000bq\u0001^5nK>,H/F\u0001P!\tA\u0002+\u0003\u0002R3\t\u0019\u0011J\u001c;\t\rM\u0003\u0001\u0015!\u0003P\u0003!!\u0018.\\3pkR\u0004\u0003\"B+\u0001\t\u00032\u0016aE2sK\u0006$XmQ1dQ\u0016l\u0015M\\1hKJ\u001cH#A,\u0011\u0005aA\u0016BA-\u001a\u0005\u0011)f.\u001b;)\tQ[6\r\u001a\t\u00039\u0006l\u0011!\u0018\u0006\u0003=~\u000b1\"\u00198o_R\fG/[8og*\u0011\u0001\rC\u0001\u0007i\u0016\u001cHO\\4\n\u0005\tl&\u0001\u0002+fgR\fq!\u001a8bE2,G-G\u0001\u0001\u0011\u00151\u0007\u0001\"\u0011W\u0003\u001d!Wm\u001d;s_fDC!\u001a5lYB\u0011A,[\u0005\u0003Uv\u0013!\"\u00114uKJ\u001cE.Y:t\u0003%\tGn^1zgJ+h.G\u0001\u0002\u0011\u0015q\u0007\u0001\"\u0001p\u0003E!Xm\u001d;SKBd\u0017nY1uK\u0012\u001cV\r\u001e\u000b\u0003/BDQ!]7A\u0002I\f\u0011!\u001c\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k\u001e\nqA]3gY\u0016\u001cG/\u0003\u0002xi\n1Q*\u001a;i_\u0012DQ!\u001f\u0001\u0005\u0002i\fQ\u0004^3tiJ+\u0007\u000f\\5dCR,GmR3u\u001bVdG/\u001b9mK.+\u0017p\u001d\u000b\u0003/nDQ!\u001d=A\u0002IDQ! \u0001\u0005\u0002y\f\u0011\u0003^3tiJ+\u0007\u000f\\5dCR,G-\u00113e)\t9v\u0010C\u0003ry\u0002\u0007!\u000fC\u0004\u0002\u0004\u0001!\t!!\u0002\u0002+Q,7\u000f\u001e*fa2L7-\u0019;fIJ+\u0007\u000f\\1dKR\u0019q+a\u0002\t\rE\f\t\u00011\u0001s\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\tA\u0003^3tiJ+\u0007\u000f\\5dCR,G-\u00119qK:$GcA,\u0002\u0010!1\u0011/!\u0003A\u0002IDq!a\u0005\u0001\t\u0003\t)\"A\u000buKN$(+\u001a9mS\u000e\fG/\u001a3Qe\u0016\u0004XM\u001c3\u0015\u0007]\u000b9\u0002\u0003\u0004r\u0003#\u0001\rA\u001d\u0005\b\u00037\u0001A\u0011AA\u000f\u0003I!Xm\u001d;SKBd\u0017nY1uK\u0012<U\r^:\u0015\u0007]\u000by\u0002\u0003\u0004r\u00033\u0001\rA\u001d\u0005\b\u0003G\u0001A\u0011AA\u0013\u0003]!Xm\u001d;SKBd\u0017nY1uK\u0012\u001c\u0015m]#ySN$8\u000fF\u0002X\u0003OAa!]A\u0011\u0001\u0004\u0011\bbBA\u0016\u0001\u0011\u0005\u0011QF\u0001\u0015i\u0016\u001cHOU3qY&\u001c\u0017\r^3e\t\u0016dW\r^3\u0015\u0007]\u000by\u0003\u0003\u0004r\u0003S\u0001\rA\u001d\u0005\b\u0003g\u0001A\u0011AA\u001b\u0003]!Xm\u001d;SKBd\u0017nY1uK\u0012Len\u0019:f[\u0016tG\u000fF\u0002X\u0003oAa!]A\u0019\u0001\u0004\u0011\bbBA\u001e\u0001\u0011\u0005\u0011QH\u0001\u0018i\u0016\u001cHOU3qY&\u001c\u0017\r^3e\t\u0016\u001c'/Z7f]R$2aVA \u0011\u0019\t\u0018\u0011\ba\u0001e\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0013a\n9s_R,7\r^3eI\u0005$Gm\u00117vgR,'/\u00128bE2,GmQ1dQ\u0016l\u0015M\\1hKJ$B!a\u0012\u0002VQ\u0011\u0011\u0011\n\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011q\n\u0004\u0002\u000f5\fg.Y4fe&!\u00111KA'\u0005Q)UNY3eI\u0016$7)Y2iK6\u000bg.Y4fe\"I\u0011qKA!\u0003\u0003\u0005\r\u0001I\u0001\u0004q\u0012\n\u0004F\u0003\u0001\\\u00037\ni&a\u0019\u0002f\u00051qM]8vaNd#!a\u0018\"\u0005\u0005\u0005\u0014A\u00034v]\u000e$\u0018n\u001c8bY\u0006AA/Z:u\u001d\u0006lW-\t\u0002\u0002h\u0005I3/\u001a:wKJtS.Z7dC\u000eDW\r\u001a\u0018NK6\u001c\u0017m\u00195fIJ+\u0007\u000f\\5dCRLwN\u001c+fgR\u0004")
public class MemcachedReplicationTest
extends MultipleCacheManagersTest
implements MemcachedTestingUtil,
ScalaObject {
    private final String org$infinispan$server$memcached$MemcachedReplicationTest$$cacheName;
    private List<MemcachedServer> servers;
    public List<MemcachedClient> org$infinispan$server$memcached$MemcachedReplicationTest$$clients;
    private final int timeout;

    public EmbeddedCacheManager protected$addClusterEnabledCacheManager(MemcachedReplicationTest memcachedReplicationTest) {
        return memcachedReplicationTest.addClusterEnabledCacheManager();
    }

    public final String org$infinispan$server$memcached$MemcachedReplicationTest$$cacheName() {
        return this.org$infinispan$server$memcached$MemcachedReplicationTest$$cacheName;
    }

    private int timeout() {
        return this.timeout;
    }

    @Test(enabled=false)
    public void createCacheManagers() {
        Configuration config$1 = AbstractCacheTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.REPL_SYNC);
        config$1.setFetchInMemoryState(true);
        Predef$.MODULE$.intWrapper(0).until(2).foreach((Function1)new Serializable(this, config$1){
            public static final long serialVersionUID;
            private final MemcachedReplicationTest $outer;
            private final Configuration config$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Configuration apply(int i) {
                EmbeddedCacheManager cm = this.$outer.protected$addClusterEnabledCacheManager(this.$outer);
                return cm.defineConfiguration(this.$outer.org$infinispan$server$memcached$MemcachedReplicationTest$$cacheName(), this.config$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.config$1 = configuration;
            }
        });
        MemcachedServer memcachedServer = this.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManagers.get(0), this.org$infinispan$server$memcached$MemcachedReplicationTest$$cacheName());
        this.servers = this.servers.$colon$colon((Object)memcachedServer);
        MemcachedServer memcachedServer2 = this.startMemcachedTextServer((EmbeddedCacheManager)this.cacheManagers.get(1), ((AbstractProtocolServer)this.servers.head()).getPort() + 50, this.org$infinispan$server$memcached$MemcachedReplicationTest$$cacheName());
        this.servers = this.servers.$colon$colon((Object)memcachedServer2);
        this.servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final MemcachedReplicationTest $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MemcachedServer s) {
                MemcachedClient memcachedClient = this.$outer.createMemcachedClient(60000L, s.getPort());
                this.$outer.org$infinispan$server$memcached$MemcachedReplicationTest$$clients = this.$outer.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.$colon$colon((Object)memcachedClient);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @AfterClass(alwaysRun=true)
    public void destroy() {
        super.destroy();
        this.log.debug((Object)"Test finished, close Hot Rod server");
        this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MemcachedClient memcachedClient) {
                memcachedClient.shutdown();
            }
        });
        this.servers.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MemcachedServer memcachedServer) {
                memcachedServer.stop();
            }
        });
    }

    public void testReplicatedSet(Method m) {
        Future f = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).set(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).get(this.k(m)), (Object)this.v(m));
    }

    public void testReplicatedGetMultipleKeys(Method m) {
        Future f1 = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).set(this.k(m, "k1-"), 0, (Object)this.v(m, "v1-"));
        Future f2 = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).set(this.k(m, "k2-"), 0, (Object)this.v(m, "v2-"));
        Future f3 = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).set(this.k(m, "k3-"), 0, (Object)this.v(m, "v3-"));
        Assert.assertTrue((boolean)((Boolean)f1.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f2.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f3.get(this.timeout(), TimeUnit.SECONDS)));
        List keys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.k(m, "k1-"), this.k(m, "k2-"), this.k(m, "k3-")}));
        Map ret = ((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).getBulk((String[])keys.toArray(ClassManifest$.MODULE$.classType(String.class)));
        Assert.assertEquals(ret.get(this.k(m, "k1-")), (Object)this.v(m, "v1-"));
        Assert.assertEquals(ret.get(this.k(m, "k2-")), (Object)this.v(m, "v2-"));
        Assert.assertEquals(ret.get(this.k(m, "k3-")), (Object)this.v(m, "v3-"));
    }

    public void testReplicatedAdd(Method m) {
        Future f = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).add(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).get(this.k(m)), (Object)this.v(m));
    }

    public void testReplicatedReplace(Method m) {
        Future f = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).add(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).get(this.k(m)), (Object)this.v(m));
        f = ((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).replace(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testReplicatedAppend(Method m) {
        Future f = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).add(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).get(this.k(m)), (Object)this.v(m));
        f = ((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).append(0L, this.k(m), (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)this.v(m).toString()).append((Object)this.v(m, "v1-").toString()).toString();
        Assert.assertEquals((Object)((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).get(this.k(m)), (Object)expected);
    }

    public void testReplicatedPrepend(Method m) {
        Future f = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).add(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).get(this.k(m)), (Object)this.v(m));
        f = ((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).prepend(0L, this.k(m), (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)this.v(m, "v1-").toString()).append((Object)this.v(m).toString()).toString();
        Assert.assertEquals((Object)((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).get(this.k(m)), (Object)expected);
    }

    public void testReplicatedGets(Method m) {
        Future f = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).set(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        CASValue value = ((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
    }

    public void testReplicatedCasExists(Method m) {
        Future f = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).set(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        CASValue value = ((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        long old = value.getCas();
        CASResponse resp = ((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).cas(this.k(m), value.getCas(), (Object)this.v(m, "v1-"));
        value = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m, "v1-"));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((value.getCas() != old ? 1 : 0) != 0);
        resp = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).cas(this.k(m), old, (Object)this.v(m, "v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.EXISTS);
        resp = ((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).cas(this.k(m), value.getCas(), (Object)this.v(m, "v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testReplicatedDelete(Method m) {
        Future f = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).set(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        f = ((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).delete(this.k(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
    }

    public void testReplicatedIncrement(Method m) {
        Future f = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).incr(this.k(m), 1), (long)2L);
    }

    public void testReplicatedDecrement(Method m) {
        Future f = ((MemcachedClient)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.head()).set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)((MemcachedClient)((IterableLike)this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients.tail()).head()).decr(this.k(m), 1), (long)0L);
    }

    public MemcachedReplicationTest() {
        MemcachedTestingUtil$class.$init$(this);
        this.org$infinispan$server$memcached$MemcachedReplicationTest$$cacheName = "MemcachedReplSync";
        this.servers = Nil$.MODULE$;
        this.org$infinispan$server$memcached$MemcachedReplicationTest$$clients = Nil$.MODULE$;
        this.timeout = 60;
    }
}

