/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.spy.memcached.CASValue;
import org.infinispan.Version;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedSingleNodeTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="server.memcached.MemcachedStatsTest")
@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001-\u0011!#T3nG\u0006\u001c\u0007.\u001a3Ti\u0006$8\u000fV3ti*\u00111\u0001B\u0001\n[\u0016l7-Y2iK\u0012T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0001\u0002CA\u0007\u000f\u001b\u0005\u0011\u0011BA\b\u0003\u0005]iU-\\2bG\",GmU5oO2,gj\u001c3f)\u0016\u001cH\u000f\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"CA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\ti\u0001\u0001C\u0004\u001c\u0001\u0001\u0007I\u0011\u0002\u000f\u0002\u0013)l\u0007\u0010R8nC&tW#A\u000f\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001\u00027b]\u001eT\u0011AI\u0001\u0005U\u00064\u0018-\u0003\u0002%?\t11\u000b\u001e:j]\u001eDqA\n\u0001A\u0002\u0013%q%A\u0007k[b$u.\\1j]~#S-\u001d\u000b\u0003Q-\u0002\"!E\u0015\n\u0005)\u0012\"\u0001B+oSRDq\u0001L\u0013\u0002\u0002\u0003\u0007Q$A\u0002yIEBaA\f\u0001!B\u0013i\u0012A\u00036nq\u0012{W.Y5oA!)\u0001\u0007\u0001C!c\u000512M]3bi\u0016$Vm\u001d;DC\u000eDW-T1oC\u001e,'/F\u00013!\t\u0019d'D\u00015\u0015\t)d!A\u0004nC:\fw-\u001a:\n\u0005]\"$\u0001F#nE\u0016$G-\u001a3DC\u000eDW-T1oC\u001e,'\u000fC\u0003:\u0001\u0011\u0005!(\u0001\u000buKN$XK\\:vaB|'\u000f^3e'R\fGo\u001d\u000b\u0003QmBQ\u0001\u0010\u001dA\u0002u\n\u0011!\u001c\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001~\tqA]3gY\u0016\u001cG/\u0003\u0002C\u007f\t1Q*\u001a;i_\u0012DQ\u0001\u0012\u0001\u0005\u0002\u0015\u000bQ\u0003^3tiVs7m\\7qCJ\f'\r\\3Ti\u0006$8\u000f\u0006\u0002)\r\")Ah\u0011a\u0001{!)\u0001\n\u0001C\u0001\u0013\u0006yA/Z:u'R\fG/[2Ti\u0006$8\u000f\u0006\u0002)\u0015\")Ah\u0012a\u0001{!)A\n\u0001C\u0001\u001b\u0006iA/Z:u)>$wn\u0015;biN,\u0012\u0001\u000b\u0005\u0006\u001f\u0002!\t\u0001U\u0001\ni\u0016\u001cHo\u0015;biN$\"\u0001K)\t\u000bqr\u0005\u0019A\u001f\t\u000bM\u0003A\u0011A'\u0002EQ,7\u000f^*uCR\u001c8\u000b]3dS\u001aL7\rV8NK6\u001c\u0017m\u00195fIZK\u0017MS7y\u0011\u0015)\u0006\u0001\"\u0001N\u0003E!Xm\u001d;Ti\u0006$8oV5uQ\u0006\u0013xm\u001d\u0005\u0006/\u0002!I\u0001W\u0001\tO\u0016$8\u000b^1ugR\u0019\u0011,Z4\u0011\u000bEQFL\u00192\n\u0005m\u0013\"A\u0002+va2,7\u0007\u0005\u0003^AviR\"\u00010\u000b\u0005}\u000b\u0013\u0001B;uS2L!!\u00190\u0003\u00075\u000b\u0007\u000f\u0005\u0002\u0012G&\u0011AM\u0005\u0002\u0004\u0013:$\b\"\u00024W\u0001\u0004\u0011\u0017\u0001E2veJ,g\u000e\u001e\"zi\u0016\u001c(+Z1e\u0011\u0015Ag\u000b1\u0001c\u0003M\u0019WO\u001d:f]R\u0014\u0015\u0010^3t/JLG\u000f^3o\u0011\u0015Q\u0007\u0001\"\u0003l\u0003E\t7o]3si\"Kw\r[3s\u0005f$Xm\u001d\u000b\u0004E2l\u0007\"\u00024j\u0001\u0004\u0011\u0007\"\u00028j\u0001\u0004y\u0017\u0001\u00032zi\u0016\u001c8\u000b\u001e:\u0011\u0005A\u001chBA\tr\u0013\t\u0011(#\u0001\u0004Qe\u0016$WMZ\u0005\u0003IQT!A\u001d\n)\u0011\u00011hp`A\u0003\u0003\u000f\u0001\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0003w\"\ta\u0001^3ti:<\u0017BA?y\u0005\u0011!Vm\u001d;\u0002\r\u001d\u0014x.\u001e9tY\t\t\t!\t\u0002\u0002\u0004\u0005Qa-\u001e8di&|g.\u00197\u0002\u0011Q,7\u000f\u001e(b[\u0016\f#!!\u0003\u0002GM,'O^3s]5,WnY1dQ\u0016$g&T3nG\u0006\u001c\u0007.\u001a3Ti\u0006$8\u000fV3ti\u0002")
public class MemcachedStatsTest
extends MemcachedSingleNodeTest
implements ScalaObject {
    private String jmxDomain = MemcachedStatsTest.class.getSimpleName();

    private String jmxDomain() {
        return this.jmxDomain;
    }

    private void jmxDomain_$eq(String string) {
        this.jmxDomain = string;
    }

    @Override
    public EmbeddedCacheManager createTestCacheManager() {
        return TestCacheManagerFactory.createCacheManagerEnforceJmxDomain((String)this.jmxDomain());
    }

    public void testUnsupportedStats(Method m) {
        Tuple3<Map<String, String>, Object, Object> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats._1()).get("pid")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("pointer_size")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("rusage_user")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("rusage_system")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("bytes")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("connection_structures")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("auth_cmds")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("auth_errors")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("limit_maxbytes")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("conn_yields")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("reclaimed")), (String)"0");
    }

    public void testUncomparableStats(Method m) {
        TestingUtil.sleepThread((long)TimeUnit.SECONDS.toMillis(1L));
        Tuple3<Map<String, String>, Object, Object> stats = this.getStats(-1, -1);
        Assert.assertNotSame(((Map)stats._1()).get("uptime"), (Object)"0");
        Assert.assertNotSame(((Map)stats._1()).get("time"), (Object)"0");
        Assert.assertNotSame(((Map)stats._1()).get("uptime"), ((Map)stats._1()).get("time"));
    }

    public void testStaticStats(Method m) {
        Tuple3<Map<String, String>, Object, Object> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats._1()).get("version")), (String)Version.VERSION);
    }

    public void testTodoStats() {
        Tuple3<Map<String, String>, Object, Object> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_connections")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_connections")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("threads")), (String)"0");
    }

    public void testStats(Method m) {
        Tuple3<Map<String, String>, Object, Object> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cmd_set")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cmd_get")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_items")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_items")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_badval")), (String)"0");
        Future f = this.client().set(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        f = this.client().set(this.k(m, "k1-"), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m, "k1-")), (Object)this.v(m, "v1-"));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cmd_set")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cmd_get")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_hits")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_items")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_items")), (String)"2");
        f = this.client().delete(this.k(m, "k1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_items")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_items")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_misses")), (String)"0");
        Assert.assertNull((Object)this.client().get(this.k(m, "k99-")));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_hits")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_misses")), (String)"1");
        f = this.client().delete(this.k(m, "k99-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_misses")), (String)"1");
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        f = this.client().set(this.k(m, "k3-"), future, (Object)this.v(m, "v3-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m, "k3-")));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_items")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_items")), (String)"3");
        this.client().incr(this.k(m, "k4-"), 1);
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_hits")), (String)"0");
        f = this.client().set(this.k(m, "k4-"), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.client().incr(this.k(m, "k4-"), 1);
        this.client().incr(this.k(m, "k4-"), 2);
        this.client().incr(this.k(m, "k4-"), 4);
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_hits")), (String)"3");
        this.client().decr(this.k(m, "k5-"), 1);
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_hits")), (String)"0");
        f = this.client().set(this.k(m, "k5-"), 0, (Object)"8");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.client().decr(this.k(m, "k5-"), 1);
        this.client().decr(this.k(m, "k5-"), 2);
        this.client().decr(this.k(m, "k5-"), 4);
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_hits")), (String)"3");
        this.client().cas(this.k(m, "k6-"), 1234L, (Object)this.v(m, "v6-"));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_badval")), (String)"0");
        f = this.client().set(this.k(m, "k6-"), 0, (Object)this.v(m, "v6-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        CASValue value = this.client().gets(this.k(m, "k6-"));
        long old = value.getCas();
        this.client().cas(this.k(m, "k6-"), value.getCas(), (Object)this.v(m, "v66-"));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_badval")), (String)"0");
        this.client().cas(this.k(m, "k6-"), old, (Object)this.v(m, "v66-"));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_badval")), (String)"1");
    }

    public void testStatsSpecificToMemcachedViaJmx() {
        this.getStats(-1, -1);
        MBeanServer server = PerThreadMBeanServerLookup.getThreadMBeanServer();
        ObjectName on = new ObjectName(Predef$.MODULE$.augmentString("%s:type=Server,name=Memcached,component=Transport").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jmxDomain()})));
        Assert.assertTrue((Predef$.MODULE$.augmentString(server.getAttribute(on, "TotalBytesRead").toString()).toInt() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((Predef$.MODULE$.augmentString(server.getAttribute(on, "TotalBytesWritten").toString()).toInt() > 0 ? 1 : 0) != 0);
    }

    public void testStatsWithArgs() {
        String resp = this.send("stats\r\n");
        this.assertExpectedResponse(resp, "STAT", false);
        resp = this.send("stats \r\n");
        this.assertExpectedResponse(resp, "STAT", false);
        resp = this.send("stats boo\r\n");
        this.assertClientError(resp);
        resp = this.send("stats boo boo2 boo3\r\n");
        this.assertClientError(resp);
    }

    private Tuple3<Map<String, String>, Object, Object> getStats(int currentBytesRead, int currentBytesWritten) {
        Map globalStats = this.client().getStats();
        Assert.assertEquals((int)globalStats.size(), (int)1);
        Map stats = (Map)globalStats.values().iterator().next();
        int bytesRead = this.assertHigherBytes(currentBytesRead, (String)stats.get("bytes_read"));
        int bytesWritten = this.assertHigherBytes(currentBytesRead, (String)stats.get("bytes_written"));
        return new Tuple3((Object)stats, (Object)BoxesRunTime.boxToInteger((int)bytesRead), (Object)BoxesRunTime.boxToInteger((int)bytesWritten));
    }

    /*
     * WARNING - void declaration
     */
    private int assertHigherBytes(int currentBytesRead, String bytesStr) {
        void var3_3;
        int bytesRead = Predef$.MODULE$.augmentString(bytesStr).toInt();
        Assert.assertTrue((bytesRead > currentBytesRead ? 1 : 0) != 0);
        return (int)var3_3;
    }
}

