/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.context.Flag;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.DecoderState;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.RequestHeader;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ExtendedChannelBuffer$;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.memcached.DelayedFlushAll;
import org.infinispan.server.memcached.MemcachedException;
import org.infinispan.server.memcached.MemcachedOperation$;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.MemcachedValue;
import org.infinispan.server.memcached.RequestResolver$;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.TextProtocolUtil$class;
import org.infinispan.stats.Stats;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\r5c\u0001B\u0001\u0003\u0001-\u0011\u0001#T3nG\u0006\u001c\u0007.\u001a3EK\u000e|G-\u001a:\u000b\u0005\r!\u0011!C7f[\u000e\f7\r[3e\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000f!\t!\"\u001b8gS:L7\u000f]1o\u0015\u0005I\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\rA\r\u0002B!\u0004\t\u001395\taB\u0003\u0002\u0010\t\u0005!1m\u001c:f\u0013\t\tbBA\fBEN$(/Y2u!J|Go\\2pY\u0012+7m\u001c3feB\u00111#\u0007\b\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$F\u0001\u0007!J,G-\u001a4\n\u0005iY\"AB*ue&twM\u0003\u0002\u0019+A\u0011QDH\u0007\u0002\u0005%\u0011qD\u0001\u0002\u000f\u001b\u0016l7-Y2iK\u00124\u0016\r\\;f!\ti\u0012%\u0003\u0002#\u0005\t\u0001B+\u001a=u!J|Go\\2pYV#\u0018\u000e\u001c\t\u0003)\u0011J!!J\u000b\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005qQ.Z7dC\u000eDW\rZ\"bG\",\u0007\u0003B\u0015+%qi\u0011AB\u0005\u0003W\u0019\u0011QaQ1dQ\u0016D\u0001\"\f\u0001\u0003\u0002\u0003\u0006IAL\u0001\ng\u000eDW\rZ;mKJ\u0004\"a\f\u001c\u000e\u0003AR!!\r\u001a\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00024i\u0005!Q\u000f^5m\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u0019\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW\r\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0003%!(/\u00198ta>\u0014H\u000f\u0005\u0002<{5\tAH\u0003\u0002:\u001d%\u0011a\b\u0010\u0002\u000f\u001d\u0016$H/\u001f+sC:\u001c\bo\u001c:u\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u0019a\u0014N\\5u}Q!!i\u0011#F!\ti\u0002\u0001C\u0003(\u007f\u0001\u0007\u0001\u0006C\u0003.\u007f\u0001\u0007a\u0006C\u0003:\u007f\u0001\u0007!(\u0002\u0003H\u0001\u0001A%AE*vSR\f'\r\\3QCJ\fW.\u001a;feN\u0004\"!H%\n\u0005)\u0013!aE'f[\u000e\f7\r[3e!\u0006\u0014\u0018-\\3uKJ\u001cX\u0001\u0002'\u0001\u00015\u0013abU;ji\u0006\u0014G.\u001a%fC\u0012,'\u000f\u0005\u0002\u000e\u001d&\u0011qJ\u0004\u0002\u000e%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u0011E\u0003\u0001R1A\u0005\nI\u000ba\"[:Ti\u0006$8/\u00128bE2,G-F\u0001T!\t!B+\u0003\u0002V+\t9!i\\8mK\u0006t\u0007\u0002C,\u0001\u0011\u0003\u0005\u000b\u0015B*\u0002\u001f%\u001c8\u000b^1ug\u0016s\u0017M\u00197fI\u0002Bq!\u0017\u0001C\u0002\u00135!,\u0001\u0006j]\u000e\u0014X*[:tKN,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=B\na!\u0019;p[&\u001c\u0017B\u00011^\u0005)\tEo\\7jG2{gn\u001a\u0005\u0007E\u0002\u0001\u000bQB.\u0002\u0017%t7M]'jgN,7\u000f\t\u0005\bI\u0002\u0011\r\u0011\"\u0004[\u0003!Ign\u0019:ISR\u001c\bB\u00024\u0001A\u000351,A\u0005j]\u000e\u0014\b*\u001b;tA!9\u0001\u000e\u0001b\u0001\n\u001bQ\u0016A\u00033fGJl\u0015n]:fg\"1!\u000e\u0001Q\u0001\u000em\u000b1\u0002Z3de6K7o]3tA!9A\u000e\u0001b\u0001\n\u001bQ\u0016\u0001\u00033fGJD\u0015\u000e^:\t\r9\u0004\u0001\u0015!\u0004\\\u0003%!Wm\u0019:ISR\u001c\b\u0005C\u0004q\u0001\t\u0007IQ\u0002.\u00023I,\u0007\u000f\\1dK&3WK\\7pI&4\u0017.\u001a3NSN\u001cXm\u001d\u0005\u0007e\u0002\u0001\u000bQB.\u00025I,\u0007\u000f\\1dK&3WK\\7pI&4\u0017.\u001a3NSN\u001cXm\u001d\u0011\t\u000fQ\u0004!\u0019!C\u00075\u00069\"/\u001a9mC\u000e,\u0017JZ+o[>$\u0017NZ5fI\"KGo\u001d\u0005\u0007m\u0002\u0001\u000bQB.\u00021I,\u0007\u000f\\1dK&3WK\\7pI&4\u0017.\u001a3ISR\u001c\b\u0005C\u0004y\u0001\t\u0007IQ\u0002.\u00023I,\u0007\u000f\\1dK&3WK\\7pI&4\u0017.\u001a3CC\u00124\u0018\r\u001c\u0005\u0007u\u0002\u0001\u000bQB.\u00025I,\u0007\u000f\\1dK&3WK\\7pI&4\u0017.\u001a3CC\u00124\u0018\r\u001c\u0011\t\u000bq\u0004A\u0011I?\u0002\u0015I,\u0017\r\u001a%fC\u0012,'\u000fF\u0002\u007f\u0003\u0013\u0001R\u0001F@\u0002\u0004MK1!!\u0001\u0016\u0005\u0019!V\u000f\u001d7feA!A#!\u0002N\u0013\r\t9!\u0006\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005-1\u00101\u0001\u0002\u000e\u00051!-\u001e4gKJ\u0004B!a\u0004\u0002\u001c5\u0011\u0011\u0011\u0003\u0006\u0005\u0003\u0017\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011!\u00028fiRL(bAA\r\u0011\u0005)!NY8tg&!\u0011QDA\t\u00055\u0019\u0005.\u00198oK2\u0014UO\u001a4fe\"9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0012a\u0002:fC\u0012\\U-\u001f\u000b\u0005\u0003K\t9\u0003\u0005\u0003\u0015\u007fJ\u0019\u0006\u0002CA\u0015\u0003?\u0001\r!!\u0004\u0002\u0003\tDq!!\f\u0001\t\u0013\ty#\u0001\u0005sK\u0006$7*Z=t)\u0011\t\t$a\u000e\u0011\tQ\t\u0019DE\u0005\u0004\u0003k)\"!B!se\u0006L\b\u0002CA\u0015\u0003W\u0001\r!!\u0004\t\u000f\u0005m\u0002\u0001\"\u0015\u0002>\u0005\u0019q-\u001a;\u0015\t\u0005}\u0012Q\t\t\u0004)\u0005\u0005\u0013bAA\"+\t1\u0011I\\=SK\u001aD\u0001\"a\u0003\u0002:\u0001\u0007\u0011Q\u0002\u0005\b\u0003\u0013\u0002A\u0011BA&\u00039\u0019\u0007.Z2l\u0017\u0016LH*\u001a8hi\"$rAEA'\u0003#\n)\u0006C\u0004\u0002P\u0005\u001d\u0003\u0019\u0001\n\u0002\u0003-Dq!a\u0015\u0002H\u0001\u00071+A\u0004f]\u0012|em\u00149\t\u0011\u0005%\u0012q\ta\u0001\u0003\u001bAq!!\u0017\u0001\t\u0003\nY&\u0001\bsK\u0006$\u0007+\u0019:b[\u0016$XM]:\u0015\u000bM\u000bi&!\u001c\t\u0011\u0005}\u0013q\u000ba\u0001\u0003C\n!a\u00195\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KRA!a\u001a\u0002\u0014\u000591\r[1o]\u0016d\u0017\u0002BA6\u0003K\u0012qa\u00115b]:,G\u000e\u0003\u0005\u0002*\u0005]\u0003\u0019AA\u0007\u0011\u001d\t\t\b\u0001C\u0005\u0003g\nAC]3bIJ+Wn\u001c<f!\u0006\u0014\u0018-\\3uKJ\u001cHc\u0001%\u0002v!A\u0011qOA8\u0001\u0004\t\t$\u0001\u0003be\u001e\u001c\bbBA>\u0001\u0011%\u0011QP\u0001\u0017e\u0016\fG-\u00138de\u0012+7M\u001d)be\u0006lW\r^3sgR\u0019\u0001*a \t\u0011\u0005]\u0014\u0011\u0010a\u0001\u0003cAq!a!\u0001\t\u0013\t))\u0001\fsK\u0006$g\t\\;tQ\u0006cG\u000eU1sC6,G/\u001a:t)\rA\u0015q\u0011\u0005\t\u0003o\n\t\t1\u0001\u00022!9\u00111\u0012\u0001\u0005\n\u00055\u0015!\u0006:fC\u0012\u001cFo\u001c:bO\u0016\u0004\u0016M]1nKR,'o\u001d\u000b\u0006\u0011\u0006=\u0015\u0011\u0013\u0005\t\u0003o\nI\t1\u0001\u00022!A\u0011\u0011FAE\u0001\u0004\ti\u0001C\u0004\u0002\u0016\u0002!\t&a&\u0002\u0013I,\u0017\r\u001a,bYV,G\u0003BAM\u0003?\u00032\u0001FAN\u0013\r\ti*\u0006\u0002\u0005+:LG\u000f\u0003\u0005\u0002*\u0005M\u0005\u0019AA\u0007\u0011\u001d\t\u0019\u000b\u0001C!\u0003K\u000b1b\u0019:fCR,g+\u00197vKR\u0019A$a*\t\u0011\u0005%\u0016\u0011\u0015a\u0001\u0003W\u000b1B\\3yiZ+'o]5p]B\u0019A#!,\n\u0007\u0005=VC\u0001\u0003M_:<\u0007bBAZ\u0001\u0011%\u0011QW\u0001\tO\u0016$h\t\\1hgR!\u00111VA\\\u0011\u001d\tI,!-A\u0002I\tQA\u001a7bONDq!!0\u0001\t\u0013\ty,A\u0006hKRd\u0015NZ3ta\u0006tG\u0003BAa\u0003\u000f\u00042\u0001FAb\u0013\r\t)-\u0006\u0002\u0004\u0013:$\bbBAe\u0003w\u0003\rAE\u0001\tY&4Wm\u001d9b]\"9\u0011Q\u001a\u0001\u0005\n\u0005=\u0017!C4fi2+gn\u001a;i)\u0011\t\t-!5\t\u000f\u0005M\u00171\u001aa\u0001%\u00051A.\u001a8hi\"Dq!a6\u0001\t\u0013\tI.\u0001\u0006hKR4VM]:j_:$B!a+\u0002\\\"9\u0011Q\\Ak\u0001\u0004\u0011\u0012a\u0002<feNLwN\u001c\u0005\b\u0003C\u0004A\u0011BAr\u00031\u0001\u0018M]:f\u001d>\u0014V\r\u001d7z)\u0015\u0019\u0016Q]Au\u0011!\t9/a8A\u0002\u0005\u0005\u0017!D3ya\u0016\u001cG/\u001a3J]\u0012,\u0007\u0010\u0003\u0005\u0002x\u0005}\u0007\u0019AA\u0019\u0011\u001d\ti\u000f\u0001C\u0005\u0003_\fa\u0003]1sg\u0016$U\r\\1zK\u0012$U\r\\3uKRKW.\u001a\u000b\u0005\u0003\u0003\f\t\u0010\u0003\u0005\u0002x\u0005-\b\u0019AA\u0019\u0011\u001d\t)\u0010\u0001C!\u0003o\f\u0001bZ3u\u0007\u0006\u001c\u0007.Z\u000b\u0002Q!9\u00111 \u0001\u0005R\u0005u\u0018AE2vgR|W\u000eR3d_\u0012,\u0007*Z1eKJ$b!a\u0010\u0002\u0000\n\u0005\u0001\u0002CA0\u0003s\u0004\r!!\u0019\t\u0011\u0005-\u0011\u0011 a\u0001\u0003\u001bAqA!\u0002\u0001\t#\u00129!A\bdkN$x.\u001c#fG>$WmS3z)\u0019\tyD!\u0003\u0003\f!A\u0011q\fB\u0002\u0001\u0004\t\t\u0007\u0003\u0005\u0002\f\t\r\u0001\u0019AA\u0007\u0011\u001d\u0011y\u0001\u0001C)\u0005#\t\u0011cY;ti>lG)Z2pI\u00164\u0016\r\\;f)\u0019\tyDa\u0005\u0003\u0016!A\u0011q\fB\u0007\u0001\u0004\t\t\u0007\u0003\u0005\u0002\f\t5\u0001\u0019AA\u0007\u0011\u001d\u0011I\u0002\u0001C\u0005\u00057\t\u0001\"\u001b8de\u0012+7M\u001d\u000b\u0005\u0003\u007f\u0011i\u0002\u0003\u0005\u0002`\t]\u0001\u0019AA1\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005G\t\u0001B\u001a7vg\"\fE\u000e\u001c\u000b\t\u0003\u007f\u0011)Ca\n\u0003*!A\u0011\u0011\u0006B\u0010\u0001\u0004\ti\u0001\u0003\u0005\u0002`\t}\u0001\u0019AA1\u0011\u001d\u0011YCa\bA\u0002M\u000bA\"[:SK\u0006$\u0007+\u0019:b[NDqAa\f\u0001\t\u0013\u0011\t$A\u0007wC2LG-\u0019;f\t\u0016dG/\u0019\u000b\u0005\u0005g\u0011Y\u0005\u0005\u0003\u00036\t\u0015c\u0002\u0002B\u001c\u0005\u0003rAA!\u000f\u0003@5\u0011!1\b\u0006\u0004\u0005{Q\u0011A\u0002\u001fs_>$h(C\u0001\u0017\u0013\r\u0011\u0019%F\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119E!\u0013\u0003\r\tKw-\u00138u\u0015\r\u0011\u0019%\u0006\u0005\b\u0005\u001b\u0012i\u00031\u0001\u0013\u0003\u0015!W\r\u001c;b\u0011\u001d\u0011\t\u0006\u0001C!\u0005'\nQc\u0019:fCR,7+^2dKN\u001c(+Z:q_:\u001cX\r\u0006\u0003\u0002@\tU\u0003b\u0002B,\u0005\u001f\u0002\r\u0001H\u0001\u0005aJ,g\u000fC\u0004\u0003\\\u0001!\tE!\u0018\u00023\r\u0014X-\u0019;f\u001d>$X\t_3dkR,GMU3ta>t7/\u001a\u000b\u0005\u0003\u007f\u0011y\u0006C\u0004\u0003X\te\u0003\u0019\u0001\u000f\t\u000f\t\r\u0004\u0001\"\u0011\u0003f\u000512M]3bi\u0016tu\u000e^#ySN$(+Z:q_:\u001cX-\u0006\u0002\u0002@!9!\u0011\u000e\u0001\u0005B\t-\u0014!E2sK\u0006$XmR3u%\u0016\u001c\bo\u001c8tKR1\u0011q\bB7\u0005_Bq!a\u0014\u0003h\u0001\u0007!\u0003C\u0004\u0003r\t\u001d\u0004\u0019\u0001\u000f\u0002\u0003YDqA!\u001e\u0001\t\u0003\u00129(\u0001\fde\u0016\fG/Z'vYRLw)\u001a;SKN\u0004xN\\:f)\u0011\tyD!\u001f\t\u0011\tm$1\u000fa\u0001\u0005{\nQ\u0001]1jeN\u0004Ra\u0005B@%qI1A!!\u001c\u0005\ri\u0015\r\u001d\u0005\b\u0005\u000b\u0003A\u0011\tBD\u0003M\u0019'/Z1uK\u0016\u0013(o\u001c:SKN\u0004xN\\:f)\u0011\tyD!#\t\u0011\t-%1\u0011a\u0001\u0005\u001b\u000b\u0011\u0001\u001e\t\u0005\u0005k\u0011y)\u0003\u0003\u0003\u0012\n%#!\u0003+ie><\u0018M\u00197f\u0011\u001d\u0011)\n\u0001C\u0005\u0005/\u000b\u0001\u0004\\8h\u0003:$7I]3bi\u0016,%O]8s\u001b\u0016\u001c8/Y4f)\u0019\u0011IJa(\u0003$B!!Q\u0007BN\u0013\u0011\u0011iJ!\u0013\u0003\u001bM#(/\u001b8h\u0005VLG\u000eZ3s\u0011!\u0011\tKa%A\u0002\te\u0015AA:c\u0011!\u0011)Ka%A\u0002\t\u001d\u0016!A7\u0011\u0007u\u0011I+C\u0002\u0003,\n\u0011!#T3nG\u0006\u001c\u0007.\u001a3Fq\u000e,\u0007\u000f^5p]\"9!q\u0016\u0001\u0005R\tE\u0016!F2sK\u0006$XmU3sm\u0016\u0014X\t_2faRLwN\u001c\u000b\u0007\u0005g\u0013)La0\u0011\u000bQy(qU*\t\u0011\t]&Q\u0016a\u0001\u0005s\u000b\u0011!\u001a\t\u0005\u0005k\u0011Y,\u0003\u0003\u0003>\n%#!C#yG\u0016\u0004H/[8o\u0011!\tIC!,A\u0002\u00055\u0001b\u0002Bb\u0001\u0011%!QY\u0001\rG2|7/Z\"iC:tW\r\u001c\u000b\u0005\u0003\u007f\u00119\r\u0003\u0005\u0002`\t\u0005\u0007\u0019AA1\u0011\u001d\u0011Y\r\u0001C!\u0005K\n1c\u0019:fCR,7\u000b^1ugJ+7\u000f]8og\u0016DqAa4\u0001\t\u0013\u0011\t.A\u0005ck&dGm\u0015;biRA\u0011Q\u0002Bj\u0005/\u0014\t\u000fC\u0004\u0003V\n5\u0007\u0019\u0001\n\u0002\tM$\u0018\r\u001e\u0005\t\u00053\u0014i\r1\u0001\u0003\\\u0006)a/\u00197vKB\u0019AC!8\n\u0007\t}WCA\u0002B]fD\u0001B!)\u0003N\u0002\u0007!\u0011\u0014\u0005\b\u0003G\u0003A\u0011\u0002Bs)\u001da\"q\u001dBz\u0005kD\u0001B!;\u0003d\u0002\u0007!1^\u0001\u0005I\u0006$\u0018\rE\u0003\u0015\u0003g\u0011i\u000fE\u0002\u0015\u0005_L1A!=\u0016\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0005%&1\u001da\u0001\u0003WC\u0001\"!/\u0003d\u0002\u0007\u00111\u0016\u0005\b\u0005s\u0004A\u0011\u0002B~\u0003A\u0011W/\u001b7e\u000f\u0016$(+Z:q_:\u001cX\r\u0006\u0005\u0002\u000e\tu8QBB\b\u0011!\u0011yPa>A\u0002\r\u0005\u0011AA8q!\u0011\u0019\u0019a!\u0003\u0011\u0007Q\u0019)!C\u0002\u0004\bU\u00111\"\u00128v[\u0016\u0014\u0018\r^5p]&!11BB\u0003\u0005\u00151\u0016\r\\;f\u0011\u001d\tyEa>A\u0002IAqA!\u001d\u0003x\u0002\u0007A\u0004C\u0004\u0004\u0014\u0001!Ia!\u0006\u0002-\t,\u0018\u000e\u001c3HKR\u0014Vm\u001d9p]N,\u0007*Z1eKJ$rAEB\f\u00073\u0019Y\u0002C\u0004\u0002P\rE\u0001\u0019\u0001\n\t\u000f\tE4\u0011\u0003a\u00019!A!q`B\t\u0001\u0004\u0019\t\u0001C\u0004\u0004 \u0001!Ia!\t\u0002'\u0019\u0014\u0018.\u001a8eYfl\u0015\r_%oi\u000eCWmY6\u0015\r\u0005\u000571EB\u0014\u0011\u001d\u0019)c!\bA\u0002I\taA\\;nE\u0016\u0014\bbBB\u0015\u0007;\u0001\rAE\u0001\b[\u0016\u001c8/Y4f\u0011\u001d\u0019i\u0003\u0001C\u0005\u0007_\t\u0011C\\;nKJL7\rT5nSR\u001c\u0005.Z2l))\t\tm!\r\u00044\r]2\u0011\b\u0005\b\u0007K\u0019Y\u00031\u0001\u0013\u0011!\u0019)da\u000bA\u0002\u0005-\u0016\u0001C7bqZ\u000bG.^3\t\u000f\r%21\u0006a\u0001%!A11HB\u0016\u0001\u0004\u0019i$A\u0001o!\u0011\u0011)da\u0010\n\t\r\u0005#\u0011\n\u0002\u0016\u001dVl'-\u001a:G_Jl\u0017\r^#yG\u0016\u0004H/[8o\u0011\u001d\u0019i\u0003\u0001C\u0005\u0007\u000b\"\u0002\"a+\u0004H\r%31\n\u0005\b\u0007K\u0019\u0019\u00051\u0001\u0013\u0011!\u0019)da\u0011A\u0002\u0005-\u0006bBB\u0015\u0007\u0007\u0002\rA\u0005")
public class MemcachedDecoder
extends AbstractProtocolDecoder<String, MemcachedValue>
implements TextProtocolUtil,
ScalaObject {
    private final ScheduledExecutorService scheduler;
    private final NettyTransport transport;
    private boolean isStatsEnabled;
    private final AtomicLong incrMisses;
    private final AtomicLong incrHits;
    private final AtomicLong decrMisses;
    private final AtomicLong decrHits;
    private final AtomicLong replaceIfUnmodifiedMisses;
    private final AtomicLong replaceIfUnmodifiedHits;
    private final AtomicLong replaceIfUnmodifiedBadval;
    private final String CRLF;
    private final byte[] CRLFBytes;
    private final byte[] END;
    private final byte[] DELETED;
    private final byte[] NOT_FOUND;
    private final byte[] EXISTS;
    private final byte[] STORED;
    private final byte[] NOT_STORED;
    private final byte[] OK;
    private final byte[] ERROR;
    private final String CLIENT_ERROR_BAD_FORMAT;
    private final String SERVER_ERROR;
    private final int CR;
    private final int LF;
    private final BigInt MAX_UNSIGNED_LONG;
    private final BigInt MIN_UNSIGNED;
    private volatile int bitmap$priv$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStatsEnabled() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.isStatsEnabled;
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.isStatsEnabled = this.cache().getConfiguration().isExposeJmxStatistics();
                this.bitmap$priv$0 |= 1;
            }
            return this.isStatsEnabled;
        }
    }

    private final AtomicLong incrMisses() {
        return this.incrMisses;
    }

    private final AtomicLong incrHits() {
        return this.incrHits;
    }

    private final AtomicLong decrMisses() {
        return this.decrMisses;
    }

    private final AtomicLong decrHits() {
        return this.decrHits;
    }

    private final AtomicLong replaceIfUnmodifiedMisses() {
        return this.replaceIfUnmodifiedMisses;
    }

    private final AtomicLong replaceIfUnmodifiedHits() {
        return this.replaceIfUnmodifiedHits;
    }

    private final AtomicLong replaceIfUnmodifiedBadval() {
        return this.replaceIfUnmodifiedBadval;
    }

    public Tuple2<Option<RequestHeader>, Object> readHeader(ChannelBuffer buffer) {
        Tuple2<String, Object> tuple2 = this.readElement(buffer);
        if (tuple2 != null) {
            Option<Enumeration.Value> op;
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            String streamOp = (String)tuple22._1();
            boolean endOfOp = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
            Option<Enumeration.Value> option = op = RequestResolver$.MODULE$.toRequest(streamOp);
            None$ none$ = None$.MODULE$;
            if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
                Object object = endOfOp ? BoxedUnit.UNIT : this.readLine(buffer);
                throw new UnknownOperationException(new StringBuilder().append((Object)"Unknown operation: ").append((Object)streamOp).toString());
            }
            Object object = op.get();
            Enumeration.Value value = Operation$.MODULE$.StatsRequest();
            if (!(object != null ? !object.equals(value) : value != null) && !endOfOp) {
                String line = this.readLine(buffer).trim();
                if (line.isEmpty()) {
                    endOfOp = true;
                } else {
                    throw new StreamCorruptedException(new StringBuilder().append((Object)"Stats command does not accept arguments: ").append((Object)line).toString());
                }
            }
            Object object2 = op.get();
            Enumeration.Value value2 = MemcachedOperation$.MODULE$.VerbosityRequest();
            if (!(object2 != null ? !object2.equals(value2) : value2 != null)) {
                Object object3 = endOfOp ? BoxedUnit.UNIT : this.readLine(buffer);
                throw new StreamCorruptedException("Memcached 'verbosity' command is unsupported");
            }
            return new Tuple2((Object)new Some((Object)new RequestHeader((Enumeration.Value)op.get())), (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<String, Object> readKey(ChannelBuffer b) {
        Tuple2<String, Object> tuple2 = this.readElement(b);
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            String k = (String)tuple22._1();
            boolean endOfOp = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
            this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, endOfOp, b);
            return new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
        }
        throw new MatchError(tuple2);
    }

    private String[] readKeys(ChannelBuffer b) {
        return this.readLine(b).trim().split(" +");
    }

    public Object get(ChannelBuffer buffer$1) {
        Object object;
        String[] keys = this.readKeys(buffer$1);
        if (keys.length > 1) {
            scala.collection.mutable.HashMap map$1 = new scala.collection.mutable.HashMap();
            Predef$.MODULE$.refArrayOps((Object[])keys).foreach((Function1)new scala.Serializable(this, buffer$1, map$1){
                public static final long serialVersionUID;
                private final MemcachedDecoder $outer;
                private final ChannelBuffer buffer$1;
                private final scala.collection.mutable.HashMap map$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(String k) {
                    MemcachedValue v = (MemcachedValue)((Object)this.$outer.cache().get(this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, true, this.buffer$1)));
                    return v == null ? BoxedUnit.UNIT : this.map$1.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)k).$minus$greater((Object)((Object)v)));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.buffer$1 = channelBuffer;
                    this.map$1 = hashMap;
                }
            });
            object = this.createMultiGetResponse((Map<String, MemcachedValue>)new HashMap().$plus$plus((GenTraversableOnce)map$1));
        } else {
            object = this.createGetResponse((String)Predef$.MODULE$.refArrayOps((Object[])keys).head(), (MemcachedValue)((Object)this.cache().get(this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength((String)Predef$.MODULE$.refArrayOps((Object[])keys).head(), true, buffer$1))));
        }
        return object;
    }

    public final String org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(String k, boolean endOfOp, ChannelBuffer b) {
        if (k.length() > 250) {
            Object object = endOfOp ? BoxedUnit.UNIT : this.readLine(b);
            throw new StreamCorruptedException("Key length over the 250 character limit");
        }
        return k;
    }

    public boolean readParameters(Channel ch, ChannelBuffer b$1) {
        MemcachedParameters memcachedParameters;
        String line$1 = this.readLine(b$1);
        BooleanRef endOfOp$1 = new BooleanRef(false);
        if (line$1.isEmpty()) {
            memcachedParameters = null;
        } else {
            if (this.isTraceEnabled()) {
                this.trace((Function0)new scala.Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Operation parameters: %s";
                    }
                }, line$1);
            }
            String[] args$1 = line$1.trim().split(" +");
            memcachedParameters = this.liftedTree1$1(b$1, line$1, endOfOp$1, args$1);
        }
        this.params_$eq(memcachedParameters);
        return endOfOp$1.elem;
    }

    private MemcachedParameters readRemoveParameters(String[] args) {
        int delayedDeleteTime = this.parseDelayedDeleteTime(args);
        boolean noReply = delayedDeleteTime == -1 ? this.parseNoReply(0, args) : false;
        return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", 0);
    }

    private MemcachedParameters readIncrDecrParameters(String[] args) {
        String delta = args[0];
        return new MemcachedParameters(-1, -1, -1, -1L, this.parseNoReply(1, args), 0L, delta, 0);
    }

    private MemcachedParameters readFlushAllParameters(String[] args) {
        NumberFormatException numberFormatException2;
        block2: {
            boolean noReplyFound = false;
            int exceptionResult1 = 0;
            try {
                exceptionResult1 = this.friendlyMaxIntCheck(args[0], "Flush delay");
            }
            catch (NumberFormatException numberFormatException2) {
                if (!numberFormatException2.getMessage().contains("noreply")) break block2;
                noReplyFound = true;
                exceptionResult1 = 0;
            }
            int flushDelay = exceptionResult1;
            boolean noReply = noReplyFound ? true : this.parseNoReply(1, args);
            return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", flushDelay);
        }
        throw numberFormatException2;
    }

    private MemcachedParameters readStorageParameters(String[] args, ChannelBuffer b) {
        int length;
        int streamLifespan;
        int index = 0;
        long flags = this.getFlags(args[index]);
        if (flags < 0L) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Flags cannot be negative: ").append((Object)BoxesRunTime.boxToLong((long)flags)).toString());
        }
        int lifespan = (streamLifespan = this.getLifespan(args[++index])) <= 0 ? -1 : streamLifespan;
        if ((length = this.getLength(args[++index])) < 0) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Negative bytes length provided: ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString());
        }
        Enumeration.Value value = this.header().op();
        Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
        Enumeration.Value value3 = value;
        long streamVersion = !(value2 != null ? !value2.equals(value3) : value3 != null) ? this.getVersion(args[++index]) : -1L;
        boolean noReply = this.parseNoReply(++index, args);
        return new MemcachedParameters(length, lifespan, -1, streamVersion, noReply, flags, "", 0);
    }

    public void readValue(ChannelBuffer b) {
        b.readBytes(this.rawValue());
        this.readLine(b);
    }

    public MemcachedValue createValue(long nextVersion) {
        return new MemcachedValue(this.rawValue(), nextVersion, ((MemcachedParameters)this.params()).flags());
    }

    /*
     * WARNING - void declaration
     */
    private long getFlags(String flags) {
        void var2_2;
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        long exceptionResult2 = 0L;
        try {
            exceptionResult2 = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags");
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult2 = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags", numberFormatException);
        }
        return (long)var2_2;
    }

    private int getLifespan(String lifespan) {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return this.friendlyMaxIntCheck(lifespan, "Lifespan");
    }

    private int getLength(String length) {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return this.friendlyMaxIntCheck(length, "The number of bytes");
    }

    private long getVersion(String version) {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return Predef$.MODULE$.augmentString(version).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNoReply(int expectedIndex, String[] args) {
        if (args.length <= expectedIndex) return false;
        String string = args[expectedIndex];
        if ("noreply" != null) {
            if (!"noreply".equals(string)) throw new StreamCorruptedException("Unable to parse noreply optional argument");
            return true;
        }
        if (string == null) return true;
        throw new StreamCorruptedException("Unable to parse noreply optional argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDelayedDeleteTime(String[] args) {
        int n;
        if (args.length <= 0) return 0;
        int exceptionResult3 = 0;
        try {
            n = exceptionResult3 = Predef$.MODULE$.augmentString(args[0]).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public Cache<String, MemcachedValue> getCache() {
        return this.cache();
    }

    public Object customDecodeHeader(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        value = this.header().op();
                        Enumeration.Value value2 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        object = this.flushAll(buffer, ch, false);
                        break block3;
                    }
                    Enumeration.Value value4 = MemcachedOperation$.MODULE$.VersionRequest();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    StringBuilder ret = new StringBuilder().append("VERSION ").append(Version.VERSION).append(this.CRLF());
                    object = this.writeResponse(ch, ret);
                    break block3;
                }
                Enumeration.Value value6 = MemcachedOperation$.MODULE$.QuitRequest();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                object = this.closeChannel(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeKey(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block5: {
            Object object;
            block4: {
                block3: {
                    block2: {
                        value = this.header().op();
                        Enumeration.Value value2 = MemcachedOperation$.MODULE$.AppendRequest();
                        Enumeration.Value value3 = value;
                        if (!(value2 == null ? value3 != null : !value2.equals(value3))) break block2;
                        Enumeration.Value value4 = MemcachedOperation$.MODULE$.PrependRequest();
                        Enumeration.Value value5 = value;
                        if (!(value4 == null ? value5 != null : !value4.equals(value5))) break block2;
                        Enumeration.Value value6 = MemcachedOperation$.MODULE$.IncrementRequest();
                        Enumeration.Value value7 = value;
                        if (!(value6 == null ? value7 != null : !value6.equals(value7))) break block2;
                        Enumeration.Value value8 = MemcachedOperation$.MODULE$.DecrementRequest();
                        Enumeration.Value value9 = value;
                        if (value8 != null ? !value8.equals(value9) : value9 != null) break block3;
                    }
                    this.key_$eq(this.readKey(buffer)._1());
                    object = this.checkpointTo(DecoderState.DECODE_PARAMETERS);
                    break block4;
                }
                Enumeration.Value value10 = MemcachedOperation$.MODULE$.FlushAllRequest();
                Enumeration.Value value11 = value;
                if (value10 != null ? !value10.equals(value11) : value11 != null) break block5;
                object = this.flushAll(buffer, ch, true);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeValue(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block15: {
            Object object;
            block13: {
                block14: {
                    block7: {
                        Enumeration.Value value2;
                        block12: {
                            Object object2;
                            block9: {
                                byte[] byArray;
                                MemcachedValue prev;
                                block11: {
                                    block10: {
                                        block8: {
                                            block6: {
                                                Enumeration.Value op;
                                                value = op = this.header().op();
                                                Enumeration.Value value3 = MemcachedOperation$.MODULE$.AppendRequest();
                                                Enumeration.Value value4 = value;
                                                if (!(value3 == null ? value4 != null : !value3.equals(value4))) break block6;
                                                Enumeration.Value value5 = MemcachedOperation$.MODULE$.PrependRequest();
                                                Enumeration.Value value6 = value;
                                                if (value5 != null ? !value5.equals(value6) : value6 != null) break block7;
                                            }
                                            this.readValue(buffer);
                                            prev = (MemcachedValue)((Object)this.cache().get(this.key()));
                                            if (prev != null) break block8;
                                            object2 = ((MemcachedParameters)this.params()).noReply() ? null : this.NOT_STORED();
                                            break block9;
                                        }
                                        value2 = this.header().op();
                                        Enumeration.Value value7 = MemcachedOperation$.MODULE$.AppendRequest();
                                        Enumeration.Value value8 = value2;
                                        if (value7 != null ? !value7.equals(value8) : value8 != null) break block10;
                                        byArray = this.concat(prev.data(), this.rawValue());
                                        break block11;
                                    }
                                    Enumeration.Value value9 = MemcachedOperation$.MODULE$.PrependRequest();
                                    Enumeration.Value value10 = value2;
                                    if (value9 != null ? !value9.equals(value10) : value10 != null) break block12;
                                    byArray = this.concat(this.rawValue(), prev.data());
                                }
                                byte[] concatenated = byArray;
                                MemcachedValue next = this.createValue(concatenated, this.generateVersion(this.cache()), ((MemcachedParameters)this.params()).flags());
                                boolean replaced = this.cache().replace(this.key(), prev, next);
                                object2 = replaced ? (Object)(((MemcachedParameters)this.params()).noReply() ? null : this.STORED()) : (Object)(((MemcachedParameters)this.params()).noReply() ? null : this.NOT_STORED());
                            }
                            byte[] ret = object2;
                            object = this.writeResponse(ch, ret);
                            break block13;
                        }
                        throw new MatchError((Object)value2);
                    }
                    Enumeration.Value value11 = MemcachedOperation$.MODULE$.IncrementRequest();
                    Enumeration.Value value12 = value;
                    if (!(value11 == null ? value12 != null : !value11.equals(value12))) break block14;
                    Enumeration.Value value13 = MemcachedOperation$.MODULE$.DecrementRequest();
                    Enumeration.Value value14 = value;
                    if (value13 != null ? !value13.equals(value14) : value14 != null) break block15;
                }
                object = this.incrDecr(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    private Object incrDecr(Channel ch) {
        Enumeration.Value value;
        block9: {
            BigInt prevCounter;
            block10: {
                Object object;
                block6: {
                    Object object2;
                    Enumeration.Value op;
                    MemcachedValue prev;
                    block8: {
                        BigInt delta;
                        block7: {
                            block5: {
                                Object object3;
                                prev = (MemcachedValue)((Object)this.cache().get(this.key()));
                                op = this.header().op();
                                if (prev != null) break block5;
                                if (this.isStatsEnabled()) {
                                    Enumeration.Value value2 = op;
                                    Enumeration.Value value3 = MemcachedOperation$.MODULE$.IncrementRequest();
                                    object3 = BoxesRunTime.boxToLong((long)(!(value2 != null ? !value2.equals(value3) : value3 != null) ? this.incrMisses().incrementAndGet() : this.decrMisses().incrementAndGet()));
                                } else {
                                    object3 = BoxedUnit.UNIT;
                                }
                                object = ((MemcachedParameters)this.params()).noReply() ? null : (Serializable)this.NOT_FOUND();
                                break block6;
                            }
                            prevCounter = package$.MODULE$.BigInt().apply(new String(prev.data()));
                            delta = this.validateDelta(((MemcachedParameters)this.params()).delta());
                            value = op;
                            Enumeration.Value value4 = MemcachedOperation$.MODULE$.IncrementRequest();
                            Enumeration.Value value5 = value;
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block7;
                            BigInt candidateCounter = prevCounter.$plus(delta);
                            object2 = candidateCounter.$greater(this.MAX_UNSIGNED_LONG()) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                            break block8;
                        }
                        Enumeration.Value value6 = MemcachedOperation$.MODULE$.DecrementRequest();
                        Enumeration.Value value7 = value;
                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block9;
                        BigInt candidateCounter = prevCounter.$minus(delta);
                        object2 = candidateCounter.$less(BigInt$.MODULE$.int2bigInt(0)) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                    }
                    Object newCounter = object2;
                    MemcachedValue next = this.createValue(newCounter.toString().getBytes(), this.generateVersion(this.cache()), ((MemcachedParameters)this.params()).flags());
                    boolean replaced = this.cache().replace(this.key(), prev, next);
                    if (replaced) {
                        Object object4;
                        if (this.isStatsEnabled()) {
                            Enumeration.Value value8 = op;
                            Enumeration.Value value9 = MemcachedOperation$.MODULE$.IncrementRequest();
                            object4 = BoxesRunTime.boxToLong((long)(!(value8 != null ? !value8.equals(value9) : value9 != null) ? this.incrHits().incrementAndGet() : this.decrHits().incrementAndGet()));
                        } else {
                            object4 = BoxedUnit.UNIT;
                        }
                        object = ((MemcachedParameters)this.params()).noReply() ? null : new StringBuilder().append((Object)new String(next.data())).append((Object)this.CRLF()).toString();
                    }
                    break block10;
                }
                Serializable ret = object;
                return this.writeResponse(ch, ret);
            }
            throw new CacheException(new StringBuilder().append((Object)"Value modified since we retrieved from the cache, old value was ").append((Object)prevCounter).toString());
        }
        throw new MatchError((Object)value);
    }

    private Object flushAll(ChannelBuffer b, Channel ch, boolean isReadParams) {
        Object object = isReadParams ? BoxesRunTime.boxToBoolean((boolean)this.readParameters(ch, b)) : BoxedUnit.UNIT;
        scala.Serializable flushFunction = new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(AdvancedCache<String, MemcachedValue> cache) {
                cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_STORE}).clear();
            }
        };
        int flushDelay = this.params() == null ? 0 : ((MemcachedParameters)this.params()).flushDelay();
        ScheduledFuture<?> scheduledFuture = flushDelay == 0 ? flushFunction.apply((Object)this.cache().getAdvancedCache()) : this.scheduler.schedule(new DelayedFlushAll((Cache<String, MemcachedValue>)this.cache(), (Function1<AdvancedCache<String, MemcachedValue>, BoxedUnit>)flushFunction), this.toMillis(flushDelay), TimeUnit.MILLISECONDS);
        byte[] ret = (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : this.OK());
        return this.writeResponse(ch, ret);
    }

    /*
     * WARNING - void declaration
     */
    private BigInt validateDelta(String delta) {
        void var2_2;
        BigInt bigIntDelta = package$.MODULE$.BigInt().apply(delta);
        if (bigIntDelta.$greater(this.MAX_UNSIGNED_LONG())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta sent (").append((Object)delta).append((Object)") exceeds unsigned limit (").append((Object)this.MAX_UNSIGNED_LONG()).append((Object)")").toString());
        }
        if (bigIntDelta.$less(this.MIN_UNSIGNED())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta cannot be negative: ").append((Object)delta).toString());
        }
        return var2_2;
    }

    public Object createSuccessResponse(MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedHits().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.RemoveRequest();
            Enumeration.Value value5 = value;
            byArray = !(value4 != null ? !value4.equals(value5) : value5 != null) ? this.DELETED() : this.STORED();
        }
        return byArray;
    }

    public Object createNotExecutedResponse(MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedBadval().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value5 = value;
            byArray = !(value4 != null ? !value4.equals(value5) : value5 != null) ? this.EXISTS() : this.NOT_STORED();
        }
        return byArray;
    }

    public Object createNotExistResponse() {
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedMisses().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : this.NOT_FOUND());
    }

    public Object createGetResponse(String k, MemcachedValue v) {
        return v == null ? this.END() : (byte[])List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(this.header().op(), k, v), ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()}))}));
    }

    public Object createMultiGetResponse(Map<String, MemcachedValue> pairs) {
        Enumeration.Value value;
        block3: {
            Enumeration.Value op$1;
            ListBuffer elements$1;
            block2: {
                elements$1 = new ListBuffer();
                value = op$1 = this.header().op();
                Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
                Enumeration.Value value3 = value;
                if (!(value2 == null ? value3 != null : !value2.equals(value3))) break block2;
                Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block3;
            }
            ((IterableLike)pairs.filter((Function1)new scala.Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<String, MemcachedValue> tuple2) {
                    Tuple2<String, MemcachedValue> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new scala.Serializable(this, elements$1, op$1){
                public static final long serialVersionUID;
                private final MemcachedDecoder $outer;
                private final ListBuffer elements$1;
                private final Enumeration.Value op$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final ListBuffer<ChannelBuffer> apply(Tuple2<String, MemcachedValue> tuple2) {
                    Tuple2<String, MemcachedValue> tuple22 = tuple2;
                    if (tuple22 != null) {
                        return this.elements$1.$plus$eq((Object)this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(this.op$1, (String)tuple22._1(), (MemcachedValue)((Object)tuple22._2())));
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.elements$1 = listBuffer;
                    this.op$1 = value;
                }
            });
            elements$1.$plus$eq((Object)ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()})));
            return elements$1.toList();
        }
        throw new MatchError((Object)value);
    }

    public Object createErrorResponse(Throwable t) {
        Object object;
        StringBuilder sb = new StringBuilder();
        Throwable throwable = t;
        if (throwable instanceof MemcachedException) {
            MemcachedException memcachedException = (MemcachedException)throwable;
            MemcachedException m = memcachedException;
            Throwable throwable2 = m.getCause();
            if (throwable2 instanceof UnknownOperationException) {
                this.logExceptionReported((Throwable)((UnknownOperationException)throwable2));
                object = this.ERROR();
            } else if (throwable2 instanceof ClosedChannelException) {
                this.logExceptionReported((ClosedChannelException)throwable2);
                object = null;
            } else {
                object = throwable2 instanceof IOException ? this.logAndCreateErrorMessage(sb, m) : (throwable2 instanceof NumberFormatException ? this.logAndCreateErrorMessage(sb, m) : (throwable2 instanceof IllegalStateException ? this.logAndCreateErrorMessage(sb, m) : sb.append(m.getMessage()).append(this.CRLF())));
            }
        } else if (throwable instanceof ClosedChannelException) {
            this.logExceptionReported((ClosedChannelException)throwable);
            object = null;
        } else {
            object = sb.append(this.SERVER_ERROR()).append(t.getMessage()).append(this.CRLF());
        }
        return object;
    }

    private StringBuilder logAndCreateErrorMessage(StringBuilder sb, MemcachedException m) {
        this.logExceptionReported(m.getCause());
        return sb.append(m.getMessage()).append(this.CRLF());
    }

    public Tuple2<MemcachedException, Object> createServerException(Exception e, ChannelBuffer b) {
        Tuple2 tuple2;
        Exception exception = e;
        if (exception instanceof IOException) {
            IOException iOException;
            IOException i = iOException = (IOException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)this.CLIENT_ERROR_BAD_FORMAT()).append((Object)i.getMessage()).toString(), i), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (exception instanceof NumberFormatException) {
            NumberFormatException numberFormatException;
            NumberFormatException n = numberFormatException = (NumberFormatException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)this.CLIENT_ERROR_BAD_FORMAT()).append((Object)n.getMessage()).toString(), n), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)this.SERVER_ERROR()).append((Object)e).toString(), e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple2;
    }

    private Object closeChannel(Channel ch) {
        ch.close();
        return null;
    }

    public Object createStatsResponse() {
        Stats stats = this.cache().getAdvancedCache().getStats();
        StringBuilder sb = new StringBuilder();
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.buildStat("pid", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("time", BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())), sb), this.buildStat("version", this.cache().getVersion(), sb), this.buildStat("pointer_size", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_user", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_system", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_items", BoxesRunTime.boxToInteger((int)stats.getCurrentNumberOfEntries()), sb), this.buildStat("total_items", BoxesRunTime.boxToLong((long)stats.getTotalNumberOfEntries()), sb), this.buildStat("bytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("total_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("connection_structures", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("cmd_get", BoxesRunTime.boxToLong((long)stats.getRetrievals()), sb), this.buildStat("cmd_set", BoxesRunTime.boxToLong((long)stats.getStores()), sb), this.buildStat("get_hits", BoxesRunTime.boxToLong((long)stats.getHits()), sb), this.buildStat("get_misses", BoxesRunTime.boxToLong((long)stats.getMisses()), sb), this.buildStat("delete_misses", BoxesRunTime.boxToLong((long)stats.getRemoveMisses()), sb), this.buildStat("delete_hits", BoxesRunTime.boxToLong((long)stats.getRemoveHits()), sb), this.buildStat("incr_misses", this.incrMisses(), sb), this.buildStat("incr_hits", this.incrHits(), sb), this.buildStat("decr_misses", this.decrMisses(), sb), this.buildStat("decr_hits", this.decrHits(), sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses(), sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits(), sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval(), sb), this.buildStat("auth_cmds", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("auth_errors", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("evictions", BoxesRunTime.boxToLong((long)stats.getEvictions()), sb), this.buildStat("bytes_read", this.transport.getTotalBytesRead(), sb), this.buildStat("bytes_written", this.transport.getTotalBytesWritten(), sb), this.buildStat("limit_maxbytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("threads", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("conn_yields", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("reclaimed", BoxesRunTime.boxToInteger((int)0), sb), ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{this.END()}))}));
    }

    private ChannelBuffer buildStat(String stat, Object value, StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append(this.CRLF());
        ChannelBuffer buffer = ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sb.toString().getBytes()}));
        sb.setLength(0);
        return buffer;
    }

    private MemcachedValue createValue(byte[] data, long nextVersion, long flags) {
        return new MemcachedValue(data, nextVersion, flags);
    }

    public final ChannelBuffer org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(Enumeration.Value op, String k, MemcachedValue v) {
        String header = this.buildGetResponseHeader(k, v, op);
        return ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{header.getBytes(), v.data(), this.CRLFBytes()}));
    }

    private String buildGetResponseHeader(String k, MemcachedValue v, Enumeration.Value op) {
        StringBuilder sb = new StringBuilder();
        sb.append("VALUE ").append(k).append(" ").append(v.flags()).append(" ").append(v.data().length);
        Enumeration.Value value = op;
        Enumeration.Value value2 = Operation$.MODULE$.GetWithVersionRequest();
        Object object = !(value != null ? !value.equals(value2) : value2 != null) ? sb.append(" ").append(v.version()) : BoxedUnit.UNIT;
        sb.append(this.CRLF());
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private int friendlyMaxIntCheck(String number, String message) {
        void var3_3;
        int exceptionResult4 = 0;
        try {
            exceptionResult4 = Predef$.MODULE$.augmentString(number).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult4 = this.numericLimitCheck(number, Integer.MAX_VALUE, message, numberFormatException);
        }
        return (int)var3_3;
    }

    private int numericLimitCheck(String number, long maxValue, String message, NumberFormatException n) {
        if (Predef$.MODULE$.augmentString(number).toLong() > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        throw n;
    }

    private long numericLimitCheck(String number, long maxValue, String message) {
        long numeric = Predef$.MODULE$.augmentString(number).toLong();
        if (Predef$.MODULE$.augmentString(number).toLong() > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        return numeric;
    }

    /*
     * Unable to fully structure code
     */
    private final MemcachedParameters liftedTree1$1(ChannelBuffer var1_1, String var2_2, BooleanRef var3_3, String[] var4_4) {
        exceptionResult5 = null;
        try {
            block5: {
                block4: {
                    var6_6 = this.header().op();
                    v0 = Operation$.MODULE$.RemoveRequest();
                    var7_7 = var6_6;
                    if (v0 != null ? v0.equals(var7_7) == false : var7_7 != null) break block4;
                    v1 = this.readRemoveParameters(var4_4);
                    break block5;
                }
                v2 = MemcachedOperation$.MODULE$.IncrementRequest();
                var8_8 = var6_6;
                if (!(v2 == null ? var8_8 != null : v2.equals(var8_8) == false)) ** GOTO lbl-1000
                v3 = MemcachedOperation$.MODULE$.DecrementRequest();
                var9_9 = var6_6;
                if (!(v3 != null ? v3.equals(var9_9) == false : var9_9 != null)) lbl-1000:
                // 2 sources

                {
                    var3_3.elem = true;
                    v1 = this.readIncrDecrParameters(var4_4);
                } else {
                    v4 = MemcachedOperation$.MODULE$.FlushAllRequest();
                    var10_10 = var6_6;
                    v1 = !(v4 != null ? v4.equals(var10_10) == false : var10_10 != null) ? this.readFlushAllParameters(var4_4) : this.readStorageParameters(var4_4, var1_1);
                }
            }
            exceptionResult5 = v1;
            return exceptionResult5;
        }
        catch (ArrayIndexOutOfBoundsException v5) {
            throw new IOException(new StringBuilder().append((Object)"Missing content in command line ").append((Object)var2_2).toString());
        }
    }

    public MemcachedDecoder(Cache<String, MemcachedValue> memcachedCache, ScheduledExecutorService scheduler, NettyTransport transport) {
        this.scheduler = scheduler;
        this.transport = transport;
        super(transport);
        TextProtocolUtil$class.$init$(this);
        this.cache_$eq(memcachedCache);
        this.incrMisses = new AtomicLong(0L);
        this.incrHits = new AtomicLong(0L);
        this.decrMisses = new AtomicLong(0L);
        this.decrHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedMisses = new AtomicLong(0L);
        this.replaceIfUnmodifiedHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedBadval = new AtomicLong(0L);
    }
}

