/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.MemcachedServer$;
import org.infinispan.server.memcached.MemcachedSingleNodeTest;
import org.infinispan.server.memcached.NoReplyListener;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Test(groups={"functional"}, testName="server.memcached.MemcachedFunctionalTest")
@ScalaSignature(bytes="\u0006\u0001\t=d\u0001B\u0001\u0003\u0001-\u0011q#T3nG\u0006\u001c\u0007.\u001a3Gk:\u001cG/[8oC2$Vm\u001d;\u000b\u0005\r!\u0011!C7f[\u000e\f7\r[3e\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000f!\t!\"\u001b8gS:L7\u000f]1o\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r!A\u0011QBD\u0007\u0002\u0005%\u0011qB\u0001\u0002\u0018\u001b\u0016l7-Y2iK\u0012\u001c\u0016N\\4mK:{G-\u001a+fgR\u0004\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u00111bU2bY\u0006|%M[3di\")q\u0003\u0001C\u00011\u00051A(\u001b8jiz\"\u0012!\u0007\t\u0003\u001b\u0001AQa\u0007\u0001\u0005\u0002q\tA\u0002^3tiN+GOQ1tS\u000e$\"!\b\u0011\u0011\u0005Eq\u0012BA\u0010\u0013\u0005\u0011)f.\u001b;\t\u000b\u0005R\u0002\u0019\u0001\u0012\u0002\u00035\u0004\"a\t\u0016\u000e\u0003\u0011R!!\n\u0014\u0002\u000fI,g\r\\3di*\u0011q\u0005K\u0001\u0005Y\u0006twMC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-\"#AB'fi\"|G\rC\u0003.\u0001\u0011\u0005a&\u0001\ruKN$8+\u001a;XSRDW\t\u001f9jef\u001cVmY8oIN$\"!H\u0018\t\u000b\u0005b\u0003\u0019\u0001\u0012\t\u000bE\u0002A\u0011\u0001\u001a\u00023Q,7\u000f^*fi^KG\u000f[#ya&\u0014\u00180\u00168jqRKW.\u001a\u000b\u0003;MBQ!\t\u0019A\u0002\tBQ!\u000e\u0001\u0005\u0002Y\nq\u0004^3tiN+GoV5uQ\u0016C\b/\u001b:z+:L\u0007\u0010V5nK&s\u0007+Y:u)\tir\u0007C\u0003\"i\u0001\u0007!\u0005C\u0003:\u0001\u0011\u0005!(A\nuKN$x)\u001a;Nk2$\u0018\u000e\u001d7f\u0017\u0016L8\u000f\u0006\u0002\u001ew!)\u0011\u0005\u000fa\u0001E!)Q\b\u0001C\u0001}\u0005aA/Z:u\u0003\u0012$')Y:jGR\u0011Qd\u0010\u0005\u0006Cq\u0002\rA\t\u0005\u0006\u0003\u0002!\tAQ\u0001\u0019i\u0016\u001cH/\u00113e/&$\b.\u0012=qSJL8+Z2p]\u0012\u001cHCA\u000fD\u0011\u0015\t\u0003\t1\u0001#\u0011\u0015)\u0005\u0001\"\u0001G\u0003e!Xm\u001d;BI\u0012<\u0016\u000e\u001e5FqBL'/_+oSb$\u0016.\\3\u0015\u0005u9\u0005\"B\u0011E\u0001\u0004\u0011\u0003\"B%\u0001\t\u0003Q\u0015a\u0005;fgRtu\u000e^!eI&3\u0007K]3tK:$HCA\u000fL\u0011\u0015\t\u0003\n1\u0001#\u0011\u0015i\u0005\u0001\"\u0001O\u0003A!Xm\u001d;SKBd\u0017mY3CCNL7\r\u0006\u0002\u001e\u001f\")\u0011\u0005\u0014a\u0001E!)\u0011\u000b\u0001C\u0001%\u0006QB/Z:u\u001d>$(+\u001a9mC\u000e,\u0017J\u001a(piB\u0013Xm]3oiR\u0011Qd\u0015\u0005\u0006CA\u0003\rA\t\u0005\u0006+\u0002!\tAV\u0001\u001di\u0016\u001cHOU3qY\u0006\u001cWmV5uQ\u0016C\b/\u001b:z'\u0016\u001cwN\u001c3t)\tir\u000bC\u0003\")\u0002\u0007!\u0005C\u0003Z\u0001\u0011\u0005!,A\u000fuKN$(+\u001a9mC\u000e,w+\u001b;i\u000bb\u0004\u0018N]=V]&DH+[7f)\ti2\fC\u0003\"1\u0002\u0007!\u0005C\u0003^\u0001\u0011\u0005a,A\buKN$\u0018\t\u001d9f]\u0012\u0014\u0015m]5d)\tir\fC\u0003\"9\u0002\u0007!\u0005C\u0003b\u0001\u0011\u0005!-\u0001\nuKN$\u0018\t\u001d9f]\u0012tu\u000e\u001e$pk:$GCA\u000fd\u0011\u0015\t\u0003\r1\u0001#\u0011\u0015)\u0007\u0001\"\u0001g\u0003A!Xm\u001d;Qe\u0016\u0004XM\u001c3CCNL7\r\u0006\u0002\u001eO\")\u0011\u0005\u001aa\u0001E!)\u0011\u000e\u0001C\u0001U\u0006\u0019B/Z:u!J,\u0007/\u001a8e\u001d>$hi\\;oIR\u0011Qd\u001b\u0005\u0006C!\u0004\rA\t\u0005\u0006[\u0002!\tA\\\u0001\u000ei\u0016\u001cHoR3ug\n\u000b7/[2\u0015\u0005uy\u0007\"B\u0011m\u0001\u0004\u0011\u0003\"B9\u0001\t\u0003\u0011\u0018\u0001\u0004;fgR\u001c\u0015m\u001d\"bg&\u001cGCA\u000ft\u0011\u0015\t\u0003\u000f1\u0001#\u0011\u0015)\b\u0001\"\u0001w\u0003=!Xm\u001d;DCNtu\u000e\u001e$pk:$GCA\u000fx\u0011\u0015\tC\u000f1\u0001#\u0011\u0015I\b\u0001\"\u0001{\u00035!Xm\u001d;DCN,\u00050[:ugR\u0011Qd\u001f\u0005\u0006Ca\u0004\rA\t\u0005\u0006{\u0002!\tA`\u0001\u000fi\u0016\u001cH/\u00138wC2LGmQ1t+\u0005i\u0002BBA\u0001\u0001\u0011\u0005a0A\nuKN$\u0018J\u001c<bY&$7)Y:WC2,X\rC\u0004\u0002\u0006\u0001!\t!a\u0002\u0002\u001fQ,7\u000f\u001e#fY\u0016$XMQ1tS\u000e$2!HA\u0005\u0011\u0019\t\u00131\u0001a\u0001E!9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0011A\u0006;fgR$U\r\\3uK\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;\u0015\u0007u\t\t\u0002\u0003\u0004\"\u0003\u0017\u0001\rA\t\u0005\b\u0003+\u0001A\u0011AA\f\u0003E!Xm\u001d;EK2,G/\u001a(p%\u0016\u0004H.\u001f\u000b\u0004;\u0005e\u0001BB\u0011\u0002\u0014\u0001\u0007!\u0005C\u0004\u0002\u001e\u0001!\t!a\b\u0002+Q,7\u000f^*fi\u0006sG-T;mi&$U\r\\3uKR\u0019Q$!\t\t\r\u0005\nY\u00021\u0001#\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\t\u0011\u0004^3tiN+GOT8SKBd\u00170T;mi&$U\r\\3uKR\u0019Q$!\u000b\t\r\u0005\n\u0019\u00031\u0001#\u0011\u001d\ti\u0003\u0001C\u0005\u0003_\t1b^5uQ:{'+\u001a9msR)Q$!\r\u00024!1\u0011%a\u000bA\u0002\tB\u0001\"!\u000e\u0002,\u0001\u0007\u0011qG\u0001\u0003_B\u0004B!!\u000f\u0002@9\u0019\u0011#a\u000f\n\u0007\u0005u\"#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\n\u0019E\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003{\u0011\u0002BBA$\u0001\u0011\u0005a0A\nuKN$\b+\u001b9fY&tW\r\u001a#fY\u0016$X\r\u0003\u0004\u0002L\u0001!\tA`\u0001 i\u0016\u001cH\u000fU5qK2Lg.\u001a3HKR\fe\r^3s\u0013:4\u0018\r\\5e\u0007\u0006\u001c\bbBA(\u0001\u0011\u0005\u0011\u0011K\u0001\u0013i\u0016\u001cH/\u00138de\u0016lWM\u001c;CCNL7\rF\u0002\u001e\u0003'Ba!IA'\u0001\u0004\u0011\u0003bBA,\u0001\u0011\u0005\u0011\u0011L\u0001\u0014i\u0016\u001cH/\u00138de\u0016lWM\u001c;Ue&\u0004H.\u001a\u000b\u0004;\u0005m\u0003BB\u0011\u0002V\u0001\u0007!\u0005C\u0004\u0002`\u0001!\t!!\u0019\u0002+Q,7\u000f^%oGJ,W.\u001a8u\u001d>$X\t_5tiR\u0019Q$a\u0019\t\r\u0005\ni\u00061\u0001#\u0011\u001d\t9\u0007\u0001C\u0001\u0003S\nq\u0003^3ti&s7M]3nK:$\u0018J\u001c;fO\u0016\u0014X*\u0019=\u0015\u0007u\tY\u0007\u0003\u0004\"\u0003K\u0002\rA\t\u0005\b\u0003_\u0002A\u0011AA9\u0003u!Xm\u001d;J]\u000e\u0014X-\\3oi\n+\u0017p\u001c8e\u0013:$XmZ3s\u001b\u0006DHcA\u000f\u0002t!1\u0011%!\u001cA\u0002\tBq!a\u001e\u0001\t\u0003\tI(\u0001\u000euKN$\u0018J\\2sK6,g\u000e\u001e\"fs>tG\rT8oO6\u000b\u0007\u0010F\u0002\u001e\u0003wBa!IA;\u0001\u0004\u0011\u0003bBA@\u0001\u0011\u0005\u0011\u0011Q\u0001\u001ci\u0016\u001cH/\u00138de\u0016lWM\u001c;TkJ\u0004\u0018m]:M_:<W*\u0019=\u0015\u0007u\t\u0019\t\u0003\u0004\"\u0003{\u0002\rA\t\u0005\b\u0003\u000f\u0003A\u0011AAE\u0003u!Xm\u001d;J]\u000e\u0014X-\\3oiN+(\u000f]1tg\nKw-\u00138u\u001b\u0006DHcA\u000f\u0002\f\"1\u0011%!\"A\u0002\tBq!a$\u0001\t\u0003\t\t*\u0001\nuKN$H)Z2sK6,g\u000e\u001e\"bg&\u001cGcA\u000f\u0002\u0014\"1\u0011%!$A\u0002\tBq!a&\u0001\t\u0003\tI*A\nuKN$H)Z2sK6,g\u000e\u001e+sSBdW\rF\u0002\u001e\u00037Ca!IAK\u0001\u0004\u0011\u0003bBAP\u0001\u0011\u0005\u0011\u0011U\u0001\u0016i\u0016\u001cH\u000fR3de\u0016lWM\u001c;O_R,\u00050[:u)\ri\u00121\u0015\u0005\u0007C\u0005u\u0005\u0019\u0001\u0012\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002*\u00061B/Z:u\t\u0016\u001c'/Z7f]R\u0014U\r\\8x5\u0016\u0014x\u000eF\u0002\u001e\u0003WCa!IAS\u0001\u0004\u0011\u0003bBAX\u0001\u0011\u0005\u0011\u0011W\u0001\ri\u0016\u001cHO\u00127vg\"\fE\u000e\u001c\u000b\u0004;\u0005M\u0006BB\u0011\u0002.\u0002\u0007!\u0005C\u0004\u00028\u0002!\t!!/\u0002'Q,7\u000f\u001e$mkND\u0017\t\u001c7EK2\f\u00170\u001a3\u0015\u0007u\tY\f\u0003\u0004\"\u0003k\u0003\rA\t\u0005\b\u0003\u007f\u0003A\u0011AAa\u0003m!Xm\u001d;GYV\u001c\b.\u00117m\t\u0016d\u0017-_3e+:L\u0007\u0010V5nKR\u0019Q$a1\t\r\u0005\ni\f1\u0001#\u0011\u001d\t9\r\u0001C\u0005\u0003\u0013\fqB\u001a7vg\"\fE\u000e\u001c#fY\u0006LX\r\u001a\u000b\b;\u0005-\u0017QZAl\u0011\u0019\t\u0013Q\u0019a\u0001E!A\u0011qZAc\u0001\u0004\t\t.A\u0003eK2\f\u0017\u0010E\u0002\u0012\u0003'L1!!6\u0013\u0005\rIe\u000e\u001e\u0005\t\u00033\f)\r1\u0001\u0002\\\u0006)1\u000f\\3faB\u0019\u0011#!8\n\u0007\u0005}'C\u0001\u0003M_:<\u0007bBAr\u0001\u0011\u0005\u0011Q]\u0001\u0014i\u0016\u001cHO\u00127vg\"\fE\u000e\u001c(p%\u0016\u0004H.\u001f\u000b\u0004;\u0005\u001d\bBB\u0011\u0002b\u0002\u0007!\u0005\u0003\u0004\u0002l\u0002!\tA`\u0001\u0015i\u0016\u001cHO\u00127vg\"\fE\u000e\u001c)ja\u0016d\u0017N\\3\t\r\u0005=\b\u0001\"\u0001\u007f\u0003-!Xm\u001d;WKJ\u001c\u0018n\u001c8\t\r\u0005M\b\u0001\"\u0001\u007f\u0003Y!Xm\u001d;J]\u000e\u00148*Z=MK:<G\u000f\u001b'j[&$\bBBA|\u0001\u0011\u0005a0A\u000buKN$x)\u001a;LKfdUM\\4uQ2KW.\u001b;\t\r\u0005m\b\u0001\"\u0001\u007f\u0003I!Xm\u001d;V].twn\u001e8D_6l\u0017M\u001c3\t\r\u0005}\b\u0001\"\u0001\u007f\u0003m!Xm\u001d;V].twn\u001e8D_6l\u0017M\u001c3QSB,G.\u001b8fI\"1!1\u0001\u0001\u0005\u0002y\fA\u0004^3tiJ+\u0017\r\u001a$vY2d\u0015N\\3BMR,'\u000fT8oO.+\u0017\u0010\u0003\u0004\u0003\b\u0001!\tA`\u0001\u001di\u0016\u001cHOT3hCRLg/\u001a\"zi\u0016\u001cH*\u001a8hi\"4\u0016\r\\;f\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0005\u001b\t1\u0003^3ti\u001ac\u0017mZ:JgVs7/[4oK\u0012$2!\bB\b\u0011\u0019\t#\u0011\u0002a\u0001E!9!1\u0003\u0001\u0005\u0002\tU\u0011A\u0006;fgRLen\u0019:EK\u000e\u0014\u0018j]+og&<g.\u001a3\u0015\u0007u\u00119\u0002\u0003\u0004\"\u0005#\u0001\rA\t\u0005\u0007\u00057\u0001A\u0011\u0001@\u0002\u001bQ,7\u000f\u001e,fe\n|7/\u001b;z\u0011\u001d\u0011y\u0002\u0001C\u0001\u0005C\t\u0001\u0002^3tiF+\u0018\u000e\u001e\u000b\u0004;\t\r\u0002BB\u0011\u0003\u001e\u0001\u0007!\u0005C\u0004\u0003(\u0001!\tA!\u000b\u0002'Q,7\u000f^*fi\nKwmU5{KZ\u000bG.^3\u0015\u0007u\u0011Y\u0003\u0003\u0004\"\u0005K\u0001\rA\t\u0005\u0007\u0005_\u0001A\u0011\u0001@\u00023Q,7\u000f^*u_J,\u0017i\u001d\"j]\u0006\u0014\u0018p\u0014<feJLG-\u001a\u0005\b\u0005g\u0001A\u0011\u0002B\u001b\u0003%\tG\rZ!oI\u001e+G\u000fF\u0002\u001e\u0005oAa!\tB\u0019\u0001\u0004\u0011\u0003b\u0002B\u001e\u0001\u0011%!QH\u0001\u0005S:\u001c'\u000f\u0006\u0004\u00028\t}\"\u0011\t\u0005\u0007C\te\u0002\u0019\u0001\u0012\t\u0011\t\r#\u0011\ba\u0001\u0003#\f!AY=\t\u000f\tm\u0002\u0001\"\u0003\u0003HQ1\u0011q\u0007B%\u0005\u001bB\u0001Ba\u0013\u0003F\u0001\u0007\u0011qG\u0001\u0002W\"A!1\tB#\u0001\u0004\t\t\u000eK\u0006\u0001\u0005#\u0012\tGa\u0019\u0003j\t-\u0004\u0003\u0002B*\u0005;j!A!\u0016\u000b\t\t]#\u0011L\u0001\fC:tw\u000e^1uS>t7OC\u0002\u0003\\!\ta\u0001^3ti:<\u0017\u0002\u0002B0\u0005+\u0012A\u0001V3ti\u00061qM]8vaNd#A!\u001a\"\u0005\t\u001d\u0014A\u00034v]\u000e$\u0018n\u001c8bY\u0006AA/Z:u\u001d\u0006lW-\t\u0002\u0003n\u0005A3/\u001a:wKJtS.Z7dC\u000eDW\r\u001a\u0018NK6\u001c\u0017m\u00195fI\u001a+hn\u0019;j_:\fG\u000eV3ti\u0002")
public class MemcachedFunctionalTest
extends MemcachedSingleNodeTest
implements ScalaObject {
    public void testSetBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    public void testSetWithExpirySeconds(Method m) {
        Future f = this.client().set(this.k(m), 1, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testSetWithExpiryUnixTime(Method m) {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().set(this.k(m), future, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testSetWithExpiryUnixTimeInPast(Method m) {
        Future f = this.client().set(this.k(m), 2592001, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testGetMultipleKeys(Method m) {
        Future f1 = this.client().set(this.k(m, "k1-"), 0, (Object)this.v(m, "v1-"));
        Future f2 = this.client().set(this.k(m, "k2-"), 0, (Object)this.v(m, "v2-"));
        Future f3 = this.client().set(this.k(m, "k3-"), 0, (Object)this.v(m, "v3-"));
        Assert.assertTrue((boolean)((Boolean)f1.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f2.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f3.get(this.timeout(), TimeUnit.SECONDS)));
        List keys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.k(m, "k1-"), this.k(m, "k2-"), this.k(m, "k3-")}));
        Map ret = this.client().getBulk((String[])keys.toArray(ClassManifest$.MODULE$.classType(String.class)));
        Assert.assertEquals(ret.get(this.k(m, "k1-")), (Object)this.v(m, "v1-"));
        Assert.assertEquals(ret.get(this.k(m, "k2-")), (Object)this.v(m, "v2-"));
        Assert.assertEquals(ret.get(this.k(m, "k3-")), (Object)this.v(m, "v3-"));
    }

    public void testAddBasic(Method m) {
        this.addAndGet(m);
    }

    public void testAddWithExpirySeconds(Method m) {
        Future f = this.client().add(this.k(m), 1, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
        f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testAddWithExpiryUnixTime(Method m) {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().add(this.k(m), future, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
        f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testNotAddIfPresent(Method m) {
        this.addAndGet(m);
        Future f = this.client().add(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    public void testReplaceBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().replace(this.k(m), 0, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
    }

    public void testNotReplaceIfNotPresent(Method m) {
        Future f = this.client().replace(this.k(m), 0, (Object)this.v(m));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testReplaceWithExpirySeconds(Method m) {
        this.addAndGet(m);
        Future f = this.client().replace(this.k(m), 1, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testReplaceWithExpiryUnixTime(Method m) {
        this.addAndGet(m);
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().replace(this.k(m), future, (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m, "v1-"));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testAppendBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().append(0L, this.k(m), (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)this.v(m)).append((Object)this.v(m, "v1-")).toString();
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)expected);
    }

    public void testAppendNotFound(Method m) {
        this.addAndGet(m);
        Future f = this.client().append(0L, this.k(m, "k2-"), (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        Assert.assertNull((Object)this.client().get(this.k(m, "k2-")));
    }

    public void testPrependBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().prepend(0L, this.k(m), (Object)this.v(m, "v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)this.v(m, "v1-")).append((Object)this.v(m)).toString();
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)expected);
    }

    public void testPrependNotFound(Method m) {
        this.addAndGet(m);
        Future f = this.client().prepend(0L, this.k(m, "k2-"), (Object)this.v(m, "v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
        Assert.assertNull((Object)this.client().get(this.k(m, "k2-")));
    }

    public void testGetsBasic(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
    }

    public void testCasBasic(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v1-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testCasNotFound(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client().cas(this.k(m, "k1-"), value.getCas(), (Object)this.v(m, "v1-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.NOT_FOUND);
    }

    public void testCasExists(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        long old = value.getCas();
        CASResponse resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v1-"));
        value = this.client().gets(this.k(m));
        Assert.assertEquals((Object)value.getValue(), (Object)this.v(m, "v1-"));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((value.getCas() != old ? 1 : 0) != 0);
        resp = this.client().cas(this.k(m), old, (Object)this.v(m, "v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.EXISTS);
        resp = this.client().cas(this.k(m), value.getCas(), (Object)this.v(m, "v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testInvalidCas() {
        String resp = this.send("cas bad blah 0 0 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 blah 0 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 0 blah 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 0 0 blah\r\n\r\n");
        this.assertClientError(resp);
    }

    public void testInvalidCasValue() {
        String resp = this.send("cas foo 0 0 6 \r\nbarva2\r\n");
        this.assertClientError(resp);
    }

    public void testDeleteBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().delete(this.k(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertNull((Object)this.client().get(this.k(m)));
    }

    public void testDeleteDoesNotExist(Method m) {
        Future f = this.client().delete(this.k(m));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
    }

    public void testDeleteNoReply(Method m) {
        this.withNoReply(m, Predef$.MODULE$.augmentString("delete %s noreply\r\n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.k(m)})));
    }

    public void testSetAndMultiDelete(Method m) {
        String key = this.k(m);
        List<String> responses = this.sendMulti(Predef$.MODULE$.augmentString("set %s 0 0 1\r\na\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, key, key, key, key})), 5, true);
        Assert.assertEquals((int)responses.length(), (int)5);
        Assert.assertEquals((String)((String)responses.head()), (String)"STORED");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"DELETED");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)responses.tail()).tail()).head()), (String)"NOT_FOUND");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)((TraversableLike)responses.tail()).tail()).tail()).head()), (String)"NOT_FOUND");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)((TraversableLike)((TraversableLike)responses.tail()).tail()).tail()).tail()).head()), (String)"NOT_FOUND");
    }

    public void testSetNoReplyMultiDelete(Method m) {
        String key = this.k(m);
        List<String> responses = this.sendMulti(Predef$.MODULE$.augmentString("set %s 0 0 1 noreply\r\na\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, key, key, key, key})), 4, true);
        Assert.assertEquals((int)responses.length(), (int)4);
        Assert.assertEquals((String)((String)responses.head()), (String)"DELETED");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"NOT_FOUND");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)responses.tail()).tail()).head()), (String)"NOT_FOUND");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)((TraversableLike)responses.tail()).tail()).tail()).head()), (String)"NOT_FOUND");
    }

    private void withNoReply(Method m, String op) {
        Future f = this.client().set(this.k(m), 0, (Object)"blah");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        CountDownLatch latch = new CountDownLatch(1);
        NoReplyListener listener = new NoReplyListener(latch);
        this.cache.addListener((Object)listener);
        try {
            this.sendNoWait(op);
            this.log.debug((Object)"No reply delete sent, wait...");
            boolean completed = latch.await(10L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)completed, (String)"Timed out waiting for remove to be executed");
            return;
        }
        finally {
            this.cache.removeListener((Object)listener);
        }
    }

    public void testPipelinedDelete() {
        List<String> responses = this.sendMulti("delete a\r\ndelete a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        responses.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String r) {
                String string = r;
                String string2 = "NOT_FOUND";
                Assert.assertTrue((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
            }
        });
    }

    public void testPipelinedGetAfterInvalidCas() {
        List<String> responses = this.sendMulti("cas bad 0 0 1 0 0\r\nget a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertTrue((boolean)((String)responses.head()).contains("CLIENT_ERROR"));
        Object object = ((IterableLike)responses.tail()).head();
        String string = "END";
        Assert.assertTrue((!(object != null ? !object.equals(string) : string != null) ? 1 : 0) != 0, (String)new StringBuilder().append((Object)"Instead response was: ").append(((IterableLike)responses.tail()).head()).toString());
    }

    public void testIncrementBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long result = this.client().incr(this.k(m), 1);
        Assert.assertEquals((long)result, (long)2L);
    }

    public void testIncrementTriple(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().incr(this.k(m), 1), (long)2L);
        Assert.assertEquals((long)this.client().incr(this.k(m), 2), (long)4L);
        Assert.assertEquals((long)this.client().incr(this.k(m), 4), (long)8L);
    }

    public void testIncrementNotExist(Method m) {
        Assert.assertEquals((long)this.client().incr(this.k(m), 1), (long)-1L);
    }

    public void testIncrementIntegerMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().incr(this.k(m), Integer.MAX_VALUE), (long)Integer.MAX_VALUE);
    }

    public void testIncrementBeyondIntegerMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long newValue = this.client().incr(this.k(m), Integer.MAX_VALUE);
        Assert.assertEquals((long)newValue, (long)((long)Integer.MAX_VALUE + 1L));
    }

    public void testIncrementBeyondLongMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"9223372036854775808");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        Assert.assertEquals((Object)package$.MODULE$.BigInt().apply(newValue), (Object)package$.MODULE$.BigInt().apply("9223372036854775809"));
    }

    public void testIncrementSurpassLongMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"9223372036854775807");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        Assert.assertEquals((Object)package$.MODULE$.BigInt().apply(newValue), (Object)package$.MODULE$.BigInt().apply("9223372036854775808"));
    }

    public void testIncrementSurpassBigIntMax(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"18446744073709551615");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        Assert.assertEquals((String)newValue, (String)"0");
    }

    public void testDecrementBasic(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)0L);
    }

    public void testDecrementTriple(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"8");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)7L);
        Assert.assertEquals((long)this.client().decr(this.k(m), 2), (long)5L);
        Assert.assertEquals((long)this.client().decr(this.k(m), 4), (long)1L);
    }

    public void testDecrementNotExist(Method m) {
        Assert.assertEquals((long)this.client().decr(this.k(m), 1), (long)-1L);
    }

    public void testDecrementBelowZero(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long newValue = this.client().decr(this.k(m), 2);
        Assert.assertEquals((long)newValue, (long)0L);
    }

    public void testFlushAll(Method m$1) {
        Predef$.MODULE$.intWrapper(1).to(5).foreach$mVc$sp((Function1)new Serializable(this, m$1){
            public static final long serialVersionUID;
            private final MemcachedFunctionalTest $outer;
            private final Method m$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                String key = this.$outer.k(this.m$1, new StringBuilder().append((Object)"k").append((Object)BoxesRunTime.boxToInteger((int)v1)).append((Object)"-").toString());
                String value = this.$outer.v(this.m$1, new StringBuilder().append((Object)"v").append((Object)BoxesRunTime.boxToInteger((int)v1)).append((Object)"-").toString());
                Future f = this.$outer.client().set(key, 0, (Object)value);
                Assert.assertTrue((boolean)((Boolean)f.get(this.$outer.timeout(), TimeUnit.SECONDS)));
                Assert.assertEquals((Object)this.$outer.client().get(key), (Object)value);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.m$1 = method;
            }
        });
        Future f = this.client().flush();
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Predef$.MODULE$.intWrapper(1).to(5).foreach$mVc$sp((Function1)new Serializable(this, m$1){
            public static final long serialVersionUID;
            private final MemcachedFunctionalTest $outer;
            private final Method m$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                String key = this.$outer.k(this.m$1, new StringBuilder().append((Object)"k").append((Object)BoxesRunTime.boxToInteger((int)v1)).append((Object)"-").toString());
                Assert.assertNull((Object)this.$outer.client().get(key));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.m$1 = method;
            }
        });
    }

    public void testFlushAllDelayed(Method m) {
        this.flushAllDelayed(m, 2, 2200L);
    }

    public void testFlushAllDelayedUnixTime(Method m) {
        int delay = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 2000L);
        this.flushAllDelayed(m, delay, 2200L);
    }

    private void flushAllDelayed(Method m$2, int delay, long sleep) {
        Predef$.MODULE$.intWrapper(1).to(5).foreach$mVc$sp((Function1)new Serializable(this, m$2){
            public static final long serialVersionUID;
            private final MemcachedFunctionalTest $outer;
            private final Method m$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                String key = this.$outer.k(this.m$2, new StringBuilder().append((Object)"k").append((Object)BoxesRunTime.boxToInteger((int)v1)).append((Object)"-").toString());
                String value = this.$outer.v(this.m$2, new StringBuilder().append((Object)"v").append((Object)BoxesRunTime.boxToInteger((int)v1)).append((Object)"-").toString());
                Future f = this.$outer.client().set(key, 0, (Object)value);
                Assert.assertTrue((boolean)((Boolean)f.get(this.$outer.timeout(), TimeUnit.SECONDS)));
                Assert.assertEquals((Object)this.$outer.client().get(key), (Object)value);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.m$2 = method;
            }
        });
        Future f = this.client().flush(delay);
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)sleep);
        Predef$.MODULE$.intWrapper(1).to(5).foreach$mVc$sp((Function1)new Serializable(this, m$2){
            public static final long serialVersionUID;
            private final MemcachedFunctionalTest $outer;
            private final Method m$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                String key = this.$outer.k(this.m$2, new StringBuilder().append((Object)"k").append((Object)BoxesRunTime.boxToInteger((int)v1)).append((Object)"-").toString());
                Assert.assertNull((Object)this.$outer.client().get(key));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.m$2 = method;
            }
        });
    }

    public void testFlushAllNoReply(Method m) {
        this.withNoReply(m, "flush_all noreply\r\n");
    }

    public void testFlushAllPipeline() {
        List<String> responses = this.sendMulti("flush_all\r\nget a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertEquals((String)((String)responses.head()), (String)"OK");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"END");
    }

    public void testVersion() {
        Map versions = this.client().getVersions();
        Assert.assertEquals((int)versions.size(), (int)1);
        String version = (String)versions.values().iterator().next();
        Assert.assertEquals((String)version, (String)Version.VERSION);
    }

    public void testIncrKeyLengthLimit() {
        String keyUnderLimit = TestingUtil.generateRandomString((int)249);
        Future f = this.client().set(keyUnderLimit, 0, (Object)"78");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(keyUnderLimit), (Object)"78");
        String keyInLimit = TestingUtil.generateRandomString((int)250);
        f = this.client().set(keyInLimit, 0, (Object)"89");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(keyInLimit), (Object)"89");
        String keyAboveLimit = TestingUtil.generateRandomString((int)251);
        String resp = this.incr(keyAboveLimit, 1);
        this.assertClientError(resp);
    }

    public void testGetKeyLengthLimit() {
        String tooLongKey = TestingUtil.generateRandomString((int)251);
        String resp = this.send(new StringBuilder().append((Object)"get ").append((Object)tooLongKey).append((Object)"\r\n").toString());
        this.assertClientError(resp);
        tooLongKey = TestingUtil.generateRandomString((int)251);
        resp = this.send(new StringBuilder().append((Object)"get k1 k2 k3 ").append((Object)tooLongKey).append((Object)"\r\n").toString());
        this.assertClientError(resp);
    }

    public void testUnknownCommand() {
        this.assertError(this.send("blah\r\n"));
    }

    public void testUnknownCommandPipelined() {
        List<String> responses = this.sendMulti("bogus\r\ndelete a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertEquals((String)((String)responses.head()), (String)"ERROR");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"NOT_FOUND");
    }

    public void testReadFullLineAfterLongKey() {
        String key = TestingUtil.generateRandomString((int)300);
        String command = new StringBuilder().append((Object)"add ").append((Object)key).append((Object)" 0 0 1\r\nget a\r\n").toString();
        List<String> responses = this.sendMulti(command, 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertTrue((boolean)((String)responses.head()).contains("CLIENT_ERROR"));
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"END");
    }

    public void testNegativeBytesLengthValue() {
        this.assertClientError(this.send("set boo1 0 0 -1\r\n"));
        this.assertClientError(this.send("add boo2 0 0 -1\r\n"));
    }

    public void testFlagsIsUnsigned(Method m) {
        String k = m.getName();
        this.assertClientError(this.send("set boo1 -1 0 0\r\n"));
        this.assertStored(this.send(new StringBuilder().append((Object)"set ").append((Object)k).append((Object)" 4294967295 0 0\r\n").toString()));
        this.assertClientError(this.send("set boo2 4294967296 0 0\r\n"));
        this.assertClientError(this.send("set boo2 18446744073709551615 0 0\r\n"));
    }

    public void testIncrDecrIsUnsigned(Method m) {
        String k = m.getName();
        Future f = this.client().set(k, 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.assertClientError(this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" -1\r\n").toString()));
        this.assertClientError(this.send(new StringBuilder().append((Object)"decr ").append((Object)k).append((Object)" -1\r\n").toString()));
        k = new StringBuilder().append((Object)k).append((Object)"-1").toString();
        f = this.client().set(k, 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.assertExpectedResponse(this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" 18446744073709551615\r\n").toString()), "18446744073709551615", true);
        k = new StringBuilder().append((Object)k).append((Object)"-1").toString();
        f = this.client().set(k, 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.assertClientError(this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" 18446744073709551616\r\n").toString()));
        this.assertClientError(this.send(new StringBuilder().append((Object)"decr ").append((Object)k).append((Object)" 18446744073709551616\r\n").toString()));
    }

    public void testVerbosity() {
        this.assertClientError(this.send("verbosity\r\n"));
        this.assertClientError(this.send("verbosity 5\r\n"));
        this.assertClientError(this.send("verbosity 10 noreply\r\n"));
    }

    public void testQuit(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.sendNoWait("quit\r\n");
    }

    public void testSetBigSizeValue(Method m) {
        Future f = this.client().set(this.k(m), 0, (Object)TestingUtil.generateRandomString((int)0x100000).getBytes());
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
    }

    public void testStoreAsBinaryOverride() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager((boolean)false);
        Configuration cfg = new Configuration().fluent().storeAsBinary().build();
        cm.defineConfiguration(MemcachedServer$.MODULE$.cacheName(), cfg);
        Assert.assertTrue((boolean)cfg.isStoreAsBinary());
        MemcachedServer testServer = this.startMemcachedTextServer(cm, this.server().getPort() + 33);
        try {
            Cache memcachedCache = cm.getCache(MemcachedServer$.MODULE$.cacheName());
            Assert.assertFalse((boolean)memcachedCache.getConfiguration().isStoreAsBinary());
            return;
        }
        finally {
            cm.stop();
            testServer.stop();
        }
    }

    private void addAndGet(Method m) {
        Future f = this.client().add(this.k(m), 0, (Object)this.v(m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(this.k(m)), (Object)this.v(m));
    }

    private String incr(Method m, int by) {
        return this.incr(this.k(m), by);
    }

    private String incr(String k, int by) {
        return this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)by)).append((Object)"\r\n").toString());
    }
}

