/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.context.Flag;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.DecoderState;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.RequestHeader;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ExtendedChannelBuffer$;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.memcached.DelayedFlushAll;
import org.infinispan.server.memcached.MemcachedException;
import org.infinispan.server.memcached.MemcachedOperation$;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.MemcachedValue;
import org.infinispan.server.memcached.RequestResolver$;
import org.infinispan.server.memcached.TextProtocolUtil$;
import org.infinispan.stats.Stats;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\r]d\u0001B\u0001\u0003\u0001-\u0011\u0001#T3nG\u0006\u001c\u0007.\u001a3EK\u000e|G-\u001a:\u000b\u0005\r!\u0011!C7f[\u000e\f7\r[3e\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000f!\t!\"\u001b8gS:L7\u000f]1o\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\rAA!Q\u0002\u0005\n\u001d\u001b\u0005q!BA\b\u0005\u0003\u0011\u0019wN]3\n\u0005Eq!aF!cgR\u0014\u0018m\u0019;Qe>$xnY8m\t\u0016\u001cw\u000eZ3s!\t\u0019\u0012D\u0004\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tAR#\u0001\u0004Qe\u0016$WMZ\u0005\u00035m\u0011aa\u0015;sS:<'B\u0001\r\u0016!\tib$D\u0001\u0003\u0013\ty\"A\u0001\bNK6\u001c\u0017m\u00195fIZ\u000bG.^3\u0011\u0005Q\t\u0013B\u0001\u0012\u0016\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\u0011\u0002!\u0011!Q\u0001\n\u0015\na\"\\3nG\u0006\u001c\u0007.\u001a3DC\u000eDW\r\u0005\u0003'OIaR\"\u0001\u0004\n\u0005!2!!B\"bG\",\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bC\u0001\u00174\u001b\u0005i#B\u0001\u00180\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003aE\nA!\u001e;jY*\t!'\u0001\u0003kCZ\f\u0017B\u0001\u001b.\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-\u001a\u0005\tm\u0001\u0011\t\u0011)A\u0005o\u0005IAO]1ogB|'\u000f\u001e\t\u0003qij\u0011!\u000f\u0006\u0003m9I!aO\u001d\u0003\u001d9+G\u000f^=Ue\u0006t7\u000f]8si\")Q\b\u0001C\u0001}\u00051A(\u001b8jiz\"Ba\u0010!B\u0005B\u0011Q\u0004\u0001\u0005\u0006Iq\u0002\r!\n\u0005\u0006Uq\u0002\ra\u000b\u0005\u0006mq\u0002\raN\u0003\u0005\t\u0002\u0001QI\u0001\nTk&$\u0018M\u00197f!\u0006\u0014\u0018-\\3uKJ\u001c\bCA\u000fG\u0013\t9%AA\nNK6\u001c\u0017m\u00195fIB\u000b'/Y7fi\u0016\u00148/\u0002\u0003J\u0001\u0001Q%AD*vSR\f'\r\\3IK\u0006$WM\u001d\t\u0003\u001b-K!\u0001\u0014\b\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011!q\u0005\u0001#b\u0001\n\u0013y\u0015AD5t'R\fGo]#oC\ndW\rZ\u000b\u0002!B\u0011A#U\u0005\u0003%V\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005U\u0001!\u0005\t\u0015)\u0003Q\u0003=I7o\u0015;biN,e.\u00192mK\u0012\u0004\u0003b\u0002,\u0001\u0005\u0004%iaV\u0001\u000bS:\u001c'/T5tg\u0016\u001cX#\u0001-\u0011\u0005ecV\"\u0001.\u000b\u0005mk\u0013AB1u_6L7-\u0003\u0002^5\nQ\u0011\t^8nS\u000eduN\\4\t\r}\u0003\u0001\u0015!\u0004Y\u0003-Ign\u0019:NSN\u001cXm\u001d\u0011\t\u000f\u0005\u0004!\u0019!C\u0007/\u0006A\u0011N\\2s\u0011&$8\u000f\u0003\u0004d\u0001\u0001\u0006i\u0001W\u0001\nS:\u001c'\u000fS5ug\u0002Bq!\u001a\u0001C\u0002\u00135q+\u0001\u0006eK\u000e\u0014X*[:tKNDaa\u001a\u0001!\u0002\u001bA\u0016a\u00033fGJl\u0015n]:fg\u0002Bq!\u001b\u0001C\u0002\u00135q+\u0001\u0005eK\u000e\u0014\b*\u001b;t\u0011\u0019Y\u0007\u0001)A\u00071\u0006IA-Z2s\u0011&$8\u000f\t\u0005\b[\u0002\u0011\r\u0011\"\u0004X\u0003e\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u001b&\u001c8/Z:\t\r=\u0004\u0001\u0015!\u0004Y\u0003i\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u001b&\u001c8/Z:!\u0011\u001d\t\bA1A\u0005\u000e]\u000bqC]3qY\u0006\u001cW-\u00134V]6|G-\u001b4jK\u0012D\u0015\u000e^:\t\rM\u0004\u0001\u0015!\u0004Y\u0003a\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0011&$8\u000f\t\u0005\bk\u0002\u0011\r\u0011\"\u0004X\u0003e\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0005\u0006$g/\u00197\t\r]\u0004\u0001\u0015!\u0004Y\u0003i\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0005\u0006$g/\u00197!\u0011\u0015I\b\u0001\"\u0011{\u0003)\u0011X-\u00193IK\u0006$WM\u001d\u000b\u0004w\u0006\r\u0001\u0003\u0002\u000b}}BK!!`\u000b\u0003\rQ+\b\u000f\\33!\r!rPS\u0005\u0004\u0003\u0003)\"AB(qi&|g\u000eC\u0004\u0002\u0006a\u0004\r!a\u0002\u0002\r\t,hMZ3s!\u0011\tI!!\u0006\u000e\u0005\u0005-!\u0002BA\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005)a.\u001a;us*\u0019\u00111\u0003\u0005\u0002\u000b)\u0014wn]:\n\t\u0005]\u00111\u0002\u0002\u000e\u0007\"\fgN\\3m\u0005V4g-\u001a:\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e\u00059!/Z1e\u0017\u0016LH\u0003BA\u0010\u0003C\u0001B\u0001\u0006?\u0013!\"A\u00111EA\r\u0001\u0004\t9!A\u0001c\u0011\u001d\t9\u0003\u0001C\u0005\u0003S\t\u0001B]3bI.+\u0017p\u001d\u000b\u0005\u0003W\t\t\u0004\u0005\u0003\u0015\u0003[\u0011\u0012bAA\u0018+\t)\u0011I\u001d:bs\"A\u00111EA\u0013\u0001\u0004\t9\u0001C\u0004\u00026\u0001!\t&a\u000e\u0002\u0007\u001d,G\u000f\u0006\u0003\u0002:\u0005}\u0002c\u0001\u000b\u0002<%\u0019\u0011QH\u000b\u0003\r\u0005s\u0017PU3g\u0011!\t)!a\rA\u0002\u0005\u001d\u0001bBA\"\u0001\u0011%\u0011QI\u0001\u000fG\",7m[&fs2+gn\u001a;i)\u001d\u0011\u0012qIA&\u0003\u001fBq!!\u0013\u0002B\u0001\u0007!#A\u0001l\u0011\u001d\ti%!\u0011A\u0002A\u000bq!\u001a8e\u001f\u001a|\u0005\u000f\u0003\u0005\u0002$\u0005\u0005\u0003\u0019AA\u0004\u0011\u001d\t\u0019\u0006\u0001C!\u0003+\naB]3bIB\u000b'/Y7fi\u0016\u00148\u000fF\u0003Q\u0003/\n9\u0007\u0003\u0005\u0002Z\u0005E\u0003\u0019AA.\u0003\t\u0019\u0007\u000e\u0005\u0003\u0002^\u0005\rTBAA0\u0015\u0011\t\t'!\u0004\u0002\u000f\rD\u0017M\u001c8fY&!\u0011QMA0\u0005\u001d\u0019\u0005.\u00198oK2D\u0001\"a\t\u0002R\u0001\u0007\u0011q\u0001\u0005\b\u0003W\u0002A\u0011BA7\u0003Q\u0011X-\u00193SK6|g/\u001a)be\u0006lW\r^3sgR\u0019Q)a\u001c\t\u0011\u0005E\u0014\u0011\u000ea\u0001\u0003W\tA!\u0019:hg\"9\u0011Q\u000f\u0001\u0005\n\u0005]\u0014A\u0006:fC\u0012Len\u0019:EK\u000e\u0014\b+\u0019:b[\u0016$XM]:\u0015\u0007\u0015\u000bI\b\u0003\u0005\u0002r\u0005M\u0004\u0019AA\u0016\u0011\u001d\ti\b\u0001C\u0005\u0003\u007f\naC]3bI\u001acWo\u001d5BY2\u0004\u0016M]1nKR,'o\u001d\u000b\u0004\u000b\u0006\u0005\u0005\u0002CA9\u0003w\u0002\r!a\u000b\t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\u0006)\"/Z1e'R|'/Y4f!\u0006\u0014\u0018-\\3uKJ\u001cH#B#\u0002\n\u0006-\u0005\u0002CA9\u0003\u0007\u0003\r!a\u000b\t\u0011\u0005\r\u00121\u0011a\u0001\u0003\u000fAq!a$\u0001\t#\n\t*A\u0005sK\u0006$g+\u00197vKR!\u00111SAM!\r!\u0012QS\u0005\u0004\u0003/+\"\u0001B+oSRD\u0001\"a\t\u0002\u000e\u0002\u0007\u0011q\u0001\u0005\b\u0003;\u0003A\u0011IAP\u0003-\u0019'/Z1uKZ\u000bG.^3\u0015\u0007q\t\t\u000b\u0003\u0005\u0002$\u0006m\u0005\u0019AAS\u0003-qW\r\u001f;WKJ\u001c\u0018n\u001c8\u0011\u0007Q\t9+C\u0002\u0002*V\u0011A\u0001T8oO\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0016\u0001C4fi\u001ac\u0017mZ:\u0015\t\u0005\u0015\u0016\u0011\u0017\u0005\b\u0003g\u000bY\u000b1\u0001\u0013\u0003\u00151G.Y4t\u0011\u001d\t9\f\u0001C\u0005\u0003s\u000b1bZ3u\u0019&4Wm\u001d9b]R!\u00111XAa!\r!\u0012QX\u0005\u0004\u0003\u007f+\"aA%oi\"9\u00111YA[\u0001\u0004\u0011\u0012\u0001\u00037jM\u0016\u001c\b/\u00198\t\u000f\u0005\u001d\u0007\u0001\"\u0003\u0002J\u0006Iq-\u001a;MK:<G\u000f\u001b\u000b\u0005\u0003w\u000bY\rC\u0004\u0002N\u0006\u0015\u0007\u0019\u0001\n\u0002\r1,gn\u001a;i\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'\f!bZ3u-\u0016\u00148/[8o)\u0011\t)+!6\t\u000f\u0005]\u0017q\u001aa\u0001%\u00059a/\u001a:tS>t\u0007bBAn\u0001\u0011%\u0011Q\\\u0001\ra\u0006\u00148/\u001a(p%\u0016\u0004H.\u001f\u000b\u0006!\u0006}\u00171\u001d\u0005\t\u0003C\fI\u000e1\u0001\u0002<\u0006iQ\r\u001f9fGR,G-\u00138eKbD\u0001\"!\u001d\u0002Z\u0002\u0007\u00111\u0006\u0005\b\u0003O\u0004A\u0011BAu\u0003Y\u0001\u0018M]:f\t\u0016d\u0017-_3e\t\u0016dW\r^3US6,G\u0003BA^\u0003WD\u0001\"!\u001d\u0002f\u0002\u0007\u00111\u0006\u0005\b\u0003_\u0004A\u0011IAy\u0003!9W\r^\"bG\",W#A\u0013\t\u000f\u0005U\b\u0001\"\u0015\u0002x\u0006\u00112-^:u_6$UmY8eK\"+\u0017\rZ3s)\u0019\tI$!?\u0002|\"A\u0011\u0011LAz\u0001\u0004\tY\u0006\u0003\u0005\u0002\u0006\u0005M\b\u0019AA\u0004\u0011\u001d\ty\u0010\u0001C)\u0005\u0003\tqbY;ti>lG)Z2pI\u0016\\U-\u001f\u000b\u0007\u0003s\u0011\u0019A!\u0002\t\u0011\u0005e\u0013Q a\u0001\u00037B\u0001\"!\u0002\u0002~\u0002\u0007\u0011q\u0001\u0005\b\u0005\u0013\u0001A\u0011\u000bB\u0006\u0003E\u0019Wo\u001d;p[\u0012+7m\u001c3f-\u0006dW/\u001a\u000b\u0007\u0003s\u0011iAa\u0004\t\u0011\u0005e#q\u0001a\u0001\u00037B\u0001\"!\u0002\u0003\b\u0001\u0007\u0011q\u0001\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0003!Ign\u0019:EK\u000e\u0014H\u0003BA\u001d\u0005/A\u0001\"!\u0017\u0003\u0012\u0001\u0007\u00111\f\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0003!1G.^:i\u00032dG\u0003CA\u001d\u0005?\u0011\tCa\t\t\u0011\u0005\r\"\u0011\u0004a\u0001\u0003\u000fA\u0001\"!\u0017\u0003\u001a\u0001\u0007\u00111\f\u0005\b\u0005K\u0011I\u00021\u0001Q\u00031I7OU3bIB\u000b'/Y7t\u0011\u001d\u0011I\u0003\u0001C\u0005\u0005W\tQB^1mS\u0012\fG/\u001a#fYR\fG\u0003\u0002B\u0017\u0005\u000b\u0002BAa\f\u0003@9!!\u0011\u0007B\u001e\u001d\u0011\u0011\u0019D!\u000f\u000e\u0005\tU\"b\u0001B\u001c\u0015\u00051AH]8pizJ\u0011AF\u0005\u0004\u0005{)\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005\u0003\u0012\u0019E\u0001\u0004CS\u001eLe\u000e\u001e\u0006\u0004\u0005{)\u0002b\u0002B$\u0005O\u0001\rAE\u0001\u0006I\u0016dG/\u0019\u0005\b\u0005\u0017\u0002A\u0011\tB'\u0003U\u0019'/Z1uKN+8mY3tgJ+7\u000f]8og\u0016$B!!\u000f\u0003P!9!\u0011\u000bB%\u0001\u0004a\u0012\u0001\u00029sKZDqA!\u0016\u0001\t\u0003\u00129&A\rde\u0016\fG/\u001a(pi\u0016CXmY;uK\u0012\u0014Vm\u001d9p]N,G\u0003BA\u001d\u00053BqA!\u0015\u0003T\u0001\u0007A\u0004C\u0004\u0003^\u0001!\tEa\u0018\u0002-\r\u0014X-\u0019;f\u001d>$X\t_5tiJ+7\u000f]8og\u0016,\"!!\u000f\t\u000f\t\r\u0004\u0001\"\u0011\u0003f\u0005\t2M]3bi\u0016<U\r\u001e*fgB|gn]3\u0015\r\u0005e\"q\rB5\u0011\u001d\tIE!\u0019A\u0002IAqAa\u001b\u0003b\u0001\u0007A$A\u0001w\u0011\u001d\u0011y\u0007\u0001C!\u0005c\nac\u0019:fCR,W*\u001e7uS\u001e+GOU3ta>t7/\u001a\u000b\u0005\u0003s\u0011\u0019\b\u0003\u0005\u0003v\t5\u0004\u0019\u0001B<\u0003\u0015\u0001\u0018-\u001b:t!\u0015\u0019\"\u0011\u0010\n\u001d\u0013\r\u0011Yh\u0007\u0002\u0004\u001b\u0006\u0004\bb\u0002B@\u0001\u0011\u0005#\u0011Q\u0001\u0014GJ,\u0017\r^3FeJ|'OU3ta>t7/\u001a\u000b\u0005\u0003s\u0011\u0019\t\u0003\u0005\u0003\u0006\nu\u0004\u0019\u0001BD\u0003\u0005!\b\u0003\u0002B\u0018\u0005\u0013KAAa#\u0003D\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0005\b\u0005\u001f\u0003A\u0011\u0002BI\u0003aawnZ!oI\u000e\u0013X-\u0019;f\u000bJ\u0014xN]'fgN\fw-\u001a\u000b\u0007\u0005'\u0013yJa)\u0011\t\tU%1T\u0007\u0003\u0005/S1A!'2\u0003\u0011a\u0017M\\4\n\t\tu%q\u0013\u0002\u000e'R\u0014\u0018N\\4Ck&dG-\u001a:\t\u0011\t\u0005&Q\u0012a\u0001\u0005'\u000b!a\u001d2\t\u0011\t\u0015&Q\u0012a\u0001\u0005O\u000b\u0011!\u001c\t\u0004;\t%\u0016b\u0001BV\u0005\t\u0011R*Z7dC\u000eDW\rZ#yG\u0016\u0004H/[8o\u0011\u001d\u0011y\u000b\u0001C)\u0005c\u000bQc\u0019:fCR,7+\u001a:wKJ,\u0005pY3qi&|g\u000e\u0006\u0004\u00034\nU&q\u0018\t\u0006)q\u00149\u000b\u0015\u0005\t\u0005o\u0013i\u000b1\u0001\u0003:\u0006\tQ\r\u0005\u0003\u00030\tm\u0016\u0002\u0002B_\u0005\u0007\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\t\u0011\u0005\r\"Q\u0016a\u0001\u0003\u000fAqAa1\u0001\t\u0013\u0011)-\u0001\u0007dY>\u001cXm\u00115b]:,G\u000e\u0006\u0003\u0002:\t\u001d\u0007\u0002CA-\u0005\u0003\u0004\r!a\u0017\t\u000f\t-\u0007\u0001\"\u0011\u0003`\u0005\u00192M]3bi\u0016\u001cF/\u0019;t%\u0016\u001c\bo\u001c8tK\"9!q\u001a\u0001\u0005\n\tE\u0017!\u00032vS2$7\u000b^1u)!\t9Aa5\u0003X\n\u0005\bb\u0002Bk\u0005\u001b\u0004\rAE\u0001\u0005gR\fG\u000f\u0003\u0005\u0003Z\n5\u0007\u0019\u0001Bn\u0003\u00151\u0018\r\\;f!\r!\"Q\\\u0005\u0004\u0005?,\"aA!os\"A!\u0011\u0015Bg\u0001\u0004\u0011\u0019\nC\u0004\u0002\u001e\u0002!IA!:\u0015\u000fq\u00119Oa=\u0003v\"A!\u0011\u001eBr\u0001\u0004\u0011Y/\u0001\u0003eCR\f\u0007#\u0002\u000b\u0002.\t5\bc\u0001\u000b\u0003p&\u0019!\u0011_\u000b\u0003\t\tKH/\u001a\u0005\t\u0003G\u0013\u0019\u000f1\u0001\u0002&\"A\u00111\u0017Br\u0001\u0004\t)\u000bC\u0004\u0003z\u0002!IAa?\u0002!\t,\u0018\u000e\u001c3HKR\u0014Vm\u001d9p]N,G\u0003CA\u0004\u0005{\u001ciaa\u0004\t\u0011\t}(q\u001fa\u0001\u0007\u0003\t!a\u001c9\u0011\t\r\r1\u0011\u0002\t\u0004)\r\u0015\u0011bAB\u0004+\tYQI\\;nKJ\fG/[8o\u0013\u0011\u0019Ya!\u0002\u0003\u000bY\u000bG.^3\t\u000f\u0005%#q\u001fa\u0001%!9!1\u000eB|\u0001\u0004a\u0002bBB\n\u0001\u0011%1QC\u0001\u0017EVLG\u000eZ*j]\u001edWmR3u%\u0016\u001c\bo\u001c8tKR1\u0011qAB\f\u00073Aq!!\u0013\u0004\u0012\u0001\u0007!\u0003C\u0004\u0003l\rE\u0001\u0019\u0001\u000f\t\u000f\ru\u0001\u0001\"\u0003\u0004 \u0005\u0019\"-^5mI\u001e+G\u000fS3bI\u0016\u0014()Z4j]RA\u0011qAB\u0011\u0007G\u0019)\u0003C\u0004\u0002J\rm\u0001\u0019\u0001\n\t\u000f\t-41\u0004a\u00019!A1qEB\u000e\u0001\u0004\tY,\u0001\u0006fqR\u0014\u0018m\u00159bG\u0016Dqaa\u000b\u0001\t\u0013\u0019i#\u0001\nxe&$XmR3u\u0011\u0016\fG-\u001a:ECR\fGCBA\u0004\u0007_\u0019\t\u0004\u0003\u0005\u0003j\u000e%\u0002\u0019\u0001Bv\u0011!\u0019\u0019d!\u000bA\u0002\u0005\u001d\u0011a\u00012vM\"91q\u0007\u0001\u0005\n\re\u0012!E<sSR,w)\u001a;IK\u0006$WM]#oIR!\u0011qAB\u001e\u0011!\u0019\u0019d!\u000eA\u0002\u0005\u001d\u0001bBB \u0001\u0011%1\u0011I\u0001\"EVLG\u000eZ*j]\u001edWmR3u/&$\bNV3sg&|gNU3ta>t7/\u001a\u000b\u0007\u0003\u000f\u0019\u0019e!\u0012\t\u000f\u0005%3Q\ba\u0001%!9!1NB\u001f\u0001\u0004a\u0002bBB%\u0001\u0011%11J\u0001\u0014MJLWM\u001c3ms6\u000b\u00070\u00138u\u0007\",7m\u001b\u000b\u0007\u0003w\u001bie!\u0015\t\u000f\r=3q\ta\u0001%\u00051a.^7cKJDqaa\u0015\u0004H\u0001\u0007!#A\u0004nKN\u001c\u0018mZ3\t\u000f\r]\u0003\u0001\"\u0003\u0004Z\u0005\tb.^7fe&\u001cG*[7ji\u000eCWmY6\u0015\u0015\u0005m61LB/\u0007C\u001a\u0019\u0007C\u0004\u0004P\rU\u0003\u0019\u0001\n\t\u0011\r}3Q\u000ba\u0001\u0003K\u000b\u0001\"\\1y-\u0006dW/\u001a\u0005\b\u0007'\u001a)\u00061\u0001\u0013\u0011!\u0019)g!\u0016A\u0002\r\u001d\u0014!\u00018\u0011\t\t=2\u0011N\u0005\u0005\u0007W\u0012\u0019EA\u000bOk6\u0014WM\u001d$pe6\fG/\u0012=dKB$\u0018n\u001c8\t\u000f\r]\u0003\u0001\"\u0003\u0004pQA\u0011QUB9\u0007g\u001a)\bC\u0004\u0004P\r5\u0004\u0019\u0001\n\t\u0011\r}3Q\u000ea\u0001\u0003KCqaa\u0015\u0004n\u0001\u0007!\u0003")
public class MemcachedDecoder
extends AbstractProtocolDecoder<String, MemcachedValue>
implements ScalaObject {
    private final ScheduledExecutorService scheduler;
    private final NettyTransport transport;
    private boolean isStatsEnabled;
    private final AtomicLong incrMisses;
    private final AtomicLong incrHits;
    private final AtomicLong decrMisses;
    private final AtomicLong decrHits;
    private final AtomicLong replaceIfUnmodifiedMisses;
    private final AtomicLong replaceIfUnmodifiedHits;
    private final AtomicLong replaceIfUnmodifiedBadval;
    private volatile int bitmap$priv$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStatsEnabled() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.isStatsEnabled;
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.isStatsEnabled = this.cache().getConfiguration().isExposeJmxStatistics();
                this.bitmap$priv$0 |= 1;
            }
            return this.isStatsEnabled;
        }
    }

    private final AtomicLong incrMisses() {
        return this.incrMisses;
    }

    private final AtomicLong incrHits() {
        return this.incrHits;
    }

    private final AtomicLong decrMisses() {
        return this.decrMisses;
    }

    private final AtomicLong decrHits() {
        return this.decrHits;
    }

    private final AtomicLong replaceIfUnmodifiedMisses() {
        return this.replaceIfUnmodifiedMisses;
    }

    private final AtomicLong replaceIfUnmodifiedHits() {
        return this.replaceIfUnmodifiedHits;
    }

    private final AtomicLong replaceIfUnmodifiedBadval() {
        return this.replaceIfUnmodifiedBadval;
    }

    public Tuple2<Option<RequestHeader>, Object> readHeader(ChannelBuffer buffer) {
        Tuple2<String, Object> tuple2 = TextProtocolUtil$.MODULE$.readElement(buffer);
        if (tuple2 != null) {
            Enumeration.Value op;
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            String streamOp = (String)tuple22._1();
            boolean endOfOp = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
            Enumeration.Value value = op = RequestResolver$.MODULE$.toRequest(streamOp, endOfOp, buffer);
            Enumeration.Value value2 = Operation$.MODULE$.StatsRequest();
            if (!(value != null ? !value.equals(value2) : value2 != null) && !endOfOp) {
                String line = TextProtocolUtil$.MODULE$.readLine(buffer).trim();
                if (line.isEmpty()) {
                    endOfOp = true;
                } else {
                    throw new StreamCorruptedException(new StringBuilder().append((Object)"Stats command does not accept arguments: ").append((Object)line).toString());
                }
            }
            Enumeration.Value value3 = op;
            Enumeration.Value value4 = MemcachedOperation$.MODULE$.VerbosityRequest();
            if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                Object object = endOfOp ? BoxedUnit.UNIT : TextProtocolUtil$.MODULE$.readLine(buffer);
                throw new StreamCorruptedException("Memcached 'verbosity' command is unsupported");
            }
            return new Tuple2((Object)new Some((Object)new RequestHeader(op)), (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<String, Object> readKey(ChannelBuffer b) {
        Tuple2<String, Object> tuple2 = TextProtocolUtil$.MODULE$.readElement(b);
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            String k = (String)tuple22._1();
            boolean endOfOp = BoxesRunTime.unboxToBoolean((Object)tuple22._2());
            this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, endOfOp, b);
            return new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
        }
        throw new MatchError(tuple2);
    }

    private String[] readKeys(ChannelBuffer b) {
        return TextProtocolUtil$.MODULE$.readLine(b).trim().split(" +");
    }

    public Object get(ChannelBuffer buffer$1) {
        Object object;
        String[] keys = this.readKeys(buffer$1);
        if (keys.length > 1) {
            scala.collection.mutable.HashMap map$1 = new scala.collection.mutable.HashMap();
            Predef$.MODULE$.refArrayOps((Object[])keys).foreach((Function1)new scala.Serializable(this, buffer$1, map$1){
                public static final long serialVersionUID;
                private final MemcachedDecoder $outer;
                private final ChannelBuffer buffer$1;
                private final scala.collection.mutable.HashMap map$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(String k) {
                    MemcachedValue v = (MemcachedValue)((Object)this.$outer.cache().get(this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, true, this.buffer$1)));
                    return v == null ? BoxedUnit.UNIT : this.map$1.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)k).$minus$greater((Object)((Object)v)));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.buffer$1 = channelBuffer;
                    this.map$1 = hashMap;
                }
            });
            object = this.createMultiGetResponse((Map<String, MemcachedValue>)new HashMap().$plus$plus((GenTraversableOnce)map$1));
        } else {
            String key = keys[0];
            object = this.createGetResponse(key, (MemcachedValue)((Object)this.cache().get(this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(key, true, buffer$1))));
        }
        return object;
    }

    public final String org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(String k, boolean endOfOp, ChannelBuffer b) {
        if (k.length() > 250) {
            Object object = endOfOp ? BoxedUnit.UNIT : TextProtocolUtil$.MODULE$.readLine(b);
            throw new StreamCorruptedException("Key length over the 250 character limit");
        }
        return k;
    }

    public boolean readParameters(Channel ch, ChannelBuffer b$1) {
        MemcachedParameters memcachedParameters;
        String line$1 = TextProtocolUtil$.MODULE$.readLine(b$1);
        BooleanRef endOfOp$1 = new BooleanRef(false);
        if (line$1.isEmpty()) {
            memcachedParameters = null;
        } else {
            if (this.isTraceEnabled()) {
                this.trace((Function0)new scala.Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Operation parameters: %s";
                    }
                }, line$1);
            }
            String[] args$1 = line$1.trim().split(" +");
            memcachedParameters = this.liftedTree1$1(b$1, line$1, endOfOp$1, args$1);
        }
        this.params_$eq(memcachedParameters);
        return endOfOp$1.elem;
    }

    private MemcachedParameters readRemoveParameters(String[] args) {
        int delayedDeleteTime = this.parseDelayedDeleteTime(args);
        boolean noReply = delayedDeleteTime == -1 ? this.parseNoReply(0, args) : false;
        return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", 0);
    }

    private MemcachedParameters readIncrDecrParameters(String[] args) {
        String delta = args[0];
        return new MemcachedParameters(-1, -1, -1, -1L, this.parseNoReply(1, args), 0L, delta, 0);
    }

    private MemcachedParameters readFlushAllParameters(String[] args) {
        NumberFormatException numberFormatException2;
        block2: {
            boolean noReplyFound = false;
            int exceptionResult1 = 0;
            try {
                exceptionResult1 = this.friendlyMaxIntCheck(args[0], "Flush delay");
            }
            catch (NumberFormatException numberFormatException2) {
                if (!numberFormatException2.getMessage().contains("noreply")) break block2;
                noReplyFound = true;
                exceptionResult1 = 0;
            }
            int flushDelay = exceptionResult1;
            boolean noReply = noReplyFound ? true : this.parseNoReply(1, args);
            return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", flushDelay);
        }
        throw numberFormatException2;
    }

    private MemcachedParameters readStorageParameters(String[] args, ChannelBuffer b) {
        int length;
        int streamLifespan;
        int index = 0;
        long flags = this.getFlags(args[index]);
        if (flags < 0L) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Flags cannot be negative: ").append((Object)BoxesRunTime.boxToLong((long)flags)).toString());
        }
        int lifespan = (streamLifespan = this.getLifespan(args[++index])) <= 0 ? -1 : streamLifespan;
        if ((length = this.getLength(args[++index])) < 0) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Negative bytes length provided: ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString());
        }
        Enumeration.Value value = this.header().op();
        Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
        Enumeration.Value value3 = value;
        long streamVersion = !(value2 != null ? !value2.equals(value3) : value3 != null) ? this.getVersion(args[++index]) : -1L;
        boolean noReply = this.parseNoReply(++index, args);
        return new MemcachedParameters(length, lifespan, -1, streamVersion, noReply, flags, "", 0);
    }

    public void readValue(ChannelBuffer b) {
        b.readBytes(this.rawValue());
        TextProtocolUtil$.MODULE$.readLine(b);
    }

    public MemcachedValue createValue(long nextVersion) {
        return new MemcachedValue(this.rawValue(), nextVersion, ((MemcachedParameters)this.params()).flags());
    }

    /*
     * WARNING - void declaration
     */
    private long getFlags(String flags) {
        void var2_2;
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        long exceptionResult2 = 0L;
        try {
            exceptionResult2 = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags");
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult2 = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags", numberFormatException);
        }
        return (long)var2_2;
    }

    private int getLifespan(String lifespan) {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return this.friendlyMaxIntCheck(lifespan, "Lifespan");
    }

    private int getLength(String length) {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return this.friendlyMaxIntCheck(length, "The number of bytes");
    }

    private long getVersion(String version) {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return Predef$.MODULE$.augmentString(version).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNoReply(int expectedIndex, String[] args) {
        if (args.length <= expectedIndex) return false;
        String string = args[expectedIndex];
        if ("noreply" != null) {
            if (!"noreply".equals(string)) throw new StreamCorruptedException("Unable to parse noreply optional argument");
            return true;
        }
        if (string == null) return true;
        throw new StreamCorruptedException("Unable to parse noreply optional argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDelayedDeleteTime(String[] args) {
        int n;
        if (args.length <= 0) return 0;
        int exceptionResult3 = 0;
        try {
            n = exceptionResult3 = Predef$.MODULE$.augmentString(args[0]).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public Cache<String, MemcachedValue> getCache() {
        return this.cache();
    }

    public Object customDecodeHeader(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        value = this.header().op();
                        Enumeration.Value value2 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        object = this.flushAll(buffer, ch, false);
                        break block3;
                    }
                    Enumeration.Value value4 = MemcachedOperation$.MODULE$.VersionRequest();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    java.lang.StringBuilder ret = new java.lang.StringBuilder().append("VERSION ").append(Version.VERSION).append(TextProtocolUtil$.MODULE$.CRLF());
                    object = this.writeResponse(ch, ret);
                    break block3;
                }
                Enumeration.Value value6 = MemcachedOperation$.MODULE$.QuitRequest();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                object = this.closeChannel(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeKey(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block5: {
            Object object;
            block4: {
                block3: {
                    block2: {
                        value = this.header().op();
                        Enumeration.Value value2 = MemcachedOperation$.MODULE$.AppendRequest();
                        Enumeration.Value value3 = value;
                        if (!(value2 == null ? value3 != null : !value2.equals(value3))) break block2;
                        Enumeration.Value value4 = MemcachedOperation$.MODULE$.PrependRequest();
                        Enumeration.Value value5 = value;
                        if (!(value4 == null ? value5 != null : !value4.equals(value5))) break block2;
                        Enumeration.Value value6 = MemcachedOperation$.MODULE$.IncrementRequest();
                        Enumeration.Value value7 = value;
                        if (!(value6 == null ? value7 != null : !value6.equals(value7))) break block2;
                        Enumeration.Value value8 = MemcachedOperation$.MODULE$.DecrementRequest();
                        Enumeration.Value value9 = value;
                        if (value8 != null ? !value8.equals(value9) : value9 != null) break block3;
                    }
                    this.key_$eq(this.readKey(buffer)._1());
                    object = this.checkpointTo(DecoderState.DECODE_PARAMETERS);
                    break block4;
                }
                Enumeration.Value value10 = MemcachedOperation$.MODULE$.FlushAllRequest();
                Enumeration.Value value11 = value;
                if (value10 != null ? !value10.equals(value11) : value11 != null) break block5;
                object = this.flushAll(buffer, ch, true);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeValue(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block15: {
            Object object;
            block13: {
                block14: {
                    block7: {
                        Enumeration.Value value2;
                        block12: {
                            Object object2;
                            block9: {
                                byte[] byArray;
                                MemcachedValue prev;
                                block11: {
                                    block10: {
                                        block8: {
                                            block6: {
                                                Enumeration.Value op;
                                                value = op = this.header().op();
                                                Enumeration.Value value3 = MemcachedOperation$.MODULE$.AppendRequest();
                                                Enumeration.Value value4 = value;
                                                if (!(value3 == null ? value4 != null : !value3.equals(value4))) break block6;
                                                Enumeration.Value value5 = MemcachedOperation$.MODULE$.PrependRequest();
                                                Enumeration.Value value6 = value;
                                                if (value5 != null ? !value5.equals(value6) : value6 != null) break block7;
                                            }
                                            this.readValue(buffer);
                                            prev = (MemcachedValue)((Object)this.cache().get(this.key()));
                                            if (prev != null) break block8;
                                            object2 = ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_STORED();
                                            break block9;
                                        }
                                        value2 = this.header().op();
                                        Enumeration.Value value7 = MemcachedOperation$.MODULE$.AppendRequest();
                                        Enumeration.Value value8 = value2;
                                        if (value7 != null ? !value7.equals(value8) : value8 != null) break block10;
                                        byArray = TextProtocolUtil$.MODULE$.concat(prev.data(), this.rawValue());
                                        break block11;
                                    }
                                    Enumeration.Value value9 = MemcachedOperation$.MODULE$.PrependRequest();
                                    Enumeration.Value value10 = value2;
                                    if (value9 != null ? !value9.equals(value10) : value10 != null) break block12;
                                    byArray = TextProtocolUtil$.MODULE$.concat(this.rawValue(), prev.data());
                                }
                                byte[] concatenated = byArray;
                                MemcachedValue next = this.createValue(concatenated, this.generateVersion(this.cache()), ((MemcachedParameters)this.params()).flags());
                                boolean replaced = this.cache().replace(this.key(), prev, next);
                                object2 = replaced ? (Object)(((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.STORED()) : (Object)(((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_STORED());
                            }
                            byte[] ret = object2;
                            object = this.writeResponse(ch, ret);
                            break block13;
                        }
                        throw new MatchError((Object)value2);
                    }
                    Enumeration.Value value11 = MemcachedOperation$.MODULE$.IncrementRequest();
                    Enumeration.Value value12 = value;
                    if (!(value11 == null ? value12 != null : !value11.equals(value12))) break block14;
                    Enumeration.Value value13 = MemcachedOperation$.MODULE$.DecrementRequest();
                    Enumeration.Value value14 = value;
                    if (value13 != null ? !value13.equals(value14) : value14 != null) break block15;
                }
                object = this.incrDecr(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    private Object incrDecr(Channel ch) {
        Enumeration.Value value;
        block9: {
            BigInt prevCounter;
            block10: {
                Object object;
                block6: {
                    Object object2;
                    Enumeration.Value op;
                    MemcachedValue prev;
                    block8: {
                        BigInt delta;
                        block7: {
                            block5: {
                                Object object3;
                                prev = (MemcachedValue)((Object)this.cache().get(this.key()));
                                op = this.header().op();
                                if (prev != null) break block5;
                                if (this.isStatsEnabled()) {
                                    Enumeration.Value value2 = op;
                                    Enumeration.Value value3 = MemcachedOperation$.MODULE$.IncrementRequest();
                                    object3 = BoxesRunTime.boxToLong((long)(!(value2 != null ? !value2.equals(value3) : value3 != null) ? this.incrMisses().incrementAndGet() : this.decrMisses().incrementAndGet()));
                                } else {
                                    object3 = BoxedUnit.UNIT;
                                }
                                object = ((MemcachedParameters)this.params()).noReply() ? null : (Serializable)TextProtocolUtil$.MODULE$.NOT_FOUND();
                                break block6;
                            }
                            prevCounter = package$.MODULE$.BigInt().apply(new String(prev.data()));
                            delta = this.validateDelta(((MemcachedParameters)this.params()).delta());
                            value = op;
                            Enumeration.Value value4 = MemcachedOperation$.MODULE$.IncrementRequest();
                            Enumeration.Value value5 = value;
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block7;
                            BigInt candidateCounter = prevCounter.$plus(delta);
                            object2 = candidateCounter.$greater(TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG()) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                            break block8;
                        }
                        Enumeration.Value value6 = MemcachedOperation$.MODULE$.DecrementRequest();
                        Enumeration.Value value7 = value;
                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block9;
                        BigInt candidateCounter = prevCounter.$minus(delta);
                        object2 = candidateCounter.$less(BigInt$.MODULE$.int2bigInt(0)) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                    }
                    Object newCounter = object2;
                    MemcachedValue next = this.createValue(newCounter.toString().getBytes(), this.generateVersion(this.cache()), ((MemcachedParameters)this.params()).flags());
                    boolean replaced = this.cache().replace(this.key(), prev, next);
                    if (replaced) {
                        Object object4;
                        if (this.isStatsEnabled()) {
                            Enumeration.Value value8 = op;
                            Enumeration.Value value9 = MemcachedOperation$.MODULE$.IncrementRequest();
                            object4 = BoxesRunTime.boxToLong((long)(!(value8 != null ? !value8.equals(value9) : value9 != null) ? this.incrHits().incrementAndGet() : this.decrHits().incrementAndGet()));
                        } else {
                            object4 = BoxedUnit.UNIT;
                        }
                        object = ((MemcachedParameters)this.params()).noReply() ? null : new StringBuilder().append((Object)new String(next.data())).append((Object)TextProtocolUtil$.MODULE$.CRLF()).toString();
                    }
                    break block10;
                }
                Serializable ret = object;
                return this.writeResponse(ch, ret);
            }
            throw new CacheException(new StringBuilder().append((Object)"Value modified since we retrieved from the cache, old value was ").append((Object)prevCounter).toString());
        }
        throw new MatchError((Object)value);
    }

    private Object flushAll(ChannelBuffer b, Channel ch, boolean isReadParams) {
        Object object = isReadParams ? BoxesRunTime.boxToBoolean((boolean)this.readParameters(ch, b)) : BoxedUnit.UNIT;
        scala.Serializable flushFunction = new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(AdvancedCache<String, MemcachedValue> cache) {
                cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_STORE}).clear();
            }
        };
        int flushDelay = this.params() == null ? 0 : ((MemcachedParameters)this.params()).flushDelay();
        ScheduledFuture<?> scheduledFuture = flushDelay == 0 ? flushFunction.apply((Object)this.cache().getAdvancedCache()) : this.scheduler.schedule(new DelayedFlushAll((Cache<String, MemcachedValue>)this.cache(), (Function1<AdvancedCache<String, MemcachedValue>, BoxedUnit>)flushFunction), this.toMillis(flushDelay), TimeUnit.MILLISECONDS);
        byte[] ret = (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.OK());
        return this.writeResponse(ch, ret);
    }

    /*
     * WARNING - void declaration
     */
    private BigInt validateDelta(String delta) {
        void var2_2;
        BigInt bigIntDelta = package$.MODULE$.BigInt().apply(delta);
        if (bigIntDelta.$greater(TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta sent (").append((Object)delta).append((Object)") exceeds unsigned limit (").append((Object)TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG()).append((Object)")").toString());
        }
        if (bigIntDelta.$less(TextProtocolUtil$.MODULE$.MIN_UNSIGNED())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta cannot be negative: ").append((Object)delta).toString());
        }
        return var2_2;
    }

    public Object createSuccessResponse(MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedHits().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.RemoveRequest();
            Enumeration.Value value5 = value;
            byArray = !(value4 != null ? !value4.equals(value5) : value5 != null) ? TextProtocolUtil$.MODULE$.DELETED() : TextProtocolUtil$.MODULE$.STORED();
        }
        return byArray;
    }

    public Object createNotExecutedResponse(MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedBadval().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value5 = value;
            byArray = !(value4 != null ? !value4.equals(value5) : value5 != null) ? TextProtocolUtil$.MODULE$.EXISTS() : TextProtocolUtil$.MODULE$.NOT_STORED();
        }
        return byArray;
    }

    public Object createNotExistResponse() {
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedMisses().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_FOUND());
    }

    public Object createGetResponse(String k, MemcachedValue v) {
        Enumeration.Value value;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        if (v != null) break block2;
                        object = TextProtocolUtil$.MODULE$.END();
                        break block3;
                    }
                    value = this.header().op();
                    Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block4;
                    object = this.buildSingleGetResponse(k, v);
                    break block3;
                }
                Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block5;
                object = this.buildSingleGetWithVersionResponse(k, v);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object createMultiGetResponse(Map<String, MemcachedValue> pairs) {
        Enumeration.Value value;
        block3: {
            Enumeration.Value op$1;
            ListBuffer elements$1;
            block2: {
                elements$1 = new ListBuffer();
                value = op$1 = this.header().op();
                Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
                Enumeration.Value value3 = value;
                if (!(value2 == null ? value3 != null : !value2.equals(value3))) break block2;
                Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block3;
            }
            ((IterableLike)pairs.filter((Function1)new scala.Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<String, MemcachedValue> tuple2) {
                    Tuple2<String, MemcachedValue> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new scala.Serializable(this, elements$1, op$1){
                public static final long serialVersionUID;
                private final MemcachedDecoder $outer;
                private final ListBuffer elements$1;
                private final Enumeration.Value op$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final ListBuffer<ChannelBuffer> apply(Tuple2<String, MemcachedValue> tuple2) {
                    Tuple2<String, MemcachedValue> tuple22 = tuple2;
                    if (tuple22 != null) {
                        return this.elements$1.$plus$eq((Object)this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(this.op$1, (String)tuple22._1(), (MemcachedValue)((Object)tuple22._2())));
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.elements$1 = listBuffer;
                    this.op$1 = value;
                }
            });
            elements$1.$plus$eq((Object)ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{TextProtocolUtil$.MODULE$.END()})));
            return elements$1.toList();
        }
        throw new MatchError((Object)value);
    }

    public Object createErrorResponse(Throwable t) {
        Object object;
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        Throwable throwable = t;
        if (throwable instanceof MemcachedException) {
            MemcachedException memcachedException = (MemcachedException)throwable;
            MemcachedException m = memcachedException;
            Throwable throwable2 = m.getCause();
            if (throwable2 instanceof UnknownOperationException) {
                this.logExceptionReported((Throwable)((UnknownOperationException)throwable2));
                object = TextProtocolUtil$.MODULE$.ERROR();
            } else if (throwable2 instanceof ClosedChannelException) {
                this.logExceptionReported((ClosedChannelException)throwable2);
                object = null;
            } else {
                object = throwable2 instanceof IOException ? this.logAndCreateErrorMessage(sb, m) : (throwable2 instanceof NumberFormatException ? this.logAndCreateErrorMessage(sb, m) : (throwable2 instanceof IllegalStateException ? this.logAndCreateErrorMessage(sb, m) : sb.append(m.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF())));
            }
        } else if (throwable instanceof ClosedChannelException) {
            this.logExceptionReported((ClosedChannelException)throwable);
            object = null;
        } else {
            object = sb.append(TextProtocolUtil$.MODULE$.SERVER_ERROR()).append(t.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
        }
        return object;
    }

    private java.lang.StringBuilder logAndCreateErrorMessage(java.lang.StringBuilder sb, MemcachedException m) {
        this.logExceptionReported(m.getCause());
        return sb.append(m.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
    }

    public Tuple2<MemcachedException, Object> createServerException(Exception e, ChannelBuffer b) {
        Tuple2 tuple2;
        Exception exception = e;
        if (exception instanceof IOException) {
            IOException iOException;
            IOException i = iOException = (IOException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.CLIENT_ERROR_BAD_FORMAT()).append((Object)i.getMessage()).toString(), i), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (exception instanceof NumberFormatException) {
            NumberFormatException numberFormatException;
            NumberFormatException n = numberFormatException = (NumberFormatException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.CLIENT_ERROR_BAD_FORMAT()).append((Object)n.getMessage()).toString(), n), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.SERVER_ERROR()).append((Object)e).toString(), e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple2;
    }

    private Object closeChannel(Channel ch) {
        ch.close();
        return null;
    }

    public Object createStatsResponse() {
        Stats stats = this.cache().getAdvancedCache().getStats();
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.buildStat("pid", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("time", BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())), sb), this.buildStat("version", this.cache().getVersion(), sb), this.buildStat("pointer_size", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_user", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_system", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_items", BoxesRunTime.boxToInteger((int)stats.getCurrentNumberOfEntries()), sb), this.buildStat("total_items", BoxesRunTime.boxToLong((long)stats.getTotalNumberOfEntries()), sb), this.buildStat("bytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("total_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("connection_structures", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("cmd_get", BoxesRunTime.boxToLong((long)stats.getRetrievals()), sb), this.buildStat("cmd_set", BoxesRunTime.boxToLong((long)stats.getStores()), sb), this.buildStat("get_hits", BoxesRunTime.boxToLong((long)stats.getHits()), sb), this.buildStat("get_misses", BoxesRunTime.boxToLong((long)stats.getMisses()), sb), this.buildStat("delete_misses", BoxesRunTime.boxToLong((long)stats.getRemoveMisses()), sb), this.buildStat("delete_hits", BoxesRunTime.boxToLong((long)stats.getRemoveHits()), sb), this.buildStat("incr_misses", this.incrMisses(), sb), this.buildStat("incr_hits", this.incrHits(), sb), this.buildStat("decr_misses", this.decrMisses(), sb), this.buildStat("decr_hits", this.decrHits(), sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses(), sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits(), sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval(), sb), this.buildStat("auth_cmds", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("auth_errors", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("evictions", BoxesRunTime.boxToLong((long)stats.getEvictions()), sb), this.buildStat("bytes_read", this.transport.getTotalBytesRead(), sb), this.buildStat("bytes_written", this.transport.getTotalBytesWritten(), sb), this.buildStat("limit_maxbytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("threads", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("conn_yields", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("reclaimed", BoxesRunTime.boxToInteger((int)0), sb), ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{TextProtocolUtil$.MODULE$.END()}))}));
    }

    private ChannelBuffer buildStat(String stat, Object value, java.lang.StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append(TextProtocolUtil$.MODULE$.CRLF());
        ChannelBuffer buffer = ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sb.toString().getBytes()}));
        sb.setLength(0);
        return buffer;
    }

    private MemcachedValue createValue(byte[] data, long nextVersion, long flags) {
        return new MemcachedValue(data, nextVersion, flags);
    }

    public final ChannelBuffer org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(Enumeration.Value op, String k, MemcachedValue v) {
        ChannelBuffer buf = this.buildGetHeaderBegin(k, v, 0);
        return this.writeGetHeaderData(v.data(), buf);
    }

    private ChannelBuffer buildSingleGetResponse(String k, MemcachedValue v) {
        ChannelBuffer buf = this.buildGetHeaderBegin(k, v, TextProtocolUtil$.MODULE$.END_SIZE());
        this.writeGetHeaderData(v.data(), buf);
        return this.writeGetHeaderEnd(buf);
    }

    private ChannelBuffer buildGetHeaderBegin(String k, MemcachedValue v, int extraSpace) {
        byte[] data = v.data();
        byte[] dataSize = Integer.valueOf(data.length).toString().getBytes();
        byte[] key = k.getBytes();
        byte[] flags = v.flags() != 0L ? Long.valueOf(v.flags()).toString().getBytes() : TextProtocolUtil$.MODULE$.ZERO();
        int flagsSize = flags.length;
        ChannelBuffer buf = ExtendedChannelBuffer$.MODULE$.buffer(TextProtocolUtil$.MODULE$.VALUE_SIZE() + key.length + data.length + flagsSize + dataSize.length + 6 + extraSpace);
        buf.writeBytes(TextProtocolUtil$.MODULE$.VALUE());
        buf.writeBytes(key);
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(flags);
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(dataSize);
        return buf;
    }

    private ChannelBuffer writeGetHeaderData(byte[] data, ChannelBuffer buf) {
        buf.writeBytes(TextProtocolUtil$.MODULE$.CRLFBytes());
        buf.writeBytes(data);
        buf.writeBytes(TextProtocolUtil$.MODULE$.CRLFBytes());
        return buf;
    }

    private ChannelBuffer writeGetHeaderEnd(ChannelBuffer buf) {
        buf.writeBytes(TextProtocolUtil$.MODULE$.END());
        return buf;
    }

    private ChannelBuffer buildSingleGetWithVersionResponse(String k, MemcachedValue v) {
        byte[] version = ((Object)BoxesRunTime.boxToLong((long)v.version())).toString().getBytes();
        ChannelBuffer buf = this.buildGetHeaderBegin(k, v, version.length + 1 + TextProtocolUtil$.MODULE$.END_SIZE());
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(version);
        this.writeGetHeaderData(v.data(), buf);
        return this.writeGetHeaderEnd(buf);
    }

    /*
     * WARNING - void declaration
     */
    private int friendlyMaxIntCheck(String number, String message) {
        void var3_3;
        int exceptionResult4 = 0;
        try {
            exceptionResult4 = Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult4 = this.numericLimitCheck(number, Integer.MAX_VALUE, message, numberFormatException);
        }
        return (int)var3_3;
    }

    private int numericLimitCheck(String number, long maxValue, String message, NumberFormatException n) {
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        throw n;
    }

    private long numericLimitCheck(String number, long maxValue, String message) {
        long numeric = Long.parseLong(number);
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        return numeric;
    }

    /*
     * Unable to fully structure code
     */
    private final MemcachedParameters liftedTree1$1(ChannelBuffer var1_1, String var2_2, BooleanRef var3_3, String[] var4_4) {
        exceptionResult5 = null;
        try {
            block5: {
                block6: {
                    block4: {
                        var6_6 = this.header().op();
                        v0 = Operation$.MODULE$.PutRequest();
                        var7_7 = var6_6;
                        if (v0 != null ? v0.equals(var7_7) == false : var7_7 != null) break block4;
                        v1 = this.readStorageParameters(var4_4, var1_1);
                        break block5;
                    }
                    v2 = Operation$.MODULE$.RemoveRequest();
                    var8_8 = var6_6;
                    if (v2 != null ? v2.equals(var8_8) == false : var8_8 != null) break block6;
                    v1 = this.readRemoveParameters(var4_4);
                    break block5;
                }
                v3 = MemcachedOperation$.MODULE$.IncrementRequest();
                var9_9 = var6_6;
                if (!(v3 == null ? var9_9 != null : v3.equals(var9_9) == false)) ** GOTO lbl-1000
                v4 = MemcachedOperation$.MODULE$.DecrementRequest();
                var10_10 = var6_6;
                if (!(v4 != null ? v4.equals(var10_10) == false : var10_10 != null)) lbl-1000:
                // 2 sources

                {
                    var3_3.elem = true;
                    v1 = this.readIncrDecrParameters(var4_4);
                } else {
                    v5 = MemcachedOperation$.MODULE$.FlushAllRequest();
                    var11_11 = var6_6;
                    v1 = !(v5 != null ? v5.equals(var11_11) == false : var11_11 != null) ? this.readFlushAllParameters(var4_4) : this.readStorageParameters(var4_4, var1_1);
                }
            }
            exceptionResult5 = v1;
            return exceptionResult5;
        }
        catch (ArrayIndexOutOfBoundsException v6) {
            throw new IOException(new StringBuilder().append((Object)"Missing content in command line ").append((Object)var2_2).toString());
        }
    }

    public MemcachedDecoder(Cache<String, MemcachedValue> memcachedCache, ScheduledExecutorService scheduler, NettyTransport transport) {
        this.scheduler = scheduler;
        this.transport = transport;
        super(transport);
        this.cache_$eq(memcachedCache);
        this.incrMisses = new AtomicLong(0L);
        this.incrHits = new AtomicLong(0L);
        this.decrMisses = new AtomicLong(0L);
        this.decrHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedMisses = new AtomicLong(0L);
        this.replaceIfUnmodifiedHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedBadval = new AtomicLong(0L);
    }
}

