/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.context.Flag;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.DecoderState;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.RequestHeader;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ExtendedChannelBuffer$;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.memcached.DelayedFlushAll;
import org.infinispan.server.memcached.MemcachedException;
import org.infinispan.server.memcached.MemcachedOperation$;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.MemcachedValue;
import org.infinispan.server.memcached.RequestResolver$;
import org.infinispan.server.memcached.TextProtocolUtil$;
import org.infinispan.stats.Stats;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\r\u0005f\u0001B\u0001\u0003\u0001-\u0011\u0001#T3nG\u0006\u001c\u0007.\u001a3EK\u000e|G-\u001a:\u000b\u0005\r!\u0011!C7f[\u000e\f7\r[3e\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000f!\t!\"\u001b8gS:L7\u000f]1o\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\rIA!Q\u0002\u0005\n!\u001b\u0005q!BA\b\u0005\u0003\u0011\u0019wN]3\n\u0005Eq!aF!cgR\u0014\u0018m\u0019;Qe>$xnY8m\t\u0016\u001cw\u000eZ3s!\t\u0019RD\u0004\u0002\u001559\u0011Q\u0003G\u0007\u0002-)\u0011qCC\u0001\u0007yI|w\u000e\u001e \n\u0003e\tQa]2bY\u0006L!a\u0007\u000f\u0002\rA\u0013X\rZ3g\u0015\u0005I\u0012B\u0001\u0010 \u0005\u0019\u0019FO]5oO*\u00111\u0004\b\t\u0003C\tj\u0011AA\u0005\u0003G\t\u0011a\"T3nG\u0006\u001c\u0007.\u001a3WC2,X\r\u0005\u0002&M5\tA$\u0003\u0002(9\tY1kY1mC>\u0013'.Z2u\u0011!I\u0003A!A!\u0002\u0013Q\u0013AD7f[\u000e\f7\r[3e\u0007\u0006\u001c\u0007.\u001a\t\u0005W1\u0012\u0002%D\u0001\u0007\u0013\ticAA\u0003DC\u000eDW\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003%\u00198\r[3ek2,'\u000f\u0005\u00022q5\t!G\u0003\u00024i\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005U2\u0014\u0001B;uS2T\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:e\tA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\t\u0011m\u0002!\u0011!Q\u0001\nq\n\u0011\u0002\u001e:b]N\u0004xN\u001d;\u0011\u0005uzT\"\u0001 \u000b\u0005mr\u0011B\u0001!?\u00059qU\r\u001e;z)J\fgn\u001d9peRDQA\u0011\u0001\u0005\u0002\r\u000ba\u0001P5oSRtD\u0003\u0002#F\r\u001e\u0003\"!\t\u0001\t\u000b%\n\u0005\u0019\u0001\u0016\t\u000b=\n\u0005\u0019\u0001\u0019\t\u000bm\n\u0005\u0019\u0001\u001f\u0006\t%\u0003\u0001A\u0013\u0002\u0013'VLG/\u00192mKB\u000b'/Y7fi\u0016\u00148\u000f\u0005\u0002\"\u0017&\u0011AJ\u0001\u0002\u0014\u001b\u0016l7-Y2iK\u0012\u0004\u0016M]1nKR,'o]\u0003\u0005\u001d\u0002\u0001qJ\u0001\bTk&$\u0018M\u00197f\u0011\u0016\fG-\u001a:\u0011\u00055\u0001\u0016BA)\u000f\u00055\u0011V-];fgRDU-\u00193fe\"A1\u000b\u0001EC\u0002\u0013%A+\u0001\bjgN#\u0018\r^:F]\u0006\u0014G.\u001a3\u0016\u0003U\u0003\"!\n,\n\u0005]c\"a\u0002\"p_2,\u0017M\u001c\u0005\t3\u0002A\t\u0011)Q\u0005+\u0006y\u0011n]*uCR\u001cXI\\1cY\u0016$\u0007\u0005C\u0004\\\u0001\t\u0007IQ\u0002/\u0002\u0015%t7M]'jgN,7/F\u0001^!\tq\u0016-D\u0001`\u0015\t\u0001''\u0001\u0004bi>l\u0017nY\u0005\u0003E~\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019!\u0007\u0001)A\u0007;\u0006Y\u0011N\\2s\u001b&\u001c8/Z:!\u0011\u001d1\u0007A1A\u0005\u000eq\u000b\u0001\"\u001b8de\"KGo\u001d\u0005\u0007Q\u0002\u0001\u000bQB/\u0002\u0013%t7M\u001d%jiN\u0004\u0003b\u00026\u0001\u0005\u0004%i\u0001X\u0001\u000bI\u0016\u001c'/T5tg\u0016\u001c\bB\u00027\u0001A\u00035Q,A\u0006eK\u000e\u0014X*[:tKN\u0004\u0003b\u00028\u0001\u0005\u0004%i\u0001X\u0001\tI\u0016\u001c'\u000fS5ug\"1\u0001\u000f\u0001Q\u0001\u000eu\u000b\u0011\u0002Z3de\"KGo\u001d\u0011\t\u000fI\u0004!\u0019!C\u00079\u0006I\"/\u001a9mC\u000e,\u0017JZ+o[>$\u0017NZ5fI6K7o]3t\u0011\u0019!\b\u0001)A\u0007;\u0006Q\"/\u001a9mC\u000e,\u0017JZ+o[>$\u0017NZ5fI6K7o]3tA!9a\u000f\u0001b\u0001\n\u001ba\u0016a\u0006:fa2\f7-Z%g+:lw\u000eZ5gS\u0016$\u0007*\u001b;t\u0011\u0019A\b\u0001)A\u0007;\u0006A\"/\u001a9mC\u000e,\u0017JZ+o[>$\u0017NZ5fI\"KGo\u001d\u0011\t\u000fi\u0004!\u0019!C\u00079\u0006I\"/\u001a9mC\u000e,\u0017JZ+o[>$\u0017NZ5fI\n\u000bGM^1m\u0011\u0019a\b\u0001)A\u0007;\u0006Q\"/\u001a9mC\u000e,\u0017JZ+o[>$\u0017NZ5fI\n\u000bGM^1mA!9a\u0010\u0001b\u0001\n\u0013!\u0016aB5t)J\f7-\u001a\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003V\u0003!I7\u000f\u0016:bG\u0016\u0004\u0003\"CA\u0003\u0001\t\u0007I\u0011BA\u0004\u0003)\u0011\u0017\u0010^3Ck\u001a4WM]\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f1\u0014AA5p\u0013\u0011\t\u0019\"!\u0004\u0003+\tKH/Z!se\u0006Lx*\u001e;qkR\u001cFO]3b[\"A\u0011q\u0003\u0001!\u0002\u0013\tI!A\u0006csR,')\u001e4gKJ\u0004\u0003bBA\u000e\u0001\u0011\u0005\u0013QD\u0001\rGJ,\u0017\r^3IK\u0006$WM]\u000b\u0002\u001f\"9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0012A\u0003:fC\u0012DU-\u00193feR1\u0011QEA\u0016\u0003\u0003\u0002B!JA\u0014+&\u0019\u0011\u0011\u0006\u000f\u0003\r=\u0003H/[8o\u0011!\ti#a\bA\u0002\u0005=\u0012A\u00022vM\u001a,'\u000f\u0005\u0003\u00022\u0005uRBAA\u001a\u0015\u0011\ti#!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0006]\u0016$H/\u001f\u0006\u0004\u0003wA\u0011!\u00026c_N\u001c\u0018\u0002BA \u0003g\u0011Qb\u00115b]:,GNQ;gM\u0016\u0014\bbBA\"\u0003?\u0001\raT\u0001\u0007Q\u0016\fG-\u001a:\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J\u00059!/Z1e\u0017\u0016LH\u0003BA&\u0003#\u0002R!JA'%UK1!a\u0014\u001d\u0005\u0019!V\u000f\u001d7fe!A\u00111KA#\u0001\u0004\ty#A\u0001c\u0011\u001d\t9\u0006\u0001C\u0005\u00033\n\u0001B]3bI.+\u0017p\u001d\u000b\u0005\u00037\nI\u0007E\u0003\u0002^\u0005\r$CD\u0002\u0015\u0003?J1!!\u0019\u001d\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001a\u0002h\t\u00191+Z9\u000b\u0007\u0005\u0005D\u0004\u0003\u0005\u0002T\u0005U\u0003\u0019AA\u0018\u0011\u001d\ti\u0007\u0001C)\u0003_\n1aZ3u)\u0011\t\t(a\u001e\u0011\u0007\u0015\n\u0019(C\u0002\u0002vq\u0011a!\u00118z%\u00164\u0007\u0002CA\u0017\u0003W\u0002\r!a\f\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~\u0005q1\r[3dW.+\u0017\u0010T3oORDGc\u0002\n\u0002\u0000\u0005\r\u0015q\u0011\u0005\b\u0003\u0003\u000bI\b1\u0001\u0013\u0003\u0005Y\u0007bBAC\u0003s\u0002\r!V\u0001\bK:$wJZ(q\u0011!\t\u0019&!\u001fA\u0002\u0005=\u0002bBAF\u0001\u0011\u0005\u0013QR\u0001\u000fe\u0016\fG\rU1sC6,G/\u001a:t)\u0015)\u0016qRAP\u0011!\t\t*!#A\u0002\u0005M\u0015AA2i!\u0011\t)*a'\u000e\u0005\u0005]%\u0002BAM\u0003k\tqa\u00195b]:,G.\u0003\u0003\u0002\u001e\u0006]%aB\"iC:tW\r\u001c\u0005\t\u0003'\nI\t1\u0001\u00020!9\u00111\u0015\u0001\u0005\n\u0005\u0015\u0016\u0001\u0006:fC\u0012\u0014V-\\8wKB\u000b'/Y7fi\u0016\u00148\u000fF\u0002K\u0003OC\u0001\"!+\u0002\"\u0002\u0007\u00111L\u0001\u0005CJ<7\u000fC\u0004\u0002.\u0002!I!a,\u0002-I,\u0017\rZ%oGJ$Um\u0019:QCJ\fW.\u001a;feN$2ASAY\u0011!\tI+a+A\u0002\u0005m\u0003bBA[\u0001\u0011%\u0011qW\u0001\u0017e\u0016\fGM\u00127vg\"\fE\u000e\u001c)be\u0006lW\r^3sgR\u0019!*!/\t\u0011\u0005%\u00161\u0017a\u0001\u00037Bq!!0\u0001\t\u0013\ty,A\u000bsK\u0006$7\u000b^8sC\u001e,\u0007+\u0019:b[\u0016$XM]:\u0015\u000b)\u000b\t-a1\t\u0011\u0005%\u00161\u0018a\u0001\u00037B\u0001\"a\u0015\u0002<\u0002\u0007\u0011q\u0006\u0005\b\u0003\u000f\u0004A\u0011KAe\u0003%\u0011X-\u00193WC2,X\r\u0006\u0003\u0002L\u0006E\u0007cA\u0013\u0002N&\u0019\u0011q\u001a\u000f\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003'\n)\r1\u0001\u00020!9\u0011Q\u001b\u0001\u0005B\u0005]\u0017aC2sK\u0006$XMV1mk\u0016$2\u0001IAm\u0011!\tY.a5A\u0002\u0005u\u0017a\u00038fqR4VM]:j_:\u00042!JAp\u0013\r\t\t\u000f\b\u0002\u0005\u0019>tw\rC\u0004\u0002f\u0002!I!a:\u0002\u0011\u001d,GO\u00127bON$B!!8\u0002j\"9\u00111^Ar\u0001\u0004\u0011\u0012!\u00024mC\u001e\u001c\bbBAx\u0001\u0011%\u0011\u0011_\u0001\fO\u0016$H*\u001b4fgB\fg\u000e\u0006\u0003\u0002t\u0006e\bcA\u0013\u0002v&\u0019\u0011q\u001f\u000f\u0003\u0007%sG\u000fC\u0004\u0002|\u00065\b\u0019\u0001\n\u0002\u00111Lg-Z:qC:Dq!a@\u0001\t\u0013\u0011\t!A\u0005hKRdUM\\4uQR!\u00111\u001fB\u0002\u0011\u001d\u0011)!!@A\u0002I\ta\u0001\\3oORD\u0007b\u0002B\u0005\u0001\u0011%!1B\u0001\u000bO\u0016$h+\u001a:tS>tG\u0003BAo\u0005\u001bAqAa\u0004\u0003\b\u0001\u0007!#A\u0004wKJ\u001c\u0018n\u001c8\t\u000f\tM\u0001\u0001\"\u0003\u0003\u0016\u0005a\u0001/\u0019:tK:{'+\u001a9msR)QKa\u0006\u0003\u001c!A!\u0011\u0004B\t\u0001\u0004\t\u00190A\u0007fqB,7\r^3e\u0013:$W\r\u001f\u0005\t\u0003S\u0013\t\u00021\u0001\u0002\\!9!q\u0004\u0001\u0005\n\t\u0005\u0012A\u00069beN,G)\u001a7bs\u0016$G)\u001a7fi\u0016$\u0016.\\3\u0015\t\u0005M(1\u0005\u0005\t\u0003S\u0013i\u00021\u0001\u0002\\!9!q\u0005\u0001\u0005B\t%\u0012\u0001C4fi\u000e\u000b7\r[3\u0016\u0003)BqA!\f\u0001\t#\u0012y#\u0001\ndkN$x.\u001c#fG>$W\rS3bI\u0016\u0014HCBA9\u0005c\u0011\u0019\u0004\u0003\u0005\u0002\u0012\n-\u0002\u0019AAJ\u0011!\tiCa\u000bA\u0002\u0005=\u0002b\u0002B\u001c\u0001\u0011E#\u0011H\u0001\u0010GV\u001cHo\\7EK\u000e|G-Z&fsR1\u0011\u0011\u000fB\u001e\u0005{A\u0001\"!%\u00036\u0001\u0007\u00111\u0013\u0005\t\u0003[\u0011)\u00041\u0001\u00020!9!\u0011\t\u0001\u0005R\t\r\u0013!E2vgR|W\u000eR3d_\u0012,g+\u00197vKR1\u0011\u0011\u000fB#\u0005\u000fB\u0001\"!%\u0003@\u0001\u0007\u00111\u0013\u0005\t\u0003[\u0011y\u00041\u0001\u00020!9!1\n\u0001\u0005\n\t5\u0013\u0001C5oGJ$Um\u0019:\u0015\t\u0005E$q\n\u0005\t\u0003#\u0013I\u00051\u0001\u0002\u0014\"9!1\u000b\u0001\u0005\n\tU\u0013\u0001\u00034mkND\u0017\t\u001c7\u0015\u0011\u0005E$q\u000bB-\u00057B\u0001\"a\u0015\u0003R\u0001\u0007\u0011q\u0006\u0005\t\u0003#\u0013\t\u00061\u0001\u0002\u0014\"9!Q\fB)\u0001\u0004)\u0016\u0001D5t%\u0016\fG\rU1sC6\u001c\bb\u0002B1\u0001\u0011%!1M\u0001\u000em\u0006d\u0017\u000eZ1uK\u0012+G\u000e^1\u0015\t\t\u0015$1\u000e\t\u0005\u0003;\u00129'\u0003\u0003\u0003j\u0005\u001d$A\u0002\"jO&sG\u000fC\u0004\u0003n\t}\u0003\u0019\u0001\n\u0002\u000b\u0011,G\u000e^1\t\u000f\tE\u0004\u0001\"\u0011\u0003t\u0005)2M]3bi\u0016\u001cVoY2fgN\u0014Vm\u001d9p]N,G\u0003BA9\u0005kBqAa\u001e\u0003p\u0001\u0007\u0001%\u0001\u0003qe\u00164\bb\u0002B>\u0001\u0011\u0005#QP\u0001\u001aGJ,\u0017\r^3O_R,\u00050Z2vi\u0016$'+Z:q_:\u001cX\r\u0006\u0003\u0002r\t}\u0004b\u0002B<\u0005s\u0002\r\u0001\t\u0005\b\u0005\u0007\u0003A\u0011\tBC\u0003Y\u0019'/Z1uK:{G/\u0012=jgR\u0014Vm\u001d9p]N,WCAA9\u0011\u001d\u0011I\t\u0001C!\u0005\u0017\u000b\u0011c\u0019:fCR,w)\u001a;SKN\u0004xN\\:f)\u0019\t\tH!$\u0003\u0010\"9\u0011\u0011\u0011BD\u0001\u0004\u0011\u0002b\u0002BI\u0005\u000f\u0003\r\u0001I\u0001\u0002m\"9!Q\u0013\u0001\u0005B\t]\u0015AF2sK\u0006$X-T;mi&<U\r\u001e*fgB|gn]3\u0015\t\u0005E$\u0011\u0014\u0005\t\u00057\u0013\u0019\n1\u0001\u0003\u001e\u0006)\u0001/Y5sgB)1Ca(\u0013A%\u0019!\u0011U\u0010\u0003\u00075\u000b\u0007\u000fC\u0004\u0003&\u0002!\tEa*\u0002'\r\u0014X-\u0019;f\u000bJ\u0014xN\u001d*fgB|gn]3\u0015\t\u0005E$\u0011\u0016\u0005\t\u0005W\u0013\u0019\u000b1\u0001\u0003.\u0006\tA\u000f\u0005\u0003\u0002^\t=\u0016\u0002\u0002BY\u0003O\u0012\u0011\u0002\u00165s_^\f'\r\\3\t\u000f\tU\u0006\u0001\"\u0003\u00038\u0006ABn\\4B]\u0012\u001c%/Z1uK\u0016\u0013(o\u001c:NKN\u001c\u0018mZ3\u0015\r\te&Q\u0019Be!\u0011\u0011YL!1\u000e\u0005\tu&b\u0001B`m\u0005!A.\u00198h\u0013\u0011\u0011\u0019M!0\u0003\u001bM#(/\u001b8h\u0005VLG\u000eZ3s\u0011!\u00119Ma-A\u0002\te\u0016AA:c\u0011!\u0011YMa-A\u0002\t5\u0017!A7\u0011\u0007\u0005\u0012y-C\u0002\u0003R\n\u0011!#T3nG\u0006\u001c\u0007.\u001a3Fq\u000e,\u0007\u000f^5p]\"9!Q\u001b\u0001\u0005R\t]\u0017!F2sK\u0006$XmU3sm\u0016\u0014X\t_2faRLwN\u001c\u000b\u0007\u00053\u0014YN!:\u0011\r\u0015\niE!4V\u0011!\u0011iNa5A\u0002\t}\u0017!A3\u0011\t\u0005u#\u0011]\u0005\u0005\u0005G\f9GA\u0005Fq\u000e,\u0007\u000f^5p]\"A\u00111\u000bBj\u0001\u0004\ty\u0003C\u0004\u0003j\u0002!IAa;\u0002\u0019\rdwn]3DQ\u0006tg.\u001a7\u0015\t\u0005E$Q\u001e\u0005\t\u0003#\u00139\u000f1\u0001\u0002\u0014\"9!\u0011\u001f\u0001\u0005B\t\u0015\u0015aE2sK\u0006$Xm\u0015;biN\u0014Vm\u001d9p]N,\u0007b\u0002B{\u0001\u0011%!q_\u0001\nEVLG\u000eZ*uCR$\u0002\"a\f\u0003z\nu8q\u0001\u0005\b\u0005w\u0014\u0019\u00101\u0001\u0013\u0003\u0011\u0019H/\u0019;\t\u0011\t}(1\u001fa\u0001\u0007\u0003\tQA^1mk\u0016\u00042!JB\u0002\u0013\r\u0019)\u0001\b\u0002\u0004\u0003:L\b\u0002\u0003Bd\u0005g\u0004\rA!/\t\u000f\u0005U\u0007\u0001\"\u0003\u0004\fQ9\u0001e!\u0004\u0004\u001e\r}\u0001\u0002CB\b\u0007\u0013\u0001\ra!\u0005\u0002\t\u0011\fG/\u0019\t\u0006K\rM1qC\u0005\u0004\u0007+a\"!B!se\u0006L\bcA\u0013\u0004\u001a%\u001911\u0004\u000f\u0003\t\tKH/\u001a\u0005\t\u00037\u001cI\u00011\u0001\u0002^\"A\u00111^B\u0005\u0001\u0004\ti\u000eC\u0004\u0004$\u0001!Ia!\n\u0002!\t,\u0018\u000e\u001c3HKR\u0014Vm\u001d9p]N,G\u0003CA\u0018\u0007O\u00199d!\u000f\t\u0011\r%2\u0011\u0005a\u0001\u0007W\t!a\u001c9\u0011\t\r521\u0007\t\u0004K\r=\u0012bAB\u00199\tYQI\\;nKJ\fG/[8o\u0013\u0011\u0019)da\f\u0003\u000bY\u000bG.^3\t\u000f\u0005\u00055\u0011\u0005a\u0001%!9!\u0011SB\u0011\u0001\u0004\u0001\u0003bBB\u001f\u0001\u0011%1qH\u0001\u0017EVLG\u000eZ*j]\u001edWmR3u%\u0016\u001c\bo\u001c8tKR1\u0011qFB!\u0007\u0007Bq!!!\u0004<\u0001\u0007!\u0003C\u0004\u0003\u0012\u000em\u0002\u0019\u0001\u0011\t\u000f\r\u001d\u0003\u0001\"\u0003\u0004J\u0005\u0019\"-^5mI\u001e+G\u000fS3bI\u0016\u0014()Z4j]RA\u0011qFB&\u0007\u001b\u001ay\u0005C\u0004\u0002\u0002\u000e\u0015\u0003\u0019\u0001\n\t\u000f\tE5Q\ta\u0001A!A1\u0011KB#\u0001\u0004\t\u00190\u0001\u0006fqR\u0014\u0018m\u00159bG\u0016Dqa!\u0016\u0001\t\u0013\u00199&\u0001\nxe&$XmR3u\u0011\u0016\fG-\u001a:ECR\fGCBA\u0018\u00073\u001aY\u0006\u0003\u0005\u0004\u0010\rM\u0003\u0019AB\t\u0011!\u0019ifa\u0015A\u0002\u0005=\u0012a\u00012vM\"91\u0011\r\u0001\u0005\n\r\r\u0014!E<sSR,w)\u001a;IK\u0006$WM]#oIR!\u0011qFB3\u0011!\u0019ifa\u0018A\u0002\u0005=\u0002bBB5\u0001\u0011%11N\u0001\"EVLG\u000eZ*j]\u001edWmR3u/&$\bNV3sg&|gNU3ta>t7/\u001a\u000b\u0007\u0003_\u0019iga\u001c\t\u000f\u0005\u00055q\ra\u0001%!9!\u0011SB4\u0001\u0004\u0001\u0003bBB:\u0001\u0011%1QO\u0001\u0014MJLWM\u001c3ms6\u000b\u00070\u00138u\u0007\",7m\u001b\u000b\u0007\u0003g\u001c9ha\u001f\t\u000f\re4\u0011\u000fa\u0001%\u00051a.^7cKJDqa! \u0004r\u0001\u0007!#A\u0004nKN\u001c\u0018mZ3\t\u000f\r\u0005\u0005\u0001\"\u0003\u0004\u0004\u0006\tb.^7fe&\u001cG*[7ji\u000eCWmY6\u0015\u0015\u0005M8QQBD\u0007\u0017\u001bi\tC\u0004\u0004z\r}\u0004\u0019\u0001\n\t\u0011\r%5q\u0010a\u0001\u0003;\f\u0001\"\\1y-\u0006dW/\u001a\u0005\b\u0007{\u001ay\b1\u0001\u0013\u0011!\u0019yia A\u0002\rE\u0015!\u00018\u0011\t\u0005u31S\u0005\u0005\u0007+\u000b9GA\u000bOk6\u0014WM\u001d$pe6\fG/\u0012=dKB$\u0018n\u001c8\t\u000f\r\u0005\u0005\u0001\"\u0003\u0004\u001aRA\u0011Q\\BN\u0007;\u001by\nC\u0004\u0004z\r]\u0005\u0019\u0001\n\t\u0011\r%5q\u0013a\u0001\u0003;Dqa! \u0004\u0018\u0002\u0007!\u0003")
public class MemcachedDecoder
extends AbstractProtocolDecoder<String, MemcachedValue>
implements ScalaObject {
    private final ScheduledExecutorService scheduler;
    private final NettyTransport transport;
    private boolean isStatsEnabled;
    private final AtomicLong incrMisses;
    private final AtomicLong incrHits;
    private final AtomicLong decrMisses;
    private final AtomicLong decrHits;
    private final AtomicLong replaceIfUnmodifiedMisses;
    private final AtomicLong replaceIfUnmodifiedHits;
    private final AtomicLong replaceIfUnmodifiedBadval;
    private final boolean isTrace;
    private final ByteArrayOutputStream byteBuffer;
    private volatile int bitmap$priv$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStatsEnabled() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.isStatsEnabled;
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.isStatsEnabled = this.cache().getConfiguration().isExposeJmxStatistics();
                this.bitmap$priv$0 |= 1;
            }
            return this.isStatsEnabled;
        }
    }

    private final AtomicLong incrMisses() {
        return this.incrMisses;
    }

    private final AtomicLong incrHits() {
        return this.incrHits;
    }

    private final AtomicLong decrMisses() {
        return this.decrMisses;
    }

    private final AtomicLong decrHits() {
        return this.decrHits;
    }

    private final AtomicLong replaceIfUnmodifiedMisses() {
        return this.replaceIfUnmodifiedMisses;
    }

    private final AtomicLong replaceIfUnmodifiedHits() {
        return this.replaceIfUnmodifiedHits;
    }

    private final AtomicLong replaceIfUnmodifiedBadval() {
        return this.replaceIfUnmodifiedBadval;
    }

    private boolean isTrace() {
        return this.isTrace;
    }

    private ByteArrayOutputStream byteBuffer() {
        return this.byteBuffer;
    }

    public RequestHeader createHeader() {
        return new RequestHeader();
    }

    public Option<Object> readHeader(ChannelBuffer buffer, RequestHeader header) {
        Enumeration.Value op;
        boolean endOfOp = TextProtocolUtil$.MODULE$.readElement(buffer, this.byteBuffer());
        String streamOp = TextProtocolUtil$.MODULE$.extractString(this.byteBuffer());
        Enumeration.Value value = op = RequestResolver$.MODULE$.toRequest(streamOp, endOfOp, buffer);
        Enumeration.Value value2 = Operation$.MODULE$.StatsRequest();
        if (!(value != null ? !value.equals(value2) : value2 != null) && !endOfOp) {
            String line = TextProtocolUtil$.MODULE$.readDiscardedLine(buffer).trim();
            if (line.isEmpty()) {
                endOfOp = true;
            } else {
                throw new StreamCorruptedException(new StringBuilder().append((Object)"Stats command does not accept arguments: ").append((Object)line).toString());
            }
        }
        Enumeration.Value value3 = op;
        Enumeration.Value value4 = MemcachedOperation$.MODULE$.VerbosityRequest();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            if (!endOfOp) {
                TextProtocolUtil$.MODULE$.skipLine(buffer);
            }
            throw new StreamCorruptedException("Memcached 'verbosity' command is unsupported");
        }
        header.op_$eq(op);
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    public Tuple2<String, Object> readKey(ChannelBuffer b) {
        boolean endOfOp = TextProtocolUtil$.MODULE$.readElement(b, this.byteBuffer());
        String k = TextProtocolUtil$.MODULE$.extractString(this.byteBuffer());
        this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, endOfOp, b);
        return new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    private Seq<String> readKeys(ChannelBuffer b) {
        return TextProtocolUtil$.MODULE$.readSplitLine(b);
    }

    public Object get(ChannelBuffer buffer$1) {
        Object object;
        Seq<String> keys = this.readKeys(buffer$1);
        if (keys.length() > 1) {
            scala.collection.mutable.HashMap map$1 = new scala.collection.mutable.HashMap();
            keys.foreach((Function1)new scala.Serializable(this, buffer$1, map$1){
                public static final long serialVersionUID;
                private final MemcachedDecoder $outer;
                private final ChannelBuffer buffer$1;
                private final scala.collection.mutable.HashMap map$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Object apply(String k) {
                    MemcachedValue v = (MemcachedValue)((Object)this.$outer.cache().get(this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, true, this.buffer$1)));
                    return v == null ? BoxedUnit.UNIT : this.map$1.$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)k).$minus$greater((Object)((Object)v)));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.buffer$1 = channelBuffer;
                    this.map$1 = hashMap;
                }
            });
            object = this.createMultiGetResponse((Map<String, MemcachedValue>)new HashMap().$plus$plus((GenTraversableOnce)map$1));
        } else {
            String key = (String)keys.apply(0);
            object = this.createGetResponse(key, (MemcachedValue)((Object)this.cache().get(this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(key, true, buffer$1))));
        }
        return object;
    }

    public final String org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(String k, boolean endOfOp, ChannelBuffer b) {
        if (k.length() > 250) {
            if (!endOfOp) {
                TextProtocolUtil$.MODULE$.skipLine(b);
            }
            throw new StreamCorruptedException("Key length over the 250 character limit");
        }
        return k;
    }

    public boolean readParameters(Channel ch, ChannelBuffer b$1) {
        MemcachedParameters memcachedParameters;
        Seq<String> args$1 = TextProtocolUtil$.MODULE$.readSplitLine(b$1);
        BooleanRef endOfOp$1 = new BooleanRef(false);
        if (args$1.isEmpty()) {
            memcachedParameters = null;
        } else {
            if (this.isTrace()) {
                this.trace((Function0)new scala.Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Operation parameters: %s";
                    }
                }, args$1);
            }
            memcachedParameters = this.liftedTree1$1(b$1, args$1, endOfOp$1);
        }
        this.params_$eq(memcachedParameters);
        return endOfOp$1.elem;
    }

    private MemcachedParameters readRemoveParameters(Seq<String> args) {
        int delayedDeleteTime = this.parseDelayedDeleteTime(args);
        boolean noReply = delayedDeleteTime == -1 ? this.parseNoReply(0, args) : false;
        return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", 0);
    }

    private MemcachedParameters readIncrDecrParameters(Seq<String> args) {
        String delta = (String)args.apply(0);
        return new MemcachedParameters(-1, -1, -1, -1L, this.parseNoReply(1, args), 0L, delta, 0);
    }

    private MemcachedParameters readFlushAllParameters(Seq<String> args) {
        NumberFormatException numberFormatException2;
        block2: {
            boolean noReplyFound = false;
            int exceptionResult1 = 0;
            try {
                exceptionResult1 = this.friendlyMaxIntCheck((String)args.apply(0), "Flush delay");
            }
            catch (NumberFormatException numberFormatException2) {
                if (!numberFormatException2.getMessage().contains("noreply")) break block2;
                noReplyFound = true;
                exceptionResult1 = 0;
            }
            int flushDelay = exceptionResult1;
            boolean noReply = noReplyFound ? true : this.parseNoReply(1, args);
            return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", flushDelay);
        }
        throw numberFormatException2;
    }

    private MemcachedParameters readStorageParameters(Seq<String> args, ChannelBuffer b) {
        int length;
        int streamLifespan;
        int index = 0;
        long flags = this.getFlags((String)args.apply(index));
        if (flags < 0L) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Flags cannot be negative: ").append((Object)BoxesRunTime.boxToLong((long)flags)).toString());
        }
        int lifespan = (streamLifespan = this.getLifespan((String)args.apply(++index))) <= 0 ? -1 : streamLifespan;
        if ((length = this.getLength((String)args.apply(++index))) < 0) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Negative bytes length provided: ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString());
        }
        Enumeration.Value value = this.header().op();
        Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
        Enumeration.Value value3 = value;
        long streamVersion = !(value2 != null ? !value2.equals(value3) : value3 != null) ? this.getVersion((String)args.apply(++index)) : -1L;
        boolean noReply = this.parseNoReply(++index, args);
        return new MemcachedParameters(length, lifespan, -1, streamVersion, noReply, flags, "", 0);
    }

    public void readValue(ChannelBuffer b) {
        b.readBytes(this.rawValue());
        TextProtocolUtil$.MODULE$.skipLine(b);
    }

    public MemcachedValue createValue(long nextVersion) {
        return new MemcachedValue(this.rawValue(), nextVersion, ((MemcachedParameters)this.params()).flags());
    }

    /*
     * WARNING - void declaration
     */
    private long getFlags(String flags) {
        void var2_2;
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        long exceptionResult2 = 0L;
        try {
            exceptionResult2 = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags");
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult2 = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags", numberFormatException);
        }
        return (long)var2_2;
    }

    private int getLifespan(String lifespan) {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return this.friendlyMaxIntCheck(lifespan, "Lifespan");
    }

    private int getLength(String length) {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return this.friendlyMaxIntCheck(length, "The number of bytes");
    }

    private long getVersion(String version) {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return Predef$.MODULE$.augmentString(version).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNoReply(int expectedIndex, Seq<String> args) {
        if (args.length() <= expectedIndex) return false;
        Object object = args.apply(expectedIndex);
        if ("noreply" != null) {
            if (!"noreply".equals(object)) throw new StreamCorruptedException("Unable to parse noreply optional argument");
            return true;
        }
        if (object == null) return true;
        throw new StreamCorruptedException("Unable to parse noreply optional argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDelayedDeleteTime(Seq<String> args) {
        int n;
        if (args.length() <= 0) return 0;
        int exceptionResult3 = 0;
        try {
            n = exceptionResult3 = Predef$.MODULE$.augmentString((String)args.apply(0)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public Cache<String, MemcachedValue> getCache() {
        return this.cache();
    }

    public Object customDecodeHeader(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        value = this.header().op();
                        Enumeration.Value value2 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        object = this.flushAll(buffer, ch, false);
                        break block3;
                    }
                    Enumeration.Value value4 = MemcachedOperation$.MODULE$.VersionRequest();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    java.lang.StringBuilder ret = new java.lang.StringBuilder().append("VERSION ").append(Version.VERSION).append(TextProtocolUtil$.MODULE$.CRLF());
                    object = this.writeResponse(ch, ret);
                    break block3;
                }
                Enumeration.Value value6 = MemcachedOperation$.MODULE$.QuitRequest();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                object = this.closeChannel(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeKey(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block5: {
            Object object;
            block4: {
                block3: {
                    block2: {
                        value = this.header().op();
                        Enumeration.Value value2 = MemcachedOperation$.MODULE$.AppendRequest();
                        Enumeration.Value value3 = value;
                        if (!(value2 == null ? value3 != null : !value2.equals(value3))) break block2;
                        Enumeration.Value value4 = MemcachedOperation$.MODULE$.PrependRequest();
                        Enumeration.Value value5 = value;
                        if (!(value4 == null ? value5 != null : !value4.equals(value5))) break block2;
                        Enumeration.Value value6 = MemcachedOperation$.MODULE$.IncrementRequest();
                        Enumeration.Value value7 = value;
                        if (!(value6 == null ? value7 != null : !value6.equals(value7))) break block2;
                        Enumeration.Value value8 = MemcachedOperation$.MODULE$.DecrementRequest();
                        Enumeration.Value value9 = value;
                        if (value8 != null ? !value8.equals(value9) : value9 != null) break block3;
                    }
                    this.key_$eq(this.readKey(buffer)._1());
                    object = this.checkpointTo(DecoderState.DECODE_PARAMETERS);
                    break block4;
                }
                Enumeration.Value value10 = MemcachedOperation$.MODULE$.FlushAllRequest();
                Enumeration.Value value11 = value;
                if (value10 != null ? !value10.equals(value11) : value11 != null) break block5;
                object = this.flushAll(buffer, ch, true);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeValue(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block15: {
            Object object;
            block13: {
                block14: {
                    block7: {
                        Enumeration.Value value2;
                        block12: {
                            Object object2;
                            block9: {
                                byte[] byArray;
                                MemcachedValue prev;
                                block11: {
                                    block10: {
                                        block8: {
                                            block6: {
                                                Enumeration.Value op;
                                                value = op = this.header().op();
                                                Enumeration.Value value3 = MemcachedOperation$.MODULE$.AppendRequest();
                                                Enumeration.Value value4 = value;
                                                if (!(value3 == null ? value4 != null : !value3.equals(value4))) break block6;
                                                Enumeration.Value value5 = MemcachedOperation$.MODULE$.PrependRequest();
                                                Enumeration.Value value6 = value;
                                                if (value5 != null ? !value5.equals(value6) : value6 != null) break block7;
                                            }
                                            this.readValue(buffer);
                                            prev = (MemcachedValue)((Object)this.cache().get(this.key()));
                                            if (prev != null) break block8;
                                            object2 = ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_STORED();
                                            break block9;
                                        }
                                        value2 = this.header().op();
                                        Enumeration.Value value7 = MemcachedOperation$.MODULE$.AppendRequest();
                                        Enumeration.Value value8 = value2;
                                        if (value7 != null ? !value7.equals(value8) : value8 != null) break block10;
                                        byArray = TextProtocolUtil$.MODULE$.concat(prev.data(), this.rawValue());
                                        break block11;
                                    }
                                    Enumeration.Value value9 = MemcachedOperation$.MODULE$.PrependRequest();
                                    Enumeration.Value value10 = value2;
                                    if (value9 != null ? !value9.equals(value10) : value10 != null) break block12;
                                    byArray = TextProtocolUtil$.MODULE$.concat(this.rawValue(), prev.data());
                                }
                                byte[] concatenated = byArray;
                                MemcachedValue next = this.createValue(concatenated, this.generateVersion(this.cache()), ((MemcachedParameters)this.params()).flags());
                                boolean replaced = this.cache().replace(this.key(), prev, next);
                                object2 = replaced ? (Object)(((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.STORED()) : (Object)(((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_STORED());
                            }
                            byte[] ret = object2;
                            object = this.writeResponse(ch, ret);
                            break block13;
                        }
                        throw new MatchError((Object)value2);
                    }
                    Enumeration.Value value11 = MemcachedOperation$.MODULE$.IncrementRequest();
                    Enumeration.Value value12 = value;
                    if (!(value11 == null ? value12 != null : !value11.equals(value12))) break block14;
                    Enumeration.Value value13 = MemcachedOperation$.MODULE$.DecrementRequest();
                    Enumeration.Value value14 = value;
                    if (value13 != null ? !value13.equals(value14) : value14 != null) break block15;
                }
                object = this.incrDecr(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    private Object incrDecr(Channel ch) {
        Enumeration.Value value;
        block9: {
            BigInt prevCounter;
            block10: {
                Object object;
                block6: {
                    Object object2;
                    Enumeration.Value op;
                    MemcachedValue prev;
                    block8: {
                        BigInt delta;
                        block7: {
                            block5: {
                                Object object3;
                                prev = (MemcachedValue)((Object)this.cache().get(this.key()));
                                op = this.header().op();
                                if (prev != null) break block5;
                                if (this.isStatsEnabled()) {
                                    Enumeration.Value value2 = op;
                                    Enumeration.Value value3 = MemcachedOperation$.MODULE$.IncrementRequest();
                                    object3 = BoxesRunTime.boxToLong((long)(!(value2 != null ? !value2.equals(value3) : value3 != null) ? this.incrMisses().incrementAndGet() : this.decrMisses().incrementAndGet()));
                                } else {
                                    object3 = BoxedUnit.UNIT;
                                }
                                object = ((MemcachedParameters)this.params()).noReply() ? null : (Serializable)TextProtocolUtil$.MODULE$.NOT_FOUND();
                                break block6;
                            }
                            prevCounter = package$.MODULE$.BigInt().apply(new String(prev.data()));
                            delta = this.validateDelta(((MemcachedParameters)this.params()).delta());
                            value = op;
                            Enumeration.Value value4 = MemcachedOperation$.MODULE$.IncrementRequest();
                            Enumeration.Value value5 = value;
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block7;
                            BigInt candidateCounter = prevCounter.$plus(delta);
                            object2 = candidateCounter.$greater(TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG()) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                            break block8;
                        }
                        Enumeration.Value value6 = MemcachedOperation$.MODULE$.DecrementRequest();
                        Enumeration.Value value7 = value;
                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block9;
                        BigInt candidateCounter = prevCounter.$minus(delta);
                        object2 = candidateCounter.$less(BigInt$.MODULE$.int2bigInt(0)) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                    }
                    Object newCounter = object2;
                    MemcachedValue next = this.createValue(newCounter.toString().getBytes(), this.generateVersion(this.cache()), ((MemcachedParameters)this.params()).flags());
                    boolean replaced = this.cache().replace(this.key(), prev, next);
                    if (replaced) {
                        Object object4;
                        if (this.isStatsEnabled()) {
                            Enumeration.Value value8 = op;
                            Enumeration.Value value9 = MemcachedOperation$.MODULE$.IncrementRequest();
                            object4 = BoxesRunTime.boxToLong((long)(!(value8 != null ? !value8.equals(value9) : value9 != null) ? this.incrHits().incrementAndGet() : this.decrHits().incrementAndGet()));
                        } else {
                            object4 = BoxedUnit.UNIT;
                        }
                        object = ((MemcachedParameters)this.params()).noReply() ? null : new StringBuilder().append((Object)new String(next.data())).append((Object)TextProtocolUtil$.MODULE$.CRLF()).toString();
                    }
                    break block10;
                }
                Serializable ret = object;
                return this.writeResponse(ch, ret);
            }
            throw new CacheException(new StringBuilder().append((Object)"Value modified since we retrieved from the cache, old value was ").append((Object)prevCounter).toString());
        }
        throw new MatchError((Object)value);
    }

    private Object flushAll(ChannelBuffer b, Channel ch, boolean isReadParams) {
        Object object = isReadParams ? BoxesRunTime.boxToBoolean((boolean)this.readParameters(ch, b)) : BoxedUnit.UNIT;
        scala.Serializable flushFunction = new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(AdvancedCache<String, MemcachedValue> cache) {
                cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_STORE}).clear();
            }
        };
        int flushDelay = this.params() == null ? 0 : ((MemcachedParameters)this.params()).flushDelay();
        ScheduledFuture<?> scheduledFuture = flushDelay == 0 ? flushFunction.apply((Object)this.cache().getAdvancedCache()) : this.scheduler.schedule(new DelayedFlushAll((Cache<String, MemcachedValue>)this.cache(), (Function1<AdvancedCache<String, MemcachedValue>, BoxedUnit>)flushFunction), this.toMillis(flushDelay), TimeUnit.MILLISECONDS);
        byte[] ret = (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.OK());
        return this.writeResponse(ch, ret);
    }

    /*
     * WARNING - void declaration
     */
    private BigInt validateDelta(String delta) {
        void var2_2;
        BigInt bigIntDelta = package$.MODULE$.BigInt().apply(delta);
        if (bigIntDelta.$greater(TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta sent (").append((Object)delta).append((Object)") exceeds unsigned limit (").append((Object)TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG()).append((Object)")").toString());
        }
        if (bigIntDelta.$less(TextProtocolUtil$.MODULE$.MIN_UNSIGNED())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta cannot be negative: ").append((Object)delta).toString());
        }
        return var2_2;
    }

    public Object createSuccessResponse(MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedHits().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.RemoveRequest();
            Enumeration.Value value5 = value;
            byArray = !(value4 != null ? !value4.equals(value5) : value5 != null) ? TextProtocolUtil$.MODULE$.DELETED() : TextProtocolUtil$.MODULE$.STORED();
        }
        return byArray;
    }

    public Object createNotExecutedResponse(MemcachedValue prev) {
        byte[] byArray;
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedBadval().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value5 = value;
            byArray = !(value4 != null ? !value4.equals(value5) : value5 != null) ? TextProtocolUtil$.MODULE$.EXISTS() : TextProtocolUtil$.MODULE$.NOT_STORED();
        }
        return byArray;
    }

    public Object createNotExistResponse() {
        Object object;
        if (this.isStatsEnabled()) {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedMisses().incrementAndGet()) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        return (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_FOUND());
    }

    public Object createGetResponse(String k, MemcachedValue v) {
        Enumeration.Value value;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        if (v != null) break block2;
                        object = TextProtocolUtil$.MODULE$.END();
                        break block3;
                    }
                    value = this.header().op();
                    Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block4;
                    object = this.buildSingleGetResponse(k, v);
                    break block3;
                }
                Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block5;
                object = this.buildSingleGetWithVersionResponse(k, v);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object createMultiGetResponse(Map<String, MemcachedValue> pairs) {
        Enumeration.Value value;
        block3: {
            Enumeration.Value op$1;
            ListBuffer elements$1;
            block2: {
                elements$1 = new ListBuffer();
                value = op$1 = this.header().op();
                Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
                Enumeration.Value value3 = value;
                if (!(value2 == null ? value3 != null : !value2.equals(value3))) break block2;
                Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block3;
            }
            ((IterableLike)pairs.filter((Function1)new scala.Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<String, MemcachedValue> tuple2) {
                    Tuple2<String, MemcachedValue> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new scala.Serializable(this, elements$1, op$1){
                public static final long serialVersionUID;
                private final MemcachedDecoder $outer;
                private final ListBuffer elements$1;
                private final Enumeration.Value op$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final ListBuffer<ChannelBuffer> apply(Tuple2<String, MemcachedValue> tuple2) {
                    Tuple2<String, MemcachedValue> tuple22 = tuple2;
                    if (tuple22 != null) {
                        return this.elements$1.$plus$eq((Object)this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(this.op$1, (String)tuple22._1(), (MemcachedValue)((Object)tuple22._2())));
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.elements$1 = listBuffer;
                    this.op$1 = value;
                }
            });
            elements$1.$plus$eq((Object)ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{TextProtocolUtil$.MODULE$.END()})));
            return elements$1.toList();
        }
        throw new MatchError((Object)value);
    }

    public Object createErrorResponse(Throwable t) {
        Object object;
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        Throwable throwable = t;
        if (throwable instanceof MemcachedException) {
            MemcachedException memcachedException = (MemcachedException)throwable;
            MemcachedException m = memcachedException;
            Throwable throwable2 = m.getCause();
            if (throwable2 instanceof UnknownOperationException) {
                this.logExceptionReported((Throwable)((UnknownOperationException)throwable2));
                object = TextProtocolUtil$.MODULE$.ERROR();
            } else if (throwable2 instanceof ClosedChannelException) {
                this.logExceptionReported((ClosedChannelException)throwable2);
                object = null;
            } else {
                object = throwable2 instanceof IOException ? this.logAndCreateErrorMessage(sb, m) : (throwable2 instanceof NumberFormatException ? this.logAndCreateErrorMessage(sb, m) : (throwable2 instanceof IllegalStateException ? this.logAndCreateErrorMessage(sb, m) : sb.append(m.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF())));
            }
        } else if (throwable instanceof ClosedChannelException) {
            this.logExceptionReported((ClosedChannelException)throwable);
            object = null;
        } else {
            object = sb.append(TextProtocolUtil$.MODULE$.SERVER_ERROR()).append(t.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
        }
        return object;
    }

    private java.lang.StringBuilder logAndCreateErrorMessage(java.lang.StringBuilder sb, MemcachedException m) {
        this.logExceptionReported(m.getCause());
        return sb.append(m.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
    }

    public Tuple2<MemcachedException, Object> createServerException(Exception e, ChannelBuffer b) {
        Tuple2 tuple2;
        Exception exception = e;
        if (exception instanceof IOException) {
            IOException iOException;
            IOException i = iOException = (IOException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.CLIENT_ERROR_BAD_FORMAT()).append((Object)i.getMessage()).toString(), i), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (exception instanceof NumberFormatException) {
            NumberFormatException numberFormatException;
            NumberFormatException n = numberFormatException = (NumberFormatException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.CLIENT_ERROR_BAD_FORMAT()).append((Object)n.getMessage()).toString(), n), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.SERVER_ERROR()).append((Object)e).toString(), e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple2;
    }

    private Object closeChannel(Channel ch) {
        ch.close();
        return null;
    }

    public Object createStatsResponse() {
        Stats stats = this.cache().getAdvancedCache().getStats();
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ChannelBuffer[]{this.buildStat("pid", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("time", BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())), sb), this.buildStat("version", this.cache().getVersion(), sb), this.buildStat("pointer_size", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_user", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_system", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_items", BoxesRunTime.boxToInteger((int)stats.getCurrentNumberOfEntries()), sb), this.buildStat("total_items", BoxesRunTime.boxToLong((long)stats.getTotalNumberOfEntries()), sb), this.buildStat("bytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("total_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("connection_structures", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("cmd_get", BoxesRunTime.boxToLong((long)stats.getRetrievals()), sb), this.buildStat("cmd_set", BoxesRunTime.boxToLong((long)stats.getStores()), sb), this.buildStat("get_hits", BoxesRunTime.boxToLong((long)stats.getHits()), sb), this.buildStat("get_misses", BoxesRunTime.boxToLong((long)stats.getMisses()), sb), this.buildStat("delete_misses", BoxesRunTime.boxToLong((long)stats.getRemoveMisses()), sb), this.buildStat("delete_hits", BoxesRunTime.boxToLong((long)stats.getRemoveHits()), sb), this.buildStat("incr_misses", this.incrMisses(), sb), this.buildStat("incr_hits", this.incrHits(), sb), this.buildStat("decr_misses", this.decrMisses(), sb), this.buildStat("decr_hits", this.decrHits(), sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses(), sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits(), sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval(), sb), this.buildStat("auth_cmds", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("auth_errors", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("evictions", BoxesRunTime.boxToLong((long)stats.getEvictions()), sb), this.buildStat("bytes_read", this.transport.getTotalBytesRead(), sb), this.buildStat("bytes_written", this.transport.getTotalBytesWritten(), sb), this.buildStat("limit_maxbytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("threads", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("conn_yields", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("reclaimed", BoxesRunTime.boxToInteger((int)0), sb), ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{TextProtocolUtil$.MODULE$.END()}))}));
    }

    private ChannelBuffer buildStat(String stat, Object value, java.lang.StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append(TextProtocolUtil$.MODULE$.CRLF());
        ChannelBuffer buffer = ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sb.toString().getBytes()}));
        sb.setLength(0);
        return buffer;
    }

    private MemcachedValue createValue(byte[] data, long nextVersion, long flags) {
        return new MemcachedValue(data, nextVersion, flags);
    }

    public final ChannelBuffer org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(Enumeration.Value op, String k, MemcachedValue v) {
        ChannelBuffer buf = this.buildGetHeaderBegin(k, v, 0);
        return this.writeGetHeaderData(v.data(), buf);
    }

    private ChannelBuffer buildSingleGetResponse(String k, MemcachedValue v) {
        ChannelBuffer buf = this.buildGetHeaderBegin(k, v, TextProtocolUtil$.MODULE$.END_SIZE());
        this.writeGetHeaderData(v.data(), buf);
        return this.writeGetHeaderEnd(buf);
    }

    private ChannelBuffer buildGetHeaderBegin(String k, MemcachedValue v, int extraSpace) {
        byte[] data = v.data();
        byte[] dataSize = Integer.valueOf(data.length).toString().getBytes();
        byte[] key = k.getBytes();
        byte[] flags = v.flags() != 0L ? Long.valueOf(v.flags()).toString().getBytes() : TextProtocolUtil$.MODULE$.ZERO();
        int flagsSize = flags.length;
        ChannelBuffer buf = ExtendedChannelBuffer$.MODULE$.buffer(TextProtocolUtil$.MODULE$.VALUE_SIZE() + key.length + data.length + flagsSize + dataSize.length + 6 + extraSpace);
        buf.writeBytes(TextProtocolUtil$.MODULE$.VALUE());
        buf.writeBytes(key);
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(flags);
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(dataSize);
        return buf;
    }

    private ChannelBuffer writeGetHeaderData(byte[] data, ChannelBuffer buf) {
        buf.writeBytes(TextProtocolUtil$.MODULE$.CRLFBytes());
        buf.writeBytes(data);
        buf.writeBytes(TextProtocolUtil$.MODULE$.CRLFBytes());
        return buf;
    }

    private ChannelBuffer writeGetHeaderEnd(ChannelBuffer buf) {
        buf.writeBytes(TextProtocolUtil$.MODULE$.END());
        return buf;
    }

    private ChannelBuffer buildSingleGetWithVersionResponse(String k, MemcachedValue v) {
        byte[] version = ((Object)BoxesRunTime.boxToLong((long)v.version())).toString().getBytes();
        ChannelBuffer buf = this.buildGetHeaderBegin(k, v, version.length + 1 + TextProtocolUtil$.MODULE$.END_SIZE());
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(version);
        this.writeGetHeaderData(v.data(), buf);
        return this.writeGetHeaderEnd(buf);
    }

    /*
     * WARNING - void declaration
     */
    private int friendlyMaxIntCheck(String number, String message) {
        void var3_3;
        int exceptionResult4 = 0;
        try {
            exceptionResult4 = Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult4 = this.numericLimitCheck(number, Integer.MAX_VALUE, message, numberFormatException);
        }
        return (int)var3_3;
    }

    private int numericLimitCheck(String number, long maxValue, String message, NumberFormatException n) {
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        throw n;
    }

    private long numericLimitCheck(String number, long maxValue, String message) {
        long numeric = Long.parseLong(number);
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        return numeric;
    }

    /*
     * Unable to fully structure code
     */
    private final MemcachedParameters liftedTree1$1(ChannelBuffer var1_1, Seq var2_2, BooleanRef var3_3) {
        exceptionResult5 = null;
        try {
            block5: {
                block6: {
                    block4: {
                        var5_5 = this.header().op();
                        v0 = Operation$.MODULE$.PutRequest();
                        var6_6 = var5_5;
                        if (v0 != null ? v0.equals(var6_6) == false : var6_6 != null) break block4;
                        v1 = this.readStorageParameters((Seq<String>)var2_2, var1_1);
                        break block5;
                    }
                    v2 = Operation$.MODULE$.RemoveRequest();
                    var7_7 = var5_5;
                    if (v2 != null ? v2.equals(var7_7) == false : var7_7 != null) break block6;
                    v1 = this.readRemoveParameters((Seq<String>)var2_2);
                    break block5;
                }
                v3 = MemcachedOperation$.MODULE$.IncrementRequest();
                var8_8 = var5_5;
                if (!(v3 == null ? var8_8 != null : v3.equals(var8_8) == false)) ** GOTO lbl-1000
                v4 = MemcachedOperation$.MODULE$.DecrementRequest();
                var9_9 = var5_5;
                if (!(v4 != null ? v4.equals(var9_9) == false : var9_9 != null)) lbl-1000:
                // 2 sources

                {
                    var3_3.elem = true;
                    v1 = this.readIncrDecrParameters((Seq<String>)var2_2);
                } else {
                    v5 = MemcachedOperation$.MODULE$.FlushAllRequest();
                    var10_10 = var5_5;
                    v1 = !(v5 != null ? v5.equals(var10_10) == false : var10_10 != null) ? this.readFlushAllParameters((Seq<String>)var2_2) : this.readStorageParameters((Seq<String>)var2_2, var1_1);
                }
            }
            exceptionResult5 = v1;
            return exceptionResult5;
        }
        catch (ArrayIndexOutOfBoundsException v6) {
            throw new IOException(new StringBuilder().append((Object)"Missing content in command line ").append((Object)var2_2).toString());
        }
    }

    public MemcachedDecoder(Cache<String, MemcachedValue> memcachedCache, ScheduledExecutorService scheduler, NettyTransport transport) {
        this.scheduler = scheduler;
        this.transport = transport;
        super(transport);
        this.cache_$eq(memcachedCache);
        this.incrMisses = new AtomicLong(0L);
        this.incrHits = new AtomicLong(0L);
        this.decrMisses = new AtomicLong(0L);
        this.decrHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedMisses = new AtomicLong(0L);
        this.replaceIfUnmodifiedHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedBadval = new AtomicLong(0L);
        this.isTrace = this.isTraceEnabled();
        this.byteBuffer = new ByteArrayOutputStream();
    }
}

