/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.context.Flag;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.DecoderState;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.RequestHeader;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ExtendedChannelBuffer$;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.memcached.DelayedFlushAll;
import org.infinispan.server.memcached.MemcachedException;
import org.infinispan.server.memcached.MemcachedOperation$;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.MemcachedValue;
import org.infinispan.server.memcached.RequestResolver$;
import org.infinispan.server.memcached.TextProtocolUtil$;
import org.infinispan.stats.Stats;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rme\u0001B\u0001\u0003\u0001-\u0011\u0001#T3nG\u0006\u001c\u0007.\u001a3EK\u000e|G-\u001a:\u000b\u0005\r!\u0011!C7f[\u000e\f7\r[3e\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000f!\t!\"\u001b8gS:L7\u000f]1o\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\u0011i\u0001C\u0005\u0011\u000e\u00039Q!a\u0004\u0003\u0002\t\r|'/Z\u0005\u0003#9\u0011q#\u00112tiJ\f7\r\u001e)s_R|7m\u001c7EK\u000e|G-\u001a:\u0011\u0005MibB\u0001\u000b\u001b\u001d\t)\u0002$D\u0001\u0017\u0015\t9\"\"\u0001\u0004=e>|GOP\u0005\u00023\u0005)1oY1mC&\u00111\u0004H\u0001\u0007!J,G-\u001a4\u000b\u0003eI!AH\u0010\u0003\rM#(/\u001b8h\u0015\tYB\u0004\u0005\u0002\"E5\t!!\u0003\u0002$\u0005\tqQ*Z7dC\u000eDW\r\u001a,bYV,\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u001d5,WnY1dQ\u0016$7)Y2iKB!q\u0005\u000b\n!\u001b\u00051\u0011BA\u0015\u0007\u0005\u0015\u0019\u0015m\u00195f\u0011!Y\u0003A!A!\u0002\u0013a\u0013!C:dQ\u0016$W\u000f\\3s!\tiC'D\u0001/\u0015\ty\u0003'\u0001\u0006d_:\u001cWO\u001d:f]RT!!\r\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0002g\u0005!!.\u0019<b\u0013\t)dF\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016D\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\niJ\fgn\u001d9peR\u0004\"!O\u001e\u000e\u0003iR!a\u000e\b\n\u0005qR$A\u0004(fiRLHK]1ogB|'\u000f\u001e\u0005\u0006}\u0001!\taP\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0001\u000b%i\u0011\t\u0003C\u0001AQ!J\u001fA\u0002\u0019BQaK\u001fA\u00021BQaN\u001fA\u0002a*A!\u0012\u0001\u0001\r\n\u00112+^5uC\ndW\rU1sC6,G/\u001a:t!\t\ts)\u0003\u0002I\u0005\t\u0019R*Z7dC\u000eDW\r\u001a)be\u0006lW\r^3sg\u0016!!\n\u0001\u0001L\u00059\u0019V/\u001b;bE2,\u0007*Z1eKJ\u0004\"!\u0004'\n\u00055s!!\u0004*fcV,7\u000f\u001e%fC\u0012,'\u000f\u0003\u0005P\u0001!\u0015\r\u0011\"\u0003Q\u00039I7o\u0015;biN,e.\u00192mK\u0012,\u0012!\u0015\t\u0003%Nk\u0011\u0001H\u0005\u0003)r\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005W\u0001!\u0005\t\u0015)\u0003R\u0003=I7o\u0015;biN,e.\u00192mK\u0012\u0004\u0003b\u0002-\u0001\u0005\u0004%i!W\u0001\u000bS:\u001c'/T5tg\u0016\u001cX#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005us\u0013AB1u_6L7-\u0003\u0002`9\nQ\u0011\t^8nS\u000eduN\\4\t\r\u0005\u0004\u0001\u0015!\u0004[\u0003-Ign\u0019:NSN\u001cXm\u001d\u0011\t\u000f\r\u0004!\u0019!C\u00073\u0006A\u0011N\\2s\u0011&$8\u000f\u0003\u0004f\u0001\u0001\u0006iAW\u0001\nS:\u001c'\u000fS5ug\u0002Bqa\u001a\u0001C\u0002\u00135\u0011,\u0001\u0006eK\u000e\u0014X*[:tKNDa!\u001b\u0001!\u0002\u001bQ\u0016a\u00033fGJl\u0015n]:fg\u0002Bqa\u001b\u0001C\u0002\u00135\u0011,\u0001\u0005eK\u000e\u0014\b*\u001b;t\u0011\u0019i\u0007\u0001)A\u00075\u0006IA-Z2s\u0011&$8\u000f\t\u0005\b_\u0002\u0011\r\u0011\"\u0004Z\u0003e\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u001b&\u001c8/Z:\t\rE\u0004\u0001\u0015!\u0004[\u0003i\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u001b&\u001c8/Z:!\u0011\u001d\u0019\bA1A\u0005\u000ee\u000bqC]3qY\u0006\u001cW-\u00134V]6|G-\u001b4jK\u0012D\u0015\u000e^:\t\rU\u0004\u0001\u0015!\u0004[\u0003a\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0011&$8\u000f\t\u0005\bo\u0002\u0011\r\u0011\"\u0004Z\u0003e\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0005\u0006$g/\u00197\t\re\u0004\u0001\u0015!\u0004[\u0003i\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0005\u0006$g/\u00197!\u0011\u001dY\bA1A\u0005\nA\u000bq![:Ue\u0006\u001cW\r\u0003\u0004~\u0001\u0001\u0006I!U\u0001\tSN$&/Y2fA!Aq\u0010\u0001b\u0001\n\u0013\t\t!\u0001\u0006csR,')\u001e4gKJ,\"!a\u0001\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u00033\u0003\tIw.\u0003\u0003\u0002\u000e\u0005\u001d!!\u0006\"zi\u0016\f%O]1z\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\u0004\u0005Y!-\u001f;f\u0005V4g-\u001a:!\u0011\u001d\t)\u0002\u0001C!\u0003/\tAb\u0019:fCR,\u0007*Z1eKJ,\u0012a\u0013\u0005\b\u00037\u0001A\u0011IA\u000f\u0003)\u0011X-\u00193IK\u0006$WM\u001d\u000b\u0007\u0003?\t)#a\u000f\u0011\tI\u000b\t#U\u0005\u0004\u0003Ga\"AB(qi&|g\u000e\u0003\u0005\u0002(\u0005e\u0001\u0019AA\u0015\u0003\u0019\u0011WO\u001a4feB!\u00111FA\u001c\u001b\t\tiC\u0003\u0003\u0002(\u0005=\"\u0002BA\u0019\u0003g\tQA\\3uifT1!!\u000e\t\u0003\u0015Q'm\\:t\u0013\u0011\tI$!\f\u0003\u001b\rC\u0017M\u001c8fY\n+hMZ3s\u0011\u001d\ti$!\u0007A\u0002-\u000ba\u0001[3bI\u0016\u0014\bbBA!\u0001\u0011\u0005\u00131I\u0001\be\u0016\fGmS3z)\u0011\t)%a\u0013\u0011\u000bI\u000b9EE)\n\u0007\u0005%CD\u0001\u0004UkBdWM\r\u0005\t\u0003\u001b\ny\u00041\u0001\u0002*\u0005\t!\rC\u0004\u0002R\u0001!I!a\u0015\u0002\u0011I,\u0017\rZ&fsN$B!!\u0016\u0002dA)\u0011qKA/%9\u0019A#!\u0017\n\u0007\u0005mC$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0013\u0011\r\u0002\u0004'\u0016\f(bAA.9!A\u0011QJA(\u0001\u0004\tI\u0003C\u0004\u0002h\u0001!\t&!\u001b\u0002\u0007\u001d,G\u000f\u0006\u0003\u0002l\u0005E\u0004c\u0001*\u0002n%\u0019\u0011q\u000e\u000f\u0003\r\u0005s\u0017PU3g\u0011!\t9#!\u001aA\u0002\u0005%\u0002bBA;\u0001\u0011%\u0011qO\u0001\u000fG\",7m[&fs2+gn\u001a;i)\u001d\u0011\u0012\u0011PA?\u0003\u0003Cq!a\u001f\u0002t\u0001\u0007!#A\u0001l\u0011\u001d\ty(a\u001dA\u0002E\u000bq!\u001a8e\u001f\u001a|\u0005\u000f\u0003\u0005\u0002N\u0005M\u0004\u0019AA\u0015\u0011\u001d\t)\t\u0001C!\u0003\u000f\u000baB]3bIB\u000b'/Y7fi\u0016\u00148\u000fF\u0003R\u0003\u0013\u000bI\n\u0003\u0005\u0002\f\u0006\r\u0005\u0019AAG\u0003\t\u0019\u0007\u000e\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\u0011\t\u0019*a\f\u0002\u000f\rD\u0017M\u001c8fY&!\u0011qSAI\u0005\u001d\u0019\u0005.\u00198oK2D\u0001\"!\u0014\u0002\u0004\u0002\u0007\u0011\u0011\u0006\u0005\b\u0003;\u0003A\u0011BAP\u0003Q\u0011X-\u00193SK6|g/\u001a)be\u0006lW\r^3sgR\u0019a)!)\t\u0011\u0005\r\u00161\u0014a\u0001\u0003+\nA!\u0019:hg\"9\u0011q\u0015\u0001\u0005\n\u0005%\u0016A\u0006:fC\u0012Len\u0019:EK\u000e\u0014\b+\u0019:b[\u0016$XM]:\u0015\u0007\u0019\u000bY\u000b\u0003\u0005\u0002$\u0006\u0015\u0006\u0019AA+\u0011\u001d\ty\u000b\u0001C\u0005\u0003c\u000baC]3bI\u001acWo\u001d5BY2\u0004\u0016M]1nKR,'o\u001d\u000b\u0004\r\u0006M\u0006\u0002CAR\u0003[\u0003\r!!\u0016\t\u000f\u0005]\u0006\u0001\"\u0003\u0002:\u0006)\"/Z1e'R|'/Y4f!\u0006\u0014\u0018-\\3uKJ\u001cH#\u0002$\u0002<\u0006u\u0006\u0002CAR\u0003k\u0003\r!!\u0016\t\u0011\u00055\u0013Q\u0017a\u0001\u0003SAq!!1\u0001\t#\n\u0019-A\u0005sK\u0006$g+\u00197vKR!\u0011QYAf!\r\u0011\u0016qY\u0005\u0004\u0003\u0013d\"\u0001B+oSRD\u0001\"!\u0014\u0002@\u0002\u0007\u0011\u0011\u0006\u0005\b\u0003\u001f\u0004A\u0011IAi\u0003-\u0019'/Z1uKZ\u000bG.^3\u0015\u0007\u0001\n\u0019\u000e\u0003\u0005\u0002V\u00065\u0007\u0019AAl\u0003-qW\r\u001f;WKJ\u001c\u0018n\u001c8\u0011\u0007I\u000bI.C\u0002\u0002\\r\u0011A\u0001T8oO\"9\u0011q\u001c\u0001\u0005\n\u0005\u0005\u0018\u0001C4fi\u001ac\u0017mZ:\u0015\t\u0005]\u00171\u001d\u0005\b\u0003K\fi\u000e1\u0001\u0013\u0003\u00151G.Y4t\u0011\u001d\tI\u000f\u0001C\u0005\u0003W\f1bZ3u\u0019&4Wm\u001d9b]R!\u0011Q^Az!\r\u0011\u0016q^\u0005\u0004\u0003cd\"aA%oi\"9\u0011Q_At\u0001\u0004\u0011\u0012\u0001\u00037jM\u0016\u001c\b/\u00198\t\u000f\u0005e\b\u0001\"\u0003\u0002|\u0006Iq-\u001a;MK:<G\u000f\u001b\u000b\u0005\u0003[\fi\u0010C\u0004\u0002\u0000\u0006]\b\u0019\u0001\n\u0002\r1,gn\u001a;i\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000b\t!bZ3u-\u0016\u00148/[8o)\u0011\t9Na\u0002\t\u000f\t%!\u0011\u0001a\u0001%\u00059a/\u001a:tS>t\u0007b\u0002B\u0007\u0001\u0011%!qB\u0001\ra\u0006\u00148/\u001a(p%\u0016\u0004H.\u001f\u000b\u0006#\nE!Q\u0003\u0005\t\u0005'\u0011Y\u00011\u0001\u0002n\u0006iQ\r\u001f9fGR,G-\u00138eKbD\u0001\"a)\u0003\f\u0001\u0007\u0011Q\u000b\u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0003Y\u0001\u0018M]:f\t\u0016d\u0017-_3e\t\u0016dW\r^3US6,G\u0003BAw\u0005;A\u0001\"a)\u0003\u0018\u0001\u0007\u0011Q\u000b\u0005\b\u0005C\u0001A\u0011\tB\u0012\u0003!9W\r^\"bG\",W#\u0001\u0014\t\u000f\t\u001d\u0002\u0001\"\u0015\u0003*\u0005\u00112-^:u_6$UmY8eK\"+\u0017\rZ3s)\u0019\tYGa\u000b\u0003.!A\u00111\u0012B\u0013\u0001\u0004\ti\t\u0003\u0005\u0002(\t\u0015\u0002\u0019AA\u0015\u0011\u001d\u0011\t\u0004\u0001C)\u0005g\tqbY;ti>lG)Z2pI\u0016\\U-\u001f\u000b\u0007\u0003W\u0012)Da\u000e\t\u0011\u0005-%q\u0006a\u0001\u0003\u001bC\u0001\"a\n\u00030\u0001\u0007\u0011\u0011\u0006\u0005\b\u0005w\u0001A\u0011\u000bB\u001f\u0003E\u0019Wo\u001d;p[\u0012+7m\u001c3f-\u0006dW/\u001a\u000b\u0007\u0003W\u0012yD!\u0011\t\u0011\u0005-%\u0011\ba\u0001\u0003\u001bC\u0001\"a\n\u0003:\u0001\u0007\u0011\u0011\u0006\u0005\b\u0005\u000b\u0002A\u0011\u0002B$\u0003!Ign\u0019:EK\u000e\u0014H\u0003BA6\u0005\u0013B\u0001\"a#\u0003D\u0001\u0007\u0011Q\u0012\u0005\b\u0005\u001b\u0002A\u0011\u0002B(\u0003!1G.^:i\u00032dG\u0003CA6\u0005#\u0012\u0019F!\u0016\t\u0011\u00055#1\na\u0001\u0003SA\u0001\"a#\u0003L\u0001\u0007\u0011Q\u0012\u0005\b\u0005/\u0012Y\u00051\u0001R\u00031I7OU3bIB\u000b'/Y7t\u0011\u001d\u0011Y\u0006\u0001C\u0005\u0005;\nQB^1mS\u0012\fG/\u001a#fYR\fG\u0003\u0002B0\u0005K\u0002B!a\u0016\u0003b%!!1MA1\u0005\u0019\u0011\u0015nZ%oi\"9!q\rB-\u0001\u0004\u0011\u0012!\u00023fYR\f\u0007b\u0002B6\u0001\u0011\u0005#QN\u0001\u0016GJ,\u0017\r^3Tk\u000e\u001cWm]:SKN\u0004xN\\:f)\u0011\tYGa\u001c\t\u000f\tE$\u0011\u000ea\u0001A\u0005!\u0001O]3w\u0011\u001d\u0011)\b\u0001C!\u0005o\n\u0011d\u0019:fCR,gj\u001c;Fq\u0016\u001cW\u000f^3e%\u0016\u001c\bo\u001c8tKR!\u00111\u000eB=\u0011\u001d\u0011\tHa\u001dA\u0002\u0001BqA! \u0001\t\u0003\u0012y(\u0001\fde\u0016\fG/\u001a(pi\u0016C\u0018n\u001d;SKN\u0004xN\\:f+\t\tY\u0007C\u0004\u0003\u0004\u0002!\tE!\"\u0002#\r\u0014X-\u0019;f\u000f\u0016$(+Z:q_:\u001cX\r\u0006\u0004\u0002l\t\u001d%\u0011\u0012\u0005\b\u0003w\u0012\t\t1\u0001\u0013\u0011\u001d\u0011YI!!A\u0002\u0001\n\u0011A\u001e\u0005\b\u0005\u001f\u0003A\u0011\tBI\u0003Y\u0019'/Z1uK6+H\u000e^5HKR\u0014Vm\u001d9p]N,G\u0003BA6\u0005'C\u0001B!&\u0003\u000e\u0002\u0007!qS\u0001\u0006a\u0006L'o\u001d\t\u0006'\te%\u0003I\u0005\u0004\u00057{\"aA'ba\"9!q\u0014\u0001\u0005B\t\u0005\u0016aE2sK\u0006$X-\u0012:s_J\u0014Vm\u001d9p]N,G\u0003BA6\u0005GC\u0001B!*\u0003\u001e\u0002\u0007!qU\u0001\u0002iB!\u0011q\u000bBU\u0013\u0011\u0011Y+!\u0019\u0003\u0013QC'o\\<bE2,\u0007b\u0002BX\u0001\u0011%!\u0011W\u0001\u0019Y><\u0017I\u001c3De\u0016\fG/Z#se>\u0014X*Z:tC\u001e,GC\u0002BZ\u0005\u007f\u0013\u0019\r\u0005\u0003\u00036\nmVB\u0001B\\\u0015\r\u0011ILM\u0001\u0005Y\u0006tw-\u0003\u0003\u0003>\n]&!D*ue&twMQ;jY\u0012,'\u000f\u0003\u0005\u0003B\n5\u0006\u0019\u0001BZ\u0003\t\u0019(\r\u0003\u0005\u0003F\n5\u0006\u0019\u0001Bd\u0003\u0005i\u0007cA\u0011\u0003J&\u0019!1\u001a\u0002\u0003%5+WnY1dQ\u0016$W\t_2faRLwN\u001c\u0005\b\u0005\u001f\u0004A\u0011\u000bBi\u0003U\u0019'/Z1uKN+'O^3s\u000bb\u001cW\r\u001d;j_:$bAa5\u0003V\n}\u0007C\u0002*\u0002H\t\u001d\u0017\u000b\u0003\u0005\u0003X\n5\u0007\u0019\u0001Bm\u0003\u0005)\u0007\u0003BA,\u00057LAA!8\u0002b\tIQ\t_2faRLwN\u001c\u0005\t\u0003\u001b\u0012i\r1\u0001\u0002*!9!1\u001d\u0001\u0005\n\t\u0015\u0018\u0001D2m_N,7\t[1o]\u0016dG\u0003BA6\u0005OD\u0001\"a#\u0003b\u0002\u0007\u0011Q\u0012\u0005\b\u0005W\u0004A\u0011\tB@\u0003M\u0019'/Z1uKN#\u0018\r^:SKN\u0004xN\\:f\u0011\u001d\u0011y\u000f\u0001C\u0005\u0005c\f\u0011BY;jY\u0012\u001cF/\u0019;\u0015\u0011\u0005%\"1\u001fB|\u0007\u0003AqA!>\u0003n\u0002\u0007!#\u0001\u0003ti\u0006$\b\u0002\u0003B}\u0005[\u0004\rAa?\u0002\u000bY\fG.^3\u0011\u0007I\u0013i0C\u0002\u0003\u0000r\u00111!\u00118z\u0011!\u0011\tM!<A\u0002\tM\u0006bBAh\u0001\u0011%1Q\u0001\u000b\bA\r\u001d1qCB\r\u0011!\u0019Iaa\u0001A\u0002\r-\u0011\u0001\u00023bi\u0006\u0004RAUB\u0007\u0007#I1aa\u0004\u001d\u0005\u0015\t%O]1z!\r\u001161C\u0005\u0004\u0007+a\"\u0001\u0002\"zi\u0016D\u0001\"!6\u0004\u0004\u0001\u0007\u0011q\u001b\u0005\t\u0003K\u001c\u0019\u00011\u0001\u0002X\"91Q\u0004\u0001\u0005\n\r}\u0011\u0001\u00052vS2$w)\u001a;SKN\u0004xN\\:f)!\tIc!\t\u00042\rM\u0002\u0002CB\u0012\u00077\u0001\ra!\n\u0002\u0005=\u0004\b\u0003BB\u0014\u0007[\u00012AUB\u0015\u0013\r\u0019Y\u0003\b\u0002\f\u000b:,X.\u001a:bi&|g.\u0003\u0003\u00040\r%\"!\u0002,bYV,\u0007bBA>\u00077\u0001\rA\u0005\u0005\b\u0005\u0017\u001bY\u00021\u0001!\u0011\u001d\u00199\u0004\u0001C\u0005\u0007s\taCY;jY\u0012\u001c\u0016N\\4mK\u001e+GOU3ta>t7/\u001a\u000b\u0007\u0003S\u0019Yd!\u0010\t\u000f\u0005m4Q\u0007a\u0001%!9!1RB\u001b\u0001\u0004\u0001\u0003bBB!\u0001\u0011%11I\u0001\u0014EVLG\u000eZ$fi\"+\u0017\rZ3s\u0005\u0016<\u0017N\u001c\u000b\t\u0003S\u0019)ea\u0012\u0004J!9\u00111PB \u0001\u0004\u0011\u0002b\u0002BF\u0007\u007f\u0001\r\u0001\t\u0005\t\u0007\u0017\u001ay\u00041\u0001\u0002n\u0006QQ\r\u001f;sCN\u0003\u0018mY3\t\u000f\r=\u0003\u0001\"\u0003\u0004R\u0005\u0011rO]5uK\u001e+G\u000fS3bI\u0016\u0014H)\u0019;b)\u0019\tIca\u0015\u0004V!A1\u0011BB'\u0001\u0004\u0019Y\u0001\u0003\u0005\u0004X\r5\u0003\u0019AA\u0015\u0003\r\u0011WO\u001a\u0005\b\u00077\u0002A\u0011BB/\u0003E9(/\u001b;f\u000f\u0016$\b*Z1eKJ,e\u000e\u001a\u000b\u0005\u0003S\u0019y\u0006\u0003\u0005\u0004X\re\u0003\u0019AA\u0015\u0011\u001d\u0019\u0019\u0007\u0001C\u0005\u0007K\n\u0011EY;jY\u0012\u001c\u0016N\\4mK\u001e+GoV5uQZ+'o]5p]J+7\u000f]8og\u0016$b!!\u000b\u0004h\r%\u0004bBA>\u0007C\u0002\rA\u0005\u0005\b\u0005\u0017\u001b\t\u00071\u0001!\u0011\u001d\u0019i\u0007\u0001C\u0005\u0007_\n1C\u001a:jK:$G._'bq&sGo\u00115fG.$b!!<\u0004r\rU\u0004bBB:\u0007W\u0002\rAE\u0001\u0007]Vl'-\u001a:\t\u000f\r]41\u000ea\u0001%\u00059Q.Z:tC\u001e,\u0007bBB>\u0001\u0011%1QP\u0001\u0012]VlWM]5d\u0019&l\u0017\u000e^\"iK\u000e\\GCCAw\u0007\u007f\u001a\ti!\"\u0004\b\"911OB=\u0001\u0004\u0011\u0002\u0002CBB\u0007s\u0002\r!a6\u0002\u00115\f\u0007PV1mk\u0016Dqaa\u001e\u0004z\u0001\u0007!\u0003\u0003\u0005\u0004\n\u000ee\u0004\u0019ABF\u0003\u0005q\u0007\u0003BA,\u0007\u001bKAaa$\u0002b\t)b*^7cKJ4uN]7bi\u0016C8-\u001a9uS>t\u0007bBB>\u0001\u0011%11\u0013\u000b\t\u0003/\u001c)ja&\u0004\u001a\"911OBI\u0001\u0004\u0011\u0002\u0002CBB\u0007#\u0003\r!a6\t\u000f\r]4\u0011\u0013a\u0001%\u0001")
public class MemcachedDecoder
extends AbstractProtocolDecoder<String, MemcachedValue> {
    private final ScheduledExecutorService scheduler;
    private final NettyTransport transport;
    private boolean isStatsEnabled;
    private final AtomicLong incrMisses;
    private final AtomicLong incrHits;
    private final AtomicLong decrMisses;
    private final AtomicLong decrHits;
    private final AtomicLong replaceIfUnmodifiedMisses;
    private final AtomicLong replaceIfUnmodifiedHits;
    private final AtomicLong replaceIfUnmodifiedBadval;
    private final boolean isTrace;
    private final ByteArrayOutputStream byteBuffer;
    private volatile boolean bitmap$0;

    private boolean isStatsEnabled$lzycompute() {
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if (!this.bitmap$0) {
                this.isStatsEnabled = this.cache().getCacheConfiguration().jmxStatistics().enabled();
                this.bitmap$0 = true;
            }
            return this.isStatsEnabled;
        }
    }

    private boolean isStatsEnabled() {
        return this.bitmap$0 ? this.isStatsEnabled : this.isStatsEnabled$lzycompute();
    }

    private final AtomicLong incrMisses() {
        return this.incrMisses;
    }

    private final AtomicLong incrHits() {
        return this.incrHits;
    }

    private final AtomicLong decrMisses() {
        return this.decrMisses;
    }

    private final AtomicLong decrHits() {
        return this.decrHits;
    }

    private final AtomicLong replaceIfUnmodifiedMisses() {
        return this.replaceIfUnmodifiedMisses;
    }

    private final AtomicLong replaceIfUnmodifiedHits() {
        return this.replaceIfUnmodifiedHits;
    }

    private final AtomicLong replaceIfUnmodifiedBadval() {
        return this.replaceIfUnmodifiedBadval;
    }

    private boolean isTrace() {
        return this.isTrace;
    }

    private ByteArrayOutputStream byteBuffer() {
        return this.byteBuffer;
    }

    public RequestHeader createHeader() {
        return new RequestHeader();
    }

    public Option<Object> readHeader(ChannelBuffer buffer, RequestHeader header) {
        Enumeration.Value op;
        boolean endOfOp = TextProtocolUtil$.MODULE$.readElement(buffer, this.byteBuffer());
        String streamOp = TextProtocolUtil$.MODULE$.extractString(this.byteBuffer());
        Enumeration.Value value = op = RequestResolver$.MODULE$.toRequest(streamOp, endOfOp, buffer);
        Enumeration.Value value2 = Operation$.MODULE$.StatsRequest();
        if (!(value != null ? !value.equals(value2) : value2 != null) && !endOfOp) {
            String line = TextProtocolUtil$.MODULE$.readDiscardedLine(buffer).trim();
            if (line.isEmpty()) {
                endOfOp = true;
            } else {
                throw new StreamCorruptedException(new StringBuilder().append((Object)"Stats command does not accept arguments: ").append((Object)line).toString());
            }
        }
        Enumeration.Value value3 = op;
        Enumeration.Value value4 = MemcachedOperation$.MODULE$.VerbosityRequest();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            if (!endOfOp) {
                TextProtocolUtil$.MODULE$.skipLine(buffer);
            }
            throw new StreamCorruptedException("Memcached 'verbosity' command is unsupported");
        }
        header.op_$eq(op);
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    public Tuple2<String, Object> readKey(ChannelBuffer b) {
        boolean endOfOp = TextProtocolUtil$.MODULE$.readElement(b, this.byteBuffer());
        String k = TextProtocolUtil$.MODULE$.extractString(this.byteBuffer());
        this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, endOfOp, b);
        return new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    private Seq<String> readKeys(ChannelBuffer b) {
        return TextProtocolUtil$.MODULE$.readSplitLine(b);
    }

    public Object get(ChannelBuffer buffer) {
        Object object;
        Seq<String> keys = this.readKeys(buffer);
        if (keys.length() > 1) {
            scala.collection.mutable.HashMap map = new scala.collection.mutable.HashMap();
            keys.foreach((Function1)new Serializable(this, buffer, map){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemcachedDecoder $outer;
                private final ChannelBuffer buffer$1;
                private final scala.collection.mutable.HashMap map$1;

                public final Object apply(String k) {
                    MemcachedValue v = (MemcachedValue)((Object)this.$outer.cache().get((Object)this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, true, this.buffer$1)));
                    return v == null ? BoxedUnit.UNIT : this.map$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)k), (Object)((Object)v)));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.buffer$1 = buffer$1;
                    this.map$1 = map$1;
                }
            });
            object = this.createMultiGetResponse((Map<String, MemcachedValue>)new HashMap().$plus$plus((GenTraversableOnce)map));
        } else {
            String key = (String)keys.apply(0);
            object = this.createGetResponse(key, (MemcachedValue)((Object)this.cache().get((Object)this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(key, true, buffer))));
        }
        return object;
    }

    public String org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(String k, boolean endOfOp, ChannelBuffer b) {
        if (k.length() > 250) {
            if (!endOfOp) {
                TextProtocolUtil$.MODULE$.skipLine(b);
            }
            throw new StreamCorruptedException("Key length over the 250 character limit");
        }
        return k;
    }

    public boolean readParameters(Channel ch, ChannelBuffer b) {
        MemcachedParameters memcachedParameters;
        Seq<String> args = TextProtocolUtil$.MODULE$.readSplitLine(b);
        BooleanRef endOfOp = new BooleanRef(false);
        if (args.isEmpty()) {
            memcachedParameters = null;
        } else {
            if (this.isTrace()) {
                this.trace((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Operation parameters: %s";
                    }
                }, args);
            }
            memcachedParameters = this.liftedTree1$1(b, args, endOfOp);
        }
        this.params_$eq(memcachedParameters);
        return endOfOp.elem;
    }

    private MemcachedParameters readRemoveParameters(Seq<String> args) {
        int delayedDeleteTime = this.parseDelayedDeleteTime(args);
        boolean noReply = delayedDeleteTime == -1 ? this.parseNoReply(0, args) : false;
        return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", 0);
    }

    private MemcachedParameters readIncrDecrParameters(Seq<String> args) {
        String delta = (String)args.apply(0);
        return new MemcachedParameters(-1, -1, -1, -1L, this.parseNoReply(1, args), 0L, delta, 0);
    }

    private MemcachedParameters readFlushAllParameters(Seq<String> args) {
        NumberFormatException numberFormatException2;
        block2: {
            int n;
            boolean noReplyFound = false;
            try {
                n = this.friendlyMaxIntCheck((String)args.apply(0), "Flush delay");
            }
            catch (NumberFormatException numberFormatException2) {
                if (!numberFormatException2.getMessage().contains("noreply")) break block2;
                noReplyFound = true;
                n = 0;
            }
            int flushDelay = n;
            boolean noReply = noReplyFound ? true : this.parseNoReply(1, args);
            return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", flushDelay);
        }
        throw numberFormatException2;
    }

    private MemcachedParameters readStorageParameters(Seq<String> args, ChannelBuffer b) {
        long l;
        int length;
        int streamLifespan;
        int index = 0;
        long flags = this.getFlags((String)args.apply(index));
        if (flags < 0L) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Flags cannot be negative: ").append((Object)BoxesRunTime.boxToLong((long)flags)).toString());
        }
        int lifespan = (streamLifespan = this.getLifespan((String)args.apply(++index))) <= 0 ? -1 : streamLifespan;
        if ((length = this.getLength((String)args.apply(++index))) < 0) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Negative bytes length provided: ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString());
        }
        Enumeration.Value value = this.header().op();
        Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Enumeration.Value x2 = value;
            l = this.getVersion((String)args.apply(++index));
        } else {
            l = -1L;
        }
        long streamVersion = l;
        boolean noReply = this.parseNoReply(++index, args);
        return new MemcachedParameters(length, lifespan, -1, streamVersion, noReply, flags, "", 0);
    }

    public void readValue(ChannelBuffer b) {
        b.readBytes(this.rawValue());
        TextProtocolUtil$.MODULE$.skipLine(b);
    }

    public MemcachedValue createValue(long nextVersion) {
        return new MemcachedValue(this.rawValue(), nextVersion, ((MemcachedParameters)this.params()).flags());
    }

    private long getFlags(String flags) {
        long l;
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        try {
            l = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags");
        }
        catch (NumberFormatException numberFormatException) {
            l = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags", numberFormatException);
        }
        return l;
    }

    private int getLifespan(String lifespan) {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return this.friendlyMaxIntCheck(lifespan, "Lifespan");
    }

    private int getLength(String length) {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return this.friendlyMaxIntCheck(length, "The number of bytes");
    }

    private long getVersion(String version) {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return new StringOps(Predef$.MODULE$.augmentString(version)).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNoReply(int expectedIndex, Seq<String> args) {
        if (args.length() <= expectedIndex) return false;
        Object object = args.apply(expectedIndex);
        if ("noreply" != null) {
            if (!"noreply".equals(object)) throw new StreamCorruptedException("Unable to parse noreply optional argument");
            return true;
        }
        if (object == null) return true;
        throw new StreamCorruptedException("Unable to parse noreply optional argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDelayedDeleteTime(Seq<String> args) {
        int n;
        if (args.length() <= 0) return 0;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString((String)args.apply(0))).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public Cache<String, MemcachedValue> getCache() {
        return this.cache();
    }

    public Object customDecodeHeader(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        value = this.header().op();
                        Enumeration.Value value2 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        Enumeration.Value x2 = value;
                        object = this.flushAll(buffer, ch, false);
                        break block3;
                    }
                    Enumeration.Value value4 = MemcachedOperation$.MODULE$.VersionRequest();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    Enumeration.Value x3 = value;
                    java.lang.StringBuilder ret = new java.lang.StringBuilder().append("VERSION ").append(Version.VERSION).append(TextProtocolUtil$.MODULE$.CRLF());
                    object = this.writeResponse(ch, ret);
                    break block3;
                }
                Enumeration.Value value6 = MemcachedOperation$.MODULE$.QuitRequest();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                Enumeration.Value x4 = value;
                object = this.closeChannel(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeKey(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block13: {
            Object object;
            block12: {
                block11: {
                    boolean bl;
                    value = this.header().op();
                    Enumeration.Value value2 = MemcachedOperation$.MODULE$.AppendRequest();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        Enumeration.Value x2 = value;
                        bl = true;
                    } else {
                        Enumeration.Value value4 = MemcachedOperation$.MODULE$.PrependRequest();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            Enumeration.Value x3 = value;
                            bl = true;
                        } else {
                            Enumeration.Value value6 = MemcachedOperation$.MODULE$.IncrementRequest();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                Enumeration.Value x4 = value;
                                bl = true;
                            } else {
                                Enumeration.Value value8 = MemcachedOperation$.MODULE$.DecrementRequest();
                                Enumeration.Value value9 = value;
                                if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                    Enumeration.Value x5 = value;
                                    bl = true;
                                } else {
                                    bl = false;
                                }
                            }
                        }
                    }
                    if (!bl) break block11;
                    this.key_$eq(this.readKey(buffer)._1());
                    object = this.checkpointTo(DecoderState.DECODE_PARAMETERS);
                    break block12;
                }
                Enumeration.Value value10 = MemcachedOperation$.MODULE$.FlushAllRequest();
                Enumeration.Value value11 = value;
                if (value10 != null ? !value10.equals(value11) : value11 != null) break block13;
                Enumeration.Value x6 = value;
                object = this.flushAll(buffer, ch, true);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeValue(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block21: {
            Object object;
            block20: {
                boolean bl;
                block14: {
                    Enumeration.Value value2;
                    block19: {
                        Object object2;
                        block16: {
                            byte[] byArray;
                            MemcachedValue prev;
                            block18: {
                                block17: {
                                    block15: {
                                        boolean bl2;
                                        Enumeration.Value op;
                                        value = op = this.header().op();
                                        Enumeration.Value value3 = MemcachedOperation$.MODULE$.AppendRequest();
                                        Enumeration.Value value4 = value;
                                        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                                            Enumeration.Value x2 = value;
                                            bl2 = true;
                                        } else {
                                            Enumeration.Value value5 = MemcachedOperation$.MODULE$.PrependRequest();
                                            Enumeration.Value value6 = value;
                                            if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                                                Enumeration.Value x3 = value;
                                                bl2 = true;
                                            } else {
                                                bl2 = false;
                                            }
                                        }
                                        if (!bl2) break block14;
                                        this.readValue(buffer);
                                        prev = (MemcachedValue)((Object)this.cache().get(this.key()));
                                        if (prev != null) break block15;
                                        object2 = ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_STORED();
                                        break block16;
                                    }
                                    value2 = this.header().op();
                                    Enumeration.Value value7 = MemcachedOperation$.MODULE$.AppendRequest();
                                    Enumeration.Value value8 = value2;
                                    if (value7 != null ? !value7.equals(value8) : value8 != null) break block17;
                                    Enumeration.Value x2 = value2;
                                    byArray = TextProtocolUtil$.MODULE$.concat(prev.data(), this.rawValue());
                                    break block18;
                                }
                                Enumeration.Value value9 = MemcachedOperation$.MODULE$.PrependRequest();
                                Enumeration.Value value10 = value2;
                                if (value9 != null ? !value9.equals(value10) : value10 != null) break block19;
                                Enumeration.Value x3 = value2;
                                byArray = TextProtocolUtil$.MODULE$.concat(this.rawValue(), prev.data());
                            }
                            byte[] concatenated = byArray;
                            MemcachedValue next = this.createValue(concatenated, this.generateVersion(this.cache()), ((MemcachedParameters)this.params()).flags());
                            boolean replaced = this.cache().replace(this.key(), (Object)prev, (Object)next);
                            object2 = replaced ? (Object)(((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.STORED()) : (Object)(((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_STORED());
                        }
                        byte[] ret = object2;
                        object = this.writeResponse(ch, ret);
                        break block20;
                    }
                    throw new MatchError((Object)value2);
                }
                Enumeration.Value value11 = MemcachedOperation$.MODULE$.IncrementRequest();
                Enumeration.Value value12 = value;
                if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                    Enumeration.Value x4 = value;
                    bl = true;
                } else {
                    Enumeration.Value value13 = MemcachedOperation$.MODULE$.DecrementRequest();
                    Enumeration.Value value14 = value;
                    if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                        Enumeration.Value x5 = value;
                        bl = true;
                    } else {
                        bl = false;
                    }
                }
                if (!bl) break block21;
                object = this.incrDecr(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    private Object incrDecr(Channel ch) {
        Enumeration.Value value;
        block9: {
            BigInt prevCounter;
            block10: {
                Object object;
                block6: {
                    Object object2;
                    Enumeration.Value op;
                    MemcachedValue prev;
                    block8: {
                        BigInt delta;
                        block7: {
                            block5: {
                                Object object3;
                                prev = (MemcachedValue)((Object)this.cache().get(this.key()));
                                op = this.header().op();
                                if (prev != null) break block5;
                                if (this.isStatsEnabled()) {
                                    Enumeration.Value value2 = op;
                                    Enumeration.Value value3 = MemcachedOperation$.MODULE$.IncrementRequest();
                                    object3 = BoxesRunTime.boxToLong((long)(!(value2 != null ? !value2.equals(value3) : value3 != null) ? this.incrMisses().incrementAndGet() : this.decrMisses().incrementAndGet()));
                                } else {
                                    object3 = BoxedUnit.UNIT;
                                }
                                object = ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_FOUND();
                                break block6;
                            }
                            prevCounter = package$.MODULE$.BigInt().apply(new String(prev.data()));
                            delta = this.validateDelta(((MemcachedParameters)this.params()).delta());
                            value = op;
                            Enumeration.Value value4 = MemcachedOperation$.MODULE$.IncrementRequest();
                            Enumeration.Value value5 = value;
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block7;
                            Enumeration.Value x2 = value;
                            BigInt candidateCounter = prevCounter.$plus(delta);
                            object2 = candidateCounter.$greater(TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG()) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                            break block8;
                        }
                        Enumeration.Value value6 = MemcachedOperation$.MODULE$.DecrementRequest();
                        Enumeration.Value value7 = value;
                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block9;
                        Enumeration.Value x3 = value;
                        BigInt candidateCounter = prevCounter.$minus(delta);
                        object2 = candidateCounter.$less(BigInt$.MODULE$.int2bigInt(0)) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                    }
                    Object newCounter = object2;
                    MemcachedValue next = this.createValue(newCounter.toString().getBytes(), this.generateVersion(this.cache()), ((MemcachedParameters)this.params()).flags());
                    boolean replaced = this.cache().replace(this.key(), (Object)prev, (Object)next);
                    if (replaced) {
                        Object object4;
                        if (this.isStatsEnabled()) {
                            Enumeration.Value value8 = op;
                            Enumeration.Value value9 = MemcachedOperation$.MODULE$.IncrementRequest();
                            object4 = BoxesRunTime.boxToLong((long)(!(value8 != null ? !value8.equals(value9) : value9 != null) ? this.incrHits().incrementAndGet() : this.decrHits().incrementAndGet()));
                        } else {
                            object4 = BoxedUnit.UNIT;
                        }
                        object = ((MemcachedParameters)this.params()).noReply() ? null : (Object)new StringBuilder().append((Object)new String(next.data())).append((Object)TextProtocolUtil$.MODULE$.CRLF()).toString();
                    }
                    break block10;
                }
                byte[] ret = object;
                return this.writeResponse(ch, ret);
            }
            throw new CacheException(new StringBuilder().append((Object)"Value modified since we retrieved from the cache, old value was ").append((Object)prevCounter).toString());
        }
        throw new MatchError((Object)value);
    }

    private Object flushAll(ChannelBuffer b, Channel ch, boolean isReadParams) {
        Object object = isReadParams ? BoxesRunTime.boxToBoolean((boolean)this.readParameters(ch, b)) : BoxedUnit.UNIT;
        Serializable flushFunction = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AdvancedCache<String, MemcachedValue> cache) {
                cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_STORE}).clear();
            }
        };
        int flushDelay = this.params() == null ? 0 : ((MemcachedParameters)this.params()).flushDelay();
        ScheduledFuture<?> scheduledFuture = flushDelay == 0 ? flushFunction.apply((Object)this.cache().getAdvancedCache()) : this.scheduler.schedule(new DelayedFlushAll((Cache<String, MemcachedValue>)this.cache(), (Function1<AdvancedCache<String, MemcachedValue>, BoxedUnit>)flushFunction), this.toMillis(flushDelay), TimeUnit.MILLISECONDS);
        byte[] ret = (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.OK());
        return this.writeResponse(ch, ret);
    }

    /*
     * WARNING - void declaration
     */
    private BigInt validateDelta(String delta) {
        void var2_2;
        BigInt bigIntDelta = package$.MODULE$.BigInt().apply(delta);
        if (bigIntDelta.$greater(TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta sent (").append((Object)delta).append((Object)") exceeds unsigned limit (").append((Object)TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG()).append((Object)")").toString());
        }
        if (bigIntDelta.$less(TextProtocolUtil$.MODULE$.MIN_UNSIGNED())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta cannot be negative: ").append((Object)delta).toString());
        }
        return var2_2;
    }

    public Object createSuccessResponse(MemcachedValue prev) {
        byte[] byArray;
        BoxedUnit boxedUnit;
        if (this.isStatsEnabled()) {
            Object object;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                object = BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedHits().incrementAndGet());
            } else {
                object = BoxedUnit.UNIT;
            }
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            byte[] byArray2;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.RemoveRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Enumeration.Value x2 = value;
                byArray2 = TextProtocolUtil$.MODULE$.DELETED();
            } else {
                byArray2 = TextProtocolUtil$.MODULE$.STORED();
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public Object createNotExecutedResponse(MemcachedValue prev) {
        byte[] byArray;
        BoxedUnit boxedUnit;
        if (this.isStatsEnabled()) {
            Object object;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                object = BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedBadval().incrementAndGet());
            } else {
                object = BoxedUnit.UNIT;
            }
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            byte[] byArray2;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Enumeration.Value x2 = value;
                byArray2 = TextProtocolUtil$.MODULE$.EXISTS();
            } else {
                byArray2 = TextProtocolUtil$.MODULE$.NOT_STORED();
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public Object createNotExistResponse() {
        BoxedUnit boxedUnit;
        if (this.isStatsEnabled()) {
            Object object;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                object = BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedMisses().incrementAndGet());
            } else {
                object = BoxedUnit.UNIT;
            }
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_FOUND());
    }

    public Object createGetResponse(String k, MemcachedValue v) {
        Enumeration.Value value;
        block6: {
            Object object;
            block3: {
                ChannelBuffer channelBuffer;
                block5: {
                    block4: {
                        block2: {
                            if (v != null) break block2;
                            object = TextProtocolUtil$.MODULE$.END();
                            break block3;
                        }
                        value = this.header().op();
                        Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block4;
                        Enumeration.Value x2 = value;
                        channelBuffer = this.buildSingleGetResponse(k, v);
                        break block5;
                    }
                    Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block6;
                    Enumeration.Value x3 = value;
                    channelBuffer = this.buildSingleGetWithVersionResponse(k, v);
                }
                object = channelBuffer;
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object createMultiGetResponse(Map<String, MemcachedValue> pairs) {
        boolean bl;
        Enumeration.Value op;
        ListBuffer elements = new ListBuffer();
        Enumeration.Value value = op = this.header().op();
        Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Enumeration.Value x2 = value;
            bl = true;
        } else {
            Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Enumeration.Value x3 = value;
                bl = true;
            } else {
                bl = false;
            }
        }
        if (bl) {
            pairs.foreach((Function1)new Serializable(this, elements, op){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemcachedDecoder $outer;
                private final ListBuffer elements$1;
                private final Enumeration.Value op$1;

                public final ListBuffer<ChannelBuffer> apply(Tuple2<String, MemcachedValue> x$1) {
                    Tuple2<String, MemcachedValue> tuple2 = x$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        MemcachedValue v = (MemcachedValue)((Object)tuple2._2());
                        ListBuffer listBuffer = this.elements$1.$plus$eq((Object)this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(this.op$1, k, v));
                        return listBuffer;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.elements$1 = elements$1;
                    this.op$1 = op$1;
                }
            });
            ListBuffer listBuffer = elements.$plus$eq((Object)ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{TextProtocolUtil$.MODULE$.END()})));
            return elements.toArray(ClassTag$.MODULE$.apply(ChannelBuffer.class));
        }
        throw new MatchError((Object)value);
    }

    public Object createErrorResponse(Throwable t) {
        Object object;
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        Throwable throwable = t;
        if (throwable instanceof MemcachedException) {
            Object object2;
            MemcachedException x2 = (MemcachedException)throwable;
            Throwable throwable2 = x2.getCause();
            if (throwable2 instanceof UnknownOperationException) {
                UnknownOperationException x22 = (UnknownOperationException)throwable2;
                this.logExceptionReported((Throwable)x22);
                object2 = TextProtocolUtil$.MODULE$.ERROR();
            } else if (throwable2 instanceof ClosedChannelException) {
                ClosedChannelException x3 = (ClosedChannelException)throwable2;
                this.logExceptionReported(x3);
                object2 = null;
            } else if (throwable2 instanceof IOException) {
                IOException x4 = (IOException)throwable2;
                object2 = this.logAndCreateErrorMessage(sb, x2);
            } else if (throwable2 instanceof NumberFormatException) {
                NumberFormatException x5 = (NumberFormatException)throwable2;
                object2 = this.logAndCreateErrorMessage(sb, x2);
            } else if (throwable2 instanceof IllegalStateException) {
                IllegalStateException x6 = (IllegalStateException)throwable2;
                object2 = this.logAndCreateErrorMessage(sb, x2);
            } else {
                object2 = sb.append(x2.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
            }
            object = object2;
        } else if (throwable instanceof ClosedChannelException) {
            ClosedChannelException x3 = (ClosedChannelException)throwable;
            this.logExceptionReported(x3);
            object = null;
        } else {
            object = sb.append(TextProtocolUtil$.MODULE$.SERVER_ERROR()).append(t.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
        }
        return object;
    }

    private java.lang.StringBuilder logAndCreateErrorMessage(java.lang.StringBuilder sb, MemcachedException m) {
        this.logExceptionReported(m.getCause());
        return sb.append(m.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
    }

    public Tuple2<MemcachedException, Object> createServerException(Exception e, ChannelBuffer b) {
        Tuple2 tuple2;
        Exception exception = e;
        if (exception instanceof IOException) {
            IOException x2 = (IOException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.CLIENT_ERROR_BAD_FORMAT()).append((Object)x2.getMessage()).toString(), x2), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (exception instanceof NumberFormatException) {
            NumberFormatException x3 = (NumberFormatException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.CLIENT_ERROR_BAD_FORMAT()).append((Object)x3.getMessage()).toString(), x3), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.SERVER_ERROR()).append((Object)e).toString(), e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple2;
    }

    private Object closeChannel(Channel ch) {
        ch.close();
        return null;
    }

    public Object createStatsResponse() {
        Stats stats = this.cache().getAdvancedCache().getStats();
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        return new ChannelBuffer[]{this.buildStat("pid", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("time", BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())), sb), this.buildStat("version", this.cache().getVersion(), sb), this.buildStat("pointer_size", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_user", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_system", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_items", BoxesRunTime.boxToInteger((int)stats.getCurrentNumberOfEntries()), sb), this.buildStat("total_items", BoxesRunTime.boxToLong((long)stats.getTotalNumberOfEntries()), sb), this.buildStat("bytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("total_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("connection_structures", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("cmd_get", BoxesRunTime.boxToLong((long)stats.getRetrievals()), sb), this.buildStat("cmd_set", BoxesRunTime.boxToLong((long)stats.getStores()), sb), this.buildStat("get_hits", BoxesRunTime.boxToLong((long)stats.getHits()), sb), this.buildStat("get_misses", BoxesRunTime.boxToLong((long)stats.getMisses()), sb), this.buildStat("delete_misses", BoxesRunTime.boxToLong((long)stats.getRemoveMisses()), sb), this.buildStat("delete_hits", BoxesRunTime.boxToLong((long)stats.getRemoveHits()), sb), this.buildStat("incr_misses", this.incrMisses(), sb), this.buildStat("incr_hits", this.incrHits(), sb), this.buildStat("decr_misses", this.decrMisses(), sb), this.buildStat("decr_hits", this.decrHits(), sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses(), sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits(), sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval(), sb), this.buildStat("auth_cmds", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("auth_errors", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("evictions", BoxesRunTime.boxToLong((long)stats.getEvictions()), sb), this.buildStat("bytes_read", this.transport.getTotalBytesRead(), sb), this.buildStat("bytes_written", this.transport.getTotalBytesWritten(), sb), this.buildStat("limit_maxbytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("threads", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("conn_yields", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("reclaimed", BoxesRunTime.boxToInteger((int)0), sb), ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{TextProtocolUtil$.MODULE$.END()}))};
    }

    private ChannelBuffer buildStat(String stat, Object value, java.lang.StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append(TextProtocolUtil$.MODULE$.CRLF());
        ChannelBuffer buffer = ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sb.toString().getBytes()}));
        sb.setLength(0);
        return buffer;
    }

    private MemcachedValue createValue(byte[] data, long nextVersion, long flags) {
        return new MemcachedValue(data, nextVersion, flags);
    }

    public ChannelBuffer org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(Enumeration.Value op, String k, MemcachedValue v) {
        ChannelBuffer buf = this.buildGetHeaderBegin(k, v, 0);
        return this.writeGetHeaderData(v.data(), buf);
    }

    private ChannelBuffer buildSingleGetResponse(String k, MemcachedValue v) {
        ChannelBuffer buf = this.buildGetHeaderBegin(k, v, TextProtocolUtil$.MODULE$.END_SIZE());
        this.writeGetHeaderData(v.data(), buf);
        return this.writeGetHeaderEnd(buf);
    }

    private ChannelBuffer buildGetHeaderBegin(String k, MemcachedValue v, int extraSpace) {
        byte[] data = v.data();
        byte[] dataSize = Integer.valueOf(data.length).toString().getBytes();
        byte[] key = k.getBytes();
        byte[] flags = v.flags() != 0L ? Long.valueOf(v.flags()).toString().getBytes() : TextProtocolUtil$.MODULE$.ZERO();
        int flagsSize = flags.length;
        ChannelBuffer buf = ExtendedChannelBuffer$.MODULE$.buffer(TextProtocolUtil$.MODULE$.VALUE_SIZE() + key.length + data.length + flagsSize + dataSize.length + 6 + extraSpace);
        buf.writeBytes(TextProtocolUtil$.MODULE$.VALUE());
        buf.writeBytes(key);
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(flags);
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(dataSize);
        return buf;
    }

    private ChannelBuffer writeGetHeaderData(byte[] data, ChannelBuffer buf) {
        buf.writeBytes(TextProtocolUtil$.MODULE$.CRLFBytes());
        buf.writeBytes(data);
        buf.writeBytes(TextProtocolUtil$.MODULE$.CRLFBytes());
        return buf;
    }

    private ChannelBuffer writeGetHeaderEnd(ChannelBuffer buf) {
        buf.writeBytes(TextProtocolUtil$.MODULE$.END());
        return buf;
    }

    private ChannelBuffer buildSingleGetWithVersionResponse(String k, MemcachedValue v) {
        byte[] version = ((Object)BoxesRunTime.boxToLong((long)v.version())).toString().getBytes();
        ChannelBuffer buf = this.buildGetHeaderBegin(k, v, version.length + 1 + TextProtocolUtil$.MODULE$.END_SIZE());
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(version);
        this.writeGetHeaderData(v.data(), buf);
        return this.writeGetHeaderEnd(buf);
    }

    private int friendlyMaxIntCheck(String number, String message) {
        int n;
        try {
            n = Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            n = this.numericLimitCheck(number, Integer.MAX_VALUE, message, numberFormatException);
        }
        return n;
    }

    private int numericLimitCheck(String number, long maxValue, String message, NumberFormatException n) {
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        throw n;
    }

    private long numericLimitCheck(String number, long maxValue, String message) {
        long numeric = Long.parseLong(number);
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        return numeric;
    }

    private final MemcachedParameters liftedTree1$1(ChannelBuffer b$1, Seq args$1, BooleanRef endOfOp$1) {
        try {
            MemcachedParameters memcachedParameters;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.PutRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                memcachedParameters = this.readStorageParameters((Seq<String>)args$1, b$1);
            } else {
                Enumeration.Value value4 = Operation$.MODULE$.RemoveRequest();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    Enumeration.Value x3 = value;
                    memcachedParameters = this.readRemoveParameters((Seq<String>)args$1);
                } else {
                    boolean bl;
                    Enumeration.Value value6 = MemcachedOperation$.MODULE$.IncrementRequest();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        Enumeration.Value x4 = value;
                        bl = true;
                    } else {
                        Enumeration.Value value8 = MemcachedOperation$.MODULE$.DecrementRequest();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            Enumeration.Value x5 = value;
                            bl = true;
                        } else {
                            bl = false;
                        }
                    }
                    if (bl) {
                        endOfOp$1.elem = true;
                        memcachedParameters = this.readIncrDecrParameters((Seq<String>)args$1);
                    } else {
                        Enumeration.Value value10 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            Enumeration.Value x6 = value;
                            memcachedParameters = this.readFlushAllParameters((Seq<String>)args$1);
                        } else {
                            memcachedParameters = this.readStorageParameters((Seq<String>)args$1, b$1);
                        }
                    }
                }
            }
            return memcachedParameters;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException(new StringBuilder().append((Object)"Missing content in command line ").append((Object)args$1).toString());
        }
    }

    public MemcachedDecoder(Cache<String, MemcachedValue> memcachedCache, ScheduledExecutorService scheduler, NettyTransport transport) {
        this.scheduler = scheduler;
        this.transport = transport;
        super(transport);
        this.cache_$eq(memcachedCache);
        this.incrMisses = new AtomicLong(0L);
        this.incrHits = new AtomicLong(0L);
        this.decrMisses = new AtomicLong(0L);
        this.decrHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedMisses = new AtomicLong(0L);
        this.replaceIfUnmodifiedHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedBadval = new AtomicLong(0L);
        this.isTrace = this.isTraceEnabled();
        this.byteBuffer = new ByteArrayOutputStream();
    }
}

