/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.DecoderState;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.RequestHeader;
import org.infinispan.server.core.ServerEntryVersion;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ExtendedChannelBuffer$;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.memcached.DelayedFlushAll;
import org.infinispan.server.memcached.MemcachedException;
import org.infinispan.server.memcached.MemcachedOperation$;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.MemcachedValue;
import org.infinispan.server.memcached.RequestResolver$;
import org.infinispan.server.memcached.TextProtocolUtil$;
import org.infinispan.stats.Stats;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rMf\u0001B\u0001\u0003\u0001-\u0011\u0001#T3nG\u0006\u001c\u0007.\u001a3EK\u000e|G-\u001a:\u000b\u0005\r!\u0011!C7f[\u000e\f7\r[3e\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000f!\t!\"\u001b8gS:L7\u000f]1o\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\u0011i\u0001C\u0005\u0011\u000e\u00039Q!a\u0004\u0003\u0002\t\r|'/Z\u0005\u0003#9\u0011q#\u00112tiJ\f7\r\u001e)s_R|7m\u001c7EK\u000e|G-\u001a:\u0011\u0005MibB\u0001\u000b\u001b\u001d\t)\u0002$D\u0001\u0017\u0015\t9\"\"\u0001\u0004=e>|GOP\u0005\u00023\u0005)1oY1mC&\u00111\u0004H\u0001\u0007!J,G-\u001a4\u000b\u0003eI!AH\u0010\u0003\rM#(/\u001b8h\u0015\tYB\u0004\u0005\u0002\"E5\t!!\u0003\u0002$\u0005\tqQ*Z7dC\u000eDW\r\u001a,bYV,\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u001d5,WnY1dQ\u0016$7)Y2iKB!q\u0005\u000b\n!\u001b\u00051\u0011BA\u0015\u0007\u00055\tEM^1oG\u0016$7)Y2iK\"A1\u0006\u0001B\u0001B\u0003%A&A\u0005tG\",G-\u001e7feB\u0011Q\u0006N\u0007\u0002])\u0011q\u0006M\u0001\u000bG>t7-\u001e:sK:$(BA\u00193\u0003\u0011)H/\u001b7\u000b\u0003M\nAA[1wC&\u0011QG\f\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\u0002\u0013Q\u0014\u0018M\\:q_J$\bCA\u001d<\u001b\u0005Q$BA\u001c\u000f\u0013\ta$H\u0001\bOKR$\u0018\u0010\u0016:b]N\u0004xN\u001d;\t\u000by\u0002A\u0011A \u0002\rqJg.\u001b;?)\u0011\u0001\u0015IQ\"\u0011\u0005\u0005\u0002\u0001\"B\u0013>\u0001\u00041\u0003\"B\u0016>\u0001\u0004a\u0003\"B\u001c>\u0001\u0004AT\u0001B#\u0001\u0001\u0019\u0013!cU;ji\u0006\u0014G.\u001a)be\u0006lW\r^3sgB\u0011\u0011eR\u0005\u0003\u0011\n\u00111#T3nG\u0006\u001c\u0007.\u001a3QCJ\fW.\u001a;feN,AA\u0013\u0001\u0001\u0017\nq1+^5uC\ndW\rS3bI\u0016\u0014\bCA\u0007M\u0013\tieBA\u0007SKF,Xm\u001d;IK\u0006$WM\u001d\u0005\t\u001f\u0002A)\u0019!C\u0005!\u0006q\u0011n]*uCR\u001cXI\\1cY\u0016$W#A)\u0011\u0005I\u001bV\"\u0001\u000f\n\u0005Qc\"a\u0002\"p_2,\u0017M\u001c\u0005\t-\u0002A\t\u0011)Q\u0005#\u0006y\u0011n]*uCR\u001cXI\\1cY\u0016$\u0007\u0005C\u0004Y\u0001\t\u0007IQB-\u0002\u0015%t7M]'jgN,7/F\u0001[!\tYf,D\u0001]\u0015\tif&\u0001\u0004bi>l\u0017nY\u0005\u0003?r\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019\t\u0007\u0001)A\u00075\u0006Y\u0011N\\2s\u001b&\u001c8/Z:!\u0011\u001d\u0019\u0007A1A\u0005\u000ee\u000b\u0001\"\u001b8de\"KGo\u001d\u0005\u0007K\u0002\u0001\u000bQ\u0002.\u0002\u0013%t7M\u001d%jiN\u0004\u0003bB4\u0001\u0005\u0004%i!W\u0001\u000bI\u0016\u001c'/T5tg\u0016\u001c\bBB5\u0001A\u00035!,A\u0006eK\u000e\u0014X*[:tKN\u0004\u0003bB6\u0001\u0005\u0004%i!W\u0001\tI\u0016\u001c'\u000fS5ug\"1Q\u000e\u0001Q\u0001\u000ei\u000b\u0011\u0002Z3de\"KGo\u001d\u0011\t\u000f=\u0004!\u0019!C\u00073\u0006I\"/\u001a9mC\u000e,\u0017JZ+o[>$\u0017NZ5fI6K7o]3t\u0011\u0019\t\b\u0001)A\u00075\u0006Q\"/\u001a9mC\u000e,\u0017JZ+o[>$\u0017NZ5fI6K7o]3tA!91\u000f\u0001b\u0001\n\u001bI\u0016a\u0006:fa2\f7-Z%g+:lw\u000eZ5gS\u0016$\u0007*\u001b;t\u0011\u0019)\b\u0001)A\u00075\u0006A\"/\u001a9mC\u000e,\u0017JZ+o[>$\u0017NZ5fI\"KGo\u001d\u0011\t\u000f]\u0004!\u0019!C\u00073\u0006I\"/\u001a9mC\u000e,\u0017JZ+o[>$\u0017NZ5fI\n\u000bGM^1m\u0011\u0019I\b\u0001)A\u00075\u0006Q\"/\u001a9mC\u000e,\u0017JZ+o[>$\u0017NZ5fI\n\u000bGM^1mA!91\u0010\u0001b\u0001\n\u0013\u0001\u0016aB5t)J\f7-\u001a\u0005\u0007{\u0002\u0001\u000b\u0011B)\u0002\u0011%\u001cHK]1dK\u0002B\u0001b \u0001C\u0002\u0013%\u0011\u0011A\u0001\u000bEf$XMQ;gM\u0016\u0014XCAA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005e\u0005\u0011\u0011n\\\u0005\u0005\u0003\u001b\t9AA\u000bCsR,\u0017I\u001d:bs>+H\u000f];u'R\u0014X-Y7\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0007\t1BY=uK\n+hMZ3sA!9\u0011Q\u0003\u0001\u0005B\u0005]\u0011\u0001D2sK\u0006$X\rS3bI\u0016\u0014X#A&\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e\u0005Q!/Z1e\u0011\u0016\fG-\u001a:\u0015\r\u0005}\u0011QEA\u001e!\u0011\u0011\u0016\u0011E)\n\u0007\u0005\rBD\u0001\u0004PaRLwN\u001c\u0005\t\u0003O\tI\u00021\u0001\u0002*\u00051!-\u001e4gKJ\u0004B!a\u000b\u000285\u0011\u0011Q\u0006\u0006\u0005\u0003O\tyC\u0003\u0003\u00022\u0005M\u0012!\u00028fiRL(bAA\u001b\u0011\u0005)!NY8tg&!\u0011\u0011HA\u0017\u00055\u0019\u0005.\u00198oK2\u0014UO\u001a4fe\"9\u0011QHA\r\u0001\u0004Y\u0015A\u00025fC\u0012,'\u000fC\u0004\u0002B\u0001!\t%a\u0011\u0002\u000fI,\u0017\rZ&fsR!\u0011QIA&!\u0015\u0011\u0016q\t\nR\u0013\r\tI\u0005\b\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u00055\u0013q\ba\u0001\u0003S\t\u0011A\u0019\u0005\b\u0003#\u0002A\u0011BA*\u0003!\u0011X-\u00193LKf\u001cH\u0003BA+\u0003G\u0002R!a\u0016\u0002^Iq1\u0001FA-\u0013\r\tY\u0006H\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty&!\u0019\u0003\u0007M+\u0017OC\u0002\u0002\\qA\u0001\"!\u0014\u0002P\u0001\u0007\u0011\u0011\u0006\u0005\b\u0003O\u0002A\u0011KA5\u0003\r9W\r\u001e\u000b\u0005\u0003W\n\t\bE\u0002S\u0003[J1!a\u001c\u001d\u0005\u0019\te.\u001f*fM\"A\u0011qEA3\u0001\u0004\tI\u0003C\u0004\u0002v\u0001!I!a\u001e\u0002\u001d\rDWmY6LKfdUM\\4uQR9!#!\u001f\u0002~\u0005\u0005\u0005bBA>\u0003g\u0002\rAE\u0001\u0002W\"9\u0011qPA:\u0001\u0004\t\u0016aB3oI>3w\n\u001d\u0005\t\u0003\u001b\n\u0019\b1\u0001\u0002*!9\u0011Q\u0011\u0001\u0005B\u0005\u001d\u0015A\u0004:fC\u0012\u0004\u0016M]1nKR,'o\u001d\u000b\u0006#\u0006%\u0015\u0011\u0014\u0005\t\u0003\u0017\u000b\u0019\t1\u0001\u0002\u000e\u0006\u00111\r\u001b\t\u0005\u0003\u001f\u000b)*\u0004\u0002\u0002\u0012*!\u00111SA\u0018\u0003\u001d\u0019\u0007.\u00198oK2LA!a&\u0002\u0012\n91\t[1o]\u0016d\u0007\u0002CA'\u0003\u0007\u0003\r!!\u000b\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \u0006!\"/Z1e%\u0016lwN^3QCJ\fW.\u001a;feN$2ARAQ\u0011!\t\u0019+a'A\u0002\u0005U\u0013\u0001B1sONDq!a*\u0001\t\u0013\tI+\u0001\fsK\u0006$\u0017J\\2s\t\u0016\u001c'\u000fU1sC6,G/\u001a:t)\r1\u00151\u0016\u0005\t\u0003G\u000b)\u000b1\u0001\u0002V!9\u0011q\u0016\u0001\u0005\n\u0005E\u0016A\u0006:fC\u00124E.^:i\u00032d\u0007+\u0019:b[\u0016$XM]:\u0015\u0007\u0019\u000b\u0019\f\u0003\u0005\u0002$\u00065\u0006\u0019AA+\u0011\u001d\t9\f\u0001C\u0005\u0003s\u000bQC]3bIN#xN]1hKB\u000b'/Y7fi\u0016\u00148\u000fF\u0003G\u0003w\u000bi\f\u0003\u0005\u0002$\u0006U\u0006\u0019AA+\u0011!\ti%!.A\u0002\u0005%\u0002bBAa\u0001\u0011E\u00131Y\u0001\ne\u0016\fGMV1mk\u0016$B!!2\u0002LB\u0019!+a2\n\u0007\u0005%GD\u0001\u0003V]&$\b\u0002CA'\u0003\u007f\u0003\r!!\u000b\t\u000f\u0005=\u0007\u0001\"\u0011\u0002R\u0006Y1M]3bi\u00164\u0016\r\\;f)\r\u0001\u00131\u001b\u0005\t\u0003+\fi\r1\u0001\u0002X\u0006Ya.\u001a=u-\u0016\u00148/[8o!\r\u0011\u0016\u0011\\\u0005\u0004\u00037d\"\u0001\u0002'p]\u001eDq!a8\u0001\t\u0013\t\t/\u0001\u0005hKR4E.Y4t)\u0011\t9.a9\t\u000f\u0005\u0015\u0018Q\u001ca\u0001%\u0005)a\r\\1hg\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\u0018aC4fi2Kg-Z:qC:$B!!<\u0002tB\u0019!+a<\n\u0007\u0005EHDA\u0002J]RDq!!>\u0002h\u0002\u0007!#\u0001\u0005mS\u001a,7\u000f]1o\u0011\u001d\tI\u0010\u0001C\u0005\u0003w\f\u0011bZ3u\u0019\u0016tw\r\u001e5\u0015\t\u00055\u0018Q \u0005\b\u0003\u007f\f9\u00101\u0001\u0013\u0003\u0019aWM\\4uQ\"9!1\u0001\u0001\u0005\n\t\u0015\u0011AC4fiZ+'o]5p]R!\u0011q\u001bB\u0004\u0011\u001d\u0011IA!\u0001A\u0002I\tqA^3sg&|g\u000eC\u0004\u0003\u000e\u0001!IAa\u0004\u0002\u0019A\f'o]3O_J+\u0007\u000f\\=\u0015\u000bE\u0013\tB!\u0006\t\u0011\tM!1\u0002a\u0001\u0003[\fQ\"\u001a=qK\u000e$X\rZ%oI\u0016D\b\u0002CAR\u0005\u0017\u0001\r!!\u0016\t\u000f\te\u0001\u0001\"\u0003\u0003\u001c\u00051\u0002/\u0019:tK\u0012+G.Y=fI\u0012+G.\u001a;f)&lW\r\u0006\u0003\u0002n\nu\u0001\u0002CAR\u0005/\u0001\r!!\u0016\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$\u0005Aq-\u001a;DC\u000eDW-\u0006\u0002\u0003&A)qEa\n\u0013A%\u0019!\u0011\u0006\u0004\u0003\u000b\r\u000b7\r[3\t\u000f\t5\u0002\u0001\"\u0015\u00030\u0005\u00112-^:u_6$UmY8eK\"+\u0017\rZ3s)\u0019\tYG!\r\u00034!A\u00111\u0012B\u0016\u0001\u0004\ti\t\u0003\u0005\u0002(\t-\u0002\u0019AA\u0015\u0011\u001d\u00119\u0004\u0001C)\u0005s\tqbY;ti>lG)Z2pI\u0016\\U-\u001f\u000b\u0007\u0003W\u0012YD!\u0010\t\u0011\u0005-%Q\u0007a\u0001\u0003\u001bC\u0001\"a\n\u00036\u0001\u0007\u0011\u0011\u0006\u0005\b\u0005\u0003\u0002A\u0011\u000bB\"\u0003E\u0019Wo\u001d;p[\u0012+7m\u001c3f-\u0006dW/\u001a\u000b\u0007\u0003W\u0012)Ea\u0012\t\u0011\u0005-%q\ba\u0001\u0003\u001bC\u0001\"a\n\u0003@\u0001\u0007\u0011\u0011\u0006\u0005\b\u0005\u0017\u0002A\u0011\u0002B'\u0003!Ign\u0019:EK\u000e\u0014H\u0003BA6\u0005\u001fB\u0001\"a#\u0003J\u0001\u0007\u0011Q\u0012\u0005\b\u0005'\u0002A\u0011\u0002B+\u0003!1G.^:i\u00032dG\u0003CA6\u0005/\u0012IFa\u0017\t\u0011\u00055#\u0011\u000ba\u0001\u0003SA\u0001\"a#\u0003R\u0001\u0007\u0011Q\u0012\u0005\b\u0005;\u0012\t\u00061\u0001R\u00031I7OU3bIB\u000b'/Y7t\u0011\u001d\u0011\t\u0007\u0001C\u0005\u0005G\nQB^1mS\u0012\fG/\u001a#fYR\fG\u0003\u0002B3\u0005W\u0002B!a\u0016\u0003h%!!\u0011NA1\u0005\u0019\u0011\u0015nZ%oi\"9!Q\u000eB0\u0001\u0004\u0011\u0012!\u00023fYR\f\u0007b\u0002B9\u0001\u0011\u0005#1O\u0001\u0016GJ,\u0017\r^3Tk\u000e\u001cWm]:SKN\u0004xN\\:f)\u0011\tYG!\u001e\t\u000f\t]$q\u000ea\u0001A\u0005!\u0001O]3w\u0011\u001d\u0011Y\b\u0001C!\u0005{\n\u0011d\u0019:fCR,gj\u001c;Fq\u0016\u001cW\u000f^3e%\u0016\u001c\bo\u001c8tKR!\u00111\u000eB@\u0011\u001d\u00119H!\u001fA\u0002\u0001BqAa!\u0001\t\u0003\u0012))\u0001\fde\u0016\fG/\u001a(pi\u0016C\u0018n\u001d;SKN\u0004xN\\:f+\t\tY\u0007C\u0004\u0003\n\u0002!\tEa#\u0002#\r\u0014X-\u0019;f\u000f\u0016$(+Z:q_:\u001cX\r\u0006\u0004\u0002l\t5%q\u0012\u0005\b\u0003w\u00129\t1\u0001\u0013\u0011!\u0011\tJa\"A\u0002\tM\u0015!B3oiJL\b\u0003\u0002BK\u0005?k!Aa&\u000b\t\te%1T\u0001\bK:$(/[3t\u0015\r\u0011iJB\u0001\nG>tG/Y5oKJLAA!)\u0003\u0018\nQ1)Y2iK\u0016sGO]=\t\u000f\t\u0015\u0006\u0001\"\u0011\u0003(\u000612M]3bi\u0016lU\u000f\u001c;j\u000f\u0016$(+Z:q_:\u001cX\r\u0006\u0003\u0002l\t%\u0006\u0002\u0003BV\u0005G\u0003\rA!,\u0002\u000bA\f\u0017N]:\u0011\u000bM\u0011yK\u0005\u0011\n\u0007\tEvDA\u0002NCBDqA!.\u0001\t\u0003\u00129,A\nde\u0016\fG/Z#se>\u0014(+Z:q_:\u001cX\r\u0006\u0003\u0002l\te\u0006\u0002\u0003B^\u0005g\u0003\rA!0\u0002\u0003Q\u0004B!a\u0016\u0003@&!!\u0011YA1\u0005%!\u0006N]8xC\ndW\rC\u0004\u0003F\u0002!IAa2\u000211|w-\u00118e\u0007J,\u0017\r^3FeJ|'/T3tg\u0006<W\r\u0006\u0004\u0003J\nU'\u0011\u001c\t\u0005\u0005\u0017\u0014\t.\u0004\u0002\u0003N*\u0019!q\u001a\u001a\u0002\t1\fgnZ\u0005\u0005\u0005'\u0014iMA\u0007TiJLgn\u001a\"vS2$WM\u001d\u0005\t\u0005/\u0014\u0019\r1\u0001\u0003J\u0006\u00111O\u0019\u0005\t\u00057\u0014\u0019\r1\u0001\u0003^\u0006\tQ\u000eE\u0002\"\u0005?L1A!9\u0003\u0005IiU-\\2bG\",G-\u0012=dKB$\u0018n\u001c8\t\u000f\t\u0015\b\u0001\"\u0015\u0003h\u0006)2M]3bi\u0016\u001cVM\u001d<fe\u0016C8-\u001a9uS>tGC\u0002Bu\u0005W\u0014)\u0010\u0005\u0004S\u0003\u000f\u0012i.\u0015\u0005\t\u0005[\u0014\u0019\u000f1\u0001\u0003p\u0006\tQ\r\u0005\u0003\u0002X\tE\u0018\u0002\u0002Bz\u0003C\u0012\u0011\"\u0012=dKB$\u0018n\u001c8\t\u0011\u00055#1\u001da\u0001\u0003SAqA!?\u0001\t\u0013\u0011Y0\u0001\u0007dY>\u001cXm\u00115b]:,G\u000e\u0006\u0003\u0002l\tu\b\u0002CAF\u0005o\u0004\r!!$\t\u000f\r\u0005\u0001\u0001\"\u0011\u0003\u0006\u0006\u00192M]3bi\u0016\u001cF/\u0019;t%\u0016\u001c\bo\u001c8tK\"91Q\u0001\u0001\u0005\n\r\u001d\u0011!\u00032vS2$7\u000b^1u)!\tIc!\u0003\u0004\u000e\r]\u0001bBB\u0006\u0007\u0007\u0001\rAE\u0001\u0005gR\fG\u000f\u0003\u0005\u0004\u0010\r\r\u0001\u0019AB\t\u0003\u00151\u0018\r\\;f!\r\u001161C\u0005\u0004\u0007+a\"aA!os\"A!q[B\u0002\u0001\u0004\u0011I\rC\u0004\u0002P\u0002!Iaa\u0007\u0015\u000f\u0001\u001aib!\f\u00040!A1qDB\r\u0001\u0004\u0019\t#\u0001\u0003eCR\f\u0007#\u0002*\u0004$\r\u001d\u0012bAB\u00139\t)\u0011I\u001d:bsB\u0019!k!\u000b\n\u0007\r-BD\u0001\u0003CsR,\u0007\u0002CAk\u00073\u0001\r!a6\t\u0011\u0005\u00158\u0011\u0004a\u0001\u0003/Dqaa\r\u0001\t\u0013\u0019)$\u0001\tck&dGmR3u%\u0016\u001c\bo\u001c8tKRA\u0011\u0011FB\u001c\u0007\u000f\u001aI\u0005\u0003\u0005\u0004:\rE\u0002\u0019AB\u001e\u0003\ty\u0007\u000f\u0005\u0003\u0004>\r\r\u0003c\u0001*\u0004@%\u00191\u0011\t\u000f\u0003\u0017\u0015sW/\\3sCRLwN\\\u0005\u0005\u0007\u000b\u001ayDA\u0003WC2,X\rC\u0004\u0002|\rE\u0002\u0019\u0001\n\t\u000f\r-3\u0011\u0007a\u0001A\u0005\ta\u000fC\u0004\u0004P\u0001!Ia!\u0015\u0002-\t,\u0018\u000e\u001c3TS:<G.Z$fiJ+7\u000f]8og\u0016$b!!\u000b\u0004T\rU\u0003bBA>\u0007\u001b\u0002\rA\u0005\u0005\b\u0007\u0017\u001ai\u00051\u0001!\u0011\u001d\u0019I\u0006\u0001C\u0005\u00077\n1CY;jY\u0012<U\r\u001e%fC\u0012,'OQ3hS:$\u0002\"!\u000b\u0004^\r}3\u0011\r\u0005\b\u0003w\u001a9\u00061\u0001\u0013\u0011\u001d\u0019Yea\u0016A\u0002\u0001B\u0001ba\u0019\u0004X\u0001\u0007\u0011Q^\u0001\u000bKb$(/Y*qC\u000e,\u0007bBB4\u0001\u0011%1\u0011N\u0001\u0013oJLG/Z$fi\"+\u0017\rZ3s\t\u0006$\u0018\r\u0006\u0004\u0002*\r-4Q\u000e\u0005\t\u0007?\u0019)\u00071\u0001\u0004\"!A1qNB3\u0001\u0004\tI#A\u0002ck\u001aDqaa\u001d\u0001\t\u0013\u0019)(A\txe&$XmR3u\u0011\u0016\fG-\u001a:F]\u0012$B!!\u000b\u0004x!A1qNB9\u0001\u0004\tI\u0003C\u0004\u0004|\u0001!Ia! \u0002C\t,\u0018\u000e\u001c3TS:<G.Z$fi^KG\u000f\u001b,feNLwN\u001c*fgB|gn]3\u0015\r\u0005%2qPBA\u0011\u001d\tYh!\u001fA\u0002IA\u0001B!%\u0004z\u0001\u0007!1\u0013\u0005\b\u0007\u000b\u0003A\u0011BBD\u0003M1'/[3oI2LX*\u0019=J]R\u001c\u0005.Z2l)\u0019\tio!#\u0004\u000e\"911RBB\u0001\u0004\u0011\u0012A\u00028v[\n,'\u000fC\u0004\u0004\u0010\u000e\r\u0005\u0019\u0001\n\u0002\u000f5,7o]1hK\"911\u0013\u0001\u0005\n\rU\u0015!\u00058v[\u0016\u0014\u0018n\u0019'j[&$8\t[3dWRQ\u0011Q^BL\u00073\u001bija(\t\u000f\r-5\u0011\u0013a\u0001%!A11TBI\u0001\u0004\t9.\u0001\u0005nCb4\u0016\r\\;f\u0011\u001d\u0019yi!%A\u0002IA\u0001b!)\u0004\u0012\u0002\u000711U\u0001\u0002]B!\u0011qKBS\u0013\u0011\u00199+!\u0019\u0003+9+XNY3s\r>\u0014X.\u0019;Fq\u000e,\u0007\u000f^5p]\"911\u0013\u0001\u0005\n\r-F\u0003CAl\u0007[\u001byk!-\t\u000f\r-5\u0011\u0016a\u0001%!A11TBU\u0001\u0004\t9\u000eC\u0004\u0004\u0010\u000e%\u0006\u0019\u0001\n")
public class MemcachedDecoder
extends AbstractProtocolDecoder<String, MemcachedValue> {
    private final ScheduledExecutorService scheduler;
    private final NettyTransport transport;
    private boolean isStatsEnabled;
    private final AtomicLong incrMisses;
    private final AtomicLong incrHits;
    private final AtomicLong decrMisses;
    private final AtomicLong decrHits;
    private final AtomicLong replaceIfUnmodifiedMisses;
    private final AtomicLong replaceIfUnmodifiedHits;
    private final AtomicLong replaceIfUnmodifiedBadval;
    private final boolean isTrace;
    private final ByteArrayOutputStream byteBuffer;
    private volatile boolean bitmap$0;

    private boolean isStatsEnabled$lzycompute() {
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if (!this.bitmap$0) {
                this.isStatsEnabled = this.cache().getCacheConfiguration().jmxStatistics().enabled();
                this.bitmap$0 = true;
            }
            return this.isStatsEnabled;
        }
    }

    private boolean isStatsEnabled() {
        return this.bitmap$0 ? this.isStatsEnabled : this.isStatsEnabled$lzycompute();
    }

    private final AtomicLong incrMisses() {
        return this.incrMisses;
    }

    private final AtomicLong incrHits() {
        return this.incrHits;
    }

    private final AtomicLong decrMisses() {
        return this.decrMisses;
    }

    private final AtomicLong decrHits() {
        return this.decrHits;
    }

    private final AtomicLong replaceIfUnmodifiedMisses() {
        return this.replaceIfUnmodifiedMisses;
    }

    private final AtomicLong replaceIfUnmodifiedHits() {
        return this.replaceIfUnmodifiedHits;
    }

    private final AtomicLong replaceIfUnmodifiedBadval() {
        return this.replaceIfUnmodifiedBadval;
    }

    private boolean isTrace() {
        return this.isTrace;
    }

    private ByteArrayOutputStream byteBuffer() {
        return this.byteBuffer;
    }

    public RequestHeader createHeader() {
        return new RequestHeader();
    }

    public Option<Object> readHeader(ChannelBuffer buffer, RequestHeader header) {
        Enumeration.Value op;
        boolean endOfOp = TextProtocolUtil$.MODULE$.readElement(buffer, this.byteBuffer());
        String streamOp = TextProtocolUtil$.MODULE$.extractString(this.byteBuffer());
        Enumeration.Value value = op = RequestResolver$.MODULE$.toRequest(streamOp, endOfOp, buffer);
        Enumeration.Value value2 = Operation$.MODULE$.StatsRequest();
        if (!(value != null ? !value.equals(value2) : value2 != null) && !endOfOp) {
            String line = TextProtocolUtil$.MODULE$.readDiscardedLine(buffer).trim();
            if (line.isEmpty()) {
                endOfOp = true;
            } else {
                throw new StreamCorruptedException(new StringBuilder().append((Object)"Stats command does not accept arguments: ").append((Object)line).toString());
            }
        }
        Enumeration.Value value3 = op;
        Enumeration.Value value4 = MemcachedOperation$.MODULE$.VerbosityRequest();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            if (!endOfOp) {
                TextProtocolUtil$.MODULE$.skipLine(buffer);
            }
            throw new StreamCorruptedException("Memcached 'verbosity' command is unsupported");
        }
        header.op_$eq(op);
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    public Tuple2<String, Object> readKey(ChannelBuffer b) {
        boolean endOfOp = TextProtocolUtil$.MODULE$.readElement(b, this.byteBuffer());
        String k = TextProtocolUtil$.MODULE$.extractString(this.byteBuffer());
        this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, endOfOp, b);
        return new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    private Seq<String> readKeys(ChannelBuffer b) {
        return TextProtocolUtil$.MODULE$.readSplitLine(b);
    }

    public Object get(ChannelBuffer buffer) {
        Object object;
        Seq<String> keys = this.readKeys(buffer);
        if (keys.length() > 1) {
            scala.collection.mutable.HashMap map = new scala.collection.mutable.HashMap();
            keys.foreach((Function1)new Serializable(this, buffer, map){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemcachedDecoder $outer;
                private final ChannelBuffer buffer$1;
                private final scala.collection.mutable.HashMap map$1;

                public final Object apply(String k) {
                    MemcachedValue v = (MemcachedValue)((Object)this.$outer.cache().get((Object)this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, true, this.buffer$1)));
                    return v == null ? BoxedUnit.UNIT : this.map$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)k), (Object)((Object)v)));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.buffer$1 = buffer$1;
                    this.map$1 = map$1;
                }
            });
            object = this.createMultiGetResponse((Map<String, MemcachedValue>)new HashMap().$plus$plus((GenTraversableOnce)map));
        } else {
            String key = this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength((String)keys.apply(0), true, buffer);
            CacheEntry entry = this.cache().getCacheEntry((Object)key);
            object = this.createGetResponse(key, entry);
        }
        return object;
    }

    public String org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(String k, boolean endOfOp, ChannelBuffer b) {
        if (k.length() > 250) {
            if (!endOfOp) {
                TextProtocolUtil$.MODULE$.skipLine(b);
            }
            throw new StreamCorruptedException("Key length over the 250 character limit");
        }
        return k;
    }

    public boolean readParameters(Channel ch, ChannelBuffer b) {
        MemcachedParameters memcachedParameters;
        Seq<String> args = TextProtocolUtil$.MODULE$.readSplitLine(b);
        BooleanRef endOfOp = new BooleanRef(false);
        if (args.isEmpty()) {
            memcachedParameters = null;
        } else {
            if (this.isTrace()) {
                this.trace((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Operation parameters: %s";
                    }
                }, args);
            }
            memcachedParameters = this.liftedTree1$1(b, args, endOfOp);
        }
        this.params_$eq(memcachedParameters);
        return endOfOp.elem;
    }

    private MemcachedParameters readRemoveParameters(Seq<String> args) {
        int delayedDeleteTime = this.parseDelayedDeleteTime(args);
        boolean noReply = delayedDeleteTime == -1 ? this.parseNoReply(0, args) : false;
        return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", 0);
    }

    private MemcachedParameters readIncrDecrParameters(Seq<String> args) {
        String delta = (String)args.apply(0);
        return new MemcachedParameters(-1, -1, -1, -1L, this.parseNoReply(1, args), 0L, delta, 0);
    }

    private MemcachedParameters readFlushAllParameters(Seq<String> args) {
        NumberFormatException numberFormatException2;
        block2: {
            int n;
            boolean noReplyFound = false;
            try {
                n = this.friendlyMaxIntCheck((String)args.apply(0), "Flush delay");
            }
            catch (NumberFormatException numberFormatException2) {
                if (!numberFormatException2.getMessage().contains("noreply")) break block2;
                noReplyFound = true;
                n = 0;
            }
            int flushDelay = n;
            boolean noReply = noReplyFound ? true : this.parseNoReply(1, args);
            return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", flushDelay);
        }
        throw numberFormatException2;
    }

    private MemcachedParameters readStorageParameters(Seq<String> args, ChannelBuffer b) {
        long l;
        int length;
        int streamLifespan;
        int index = 0;
        long flags = this.getFlags((String)args.apply(index));
        if (flags < 0L) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Flags cannot be negative: ").append((Object)BoxesRunTime.boxToLong((long)flags)).toString());
        }
        int lifespan = (streamLifespan = this.getLifespan((String)args.apply(++index))) <= 0 ? -1 : streamLifespan;
        if ((length = this.getLength((String)args.apply(++index))) < 0) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Negative bytes length provided: ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString());
        }
        Enumeration.Value value = this.header().op();
        Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Enumeration.Value x2 = value;
            l = this.getVersion((String)args.apply(++index));
        } else {
            l = -1L;
        }
        long streamVersion = l;
        boolean noReply = this.parseNoReply(++index, args);
        return new MemcachedParameters(length, lifespan, -1, streamVersion, noReply, flags, "", 0);
    }

    public void readValue(ChannelBuffer b) {
        b.readBytes(this.rawValue());
        TextProtocolUtil$.MODULE$.skipLine(b);
    }

    public MemcachedValue createValue(long nextVersion) {
        return new MemcachedValue(this.rawValue(), nextVersion, ((MemcachedParameters)this.params()).flags());
    }

    private long getFlags(String flags) {
        long l;
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        try {
            l = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags");
        }
        catch (NumberFormatException numberFormatException) {
            l = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags", numberFormatException);
        }
        return l;
    }

    private int getLifespan(String lifespan) {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return this.friendlyMaxIntCheck(lifespan, "Lifespan");
    }

    private int getLength(String length) {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return this.friendlyMaxIntCheck(length, "The number of bytes");
    }

    private long getVersion(String version) {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return new StringOps(Predef$.MODULE$.augmentString(version)).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNoReply(int expectedIndex, Seq<String> args) {
        if (args.length() <= expectedIndex) return false;
        Object object = args.apply(expectedIndex);
        if ("noreply" != null) {
            if (!"noreply".equals(object)) throw new StreamCorruptedException("Unable to parse noreply optional argument");
            return true;
        }
        if (object == null) return true;
        throw new StreamCorruptedException("Unable to parse noreply optional argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDelayedDeleteTime(Seq<String> args) {
        int n;
        if (args.length() <= 0) return 0;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString((String)args.apply(0))).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public Cache<String, MemcachedValue> getCache() {
        return this.cache();
    }

    public Object customDecodeHeader(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        value = this.header().op();
                        Enumeration.Value value2 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        Enumeration.Value x2 = value;
                        object = this.flushAll(buffer, ch, false);
                        break block3;
                    }
                    Enumeration.Value value4 = MemcachedOperation$.MODULE$.VersionRequest();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    Enumeration.Value x3 = value;
                    java.lang.StringBuilder ret = new java.lang.StringBuilder().append("VERSION ").append(Version.VERSION).append(TextProtocolUtil$.MODULE$.CRLF());
                    object = this.writeResponse(ch, ret);
                    break block3;
                }
                Enumeration.Value value6 = MemcachedOperation$.MODULE$.QuitRequest();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                Enumeration.Value x4 = value;
                object = this.closeChannel(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeKey(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block13: {
            Object object;
            block12: {
                block11: {
                    boolean bl;
                    value = this.header().op();
                    Enumeration.Value value2 = MemcachedOperation$.MODULE$.AppendRequest();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        Enumeration.Value x2 = value;
                        bl = true;
                    } else {
                        Enumeration.Value value4 = MemcachedOperation$.MODULE$.PrependRequest();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            Enumeration.Value x3 = value;
                            bl = true;
                        } else {
                            Enumeration.Value value6 = MemcachedOperation$.MODULE$.IncrementRequest();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                Enumeration.Value x4 = value;
                                bl = true;
                            } else {
                                Enumeration.Value value8 = MemcachedOperation$.MODULE$.DecrementRequest();
                                Enumeration.Value value9 = value;
                                if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                    Enumeration.Value x5 = value;
                                    bl = true;
                                } else {
                                    bl = false;
                                }
                            }
                        }
                    }
                    if (!bl) break block11;
                    this.key_$eq(this.readKey(buffer)._1());
                    object = this.checkpointTo(DecoderState.DECODE_PARAMETERS);
                    break block12;
                }
                Enumeration.Value value10 = MemcachedOperation$.MODULE$.FlushAllRequest();
                Enumeration.Value value11 = value;
                if (value10 != null ? !value10.equals(value11) : value11 != null) break block13;
                Enumeration.Value x6 = value;
                object = this.flushAll(buffer, ch, true);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeValue(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block21: {
            Object object;
            block20: {
                boolean bl;
                block14: {
                    Enumeration.Value value2;
                    block19: {
                        Object object2;
                        block16: {
                            byte[] byArray;
                            MemcachedValue prev;
                            block18: {
                                block17: {
                                    block15: {
                                        boolean bl2;
                                        Enumeration.Value op;
                                        value = op = this.header().op();
                                        Enumeration.Value value3 = MemcachedOperation$.MODULE$.AppendRequest();
                                        Enumeration.Value value4 = value;
                                        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                                            Enumeration.Value x2 = value;
                                            bl2 = true;
                                        } else {
                                            Enumeration.Value value5 = MemcachedOperation$.MODULE$.PrependRequest();
                                            Enumeration.Value value6 = value;
                                            if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                                                Enumeration.Value x3 = value;
                                                bl2 = true;
                                            } else {
                                                bl2 = false;
                                            }
                                        }
                                        if (!bl2) break block14;
                                        this.readValue(buffer);
                                        prev = (MemcachedValue)((Object)this.cache().get(this.key()));
                                        if (prev != null) break block15;
                                        object2 = ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_STORED();
                                        break block16;
                                    }
                                    value2 = this.header().op();
                                    Enumeration.Value value7 = MemcachedOperation$.MODULE$.AppendRequest();
                                    Enumeration.Value value8 = value2;
                                    if (value7 != null ? !value7.equals(value8) : value8 != null) break block17;
                                    Enumeration.Value x2 = value2;
                                    byArray = TextProtocolUtil$.MODULE$.concat(prev.data(), this.rawValue());
                                    break block18;
                                }
                                Enumeration.Value value9 = MemcachedOperation$.MODULE$.PrependRequest();
                                Enumeration.Value value10 = value2;
                                if (value9 != null ? !value9.equals(value10) : value10 != null) break block19;
                                Enumeration.Value x3 = value2;
                                byArray = TextProtocolUtil$.MODULE$.concat(this.rawValue(), prev.data());
                            }
                            byte[] concatenated = byArray;
                            MemcachedValue next = this.createValue(concatenated, this.generateVersion((Cache)this.cache()), ((MemcachedParameters)this.params()).flags());
                            boolean replaced = this.cache().replace(this.key(), (Object)prev, (Object)next);
                            object2 = replaced ? (Object)(((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.STORED()) : (Object)(((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_STORED());
                        }
                        byte[] ret = object2;
                        object = this.writeResponse(ch, ret);
                        break block20;
                    }
                    throw new MatchError((Object)value2);
                }
                Enumeration.Value value11 = MemcachedOperation$.MODULE$.IncrementRequest();
                Enumeration.Value value12 = value;
                if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                    Enumeration.Value x4 = value;
                    bl = true;
                } else {
                    Enumeration.Value value13 = MemcachedOperation$.MODULE$.DecrementRequest();
                    Enumeration.Value value14 = value;
                    if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                        Enumeration.Value x5 = value;
                        bl = true;
                    } else {
                        bl = false;
                    }
                }
                if (!bl) break block21;
                object = this.incrDecr(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    private Object incrDecr(Channel ch) {
        Enumeration.Value value;
        block9: {
            BigInt prevCounter;
            block10: {
                Object object;
                block6: {
                    Object object2;
                    Enumeration.Value op;
                    MemcachedValue prev;
                    block8: {
                        BigInt delta;
                        block7: {
                            block5: {
                                Object object3;
                                prev = (MemcachedValue)((Object)this.cache().get(this.key()));
                                op = this.header().op();
                                if (prev != null) break block5;
                                if (this.isStatsEnabled()) {
                                    Enumeration.Value value2 = op;
                                    Enumeration.Value value3 = MemcachedOperation$.MODULE$.IncrementRequest();
                                    object3 = BoxesRunTime.boxToLong((long)(!(value2 != null ? !value2.equals(value3) : value3 != null) ? this.incrMisses().incrementAndGet() : this.decrMisses().incrementAndGet()));
                                } else {
                                    object3 = BoxedUnit.UNIT;
                                }
                                object = ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_FOUND();
                                break block6;
                            }
                            prevCounter = package$.MODULE$.BigInt().apply(new String(prev.data()));
                            delta = this.validateDelta(((MemcachedParameters)this.params()).delta());
                            value = op;
                            Enumeration.Value value4 = MemcachedOperation$.MODULE$.IncrementRequest();
                            Enumeration.Value value5 = value;
                            if (value4 != null ? !value4.equals(value5) : value5 != null) break block7;
                            Enumeration.Value x2 = value;
                            BigInt candidateCounter = prevCounter.$plus(delta);
                            object2 = candidateCounter.$greater(TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG()) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                            break block8;
                        }
                        Enumeration.Value value6 = MemcachedOperation$.MODULE$.DecrementRequest();
                        Enumeration.Value value7 = value;
                        if (value6 != null ? !value6.equals(value7) : value7 != null) break block9;
                        Enumeration.Value x3 = value;
                        BigInt candidateCounter = prevCounter.$minus(delta);
                        object2 = candidateCounter.$less(BigInt$.MODULE$.int2bigInt(0)) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
                    }
                    Object newCounter = object2;
                    MemcachedValue next = this.createValue(newCounter.toString().getBytes(), this.generateVersion((Cache)this.cache()), ((MemcachedParameters)this.params()).flags());
                    boolean replaced = this.cache().replace(this.key(), (Object)prev, (Object)next);
                    if (replaced) {
                        Object object4;
                        if (this.isStatsEnabled()) {
                            Enumeration.Value value8 = op;
                            Enumeration.Value value9 = MemcachedOperation$.MODULE$.IncrementRequest();
                            object4 = BoxesRunTime.boxToLong((long)(!(value8 != null ? !value8.equals(value9) : value9 != null) ? this.incrHits().incrementAndGet() : this.decrHits().incrementAndGet()));
                        } else {
                            object4 = BoxedUnit.UNIT;
                        }
                        object = ((MemcachedParameters)this.params()).noReply() ? null : (Object)new StringBuilder().append((Object)new String(next.data())).append((Object)TextProtocolUtil$.MODULE$.CRLF()).toString();
                    }
                    break block10;
                }
                byte[] ret = object;
                return this.writeResponse(ch, ret);
            }
            throw new CacheException(new StringBuilder().append((Object)"Value modified since we retrieved from the cache, old value was ").append((Object)prevCounter).toString());
        }
        throw new MatchError((Object)value);
    }

    private Object flushAll(ChannelBuffer b, Channel ch, boolean isReadParams) {
        Object object = isReadParams ? BoxesRunTime.boxToBoolean((boolean)this.readParameters(ch, b)) : BoxedUnit.UNIT;
        Serializable flushFunction = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AdvancedCache<String, MemcachedValue> cache) {
                cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_STORE}).clear();
            }
        };
        int flushDelay = this.params() == null ? 0 : ((MemcachedParameters)this.params()).flushDelay();
        ScheduledFuture<?> scheduledFuture = flushDelay == 0 ? flushFunction.apply((Object)this.cache().getAdvancedCache()) : this.scheduler.schedule(new DelayedFlushAll((Cache<String, MemcachedValue>)this.cache(), (Function1<AdvancedCache<String, MemcachedValue>, BoxedUnit>)flushFunction), this.toMillis(flushDelay), TimeUnit.MILLISECONDS);
        byte[] ret = (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.OK());
        return this.writeResponse(ch, ret);
    }

    /*
     * WARNING - void declaration
     */
    private BigInt validateDelta(String delta) {
        void var2_2;
        BigInt bigIntDelta = package$.MODULE$.BigInt().apply(delta);
        if (bigIntDelta.$greater(TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta sent (").append((Object)delta).append((Object)") exceeds unsigned limit (").append((Object)TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG()).append((Object)")").toString());
        }
        if (bigIntDelta.$less(TextProtocolUtil$.MODULE$.MIN_UNSIGNED())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta cannot be negative: ").append((Object)delta).toString());
        }
        return var2_2;
    }

    public Object createSuccessResponse(MemcachedValue prev) {
        byte[] byArray;
        BoxedUnit boxedUnit;
        if (this.isStatsEnabled()) {
            Object object;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                object = BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedHits().incrementAndGet());
            } else {
                object = BoxedUnit.UNIT;
            }
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            byte[] byArray2;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.RemoveRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Enumeration.Value x2 = value;
                byArray2 = TextProtocolUtil$.MODULE$.DELETED();
            } else {
                byArray2 = TextProtocolUtil$.MODULE$.STORED();
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public Object createNotExecutedResponse(MemcachedValue prev) {
        byte[] byArray;
        BoxedUnit boxedUnit;
        if (this.isStatsEnabled()) {
            Object object;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                object = BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedBadval().incrementAndGet());
            } else {
                object = BoxedUnit.UNIT;
            }
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            byte[] byArray2;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Enumeration.Value x2 = value;
                byArray2 = TextProtocolUtil$.MODULE$.EXISTS();
            } else {
                byArray2 = TextProtocolUtil$.MODULE$.NOT_STORED();
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public Object createNotExistResponse() {
        BoxedUnit boxedUnit;
        if (this.isStatsEnabled()) {
            Object object;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                object = BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedMisses().incrementAndGet());
            } else {
                object = BoxedUnit.UNIT;
            }
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_FOUND());
    }

    public Object createGetResponse(String k, CacheEntry entry) {
        Enumeration.Value value;
        block6: {
            Object object;
            block3: {
                ChannelBuffer channelBuffer;
                block5: {
                    block4: {
                        block2: {
                            if (entry != null) break block2;
                            object = TextProtocolUtil$.MODULE$.END();
                            break block3;
                        }
                        value = this.header().op();
                        Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block4;
                        Enumeration.Value x2 = value;
                        channelBuffer = this.buildSingleGetResponse(k, (MemcachedValue)((Object)entry.getValue()));
                        break block5;
                    }
                    Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block6;
                    Enumeration.Value x3 = value;
                    channelBuffer = this.buildSingleGetWithVersionResponse(k, entry);
                }
                object = channelBuffer;
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object createMultiGetResponse(Map<String, MemcachedValue> pairs) {
        boolean bl;
        Enumeration.Value op;
        ListBuffer elements = new ListBuffer();
        Enumeration.Value value = op = this.header().op();
        Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Enumeration.Value x2 = value;
            bl = true;
        } else {
            Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Enumeration.Value x3 = value;
                bl = true;
            } else {
                bl = false;
            }
        }
        if (bl) {
            pairs.foreach((Function1)new Serializable(this, elements, op){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemcachedDecoder $outer;
                private final ListBuffer elements$1;
                private final Enumeration.Value op$1;

                public final ListBuffer<ChannelBuffer> apply(Tuple2<String, MemcachedValue> x$1) {
                    Tuple2<String, MemcachedValue> tuple2 = x$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        MemcachedValue v = (MemcachedValue)((Object)tuple2._2());
                        ListBuffer listBuffer = this.elements$1.$plus$eq((Object)this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(this.op$1, k, v));
                        return listBuffer;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.elements$1 = elements$1;
                    this.op$1 = op$1;
                }
            });
            ListBuffer listBuffer = elements.$plus$eq((Object)ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{TextProtocolUtil$.MODULE$.END()})));
            return elements.toArray(ClassTag$.MODULE$.apply(ChannelBuffer.class));
        }
        throw new MatchError((Object)value);
    }

    public Object createErrorResponse(Throwable t) {
        Object object;
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        Throwable throwable = t;
        if (throwable instanceof MemcachedException) {
            Object object2;
            MemcachedException x2 = (MemcachedException)throwable;
            Throwable throwable2 = x2.getCause();
            if (throwable2 instanceof UnknownOperationException) {
                UnknownOperationException x22 = (UnknownOperationException)throwable2;
                this.logExceptionReported((Throwable)x22);
                object2 = TextProtocolUtil$.MODULE$.ERROR();
            } else if (throwable2 instanceof ClosedChannelException) {
                ClosedChannelException x3 = (ClosedChannelException)throwable2;
                this.logExceptionReported(x3);
                object2 = null;
            } else if (throwable2 instanceof IOException) {
                IOException x4 = (IOException)throwable2;
                object2 = this.logAndCreateErrorMessage(sb, x2);
            } else if (throwable2 instanceof NumberFormatException) {
                NumberFormatException x5 = (NumberFormatException)throwable2;
                object2 = this.logAndCreateErrorMessage(sb, x2);
            } else if (throwable2 instanceof IllegalStateException) {
                IllegalStateException x6 = (IllegalStateException)throwable2;
                object2 = this.logAndCreateErrorMessage(sb, x2);
            } else {
                object2 = sb.append(x2.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
            }
            object = object2;
        } else if (throwable instanceof ClosedChannelException) {
            ClosedChannelException x3 = (ClosedChannelException)throwable;
            this.logExceptionReported(x3);
            object = null;
        } else {
            object = sb.append(TextProtocolUtil$.MODULE$.SERVER_ERROR()).append(t.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
        }
        return object;
    }

    private java.lang.StringBuilder logAndCreateErrorMessage(java.lang.StringBuilder sb, MemcachedException m) {
        this.logExceptionReported(m.getCause());
        return sb.append(m.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
    }

    public Tuple2<MemcachedException, Object> createServerException(Exception e, ChannelBuffer b) {
        Tuple2 tuple2;
        Exception exception = e;
        if (exception instanceof IOException) {
            IOException x2 = (IOException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.CLIENT_ERROR_BAD_FORMAT()).append((Object)x2.getMessage()).toString(), x2), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (exception instanceof NumberFormatException) {
            NumberFormatException x3 = (NumberFormatException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.CLIENT_ERROR_BAD_FORMAT()).append((Object)x3.getMessage()).toString(), x3), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.SERVER_ERROR()).append((Object)e).toString(), e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple2;
    }

    private Object closeChannel(Channel ch) {
        ch.close();
        return null;
    }

    public Object createStatsResponse() {
        Stats stats = this.cache().getAdvancedCache().getStats();
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        return new ChannelBuffer[]{this.buildStat("pid", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("time", BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())), sb), this.buildStat("version", this.cache().getVersion(), sb), this.buildStat("pointer_size", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_user", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_system", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_items", BoxesRunTime.boxToInteger((int)stats.getCurrentNumberOfEntries()), sb), this.buildStat("total_items", BoxesRunTime.boxToLong((long)stats.getTotalNumberOfEntries()), sb), this.buildStat("bytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("total_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("connection_structures", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("cmd_get", BoxesRunTime.boxToLong((long)stats.getRetrievals()), sb), this.buildStat("cmd_set", BoxesRunTime.boxToLong((long)stats.getStores()), sb), this.buildStat("get_hits", BoxesRunTime.boxToLong((long)stats.getHits()), sb), this.buildStat("get_misses", BoxesRunTime.boxToLong((long)stats.getMisses()), sb), this.buildStat("delete_misses", BoxesRunTime.boxToLong((long)stats.getRemoveMisses()), sb), this.buildStat("delete_hits", BoxesRunTime.boxToLong((long)stats.getRemoveHits()), sb), this.buildStat("incr_misses", this.incrMisses(), sb), this.buildStat("incr_hits", this.incrHits(), sb), this.buildStat("decr_misses", this.decrMisses(), sb), this.buildStat("decr_hits", this.decrHits(), sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses(), sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits(), sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval(), sb), this.buildStat("auth_cmds", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("auth_errors", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("evictions", BoxesRunTime.boxToLong((long)stats.getEvictions()), sb), this.buildStat("bytes_read", this.transport.getTotalBytesRead(), sb), this.buildStat("bytes_written", this.transport.getTotalBytesWritten(), sb), this.buildStat("limit_maxbytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("threads", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("conn_yields", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("reclaimed", BoxesRunTime.boxToInteger((int)0), sb), ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{TextProtocolUtil$.MODULE$.END()}))};
    }

    private ChannelBuffer buildStat(String stat, Object value, java.lang.StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append(TextProtocolUtil$.MODULE$.CRLF());
        ChannelBuffer buffer = ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sb.toString().getBytes()}));
        sb.setLength(0);
        return buffer;
    }

    private MemcachedValue createValue(byte[] data, long nextVersion, long flags) {
        return new MemcachedValue(data, nextVersion, flags);
    }

    public ChannelBuffer org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(Enumeration.Value op, String k, MemcachedValue v) {
        ChannelBuffer buf = this.buildGetHeaderBegin(k, v, 0);
        return this.writeGetHeaderData(v.data(), buf);
    }

    private ChannelBuffer buildSingleGetResponse(String k, MemcachedValue v) {
        ChannelBuffer buf = this.buildGetHeaderBegin(k, v, TextProtocolUtil$.MODULE$.END_SIZE());
        this.writeGetHeaderData(v.data(), buf);
        return this.writeGetHeaderEnd(buf);
    }

    private ChannelBuffer buildGetHeaderBegin(String k, MemcachedValue v, int extraSpace) {
        byte[] data = v.data();
        byte[] dataSize = Integer.valueOf(data.length).toString().getBytes();
        byte[] key = k.getBytes();
        byte[] flags = v.flags() != 0L ? Long.valueOf(v.flags()).toString().getBytes() : TextProtocolUtil$.MODULE$.ZERO();
        int flagsSize = flags.length;
        ChannelBuffer buf = ExtendedChannelBuffer$.MODULE$.buffer(TextProtocolUtil$.MODULE$.VALUE_SIZE() + key.length + data.length + flagsSize + dataSize.length + 6 + extraSpace);
        buf.writeBytes(TextProtocolUtil$.MODULE$.VALUE());
        buf.writeBytes(key);
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(flags);
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(dataSize);
        return buf;
    }

    private ChannelBuffer writeGetHeaderData(byte[] data, ChannelBuffer buf) {
        buf.writeBytes(TextProtocolUtil$.MODULE$.CRLFBytes());
        buf.writeBytes(data);
        buf.writeBytes(TextProtocolUtil$.MODULE$.CRLFBytes());
        return buf;
    }

    private ChannelBuffer writeGetHeaderEnd(ChannelBuffer buf) {
        buf.writeBytes(TextProtocolUtil$.MODULE$.END());
        return buf;
    }

    private ChannelBuffer buildSingleGetWithVersionResponse(String k, CacheEntry entry) {
        MemcachedValue v = (MemcachedValue)((Object)entry.getValue());
        byte[] version = ((Object)BoxesRunTime.boxToLong((long)((ServerEntryVersion)entry.getVersion()).version())).toString().getBytes();
        ChannelBuffer buf = this.buildGetHeaderBegin(k, v, version.length + 1 + TextProtocolUtil$.MODULE$.END_SIZE());
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(version);
        this.writeGetHeaderData(v.data(), buf);
        return this.writeGetHeaderEnd(buf);
    }

    private int friendlyMaxIntCheck(String number, String message) {
        int n;
        try {
            n = Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            n = this.numericLimitCheck(number, Integer.MAX_VALUE, message, numberFormatException);
        }
        return n;
    }

    private int numericLimitCheck(String number, long maxValue, String message, NumberFormatException n) {
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        throw n;
    }

    private long numericLimitCheck(String number, long maxValue, String message) {
        long numeric = Long.parseLong(number);
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        return numeric;
    }

    private final MemcachedParameters liftedTree1$1(ChannelBuffer b$1, Seq args$1, BooleanRef endOfOp$1) {
        try {
            MemcachedParameters memcachedParameters;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.PutRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                memcachedParameters = this.readStorageParameters((Seq<String>)args$1, b$1);
            } else {
                Enumeration.Value value4 = Operation$.MODULE$.RemoveRequest();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    Enumeration.Value x3 = value;
                    memcachedParameters = this.readRemoveParameters((Seq<String>)args$1);
                } else {
                    boolean bl;
                    Enumeration.Value value6 = MemcachedOperation$.MODULE$.IncrementRequest();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        Enumeration.Value x4 = value;
                        bl = true;
                    } else {
                        Enumeration.Value value8 = MemcachedOperation$.MODULE$.DecrementRequest();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            Enumeration.Value x5 = value;
                            bl = true;
                        } else {
                            bl = false;
                        }
                    }
                    if (bl) {
                        endOfOp$1.elem = true;
                        memcachedParameters = this.readIncrDecrParameters((Seq<String>)args$1);
                    } else {
                        Enumeration.Value value10 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            Enumeration.Value x6 = value;
                            memcachedParameters = this.readFlushAllParameters((Seq<String>)args$1);
                        } else {
                            memcachedParameters = this.readStorageParameters((Seq<String>)args$1, b$1);
                        }
                    }
                }
            }
            return memcachedParameters;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException(new StringBuilder().append((Object)"Missing content in command line ").append((Object)args$1).toString());
        }
    }

    public MemcachedDecoder(AdvancedCache<String, MemcachedValue> memcachedCache, ScheduledExecutorService scheduler, NettyTransport transport) {
        this.scheduler = scheduler;
        this.transport = transport;
        super(transport);
        this.cache_$eq(memcachedCache);
        this.incrMisses = new AtomicLong(0L);
        this.incrHits = new AtomicLong(0L);
        this.decrMisses = new AtomicLong(0L);
        this.decrHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedMisses = new AtomicLong(0L);
        this.replaceIfUnmodifiedHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedBadval = new AtomicLong(0L);
        this.isTrace = this.isTraceEnabled();
        this.byteBuffer = new ByteArrayOutputStream();
    }
}

