/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.Version;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.DecoderState;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.RequestHeader;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ExtendedChannelBuffer$;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.memcached.DelayedFlushAll;
import org.infinispan.server.memcached.MemcachedException;
import org.infinispan.server.memcached.MemcachedMetadata;
import org.infinispan.server.memcached.MemcachedMetadata$;
import org.infinispan.server.memcached.MemcachedOperation$;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.RequestResolver$;
import org.infinispan.server.memcached.TextProtocolUtil$;
import org.infinispan.stats.Stats;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r=f\u0001B\u0001\u0003\u0001-\u0011\u0001#T3nG\u0006\u001c\u0007.\u001a3EK\u000e|G-\u001a:\u000b\u0005\r!\u0011!C7f[\u000e\f7\r[3e\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000f!\t!\"\u001b8gS:L7\u000f]1o\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\u0011i\u0001C\u0005\u0011\u000e\u00039Q!a\u0004\u0003\u0002\t\r|'/Z\u0005\u0003#9\u0011q#\u00112tiJ\f7\r\u001e)s_R|7m\u001c7EK\u000e|G-\u001a:\u0011\u0005MibB\u0001\u000b\u001b\u001d\t)\u0002$D\u0001\u0017\u0015\t9\"\"\u0001\u0004=e>|GOP\u0005\u00023\u0005)1oY1mC&\u00111\u0004H\u0001\u0007!J,G-\u001a4\u000b\u0003eI!AH\u0010\u0003\rM#(/\u001b8h\u0015\tYB\u0004E\u0002\"E\u0011j\u0011\u0001H\u0005\u0003Gq\u0011Q!\u0011:sCf\u0004\"!I\u0013\n\u0005\u0019b\"\u0001\u0002\"zi\u0016D\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\u000f[\u0016l7-Y2iK\u0012\u001c\u0015m\u00195f!\u0011Q3F\u0005\u0011\u000e\u0003\u0019I!\u0001\f\u0004\u0003\u001b\u0005#g/\u00198dK\u0012\u001c\u0015m\u00195f\u0011!q\u0003A!A!\u0002\u0013y\u0013!C:dQ\u0016$W\u000f\\3s!\t\u0001t'D\u00012\u0015\t\u00114'\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001N\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002m\u0005!!.\u0019<b\u0013\tA\u0014G\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016D\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IaO\u0001\niJ\fgn\u001d9peR\u0004\"\u0001\u0010 \u000e\u0003uR!A\u000f\b\n\u0005}j$A\u0004(fiRLHK]1ogB|'\u000f\u001e\u0005\u0006\u0003\u0002!\tAQ\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\r+ei\u0012\t\u0003\t\u0002i\u0011A\u0001\u0005\u0006Q\u0001\u0003\r!\u000b\u0005\u0006]\u0001\u0003\ra\f\u0005\u0006u\u0001\u0003\raO\u0003\u0005\u0013\u0002\u0001!J\u0001\nTk&$\u0018M\u00197f!\u0006\u0014\u0018-\\3uKJ\u001c\bC\u0001#L\u0013\ta%AA\nNK6\u001c\u0017m\u00195fIB\u000b'/Y7fi\u0016\u00148/\u0002\u0003O\u0001\u0001y%AD*vSR\f'\r\\3IK\u0006$WM\u001d\t\u0003\u001bAK!!\u0015\b\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011!\u0019\u0006\u0001#b\u0001\n\u0013!\u0016AD5t'R\fGo]#oC\ndW\rZ\u000b\u0002+B\u0011\u0011EV\u0005\u0003/r\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005Z\u0001!\u0005\t\u0015)\u0003V\u0003=I7o\u0015;biN,e.\u00192mK\u0012\u0004\u0003bB.\u0001\u0005\u0004%i\u0001X\u0001\u000bS:\u001c'/T5tg\u0016\u001cX#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\f\u0014AB1u_6L7-\u0003\u0002c?\nQ\u0011\t^8nS\u000eduN\\4\t\r\u0011\u0004\u0001\u0015!\u0004^\u0003-Ign\u0019:NSN\u001cXm\u001d\u0011\t\u000f\u0019\u0004!\u0019!C\u00079\u0006A\u0011N\\2s\u0011&$8\u000f\u0003\u0004i\u0001\u0001\u0006i!X\u0001\nS:\u001c'\u000fS5ug\u0002BqA\u001b\u0001C\u0002\u00135A,\u0001\u0006eK\u000e\u0014X*[:tKNDa\u0001\u001c\u0001!\u0002\u001bi\u0016a\u00033fGJl\u0015n]:fg\u0002BqA\u001c\u0001C\u0002\u00135A,\u0001\u0005eK\u000e\u0014\b*\u001b;t\u0011\u0019\u0001\b\u0001)A\u0007;\u0006IA-Z2s\u0011&$8\u000f\t\u0005\be\u0002\u0011\r\u0011\"\u0004]\u0003e\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u001b&\u001c8/Z:\t\rQ\u0004\u0001\u0015!\u0004^\u0003i\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u001b&\u001c8/Z:!\u0011\u001d1\bA1A\u0005\u000eq\u000bqC]3qY\u0006\u001cW-\u00134V]6|G-\u001b4jK\u0012D\u0015\u000e^:\t\ra\u0004\u0001\u0015!\u0004^\u0003a\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0011&$8\u000f\t\u0005\bu\u0002\u0011\r\u0011\"\u0004]\u0003e\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0005\u0006$g/\u00197\t\rq\u0004\u0001\u0015!\u0004^\u0003i\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0005\u0006$g/\u00197!\u0011\u001dq\bA1A\u0005\nQ\u000bq![:Ue\u0006\u001cW\rC\u0004\u0002\u0002\u0001\u0001\u000b\u0011B+\u0002\u0011%\u001cHK]1dK\u0002B\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\u0002\u0015\tLH/\u001a\"vM\u001a,'/\u0006\u0002\u0002\nA!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010U\n!![8\n\t\u0005M\u0011Q\u0002\u0002\u0016\u0005f$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n\u0011!\t9\u0002\u0001Q\u0001\n\u0005%\u0011a\u00032zi\u0016\u0014UO\u001a4fe\u0002Bq!a\u0007\u0001\t\u0003\ni\"\u0001\u0007de\u0016\fG/\u001a%fC\u0012,'/F\u0001P\u0011\u001d\t\t\u0003\u0001C!\u0003G\t!B]3bI\"+\u0017\rZ3s)\u0019\t)#a\u000b\u0002BA!\u0011%a\nV\u0013\r\tI\u0003\b\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u00055\u0012q\u0004a\u0001\u0003_\taAY;gM\u0016\u0014\b\u0003BA\u0019\u0003{i!!a\r\u000b\t\u00055\u0012Q\u0007\u0006\u0005\u0003o\tI$A\u0003oKR$\u0018PC\u0002\u0002<!\tQA\u001b2pgNLA!a\u0010\u00024\ti1\t[1o]\u0016d')\u001e4gKJDq!a\u0011\u0002 \u0001\u0007q*\u0001\u0004iK\u0006$WM\u001d\u0005\b\u0003\u000f\u0002A\u0011IA%\u0003\u001d\u0011X-\u00193LKf$B!a\u0013\u0002RA)\u0011%!\u0014\u0013+&\u0019\u0011q\n\u000f\u0003\rQ+\b\u000f\\33\u0011!\t\u0019&!\u0012A\u0002\u0005=\u0012!\u00012\t\u000f\u0005]\u0003\u0001\"\u0003\u0002Z\u0005A!/Z1e\u0017\u0016L8\u000f\u0006\u0003\u0002\\\u0005%\u0004#BA/\u0003G\u0012bb\u0001\u000b\u0002`%\u0019\u0011\u0011\r\u000f\u0002\u000fA\f7m[1hK&!\u0011QMA4\u0005\r\u0019V-\u001d\u0006\u0004\u0003Cb\u0002\u0002CA*\u0003+\u0002\r!a\f\t\u000f\u00055\u0004\u0001\"\u0015\u0002p\u0005\u0019q-\u001a;\u0015\t\u0005E\u0014q\u000f\t\u0004C\u0005M\u0014bAA;9\t1\u0011I\\=SK\u001aD\u0001\"!\f\u0002l\u0001\u0007\u0011q\u0006\u0005\b\u0003w\u0002A\u0011BA?\u00039\u0019\u0007.Z2l\u0017\u0016LH*\u001a8hi\"$rAEA@\u0003\u0007\u000b9\tC\u0004\u0002\u0002\u0006e\u0004\u0019\u0001\n\u0002\u0003-Dq!!\"\u0002z\u0001\u0007Q+A\u0004f]\u0012|em\u00149\t\u0011\u0005M\u0013\u0011\u0010a\u0001\u0003_Aq!a#\u0001\t\u0003\ni)\u0001\bsK\u0006$\u0007+\u0019:b[\u0016$XM]:\u0015\u000bU\u000by)a(\t\u0011\u0005E\u0015\u0011\u0012a\u0001\u0003'\u000b!a\u00195\u0011\t\u0005U\u00151T\u0007\u0003\u0003/SA!!'\u00026\u000591\r[1o]\u0016d\u0017\u0002BAO\u0003/\u0013qa\u00115b]:,G\u000e\u0003\u0005\u0002T\u0005%\u0005\u0019AA\u0018\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003K\u000bAC]3bIJ+Wn\u001c<f!\u0006\u0014\u0018-\\3uKJ\u001cHc\u0001&\u0002(\"A\u0011\u0011VAQ\u0001\u0004\tY&\u0001\u0003be\u001e\u001c\bbBAW\u0001\u0011%\u0011qV\u0001\u0017e\u0016\fG-\u00138de\u0012+7M\u001d)be\u0006lW\r^3sgR\u0019!*!-\t\u0011\u0005%\u00161\u0016a\u0001\u00037Bq!!.\u0001\t\u0013\t9,\u0001\fsK\u0006$g\t\\;tQ\u0006cG\u000eU1sC6,G/\u001a:t)\rQ\u0015\u0011\u0018\u0005\t\u0003S\u000b\u0019\f1\u0001\u0002\\!9\u0011Q\u0018\u0001\u0005\n\u0005}\u0016!\u0006:fC\u0012\u001cFo\u001c:bO\u0016\u0004\u0016M]1nKR,'o\u001d\u000b\u0006\u0015\u0006\u0005\u00171\u0019\u0005\t\u0003S\u000bY\f1\u0001\u0002\\!A\u00111KA^\u0001\u0004\ty\u0003C\u0004\u0002H\u0002!\t&!3\u0002\u0013I,\u0017\r\u001a,bYV,G\u0003BAf\u0003#\u00042!IAg\u0013\r\ty\r\b\u0002\u0005+:LG\u000f\u0003\u0005\u0002T\u0005\u0015\u0007\u0019AA\u0018\u0011\u001d\t)\u000e\u0001C!\u0003/\f1b\u0019:fCR,g+\u00197vKR\t\u0001\u0005C\u0004\u0002\\\u0002!I!!8\u0002\u0011\u001d,GO\u00127bON$B!a8\u0002fB\u0019\u0011%!9\n\u0007\u0005\rHD\u0001\u0003M_:<\u0007bBAt\u00033\u0004\rAE\u0001\u0006M2\fwm\u001d\u0005\b\u0003W\u0004A\u0011BAw\u0003-9W\r\u001e'jM\u0016\u001c\b/\u00198\u0015\t\u0005=\u0018Q\u001f\t\u0004C\u0005E\u0018bAAz9\t\u0019\u0011J\u001c;\t\u000f\u0005]\u0018\u0011\u001ea\u0001%\u0005AA.\u001b4fgB\fg\u000eC\u0004\u0002|\u0002!I!!@\u0002\u0013\u001d,G\u000fT3oORDG\u0003BAx\u0003\u007fDqA!\u0001\u0002z\u0002\u0007!#\u0001\u0004mK:<G\u000f\u001b\u0005\b\u0005\u000b\u0001A\u0011\u0002B\u0004\u0003)9W\r\u001e,feNLwN\u001c\u000b\u0005\u0003?\u0014I\u0001C\u0004\u0003\f\t\r\u0001\u0019\u0001\n\u0002\u000fY,'o]5p]\"9!q\u0002\u0001\u0005\n\tE\u0011\u0001\u00049beN,gj\u001c*fa2LH#B+\u0003\u0014\t]\u0001\u0002\u0003B\u000b\u0005\u001b\u0001\r!a<\u0002\u001b\u0015D\b/Z2uK\u0012Le\u000eZ3y\u0011!\tIK!\u0004A\u0002\u0005m\u0003b\u0002B\u000e\u0001\u0011%!QD\u0001\u0017a\u0006\u00148/\u001a#fY\u0006LX\r\u001a#fY\u0016$X\rV5nKR!\u0011q\u001eB\u0010\u0011!\tIK!\u0007A\u0002\u0005m\u0003b\u0002B\u0012\u0001\u0011\u0005#QE\u0001\tO\u0016$8)Y2iKV\u0011!q\u0005\t\u0006U\t%\"\u0003I\u0005\u0004\u0005W1!!B\"bG\",\u0007b\u0002B\u0018\u0001\u0011E#\u0011G\u0001\u0013GV\u001cHo\\7EK\u000e|G-\u001a%fC\u0012,'\u000f\u0006\u0004\u0002r\tM\"Q\u0007\u0005\t\u0003#\u0013i\u00031\u0001\u0002\u0014\"A\u0011Q\u0006B\u0017\u0001\u0004\ty\u0003C\u0004\u0003:\u0001!\tFa\u000f\u0002\u001f\r,8\u000f^8n\t\u0016\u001cw\u000eZ3LKf$b!!\u001d\u0003>\t}\u0002\u0002CAI\u0005o\u0001\r!a%\t\u0011\u00055\"q\u0007a\u0001\u0003_AqAa\u0011\u0001\t#\u0012)%A\tdkN$x.\u001c#fG>$WMV1mk\u0016$b!!\u001d\u0003H\t%\u0003\u0002CAI\u0005\u0003\u0002\r!a%\t\u0011\u00055\"\u0011\ta\u0001\u0003_AqA!\u0014\u0001\t\u0013\u0011y%\u0001\u0005j]\u000e\u0014H)Z2s)\u0011\t\tH!\u0015\t\u0011\u0005E%1\na\u0001\u0003'CqA!\u0016\u0001\t\u0013\u00119&\u0001\u0005gYV\u001c\b.\u00117m)!\t\tH!\u0017\u0003\\\tu\u0003\u0002CA*\u0005'\u0002\r!a\f\t\u0011\u0005E%1\u000ba\u0001\u0003'CqAa\u0018\u0003T\u0001\u0007Q+\u0001\u0007jgJ+\u0017\r\u001a)be\u0006l7\u000fC\u0004\u0003d\u0001!IA!\u001a\u0002\u001bY\fG.\u001b3bi\u0016$U\r\u001c;b)\u0011\u00119G!\u001c\u0011\t\u0005u#\u0011N\u0005\u0005\u0005W\n9G\u0001\u0004CS\u001eLe\u000e\u001e\u0005\b\u0005_\u0012\t\u00071\u0001\u0013\u0003\u0015!W\r\u001c;b\u0011\u001d\u0011\u0019\b\u0001C!\u0005k\nQc\u0019:fCR,7+^2dKN\u001c(+Z:q_:\u001cX\r\u0006\u0003\u0002r\t]\u0004b\u0002B=\u0005c\u0002\r\u0001I\u0001\u0005aJ,g\u000fC\u0004\u0003~\u0001!\tEa \u00023\r\u0014X-\u0019;f\u001d>$X\t_3dkR,GMU3ta>t7/\u001a\u000b\u0005\u0003c\u0012\t\tC\u0004\u0003z\tm\u0004\u0019\u0001\u0011\t\u000f\t\u0015\u0005\u0001\"\u0011\u0003\b\u000612M]3bi\u0016tu\u000e^#ySN$(+Z:q_:\u001cX-\u0006\u0002\u0002r!9!1\u0012\u0001\u0005B\t5\u0015!E2sK\u0006$XmR3u%\u0016\u001c\bo\u001c8tKR1\u0011\u0011\u000fBH\u0005#Cq!!!\u0003\n\u0002\u0007!\u0003\u0003\u0005\u0003\u0014\n%\u0005\u0019\u0001BK\u0003\u0015)g\u000e\u001e:z!\u0011\u00119J!)\u000e\u0005\te%\u0002\u0002BN\u0005;\u000bq!\u001a8ue&,7OC\u0002\u0003 \u001a\t\u0011bY8oi\u0006Lg.\u001a:\n\t\t\r&\u0011\u0014\u0002\u000b\u0007\u0006\u001c\u0007.Z#oiJL\bb\u0002BT\u0001\u0011\u0005#\u0011V\u0001\u0017GJ,\u0017\r^3Nk2$\u0018nR3u%\u0016\u001c\bo\u001c8tKR!\u0011\u0011\u000fBV\u0011!\u0011iK!*A\u0002\t=\u0016!\u00029bSJ\u001c\bCB\n\u00032J\u0011)*C\u0002\u00034~\u00111!T1q\u0011\u001d\u00119\f\u0001C!\u0005s\u000b1c\u0019:fCR,WI\u001d:peJ+7\u000f]8og\u0016$B!!\u001d\u0003<\"A!Q\u0018B[\u0001\u0004\u0011y,A\u0001u!\u0011\tiF!1\n\t\t\r\u0017q\r\u0002\n)\"\u0014xn^1cY\u0016DqAa2\u0001\t#\u0012I-A\u0007ck&dG-T3uC\u0012\fG/\u0019\u000b\u0003\u0005\u0017\u0004BA!4\u0003T6\u0011!q\u001a\u0006\u0004\u0005#4\u0011\u0001C7fi\u0006$\u0017\r^1\n\t\tU'q\u001a\u0002\t\u001b\u0016$\u0018\rZ1uC\"9!\u0011\u001c\u0001\u0005\n\tm\u0017\u0001\u00077pO\u0006sGm\u0011:fCR,WI\u001d:pe6+7o]1hKR1!Q\u001cBu\u0005[\u0004BAa8\u0003f6\u0011!\u0011\u001d\u0006\u0004\u0005G,\u0014\u0001\u00027b]\u001eLAAa:\u0003b\ni1\u000b\u001e:j]\u001e\u0014U/\u001b7eKJD\u0001Ba;\u0003X\u0002\u0007!Q\\\u0001\u0003g\nD\u0001Ba<\u0003X\u0002\u0007!\u0011_\u0001\u0002[B\u0019AIa=\n\u0007\tU(A\u0001\nNK6\u001c\u0017m\u00195fI\u0016C8-\u001a9uS>t\u0007b\u0002B}\u0001\u0011E#1`\u0001\u0016GJ,\u0017\r^3TKJ4XM]#yG\u0016\u0004H/[8o)\u0019\u0011iPa@\u0004\nA1\u0011%!\u0014\u0003rVC\u0001b!\u0001\u0003x\u0002\u000711A\u0001\u0002KB!\u0011QLB\u0003\u0013\u0011\u00199!a\u001a\u0003\u0013\u0015C8-\u001a9uS>t\u0007\u0002CA*\u0005o\u0004\r!a\f\t\u000f\r5\u0001\u0001\"\u0003\u0004\u0010\u0005a1\r\\8tK\u000eC\u0017M\u001c8fYR!\u0011\u0011OB\t\u0011!\t\tja\u0003A\u0002\u0005M\u0005bBB\u000b\u0001\u0011\u0005#qQ\u0001\u0014GJ,\u0017\r^3Ti\u0006$8OU3ta>t7/\u001a\u0005\b\u00073\u0001A\u0011BB\u000e\u0003%\u0011W/\u001b7e'R\fG\u000f\u0006\u0005\u00020\ru1\u0011EB\u0016\u0011\u001d\u0019yba\u0006A\u0002I\tAa\u001d;bi\"A11EB\f\u0001\u0004\u0019)#A\u0003wC2,X\rE\u0002\"\u0007OI1a!\u000b\u001d\u0005\r\te.\u001f\u0005\t\u0005W\u001c9\u00021\u0001\u0003^\"91q\u0006\u0001\u0005\n\rE\u0012\u0001\u00052vS2$w)\u001a;SKN\u0004xN\\:f)!\tyca\r\u0004D\r\u0015\u0003\u0002CB\u001b\u0007[\u0001\raa\u000e\u0002\u0005=\u0004\b\u0003BB\u001d\u0007\u007f\u00012!IB\u001e\u0013\r\u0019i\u0004\b\u0002\f\u000b:,X.\u001a:bi&|g.\u0003\u0003\u0004B\rm\"!\u0002,bYV,\u0007bBAA\u0007[\u0001\rA\u0005\u0005\t\u0005'\u001bi\u00031\u0001\u0003\u0016\"91\u0011\n\u0001\u0005\n\r-\u0013A\u00062vS2$7+\u001b8hY\u0016<U\r\u001e*fgB|gn]3\u0015\r\u0005=2QJB(\u0011\u001d\t\tia\u0012A\u0002IA\u0001Ba%\u0004H\u0001\u0007!Q\u0013\u0005\b\u0007'\u0002A\u0011BB+\u0003M\u0011W/\u001b7e\u000f\u0016$\b*Z1eKJ\u0014UmZ5o)!\tyca\u0016\u0004Z\rm\u0003bBAA\u0007#\u0002\rA\u0005\u0005\t\u0005'\u001b\t\u00061\u0001\u0003\u0016\"A1QLB)\u0001\u0004\ty/\u0001\u0006fqR\u0014\u0018m\u00159bG\u0016Dqa!\u0019\u0001\t\u0013\u0019\u0019'\u0001\nxe&$XmR3u\u0011\u0016\fG-\u001a:ECR\fGCBA\u0018\u0007K\u001aI\u0007C\u0004\u0004h\r}\u0003\u0019\u0001\u0011\u0002\t\u0011\fG/\u0019\u0005\t\u0007W\u001ay\u00061\u0001\u00020\u0005\u0019!-\u001e4\t\u000f\r=\u0004\u0001\"\u0003\u0004r\u0005\trO]5uK\u001e+G\u000fS3bI\u0016\u0014XI\u001c3\u0015\t\u0005=21\u000f\u0005\t\u0007W\u001ai\u00071\u0001\u00020!91q\u000f\u0001\u0005\n\re\u0014!\t2vS2$7+\u001b8hY\u0016<U\r^,ji\"4VM]:j_:\u0014Vm\u001d9p]N,GCBA\u0018\u0007w\u001ai\bC\u0004\u0002\u0002\u000eU\u0004\u0019\u0001\n\t\u0011\tM5Q\u000fa\u0001\u0005+Cqa!!\u0001\t\u0013\u0019\u0019)A\nge&,g\u000e\u001a7z\u001b\u0006D\u0018J\u001c;DQ\u0016\u001c7\u000e\u0006\u0004\u0002p\u000e\u00155\u0011\u0012\u0005\b\u0007\u000f\u001by\b1\u0001\u0013\u0003\u0019qW/\u001c2fe\"911RB@\u0001\u0004\u0011\u0012aB7fgN\fw-\u001a\u0005\b\u0007\u001f\u0003A\u0011BBI\u0003EqW/\\3sS\u000ed\u0015.\\5u\u0007\",7m\u001b\u000b\u000b\u0003_\u001c\u0019j!&\u0004\u001a\u000em\u0005bBBD\u0007\u001b\u0003\rA\u0005\u0005\t\u0007/\u001bi\t1\u0001\u0002`\u0006AQ.\u0019=WC2,X\rC\u0004\u0004\f\u000e5\u0005\u0019\u0001\n\t\u0011\ru5Q\u0012a\u0001\u0007?\u000b\u0011A\u001c\t\u0005\u0003;\u001a\t+\u0003\u0003\u0004$\u0006\u001d$!\u0006(v[\n,'OR8s[\u0006$X\t_2faRLwN\u001c\u0005\b\u0007\u001f\u0003A\u0011BBT)!\tyn!+\u0004,\u000e5\u0006bBBD\u0007K\u0003\rA\u0005\u0005\t\u0007/\u001b)\u000b1\u0001\u0002`\"911RBS\u0001\u0004\u0011\u0002")
public class MemcachedDecoder
extends AbstractProtocolDecoder<String, byte[]> {
    private final ScheduledExecutorService scheduler;
    private final NettyTransport transport;
    private boolean isStatsEnabled;
    private final AtomicLong incrMisses;
    private final AtomicLong incrHits;
    private final AtomicLong decrMisses;
    private final AtomicLong decrHits;
    private final AtomicLong replaceIfUnmodifiedMisses;
    private final AtomicLong replaceIfUnmodifiedHits;
    private final AtomicLong replaceIfUnmodifiedBadval;
    private final boolean isTrace;
    private final ByteArrayOutputStream byteBuffer;
    private volatile boolean bitmap$0;

    private boolean isStatsEnabled$lzycompute() {
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if (!this.bitmap$0) {
                this.isStatsEnabled = this.cache().getCacheConfiguration().jmxStatistics().enabled();
                this.bitmap$0 = true;
            }
            return this.isStatsEnabled;
        }
    }

    private boolean isStatsEnabled() {
        return this.bitmap$0 ? this.isStatsEnabled : this.isStatsEnabled$lzycompute();
    }

    private final AtomicLong incrMisses() {
        return this.incrMisses;
    }

    private final AtomicLong incrHits() {
        return this.incrHits;
    }

    private final AtomicLong decrMisses() {
        return this.decrMisses;
    }

    private final AtomicLong decrHits() {
        return this.decrHits;
    }

    private final AtomicLong replaceIfUnmodifiedMisses() {
        return this.replaceIfUnmodifiedMisses;
    }

    private final AtomicLong replaceIfUnmodifiedHits() {
        return this.replaceIfUnmodifiedHits;
    }

    private final AtomicLong replaceIfUnmodifiedBadval() {
        return this.replaceIfUnmodifiedBadval;
    }

    private boolean isTrace() {
        return this.isTrace;
    }

    private ByteArrayOutputStream byteBuffer() {
        return this.byteBuffer;
    }

    public RequestHeader createHeader() {
        return new RequestHeader();
    }

    public Option<Object> readHeader(ChannelBuffer buffer, RequestHeader header) {
        Enumeration.Value op;
        boolean endOfOp = TextProtocolUtil$.MODULE$.readElement(buffer, this.byteBuffer());
        String streamOp = TextProtocolUtil$.MODULE$.extractString(this.byteBuffer());
        Enumeration.Value value = op = RequestResolver$.MODULE$.toRequest(streamOp, endOfOp, buffer);
        Enumeration.Value value2 = Operation$.MODULE$.StatsRequest();
        if (!(value != null ? !value.equals(value2) : value2 != null) && !endOfOp) {
            String line = TextProtocolUtil$.MODULE$.readDiscardedLine(buffer).trim();
            if (line.isEmpty()) {
                endOfOp = true;
            } else {
                throw new StreamCorruptedException(new StringBuilder().append((Object)"Stats command does not accept arguments: ").append((Object)line).toString());
            }
        }
        Enumeration.Value value3 = op;
        Enumeration.Value value4 = MemcachedOperation$.MODULE$.VerbosityRequest();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            if (!endOfOp) {
                TextProtocolUtil$.MODULE$.skipLine(buffer);
            }
            throw new StreamCorruptedException("Memcached 'verbosity' command is unsupported");
        }
        header.op_$eq(op);
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    public Tuple2<String, Object> readKey(ChannelBuffer b) {
        boolean endOfOp = TextProtocolUtil$.MODULE$.readElement(b, this.byteBuffer());
        String k = TextProtocolUtil$.MODULE$.extractString(this.byteBuffer());
        this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, endOfOp, b);
        return new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    private Seq<String> readKeys(ChannelBuffer b) {
        return TextProtocolUtil$.MODULE$.readSplitLine(b);
    }

    public Object get(ChannelBuffer buffer) {
        Object object;
        Seq<String> keys = this.readKeys(buffer);
        if (keys.length() > 1) {
            scala.collection.mutable.HashMap map = new scala.collection.mutable.HashMap();
            keys.foreach((Function1)new Serializable(this, buffer, map){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemcachedDecoder $outer;
                private final ChannelBuffer buffer$1;
                private final scala.collection.mutable.HashMap map$1;

                public final Object apply(String k) {
                    CacheEntry entry = this.$outer.cache().getCacheEntry((Object)this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, true, this.buffer$1));
                    return entry == null ? BoxedUnit.UNIT : this.map$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)k), (Object)entry));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.buffer$1 = buffer$1;
                    this.map$1 = map$1;
                }
            });
            object = this.createMultiGetResponse((Map<String, CacheEntry>)new HashMap().$plus$plus((GenTraversableOnce)map));
        } else {
            String key = this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength((String)keys.apply(0), true, buffer);
            CacheEntry entry = this.cache().getCacheEntry((Object)key);
            object = this.createGetResponse(key, entry);
        }
        return object;
    }

    public String org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(String k, boolean endOfOp, ChannelBuffer b) {
        if (k.length() > 250) {
            if (!endOfOp) {
                TextProtocolUtil$.MODULE$.skipLine(b);
            }
            throw new StreamCorruptedException("Key length over the 250 character limit");
        }
        return k;
    }

    public boolean readParameters(Channel ch, ChannelBuffer b) {
        MemcachedParameters memcachedParameters;
        Seq<String> args = TextProtocolUtil$.MODULE$.readSplitLine(b);
        BooleanRef endOfOp = new BooleanRef(false);
        if (args.isEmpty()) {
            memcachedParameters = null;
        } else {
            if (this.isTrace()) {
                this.trace((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Operation parameters: %s";
                    }
                }, args);
            }
            memcachedParameters = this.liftedTree1$1(b, args, endOfOp);
        }
        this.params_$eq(memcachedParameters);
        return endOfOp.elem;
    }

    private MemcachedParameters readRemoveParameters(Seq<String> args) {
        int delayedDeleteTime = this.parseDelayedDeleteTime(args);
        boolean noReply = delayedDeleteTime == -1 ? this.parseNoReply(0, args) : false;
        return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", 0);
    }

    private MemcachedParameters readIncrDecrParameters(Seq<String> args) {
        String delta = (String)args.apply(0);
        return new MemcachedParameters(-1, -1, -1, -1L, this.parseNoReply(1, args), 0L, delta, 0);
    }

    private MemcachedParameters readFlushAllParameters(Seq<String> args) {
        NumberFormatException numberFormatException2;
        block2: {
            int n;
            boolean noReplyFound = false;
            try {
                n = this.friendlyMaxIntCheck((String)args.apply(0), "Flush delay");
            }
            catch (NumberFormatException numberFormatException2) {
                if (!numberFormatException2.getMessage().contains("noreply")) break block2;
                noReplyFound = true;
                n = 0;
            }
            int flushDelay = n;
            boolean noReply = noReplyFound ? true : this.parseNoReply(1, args);
            return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", flushDelay);
        }
        throw numberFormatException2;
    }

    private MemcachedParameters readStorageParameters(Seq<String> args, ChannelBuffer b) {
        long l;
        int length;
        int streamLifespan;
        int index = 0;
        long flags = this.getFlags((String)args.apply(index));
        if (flags < 0L) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Flags cannot be negative: ").append((Object)BoxesRunTime.boxToLong((long)flags)).toString());
        }
        int lifespan = (streamLifespan = this.getLifespan((String)args.apply(++index))) <= 0 ? -1 : streamLifespan;
        if ((length = this.getLength((String)args.apply(++index))) < 0) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Negative bytes length provided: ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString());
        }
        Enumeration.Value value = this.header().op();
        Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Enumeration.Value x2 = value;
            l = this.getVersion((String)args.apply(++index));
        } else {
            l = -1L;
        }
        long streamVersion = l;
        boolean noReply = this.parseNoReply(++index, args);
        return new MemcachedParameters(length, lifespan, -1, streamVersion, noReply, flags, "", 0);
    }

    public void readValue(ChannelBuffer b) {
        b.readBytes(this.rawValue());
        TextProtocolUtil$.MODULE$.skipLine(b);
    }

    public byte[] createValue() {
        return this.rawValue();
    }

    private long getFlags(String flags) {
        long l;
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        try {
            l = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags");
        }
        catch (NumberFormatException numberFormatException) {
            l = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags", numberFormatException);
        }
        return l;
    }

    private int getLifespan(String lifespan) {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return this.friendlyMaxIntCheck(lifespan, "Lifespan");
    }

    private int getLength(String length) {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return this.friendlyMaxIntCheck(length, "The number of bytes");
    }

    private long getVersion(String version) {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return new StringOps(Predef$.MODULE$.augmentString(version)).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNoReply(int expectedIndex, Seq<String> args) {
        if (args.length() <= expectedIndex) return false;
        Object object = args.apply(expectedIndex);
        if ("noreply" != null) {
            if (!"noreply".equals(object)) throw new StreamCorruptedException("Unable to parse noreply optional argument");
            return true;
        }
        if (object == null) return true;
        throw new StreamCorruptedException("Unable to parse noreply optional argument");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDelayedDeleteTime(Seq<String> args) {
        int n;
        if (args.length() <= 0) return 0;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString((String)args.apply(0))).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public Cache<String, byte[]> getCache() {
        return this.cache();
    }

    public Object customDecodeHeader(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        value = this.header().op();
                        Enumeration.Value value2 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        Enumeration.Value x2 = value;
                        object = this.flushAll(buffer, ch, false);
                        break block3;
                    }
                    Enumeration.Value value4 = MemcachedOperation$.MODULE$.VersionRequest();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    Enumeration.Value x3 = value;
                    java.lang.StringBuilder ret = new java.lang.StringBuilder().append("VERSION ").append(Version.VERSION).append(TextProtocolUtil$.MODULE$.CRLF());
                    object = this.writeResponse(ch, ret);
                    break block3;
                }
                Enumeration.Value value6 = MemcachedOperation$.MODULE$.QuitRequest();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                Enumeration.Value x4 = value;
                object = this.closeChannel(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeKey(Channel ch, ChannelBuffer buffer) {
        Enumeration.Value value;
        block13: {
            Object object;
            block12: {
                block11: {
                    boolean bl;
                    value = this.header().op();
                    Enumeration.Value value2 = MemcachedOperation$.MODULE$.AppendRequest();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        Enumeration.Value x2 = value;
                        bl = true;
                    } else {
                        Enumeration.Value value4 = MemcachedOperation$.MODULE$.PrependRequest();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            Enumeration.Value x3 = value;
                            bl = true;
                        } else {
                            Enumeration.Value value6 = MemcachedOperation$.MODULE$.IncrementRequest();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                Enumeration.Value x4 = value;
                                bl = true;
                            } else {
                                Enumeration.Value value8 = MemcachedOperation$.MODULE$.DecrementRequest();
                                Enumeration.Value value9 = value;
                                if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                    Enumeration.Value x5 = value;
                                    bl = true;
                                } else {
                                    bl = false;
                                }
                            }
                        }
                    }
                    if (!bl) break block11;
                    this.key_$eq(this.readKey(buffer)._1());
                    object = this.checkpointTo(DecoderState.DECODE_PARAMETERS);
                    break block12;
                }
                Enumeration.Value value10 = MemcachedOperation$.MODULE$.FlushAllRequest();
                Enumeration.Value value11 = value;
                if (value10 != null ? !value10.equals(value11) : value11 != null) break block13;
                Enumeration.Value x6 = value;
                object = this.flushAll(buffer, ch, true);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object customDecodeValue(Channel ch, ChannelBuffer buffer) {
        boolean bl;
        boolean bl2;
        Enumeration.Value op;
        Enumeration.Value value = op = this.header().op();
        Enumeration.Value value2 = MemcachedOperation$.MODULE$.AppendRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Enumeration.Value x2 = value;
            bl2 = true;
        } else {
            Enumeration.Value value4 = MemcachedOperation$.MODULE$.PrependRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Enumeration.Value x3 = value;
                bl2 = true;
            } else {
                bl2 = false;
            }
        }
        if (bl2) {
            Object object;
            this.readValue(buffer);
            byte[] prev = (byte[])this.cache().get(this.key());
            if (prev != null) {
                byte[] byArray;
                Enumeration.Value value6 = this.header().op();
                Enumeration.Value value7 = MemcachedOperation$.MODULE$.AppendRequest();
                Enumeration.Value value8 = value6;
                if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                    Enumeration.Value x2 = value6;
                    byArray = TextProtocolUtil$.MODULE$.concat(prev, this.rawValue());
                } else {
                    Enumeration.Value value9 = MemcachedOperation$.MODULE$.PrependRequest();
                    Enumeration.Value value10 = value6;
                    if (value9 == null) {
                        if (value10 != null) {
                            throw new MatchError((Object)value6);
                        }
                    } else if (!value9.equals(value10)) throw new MatchError((Object)value6);
                    Enumeration.Value x3 = value6;
                    byArray = TextProtocolUtil$.MODULE$.concat(this.rawValue(), prev);
                }
                byte[] concatenated = byArray;
                boolean replaced = this.cache().replace(this.key(), (Object)prev, (Object)concatenated, this.buildMetadata());
                object = replaced ? (Object)(((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.STORED()) : (Object)(((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_STORED());
            } else {
                object = ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_STORED();
            }
            byte[] ret = object;
            return this.writeResponse(ch, ret);
        }
        Enumeration.Value value11 = MemcachedOperation$.MODULE$.IncrementRequest();
        Enumeration.Value value12 = value;
        if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
            Enumeration.Value x4 = value;
            bl = true;
        } else {
            Enumeration.Value value13 = MemcachedOperation$.MODULE$.DecrementRequest();
            Enumeration.Value value14 = value;
            if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                Enumeration.Value x5 = value;
                bl = true;
            } else {
                bl = false;
            }
        }
        if (!bl) throw new MatchError((Object)value);
        return this.incrDecr(ch);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object incrDecr(Channel ch) {
        Object object;
        byte[] prev = (byte[])this.cache().get(this.key());
        Enumeration.Value op = this.header().op();
        if (prev != null) {
            Object object2;
            Object object3;
            BigInt prevCounter = package$.MODULE$.BigInt().apply(new String(prev));
            BigInt delta = this.validateDelta(((MemcachedParameters)this.params()).delta());
            Enumeration.Value value = op;
            Enumeration.Value value2 = MemcachedOperation$.MODULE$.IncrementRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                BigInt candidateCounter = prevCounter.$plus(delta);
                object3 = candidateCounter.$greater(TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG()) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
            } else {
                Enumeration.Value value4 = MemcachedOperation$.MODULE$.DecrementRequest();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) throw new MatchError((Object)value);
                Enumeration.Value x3 = value;
                BigInt candidateCounter = prevCounter.$minus(delta);
                object3 = candidateCounter.$less(BigInt$.MODULE$.int2bigInt(0)) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
            }
            Object newCounter = object3;
            byte[] next = newCounter.toString().getBytes();
            boolean replaced = this.cache().replace(this.key(), (Object)prev, (Object)next, this.buildMetadata());
            if (!replaced) throw new CacheException(new StringBuilder().append((Object)"Value modified since we retrieved from the cache, old value was ").append((Object)prevCounter).toString());
            if (this.isStatsEnabled()) {
                Enumeration.Value value6 = op;
                Enumeration.Value value7 = MemcachedOperation$.MODULE$.IncrementRequest();
                object2 = BoxesRunTime.boxToLong((long)(!(value6 != null ? !value6.equals(value7) : value7 != null) ? this.incrHits().incrementAndGet() : this.decrHits().incrementAndGet()));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            object = ((MemcachedParameters)this.params()).noReply() ? null : (Object)new StringBuilder().append((Object)new String(next)).append((Object)TextProtocolUtil$.MODULE$.CRLF()).toString();
        } else {
            Object object4;
            if (this.isStatsEnabled()) {
                Enumeration.Value value = op;
                Enumeration.Value value8 = MemcachedOperation$.MODULE$.IncrementRequest();
                object4 = BoxesRunTime.boxToLong((long)(!(value != null ? !value.equals(value8) : value8 != null) ? this.incrMisses().incrementAndGet() : this.decrMisses().incrementAndGet()));
            } else {
                object4 = BoxedUnit.UNIT;
            }
            object = ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_FOUND();
        }
        byte[] ret = object;
        return this.writeResponse(ch, ret);
    }

    private Object flushAll(ChannelBuffer b, Channel ch, boolean isReadParams) {
        Object object = isReadParams ? BoxesRunTime.boxToBoolean((boolean)this.readParameters(ch, b)) : BoxedUnit.UNIT;
        Serializable flushFunction = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AdvancedCache<String, byte[]> cache) {
                cache.clear();
            }
        };
        int flushDelay = this.params() == null ? 0 : ((MemcachedParameters)this.params()).flushDelay();
        ScheduledFuture<?> scheduledFuture = flushDelay == 0 ? flushFunction.apply((Object)this.cache()) : this.scheduler.schedule(new DelayedFlushAll((AdvancedCache<String, byte[]>)this.cache(), (Function1<AdvancedCache<String, byte[]>, BoxedUnit>)flushFunction), this.toMillis(flushDelay), TimeUnit.MILLISECONDS);
        byte[] ret = (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.OK());
        return this.writeResponse(ch, ret);
    }

    /*
     * WARNING - void declaration
     */
    private BigInt validateDelta(String delta) {
        void var2_2;
        BigInt bigIntDelta = package$.MODULE$.BigInt().apply(delta);
        if (bigIntDelta.$greater(TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta sent (").append((Object)delta).append((Object)") exceeds unsigned limit (").append((Object)TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG()).append((Object)")").toString());
        }
        if (bigIntDelta.$less(TextProtocolUtil$.MODULE$.MIN_UNSIGNED())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta cannot be negative: ").append((Object)delta).toString());
        }
        return var2_2;
    }

    public Object createSuccessResponse(byte[] prev) {
        byte[] byArray;
        BoxedUnit boxedUnit;
        if (this.isStatsEnabled()) {
            Object object;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                object = BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedHits().incrementAndGet());
            } else {
                object = BoxedUnit.UNIT;
            }
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            byte[] byArray2;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.RemoveRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Enumeration.Value x2 = value;
                byArray2 = TextProtocolUtil$.MODULE$.DELETED();
            } else {
                byArray2 = TextProtocolUtil$.MODULE$.STORED();
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public Object createNotExecutedResponse(byte[] prev) {
        byte[] byArray;
        BoxedUnit boxedUnit;
        if (this.isStatsEnabled()) {
            Object object;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                object = BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedBadval().incrementAndGet());
            } else {
                object = BoxedUnit.UNIT;
            }
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            byte[] byArray2;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Enumeration.Value x2 = value;
                byArray2 = TextProtocolUtil$.MODULE$.EXISTS();
            } else {
                byArray2 = TextProtocolUtil$.MODULE$.NOT_STORED();
            }
            byArray = byArray2;
        }
        return byArray;
    }

    public Object createNotExistResponse() {
        BoxedUnit boxedUnit;
        if (this.isStatsEnabled()) {
            Object object;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                object = BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedMisses().incrementAndGet());
            } else {
                object = BoxedUnit.UNIT;
            }
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_FOUND());
    }

    public Object createGetResponse(String k, CacheEntry entry) {
        Enumeration.Value value;
        block6: {
            Object object;
            block3: {
                ChannelBuffer channelBuffer;
                block5: {
                    block4: {
                        block2: {
                            if (entry != null) break block2;
                            object = TextProtocolUtil$.MODULE$.END();
                            break block3;
                        }
                        value = this.header().op();
                        Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block4;
                        Enumeration.Value x2 = value;
                        channelBuffer = this.buildSingleGetResponse(k, entry);
                        break block5;
                    }
                    Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block6;
                    Enumeration.Value x3 = value;
                    channelBuffer = this.buildSingleGetWithVersionResponse(k, entry);
                }
                object = channelBuffer;
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object createMultiGetResponse(Map<String, CacheEntry> pairs) {
        boolean bl;
        Enumeration.Value op;
        ListBuffer elements = new ListBuffer();
        Enumeration.Value value = op = this.header().op();
        Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Enumeration.Value x2 = value;
            bl = true;
        } else {
            Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Enumeration.Value x3 = value;
                bl = true;
            } else {
                bl = false;
            }
        }
        if (bl) {
            pairs.foreach((Function1)new Serializable(this, elements, op){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MemcachedDecoder $outer;
                private final ListBuffer elements$1;
                private final Enumeration.Value op$1;

                public final ListBuffer<ChannelBuffer> apply(Tuple2<String, CacheEntry> x$1) {
                    Tuple2<String, CacheEntry> tuple2 = x$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        CacheEntry entry = (CacheEntry)tuple2._2();
                        ListBuffer listBuffer = this.elements$1.$plus$eq((Object)this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(this.op$1, k, entry));
                        return listBuffer;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.elements$1 = elements$1;
                    this.op$1 = op$1;
                }
            });
            ListBuffer listBuffer = elements.$plus$eq((Object)ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{TextProtocolUtil$.MODULE$.END()})));
            return elements.toArray(ClassTag$.MODULE$.apply(ChannelBuffer.class));
        }
        throw new MatchError((Object)value);
    }

    public Object createErrorResponse(Throwable t) {
        Object object;
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        Throwable throwable = t;
        if (throwable instanceof MemcachedException) {
            Object object2;
            MemcachedException x2 = (MemcachedException)throwable;
            Throwable throwable2 = x2.getCause();
            if (throwable2 instanceof UnknownOperationException) {
                UnknownOperationException x22 = (UnknownOperationException)throwable2;
                this.logExceptionReported((Throwable)x22);
                object2 = TextProtocolUtil$.MODULE$.ERROR();
            } else if (throwable2 instanceof ClosedChannelException) {
                ClosedChannelException x3 = (ClosedChannelException)throwable2;
                this.logExceptionReported(x3);
                object2 = null;
            } else if (throwable2 instanceof IOException) {
                IOException x4 = (IOException)throwable2;
                object2 = this.logAndCreateErrorMessage(sb, x2);
            } else if (throwable2 instanceof NumberFormatException) {
                NumberFormatException x5 = (NumberFormatException)throwable2;
                object2 = this.logAndCreateErrorMessage(sb, x2);
            } else if (throwable2 instanceof IllegalStateException) {
                IllegalStateException x6 = (IllegalStateException)throwable2;
                object2 = this.logAndCreateErrorMessage(sb, x2);
            } else {
                object2 = sb.append(x2.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
            }
            object = object2;
        } else if (throwable instanceof ClosedChannelException) {
            ClosedChannelException x3 = (ClosedChannelException)throwable;
            this.logExceptionReported(x3);
            object = null;
        } else {
            object = sb.append(TextProtocolUtil$.MODULE$.SERVER_ERROR()).append(t.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
        }
        return object;
    }

    public Metadata buildMetadata() {
        EntryVersion version = this.generateVersion((Cache)this.cache());
        return MemcachedMetadata$.MODULE$.apply(((MemcachedParameters)this.params()).flags(), version, this.toMillis(((MemcachedParameters)this.params()).lifespan()), TimeUnit.MILLISECONDS, this.defaultMaxIdleTime(), TimeUnit.MILLISECONDS);
    }

    private java.lang.StringBuilder logAndCreateErrorMessage(java.lang.StringBuilder sb, MemcachedException m) {
        this.logExceptionReported(m.getCause());
        return sb.append(m.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
    }

    public Tuple2<MemcachedException, Object> createServerException(Exception e, ChannelBuffer b) {
        Tuple2 tuple2;
        Exception exception = e;
        if (exception instanceof IOException) {
            IOException x2 = (IOException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.CLIENT_ERROR_BAD_FORMAT()).append((Object)x2.getMessage()).toString(), x2), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (exception instanceof NumberFormatException) {
            NumberFormatException x3 = (NumberFormatException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.CLIENT_ERROR_BAD_FORMAT()).append((Object)x3.getMessage()).toString(), x3), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.SERVER_ERROR()).append((Object)e).toString(), e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple2;
    }

    private Object closeChannel(Channel ch) {
        ch.close();
        return null;
    }

    public Object createStatsResponse() {
        Stats stats = this.cache().getAdvancedCache().getStats();
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        return new ChannelBuffer[]{this.buildStat("pid", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("time", BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())), sb), this.buildStat("version", this.cache().getVersion(), sb), this.buildStat("pointer_size", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_user", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_system", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_items", BoxesRunTime.boxToInteger((int)stats.getCurrentNumberOfEntries()), sb), this.buildStat("total_items", BoxesRunTime.boxToLong((long)stats.getTotalNumberOfEntries()), sb), this.buildStat("bytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("total_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("connection_structures", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("cmd_get", BoxesRunTime.boxToLong((long)stats.getRetrievals()), sb), this.buildStat("cmd_set", BoxesRunTime.boxToLong((long)stats.getStores()), sb), this.buildStat("get_hits", BoxesRunTime.boxToLong((long)stats.getHits()), sb), this.buildStat("get_misses", BoxesRunTime.boxToLong((long)stats.getMisses()), sb), this.buildStat("delete_misses", BoxesRunTime.boxToLong((long)stats.getRemoveMisses()), sb), this.buildStat("delete_hits", BoxesRunTime.boxToLong((long)stats.getRemoveHits()), sb), this.buildStat("incr_misses", this.incrMisses(), sb), this.buildStat("incr_hits", this.incrHits(), sb), this.buildStat("decr_misses", this.decrMisses(), sb), this.buildStat("decr_hits", this.decrHits(), sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses(), sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits(), sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval(), sb), this.buildStat("auth_cmds", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("auth_errors", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("evictions", BoxesRunTime.boxToLong((long)stats.getEvictions()), sb), this.buildStat("bytes_read", this.transport.getTotalBytesRead(), sb), this.buildStat("bytes_written", this.transport.getTotalBytesWritten(), sb), this.buildStat("limit_maxbytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("threads", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("conn_yields", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("reclaimed", BoxesRunTime.boxToInteger((int)0), sb), ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{TextProtocolUtil$.MODULE$.END()}))};
    }

    private ChannelBuffer buildStat(String stat, Object value, java.lang.StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append(TextProtocolUtil$.MODULE$.CRLF());
        ChannelBuffer buffer = ExtendedChannelBuffer$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sb.toString().getBytes()}));
        sb.setLength(0);
        return buffer;
    }

    public ChannelBuffer org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(Enumeration.Value op, String k, CacheEntry entry) {
        ChannelBuffer buf = this.buildGetHeaderBegin(k, entry, 0);
        return this.writeGetHeaderData((byte[])entry.getValue(), buf);
    }

    private ChannelBuffer buildSingleGetResponse(String k, CacheEntry entry) {
        ChannelBuffer buf = this.buildGetHeaderBegin(k, entry, TextProtocolUtil$.MODULE$.END_SIZE());
        this.writeGetHeaderData((byte[])entry.getValue(), buf);
        return this.writeGetHeaderEnd(buf);
    }

    private ChannelBuffer buildGetHeaderBegin(String k, CacheEntry entry, int extraSpace) {
        MemcachedMetadata x2;
        byte[] data = (byte[])entry.getValue();
        byte[] dataSize = Integer.valueOf(data.length).toString().getBytes();
        byte[] key = k.getBytes();
        Metadata metadata = entry.getMetadata();
        byte[] byArray = metadata instanceof MemcachedMetadata && (x2 = (MemcachedMetadata)metadata).flags() != 0L ? Long.valueOf(x2.flags()).toString().getBytes() : TextProtocolUtil$.MODULE$.ZERO();
        byte[] flags = byArray;
        int flagsSize = flags.length;
        ChannelBuffer buf = ExtendedChannelBuffer$.MODULE$.buffer(TextProtocolUtil$.MODULE$.VALUE_SIZE() + key.length + data.length + flagsSize + dataSize.length + 6 + extraSpace);
        buf.writeBytes(TextProtocolUtil$.MODULE$.VALUE());
        buf.writeBytes(key);
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(flags);
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(dataSize);
        return buf;
    }

    private ChannelBuffer writeGetHeaderData(byte[] data, ChannelBuffer buf) {
        buf.writeBytes(TextProtocolUtil$.MODULE$.CRLFBytes());
        buf.writeBytes(data);
        buf.writeBytes(TextProtocolUtil$.MODULE$.CRLFBytes());
        return buf;
    }

    private ChannelBuffer writeGetHeaderEnd(ChannelBuffer buf) {
        buf.writeBytes(TextProtocolUtil$.MODULE$.END());
        return buf;
    }

    private ChannelBuffer buildSingleGetWithVersionResponse(String k, CacheEntry entry) {
        byte[] v = (byte[])entry.getValue();
        byte[] version = ((Object)BoxesRunTime.boxToLong((long)((NumericVersion)entry.getMetadata().version()).getVersion())).toString().getBytes();
        ChannelBuffer buf = this.buildGetHeaderBegin(k, entry, version.length + 1 + TextProtocolUtil$.MODULE$.END_SIZE());
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(version);
        this.writeGetHeaderData(v, buf);
        return this.writeGetHeaderEnd(buf);
    }

    private int friendlyMaxIntCheck(String number, String message) {
        int n;
        try {
            n = Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            n = this.numericLimitCheck(number, Integer.MAX_VALUE, message, numberFormatException);
        }
        return n;
    }

    private int numericLimitCheck(String number, long maxValue, String message, NumberFormatException n) {
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        throw n;
    }

    private long numericLimitCheck(String number, long maxValue, String message) {
        long numeric = Long.parseLong(number);
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        return numeric;
    }

    private final MemcachedParameters liftedTree1$1(ChannelBuffer b$1, Seq args$1, BooleanRef endOfOp$1) {
        try {
            MemcachedParameters memcachedParameters;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.PutRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                Enumeration.Value x2 = value;
                memcachedParameters = this.readStorageParameters((Seq<String>)args$1, b$1);
            } else {
                Enumeration.Value value4 = Operation$.MODULE$.RemoveRequest();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    Enumeration.Value x3 = value;
                    memcachedParameters = this.readRemoveParameters((Seq<String>)args$1);
                } else {
                    boolean bl;
                    Enumeration.Value value6 = MemcachedOperation$.MODULE$.IncrementRequest();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        Enumeration.Value x4 = value;
                        bl = true;
                    } else {
                        Enumeration.Value value8 = MemcachedOperation$.MODULE$.DecrementRequest();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            Enumeration.Value x5 = value;
                            bl = true;
                        } else {
                            bl = false;
                        }
                    }
                    if (bl) {
                        endOfOp$1.elem = true;
                        memcachedParameters = this.readIncrDecrParameters((Seq<String>)args$1);
                    } else {
                        Enumeration.Value value10 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            Enumeration.Value x6 = value;
                            memcachedParameters = this.readFlushAllParameters((Seq<String>)args$1);
                        } else {
                            memcachedParameters = this.readStorageParameters((Seq<String>)args$1, b$1);
                        }
                    }
                }
            }
            return memcachedParameters;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException(new StringBuilder().append((Object)"Missing content in command line ").append((Object)args$1).toString());
        }
    }

    public MemcachedDecoder(AdvancedCache<String, byte[]> memcachedCache, ScheduledExecutorService scheduler, NettyTransport transport) {
        this.scheduler = scheduler;
        this.transport = transport;
        super(transport);
        this.cache_$eq(memcachedCache.getAdvancedCache().withFlags(new Flag[]{Flag.OPERATION_MEMCACHED}));
        this.incrMisses = new AtomicLong(0L);
        this.incrHits = new AtomicLong(0L);
        this.decrMisses = new AtomicLong(0L);
        this.decrHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedMisses = new AtomicLong(0L);
        this.replaceIfUnmodifiedHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedBadval = new AtomicLong(0L);
        this.isTrace = this.isTraceEnabled();
        this.byteBuffer = new ByteArrayOutputStream();
    }
}

