package org.infinispan.server.memcached;
/**
 * Memcached value part of key/value pair containing flags on top the common
 * byte array and version.
 * <p>
 * The class can be marshalled either via its externalizer or via the JVM
 * serialization.  The reason for supporting both methods is to enable
 * third-party libraries to be able to marshall/unmarshall them using standard
 * JVM serialization rules.  The Infinispan marshalling layer will always
 * chose the most performant one, aka the AdvancedExternalizer method.
 * <p>
 * @author Galder Zamarre&#x00f1;o
 * @since 4.1
 */
public  class MemcachedValue extends org.infinispan.server.core.CacheValue {
  static public  class Externalizer extends org.infinispan.commons.marshall.AbstractExternalizer<org.infinispan.server.memcached.MemcachedValue> {
    public   Externalizer () { throw new RuntimeException(); }
    public  void writeObject (java.io.ObjectOutput output, org.infinispan.server.memcached.MemcachedValue cacheValue) { throw new RuntimeException(); }
    public  org.infinispan.server.memcached.MemcachedValue readObject (java.io.ObjectInput input) { throw new RuntimeException(); }
    public  java.util.Set<java.lang.Class<? extends org.infinispan.server.memcached.MemcachedValue>> getTypeClasses () { throw new RuntimeException(); }
  }
  public  byte[] data () { throw new RuntimeException(); }
  public  long version () { throw new RuntimeException(); }
  public  long flags () { throw new RuntimeException(); }
  // not preceding
  public   MemcachedValue (byte[] data, long version, long flags) { throw new RuntimeException(); }
  public  java.lang.String toString () { throw new RuntimeException(); }
}
