/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.MemcachedSingleNodeTest;
import org.infinispan.server.memcached.NoReplyListener;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.configuration.MemcachedServerConfigurationBuilder;
import org.infinispan.server.memcached.test.MemcachedTestingUtil$;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@Test(groups={"functional"}, testName="server.memcached.MemcachedFunctionalTest")
@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u0001\u0003\u0001-\u0011q#T3nG\u0006\u001c\u0007.\u001a3Gk:\u001cG/[8oC2$Vm\u001d;\u000b\u0005\r!\u0011!C7f[\u000e\f7\r[3e\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000f!\t!\"\u001b8gS:L7\u000f]1o\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\tia\"D\u0001\u0003\u0013\ty!AA\fNK6\u001c\u0017m\u00195fINKgn\u001a7f\u001d>$W\rV3ti\")\u0011\u0003\u0001C\u0001%\u00051A(\u001b8jiz\"\u0012a\u0005\t\u0003\u001b\u0001AQ!\u0006\u0001\u0005\u0002Y\tA\u0002^3tiN+GOQ1tS\u000e$\"aF\u000f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006=Q\u0001\raH\u0001\u0002[B\u0011\u0001eJ\u0007\u0002C)\u0011!eI\u0001\be\u00164G.Z2u\u0015\t!S%\u0001\u0003mC:<'\"\u0001\u0014\u0002\t)\fg/Y\u0005\u0003Q\u0005\u0012a!T3uQ>$\u0007\"\u0002\u0016\u0001\t\u0003Y\u0013\u0001\u0007;fgR\u001cV\r^,ji\",\u0005\u0010]5ssN+7m\u001c8egR\u0011q\u0003\f\u0005\u0006=%\u0002\ra\b\u0005\u0006]\u0001!\taL\u0001\u001ai\u0016\u001cHoU3u/&$\b.\u0012=qSJLXK\\5y)&lW\r\u0006\u0002\u0018a!)a$\fa\u0001?!)!\u0007\u0001C\u0001g\u0005yB/Z:u'\u0016$x+\u001b;i\u000bb\u0004\u0018N]=V]&DH+[7f\u0013:\u0004\u0016m\u001d;\u0015\u0005]!\u0004\"\u0002\u00102\u0001\u0004y\u0002\"\u0002\u001c\u0001\t\u00039\u0014a\u0005;fgR<U\r^'vYRL\u0007\u000f\\3LKf\u001cHCA\f9\u0011\u0015qR\u00071\u0001 \u0011\u0015Q\u0004\u0001\"\u0001<\u00031!Xm\u001d;BI\u0012\u0014\u0015m]5d)\t9B\bC\u0003\u001fs\u0001\u0007q\u0004C\u0003?\u0001\u0011\u0005q(\u0001\ruKN$\u0018\t\u001a3XSRDW\t\u001f9jef\u001cVmY8oIN$\"a\u0006!\t\u000byi\u0004\u0019A\u0010\t\u000b\t\u0003A\u0011A\"\u00023Q,7\u000f^!eI^KG\u000f[#ya&\u0014\u00180\u00168jqRKW.\u001a\u000b\u0003/\u0011CQAH!A\u0002}AQA\u0012\u0001\u0005\u0002\u001d\u000b1\u0003^3ti:{G/\u00113e\u0013\u001a\u0004&/Z:f]R$\"a\u0006%\t\u000by)\u0005\u0019A\u0010\t\u000b)\u0003A\u0011A&\u0002!Q,7\u000f\u001e*fa2\f7-\u001a\"bg&\u001cGCA\fM\u0011\u0015q\u0012\n1\u0001 \u0011\u0015q\u0005\u0001\"\u0001P\u0003i!Xm\u001d;O_R\u0014V\r\u001d7bG\u0016LeMT8u!J,7/\u001a8u)\t9\u0002\u000bC\u0003\u001f\u001b\u0002\u0007q\u0004C\u0003S\u0001\u0011\u00051+\u0001\u000fuKN$(+\u001a9mC\u000e,w+\u001b;i\u000bb\u0004\u0018N]=TK\u000e|g\u000eZ:\u0015\u0005]!\u0006\"\u0002\u0010R\u0001\u0004y\u0002\"\u0002,\u0001\t\u00039\u0016!\b;fgR\u0014V\r\u001d7bG\u0016<\u0016\u000e\u001e5FqBL'/_+oSb$\u0016.\\3\u0015\u0005]A\u0006\"\u0002\u0010V\u0001\u0004y\u0002\"\u0002.\u0001\t\u0003Y\u0016a\u0004;fgR\f\u0005\u000f]3oI\n\u000b7/[2\u0015\u0005]a\u0006\"\u0002\u0010Z\u0001\u0004y\u0002\"\u00020\u0001\t\u0003y\u0016A\u0005;fgR\f\u0005\u000f]3oI:{GOR8v]\u0012$\"a\u00061\t\u000byi\u0006\u0019A\u0010\t\u000b\t\u0004A\u0011A2\u0002!Q,7\u000f\u001e)sKB,g\u000e\u001a\"bg&\u001cGCA\fe\u0011\u0015q\u0012\r1\u0001 \u0011\u00151\u0007\u0001\"\u0001h\u0003M!Xm\u001d;Qe\u0016\u0004XM\u001c3O_R4u.\u001e8e)\t9\u0002\u000eC\u0003\u001fK\u0002\u0007q\u0004C\u0003k\u0001\u0011\u00051.A\u0007uKN$x)\u001a;t\u0005\u0006\u001c\u0018n\u0019\u000b\u0003/1DQAH5A\u0002}AQA\u001c\u0001\u0005\u0002=\fA\u0002^3ti\u000e\u000b7OQ1tS\u000e$\"a\u00069\t\u000byi\u0007\u0019A\u0010\t\u000bI\u0004A\u0011A:\u0002\u001fQ,7\u000f^\"bg:{GOR8v]\u0012$\"a\u0006;\t\u000by\t\b\u0019A\u0010\t\u000bY\u0004A\u0011A<\u0002\u001bQ,7\u000f^\"bg\u0016C\u0018n\u001d;t)\t9\u0002\u0010C\u0003\u001fk\u0002\u0007q\u0004C\u0003{\u0001\u0011\u000510\u0001\buKN$\u0018J\u001c<bY&$7)Y:\u0016\u0003]AQ! \u0001\u0005\u0002m\f1\u0003^3ti&sg/\u00197jI\u000e\u000b7OV1mk\u0016Daa \u0001\u0005\u0002\u0005\u0005\u0011a\u0004;fgR$U\r\\3uK\n\u000b7/[2\u0015\u0007]\t\u0019\u0001C\u0003\u001f}\u0002\u0007q\u0004C\u0004\u0002\b\u0001!\t!!\u0003\u0002-Q,7\u000f\u001e#fY\u0016$X\rR8fg:{G/\u0012=jgR$2aFA\u0006\u0011\u0019q\u0012Q\u0001a\u0001?!9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0011!\u0005;fgR$U\r\\3uK:{'+\u001a9msR\u0019q#a\u0005\t\ry\ti\u00011\u0001 \u0011\u001d\t9\u0002\u0001C\u0001\u00033\tQ\u0003^3tiN+G/\u00118e\u001bVdG/\u001b#fY\u0016$X\rF\u0002\u0018\u00037AaAHA\u000b\u0001\u0004y\u0002bBA\u0010\u0001\u0011\u0005\u0011\u0011E\u0001\u001ai\u0016\u001cHoU3u\u001d>\u0014V\r\u001d7z\u001bVdG/\u001b#fY\u0016$X\rF\u0002\u0018\u0003GAaAHA\u000f\u0001\u0004y\u0002bBA\u0014\u0001\u0011%\u0011\u0011F\u0001\fo&$\bNT8SKBd\u0017\u0010F\u0003\u0018\u0003W\ti\u0003\u0003\u0004\u001f\u0003K\u0001\ra\b\u0005\t\u0003_\t)\u00031\u0001\u00022\u0005\u0011q\u000e\u001d\t\u0005\u0003g\tIDD\u0002\u0019\u0003kI1!a\u000e\u001a\u0003\u0019\u0001&/\u001a3fM&!\u00111HA\u001f\u0005\u0019\u0019FO]5oO*\u0019\u0011qG\r\t\r\u0005\u0005\u0003\u0001\"\u0001|\u0003M!Xm\u001d;QSB,G.\u001b8fI\u0012+G.\u001a;f\u0011\u0019\t)\u0005\u0001C\u0001w\u0006yB/Z:u!&\u0004X\r\\5oK\u0012<U\r^!gi\u0016\u0014\u0018J\u001c<bY&$7)Y:\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L\u0005\u0011B/Z:u\u0013:\u001c'/Z7f]R\u0014\u0015m]5d)\r9\u0012Q\n\u0005\u0007=\u0005\u001d\u0003\u0019A\u0010\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T\u0005\u0019B/Z:u\u0013:\u001c'/Z7f]R$&/\u001b9mKR\u0019q#!\u0016\t\ry\ty\u00051\u0001 \u0011\u001d\tI\u0006\u0001C\u0001\u00037\nQ\u0003^3ti&s7M]3nK:$hj\u001c;Fq&\u001cH\u000fF\u0002\u0018\u0003;BaAHA,\u0001\u0004y\u0002bBA1\u0001\u0011\u0005\u00111M\u0001\u0018i\u0016\u001cH/\u00138de\u0016lWM\u001c;J]R,w-\u001a:NCb$2aFA3\u0011\u0019q\u0012q\fa\u0001?!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0014!\b;fgRLen\u0019:f[\u0016tGOQ3z_:$\u0017J\u001c;fO\u0016\u0014X*\u0019=\u0015\u0007]\ti\u0007\u0003\u0004\u001f\u0003O\u0002\ra\b\u0005\b\u0003c\u0002A\u0011AA:\u0003i!Xm\u001d;J]\u000e\u0014X-\\3oi\n+\u0017p\u001c8e\u0019>tw-T1y)\r9\u0012Q\u000f\u0005\u0007=\u0005=\u0004\u0019A\u0010\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|\u0005YB/Z:u\u0013:\u001c'/Z7f]R\u001cVO\u001d9bgNduN\\4NCb$2aFA?\u0011\u0019q\u0012q\u000fa\u0001?!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r\u0015!\b;fgRLen\u0019:f[\u0016tGoU;sa\u0006\u001c8OQ5h\u0013:$X*\u0019=\u0015\u0007]\t)\t\u0003\u0004\u001f\u0003\u007f\u0002\ra\b\u0005\b\u0003\u0013\u0003A\u0011AAF\u0003I!Xm\u001d;EK\u000e\u0014X-\\3oi\n\u000b7/[2\u0015\u0007]\ti\t\u0003\u0004\u001f\u0003\u000f\u0003\ra\b\u0005\b\u0003#\u0003A\u0011AAJ\u0003M!Xm\u001d;EK\u000e\u0014X-\\3oiR\u0013\u0018\u000e\u001d7f)\r9\u0012Q\u0013\u0005\u0007=\u0005=\u0005\u0019A\u0010\t\u000f\u0005e\u0005\u0001\"\u0001\u0002\u001c\u0006)B/Z:u\t\u0016\u001c'/Z7f]Rtu\u000e^#ySN$HcA\f\u0002\u001e\"1a$a&A\u0002}Aq!!)\u0001\t\u0003\t\u0019+\u0001\fuKN$H)Z2sK6,g\u000e\u001e\"fY><(,\u001a:p)\r9\u0012Q\u0015\u0005\u0007=\u0005}\u0005\u0019A\u0010\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\u0006aA/Z:u\r2,8\u000f[!mYR\u0019q#!,\t\ry\t9\u000b1\u0001 \u0011\u001d\t\t\f\u0001C\u0001\u0003g\u000b1\u0003^3ti\u001acWo\u001d5BY2$U\r\\1zK\u0012$2aFA[\u0011\u0019q\u0012q\u0016a\u0001?!9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0016a\u0007;fgR4E.^:i\u00032dG)\u001a7bs\u0016$WK\\5y)&lW\rF\u0002\u0018\u0003{CaAHA\\\u0001\u0004y\u0002bBAa\u0001\u0011%\u00111Y\u0001\u0010M2,8\u000f[!mY\u0012+G.Y=fIR9q#!2\u0002H\u0006E\u0007B\u0002\u0010\u0002@\u0002\u0007q\u0004\u0003\u0005\u0002J\u0006}\u0006\u0019AAf\u0003\u0015!W\r\\1z!\rA\u0012QZ\u0005\u0004\u0003\u001fL\"aA%oi\"A\u00111[A`\u0001\u0004\t).A\u0003tY\u0016,\u0007\u000fE\u0002\u0019\u0003/L1!!7\u001a\u0005\u0011auN\\4\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\u0006\u0019B/Z:u\r2,8\u000f[!mY:{'+\u001a9msR\u0019q#!9\t\ry\tY\u000e1\u0001 \u0011\u0019\t)\u000f\u0001C\u0001w\u0006!B/Z:u\r2,8\u000f[!mYBK\u0007/\u001a7j]\u0016Da!!;\u0001\t\u0003Y\u0018a\u0003;fgR4VM]:j_:Da!!<\u0001\t\u0003Y\u0018A\u0006;fgRLen\u0019:LKfdUM\\4uQ2KW.\u001b;\t\r\u0005E\b\u0001\"\u0001|\u0003U!Xm\u001d;HKR\\U-\u001f'f]\u001e$\b\u000eT5nSRDa!!>\u0001\t\u0003Y\u0018A\u0005;fgR,fn\u001b8po:\u001cu.\\7b]\u0012Da!!?\u0001\t\u0003Y\u0018a\u0007;fgR,fn\u001b8po:\u001cu.\\7b]\u0012\u0004\u0016\u000e]3mS:,G\r\u0003\u0004\u0002~\u0002!\ta_\u0001\u001di\u0016\u001cHOU3bI\u001a+H\u000e\u001c'j]\u0016\fe\r^3s\u0019>twmS3z\u0011\u0019\u0011\t\u0001\u0001C\u0001w\u0006aB/Z:u\u001d\u0016<\u0017\r^5wK\nKH/Z:MK:<G\u000f\u001b,bYV,\u0007b\u0002B\u0003\u0001\u0011\u0005!qA\u0001\u0014i\u0016\u001cHO\u00127bONL5/\u00168tS\u001etW\r\u001a\u000b\u0004/\t%\u0001B\u0002\u0010\u0003\u0004\u0001\u0007q\u0004C\u0004\u0003\u000e\u0001!\tAa\u0004\u0002-Q,7\u000f^%oGJ$Um\u0019:JgVs7/[4oK\u0012$2a\u0006B\t\u0011\u0019q\"1\u0002a\u0001?!1!Q\u0003\u0001\u0005\u0002m\fQ\u0002^3tiZ+'OY8tSRL\bb\u0002B\r\u0001\u0011\u0005!1D\u0001\ti\u0016\u001cH/U;jiR\u0019qC!\b\t\ry\u00119\u00021\u0001 \u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005G\t1\u0003^3tiN+GOQ5h'&TXMV1mk\u0016$2a\u0006B\u0013\u0011\u0019q\"q\u0004a\u0001?!1!\u0011\u0006\u0001\u0005\u0002m\f\u0011\u0004^3tiN#xN]3Bg\nKg.\u0019:z\u001fZ,'O]5eK\"9!Q\u0006\u0001\u0005\n\t=\u0012!C1eI\u0006sGmR3u)\r9\"\u0011\u0007\u0005\u0007=\t-\u0002\u0019A\u0010\t\u000f\tU\u0002\u0001\"\u0003\u00038\u0005!\u0011N\\2s)\u0019\t\tD!\u000f\u0003<!1aDa\rA\u0002}A\u0001B!\u0010\u00034\u0001\u0007\u00111Z\u0001\u0003EfDqA!\u000e\u0001\t\u0013\u0011\t\u0005\u0006\u0004\u00022\t\r#q\t\u0005\t\u0005\u000b\u0012y\u00041\u0001\u00022\u0005\t1\u000e\u0003\u0005\u0003>\t}\u0002\u0019AAfQ-\u0001!1\nB.\u0005;\u0012\u0019G!\u001a\u0011\t\t5#qK\u0007\u0003\u0005\u001fRAA!\u0015\u0003T\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\r\u0011)\u0006C\u0001\u0007i\u0016\u001cHO\\4\n\t\te#q\n\u0002\u0005)\u0016\u001cH/\u0001\u0004he>,\bo\u001d\u0017\u0003\u0005?\n#A!\u0019\u0002\u0015\u0019,hn\u0019;j_:\fG.\u0001\u0005uKN$h*Y7fC\t\u00119'\u0001\u0015tKJ4XM\u001d\u0018nK6\u001c\u0017m\u00195fI:jU-\\2bG\",GMR;oGRLwN\\1m)\u0016\u001cH\u000f")
public class MemcachedFunctionalTest
extends MemcachedSingleNodeTest {
    public void testSetBasic(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
    }

    public void testSetWithExpirySeconds(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 1, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m)));
    }

    public void testSetWithExpiryUnixTime(Method m) {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().set(TestingUtil.k((Method)m), future, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m)));
    }

    public void testSetWithExpiryUnixTimeInPast(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 2592001, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m)));
    }

    public void testGetMultipleKeys(Method m) {
        Future f1 = this.client().set(TestingUtil.k((Method)m, (String)"k1-"), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Future f2 = this.client().set(TestingUtil.k((Method)m, (String)"k2-"), 0, (Object)TestingUtil.v((Method)m, (String)"v2-"));
        Future f3 = this.client().set(TestingUtil.k((Method)m, (String)"k3-"), 0, (Object)TestingUtil.v((Method)m, (String)"v3-"));
        Assert.assertTrue((boolean)((Boolean)f1.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f2.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f3.get(this.timeout(), TimeUnit.SECONDS)));
        List keys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TestingUtil.k((Method)m, (String)"k1-"), TestingUtil.k((Method)m, (String)"k2-"), TestingUtil.k((Method)m, (String)"k3-")}));
        Map ret = this.client().getBulk((String[])keys.toArray(ClassTag$.MODULE$.apply(String.class)));
        Assert.assertEquals(ret.get(TestingUtil.k((Method)m, (String)"k1-")), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertEquals(ret.get(TestingUtil.k((Method)m, (String)"k2-")), (Object)TestingUtil.v((Method)m, (String)"v2-"));
        Assert.assertEquals(ret.get(TestingUtil.k((Method)m, (String)"k3-")), (Object)TestingUtil.v((Method)m, (String)"v3-"));
    }

    public void testAddBasic(Method m) {
        this.addAndGet(m);
    }

    public void testAddWithExpirySeconds(Method m) {
        Future f = this.client().add(TestingUtil.k((Method)m), 1, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m)));
        f = this.client().add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m, (String)"v1-"));
    }

    public void testAddWithExpiryUnixTime(Method m) {
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().add(TestingUtil.k((Method)m), future, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m)));
        f = this.client().add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m, (String)"v1-"));
    }

    public void testNotAddIfPresent(Method m) {
        this.addAndGet(m);
        Future f = this.client().add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
    }

    public void testReplaceBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().replace(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m, (String)"v1-"));
    }

    public void testNotReplaceIfNotPresent(Method m) {
        Future f = this.client().replace(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m)));
    }

    public void testReplaceWithExpirySeconds(Method m) {
        this.addAndGet(m);
        Future f = this.client().replace(TestingUtil.k((Method)m), 1, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m)));
    }

    public void testReplaceWithExpiryUnixTime(Method m) {
        this.addAndGet(m);
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        Future f = this.client().replace(TestingUtil.k((Method)m), future, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m)));
    }

    public void testAppendBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().append(0L, TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)TestingUtil.v((Method)m)).append((Object)TestingUtil.v((Method)m, (String)"v1-")).toString();
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)expected);
    }

    public void testAppendNotFound(Method m) {
        this.addAndGet(m);
        Future f = this.client().append(0L, TestingUtil.k((Method)m, (String)"k2-"), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m, (String)"k2-")));
    }

    public void testPrependBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().prepend(0L, TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)TestingUtil.v((Method)m, (String)"v1-")).append((Object)TestingUtil.v((Method)m)).toString();
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)expected);
    }

    public void testPrependNotFound(Method m) {
        this.addAndGet(m);
        Future f = this.client().prepend(0L, TestingUtil.k((Method)m, (String)"k2-"), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m, (String)"k2-")));
    }

    public void testGetsBasic(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(TestingUtil.k((Method)m));
        Assert.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
    }

    public void testCasBasic(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(TestingUtil.k((Method)m));
        Assert.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client().cas(TestingUtil.k((Method)m), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testCasNotFound(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(TestingUtil.k((Method)m));
        Assert.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        CASResponse resp = this.client().cas(TestingUtil.k((Method)m, (String)"k1-"), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.NOT_FOUND);
    }

    public void testCasExists(Method m) {
        this.addAndGet(m);
        CASValue value = this.client().gets(TestingUtil.k((Method)m));
        Assert.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        long old = value.getCas();
        CASResponse resp = this.client().cas(TestingUtil.k((Method)m), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        value = this.client().gets(TestingUtil.k((Method)m));
        Assert.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((value.getCas() != old ? 1 : 0) != 0);
        resp = this.client().cas(TestingUtil.k((Method)m), old, (Object)TestingUtil.v((Method)m, (String)"v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.EXISTS);
        resp = this.client().cas(TestingUtil.k((Method)m), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testInvalidCas() {
        String resp = this.send("cas bad blah 0 0 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 blah 0 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 0 blah 0\r\n\r\n");
        this.assertClientError(resp);
        resp = this.send("cas bad 0 0 0 blah\r\n\r\n");
        this.assertClientError(resp);
    }

    public void testInvalidCasValue() {
        String resp = this.send("cas foo 0 0 6 \r\nbarva2\r\n");
        this.assertClientError(resp);
    }

    public void testDeleteBasic(Method m) {
        this.addAndGet(m);
        Future f = this.client().delete(TestingUtil.k((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m)));
    }

    public void testDeleteDoesNotExist(Method m) {
        Future f = this.client().delete(TestingUtil.k((Method)m));
        Assert.assertFalse((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
    }

    public void testDeleteNoReply(Method m) {
        this.withNoReply(m, new StringOps(Predef$.MODULE$.augmentString("delete %s noreply\r\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TestingUtil.k((Method)m)})));
    }

    public void testSetAndMultiDelete(Method m) {
        String key = TestingUtil.k((Method)m);
        List<String> responses = this.sendMulti(new StringOps(Predef$.MODULE$.augmentString("set %s 0 0 1\r\na\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, key, key, key, key})), 5, true);
        Assert.assertEquals((int)responses.length(), (int)5);
        Assert.assertEquals((String)((String)responses.head()), (String)"STORED");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"DELETED");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)responses.tail()).tail()).head()), (String)"NOT_FOUND");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)((TraversableLike)responses.tail()).tail()).tail()).head()), (String)"NOT_FOUND");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)((TraversableLike)((TraversableLike)responses.tail()).tail()).tail()).tail()).head()), (String)"NOT_FOUND");
    }

    public void testSetNoReplyMultiDelete(Method m) {
        String key = TestingUtil.k((Method)m);
        List<String> responses = this.sendMulti(new StringOps(Predef$.MODULE$.augmentString("set %s 0 0 1 noreply\r\na\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\ndelete %s\r\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, key, key, key, key})), 4, true);
        Assert.assertEquals((int)responses.length(), (int)4);
        Assert.assertEquals((String)((String)responses.head()), (String)"DELETED");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"NOT_FOUND");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)responses.tail()).tail()).head()), (String)"NOT_FOUND");
        Assert.assertEquals((String)((String)((IterableLike)((TraversableLike)((TraversableLike)responses.tail()).tail()).tail()).head()), (String)"NOT_FOUND");
    }

    private void withNoReply(Method m, String op) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)"blah");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        CountDownLatch latch = new CountDownLatch(1);
        NoReplyListener listener = new NoReplyListener(latch);
        this.cache.addListener((Object)listener);
        try {
            this.sendNoWait(op);
            this.log.debug((Object)"No reply delete sent, wait...");
            boolean completed = latch.await(10L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)completed, (String)"Timed out waiting for remove to be executed");
            return;
        }
        finally {
            this.cache.removeListener((Object)listener);
        }
    }

    public void testPipelinedDelete() {
        List<String> responses = this.sendMulti("delete a\r\ndelete a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        responses.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String r) {
                String string = r;
                String string2 = "NOT_FOUND";
                Assert.assertTrue((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
            }
        });
    }

    public void testPipelinedGetAfterInvalidCas() {
        List<String> responses = this.sendMulti("cas bad 0 0 1 0 0\r\nget a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertTrue((boolean)((String)responses.head()).contains("CLIENT_ERROR"));
        Object object = ((IterableLike)responses.tail()).head();
        String string = "END";
        Assert.assertTrue((!(object != null ? !object.equals(string) : string != null) ? 1 : 0) != 0, (String)new StringBuilder().append((Object)"Instead response was: ").append(((IterableLike)responses.tail()).head()).toString());
    }

    public void testIncrementBasic(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long result = this.client().incr(TestingUtil.k((Method)m), 1);
        Assert.assertEquals((long)result, (long)2L);
    }

    public void testIncrementTriple(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().incr(TestingUtil.k((Method)m), 1), (long)2L);
        Assert.assertEquals((long)this.client().incr(TestingUtil.k((Method)m), 2), (long)4L);
        Assert.assertEquals((long)this.client().incr(TestingUtil.k((Method)m), 4), (long)8L);
    }

    public void testIncrementNotExist(Method m) {
        Assert.assertEquals((long)this.client().incr(TestingUtil.k((Method)m), 1), (long)-1L);
    }

    public void testIncrementIntegerMax(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().incr(TestingUtil.k((Method)m), Integer.MAX_VALUE), (long)Integer.MAX_VALUE);
    }

    public void testIncrementBeyondIntegerMax(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long newValue = this.client().incr(TestingUtil.k((Method)m), Integer.MAX_VALUE);
        Assert.assertEquals((long)newValue, (long)((long)Integer.MAX_VALUE + 1L));
    }

    public void testIncrementBeyondLongMax(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)"9223372036854775808");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        Assert.assertEquals((Object)package$.MODULE$.BigInt().apply(newValue), (Object)package$.MODULE$.BigInt().apply("9223372036854775809"));
    }

    public void testIncrementSurpassLongMax(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)"9223372036854775807");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        Assert.assertEquals((Object)package$.MODULE$.BigInt().apply(newValue), (Object)package$.MODULE$.BigInt().apply("9223372036854775808"));
    }

    public void testIncrementSurpassBigIntMax(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)"18446744073709551615");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String newValue = this.incr(m, 1);
        Assert.assertEquals((String)newValue, (String)"0");
    }

    public void testDecrementBasic(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().decr(TestingUtil.k((Method)m), 1), (long)0L);
    }

    public void testDecrementTriple(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)"8");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)this.client().decr(TestingUtil.k((Method)m), 1), (long)7L);
        Assert.assertEquals((long)this.client().decr(TestingUtil.k((Method)m), 2), (long)5L);
        Assert.assertEquals((long)this.client().decr(TestingUtil.k((Method)m), 4), (long)1L);
    }

    public void testDecrementNotExist(Method m) {
        Assert.assertEquals((long)this.client().decr(TestingUtil.k((Method)m), 1), (long)-1L);
    }

    public void testDecrementBelowZero(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        long newValue = this.client().decr(TestingUtil.k((Method)m), 2);
        Assert.assertEquals((long)newValue, (long)0L);
    }

    public void testFlushAll(Method m) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemcachedFunctionalTest $outer;
            private final Method m$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String key = TestingUtil.k((Method)this.m$1, (String)new StringBuilder().append((Object)"k").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"-").toString());
                String value = TestingUtil.v((Method)this.m$1, (String)new StringBuilder().append((Object)"v").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"-").toString());
                Future f = this.$outer.client().set(key, 0, (Object)value);
                Assert.assertTrue((boolean)((Boolean)f.get(this.$outer.timeout(), TimeUnit.SECONDS)));
                Assert.assertEquals((Object)this.$outer.client().get(key), (Object)value);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.m$1 = m$1;
            }
        });
        Future f = this.client().flush();
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemcachedFunctionalTest $outer;
            private final Method m$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String key = TestingUtil.k((Method)this.m$1, (String)new StringBuilder().append((Object)"k").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"-").toString());
                Assert.assertNull((Object)this.$outer.client().get(key));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.m$1 = m$1;
            }
        });
    }

    public void testFlushAllDelayed(Method m) {
        this.flushAllDelayed(m, 2, 2200L);
    }

    public void testFlushAllDelayedUnixTime(Method m) {
        int delay = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 2000L);
        this.flushAllDelayed(m, delay, 2200L);
    }

    private void flushAllDelayed(Method m, int delay, long sleep) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemcachedFunctionalTest $outer;
            private final Method m$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String key = TestingUtil.k((Method)this.m$2, (String)new StringBuilder().append((Object)"k").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"-").toString());
                String value = TestingUtil.v((Method)this.m$2, (String)new StringBuilder().append((Object)"v").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"-").toString());
                Future f = this.$outer.client().set(key, 0, (Object)value);
                Assert.assertTrue((boolean)((Boolean)f.get(this.$outer.timeout(), TimeUnit.SECONDS)));
                Assert.assertEquals((Object)this.$outer.client().get(key), (Object)value);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.m$2 = m$2;
            }
        });
        Future f = this.client().flush(delay);
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)sleep);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 5).foreach$mVc$sp((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemcachedFunctionalTest $outer;
            private final Method m$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                String key = TestingUtil.k((Method)this.m$2, (String)new StringBuilder().append((Object)"k").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)"-").toString());
                Assert.assertNull((Object)this.$outer.client().get(key));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.m$2 = m$2;
            }
        });
    }

    public void testFlushAllNoReply(Method m) {
        this.withNoReply(m, "flush_all noreply\r\n");
    }

    public void testFlushAllPipeline() {
        List<String> responses = this.sendMulti("flush_all\r\nget a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertEquals((String)((String)responses.head()), (String)"OK");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"END");
    }

    public void testVersion() {
        Map versions = this.client().getVersions();
        Assert.assertEquals((int)versions.size(), (int)1);
        String version = (String)versions.values().iterator().next();
        Assert.assertEquals((String)version, (String)Version.VERSION);
    }

    public void testIncrKeyLengthLimit() {
        String keyUnderLimit = TestingUtil.generateRandomString((int)249);
        Future f = this.client().set(keyUnderLimit, 0, (Object)"78");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(keyUnderLimit), (Object)"78");
        String keyInLimit = TestingUtil.generateRandomString((int)250);
        f = this.client().set(keyInLimit, 0, (Object)"89");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(keyInLimit), (Object)"89");
        String keyAboveLimit = TestingUtil.generateRandomString((int)251);
        String resp = this.incr(keyAboveLimit, 1);
        this.assertClientError(resp);
    }

    public void testGetKeyLengthLimit() {
        String tooLongKey = TestingUtil.generateRandomString((int)251);
        String resp = this.send(new StringBuilder().append((Object)"get ").append((Object)tooLongKey).append((Object)"\r\n").toString());
        this.assertClientError(resp);
        tooLongKey = TestingUtil.generateRandomString((int)251);
        resp = this.send(new StringBuilder().append((Object)"get k1 k2 k3 ").append((Object)tooLongKey).append((Object)"\r\n").toString());
        this.assertClientError(resp);
    }

    public void testUnknownCommand() {
        this.assertError(this.send("blah\r\n"));
        this.assertError(this.send("blah boo poo goo zoo\r\n"));
    }

    public void testUnknownCommandPipelined() {
        List<String> responses = this.sendMulti("bogus\r\ndelete a\r\n", 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertEquals((String)((String)responses.head()), (String)"ERROR");
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"NOT_FOUND");
    }

    public void testReadFullLineAfterLongKey() {
        String key = TestingUtil.generateRandomString((int)300);
        String command = new StringBuilder().append((Object)"add ").append((Object)key).append((Object)" 0 0 1\r\nget a\r\n").toString();
        List<String> responses = this.sendMulti(command, 2, true);
        Assert.assertEquals((int)responses.length(), (int)2);
        Assert.assertTrue((boolean)((String)responses.head()).contains("CLIENT_ERROR"));
        Assert.assertEquals((String)((String)((IterableLike)responses.tail()).head()), (String)"END");
    }

    public void testNegativeBytesLengthValue() {
        this.assertClientError(this.send("set boo1 0 0 -1\r\n"));
        this.assertClientError(this.send("add boo2 0 0 -1\r\n"));
    }

    public void testFlagsIsUnsigned(Method m) {
        String k = m.getName();
        this.assertClientError(this.send("set boo1 -1 0 0\r\n"));
        this.assertStored(this.send(new StringBuilder().append((Object)"set ").append((Object)k).append((Object)" 4294967295 0 0\r\n").toString()));
        this.assertClientError(this.send("set boo2 4294967296 0 0\r\n"));
        this.assertClientError(this.send("set boo2 18446744073709551615 0 0\r\n"));
    }

    public void testIncrDecrIsUnsigned(Method m) {
        String k = m.getName();
        Future f = this.client().set(k, 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.assertClientError(this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" -1\r\n").toString()));
        this.assertClientError(this.send(new StringBuilder().append((Object)"decr ").append((Object)k).append((Object)" -1\r\n").toString()));
        k = new StringBuilder().append((Object)k).append((Object)"-1").toString();
        f = this.client().set(k, 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.assertExpectedResponse(this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" 18446744073709551615\r\n").toString()), "18446744073709551615", true);
        k = new StringBuilder().append((Object)k).append((Object)"-1").toString();
        f = this.client().set(k, 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.assertClientError(this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" 18446744073709551616\r\n").toString()));
        this.assertClientError(this.send(new StringBuilder().append((Object)"decr ").append((Object)k).append((Object)" 18446744073709551616\r\n").toString()));
    }

    public void testVerbosity() {
        this.assertClientError(this.send("verbosity\r\n"));
        this.assertClientError(this.send("verbosity 5\r\n"));
        this.assertClientError(this.send("verbosity 10 noreply\r\n"));
    }

    public void testQuit(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)"0");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        this.sendNoWait("quit\r\n");
    }

    public void testSetBigSizeValue(Method m) {
        Future f = this.client().set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.generateRandomString((int)0x100000).getBytes());
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
    }

    public void testStoreAsBinaryOverride() {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)false);
        builder.storeAsBinary().enable();
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
        Configuration cfg = builder.build();
        cm.defineConfiguration(new MemcachedServerConfigurationBuilder().build().cache(), cfg);
        Assert.assertTrue((boolean)cfg.storeAsBinary().enabled());
        MemcachedServer testServer = MemcachedTestingUtil$.MODULE$.startMemcachedTextServer(cm, this.server().getPort() + 33);
        try {
            Cache memcachedCache = cm.getCache(((MemcachedServerConfiguration)testServer.getConfiguration()).cache());
            Assert.assertFalse((boolean)memcachedCache.getCacheConfiguration().storeAsBinary().enabled());
            return;
        }
        finally {
            cm.stop();
            testServer.stop();
        }
    }

    private void addAndGet(Method m) {
        Future f = this.client().add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
    }

    private String incr(Method m, int by) {
        return this.incr(TestingUtil.k((Method)m), by);
    }

    private String incr(String k, int by) {
        return this.send(new StringBuilder().append((Object)"incr ").append((Object)k).append((Object)" ").append((Object)BoxesRunTime.boxToInteger((int)by)).append((Object)"\r\n").toString());
    }
}

