/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.server.core.AbstractProtocolDecoder;
import org.infinispan.server.core.DecoderState;
import org.infinispan.server.core.Operation$;
import org.infinispan.server.core.RequestHeader;
import org.infinispan.server.core.UnknownOperationException;
import org.infinispan.server.core.transport.ExtendedByteBuf$;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.memcached.DelayedFlushAll;
import org.infinispan.server.memcached.MemcachedException;
import org.infinispan.server.memcached.MemcachedMetadata;
import org.infinispan.server.memcached.MemcachedMetadataBuilder;
import org.infinispan.server.memcached.MemcachedOperation$;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.RequestResolver$;
import org.infinispan.server.memcached.TextProtocolUtil$;
import org.infinispan.stats.Stats;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rUh\u0001B\u0001\u0003\u0001-\u0011\u0001#T3nG\u0006\u001c\u0007.\u001a3EK\u000e|G-\u001a:\u000b\u0005\r!\u0011!C7f[\u000e\f7\r[3e\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000f!\t!\"\u001b8gS:L7\u000f]1o\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\u0011i\u0001C\u0005\u0011\u000e\u00039Q!a\u0004\u0003\u0002\t\r|'/Z\u0005\u0003#9\u0011q#\u00112tiJ\f7\r\u001e)s_R|7m\u001c7EK\u000e|G-\u001a:\u0011\u0005MibB\u0001\u000b\u001b\u001d\t)\u0002$D\u0001\u0017\u0015\t9\"\"\u0001\u0004=e>|GOP\u0005\u00023\u0005)1oY1mC&\u00111\u0004H\u0001\u0007!J,G-\u001a4\u000b\u0003eI!AH\u0010\u0003\rM#(/\u001b8h\u0015\tYB\u0004E\u0002\"E\u0011j\u0011\u0001H\u0005\u0003Gq\u0011Q!\u0011:sCf\u0004\"!I\u0013\n\u0005\u0019b\"\u0001\u0002\"zi\u0016D\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\u000f[\u0016l7-Y2iK\u0012\u001c\u0015m\u00195f!\u0011Q3F\u0005\u0011\u000e\u0003\u0019I!\u0001\f\u0004\u0003\u001b\u0005#g/\u00198dK\u0012\u001c\u0015m\u00195f\u0011!q\u0003A!A!\u0002\u0013y\u0013!C:dQ\u0016$W\u000f\\3s!\t\u0001t'D\u00012\u0015\t\u00114'\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001N\u001b\u0002\tU$\u0018\u000e\u001c\u0006\u0002m\u0005!!.\u0019<b\u0013\tA\u0014G\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016D\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IaO\u0001\niJ\fgn\u001d9peR\u0004\"\u0001\u0010 \u000e\u0003uR!A\u000f\b\n\u0005}j$A\u0004(fiRLHK]1ogB|'\u000f\u001e\u0005\u0006\u0003\u0002!\tAQ\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\r+ei\u0012\t\u0003\t\u0002i\u0011A\u0001\u0005\u0006Q\u0001\u0003\r!\u000b\u0005\u0006]\u0001\u0003\ra\f\u0005\u0006u\u0001\u0003\raO\u0003\u0005\u0013\u0002\u0001!J\u0001\nTk&$\u0018M\u00197f!\u0006\u0014\u0018-\\3uKJ\u001c\bC\u0001#L\u0013\ta%AA\nNK6\u001c\u0017m\u00195fIB\u000b'/Y7fi\u0016\u00148/\u0002\u0003O\u0001\u0001y%AD*vSR\f'\r\\3IK\u0006$WM\u001d\t\u0003\u001bAK!!\u0015\b\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011!\u0019\u0006\u0001#b\u0001\n\u0013!\u0016AD5t'R\fGo]#oC\ndW\rZ\u000b\u0002+B\u0011\u0011EV\u0005\u0003/r\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005Z\u0001!\u0005\t\u0015)\u0003V\u0003=I7o\u0015;biN,e.\u00192mK\u0012\u0004\u0003bB.\u0001\u0005\u0004%i\u0001X\u0001\u000bS:\u001c'/T5tg\u0016\u001cX#A/\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001\f\u0014AB1u_6L7-\u0003\u0002c?\nQ\u0011\t^8nS\u000eduN\\4\t\r\u0011\u0004\u0001\u0015!\u0004^\u0003-Ign\u0019:NSN\u001cXm\u001d\u0011\t\u000f\u0019\u0004!\u0019!C\u00079\u0006A\u0011N\\2s\u0011&$8\u000f\u0003\u0004i\u0001\u0001\u0006i!X\u0001\nS:\u001c'\u000fS5ug\u0002BqA\u001b\u0001C\u0002\u00135A,\u0001\u0006eK\u000e\u0014X*[:tKNDa\u0001\u001c\u0001!\u0002\u001bi\u0016a\u00033fGJl\u0015n]:fg\u0002BqA\u001c\u0001C\u0002\u00135A,\u0001\u0005eK\u000e\u0014\b*\u001b;t\u0011\u0019\u0001\b\u0001)A\u0007;\u0006IA-Z2s\u0011&$8\u000f\t\u0005\be\u0002\u0011\r\u0011\"\u0004]\u0003e\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u001b&\u001c8/Z:\t\rQ\u0004\u0001\u0015!\u0004^\u0003i\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u001b&\u001c8/Z:!\u0011\u001d1\bA1A\u0005\u000eq\u000bqC]3qY\u0006\u001cW-\u00134V]6|G-\u001b4jK\u0012D\u0015\u000e^:\t\ra\u0004\u0001\u0015!\u0004^\u0003a\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0011&$8\u000f\t\u0005\bu\u0002\u0011\r\u0011\"\u0004]\u0003e\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0005\u0006$g/\u00197\t\rq\u0004\u0001\u0015!\u0004^\u0003i\u0011X\r\u001d7bG\u0016Le-\u00168n_\u0012Lg-[3e\u0005\u0006$g/\u00197!\u0011\u001dq\bA1A\u0005\nQ\u000bq![:Ue\u0006\u001cW\rC\u0004\u0002\u0002\u0001\u0001\u000b\u0011B+\u0002\u0011%\u001cHK]1dK\u0002B\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\u0002\u0015\tLH/\u001a\"vM\u001a,'/\u0006\u0002\u0002\nA!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010U\n!![8\n\t\u0005M\u0011Q\u0002\u0002\u0016\u0005f$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1n\u0011!\t9\u0002\u0001Q\u0001\n\u0005%\u0011a\u00032zi\u0016\u0014UO\u001a4fe\u0002Bq!a\u0007\u0001\t\u0003\ni\"\u0001\u0004eK\u000e|G-\u001a\u000b\t\u0003?\t)#a\u000f\u0002LA\u0019\u0011%!\t\n\u0007\u0005\rBD\u0001\u0003V]&$\b\u0002CA\u0014\u00033\u0001\r!!\u000b\u0002\u0007\r$\b\u0010\u0005\u0003\u0002,\u0005]RBAA\u0017\u0015\u0011\ty#!\r\u0002\u000f\rD\u0017M\u001c8fY*!\u00111GA\u001b\u0003\u0015qW\r\u001e;z\u0015\t\ty!\u0003\u0003\u0002:\u00055\"!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\t\u0003{\tI\u00021\u0001\u0002@\u0005\u0011\u0011N\u001c\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)!\u0011QIA\u0019\u0003\u0019\u0011WO\u001a4fe&!\u0011\u0011JA\"\u0005\u001d\u0011\u0015\u0010^3Ck\u001aD\u0001\"!\u0014\u0002\u001a\u0001\u0007\u0011qJ\u0001\u0004_V$\bCBA)\u0003'\n9&D\u00014\u0013\r\t)f\r\u0002\u0005\u0019&\u001cH\u000fE\u0002\"\u00033J1!a\u0017\u001d\u0005\u0019\te.\u001f*fM\"9\u0011q\f\u0001\u0005B\u0005\u0005\u0014\u0001D2sK\u0006$X\rS3bI\u0016\u0014X#A(\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h\u0005Q!/Z1e\u0011\u0016\fG-\u001a:\u0015\r\u0005%\u0014qNA9!\u0011\t\u00131N+\n\u0007\u00055DD\u0001\u0004PaRLwN\u001c\u0005\t\u0003\u000b\n\u0019\u00071\u0001\u0002@!9\u00111OA2\u0001\u0004y\u0015A\u00025fC\u0012,'\u000fC\u0004\u0002x\u0001!\t%!\u001f\u0002\u000fI,\u0017\rZ&fsR!\u00111PAA!\u0015\t\u0013Q\u0010\nV\u0013\r\ty\b\b\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005\r\u0015Q\u000fa\u0001\u0003\u007f\t\u0011A\u0019\u0005\b\u0003\u000f\u0003A\u0011BAE\u0003!\u0011X-\u00193LKf\u001cH\u0003BAF\u00033\u0003R!!$\u0002\u0014Jq1\u0001FAH\u0013\r\t\t\nH\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)*a&\u0003\u0007M+\u0017OC\u0002\u0002\u0012rA\u0001\"a!\u0002\u0006\u0002\u0007\u0011q\b\u0005\b\u0003;\u0003A\u0011KAP\u0003\r9W\r\u001e\u000b\u0005\u0003/\n\t\u000b\u0003\u0005\u0002F\u0005m\u0005\u0019AA \u0011\u001d\t)\u000b\u0001C\u0005\u0003O\u000bab\u00195fG.\\U-\u001f'f]\u001e$\b\u000eF\u0004\u0013\u0003S\u000bi+!-\t\u000f\u0005-\u00161\u0015a\u0001%\u0005\t1\u000eC\u0004\u00020\u0006\r\u0006\u0019A+\u0002\u000f\u0015tGm\u00144Pa\"A\u00111QAR\u0001\u0004\ty\u0004C\u0004\u00026\u0002!\t%a.\u0002\u001dI,\u0017\r\u001a)be\u0006lW\r^3sgR)Q+!/\u0002D\"A\u00111XAZ\u0001\u0004\ti,\u0001\u0002dQB!\u00111FA`\u0013\u0011\t\t-!\f\u0003\u000f\rC\u0017M\u001c8fY\"A\u00111QAZ\u0001\u0004\ty\u0004C\u0004\u0002H\u0002!I!!3\u0002)I,\u0017\r\u001a*f[>4X\rU1sC6,G/\u001a:t)\rQ\u00151\u001a\u0005\t\u0003\u001b\f)\r1\u0001\u0002\f\u0006!\u0011M]4t\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'\faC]3bI&s7M\u001d#fGJ\u0004\u0016M]1nKR,'o\u001d\u000b\u0004\u0015\u0006U\u0007\u0002CAg\u0003\u001f\u0004\r!a#\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\u00061\"/Z1e\r2,8\u000f[!mYB\u000b'/Y7fi\u0016\u00148\u000fF\u0002K\u0003;D\u0001\"!4\u0002X\u0002\u0007\u00111\u0012\u0005\b\u0003C\u0004A\u0011BAr\u0003U\u0011X-\u00193Ti>\u0014\u0018mZ3QCJ\fW.\u001a;feN$RASAs\u0003OD\u0001\"!4\u0002`\u0002\u0007\u00111\u0012\u0005\t\u0003\u0007\u000by\u000e1\u0001\u0002@!9\u00111\u001e\u0001\u0005R\u00055\u0018!\u0003:fC\u00124\u0016\r\\;f)\u0011\ty\"a<\t\u0011\u0005\r\u0015\u0011\u001ea\u0001\u0003\u007fAq!a=\u0001\t\u0003\n)0A\u0006de\u0016\fG/\u001a,bYV,G#\u0001\u0011\t\u000f\u0005e\b\u0001\"\u0003\u0002|\u0006Aq-\u001a;GY\u0006<7\u000f\u0006\u0003\u0002~\n\r\u0001cA\u0011\u0002\u0000&\u0019!\u0011\u0001\u000f\u0003\t1{gn\u001a\u0005\b\u0005\u000b\t9\u00101\u0001\u0013\u0003\u00151G.Y4t\u0011\u001d\u0011I\u0001\u0001C\u0005\u0005\u0017\t1bZ3u\u0019&4Wm\u001d9b]R!!Q\u0002B\n!\r\t#qB\u0005\u0004\u0005#a\"aA%oi\"9!Q\u0003B\u0004\u0001\u0004\u0011\u0012\u0001\u00037jM\u0016\u001c\b/\u00198\t\u000f\te\u0001\u0001\"\u0003\u0003\u001c\u0005Iq-\u001a;MK:<G\u000f\u001b\u000b\u0005\u0005\u001b\u0011i\u0002C\u0004\u0003 \t]\u0001\u0019\u0001\n\u0002\r1,gn\u001a;i\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005K\t!bZ3u-\u0016\u00148/[8o)\u0011\tiPa\n\t\u000f\t%\"\u0011\u0005a\u0001%\u00059a/\u001a:tS>t\u0007b\u0002B\u0017\u0001\u0011%!qF\u0001\ra\u0006\u00148/\u001a(p%\u0016\u0004H.\u001f\u000b\u0006+\nE\"Q\u0007\u0005\t\u0005g\u0011Y\u00031\u0001\u0003\u000e\u0005iQ\r\u001f9fGR,G-\u00138eKbD\u0001\"!4\u0003,\u0001\u0007\u00111\u0012\u0005\b\u0005s\u0001A\u0011\u0002B\u001e\u0003Y\u0001\u0018M]:f\t\u0016d\u0017-_3e\t\u0016dW\r^3US6,G\u0003\u0002B\u0007\u0005{A\u0001\"!4\u00038\u0001\u0007\u00111\u0012\u0005\b\u0005\u0003\u0002A\u0011\tB\"\u0003!9W\r^\"bG\",WC\u0001B#!\u0015Q#q\t\n!\u0013\r\u0011IE\u0002\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\u0005\b\u0005\u001b\u0002A\u0011\tB(\u0003U9W\r^\"bG\",7i\u001c8gS\u001e,(/\u0019;j_:,\"A!\u0015\u0011\t\tM#QL\u0007\u0003\u0005+RAAa\u0016\u0003Z\u0005)1-Y2iK*\u0019!1\f\u0004\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\u0011\u0011yF!\u0016\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\u0011\u0019\u0007\u0001C!\u0005K\n\u0001cZ3u\u0007\u0006\u001c\u0007.\u001a*fO&\u001cHO]=\u0016\u0005\t\u001d\u0004\u0003\u0002B5\u0005_j!Aa\u001b\u000b\u0007\t5d!A\u0005gC\u000e$xN]5fg&!!\u0011\u000fB6\u0005E\u0019u.\u001c9p]\u0016tGOU3hSN$(/\u001f\u0005\b\u0005k\u0002A\u0011\u000bB<\u0003I\u0019Wo\u001d;p[\u0012+7m\u001c3f\u0011\u0016\fG-\u001a:\u0015\r\u0005]#\u0011\u0010B>\u0011!\t9Ca\u001dA\u0002\u0005%\u0002\u0002CA#\u0005g\u0002\r!a\u0010\t\u000f\t}\u0004\u0001\"\u0015\u0003\u0002\u0006y1-^:u_6$UmY8eK.+\u0017\u0010\u0006\u0004\u0002X\t\r%Q\u0011\u0005\t\u0003O\u0011i\b1\u0001\u0002*!A\u0011Q\tB?\u0001\u0004\ty\u0004C\u0004\u0003\n\u0002!\tFa#\u0002#\r,8\u000f^8n\t\u0016\u001cw\u000eZ3WC2,X\r\u0006\u0004\u0002X\t5%q\u0012\u0005\t\u0003O\u00119\t1\u0001\u0002*!A\u0011Q\tBD\u0001\u0004\ty\u0004C\u0004\u0003\u0014\u0002!IA!&\u0002\u0011%t7M\u001d#fGJ$B!a\u0016\u0003\u0018\"A\u00111\u0018BI\u0001\u0004\ti\fC\u0004\u0003\u001c\u0002!IA!(\u0002\u0011\u0019dWo\u001d5BY2$\u0002\"a\u0016\u0003 \n\u0005&1\u0015\u0005\t\u0003\u0007\u0013I\n1\u0001\u0002@!A\u00111\u0018BM\u0001\u0004\ti\fC\u0004\u0003&\ne\u0005\u0019A+\u0002\u0019%\u001c(+Z1e!\u0006\u0014\u0018-\\:\t\u000f\t%\u0006\u0001\"\u0003\u0003,\u0006ia/\u00197jI\u0006$X\rR3mi\u0006$BA!,\u00034B!\u0011Q\u0012BX\u0013\u0011\u0011\t,a&\u0003\r\tKw-\u00138u\u0011\u001d\u0011)La*A\u0002I\tQ\u0001Z3mi\u0006DqA!/\u0001\t\u0003\u0012Y,A\u000bde\u0016\fG/Z*vG\u000e,7o\u001d*fgB|gn]3\u0015\t\u0005]#Q\u0018\u0005\b\u0005\u007f\u00139\f1\u0001!\u0003\u0011\u0001(/\u001a<\t\u000f\t\r\u0007\u0001\"\u0011\u0003F\u0006I2M]3bi\u0016tu\u000e^#yK\u000e,H/\u001a3SKN\u0004xN\\:f)\u0011\t9Fa2\t\u000f\t}&\u0011\u0019a\u0001A!9!1\u001a\u0001\u0005B\t5\u0017AF2sK\u0006$XMT8u\u000bbL7\u000f\u001e*fgB|gn]3\u0016\u0005\u0005]\u0003b\u0002Bi\u0001\u0011\u0005#1[\u0001\u0012GJ,\u0017\r^3HKR\u0014Vm\u001d9p]N,GCBA,\u0005+\u00149\u000eC\u0004\u0002,\n=\u0007\u0019\u0001\n\t\u0011\te'q\u001aa\u0001\u00057\fQ!\u001a8uef\u0004bA!8\u0003hJ\u0001SB\u0001Bp\u0015\u0011\u0011\tOa9\u0002\u000f\u0015tGO]5fg*\u0019!Q\u001d\u0004\u0002\u0013\r|g\u000e^1j]\u0016\u0014\u0018\u0002\u0002Bu\u0005?\u0014!bQ1dQ\u0016,e\u000e\u001e:z\u0011\u001d\u0011i\u000f\u0001C!\u0005_\fac\u0019:fCR,W*\u001e7uS\u001e+GOU3ta>t7/\u001a\u000b\u0005\u0003/\u0012\t\u0010\u0003\u0005\u0003t\n-\b\u0019\u0001B{\u0003\u0015\u0001\u0018-\u001b:t!\u0019\u0019\"q\u001f\n\u0003\\&\u0019!\u0011`\u0010\u0003\u00075\u000b\u0007\u000fC\u0004\u0003~\u0002!\tEa@\u0002'\r\u0014X-\u0019;f\u000bJ\u0014xN\u001d*fgB|gn]3\u0015\t\u0005]3\u0011\u0001\u0005\t\u0007\u0007\u0011Y\u00101\u0001\u0004\u0006\u0005\tA\u000f\u0005\u0003\u0002\u000e\u000e\u001d\u0011\u0002BB\u0005\u0003/\u0013\u0011\u0002\u00165s_^\f'\r\\3\t\u000f\r5\u0001\u0001\"\u0015\u0004\u0010\u0005i!-^5mI6+G/\u00193bi\u0006$\"a!\u0005\u0011\t\rM1\u0011D\u0007\u0003\u0007+Q1aa\u0006\u0007\u0003!iW\r^1eCR\f\u0017\u0002BB\u000e\u0007+\u0011\u0001\"T3uC\u0012\fG/\u0019\u0005\b\u0007?\u0001A\u0011BB\u0011\u0003aawnZ!oI\u000e\u0013X-\u0019;f\u000bJ\u0014xN]'fgN\fw-\u001a\u000b\u0007\u0007G\u0019yca\r\u0011\t\r\u001521F\u0007\u0003\u0007OQ1a!\u000b6\u0003\u0011a\u0017M\\4\n\t\r52q\u0005\u0002\u000e'R\u0014\u0018N\\4Ck&dG-\u001a:\t\u0011\rE2Q\u0004a\u0001\u0007G\t!a\u001d2\t\u0011\rU2Q\u0004a\u0001\u0007o\t\u0011!\u001c\t\u0004\t\u000ee\u0012bAB\u001e\u0005\t\u0011R*Z7dC\u000eDW\rZ#yG\u0016\u0004H/[8o\u0011\u001d\u0019y\u0004\u0001C)\u0007\u0003\nQc\u0019:fCR,7+\u001a:wKJ,\u0005pY3qi&|g\u000e\u0006\u0004\u0004D\r\u00153q\n\t\u0007C\u0005u4qG+\t\u0011\r\u001d3Q\ba\u0001\u0007\u0013\n\u0011!\u001a\t\u0005\u0003\u001b\u001bY%\u0003\u0003\u0004N\u0005]%!C#yG\u0016\u0004H/[8o\u0011!\t\u0019i!\u0010A\u0002\u0005}\u0002bBB*\u0001\u0011%1QK\u0001\rG2|7/Z\"iC:tW\r\u001c\u000b\u0005\u0003/\u001a9\u0006\u0003\u0005\u0002<\u000eE\u0003\u0019AA_\u0011\u001d\u0019Y\u0006\u0001C!\u0005\u001b\f1c\u0019:fCR,7\u000b^1ugJ+7\u000f]8og\u0016Dqaa\u0018\u0001\t\u0013\u0019\t'A\u0005ck&dGm\u0015;biRA\u0011qHB2\u0007O\u001a\t\bC\u0004\u0004f\ru\u0003\u0019\u0001\n\u0002\tM$\u0018\r\u001e\u0005\t\u0007S\u001ai\u00061\u0001\u0004l\u0005)a/\u00197vKB\u0019\u0011e!\u001c\n\u0007\r=DDA\u0002B]fD\u0001b!\r\u0004^\u0001\u000711\u0005\u0005\b\u0007k\u0002A\u0011BB<\u0003A\u0011W/\u001b7e\u000f\u0016$(+Z:q_:\u001cX\r\u0006\u0005\u0002@\re4\u0011RBF\u0011!\u0019Yha\u001dA\u0002\ru\u0014AA8q!\u0011\u0019yh!\"\u0011\u0007\u0005\u001a\t)C\u0002\u0004\u0004r\u00111\"\u00128v[\u0016\u0014\u0018\r^5p]&!1qQBA\u0005\u00151\u0016\r\\;f\u0011\u001d\tYka\u001dA\u0002IA\u0001B!7\u0004t\u0001\u0007!1\u001c\u0005\b\u0007\u001f\u0003A\u0011BBI\u0003Y\u0011W/\u001b7e'&tw\r\\3HKR\u0014Vm\u001d9p]N,GCBA \u0007'\u001b)\nC\u0004\u0002,\u000e5\u0005\u0019\u0001\n\t\u0011\te7Q\u0012a\u0001\u00057Dqa!'\u0001\t\u0013\u0019Y*A\nck&dGmR3u\u0011\u0016\fG-\u001a:CK\u001eLg\u000e\u0006\u0005\u0002@\ru5qTBQ\u0011\u001d\tYka&A\u0002IA\u0001B!7\u0004\u0018\u0002\u0007!1\u001c\u0005\t\u0007G\u001b9\n1\u0001\u0003\u000e\u0005QQ\r\u001f;sCN\u0003\u0018mY3\t\u000f\r\u001d\u0006\u0001\"\u0003\u0004*\u0006\u0011rO]5uK\u001e+G\u000fS3bI\u0016\u0014H)\u0019;b)\u0019\tyda+\u00040\"91QVBS\u0001\u0004\u0001\u0013\u0001\u00023bi\u0006D\u0001b!-\u0004&\u0002\u0007\u0011qH\u0001\u0004EV4\u0007bBB[\u0001\u0011%1qW\u0001\u0012oJLG/Z$fi\"+\u0017\rZ3s\u000b:$G\u0003BA \u0007sC\u0001b!-\u00044\u0002\u0007\u0011q\b\u0005\b\u0007{\u0003A\u0011BB`\u0003\u0005\u0012W/\u001b7e'&tw\r\\3HKR<\u0016\u000e\u001e5WKJ\u001c\u0018n\u001c8SKN\u0004xN\\:f)\u0019\tyd!1\u0004D\"9\u00111VB^\u0001\u0004\u0011\u0002\u0002\u0003Bm\u0007w\u0003\rAa7\t\u000f\r\u001d\u0007\u0001\"\u0003\u0004J\u0006\u0019bM]5f]\u0012d\u00170T1y\u0013:$8\t[3dWR1!QBBf\u0007\u001fDqa!4\u0004F\u0002\u0007!#\u0001\u0004ok6\u0014WM\u001d\u0005\b\u0007#\u001c)\r1\u0001\u0013\u0003\u001diWm]:bO\u0016Dqa!6\u0001\t\u0013\u00199.A\tok6,'/[2MS6LGo\u00115fG.$\"B!\u0004\u0004Z\u000em7q\\Bq\u0011\u001d\u0019ima5A\u0002IA\u0001b!8\u0004T\u0002\u0007\u0011Q`\u0001\t[\u0006Dh+\u00197vK\"91\u0011[Bj\u0001\u0004\u0011\u0002\u0002CBr\u0007'\u0004\ra!:\u0002\u00039\u0004B!!$\u0004h&!1\u0011^AL\u0005UqU/\u001c2fe\u001a{'/\\1u\u000bb\u001cW\r\u001d;j_:Dqa!6\u0001\t\u0013\u0019i\u000f\u0006\u0005\u0002~\u000e=8\u0011_Bz\u0011\u001d\u0019ima;A\u0002IA\u0001b!8\u0004l\u0002\u0007\u0011Q \u0005\b\u0007#\u001cY\u000f1\u0001\u0013\u0001")
public class MemcachedDecoder
extends AbstractProtocolDecoder<String, byte[]> {
    private final ScheduledExecutorService scheduler;
    private final NettyTransport transport;
    private boolean isStatsEnabled;
    private final AtomicLong incrMisses;
    private final AtomicLong incrHits;
    private final AtomicLong decrMisses;
    private final AtomicLong decrHits;
    private final AtomicLong replaceIfUnmodifiedMisses;
    private final AtomicLong replaceIfUnmodifiedHits;
    private final AtomicLong replaceIfUnmodifiedBadval;
    private final boolean isTrace;
    private final ByteArrayOutputStream byteBuffer;
    private volatile boolean bitmap$0;

    private boolean isStatsEnabled$lzycompute() {
        MemcachedDecoder memcachedDecoder = this;
        synchronized (memcachedDecoder) {
            if (!this.bitmap$0) {
                this.isStatsEnabled = this.cache().getCacheConfiguration().jmxStatistics().enabled();
                this.bitmap$0 = true;
            }
            return this.isStatsEnabled;
        }
    }

    private boolean isStatsEnabled() {
        return this.bitmap$0 ? this.isStatsEnabled : this.isStatsEnabled$lzycompute();
    }

    private final AtomicLong incrMisses() {
        return this.incrMisses;
    }

    private final AtomicLong incrHits() {
        return this.incrHits;
    }

    private final AtomicLong decrMisses() {
        return this.decrMisses;
    }

    private final AtomicLong decrHits() {
        return this.decrHits;
    }

    private final AtomicLong replaceIfUnmodifiedMisses() {
        return this.replaceIfUnmodifiedMisses;
    }

    private final AtomicLong replaceIfUnmodifiedHits() {
        return this.replaceIfUnmodifiedHits;
    }

    private final AtomicLong replaceIfUnmodifiedBadval() {
        return this.replaceIfUnmodifiedBadval;
    }

    private boolean isTrace() {
        return this.isTrace;
    }

    private ByteArrayOutputStream byteBuffer() {
        return this.byteBuffer;
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        try {
            super.decode(ctx, in, out);
            return;
        }
        finally {
            this.byteBuffer().reset();
        }
    }

    public RequestHeader createHeader() {
        return new RequestHeader();
    }

    public Option<Object> readHeader(ByteBuf buffer, RequestHeader header) {
        Enumeration.Value op;
        boolean endOfOp = TextProtocolUtil$.MODULE$.readElement(buffer, this.byteBuffer());
        String streamOp = TextProtocolUtil$.MODULE$.extractString(this.byteBuffer());
        Enumeration.Value value = op = RequestResolver$.MODULE$.toRequest(streamOp, endOfOp, buffer);
        Enumeration.Value value2 = Operation$.MODULE$.StatsRequest();
        if (!(value != null ? !value.equals(value2) : value2 != null) && !endOfOp) {
            String line = TextProtocolUtil$.MODULE$.readDiscardedLine(buffer).trim();
            if (line.isEmpty()) {
                endOfOp = true;
            } else {
                throw new StreamCorruptedException(new StringBuilder().append((Object)"Stats command does not accept arguments: ").append((Object)line).toString());
            }
        }
        Enumeration.Value value3 = op;
        Enumeration.Value value4 = MemcachedOperation$.MODULE$.VerbosityRequest();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            if (!endOfOp) {
                TextProtocolUtil$.MODULE$.skipLine(buffer);
            }
            throw new StreamCorruptedException("Memcached 'verbosity' command is unsupported");
        }
        header.op_$eq(op);
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    public Tuple2<String, Object> readKey(ByteBuf b) {
        boolean endOfOp = TextProtocolUtil$.MODULE$.readElement(b, this.byteBuffer());
        String k = TextProtocolUtil$.MODULE$.extractString(this.byteBuffer());
        this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, endOfOp, b);
        return new Tuple2((Object)k, (Object)BoxesRunTime.boxToBoolean((boolean)endOfOp));
    }

    private Seq<String> readKeys(ByteBuf b) {
        return TextProtocolUtil$.MODULE$.readSplitLine(b);
    }

    public Object get(ByteBuf buffer) {
        Object object;
        Seq<String> keys = this.readKeys(buffer);
        if (keys.length() > 1) {
            scala.collection.mutable.HashMap map = new scala.collection.mutable.HashMap();
            keys.foreach((Function1)new Serializable(this, buffer, map){
                private final /* synthetic */ MemcachedDecoder $outer;
                private final ByteBuf buffer$1;
                private final scala.collection.mutable.HashMap map$1;

                public final Object apply(String k) {
                    CacheEntry entry = this.$outer.cache().getCacheEntry((Object)this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(k, true, this.buffer$1));
                    return entry == null ? BoxedUnit.UNIT : this.map$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)entry));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.buffer$1 = buffer$1;
                    this.map$1 = map$1;
                }
            });
            object = this.createMultiGetResponse((Map<String, CacheEntry<String, byte[]>>)new HashMap().$plus$plus((GenTraversableOnce)map));
        } else {
            String key = this.org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength((String)keys.apply(0), true, buffer);
            CacheEntry entry = this.cache().getCacheEntry((Object)key);
            object = this.createGetResponse(key, (CacheEntry<String, byte[]>)entry);
        }
        return object;
    }

    public String org$infinispan$server$memcached$MemcachedDecoder$$checkKeyLength(String k, boolean endOfOp, ByteBuf b) {
        if (k.length() > 250) {
            if (!endOfOp) {
                TextProtocolUtil$.MODULE$.skipLine(b);
            }
            throw new StreamCorruptedException("Key length over the 250 character limit");
        }
        return k;
    }

    public boolean readParameters(Channel ch, ByteBuf b) {
        MemcachedParameters memcachedParameters;
        Seq<String> args = TextProtocolUtil$.MODULE$.readSplitLine(b);
        BooleanRef endOfOp = BooleanRef.create((boolean)false);
        if (args.isEmpty()) {
            memcachedParameters = null;
        } else {
            if (this.isTrace()) {
                this.trace((Function0)new Serializable(this){

                    public final String apply() {
                        return "Operation parameters: %s";
                    }
                }, args);
            }
            memcachedParameters = this.liftedTree1$1(b, args, endOfOp);
        }
        this.params_$eq(memcachedParameters);
        return endOfOp.elem;
    }

    private MemcachedParameters readRemoveParameters(Seq<String> args) {
        int delayedDeleteTime = this.parseDelayedDeleteTime(args);
        boolean noReply = delayedDeleteTime == -1 ? this.parseNoReply(0, args) : false;
        return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", 0);
    }

    private MemcachedParameters readIncrDecrParameters(Seq<String> args) {
        String delta = (String)args.apply(0);
        return new MemcachedParameters(-1, -1, -1, -1L, this.parseNoReply(1, args), 0L, delta, 0);
    }

    private MemcachedParameters readFlushAllParameters(Seq<String> args) {
        NumberFormatException numberFormatException2;
        block2: {
            int n;
            boolean noReplyFound = false;
            try {
                n = this.friendlyMaxIntCheck((String)args.apply(0), "Flush delay");
            }
            catch (NumberFormatException numberFormatException2) {
                if (!numberFormatException2.getMessage().contains("noreply")) break block2;
                noReplyFound = true;
                n = 0;
            }
            int flushDelay = n;
            boolean noReply = noReplyFound ? true : this.parseNoReply(1, args);
            return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", flushDelay);
        }
        throw numberFormatException2;
    }

    private MemcachedParameters readStorageParameters(Seq<String> args, ByteBuf b) {
        int length;
        int streamLifespan;
        int index = 0;
        long flags = this.getFlags((String)args.apply(index));
        if (flags < 0L) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Flags cannot be negative: ").append((Object)BoxesRunTime.boxToLong((long)flags)).toString());
        }
        int lifespan = (streamLifespan = this.getLifespan((String)args.apply(++index))) <= 0 ? -1 : streamLifespan;
        if ((length = this.getLength((String)args.apply(++index))) < 0) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Negative bytes length provided: ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString());
        }
        Enumeration.Value value = this.header().op();
        Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
        Enumeration.Value value3 = value;
        long l = !(value2 != null ? !value2.equals(value3) : value3 != null) ? this.getVersion((String)args.apply(++index)) : -1L;
        long streamVersion = l;
        boolean noReply = this.parseNoReply(++index, args);
        return new MemcachedParameters(length, lifespan, -1, streamVersion, noReply, flags, "", 0);
    }

    public void readValue(ByteBuf b) {
        b.readBytes(this.rawValue());
        TextProtocolUtil$.MODULE$.skipLine(b);
    }

    public byte[] createValue() {
        return this.rawValue();
    }

    private long getFlags(String flags) {
        long l;
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        try {
            l = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags");
        }
        catch (NumberFormatException numberFormatException) {
            l = this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags", numberFormatException);
        }
        return l;
    }

    private int getLifespan(String lifespan) {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return this.friendlyMaxIntCheck(lifespan, "Lifespan");
    }

    private int getLength(String length) {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return this.friendlyMaxIntCheck(length, "The number of bytes");
    }

    private long getVersion(String version) {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return new StringOps(Predef$.MODULE$.augmentString(version)).toLong();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseNoReply(int expectedIndex, Seq<String> args) {
        if (args.length() <= expectedIndex) return false;
        if (!"noreply".equals(args.apply(expectedIndex))) throw new StreamCorruptedException("Unable to parse noreply optional argument");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int parseDelayedDeleteTime(Seq<String> args) {
        int n;
        if (args.length() <= 0) return 0;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString((String)args.apply(0))).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        return n;
    }

    public Cache<String, byte[]> getCache() {
        return this.cache();
    }

    public Configuration getCacheConfiguration() {
        return this.cache().getCacheConfiguration();
    }

    public ComponentRegistry getCacheRegistry() {
        return this.cache().getComponentRegistry();
    }

    public Object customDecodeHeader(ChannelHandlerContext ctx, ByteBuf buffer) {
        Enumeration.Value value;
        block5: {
            Object object;
            block3: {
                Channel ch;
                block4: {
                    block2: {
                        ch = ctx.channel();
                        value = this.header().op();
                        Enumeration.Value value2 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                        object = this.flushAll(buffer, ch, false);
                        break block3;
                    }
                    Enumeration.Value value4 = MemcachedOperation$.MODULE$.VersionRequest();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                    java.lang.StringBuilder ret = new java.lang.StringBuilder().append("VERSION ").append(Version.VERSION).append(TextProtocolUtil$.MODULE$.CRLF());
                    object = this.writeResponse(ch, ret);
                    break block3;
                }
                Enumeration.Value value6 = MemcachedOperation$.MODULE$.QuitRequest();
                Enumeration.Value value7 = value;
                if (value6 != null ? !value6.equals(value7) : value7 != null) break block5;
                object = this.closeChannel(ch);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object customDecodeKey(ChannelHandlerContext ctx, ByteBuf buffer) {
        Enumeration.Value value;
        block11: {
            Object object;
            block10: {
                Channel ch;
                block9: {
                    boolean bl;
                    ch = ctx.channel();
                    value = this.header().op();
                    Enumeration.Value value2 = MemcachedOperation$.MODULE$.AppendRequest();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        bl = true;
                    } else {
                        Enumeration.Value value4 = MemcachedOperation$.MODULE$.PrependRequest();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            bl = true;
                        } else {
                            Enumeration.Value value6 = MemcachedOperation$.MODULE$.IncrementRequest();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                bl = true;
                            } else {
                                Enumeration.Value value8 = MemcachedOperation$.MODULE$.DecrementRequest();
                                Enumeration.Value value9 = value;
                                bl = !(value8 != null ? !value8.equals(value9) : value9 != null);
                            }
                        }
                    }
                    if (!bl) break block9;
                    this.key_$eq(this.readKey(buffer)._1());
                    object = this.checkpointTo(DecoderState.DECODE_PARAMETERS);
                    break block10;
                }
                Enumeration.Value value10 = MemcachedOperation$.MODULE$.FlushAllRequest();
                Enumeration.Value value11 = value;
                if (value10 != null ? !value10.equals(value11) : value11 != null) break block11;
                object = this.flushAll(buffer, ch, true);
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object customDecodeValue(ChannelHandlerContext ctx, ByteBuf buffer) {
        boolean bl;
        boolean bl2;
        Enumeration.Value op;
        Channel ch = ctx.channel();
        Enumeration.Value value = op = this.header().op();
        Enumeration.Value value2 = MemcachedOperation$.MODULE$.AppendRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl2 = true;
        } else {
            Enumeration.Value value4 = MemcachedOperation$.MODULE$.PrependRequest();
            Enumeration.Value value5 = value;
            bl2 = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        if (bl2) {
            Object object;
            this.readValue(buffer);
            byte[] prev = (byte[])this.cache().get(this.key());
            if (prev != null) {
                byte[] byArray;
                Enumeration.Value value6 = this.header().op();
                Enumeration.Value value7 = MemcachedOperation$.MODULE$.AppendRequest();
                Enumeration.Value value8 = value6;
                if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                    byArray = TextProtocolUtil$.MODULE$.concat(prev, this.rawValue());
                } else {
                    Enumeration.Value value9 = MemcachedOperation$.MODULE$.PrependRequest();
                    Enumeration.Value value10 = value6;
                    if (value9 == null) {
                        if (value10 != null) {
                            throw new MatchError((Object)value6);
                        }
                    } else if (!value9.equals(value10)) throw new MatchError((Object)value6);
                    byArray = TextProtocolUtil$.MODULE$.concat(this.rawValue(), prev);
                }
                byte[] concatenated = byArray;
                boolean replaced = this.cache().replace(this.key(), (Object)prev, (Object)concatenated, this.buildMetadata());
                object = replaced ? (Object)(((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.STORED()) : (Object)(((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_STORED());
            } else {
                object = ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_STORED();
            }
            byte[] ret = object;
            return this.writeResponse(ch, ret);
        }
        Enumeration.Value value11 = MemcachedOperation$.MODULE$.IncrementRequest();
        Enumeration.Value value12 = value;
        if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
            bl = true;
        } else {
            Enumeration.Value value13 = MemcachedOperation$.MODULE$.DecrementRequest();
            Enumeration.Value value14 = value;
            bl = !(value13 != null ? !value13.equals(value14) : value14 != null);
        }
        if (!bl) throw new MatchError((Object)value);
        return this.incrDecr(ch);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object incrDecr(Channel ch) {
        Object object;
        byte[] prev = (byte[])this.cache().get(this.key());
        Enumeration.Value op = this.header().op();
        if (prev != null) {
            Object object2;
            Object object3;
            BigInt prevCounter = package$.MODULE$.BigInt().apply(new String(prev));
            BigInt delta = this.validateDelta(((MemcachedParameters)this.params()).delta());
            Enumeration.Value value = op;
            Enumeration.Value value2 = MemcachedOperation$.MODULE$.IncrementRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                BigInt candidateCounter = prevCounter.$plus(delta);
                object3 = candidateCounter.$greater(TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG()) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
            } else {
                Enumeration.Value value4 = MemcachedOperation$.MODULE$.DecrementRequest();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) throw new MatchError((Object)value);
                BigInt candidateCounter = prevCounter.$minus(delta);
                object3 = candidateCounter.$less(BigInt$.MODULE$.int2bigInt(0)) ? BoxesRunTime.boxToInteger((int)0) : candidateCounter;
            }
            Object newCounter = object3;
            byte[] next = newCounter.toString().getBytes();
            boolean replaced = this.cache().replace(this.key(), (Object)prev, (Object)next, this.buildMetadata());
            if (!replaced) throw new CacheException(new StringBuilder().append((Object)"Value modified since we retrieved from the cache, old value was ").append((Object)prevCounter).toString());
            if (this.isStatsEnabled()) {
                Enumeration.Value value6 = op;
                Enumeration.Value value7 = MemcachedOperation$.MODULE$.IncrementRequest();
                object2 = BoxesRunTime.boxToLong((long)(!(value6 != null ? !value6.equals(value7) : value7 != null) ? this.incrHits().incrementAndGet() : this.decrHits().incrementAndGet()));
            } else {
                object2 = BoxedUnit.UNIT;
            }
            object = ((MemcachedParameters)this.params()).noReply() ? null : (Object)new StringBuilder().append((Object)new String(next)).append((Object)TextProtocolUtil$.MODULE$.CRLF()).toString();
        } else {
            Object object4;
            if (this.isStatsEnabled()) {
                Enumeration.Value value = op;
                Enumeration.Value value8 = MemcachedOperation$.MODULE$.IncrementRequest();
                object4 = BoxesRunTime.boxToLong((long)(!(value != null ? !value.equals(value8) : value8 != null) ? this.incrMisses().incrementAndGet() : this.decrMisses().incrementAndGet()));
            } else {
                object4 = BoxedUnit.UNIT;
            }
            object = ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_FOUND();
        }
        byte[] ret = object;
        return this.writeResponse(ch, ret);
    }

    private Object flushAll(ByteBuf b, Channel ch, boolean isReadParams) {
        Object object = isReadParams ? BoxesRunTime.boxToBoolean((boolean)this.readParameters(ch, b)) : BoxedUnit.UNIT;
        Serializable flushFunction = new Serializable(this){

            public final void apply(AdvancedCache<String, byte[]> cache) {
                cache.clear();
            }
        };
        int flushDelay = this.params() == null ? 0 : ((MemcachedParameters)this.params()).flushDelay();
        ScheduledFuture<?> scheduledFuture = flushDelay == 0 ? flushFunction.apply((Object)this.cache()) : this.scheduler.schedule(new DelayedFlushAll((AdvancedCache<String, byte[]>)this.cache(), (Function1<AdvancedCache<String, byte[]>, BoxedUnit>)flushFunction), this.toMillis(flushDelay), TimeUnit.MILLISECONDS);
        byte[] ret = (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.OK());
        return this.writeResponse(ch, ret);
    }

    /*
     * WARNING - void declaration
     */
    private BigInt validateDelta(String delta) {
        void var2_2;
        BigInt bigIntDelta = package$.MODULE$.BigInt().apply(delta);
        if (bigIntDelta.$greater(TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta sent (").append((Object)delta).append((Object)") exceeds unsigned limit (").append((Object)TextProtocolUtil$.MODULE$.MAX_UNSIGNED_LONG()).append((Object)")").toString());
        }
        if (bigIntDelta.$less(TextProtocolUtil$.MODULE$.MIN_UNSIGNED())) {
            throw new StreamCorruptedException(new StringBuilder().append((Object)"Increment or decrement delta cannot be negative: ").append((Object)delta).toString());
        }
        return var2_2;
    }

    public Object createSuccessResponse(byte[] prev) {
        byte[] byArray;
        BoxedUnit boxedUnit;
        if (this.isStatsEnabled()) {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            Object object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedHits().incrementAndGet()) : BoxedUnit.UNIT;
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.RemoveRequest();
            Enumeration.Value value5 = value;
            byte[] byArray2 = !(value4 != null ? !value4.equals(value5) : value5 != null) ? TextProtocolUtil$.MODULE$.DELETED() : TextProtocolUtil$.MODULE$.STORED();
            byArray = byArray2;
        }
        return byArray;
    }

    public Object createNotExecutedResponse(byte[] prev) {
        byte[] byArray;
        BoxedUnit boxedUnit;
        if (this.isStatsEnabled()) {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            Object object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedBadval().incrementAndGet()) : BoxedUnit.UNIT;
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (this.params() != null && ((MemcachedParameters)this.params()).noReply()) {
            byArray = null;
        } else {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value4 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value5 = value;
            byte[] byArray2 = !(value4 != null ? !value4.equals(value5) : value5 != null) ? TextProtocolUtil$.MODULE$.EXISTS() : TextProtocolUtil$.MODULE$.NOT_STORED();
            byArray = byArray2;
        }
        return byArray;
    }

    public Object createNotExistResponse() {
        BoxedUnit boxedUnit;
        if (this.isStatsEnabled()) {
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.ReplaceIfUnmodifiedRequest();
            Enumeration.Value value3 = value;
            Object object = !(value2 != null ? !value2.equals(value3) : value3 != null) ? BoxesRunTime.boxToLong((long)this.replaceIfUnmodifiedMisses().incrementAndGet()) : BoxedUnit.UNIT;
            boxedUnit = object;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (byte[])(this.params() != null && ((MemcachedParameters)this.params()).noReply() ? null : TextProtocolUtil$.MODULE$.NOT_FOUND());
    }

    public Object createGetResponse(String k, CacheEntry<String, byte[]> entry) {
        Enumeration.Value value;
        block6: {
            Object object;
            block3: {
                ByteBuf byteBuf;
                block5: {
                    block4: {
                        block2: {
                            if (entry != null) break block2;
                            object = TextProtocolUtil$.MODULE$.END();
                            break block3;
                        }
                        value = this.header().op();
                        Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
                        Enumeration.Value value3 = value;
                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block4;
                        byteBuf = this.buildSingleGetResponse(k, entry);
                        break block5;
                    }
                    Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
                    Enumeration.Value value5 = value;
                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block6;
                    byteBuf = this.buildSingleGetWithVersionResponse(k, entry);
                }
                object = byteBuf;
            }
            return object;
        }
        throw new MatchError((Object)value);
    }

    public Object createMultiGetResponse(Map<String, CacheEntry<String, byte[]>> pairs) {
        boolean bl;
        Enumeration.Value op;
        ListBuffer elements = new ListBuffer();
        Enumeration.Value value = op = this.header().op();
        Enumeration.Value value2 = Operation$.MODULE$.GetRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = Operation$.MODULE$.GetWithVersionRequest();
            Enumeration.Value value5 = value;
            bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        if (bl) {
            pairs.withFilter((Function1)new Serializable(this){

                public final boolean apply(Tuple2<String, CacheEntry<String, byte[]>> check$ifrefutable$1) {
                    Tuple2<String, CacheEntry<String, byte[]>> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, elements, op){
                private final /* synthetic */ MemcachedDecoder $outer;
                private final ListBuffer elements$1;
                private final Enumeration.Value op$1;

                public final ListBuffer<ByteBuf> apply(Tuple2<String, CacheEntry<String, byte[]>> x$1) {
                    Tuple2<String, CacheEntry<String, byte[]>> tuple2 = x$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        CacheEntry entry = (CacheEntry)tuple2._2();
                        ListBuffer listBuffer = this.elements$1.$plus$eq((Object)this.$outer.org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(this.op$1, k, (CacheEntry<String, byte[]>)entry));
                        return listBuffer;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.elements$1 = elements$1;
                    this.op$1 = op$1;
                }
            });
            ListBuffer listBuffer = elements.$plus$eq((Object)ExtendedByteBuf$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{TextProtocolUtil$.MODULE$.END()})));
            return elements.toArray(ClassTag$.MODULE$.apply(ByteBuf.class));
        }
        throw new MatchError((Object)value);
    }

    public Object createErrorResponse(Throwable t) {
        Object object;
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        Throwable throwable = t;
        if (throwable instanceof MemcachedException) {
            Object object2;
            MemcachedException memcachedException = (MemcachedException)throwable;
            Throwable throwable2 = memcachedException.getCause();
            if (throwable2 instanceof UnknownOperationException) {
                UnknownOperationException unknownOperationException = (UnknownOperationException)throwable2;
                this.logExceptionReported((Throwable)unknownOperationException);
                object2 = TextProtocolUtil$.MODULE$.ERROR();
            } else if (throwable2 instanceof ClosedChannelException) {
                ClosedChannelException closedChannelException = (ClosedChannelException)throwable2;
                this.logExceptionReported(closedChannelException);
                object2 = null;
            } else {
                object2 = throwable2 instanceof IOException ? (Object)this.logAndCreateErrorMessage(sb, memcachedException) : (throwable2 instanceof NumberFormatException ? (Object)this.logAndCreateErrorMessage(sb, memcachedException) : (throwable2 instanceof IllegalStateException ? (Object)this.logAndCreateErrorMessage(sb, memcachedException) : (Object)sb.append(memcachedException.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF())));
            }
            object = object2;
        } else if (throwable instanceof ClosedChannelException) {
            ClosedChannelException closedChannelException = (ClosedChannelException)throwable;
            this.logExceptionReported(closedChannelException);
            object = null;
        } else {
            object = sb.append(TextProtocolUtil$.MODULE$.SERVER_ERROR()).append(t.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
        }
        return object;
    }

    public Metadata buildMetadata() {
        MemcachedMetadataBuilder metadata = new MemcachedMetadataBuilder();
        metadata.version(this.generateVersion((Cache)this.cache()));
        metadata.flags(((MemcachedParameters)this.params()).flags());
        Object object = ((MemcachedParameters)this.params()).lifespan() > 0 ? metadata.lifespan(this.toMillis(((MemcachedParameters)this.params()).lifespan())) : BoxedUnit.UNIT;
        return metadata.build();
    }

    private java.lang.StringBuilder logAndCreateErrorMessage(java.lang.StringBuilder sb, MemcachedException m) {
        this.logExceptionReported(m.getCause());
        return sb.append(m.getMessage()).append(TextProtocolUtil$.MODULE$.CRLF());
    }

    public Tuple2<MemcachedException, Object> createServerException(Exception e, ByteBuf b) {
        Tuple2 tuple2;
        Exception exception = e;
        if (exception instanceof IOException) {
            IOException iOException = (IOException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.CLIENT_ERROR_BAD_FORMAT()).append((Object)iOException.getMessage()).toString(), iOException), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (exception instanceof NumberFormatException) {
            NumberFormatException numberFormatException = (NumberFormatException)exception;
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.CLIENT_ERROR_BAD_FORMAT()).append((Object)numberFormatException.getMessage()).toString(), numberFormatException), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple2 = new Tuple2((Object)new MemcachedException(new StringBuilder().append((Object)TextProtocolUtil$.MODULE$.SERVER_ERROR()).append((Object)e).toString(), e), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return tuple2;
    }

    private Object closeChannel(Channel ch) {
        ch.close();
        return null;
    }

    public Object createStatsResponse() {
        Stats stats = this.cache().getAdvancedCache().getStats();
        java.lang.StringBuilder sb = new java.lang.StringBuilder();
        return new ByteBuf[]{this.buildStat("pid", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("uptime", BoxesRunTime.boxToLong((long)stats.getTimeSinceStart()), sb), this.buildStat("time", BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())), sb), this.buildStat("version", this.cache().getVersion(), sb), this.buildStat("pointer_size", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_user", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("rusage_system", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_items", BoxesRunTime.boxToInteger((int)stats.getCurrentNumberOfEntries()), sb), this.buildStat("total_items", BoxesRunTime.boxToLong((long)stats.getTotalNumberOfEntries()), sb), this.buildStat("bytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("curr_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("total_connections", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("connection_structures", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("cmd_get", BoxesRunTime.boxToLong((long)stats.getRetrievals()), sb), this.buildStat("cmd_set", BoxesRunTime.boxToLong((long)stats.getStores()), sb), this.buildStat("get_hits", BoxesRunTime.boxToLong((long)stats.getHits()), sb), this.buildStat("get_misses", BoxesRunTime.boxToLong((long)stats.getMisses()), sb), this.buildStat("delete_misses", BoxesRunTime.boxToLong((long)stats.getRemoveMisses()), sb), this.buildStat("delete_hits", BoxesRunTime.boxToLong((long)stats.getRemoveHits()), sb), this.buildStat("incr_misses", this.incrMisses(), sb), this.buildStat("incr_hits", this.incrHits(), sb), this.buildStat("decr_misses", this.decrMisses(), sb), this.buildStat("decr_hits", this.decrHits(), sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses(), sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits(), sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval(), sb), this.buildStat("auth_cmds", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("auth_errors", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("evictions", BoxesRunTime.boxToLong((long)stats.getEvictions()), sb), this.buildStat("bytes_read", this.transport.getTotalBytesRead(), sb), this.buildStat("bytes_written", this.transport.getTotalBytesWritten(), sb), this.buildStat("limit_maxbytes", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("threads", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("conn_yields", BoxesRunTime.boxToInteger((int)0), sb), this.buildStat("reclaimed", BoxesRunTime.boxToInteger((int)0), sb), ExtendedByteBuf$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{TextProtocolUtil$.MODULE$.END()}))};
    }

    private ByteBuf buildStat(String stat, Object value, java.lang.StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append(TextProtocolUtil$.MODULE$.CRLF());
        ByteBuf buffer = ExtendedByteBuf$.MODULE$.wrappedBuffer((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{sb.toString().getBytes()}));
        sb.setLength(0);
        return buffer;
    }

    public ByteBuf org$infinispan$server$memcached$MemcachedDecoder$$buildGetResponse(Enumeration.Value op, String k, CacheEntry<String, byte[]> entry) {
        ByteBuf buf = this.buildGetHeaderBegin(k, entry, 0);
        return this.writeGetHeaderData((byte[])entry.getValue(), buf);
    }

    private ByteBuf buildSingleGetResponse(String k, CacheEntry<String, byte[]> entry) {
        ByteBuf buf = this.buildGetHeaderBegin(k, entry, TextProtocolUtil$.MODULE$.END_SIZE());
        this.writeGetHeaderData((byte[])entry.getValue(), buf);
        return this.writeGetHeaderEnd(buf);
    }

    private ByteBuf buildGetHeaderBegin(String k, CacheEntry<String, byte[]> entry, int extraSpace) {
        MemcachedMetadata memcachedMetadata;
        byte[] data = (byte[])entry.getValue();
        byte[] dataSize = Integer.valueOf(data.length).toString().getBytes();
        byte[] key = k.getBytes();
        Metadata metadata = entry.getMetadata();
        byte[] byArray = metadata instanceof MemcachedMetadata && (memcachedMetadata = (MemcachedMetadata)metadata).flags() != 0L ? Long.valueOf(memcachedMetadata.flags()).toString().getBytes() : TextProtocolUtil$.MODULE$.ZERO();
        byte[] flags = byArray;
        int flagsSize = flags.length;
        ByteBuf buf = ExtendedByteBuf$.MODULE$.buffer(TextProtocolUtil$.MODULE$.VALUE_SIZE() + key.length + data.length + flagsSize + dataSize.length + 6 + extraSpace);
        buf.writeBytes(TextProtocolUtil$.MODULE$.VALUE());
        buf.writeBytes(key);
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(flags);
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(dataSize);
        return buf;
    }

    private ByteBuf writeGetHeaderData(byte[] data, ByteBuf buf) {
        buf.writeBytes(TextProtocolUtil$.MODULE$.CRLFBytes());
        buf.writeBytes(data);
        buf.writeBytes(TextProtocolUtil$.MODULE$.CRLFBytes());
        return buf;
    }

    private ByteBuf writeGetHeaderEnd(ByteBuf buf) {
        buf.writeBytes(TextProtocolUtil$.MODULE$.END());
        return buf;
    }

    private ByteBuf buildSingleGetWithVersionResponse(String k, CacheEntry<String, byte[]> entry) {
        byte[] v = (byte[])entry.getValue();
        byte[] version = ((Object)BoxesRunTime.boxToLong((long)((NumericVersion)entry.getMetadata().version()).getVersion())).toString().getBytes();
        ByteBuf buf = this.buildGetHeaderBegin(k, entry, version.length + 1 + TextProtocolUtil$.MODULE$.END_SIZE());
        buf.writeByte(TextProtocolUtil$.MODULE$.SP());
        buf.writeBytes(version);
        this.writeGetHeaderData(v, buf);
        return this.writeGetHeaderEnd(buf);
    }

    private int friendlyMaxIntCheck(String number, String message) {
        int n;
        try {
            n = Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            n = this.numericLimitCheck(number, Integer.MAX_VALUE, message, numberFormatException);
        }
        return n;
    }

    private int numericLimitCheck(String number, long maxValue, String message, NumberFormatException n) {
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        throw n;
    }

    private long numericLimitCheck(String number, long maxValue, String message) {
        long numeric = Long.parseLong(number);
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(new StringBuilder().append((Object)message).append((Object)" sent (").append((Object)number).append((Object)") exceeds the limit (").append((Object)BoxesRunTime.boxToLong((long)maxValue)).append((Object)")").toString());
        }
        return numeric;
    }

    private final MemcachedParameters liftedTree1$1(ByteBuf b$1, Seq args$1, BooleanRef endOfOp$1) {
        try {
            MemcachedParameters memcachedParameters;
            Enumeration.Value value = this.header().op();
            Enumeration.Value value2 = Operation$.MODULE$.PutRequest();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                memcachedParameters = this.readStorageParameters((Seq<String>)args$1, b$1);
            } else {
                Enumeration.Value value4 = Operation$.MODULE$.RemoveRequest();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    memcachedParameters = this.readRemoveParameters((Seq<String>)args$1);
                } else {
                    boolean bl;
                    Enumeration.Value value6 = MemcachedOperation$.MODULE$.IncrementRequest();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        bl = true;
                    } else {
                        Enumeration.Value value8 = MemcachedOperation$.MODULE$.DecrementRequest();
                        Enumeration.Value value9 = value;
                        bl = !(value8 != null ? !value8.equals(value9) : value9 != null);
                    }
                    if (bl) {
                        endOfOp$1.elem = true;
                        memcachedParameters = this.readIncrDecrParameters((Seq<String>)args$1);
                    } else {
                        Enumeration.Value value10 = MemcachedOperation$.MODULE$.FlushAllRequest();
                        Enumeration.Value value11 = value;
                        memcachedParameters = !(value10 != null ? !value10.equals(value11) : value11 != null) ? this.readFlushAllParameters((Seq<String>)args$1) : this.readStorageParameters((Seq<String>)args$1, b$1);
                    }
                }
            }
            return memcachedParameters;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException(new StringBuilder().append((Object)"Missing content in command line ").append((Object)args$1).toString());
        }
    }

    public MemcachedDecoder(AdvancedCache<String, byte[]> memcachedCache, ScheduledExecutorService scheduler, NettyTransport transport) {
        this.scheduler = scheduler;
        this.transport = transport;
        super(false, transport);
        this.cache_$eq(memcachedCache.getCacheConfiguration().compatibility().enabled() ? memcachedCache.getAdvancedCache().withFlags(new Flag[]{Flag.OPERATION_MEMCACHED}) : memcachedCache);
        this.incrMisses = new AtomicLong(0L);
        this.incrHits = new AtomicLong(0L);
        this.decrMisses = new AtomicLong(0L);
        this.decrHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedMisses = new AtomicLong(0L);
        this.replaceIfUnmodifiedHits = new AtomicLong(0L);
        this.replaceIfUnmodifiedBadval = new AtomicLong(0L);
        this.isTrace = this.isTraceEnabled();
        this.byteBuffer = new ByteArrayOutputStream();
    }
}

