/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.test.Stoppable$;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedServerConfigurationBuilder;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@Test(groups={"functional"}, testName="server.memcached.MemcachedServerTest")
@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001\u0017\t\u0019R*Z7dC\u000eDW\rZ*feZ,'\u000fV3ti*\u00111\u0001B\u0001\n[\u0016l7-Y2iK\u0012T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u0011\u0015A\u0002\u0001\"\u0001\u001a\u0003\u0001\"Xm\u001d;WC2LG-\u0019;f\t\u00164\u0017-\u001e7u\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003i\u0001\"!D\u000e\n\u0005qq!\u0001B+oSRDQA\b\u0001\u0005\u0002e\tQ\u0004^3tiZ\u000bG.\u001b3bi\u0016LeN^1mS\u0012,\u0005\u0010]5sCRLwN\u001c\u0015\u0005;\u0001B\u0013\u0006\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\t)\u0003\"\u0001\u0004uKN$hnZ\u0005\u0003O\t\u0012A\u0001V3ti\u0006\u0011R\r\u001f9fGR,G-\u0012=dKB$\u0018n\u001c8tY\u0005Q3%A\u0016\u0011\u00051zS\"A\u0017\u000b\u000592\u0011aB2p[6|gn]\u0005\u0003a5\u00121dQ1dQ\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0016C8-\u001a9uS>t\u0007F\u0002\u0001!eM2t'\u0001\u0004he>,\bo\u001d\u0017\u0002i\u0005\nQ'\u0001\u0006gk:\u001cG/[8oC2\f\u0001\u0002^3ti:\u000bW.Z\u0011\u0002q\u0005!3/\u001a:wKJtS.Z7dC\u000eDW\r\u001a\u0018NK6\u001c\u0017m\u00195fIN+'O^3s)\u0016\u001cH\u000f")
public class MemcachedServerTest {
    public void testValidateDefaultConfiguration() {
        Stoppable$.MODULE$.useCacheManager(TestCacheManagerFactory.createCacheManager(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(EmbeddedCacheManager cm) {
                Stoppable$.MODULE$.useServer((AbstractProtocolServer)new MemcachedServer(), (Function1)new Serializable(this, cm){
                    public static final long serialVersionUID = 0L;
                    private final EmbeddedCacheManager cm$1;

                    public final void apply(MemcachedServer server) {
                        server.start((ProtocolServerConfiguration)new MemcachedServerConfigurationBuilder().build(), this.cm$1);
                        Assert.assertEquals((String)server.getHost(), (String)"127.0.0.1");
                        Assert.assertEquals((int)server.getPort(), (int)11211);
                    }
                    {
                        this.cm$1 = cm$1;
                    }
                });
            }
        });
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testValidateInvalidExpiration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.expiration().lifespan(10L);
        Stoppable$.MODULE$.useCacheManager(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(EmbeddedCacheManager cm) {
                Stoppable$.MODULE$.useServer((AbstractProtocolServer)new MemcachedServer(), (Function1)new Serializable(this, cm){
                    public static final long serialVersionUID = 0L;
                    private final EmbeddedCacheManager cm$2;

                    public final void apply(MemcachedServer server) {
                        server.start((ProtocolServerConfiguration)new MemcachedServerConfigurationBuilder().cache("memcachedCache").build(), this.cm$2);
                        Assert.fail((String)"Server should not start when expiration is enabled");
                    }
                    {
                        this.cm$2 = cm$2;
                    }
                });
            }
        });
    }
}

