/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedMultiNodeTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Test(groups={"functional"}, testName="server.memcached.MemcachedReplicationTest")
@ScalaSignature(bytes="\u0006\u0001=4A!\u0001\u0002\u0001\u0017\tAR*Z7dC\u000eDW\r\u001a*fa2L7-\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011!C7f[\u000e\f7\r[3e\u0015\t)a!\u0001\u0004tKJ4XM\u001d\u0006\u0003\u000f!\t!\"\u001b8gS:L7\u000f]1o\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\tia\"D\u0001\u0003\u0013\ty!A\u0001\fNK6\u001c\u0017m\u00195fI6+H\u000e^5O_\u0012,G+Z:u\u0011\u0015\t\u0002\u0001\"\u0001\u0013\u0003\u0019a\u0014N\\5u}Q\t1\u0003\u0005\u0002\u000e\u0001!)Q\u0003\u0001C\t-\u0005\u00112M]3bi\u0016\u001c\u0015m\u00195f\u001b\u0006t\u0017mZ3s)\t9R\u0004\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\r\u00059Q.\u00198bO\u0016\u0014\u0018B\u0001\u000f\u001a\u0005Q)UNY3eI\u0016$7)Y2iK6\u000bg.Y4fe\")a\u0004\u0006a\u0001?\u0005)\u0011N\u001c3fqB\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t\u0019\u0011J\u001c;\t\u000b\u0019\u0002A\u0011A\u0014\u0002#Q,7\u000f\u001e*fa2L7-\u0019;fIN+G\u000f\u0006\u0002)WA\u0011\u0001%K\u0005\u0003U\u0005\u0012A!\u00168ji\")A&\na\u0001[\u0005\tQ\u000e\u0005\u0002/k5\tqF\u0003\u00021c\u00059!/\u001a4mK\u000e$(B\u0001\u001a4\u0003\u0011a\u0017M\\4\u000b\u0003Q\nAA[1wC&\u0011ag\f\u0002\u0007\u001b\u0016$\bn\u001c3\t\u000ba\u0002A\u0011A\u001d\u0002;Q,7\u000f\u001e*fa2L7-\u0019;fI\u001e+G/T;mi&\u0004H.Z&fsN$\"\u0001\u000b\u001e\t\u000b1:\u0004\u0019A\u0017\t\u000bq\u0002A\u0011A\u001f\u0002#Q,7\u000f\u001e*fa2L7-\u0019;fI\u0006#G\r\u0006\u0002)}!)Af\u000fa\u0001[!)\u0001\t\u0001C\u0001\u0003\u0006)B/Z:u%\u0016\u0004H.[2bi\u0016$'+\u001a9mC\u000e,GC\u0001\u0015C\u0011\u0015as\b1\u0001.\u0011\u0015!\u0005\u0001\"\u0001F\u0003Q!Xm\u001d;SKBd\u0017nY1uK\u0012\f\u0005\u000f]3oIR\u0011\u0001F\u0012\u0005\u0006Y\r\u0003\r!\f\u0005\u0006\u0011\u0002!\t!S\u0001\u0016i\u0016\u001cHOU3qY&\u001c\u0017\r^3e!J,\u0007/\u001a8e)\tA#\nC\u0003-\u000f\u0002\u0007Q\u0006C\u0003M\u0001\u0011\u0005Q*\u0001\nuKN$(+\u001a9mS\u000e\fG/\u001a3HKR\u001cHC\u0001\u0015O\u0011\u0015a3\n1\u0001.\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003]!Xm\u001d;SKBd\u0017nY1uK\u0012\u001c\u0015m]#ySN$8\u000f\u0006\u0002)%\")Af\u0014a\u0001[!)A\u000b\u0001C\u0001+\u0006!B/Z:u%\u0016\u0004H.[2bi\u0016$G)\u001a7fi\u0016$\"\u0001\u000b,\t\u000b1\u001a\u0006\u0019A\u0017\t\u000ba\u0003A\u0011A-\u0002/Q,7\u000f\u001e*fa2L7-\u0019;fI&s7M]3nK:$HC\u0001\u0015[\u0011\u0015as\u000b1\u0001.\u0011\u0015a\u0006\u0001\"\u0001^\u0003]!Xm\u001d;SKBd\u0017nY1uK\u0012$Um\u0019:f[\u0016tG\u000f\u0006\u0002)=\")Af\u0017a\u0001[!2\u0001\u0001\u00195jY6\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0003K\"\ta\u0001^3ti:<\u0017BA4c\u0005\u0011!Vm\u001d;\u0002\r\u001d\u0014x.\u001e9tY\u0005Q\u0017%A6\u0002\u0015\u0019,hn\u0019;j_:\fG.\u0001\u0005uKN$h*Y7fC\u0005q\u0017!K:feZ,'OL7f[\u000e\f7\r[3e]5+WnY1dQ\u0016$'+\u001a9mS\u000e\fG/[8o)\u0016\u001cH\u000f")
public class MemcachedReplicationTest
extends MemcachedMultiNodeTest {
    @Override
    public EmbeddedCacheManager createCacheManager(int index) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).dataContainer().valueEquivalence(ByteArrayEquivalence.INSTANCE);
        return TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)builder);
    }

    public void testReplicatedSet(Method m) {
        Future f = ((MemcachedClient)this.clients().head()).set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((MemcachedClient)((IterableLike)this.clients().tail()).head()).get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
    }

    public void testReplicatedGetMultipleKeys(Method m) {
        Future f1 = ((MemcachedClient)this.clients().head()).set(TestingUtil.k((Method)m, (String)"k1-"), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Future f2 = ((MemcachedClient)this.clients().head()).set(TestingUtil.k((Method)m, (String)"k2-"), 0, (Object)TestingUtil.v((Method)m, (String)"v2-"));
        Future f3 = ((MemcachedClient)this.clients().head()).set(TestingUtil.k((Method)m, (String)"k3-"), 0, (Object)TestingUtil.v((Method)m, (String)"v3-"));
        Assert.assertTrue((boolean)((Boolean)f1.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f2.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertTrue((boolean)((Boolean)f3.get(this.timeout(), TimeUnit.SECONDS)));
        List keys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{TestingUtil.k((Method)m, (String)"k1-"), TestingUtil.k((Method)m, (String)"k2-"), TestingUtil.k((Method)m, (String)"k3-")}));
        Map ret = ((MemcachedClient)((IterableLike)this.clients().tail()).head()).getBulk((String[])keys.toArray(ClassTag$.MODULE$.apply(String.class)));
        Assert.assertEquals(ret.get(TestingUtil.k((Method)m, (String)"k1-")), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertEquals(ret.get(TestingUtil.k((Method)m, (String)"k2-")), (Object)TestingUtil.v((Method)m, (String)"v2-"));
        Assert.assertEquals(ret.get(TestingUtil.k((Method)m, (String)"k3-")), (Object)TestingUtil.v((Method)m, (String)"v3-"));
    }

    public void testReplicatedAdd(Method m) {
        Future f = ((MemcachedClient)this.clients().head()).add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((MemcachedClient)((IterableLike)this.clients().tail()).head()).get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
    }

    public void testReplicatedReplace(Method m) {
        Future f = ((MemcachedClient)this.clients().head()).add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((MemcachedClient)((IterableLike)this.clients().tail()).head()).get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
        f = ((MemcachedClient)((IterableLike)this.clients().tail()).head()).replace(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((MemcachedClient)this.clients().head()).get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m, (String)"v1-"));
    }

    public void testReplicatedAppend(Method m) {
        Future f = ((MemcachedClient)this.clients().head()).add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((MemcachedClient)((IterableLike)this.clients().tail()).head()).get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
        f = ((MemcachedClient)((IterableLike)this.clients().tail()).head()).append(0L, TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)TestingUtil.v((Method)m)).append((Object)TestingUtil.v((Method)m, (String)"v1-")).toString();
        Assert.assertEquals((Object)((MemcachedClient)this.clients().head()).get(TestingUtil.k((Method)m)), (Object)expected);
    }

    public void testReplicatedPrepend(Method m) {
        Future f = ((MemcachedClient)this.clients().head()).add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)((MemcachedClient)((IterableLike)this.clients().tail()).head()).get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
        f = ((MemcachedClient)((IterableLike)this.clients().tail()).head()).prepend(0L, TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        String expected = new StringBuilder().append((Object)TestingUtil.v((Method)m, (String)"v1-")).append((Object)TestingUtil.v((Method)m)).toString();
        Assert.assertEquals((Object)((MemcachedClient)this.clients().head()).get(TestingUtil.k((Method)m)), (Object)expected);
    }

    public void testReplicatedGets(Method m) {
        Future f = ((MemcachedClient)this.clients().head()).set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        CASValue value = ((MemcachedClient)((IterableLike)this.clients().tail()).head()).gets(TestingUtil.k((Method)m));
        Assert.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
    }

    public void testReplicatedCasExists(Method m) {
        Future f = ((MemcachedClient)this.clients().head()).set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        CASValue value = ((MemcachedClient)((IterableLike)this.clients().tail()).head()).gets(TestingUtil.k((Method)m));
        Assert.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        long old = value.getCas();
        CASResponse resp = ((MemcachedClient)((IterableLike)this.clients().tail()).head()).cas(TestingUtil.k((Method)m), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        value = ((MemcachedClient)this.clients().head()).gets(TestingUtil.k((Method)m));
        Assert.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((value.getCas() != old ? 1 : 0) != 0);
        resp = ((MemcachedClient)this.clients().head()).cas(TestingUtil.k((Method)m), old, (Object)TestingUtil.v((Method)m, (String)"v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.EXISTS);
        resp = ((MemcachedClient)((IterableLike)this.clients().tail()).head()).cas(TestingUtil.k((Method)m), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v2-"));
        Assert.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testReplicatedDelete(Method m) {
        Future f = ((MemcachedClient)this.clients().head()).set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        f = ((MemcachedClient)((IterableLike)this.clients().tail()).head()).delete(TestingUtil.k((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
    }

    public void testReplicatedIncrement(Method m) {
        Future f = ((MemcachedClient)this.clients().head()).set(TestingUtil.k((Method)m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)((MemcachedClient)((IterableLike)this.clients().tail()).head()).incr(TestingUtil.k((Method)m), 1), (long)2L);
    }

    public void testReplicatedDecrement(Method m) {
        Future f = ((MemcachedClient)this.clients().head()).set(TestingUtil.k((Method)m), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get(this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((long)((MemcachedClient)((IterableLike)this.clients().tail()).head()).decr(TestingUtil.k((Method)m), 1), (long)0L);
    }
}

