/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.test.Stoppable$;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedServerConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@Test(groups={"functional"}, testName="server.memcached.MemcachedServerTest")
@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u0017\t\u0019R*Z7dC\u000eDW\rZ*feZ,'\u000fV3ti*\u00111\u0001B\u0001\n[\u0016l7-Y2iK\u0012T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q!a\u0004\u0004\u0002\tQ,7\u000f^\u0005\u0003#9\u0011a#\u00112tiJ\f7\r^%oM&t\u0017n\u001d9b]R+7\u000f\u001e\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAQ\u0001\u0007\u0001\u0005\u0002e\t\u0001\u0005^3tiZ\u000bG.\u001b3bi\u0016$UMZ1vYR\u001cuN\u001c4jOV\u0014\u0018\r^5p]V\t!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0003V]&$\b\"B\u0011\u0001\t\u0003I\u0012!\b;fgR4\u0016\r\\5eCR,\u0017J\u001c<bY&$W\t\u001f9je\u0006$\u0018n\u001c8)\t\u0001\u001a3\u0006\f\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\n1\"\u00198o_R\fG/[8og*\u0011\u0001\u0006C\u0001\u0007i\u0016\u001cHO\\4\n\u0005)*#\u0001\u0002+fgR\f!#\u001a=qK\u000e$X\rZ#yG\u0016\u0004H/[8og2\nQfI\u0001/!\ty#'D\u00011\u0015\t\td!A\u0004d_6lwN\\:\n\u0005M\u0002$aG\"bG\",7i\u001c8gS\u001e,(/\u0019;j_:,\u0005pY3qi&|g\u000e\u000b\u0004\u0001GU2\u0014HO\u0001\u0007OJ|W\u000f]:-\u0003]\n\u0013\u0001O\u0001\u000bMVt7\r^5p]\u0006d\u0017\u0001\u0003;fgRt\u0015-\\3\"\u0003m\nAe]3sm\u0016\u0014h&\\3nG\u0006\u001c\u0007.\u001a3/\u001b\u0016l7-Y2iK\u0012\u001cVM\u001d<feR+7\u000f\u001e")
public class MemcachedServerTest
extends AbstractInfinispanTest {
    public void testValidateDefaultConfiguration() {
        Stoppable$.MODULE$.useCacheManager(TestCacheManagerFactory.createCacheManager(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(EmbeddedCacheManager cm) {
                Stoppable$.MODULE$.useServer((AbstractProtocolServer)new MemcachedServer(), (Function1)new Serializable(this, cm){
                    public static final long serialVersionUID = 0L;
                    private final EmbeddedCacheManager cm$1;

                    public final void apply(MemcachedServer server) {
                        server.start((ProtocolServerConfiguration)new MemcachedServerConfigurationBuilder().build(), this.cm$1);
                        Assert.assertEquals((String)server.getHost(), (String)"127.0.0.1");
                        Assert.assertEquals((int)server.getPort(), (int)11211);
                    }
                    {
                        this.cm$1 = cm$1;
                    }
                });
            }
        });
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testValidateInvalidExpiration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.expiration().lifespan(10L);
        Stoppable$.MODULE$.useCacheManager(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(EmbeddedCacheManager cm) {
                Stoppable$.MODULE$.useServer((AbstractProtocolServer)new MemcachedServer(), (Function1)new Serializable(this, cm){
                    public static final long serialVersionUID = 0L;
                    private final EmbeddedCacheManager cm$2;

                    public final void apply(MemcachedServer server) {
                        server.start((ProtocolServerConfiguration)new MemcachedServerConfigurationBuilder().cache("memcachedCache").build(), this.cm$2);
                        Assert.fail((String)"Server should not start when expiration is enabled");
                    }
                    {
                        this.cm$2 = cm$2;
                    }
                });
            }
        });
    }
}

