/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.infinispan.Cache;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedMultiNodeTest;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@Test(groups={"functional"}, testName="server.memcached.MemcachedDistributionTest")
@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001\u0017\tIR*Z7dC\u000eDW\r\u001a#jgR\u0014\u0018NY;uS>tG+Z:u\u0015\t\u0019A!A\u0005nK6\u001c\u0017m\u00195fI*\u0011QAB\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005\u001dA\u0011AC5oM&t\u0017n\u001d9b]*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011QBD\u0007\u0002\u0005%\u0011qB\u0001\u0002\u0017\u001b\u0016l7-Y2iK\u0012lU\u000f\u001c;j\u001d>$W\rV3ti\")\u0011\u0003\u0001C\u0001%\u00051A(\u001b8jiz\"\u0012a\u0005\t\u0003\u001b\u0001AQ!\u0006\u0001\u0005\u0012Y\t!c\u0019:fCR,7)Y2iK6\u000bg.Y4feR\u0011q#\b\t\u00031mi\u0011!\u0007\u0006\u00035\u0019\tq!\\1oC\u001e,'/\u0003\u0002\u001d3\t!R)\u001c2fI\u0012,GmQ1dQ\u0016l\u0015M\\1hKJDQA\b\u000bA\u0002}\tQ!\u001b8eKb\u0004\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u00121!\u00138u\u0011\u00151\u0003\u0001\"\u0001(\u0003M!Xm\u001d;HKR4%o\\7O_:|uO\\3s)\u0005A\u0003C\u0001\u0011*\u0013\tQ\u0013E\u0001\u0003V]&$\b\"\u0002\u0017\u0001\t\u0013i\u0013\u0001E4fi\u001aK'o\u001d;O_:|uO\\3s)\tqs\u0007\u0005\u00020k5\t\u0001G\u0003\u0002\u0004c)\u0011!gM\u0001\u0004gBL(\"\u0001\u001b\u0002\u00079,G/\u0003\u00027a\tyQ*Z7dC\u000eDW\rZ\"mS\u0016tG\u000fC\u00039W\u0001\u0007\u0011(A\u0001l!\tQTH\u0004\u0002!w%\u0011A(I\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=C!)\u0011\t\u0001C\u0005\u0005\u0006iq-\u001a;GSJ\u001cHoT<oKJ$\"AL\"\t\u000ba\u0002\u0005\u0019A\u001d\t\u000b\u0015\u0003A\u0011\u0002$\u0002\u0019\u001d,GoQ1dQ\u0016$\u0006.\u0019;\u0015\u00079:\u0005\nC\u00039\t\u0002\u0007\u0011\bC\u0003J\t\u0002\u0007!*A\u0003po:,'\u000f\u0005\u0002!\u0017&\u0011A*\t\u0002\b\u0005>|G.Z1oQ\u0019\u0001aJV,[7B\u0011q\nV\u0007\u0002!*\u0011\u0011KU\u0001\fC:tw\u000e^1uS>t7O\u0003\u0002T\u0011\u00051A/Z:u]\u001eL!!\u0016)\u0003\tQ+7\u000f^\u0001\u0007OJ|W\u000f]:-\u0003a\u000b\u0013!W\u0001\u000bMVt7\r^5p]\u0006d\u0017\u0001\u0003;fgRt\u0015-\\3\"\u0003q\u000b!f]3sm\u0016\u0014h&\\3nG\u0006\u001c\u0007.\u001a3/\u001b\u0016l7-Y2iK\u0012$\u0015n\u001d;sS\n,H/[8o)\u0016\u001cH\u000f")
public class MemcachedDistributionTest
extends MemcachedMultiNodeTest {
    @Override
    public EmbeddedCacheManager createCacheManager(int index) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(1).dataContainer().valueEquivalence(ByteArrayEquivalence.INSTANCE);
        return TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)builder);
    }

    public void testGetFromNonOwner() {
        MemcachedClient owner = this.getFirstOwner("1");
        OperationFuture f = owner.set("1", 0, (Object)"v1");
        Assert.assertTrue((boolean)((Boolean)f.get((long)this.timeout(), TimeUnit.SECONDS)));
        MemcachedClient nonOwner = this.getFirstNonOwner("1");
        Assert.assertEquals((Object)nonOwner.get("1"), (Object)"v1");
    }

    private MemcachedClient getFirstNonOwner(String k) {
        return this.getCacheThat(k, false);
    }

    private MemcachedClient getFirstOwner(String k) {
        return this.getCacheThat(k, true);
    }

    private MemcachedClient getCacheThat(String k, boolean owner) {
        List caches = (List)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MemcachedDistributionTest $outer;

            public final Cache<String, byte[]> apply(MemcachedServer x$1) {
                return x$1.getCacheManager().getCache(this.$outer.cacheName());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        Cache cache = owner ? DistributionTestHelper.getFirstOwner((Object)k, (java.util.List)JavaConversions$.MODULE$.seqAsJavaList((Seq)caches)) : DistributionTestHelper.getFirstNonOwner((Object)k, (java.util.List)JavaConversions$.MODULE$.seqAsJavaList((Seq)caches));
        return (MemcachedClient)this.cacheClient().get((Object)cache).get();
    }
}

