/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.infinispan.Version;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.ConnectionStatsTest$;
import org.infinispan.server.memcached.MemcachedSingleNodeTest;
import org.infinispan.server.memcached.test.MemcachedTestingUtil$;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Test(groups={"functional"}, testName="server.memcached.MemcachedStatsTest")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u0001-\u0011!#T3nG\u0006\u001c\u0007.\u001a3Ti\u0006$8\u000fV3ti*\u00111\u0001B\u0001\n[\u0016l7-Y2iK\u0012T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003/5+WnY1dQ\u0016$7+\u001b8hY\u0016tu\u000eZ3UKN$\b\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\ti\u0001\u0001C\u0004\u0016\u0001\t\u0007I\u0011\u0002\f\u0002\u0013)l\u0007\u0010R8nC&tW#A\f\u0011\u0005aiR\"A\r\u000b\u0005iY\u0012\u0001\u00027b]\u001eT\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f3\t11\u000b\u001e:j]\u001eDa\u0001\t\u0001!\u0002\u00139\u0012A\u00036nq\u0012{W.Y5oA!)!\u0005\u0001C!G\u000512M]3bi\u0016$Vm\u001d;DC\u000eDW-T1oC\u001e,'/F\u0001%!\t)\u0003&D\u0001'\u0015\t9c!A\u0004nC:\fw-\u001a:\n\u0005%2#\u0001F#nE\u0016$G-\u001a3DC\u000eDW-T1oC\u001e,'\u000fC\u0003,\u0001\u0011\u0005A&\u0001\u000buKN$XK\\:vaB|'\u000f^3e'R\fGo\u001d\u000b\u0003[M\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012A!\u00168ji\")AG\u000ba\u0001k\u0005\tQ\u000e\u0005\u00027s5\tqG\u0003\u000293\u00059!/\u001a4mK\u000e$\u0018B\u0001\u001e8\u0005\u0019iU\r\u001e5pI\")A\b\u0001C\u0001{\u0005)B/Z:u+:\u001cw.\u001c9be\u0006\u0014G.Z*uCR\u001cHCA\u0017?\u0011\u0015!4\b1\u00016\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003=!Xm\u001d;Ti\u0006$\u0018nY*uCR\u001cHCA\u0017C\u0011\u0015!t\b1\u00016\u0011\u0015!\u0005\u0001\"\u0001F\u00035!Xm\u001d;U_\u0012|7\u000b^1ugR\tQ\u0006C\u0003H\u0001\u0011\u0005\u0001*A\u0005uKN$8\u000b^1ugR\u0011Q&\u0013\u0005\u0006i\u0019\u0003\r!\u000e\u0005\u0006\u0017\u0002!I\u0001T\u0001\u0016GJ,\u0017\r^3Nk2$\u0018\u000e\u001d7f\u00072LWM\u001c;t)\u0011i%\rZ5\u0011\u000793\u0016L\u0004\u0002P):\u0011\u0001kU\u0007\u0002#*\u0011!KC\u0001\u0007yI|w\u000e\u001e \n\u0003AJ!!V\u0018\u0002\u000fA\f7m[1hK&\u0011q\u000b\u0017\u0002\u0005\u0019&\u001cHO\u0003\u0002V_A\u0011!\fY\u0007\u00027*\u00111\u0001\u0018\u0006\u0003;z\u000b1a\u001d9z\u0015\u0005y\u0016a\u00018fi&\u0011\u0011m\u0017\u0002\u0010\u001b\u0016l7-Y2iK\u0012\u001cE.[3oi\")1M\u0013a\u0001\u001b\u000691\r\\5f]R\u001c\b\"B3K\u0001\u00041\u0017A\u00028v[\n,'\u000f\u0005\u0002/O&\u0011\u0001n\f\u0002\u0004\u0013:$\b\"\u00026K\u0001\u00041\u0017\u0001\u00024s_6D#A\u00137\u0011\u00055\u0004X\"\u00018\u000b\u0005=|\u0013AC1o]>$\u0018\r^5p]&\u0011\u0011O\u001c\u0002\bi\u0006LGN]3d\u0011\u0015\u0019\b\u0001\"\u0001F\u0003\t\"Xm\u001d;Ti\u0006$8o\u00159fG&4\u0017n\u0019+p\u001b\u0016l7-Y2iK\u00124\u0016.\u0019&nq\")Q\u000f\u0001C\u0001\u000b\u0006\tB/Z:u'R\fGo],ji\"\f%oZ:\t\u000b]\u0004A\u0011\u0002=\u0002\u0011\u001d,Go\u0015;biN$R!_A\u0003\u0003\u0013\u0001RA\f>}M\u001aL!a_\u0018\u0003\rQ+\b\u000f\\34!\u0015i\u0018\u0011A\f\u0018\u001b\u0005q(BA@\u001c\u0003\u0011)H/\u001b7\n\u0007\u0005\raPA\u0002NCBDa!a\u0002w\u0001\u00041\u0017\u0001E2veJ,g\u000e\u001e\"zi\u0016\u001c(+Z1e\u0011\u0019\tYA\u001ea\u0001M\u0006\u00192-\u001e:sK:$()\u001f;fg^\u0013\u0018\u000e\u001e;f]\"9\u0011q\u0002\u0001\u0005\n\u0005E\u0011!E1tg\u0016\u0014H\u000fS5hQ\u0016\u0014()\u001f;fgR)a-a\u0005\u0002\u0016!9\u0011qAA\u0007\u0001\u00041\u0007\u0002CA\f\u0003\u001b\u0001\r!!\u0007\u0002\u0011\tLH/Z:TiJ\u0004B!a\u0007\u0002\"9\u0019a&!\b\n\u0007\u0005}q&\u0001\u0004Qe\u0016$WMZ\u0005\u0004=\u0005\r\"bAA\u0010_!Z\u0001!a\n\u00028\u0005e\u0012qHA!!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t1\"\u00198o_R\fG/[8og*\u0019\u0011\u0011\u0007\u0005\u0002\rQ,7\u000f\u001e8h\u0013\u0011\t)$a\u000b\u0003\tQ+7\u000f^\u0001\u0007OJ|W\u000f]:-\u0005\u0005m\u0012EAA\u001f\u0003)1WO\\2uS>t\u0017\r\\\u0001\ti\u0016\u001cHOT1nK\u0006\u0012\u00111I\u0001$g\u0016\u0014h/\u001a:/[\u0016l7-Y2iK\u0012tS*Z7dC\u000eDW\rZ*uCR\u001cH+Z:u\u0001")
public class MemcachedStatsTest
extends MemcachedSingleNodeTest {
    private final String jmxDomain = MemcachedStatsTest.class.getSimpleName();

    private String jmxDomain() {
        return this.jmxDomain;
    }

    @Override
    public EmbeddedCacheManager createTestCacheManager() {
        return TestCacheManagerFactory.createCacheManagerEnforceJmxDomain((String)this.jmxDomain());
    }

    public void testUnsupportedStats(Method m) {
        Tuple3<Map<String, String>, Object, Object> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats._1()).get("pid")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("pointer_size")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("rusage_user")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("rusage_system")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("bytes")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("connection_structures")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("auth_cmds")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("auth_errors")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("limit_maxbytes")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("conn_yields")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("reclaimed")), (String)"0");
    }

    public void testUncomparableStats(Method m) {
        TestingUtil.sleepThread((long)TimeUnit.SECONDS.toMillis(1L));
        Tuple3<Map<String, String>, Object, Object> stats = this.getStats(-1, -1);
        Assert.assertNotSame(((Map)stats._1()).get("uptime"), (Object)"0");
        Assert.assertNotSame(((Map)stats._1()).get("time"), (Object)"0");
        Assert.assertNotSame(((Map)stats._1()).get("uptime"), ((Map)stats._1()).get("time"));
    }

    public void testStaticStats(Method m) {
        Tuple3<Map<String, String>, Object, Object> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats._1()).get("version")), (String)Version.getVersion());
    }

    public void testTodoStats() {
        Tuple3<Map<String, String>, Object, Object> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_connections")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_connections")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("threads")), (String)"0");
    }

    public void testStats(Method m) {
        Tuple3<Map<String, String>, Object, Object> stats = this.getStats(-1, -1);
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cmd_set")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cmd_get")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_items")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_items")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_badval")), (String)"0");
        OperationFuture f = this.client().set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        Assert.assertTrue((boolean)((Boolean)f.get((long)this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
        f = this.client().set(TestingUtil.k((Method)m, (String)"k1-"), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        Assert.assertTrue((boolean)((Boolean)f.get((long)this.timeout(), TimeUnit.SECONDS)));
        Assert.assertEquals((Object)this.client().get(TestingUtil.k((Method)m, (String)"k1-")), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cmd_set")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cmd_get")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_hits")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_misses")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_items")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_items")), (String)"2");
        f = this.client().delete(TestingUtil.k((Method)m, (String)"k1-"));
        Assert.assertTrue((boolean)((Boolean)f.get((long)this.timeout(), TimeUnit.SECONDS)));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_items")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_items")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_misses")), (String)"0");
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m, (String)"k99-")));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_hits")), (String)"2");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("get_misses")), (String)"1");
        f = this.client().delete(TestingUtil.k((Method)m, (String)"k99-"));
        Assert.assertFalse((boolean)((Boolean)f.get((long)this.timeout(), TimeUnit.SECONDS)));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("delete_misses")), (String)"1");
        int future = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() + 1000L);
        f = this.client().set(TestingUtil.k((Method)m, (String)"k3-"), future, (Object)TestingUtil.v((Method)m, (String)"v3-"));
        Assert.assertTrue((boolean)((Boolean)f.get((long)this.timeout(), TimeUnit.SECONDS)));
        TestingUtil.sleepThread((long)1100L);
        Assert.assertNull((Object)this.client().get(TestingUtil.k((Method)m, (String)"k3-")));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("curr_items")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("total_items")), (String)"3");
        this.client().incr(TestingUtil.k((Method)m, (String)"k4-"), 1);
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_hits")), (String)"0");
        f = this.client().set(TestingUtil.k((Method)m, (String)"k4-"), 0, (Object)"1");
        Assert.assertTrue((boolean)((Boolean)f.get((long)this.timeout(), TimeUnit.SECONDS)));
        this.client().incr(TestingUtil.k((Method)m, (String)"k4-"), 1);
        this.client().incr(TestingUtil.k((Method)m, (String)"k4-"), 2);
        this.client().incr(TestingUtil.k((Method)m, (String)"k4-"), 4);
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("incr_hits")), (String)"3");
        this.client().decr(TestingUtil.k((Method)m, (String)"k5-"), 1);
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_hits")), (String)"0");
        f = this.client().set(TestingUtil.k((Method)m, (String)"k5-"), 0, (Object)"8");
        Assert.assertTrue((boolean)((Boolean)f.get((long)this.timeout(), TimeUnit.SECONDS)));
        this.client().decr(TestingUtil.k((Method)m, (String)"k5-"), 1);
        this.client().decr(TestingUtil.k((Method)m, (String)"k5-"), 2);
        this.client().decr(TestingUtil.k((Method)m, (String)"k5-"), 4);
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("decr_hits")), (String)"3");
        this.client().cas(TestingUtil.k((Method)m, (String)"k6-"), 1234L, (Object)TestingUtil.v((Method)m, (String)"v6-"));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_hits")), (String)"0");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_badval")), (String)"0");
        f = this.client().set(TestingUtil.k((Method)m, (String)"k6-"), 0, (Object)TestingUtil.v((Method)m, (String)"v6-"));
        Assert.assertTrue((boolean)((Boolean)f.get((long)this.timeout(), TimeUnit.SECONDS)));
        CASValue value = this.client().gets(TestingUtil.k((Method)m, (String)"k6-"));
        long old = value.getCas();
        this.client().cas(TestingUtil.k((Method)m, (String)"k6-"), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v66-"));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_badval")), (String)"0");
        this.client().cas(TestingUtil.k((Method)m, (String)"k6-"), old, (Object)TestingUtil.v((Method)m, (String)"v66-"));
        stats = this.getStats(BoxesRunTime.unboxToInt((Object)stats._2()), BoxesRunTime.unboxToInt((Object)stats._3()));
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_misses")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_hits")), (String)"1");
        Assert.assertEquals((String)((String)((Map)stats._1()).get("cas_badval")), (String)"1");
    }

    private List<MemcachedClient> createMultipleClients(List<MemcachedClient> clients, int number, int from) {
        while (from < number) {
            MemcachedClient newClient = MemcachedTestingUtil$.MODULE$.createMemcachedClient(60000L, this.server().getPort());
            Object value = newClient.get("a");
            if (value != null && value.hashCode() % 1000 == 0) {
                Predef$.MODULE$.print((Object)BoxesRunTime.boxToInteger((int)value.hashCode()));
            }
            MemcachedClient memcachedClient = newClient;
            ++from;
            clients = clients.$colon$colon((Object)memcachedClient);
        }
        return clients;
    }

    /*
     * WARNING - void declaration
     */
    public void testStatsSpecificToMemcachedViaJmx() {
        this.getStats(-1, -1);
        ConnectionStatsTest$.MODULE$.testSingleLocalConnection(this.jmxDomain(), "Memcached");
        List<MemcachedClient> clients = Nil$.MODULE$;
        try {
            clients = this.createMultipleClients(clients, 10, 0);
            ConnectionStatsTest$.MODULE$.testMultipleLocalConnections(this.jmxDomain(), "Memcached", clients.size() + 1);
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Object apply(MemcachedClient client) {
                    Object object;
                    try {
                        object = BoxesRunTime.boxToBoolean((boolean)client.shutdown(20L, TimeUnit.SECONDS));
                    }
                    catch (Throwable throwable) {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                }
            });
            throw throwable;
        }
        clients.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public void testStatsWithArgs() {
        String resp = this.send("stats\r\n");
        this.assertExpectedResponse(resp, "STAT", false);
        resp = this.send("stats \r\n");
        this.assertExpectedResponse(resp, "STAT", false);
        resp = this.send("stats boo\r\n");
        this.assertClientError(resp);
        resp = this.send("stats boo boo2 boo3\r\n");
        this.assertClientError(resp);
    }

    private Tuple3<Map<String, String>, Object, Object> getStats(int currentBytesRead, int currentBytesWritten) {
        Map globalStats = this.client().getStats();
        Assert.assertEquals((int)globalStats.size(), (int)1);
        Map stats = (Map)globalStats.values().iterator().next();
        int bytesRead = this.assertHigherBytes(currentBytesRead, (String)stats.get("bytes_read"));
        int bytesWritten = this.assertHigherBytes(currentBytesRead, (String)stats.get("bytes_written"));
        return new Tuple3((Object)stats, (Object)BoxesRunTime.boxToInteger((int)bytesRead), (Object)BoxesRunTime.boxToInteger((int)bytesWritten));
    }

    /*
     * WARNING - void declaration
     */
    private int assertHigherBytes(int currentBytesRead, String bytesStr) {
        void var3_3;
        int bytesRead = new StringOps(Predef$.MODULE$.augmentString(bytesStr)).toInt();
        Assert.assertTrue((bytesRead > currentBytesRead ? 1 : 0) != 0);
        return (int)var3_3;
    }
}

