/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.util.Properties;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.ConnectionStatsTest;
import org.infinispan.server.memcached.MemcachedMultiNodeTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"unstable"}, testName="server.memcached.MemcachedClusteredStatsTest", description="original group: functional - randomly fails with: expected [2] but found [1])")
public class MemcachedClusteredStatsTest
extends MemcachedMultiNodeTest {
    private String jmxDomain = MemcachedClusteredStatsTest.class.getSimpleName();
    private MBeanServerLookup mbeanServerLookup = new ProvidedMBeanServerLookup(MBeanServerFactory.createMBeanServer());

    @Override
    public EmbeddedCacheManager createCacheManager(int index) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC);
        return TestCacheManagerFactory.createClusteredCacheManagerEnforceJmxDomain(null, (String)(this.jmxDomain + "-" + index), (boolean)true, (boolean)false, (ConfigurationBuilder)builder, (MBeanServerLookup)this.mbeanServerLookup);
    }

    public void testSingleConnectionPerServer() throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException {
        ConnectionStatsTest.testGlobalConnections(this.jmxDomain + "-0", "Memcached", 2, this.mbeanServerLookup.getMBeanServer(null));
    }

    class ProvidedMBeanServerLookup
    implements MBeanServerLookup {
        private final MBeanServer mbeanServer;

        ProvidedMBeanServerLookup(MBeanServer mbeanServer) {
            this.mbeanServer = mbeanServer;
        }

        public MBeanServer getMBeanServer(Properties properties) {
            return this.mbeanServer;
        }
    }
}

