/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import io.netty.util.CharsetUtil;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.NumericVersionGenerator;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.server.core.transport.ExtendedByteBuf;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.memcached.CacheUnavailableException;
import org.infinispan.server.memcached.MemcachedDecoderState;
import org.infinispan.server.memcached.MemcachedException;
import org.infinispan.server.memcached.MemcachedMetadata;
import org.infinispan.server.memcached.MemcachedMetadataBuilder;
import org.infinispan.server.memcached.MemcachedOperation;
import org.infinispan.server.memcached.MemcachedParameters;
import org.infinispan.server.memcached.PartialResponse;
import org.infinispan.server.memcached.RequestHeader;
import org.infinispan.server.memcached.TextProtocolUtil;
import org.infinispan.server.memcached.UnknownOperationException;
import org.infinispan.server.memcached.logging.JavaLog;
import org.infinispan.stats.Stats;
import org.infinispan.util.KeyValuePair;

public class MemcachedDecoder
extends ReplayingDecoder<MemcachedDecoderState> {
    private final AdvancedCache<String, byte[]> cache;
    private final ScheduledExecutorService scheduler;
    protected final NettyTransport transport;
    protected final Predicate<? super String> ignoreCache;
    private static final JavaLog log = (JavaLog)LogFactory.getLog(MemcachedDecoder.class, JavaLog.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private static final int SecondsInAMonth = 2592000;
    private static final TimeUnit DefaultTimeUnit = TimeUnit.MILLISECONDS;
    long defaultLifespanTime;
    long defaultMaxIdleTime;
    protected String key;
    protected byte[] rawValue;
    protected Configuration cacheConfiguration;
    protected MemcachedParameters params;
    private final boolean isStatsEnabled;
    private final AtomicLong incrMisses = new AtomicLong();
    private final AtomicLong incrHits = new AtomicLong();
    private final AtomicLong decrMisses = new AtomicLong();
    private final AtomicLong decrHits = new AtomicLong();
    private final AtomicLong replaceIfUnmodifiedMisses = new AtomicLong();
    private final AtomicLong replaceIfUnmodifiedHits = new AtomicLong();
    private final AtomicLong replaceIfUnmodifiedBadval = new AtomicLong();
    private ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    protected RequestHeader header;

    public MemcachedDecoder(AdvancedCache<String, byte[]> memcachedCache, ScheduledExecutorService scheduler, NettyTransport transport, Predicate<? super String> ignoreCache) {
        super((Object)MemcachedDecoderState.DECODE_HEADER);
        this.cache = memcachedCache.getCacheConfiguration().compatibility().enabled() ? memcachedCache.withFlags(new Flag[]{Flag.OPERATION_MEMCACHED}) : memcachedCache;
        this.scheduler = scheduler;
        this.transport = transport;
        this.ignoreCache = ignoreCache;
        this.isStatsEnabled = this.cache.getCacheConfiguration().jmxStatistics().enabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            this.decodeDispatch(ctx, in, out);
        }
        finally {
            this.byteBuffer.reset();
        }
    }

    protected Object replace() {
        Object prev = this.cache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).get((Object)this.key);
        if (prev != null) {
            prev = this.cache.replace((Object)this.key, (Object)this.createValue(), this.buildMetadata());
        }
        if (prev != null) {
            return this.createSuccessResponse();
        }
        return this.createNotExecutedResponse();
    }

    protected Object replaceIfUnmodified() {
        CacheEntry entry = this.cache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).getCacheEntry((Object)this.key);
        if (entry != null) {
            byte[] prev = (byte[])entry.getValue();
            NumericVersion streamVersion = new NumericVersion(this.params.streamVersion);
            if (entry.getMetadata().version().equals(streamVersion)) {
                byte[] v = this.createValue();
                boolean replaced = this.cache.replace((Object)this.key, (Object)prev, (Object)v, this.buildMetadata());
                if (replaced) {
                    return this.createSuccessResponse();
                }
                return this.createNotExecutedResponse();
            }
            return this.createNotExecutedResponse();
        }
        return this.createNotExistResponse();
    }

    private void decodeDispatch(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws MemcachedException {
        try {
            if (isTrace) {
                log.tracef("Decode using instance @%x", System.identityHashCode((Object)this));
            }
            MemcachedDecoderState state = (MemcachedDecoderState)((Object)this.state());
            switch (state) {
                case DECODE_HEADER: {
                    this.decodeHeader(ctx, in, state, out);
                    break;
                }
                case DECODE_KEY: {
                    this.decodeKey(ctx, in);
                    break;
                }
                case DECODE_PARAMETERS: {
                    this.decodeParameters(ctx, in, state);
                    break;
                }
                case DECODE_VALUE: {
                    this.decodeValue(ctx, in, state);
                }
            }
        }
        catch (IOException | NumberFormatException e) {
            ctx.pipeline().fireExceptionCaught((Throwable)new MemcachedException("CLIENT_ERROR bad command line format: " + e.getMessage(), e));
        }
        catch (Exception e) {
            throw new MemcachedException("SERVER_ERROR " + e, e);
        }
    }

    void decodeHeader(ChannelHandlerContext ctx, ByteBuf buffer, MemcachedDecoderState state, List<Object> out) throws CacheUnavailableException, IOException {
        this.header = new RequestHeader();
        Optional<Boolean> endOfOp = this.readHeader(buffer, this.header);
        if (!endOfOp.isPresent()) {
            return;
        }
        Channel ch = ctx.channel();
        String cacheName = this.cache.getName();
        if (this.ignoreCache.test(cacheName)) {
            throw new CacheUnavailableException(cacheName);
        }
        this.cacheConfiguration = this.getCacheConfiguration();
        this.defaultLifespanTime = this.cacheConfiguration.expiration().lifespan();
        this.defaultMaxIdleTime = this.cacheConfiguration.expiration().maxIdle();
        if (endOfOp.get().booleanValue()) {
            Object message;
            switch (this.header.operation) {
                case StatsRequest: {
                    message = this.writeResponse(ch, this.createStatsResponse());
                    break;
                }
                default: {
                    this.customDecodeHeader(ctx, buffer);
                    message = null;
                }
            }
            if (message instanceof PartialResponse) {
                out.add(((PartialResponse)message).buffer);
            }
        } else {
            this.checkpoint((Object)MemcachedDecoderState.DECODE_KEY);
        }
    }

    void decodeKey(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        Channel ch = ctx.channel();
        switch (this.header.operation) {
            case GetRequest: 
            case GetWithVersionRequest: {
                this.writeResponse(ch, this.get(buffer));
                break;
            }
            case PutRequest: 
            case RemoveRequest: 
            case PutIfAbsentRequest: 
            case ReplaceRequest: 
            case ReplaceIfUnmodifiedRequest: {
                this.handleModification(ch, buffer);
                break;
            }
            default: {
                this.customDecodeKey(ctx, buffer);
            }
        }
    }

    private void decodeParameters(ChannelHandlerContext ctx, ByteBuf buffer, MemcachedDecoderState state) throws IOException {
        Channel ch = ctx.channel();
        boolean endOfOp = this.readParameters(ch, buffer);
        if (!endOfOp && this.params.valueLength > 0) {
            this.rawValue = new byte[this.params.valueLength];
            this.checkpoint((Object)MemcachedDecoderState.DECODE_VALUE);
        } else if (this.params.valueLength == 0) {
            this.rawValue = new byte[0];
            this.decodeValue(ctx, buffer, state);
        } else {
            this.decodeValue(ctx, buffer, state);
        }
    }

    private void decodeValue(ChannelHandlerContext ctx, ByteBuf buffer, MemcachedDecoderState state) throws StreamCorruptedException {
        Object ret;
        Channel ch = ctx.channel();
        switch (this.header.operation) {
            case PutRequest: {
                this.readValue(buffer);
                ret = this.put();
                break;
            }
            case PutIfAbsentRequest: {
                this.readValue(buffer);
                ret = this.putIfAbsent();
                break;
            }
            case ReplaceRequest: {
                this.readValue(buffer);
                ret = this.replace();
                break;
            }
            case ReplaceIfUnmodifiedRequest: {
                this.readValue(buffer);
                ret = this.replaceIfUnmodified();
                break;
            }
            case RemoveRequest: {
                ret = this.remove();
                break;
            }
            default: {
                this.customDecodeValue(ctx, buffer);
                ret = null;
            }
        }
        this.writeResponse(ch, ret);
    }

    private Object putIfAbsent() {
        Object prev = this.cache.get((Object)this.key);
        if (prev == null) {
            prev = this.cache.putIfAbsent((Object)this.key, (Object)this.createValue(), this.buildMetadata());
        }
        if (prev == null) {
            return this.createSuccessResponse();
        }
        return this.createNotExecutedResponse();
    }

    private Object put() {
        Object prev = this.cache.put((Object)this.key, (Object)this.createValue(), this.buildMetadata());
        return this.createSuccessResponse();
    }

    private Optional<Boolean> readHeader(ByteBuf buffer, RequestHeader header) throws IOException {
        boolean endOfOp = TextProtocolUtil.readElement(buffer, this.byteBuffer);
        String streamOp = TextProtocolUtil.extractString(this.byteBuffer);
        MemcachedOperation op = this.toRequest(streamOp, endOfOp, buffer);
        if (op == MemcachedOperation.StatsRequest && !endOfOp) {
            String line = TextProtocolUtil.readDiscardedLine(buffer).trim();
            if (!line.isEmpty()) {
                throw new StreamCorruptedException("Stats command does not accept arguments: " + line);
            }
            endOfOp = true;
        }
        if (op == MemcachedOperation.VerbosityRequest) {
            if (!endOfOp) {
                TextProtocolUtil.skipLine(buffer);
            }
            throw new StreamCorruptedException("Memcached 'verbosity' command is unsupported");
        }
        header.operation = op;
        return Optional.of(endOfOp);
    }

    KeyValuePair<String, Boolean> readKey(ByteBuf b) throws IOException {
        boolean endOfOp = TextProtocolUtil.readElement(b, this.byteBuffer);
        String k = TextProtocolUtil.extractString(this.byteBuffer);
        this.checkKeyLength(k, endOfOp, b);
        return new KeyValuePair((Object)k, (Object)endOfOp);
    }

    private List<String> readKeys(ByteBuf b) {
        return TextProtocolUtil.readSplitLine(b);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Object errorResponse;
        Channel ch = ctx.channel();
        log.debug("Exception caught", cause);
        if (!(cause instanceof IOException) && (errorResponse = this.createErrorResponse(cause)) != null) {
            if (errorResponse instanceof byte[]) {
                ch.writeAndFlush((Object)ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{(byte[])errorResponse}), ch.voidPromise());
            } else if (errorResponse instanceof CharSequence) {
                ch.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)((CharSequence)errorResponse), (Charset)CharsetUtil.UTF_8), ch.voidPromise());
            } else {
                ch.writeAndFlush(errorResponse, ch.voidPromise());
            }
        }
        this.resetParams();
    }

    protected Object get(ByteBuf buffer) throws StreamCorruptedException {
        List<String> keys = this.readKeys(buffer);
        if (keys.size() > 1) {
            HashMap<String, CacheEntry<String, byte[]>> map = new HashMap<String, CacheEntry<String, byte[]>>();
            for (String key : keys) {
                CacheEntry entry = this.cache.getCacheEntry((Object)this.checkKeyLength(key, true, buffer));
                if (entry == null) continue;
                map.put(key, (CacheEntry<String, byte[]>)entry);
            }
            return this.createMultiGetResponse(map);
        }
        String key = this.checkKeyLength(keys.get(0), true, buffer);
        CacheEntry entry = this.cache.getCacheEntry((Object)key);
        return this.createGetResponse(key, (CacheEntry<String, byte[]>)entry);
    }

    private String checkKeyLength(String k, boolean endOfOp, ByteBuf b) throws StreamCorruptedException {
        if (k.length() > 250) {
            if (!endOfOp) {
                TextProtocolUtil.skipLine(b);
            }
            throw new StreamCorruptedException("Key length over the 250 character limit");
        }
        return k;
    }

    private boolean readParameters(Channel ch, ByteBuf b) throws IOException {
        List<String> args = TextProtocolUtil.readSplitLine(b);
        boolean endOfOp = false;
        if (args.size() != 0) {
            if (isTrace) {
                log.tracef("Operation parameters: %s", args);
            }
            try {
                switch (this.header.operation) {
                    case PutRequest: {
                        this.params = this.readStorageParameters(args, b);
                        break;
                    }
                    case RemoveRequest: {
                        this.params = this.readRemoveParameters(args);
                        break;
                    }
                    case IncrementRequest: 
                    case DecrementRequest: {
                        endOfOp = true;
                        this.params = this.readIncrDecrParameters(args);
                        break;
                    }
                    case FlushAllRequest: {
                        this.params = this.readFlushAllParameters(args);
                        break;
                    }
                    default: {
                        this.params = this.readStorageParameters(args, b);
                        break;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Missing content in command line " + args);
            }
        }
        return endOfOp;
    }

    private MemcachedParameters readRemoveParameters(List<String> args) throws StreamCorruptedException {
        int delayedDeleteTime = this.parseDelayedDeleteTime(args);
        boolean noReply = delayedDeleteTime == -1 && this.parseNoReply(0, args);
        return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", 0);
    }

    private MemcachedParameters readIncrDecrParameters(List<String> args) throws StreamCorruptedException {
        String delta = args.get(0);
        return new MemcachedParameters(-1, -1, -1, -1L, this.parseNoReply(1, args), 0L, delta, 0);
    }

    private MemcachedParameters readFlushAllParameters(List<String> args) throws StreamCorruptedException {
        int flushDelay;
        boolean noReplyFound = false;
        try {
            flushDelay = this.friendlyMaxIntCheck(args.get(0), "Flush delay");
        }
        catch (NumberFormatException n) {
            if (n.getMessage().contains("noreply")) {
                noReplyFound = true;
                flushDelay = 0;
            }
            throw n;
        }
        boolean noReply = noReplyFound || this.parseNoReply(1, args);
        return new MemcachedParameters(-1, -1, -1, -1L, noReply, 0L, "", flushDelay);
    }

    private MemcachedParameters readStorageParameters(List<String> args, ByteBuf b) throws StreamCorruptedException, EOFException {
        int length;
        int streamLifespan;
        int index = 0;
        long flags = this.getFlags(args.get(index));
        if (flags < 0L) {
            throw new StreamCorruptedException("Flags cannot be negative: " + flags);
        }
        int lifespan = (streamLifespan = this.getLifespan(args.get(++index))) <= 0 ? -1 : this.getLifespan(args.get(index));
        if ((length = this.getLength(args.get(++index))) < 0) {
            throw new StreamCorruptedException("Negative bytes length provided: " + length);
        }
        long streamVersion = this.header.operation == MemcachedOperation.ReplaceIfUnmodifiedRequest ? this.getVersion(args.get(++index)) : 1L;
        boolean noReply = this.parseNoReply(++index, args);
        return new MemcachedParameters(length, lifespan, -1, streamVersion, noReply, flags, "", 0);
    }

    private EntryVersion generateVersion(Cache<String, byte[]> cache) {
        ComponentRegistry registry = this.getCacheRegistry();
        VersionGenerator cacheVersionGenerator = (VersionGenerator)registry.getComponent(VersionGenerator.class);
        if (cacheVersionGenerator == null) {
            NumericVersionGenerator newVersionGenerator = new NumericVersionGenerator().clustered(registry.getComponent(RpcManager.class) != null);
            registry.registerComponent((Object)newVersionGenerator, VersionGenerator.class);
            return newVersionGenerator.generateNew();
        }
        return cacheVersionGenerator.generateNew();
    }

    private void readValue(ByteBuf b) {
        b.readBytes(this.rawValue);
        TextProtocolUtil.skipLine(b);
    }

    private byte[] createValue() {
        return this.rawValue;
    }

    private long getFlags(String flags) throws EOFException {
        if (flags == null) {
            throw new EOFException("No flags passed");
        }
        try {
            return this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags");
        }
        catch (NumberFormatException n) {
            return this.numericLimitCheck(flags, 0xFFFFFFFFL, "Flags", n);
        }
    }

    private int getLifespan(String lifespan) throws EOFException {
        if (lifespan == null) {
            throw new EOFException("No expiry passed");
        }
        return this.friendlyMaxIntCheck(lifespan, "Lifespan");
    }

    private int getLength(String length) throws EOFException {
        if (length == null) {
            throw new EOFException("No bytes passed");
        }
        return this.friendlyMaxIntCheck(length, "The number of bytes");
    }

    private long getVersion(String version) throws EOFException {
        if (version == null) {
            throw new EOFException("No cas passed");
        }
        return Long.parseLong(version);
    }

    private boolean parseNoReply(int expectedIndex, List<String> args) throws StreamCorruptedException {
        if (args.size() > expectedIndex) {
            if ("noreply".equals(args.get(expectedIndex))) {
                return true;
            }
            throw new StreamCorruptedException("Unable to parse noreply optional argument");
        }
        return false;
    }

    private int parseDelayedDeleteTime(List<String> args) {
        if (args.size() > 0) {
            try {
                return Integer.parseInt(args.get(0));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return 0;
    }

    private Configuration getCacheConfiguration() {
        return this.cache.getCacheConfiguration();
    }

    private ComponentRegistry getCacheRegistry() {
        return this.cache.getComponentRegistry();
    }

    private void customDecodeHeader(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        Channel ch = ctx.channel();
        switch (this.header.operation) {
            case FlushAllRequest: {
                this.flushAll(buffer, ch, false);
                break;
            }
            case VersionRequest: {
                StringBuilder ret = new StringBuilder().append("VERSION ").append(Version.getVersion()).append("\r\n");
                this.writeResponse(ch, ret);
                break;
            }
            case QuitRequest: {
                ch.close();
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation " + (Object)((Object)this.header.operation) + " not supported!");
            }
        }
    }

    protected void customDecodeKey(ChannelHandlerContext ctx, ByteBuf buffer) throws IOException {
        Channel ch = ctx.channel();
        switch (this.header.operation) {
            case IncrementRequest: 
            case DecrementRequest: 
            case AppendRequest: 
            case PrependRequest: {
                this.key = (String)this.readKey(buffer).getKey();
                this.checkpoint((Object)MemcachedDecoderState.DECODE_PARAMETERS);
                break;
            }
            case FlushAllRequest: {
                this.flushAll(buffer, ch, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation " + (Object)((Object)this.header.operation) + " not supported!");
            }
        }
    }

    protected void customDecodeValue(ChannelHandlerContext ctx, ByteBuf buffer) throws StreamCorruptedException {
        Channel ch = ctx.channel();
        switch (this.header.operation) {
            case AppendRequest: 
            case PrependRequest: {
                Object ret;
                this.readValue(buffer);
                byte[] prev = (byte[])this.cache.get((Object)this.key);
                if (prev != null) {
                    byte[] concatenated;
                    switch (this.header.operation) {
                        case AppendRequest: {
                            concatenated = TextProtocolUtil.concat(prev, this.rawValue);
                            break;
                        }
                        case PrependRequest: {
                            concatenated = TextProtocolUtil.concat(this.rawValue, prev);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Operation " + (Object)((Object)this.header.operation) + " not supported!");
                        }
                    }
                    ret = this.cache.replace((Object)this.key, (Object)prev, (Object)concatenated, this.buildMetadata()) ? (Object)(!this.params.noReply ? TextProtocolUtil.STORED : null) : (byte[])(!this.params.noReply ? TextProtocolUtil.NOT_STORED : null);
                } else {
                    ret = (byte[])(!this.params.noReply ? TextProtocolUtil.NOT_STORED : null);
                }
                this.writeResponse(ch, ret);
                break;
            }
            case IncrementRequest: 
            case DecrementRequest: {
                this.incrDecr(ch);
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation " + (Object)((Object)this.header.operation) + " not supported!");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void incrDecr(Channel ch) throws StreamCorruptedException {
        byte[] ret;
        byte[] prev = (byte[])this.cache.get((Object)this.key);
        MemcachedOperation op = this.header.operation;
        if (prev != null) {
            BigInteger candidateCounter;
            BigInteger prevCounter = new BigInteger(new String(prev));
            BigInteger delta = this.validateDelta(this.params.delta);
            switch (op) {
                case IncrementRequest: {
                    candidateCounter = prevCounter.add(delta);
                    candidateCounter = candidateCounter.compareTo(TextProtocolUtil.MAX_UNSIGNED_LONG) > 0 ? TextProtocolUtil.MIN_UNSIGNED : candidateCounter;
                    break;
                }
                case DecrementRequest: {
                    candidateCounter = prevCounter.subtract(delta);
                    candidateCounter = candidateCounter.compareTo(TextProtocolUtil.MIN_UNSIGNED) < 0 ? TextProtocolUtil.MIN_UNSIGNED : candidateCounter;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Operation " + (Object)((Object)op) + " not supported!");
                }
            }
            String counterString = candidateCounter.toString();
            if (!this.cache.replace((Object)this.key, (Object)prev, (Object)counterString.getBytes(), this.buildMetadata())) throw new CacheException("Value modified since we retrieved from the cache, old value was " + prevCounter);
            if (this.isStatsEnabled) {
                if (op == MemcachedOperation.IncrementRequest) {
                    this.incrHits.incrementAndGet();
                } else {
                    this.decrHits.incrementAndGet();
                }
            }
            ret = !this.params.noReply ? counterString + "\r\n" : null;
        } else {
            if (this.isStatsEnabled) {
                if (op == MemcachedOperation.IncrementRequest) {
                    this.incrMisses.incrementAndGet();
                } else {
                    this.decrMisses.incrementAndGet();
                }
            }
            ret = (byte[])(!this.params.noReply ? TextProtocolUtil.NOT_FOUND : null);
        }
        this.writeResponse(ch, ret);
    }

    private void flushAll(ByteBuf b, Channel ch, boolean isReadParams) throws IOException {
        int flushDelay;
        if (isReadParams) {
            this.readParameters(ch, b);
        }
        Consumer<Cache> consumer = c -> c.clear();
        int n = flushDelay = this.params == null ? 0 : this.params.flushDelay;
        if (flushDelay == 0) {
            consumer.accept((Cache)this.cache);
        } else {
            this.scheduler.schedule(() -> consumer.accept((Cache)this.cache), this.toMillis(flushDelay), TimeUnit.MILLISECONDS);
        }
        byte[] ret = (byte[])(this.params == null || !this.params.noReply ? TextProtocolUtil.OK : null);
        this.writeResponse(ch, ret);
    }

    private BigInteger validateDelta(String delta) throws StreamCorruptedException {
        BigInteger bigIntDelta = new BigInteger(delta);
        if (bigIntDelta.compareTo(TextProtocolUtil.MAX_UNSIGNED_LONG) > 0) {
            throw new StreamCorruptedException("Increment or decrement delta sent (" + delta + ") exceeds unsigned limit (" + TextProtocolUtil.MAX_UNSIGNED_LONG + ")");
        }
        if (bigIntDelta.compareTo(TextProtocolUtil.MIN_UNSIGNED) < 0) {
            throw new StreamCorruptedException("Increment or decrement delta cannot be negative: " + delta);
        }
        return bigIntDelta;
    }

    private Object createSuccessResponse() {
        if (this.isStatsEnabled && this.header.operation == MemcachedOperation.ReplaceIfUnmodifiedRequest) {
            this.replaceIfUnmodifiedHits.incrementAndGet();
        }
        if (this.params == null || !this.params.noReply) {
            if (this.header.operation == MemcachedOperation.RemoveRequest) {
                return TextProtocolUtil.DELETED;
            }
            return TextProtocolUtil.STORED;
        }
        return null;
    }

    Object createNotExecutedResponse() {
        if (this.isStatsEnabled && this.header.operation == MemcachedOperation.ReplaceIfUnmodifiedRequest) {
            this.replaceIfUnmodifiedBadval.incrementAndGet();
        }
        if (this.params == null || !this.params.noReply) {
            if (this.header.operation == MemcachedOperation.ReplaceIfUnmodifiedRequest) {
                return TextProtocolUtil.EXISTS;
            }
            return TextProtocolUtil.NOT_STORED;
        }
        return null;
    }

    Object createNotExistResponse() {
        if (this.isStatsEnabled && this.header.operation == MemcachedOperation.ReplaceIfUnmodifiedRequest) {
            this.replaceIfUnmodifiedMisses.incrementAndGet();
        }
        if (this.params == null || !this.params.noReply) {
            return TextProtocolUtil.NOT_FOUND;
        }
        return null;
    }

    Object createGetResponse(String k, CacheEntry<String, byte[]> entry) {
        if (entry != null) {
            switch (this.header.operation) {
                case GetRequest: {
                    return this.buildSingleGetResponse(k, entry);
                }
                case GetWithVersionRequest: {
                    return this.buildSingleGetWithVersionResponse(k, entry);
                }
            }
            throw new IllegalArgumentException("Operation " + (Object)((Object)this.header.operation) + " not supported!");
        }
        return TextProtocolUtil.END;
    }

    private ByteBuf buildSingleGetResponse(String k, CacheEntry<String, byte[]> entry) {
        ByteBuf buf = this.buildGetHeaderBegin(k, entry, TextProtocolUtil.END_SIZE);
        this.writeGetHeaderData((byte[])entry.getValue(), buf);
        return this.writeGetHeaderEnd(buf);
    }

    Object createMultiGetResponse(Map<String, CacheEntry<String, byte[]>> pairs) {
        Stream.Builder<ByteBuf> elements = Stream.builder();
        switch (this.header.operation) {
            case GetRequest: 
            case GetWithVersionRequest: {
                pairs.forEach((k, v) -> elements.add(this.buildGetResponse((String)k, (CacheEntry<String, byte[]>)v)));
                elements.add(ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{TextProtocolUtil.END}));
                return elements.build().toArray(ByteBuf[]::new);
            }
        }
        throw new IllegalArgumentException("Operation " + (Object)((Object)this.header.operation) + " not supported!");
    }

    void handleModification(Channel ch, ByteBuf buf) throws IOException {
        KeyValuePair<String, Boolean> pair = this.readKey(buf);
        this.key = (String)pair.getKey();
        if (((Boolean)pair.getValue()).booleanValue()) {
            this.writeResponse(ch, this.remove());
        } else {
            this.checkpoint((Object)MemcachedDecoderState.DECODE_PARAMETERS);
        }
    }

    private void resetParams() {
        this.checkpoint((Object)MemcachedDecoderState.DECODE_HEADER);
        this.params = null;
        this.rawValue = null;
    }

    protected Object remove() {
        Object prev = this.cache.remove((Object)this.key);
        if (prev != null) {
            return this.createSuccessResponse();
        }
        return this.createNotExistResponse();
    }

    private Object createErrorResponse(Throwable t) {
        StringBuilder sb = new StringBuilder();
        if (t instanceof MemcachedException) {
            Throwable cause = t.getCause();
            if (cause instanceof UnknownOperationException) {
                log.exceptionReported(cause);
                return TextProtocolUtil.ERROR;
            }
            if (cause instanceof ClosedChannelException) {
                log.exceptionReported(cause);
                return null;
            }
            if (cause instanceof IOException || cause instanceof NumberFormatException || cause instanceof IllegalStateException) {
                return this.logAndCreateErrorMessage(sb, (MemcachedException)t);
            }
            return sb.append(t.getMessage()).append("\r\n");
        }
        if (t instanceof ClosedChannelException) {
            log.exceptionReported(t);
            return null;
        }
        return sb.append("SERVER_ERROR ").append(t.getMessage()).append("\r\n");
    }

    protected Metadata buildMetadata() {
        MemcachedMetadataBuilder metadata = new MemcachedMetadataBuilder();
        metadata.version(this.generateVersion((Cache<String, byte[]>)this.cache));
        metadata.flags(this.params.flags);
        if (this.params.lifespan > 0) {
            metadata.lifespan(this.toMillis(this.params.lifespan));
        }
        return metadata.build();
    }

    private StringBuilder logAndCreateErrorMessage(StringBuilder sb, MemcachedException m) {
        log.exceptionReported(m.getCause());
        return sb.append(m.getMessage()).append("\r\n");
    }

    private long toMillis(int lifespan) {
        if (lifespan > 2592000) {
            long unixTimeExpiry = TimeUnit.SECONDS.toMillis(lifespan) - System.currentTimeMillis();
            return unixTimeExpiry < 0L ? 0L : unixTimeExpiry;
        }
        return TimeUnit.SECONDS.toMillis(lifespan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object writeResponse(Channel ch, Object response) {
        try {
            if (response != null) {
                if (isTrace) {
                    log.tracef("Write response %s", response);
                }
                if (response instanceof ByteBuf[]) {
                    for (ByteBuf buf : (ByteBuf[])response) {
                        ch.write((Object)buf, ch.voidPromise());
                        ch.flush();
                    }
                } else if (response instanceof byte[]) {
                    ch.writeAndFlush((Object)ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{(byte[])response}), ch.voidPromise());
                } else if (response instanceof CharSequence) {
                    ch.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)((CharSequence)response), (Charset)CharsetUtil.UTF_8), ch.voidPromise());
                } else {
                    if (response instanceof PartialResponse) {
                        Object object = response;
                        return object;
                    }
                    ch.writeAndFlush(response, ch.voidPromise());
                }
            }
            ByteBuf[] byteBufArray = null;
            return byteBufArray;
        }
        finally {
            this.resetParams();
        }
    }

    Object createStatsResponse() {
        Stats stats = this.cache.getAdvancedCache().getStats();
        StringBuilder sb = new StringBuilder();
        return new ByteBuf[]{this.buildStat("pid", 0, sb), this.buildStat("uptime", stats.getTimeSinceStart(), sb), this.buildStat("uptime", stats.getTimeSinceStart(), sb), this.buildStat("time", TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()), sb), this.buildStat("version", this.cache.getVersion(), sb), this.buildStat("pointer_size", 0, sb), this.buildStat("rusage_user", 0, sb), this.buildStat("rusage_system", 0, sb), this.buildStat("curr_items", stats.getCurrentNumberOfEntries(), sb), this.buildStat("total_items", stats.getTotalNumberOfEntries(), sb), this.buildStat("bytes", 0, sb), this.buildStat("curr_connections", 0, sb), this.buildStat("total_connections", 0, sb), this.buildStat("connection_structures", 0, sb), this.buildStat("cmd_get", stats.getRetrievals(), sb), this.buildStat("cmd_set", stats.getStores(), sb), this.buildStat("get_hits", stats.getHits(), sb), this.buildStat("get_misses", stats.getMisses(), sb), this.buildStat("delete_misses", stats.getRemoveMisses(), sb), this.buildStat("delete_hits", stats.getRemoveHits(), sb), this.buildStat("incr_misses", this.incrMisses, sb), this.buildStat("incr_hits", this.incrHits, sb), this.buildStat("decr_misses", this.decrMisses, sb), this.buildStat("decr_hits", this.decrHits, sb), this.buildStat("cas_misses", this.replaceIfUnmodifiedMisses, sb), this.buildStat("cas_hits", this.replaceIfUnmodifiedHits, sb), this.buildStat("cas_badval", this.replaceIfUnmodifiedBadval, sb), this.buildStat("auth_cmds", 0, sb), this.buildStat("auth_errors", 0, sb), this.buildStat("evictions", stats.getEvictions(), sb), this.buildStat("bytes_read", this.transport.getTotalBytesRead(), sb), this.buildStat("bytes_written", this.transport.getTotalBytesWritten(), sb), this.buildStat("limit_maxbytes", 0, sb), this.buildStat("threads", 0, sb), this.buildStat("conn_yields", 0, sb), this.buildStat("reclaimed", 0, sb), ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{TextProtocolUtil.END})};
    }

    private ByteBuf buildStat(String stat, Object value, StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append("\r\n");
        ByteBuf buffer = ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{sb.toString().getBytes()});
        sb.setLength(0);
        return buffer;
    }

    private ByteBuf buildStat(String stat, int value, StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append("\r\n");
        ByteBuf buffer = ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{sb.toString().getBytes()});
        sb.setLength(0);
        return buffer;
    }

    private ByteBuf buildStat(String stat, long value, StringBuilder sb) {
        sb.append("STAT").append(' ').append(stat).append(' ').append(value).append("\r\n");
        ByteBuf buffer = ExtendedByteBuf.wrappedBuffer((byte[][])new byte[][]{sb.toString().getBytes()});
        sb.setLength(0);
        return buffer;
    }

    private ByteBuf buildGetResponse(String k, CacheEntry<String, byte[]> entry) {
        ByteBuf buf = this.buildGetHeaderBegin(k, entry, 0);
        return this.writeGetHeaderData((byte[])entry.getValue(), buf);
    }

    private ByteBuf buildGetHeaderBegin(String k, CacheEntry<String, byte[]> entry, int extraSpace) {
        byte[] flags;
        byte[] data = (byte[])entry.getValue();
        byte[] dataSize = String.valueOf(data.length).getBytes();
        byte[] key = k.getBytes();
        Metadata metadata = entry.getMetadata();
        if (metadata instanceof MemcachedMetadata) {
            long metaFlags = ((MemcachedMetadata)metadata).flags;
            flags = String.valueOf(metaFlags).getBytes();
        } else {
            flags = TextProtocolUtil.ZERO;
        }
        int flagsSize = flags.length;
        ByteBuf buf = ExtendedByteBuf.buffer((int)(TextProtocolUtil.VALUE_SIZE + key.length + data.length + flagsSize + dataSize.length + 6 + extraSpace));
        buf.writeBytes(TextProtocolUtil.VALUE);
        buf.writeBytes(key);
        buf.writeByte(32);
        buf.writeBytes(flags);
        buf.writeByte(32);
        buf.writeBytes(dataSize);
        return buf;
    }

    private ByteBuf writeGetHeaderData(byte[] data, ByteBuf buf) {
        buf.writeBytes(TextProtocolUtil.CRLFBytes);
        buf.writeBytes(data);
        buf.writeBytes(TextProtocolUtil.CRLFBytes);
        return buf;
    }

    private ByteBuf writeGetHeaderEnd(ByteBuf buf) {
        buf.writeBytes(TextProtocolUtil.END);
        return buf;
    }

    private ByteBuf buildSingleGetWithVersionResponse(String k, CacheEntry<String, byte[]> entry) {
        byte[] v = (byte[])entry.getValue();
        byte[] version = String.valueOf(((NumericVersion)entry.getMetadata().version()).getVersion()).getBytes();
        ByteBuf buf = this.buildGetHeaderBegin(k, entry, version.length + 1 + TextProtocolUtil.END_SIZE);
        buf.writeByte(32);
        buf.writeBytes(version);
        this.writeGetHeaderData(v, buf);
        return this.writeGetHeaderEnd(buf);
    }

    private int friendlyMaxIntCheck(String number, String message) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return this.numericLimitCheck(number, Integer.MAX_VALUE, message, e);
        }
    }

    private int numericLimitCheck(String number, long maxValue, String message, NumberFormatException n) {
        if (Long.parseLong(number) > maxValue) {
            throw new NumberFormatException(message + " sent (" + number + ") exceeds the limit (" + maxValue + ")");
        }
        throw n;
    }

    private long numericLimitCheck(String number, long maxValue, String message) {
        long numeric = Long.parseLong(number);
        if (numeric > maxValue) {
            throw new NumberFormatException(message + " sent (" + number + ") exceeds the limit (" + maxValue + ")");
        }
        return numeric;
    }

    private MemcachedOperation toRequest(String commandName, Boolean endOfOp, ByteBuf buffer) throws UnknownOperationException {
        if (isTrace) {
            log.tracef("Operation: '%s'", commandName);
        }
        switch (commandName) {
            case "get": {
                return MemcachedOperation.GetRequest;
            }
            case "set": {
                return MemcachedOperation.PutRequest;
            }
            case "add": {
                return MemcachedOperation.PutIfAbsentRequest;
            }
            case "delete": {
                return MemcachedOperation.RemoveRequest;
            }
            case "replace": {
                return MemcachedOperation.ReplaceRequest;
            }
            case "cas": {
                return MemcachedOperation.ReplaceIfUnmodifiedRequest;
            }
            case "append": {
                return MemcachedOperation.AppendRequest;
            }
            case "prepend": {
                return MemcachedOperation.PrependRequest;
            }
            case "gets": {
                return MemcachedOperation.GetWithVersionRequest;
            }
            case "incr": {
                return MemcachedOperation.IncrementRequest;
            }
            case "decr": {
                return MemcachedOperation.DecrementRequest;
            }
            case "flush_all": {
                return MemcachedOperation.FlushAllRequest;
            }
            case "version": {
                return MemcachedOperation.VersionRequest;
            }
            case "stats": {
                return MemcachedOperation.StatsRequest;
            }
            case "verbosity": {
                return MemcachedOperation.VerbosityRequest;
            }
            case "quit": {
                return MemcachedOperation.QuitRequest;
            }
        }
        if (!endOfOp.booleanValue()) {
            String line = TextProtocolUtil.readDiscardedLine(buffer);
            log.debugf("Unexpected operation '%s', rest of line contains: %s", commandName, line);
        }
        throw new UnknownOperationException("Unknown operation: " + commandName);
    }
}

