/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.infinispan.Cache;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedMultiNodeTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.memcached.MemcachedDistributionTest")
public class MemcachedDistributionTest
extends MemcachedMultiNodeTest {
    @Override
    public EmbeddedCacheManager createCacheManager(int index) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(1).dataContainer().valueEquivalence(ByteArrayEquivalence.INSTANCE);
        return TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)GlobalConfigurationBuilder.defaultClusteredBuilder().defaultCacheName(cacheName), (ConfigurationBuilder)builder);
    }

    public void testGetFromNonOwner() throws InterruptedException, ExecutionException, TimeoutException {
        MemcachedClient owner = this.getFirstOwner("1");
        OperationFuture f = owner.set("1", 0, (Object)"v1");
        Assert.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        MemcachedClient nonOwner = this.getFirstNonOwner("1");
        Assert.assertEquals((Object)nonOwner.get("1"), (Object)"v1");
    }

    private MemcachedClient getFirstNonOwner(String k) {
        return this.getCacheThat(k, false);
    }

    private MemcachedClient getFirstOwner(String k) {
        return this.getCacheThat(k, true);
    }

    private MemcachedClient getCacheThat(String k, Boolean owner) {
        List caches = this.servers.stream().map(s -> {
            Cache cache = s.getCacheManager().getCache(cacheName);
            return cache;
        }).collect(Collectors.toList());
        Cache cache = owner != false ? DistributionTestHelper.getFirstOwner((Object)k, caches) : DistributionTestHelper.getFirstNonOwner((Object)k, caches);
        return (MemcachedClient)this.cacheClient.get(cache);
    }
}

