/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.server.memcached.MemcachedExpirableMetadata;
import org.infinispan.server.memcached.MemcachedMetadata;
import org.jboss.marshalling.util.IdentityIntMap;

public class MemcachedMetadataExternalizer
extends AbstractExternalizer<MemcachedMetadata> {
    static final int Immortal = 0;
    static final int Expirable = 1;
    static final IdentityIntMap<Class> numbers = new IdentityIntMap(2);

    public Set<Class<? extends MemcachedMetadata>> getTypeClasses() {
        return Util.asSet((Object[])new Class[]{MemcachedMetadata.class, MemcachedExpirableMetadata.class});
    }

    public void writeObject(ObjectOutput output, MemcachedMetadata object) throws IOException {
        output.writeLong(object.flags);
        output.writeObject(object.version);
        int number = numbers.get(object.getClass(), -1);
        output.write(number);
        if (number == 1) {
            output.writeLong(object.lifespan());
        }
    }

    public MemcachedMetadata readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        long flags = input.readLong();
        EntryVersion version = (EntryVersion)input.readObject();
        int number = input.readUnsignedByte();
        switch (number) {
            case 0: {
                return new MemcachedMetadata(flags, version);
            }
            case 1: {
                long lifespan = input.readLong();
                return new MemcachedExpirableMetadata(flags, version, lifespan, TimeUnit.MILLISECONDS);
            }
        }
        throw new IllegalArgumentException("Number " + number + " not supported!");
    }

    static {
        numbers.put(MemcachedMetadata.class, 0);
        numbers.put(MemcachedExpirableMetadata.class, 1);
    }
}

