/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedMultiNodeTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.memcached.MemcachedReplicationTest")
public class MemcachedReplicationTest
extends MemcachedMultiNodeTest {
    @Override
    protected EmbeddedCacheManager createCacheManager(int index) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.REPL_SYNC).dataContainer().valueEquivalence(ByteArrayEquivalence.INSTANCE);
        return TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)GlobalConfigurationBuilder.defaultClusteredBuilder().defaultCacheName(cacheName), (ConfigurationBuilder)builder);
    }

    public void testReplicatedSet(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = ((MemcachedClient)this.clients.get(0)).set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)((MemcachedClient)this.clients.get(0)).get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
    }

    public void testReplicatedGetMultipleKeys(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f1 = ((MemcachedClient)this.clients.get(0)).set(TestingUtil.k((Method)m, (String)"k1-"), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        OperationFuture f2 = ((MemcachedClient)this.clients.get(0)).set(TestingUtil.k((Method)m, (String)"k2-"), 0, (Object)TestingUtil.v((Method)m, (String)"v2-"));
        OperationFuture f3 = ((MemcachedClient)this.clients.get(0)).set(TestingUtil.k((Method)m, (String)"k3-"), 0, (Object)TestingUtil.v((Method)m, (String)"v3-"));
        AssertJUnit.assertTrue((boolean)((Boolean)f1.get((long)this.timeout, TimeUnit.SECONDS)));
        AssertJUnit.assertTrue((boolean)((Boolean)f2.get((long)this.timeout, TimeUnit.SECONDS)));
        AssertJUnit.assertTrue((boolean)((Boolean)f3.get((long)this.timeout, TimeUnit.SECONDS)));
        List<String> keys = Arrays.asList(TestingUtil.k((Method)m, (String)"k1-"), TestingUtil.k((Method)m, (String)"k2-"), TestingUtil.k((Method)m, (String)"k3-"));
        Map ret = ((MemcachedClient)this.clients.get(1)).getBulk(keys);
        AssertJUnit.assertEquals(ret.get(TestingUtil.k((Method)m, (String)"k1-")), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertEquals(ret.get(TestingUtil.k((Method)m, (String)"k2-")), (Object)TestingUtil.v((Method)m, (String)"v2-"));
        AssertJUnit.assertEquals(ret.get(TestingUtil.k((Method)m, (String)"k3-")), (Object)TestingUtil.v((Method)m, (String)"v3-"));
    }

    public void testReplicatedAdd(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = ((MemcachedClient)this.clients.get(0)).add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)((MemcachedClient)this.clients.get(1)).get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
    }

    public void testReplicatedReplace(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = ((MemcachedClient)this.clients.get(0)).add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)((MemcachedClient)this.clients.get(1)).get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
        f = ((MemcachedClient)this.clients.get(1)).replace(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)((MemcachedClient)this.clients.get(0)).get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m, (String)"v1-"));
    }

    public void testReplicatedAppend(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = ((MemcachedClient)this.clients.get(0)).add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)((MemcachedClient)this.clients.get(1)).get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
        f = ((MemcachedClient)this.clients.get(1)).append(0L, TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        String expected = TestingUtil.v((Method)m) + TestingUtil.v((Method)m, (String)"v1-");
        AssertJUnit.assertEquals((Object)((MemcachedClient)this.clients.get(0)).get(TestingUtil.k((Method)m)), (Object)expected);
    }

    public void testReplicatedPrepend(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = ((MemcachedClient)this.clients.get(0)).add(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)((MemcachedClient)this.clients.get(1)).get(TestingUtil.k((Method)m)), (Object)TestingUtil.v((Method)m));
        f = ((MemcachedClient)this.clients.get(1)).prepend(0L, TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        String expected = TestingUtil.v((Method)m, (String)"v1-") + TestingUtil.v((Method)m);
        AssertJUnit.assertEquals((Object)((MemcachedClient)this.clients.get(0)).get(TestingUtil.k((Method)m)), (Object)expected);
    }

    public void testReplicatedGets(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = ((MemcachedClient)this.clients.get(0)).set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        CASValue value = ((MemcachedClient)this.clients.get(1)).gets(TestingUtil.k((Method)m));
        AssertJUnit.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
    }

    public void testReplicatedCasExists(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = ((MemcachedClient)this.clients.get(0)).set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        CASValue value = ((MemcachedClient)this.clients.get(1)).gets(TestingUtil.k((Method)m));
        AssertJUnit.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        long old = value.getCas();
        CASResponse resp = ((MemcachedClient)this.clients.get(1)).cas(TestingUtil.k((Method)m), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        value = ((MemcachedClient)this.clients.get(0)).gets(TestingUtil.k((Method)m));
        AssertJUnit.assertEquals((Object)value.getValue(), (Object)TestingUtil.v((Method)m, (String)"v1-"));
        AssertJUnit.assertTrue((value.getCas() != 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((value.getCas() != old ? 1 : 0) != 0);
        resp = ((MemcachedClient)this.clients.get(0)).cas(TestingUtil.k((Method)m), old, (Object)TestingUtil.v((Method)m, (String)"v2-"));
        AssertJUnit.assertEquals((Object)resp, (Object)CASResponse.EXISTS);
        resp = ((MemcachedClient)this.clients.get(1)).cas(TestingUtil.k((Method)m), value.getCas(), (Object)TestingUtil.v((Method)m, (String)"v2-"));
        AssertJUnit.assertEquals((Object)resp, (Object)CASResponse.OK);
    }

    public void testReplicatedDelete(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = ((MemcachedClient)this.clients.get(0)).set(TestingUtil.k((Method)m), 0, (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        f = ((MemcachedClient)this.clients.get(1)).delete(TestingUtil.k((Method)m));
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
    }

    public void testReplicatedIncrement(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = ((MemcachedClient)this.clients.get(0)).set(TestingUtil.k((Method)m), 0, (Object)"1");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((long)((MemcachedClient)this.clients.get(1)).incr(TestingUtil.k((Method)m), 1), (long)2L);
    }

    public void testReplicatedDecrement(Method m) throws InterruptedException, ExecutionException, TimeoutException {
        OperationFuture f = ((MemcachedClient)this.clients.get(0)).set(TestingUtil.k((Method)m), 0, (Object)"1");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get((long)this.timeout, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((long)((MemcachedClient)this.clients.get(1)).decr(TestingUtil.k((Method)m), 1), (long)0L);
    }
}

