/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.test.Stoppable;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedServerConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.memcached.MemcachedServerTest")
public class MemcachedServerTest
extends AbstractInfinispanTest {
    void testValidateDefaultConfiguration() {
        Stoppable.useCacheManager((EmbeddedCacheManager)TestCacheManagerFactory.createCacheManager(), cm -> Stoppable.useServer((AbstractProtocolServer)new MemcachedServer(), ms -> {
            ms.start((ProtocolServerConfiguration)new MemcachedServerConfigurationBuilder().build(), cm);
            Assert.assertEquals((String)ms.getHost(), (String)"127.0.0.1");
            Assert.assertEquals((int)ms.getPort(), (int)11211);
        }));
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    void testValidateInvalidExpiration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.expiration().lifespan(10L);
        Stoppable.useCacheManager((EmbeddedCacheManager)TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config), cm -> Stoppable.useServer((AbstractProtocolServer)new MemcachedServer(), ms -> {
            ms.start((ProtocolServerConfiguration)new MemcachedServerConfigurationBuilder().cache("memcachedCache").build(), cm);
            Assert.fail((String)"Server should not start when expiration is enabled");
        }));
    }
}

