/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.spy.memcached.MemcachedClient;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.test.MemcachedTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;

abstract class MemcachedSingleNodeTest
extends SingleCacheManagerTest {
    protected MemcachedClient client;
    protected MemcachedServer server;
    protected static final int timeout = 60;

    MemcachedSingleNodeTest() {
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = this.createTestCacheManager();
        this.server = MemcachedTestingUtil.startMemcachedTextServer(this.cacheManager);
        this.client = MemcachedTestingUtil.createMemcachedClient(60000L, this.server.getPort());
        this.cache = this.cacheManager.getCache(((MemcachedServerConfiguration)this.server.getConfiguration()).defaultCacheName());
        return this.cacheManager;
    }

    protected EmbeddedCacheManager createTestCacheManager() {
        return TestCacheManagerFactory.createCacheManager((boolean)false);
    }

    @AfterClass(alwaysRun=true)
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        this.log.debug((Object)"Test finished, close memcached server");
        this.shutdownClient();
        MemcachedTestingUtil.killMemcachedServer(this.server);
    }

    protected void shutdownClient() {
        this.client.shutdown();
    }

    protected String send(String req) throws IOException {
        return this.sendMulti(req, 1, true).get(0);
    }

    protected List<String> sendNoWait(String req) throws IOException {
        return this.sendMulti(req, 1, false);
    }

    protected List<String> sendMulti(String req, int expectedResponses, boolean wait) throws IOException {
        try (Socket socket = new Socket(this.server.getHost(), this.server.getPort());){
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(req.getBytes());
            outputStream.flush();
            if (wait) {
                Stream.Builder<String> builder = Stream.builder();
                for (int i = 0; i < expectedResponses; ++i) {
                    builder.accept(this.readLine(socket.getInputStream(), new StringBuilder()));
                }
                List<String> list = builder.build().collect(Collectors.toList());
                return list;
            }
            List<String> list = Collections.emptyList();
            return list;
        }
    }

    protected String readLine(InputStream is, StringBuilder sb) throws IOException {
        int next = is.read();
        if (next == 13) {
            next = is.read();
            if (next == 10) {
                return sb.toString().trim();
            }
            sb.append((char)next);
            return this.readLine(is, sb);
        }
        if (next == 10) {
            return sb.toString().trim();
        }
        sb.append((char)next);
        return this.readLine(is, sb);
    }

    protected void assertClientError(String resp) {
        this.assertExpectedResponse(resp, "CLIENT_ERROR", false);
    }

    protected void assertError(String resp) {
        this.assertExpectedResponse(resp, "ERROR", true);
    }

    protected void assertStored(String resp) {
        this.assertExpectedResponse(resp, "STORED", true);
    }

    protected void assertExpectedResponse(String resp, String expectedResp, boolean strictComparison) {
        if (strictComparison) {
            Assert.assertEquals((String)resp, (String)expectedResp, (String)("Instead response is: " + resp));
        } else {
            Assert.assertTrue((boolean)resp.contains(expectedResp), (String)("Instead response is: " + resp));
        }
    }
}

