/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached.test;

import io.netty.channel.ChannelInboundHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.infinispan.Cache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.memcached.MemcachedDecoder;
import org.infinispan.server.memcached.MemcachedServer;
import org.infinispan.server.memcached.configuration.MemcachedServerConfigurationBuilder;
import org.infinispan.server.memcached.logging.Log;
import org.infinispan.server.memcached.test.UniquePortThreadLocal;
import org.infinispan.test.fwk.TestResourceTracker;

public class MemcachedTestingUtil {
    private static final Log log = (Log)LogFactory.getLog(MemcachedTestingUtil.class, Log.class);
    private static final String host = "127.0.0.1";

    public static MemcachedClient createMemcachedClient(final long timeout, int port) throws IOException {
        DefaultConnectionFactory d = new DefaultConnectionFactory(){

            public long getOperationTimeout() {
                return timeout;
            }
        };
        return new MemcachedClient((ConnectionFactory)d, Collections.singletonList(new InetSocketAddress(host, port)));
    }

    public static MemcachedServer startMemcachedTextServer(EmbeddedCacheManager cacheManager) {
        return MemcachedTestingUtil.startMemcachedTextServer(cacheManager, (Integer)UniquePortThreadLocal.INSTANCE.get());
    }

    public static MemcachedServer startMemcachedTextServer(EmbeddedCacheManager cacheManager, int port) {
        MemcachedServer server = new MemcachedServer();
        String serverName = TestResourceTracker.getCurrentTestShortName();
        server.start((ProtocolServerConfiguration)((MemcachedServerConfigurationBuilder)((MemcachedServerConfigurationBuilder)((MemcachedServerConfigurationBuilder)new MemcachedServerConfigurationBuilder().name(serverName)).host(host)).port(port)).build(), cacheManager);
        return server;
    }

    public static MemcachedServer startMemcachedTextServer(EmbeddedCacheManager cacheManager, String cacheName) {
        return MemcachedTestingUtil.startMemcachedTextServer(cacheManager, (Integer)UniquePortThreadLocal.INSTANCE.get(), cacheName);
    }

    public static MemcachedServer startMemcachedTextServer(EmbeddedCacheManager cacheManager, int port, final String cacheName) {
        MemcachedServer server = new MemcachedServer(){

            public ChannelInboundHandler getDecoder() {
                Cache cache = this.getCacheManager().getCache(cacheName);
                return new MemcachedDecoder(cache.getAdvancedCache(), this.scheduler, this.transport, s -> false);
            }

            protected void startDefaultCache() {
                this.getCacheManager().getCache(cacheName);
            }
        };
        String serverName = TestResourceTracker.getCurrentTestShortName();
        server.start((ProtocolServerConfiguration)((MemcachedServerConfigurationBuilder)((MemcachedServerConfigurationBuilder)((MemcachedServerConfigurationBuilder)new MemcachedServerConfigurationBuilder().name(serverName)).host(host)).port(port)).build(), cacheManager);
        return server;
    }

    public static void killMemcachedClient(MemcachedClient client) {
        try {
            if (client != null) {
                client.shutdown();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error stopping client", t);
        }
    }

    public static void killMemcachedServer(MemcachedServer server) {
        if (server != null) {
            server.stop();
        }
    }
}

