/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.infinispan.commons.jmx.PerThreadMBeanServerLookup;
import org.testng.Assert;

class ConnectionStatsTest {
    ConnectionStatsTest() {
    }

    public static void testSingleLocalConnection(String jmxDomain, String serverName) throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException {
        MBeanServer mbeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        ObjectName on = new ObjectName(String.format("%s:type=Server,name=%s,component=Transport", jmxDomain, serverName));
        Assert.assertTrue((Integer.parseInt(mbeanServer.getAttribute(on, "TotalBytesRead").toString()) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((Integer.parseInt(mbeanServer.getAttribute(on, "TotalBytesWritten").toString()) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)mbeanServer.getAttribute(on, "NumberOfLocalConnections"), (Object)1);
    }

    public static void testMultipleLocalConnections(String jmxDomain, String serverName, int expectedTotalConns) throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException {
        MBeanServer mbeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        ObjectName on = new ObjectName(String.format("%s:type=Server,name=%s,component=Transport", jmxDomain, serverName));
        Assert.assertEquals((Object)mbeanServer.getAttribute(on, "NumberOfLocalConnections"), (Object)expectedTotalConns);
    }

    public static void testGlobalConnections(String jmxDomain, String serverName, int expectedTotalConns, MBeanServer mbeanServer) throws MalformedObjectNameException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException {
        ObjectName on = new ObjectName(String.format("%s:type=Server,name=%s,component=Transport", jmxDomain, serverName));
        Assert.assertEquals((Object)mbeanServer.getAttribute(on, "NumberOfGlobalConnections"), (Object)expectedTotalConns);
    }
}

