/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespSingleNodeTest")
public class RespSingleNodeTest
extends SingleCacheManagerTest {
    protected RedisClient client;
    protected RespServer server;
    protected StatefulRedisConnection<String, String> redisConnection;
    protected static final int timeout = 60;

    protected EmbeddedCacheManager createCacheManager() {
        this.cacheManager = this.createTestCacheManager();
        this.server = RespTestingUtil.startServer(this.cacheManager);
        this.client = RespTestingUtil.createClient(30000L, this.server.getPort());
        this.redisConnection = this.client.connect();
        this.cache = this.cacheManager.getCache(((RespServerConfiguration)this.server.getConfiguration()).defaultCacheName());
        return this.cacheManager;
    }

    protected EmbeddedCacheManager createTestCacheManager() {
        return TestCacheManagerFactory.createCacheManager((boolean)true);
    }

    @AfterClass(alwaysRun=true)
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        log.debug((Object)"Test finished, close resp server");
        RespTestingUtil.killClient(this.client);
        RespTestingUtil.killServer(this.server);
    }

    public void testSetMGet() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)"k1", (Object)"v1");
        redis.set((Object)"k3", (Object)"v3");
        redis.set((Object)"k4", (Object)"v4");
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>(4);
        expected.add(KeyValue.just((Object)"k1", (Object)"v1"));
        expected.add(KeyValue.empty((Object)"k2"));
        expected.add(KeyValue.just((Object)"k3", (Object)"v3"));
        expected.add(KeyValue.just((Object)"k4", (Object)"v4"));
        List results = redis.mget((Object[])new String[]{"k1", "k2", "k3", "k4"});
        AssertJUnit.assertEquals(expected, (Object)results);
    }

    public void testMSetMGet() {
        RedisCommands redis = this.redisConnection.sync();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("k1", "v1");
        values.put("k3", "v3");
        values.put("k4", "v4");
        redis.mset(values);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>(4);
        expected.add(KeyValue.just((Object)"k1", (Object)"v1"));
        expected.add(KeyValue.empty((Object)"k2"));
        expected.add(KeyValue.just((Object)"k3", (Object)"v3"));
        expected.add(KeyValue.just((Object)"k4", (Object)"v4"));
        List results = redis.mget((Object[])new String[]{"k1", "k2", "k3", "k4"});
        AssertJUnit.assertEquals(expected, (Object)results);
    }

    public void testSetGetDelete() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)"k1", (Object)"v1");
        String v = (String)redis.get((Object)"k1");
        AssertJUnit.assertEquals((String)"v1", (String)v);
        redis.del((Object[])new String[]{"k1"});
        AssertJUnit.assertNull((Object)redis.get((Object)"k1"));
    }

    public void testPingNoArg() {
        RedisCommands redis = this.redisConnection.sync();
        AssertJUnit.assertEquals((String)"PONG", (String)redis.ping());
    }

    public void testEcho() {
        RedisCommands redis = this.redisConnection.sync();
        String stringToSend = "HI THERE!";
        AssertJUnit.assertEquals((String)stringToSend, (String)((String)redis.echo((Object)stringToSend)));
    }

    private BlockingQueue<String> addPubSubListener(RedisPubSubCommands<String, String> connection) {
        final LinkedBlockingQueue<String> handOffQueue = new LinkedBlockingQueue<String>();
        connection.getStatefulConnection().addListener((RedisPubSubListener)new RedisPubSubAdapter<String, String>(){

            public void message(String channel, String message) {
                handOffQueue.add("message-" + channel + "-" + message);
            }

            public void subscribed(String channel, long count) {
                handOffQueue.add("subscribed-" + channel + "-" + count);
            }

            public void unsubscribed(String channel, long count) {
                handOffQueue.add("unsubscribed-" + channel + "-" + count);
            }
        });
        return handOffQueue;
    }

    @DataProvider(name="booleans")
    Object[][] booleans() {
        return new Object[][]{{false}};
    }

    @Test(dataProvider="booleans")
    public void testPubSubUnsubscribe(boolean reset) throws InterruptedException {
        RedisPubSubCommands connection = this.client.connectPubSub().sync();
        BlockingQueue<String> handOffQueue = this.addPubSubListener((RedisPubSubCommands<String, String>)connection);
        connection.subscribe((Object[])new String[]{"channel2", "test"});
        String value = handOffQueue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)"subscribed-channel2-0", (String)value);
        value = handOffQueue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)"subscribed-test-0", (String)value);
        if (reset) {
            connection.reset();
        } else {
            connection.unsubscribe((Object[])new String[0]);
        }
        for (int i = 0; i < 2; ++i) {
            value = handOffQueue.poll(10L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull((String)"Didn't receive any notifications", (Object)value);
            if (value.equals("unsubscribed-channel2-0") || value.equals("unsubscribed-test-0")) continue;
            AssertJUnit.fail((String)("Notification doesn't match expected, was: " + value));
        }
    }

    public void testPubSub() throws InterruptedException {
        RedisPubSubCommands connection = this.client.connectPubSub().sync();
        BlockingQueue<String> handOffQueue = this.addPubSubListener((RedisPubSubCommands<String, String>)connection);
        connection.subscribe((Object[])new String[]{"channel2", "test"});
        String value = handOffQueue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)"subscribed-channel2-0", (String)value);
        value = handOffQueue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)"subscribed-test-0", (String)value);
        RedisCommands redis = this.redisConnection.sync();
        redis.publish((Object)"channel2", (Object)"boomshakayaka");
        value = handOffQueue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)"message-channel2-boomshakayaka", (String)value);
        connection.subscribe((Object[])new String[]{"channel"});
        value = handOffQueue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((String)"subscribed-channel-0", (String)value);
        connection.unsubscribe((Object[])new String[]{"channel2"});
        connection.unsubscribe((Object[])new String[]{"doesn't-exist"});
        connection.unsubscribe((Object[])new String[]{"channel", "test"});
        for (String channel : new String[]{"channel2", "doesn't-exist", "channel", "test"}) {
            value = handOffQueue.poll(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)("unsubscribed-" + channel + "-0"), (String)value);
        }
    }

    public void testIncrNotPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String nonPresentKey = "incr-notpresent";
        Long newValue = redis.incr((Object)nonPresentKey);
        AssertJUnit.assertEquals((long)1L, (long)newValue);
        Long nextValue = redis.incr((Object)nonPresentKey);
        AssertJUnit.assertEquals((long)2L, (long)nextValue);
    }

    public void testIncrPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "incr";
        redis.set((Object)key, (Object)"12");
        Long newValue = redis.incr((Object)key);
        AssertJUnit.assertEquals((long)13L, (long)newValue);
        Long nextValue = redis.incr((Object)key);
        AssertJUnit.assertEquals((long)14L, (long)nextValue);
    }

    public void testDecrNotPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String nonPresentKey = "decr-notpresent";
        Long newValue = redis.decr((Object)nonPresentKey);
        AssertJUnit.assertEquals((long)-1L, (long)newValue);
        Long nextValue = redis.decr((Object)nonPresentKey);
        AssertJUnit.assertEquals((long)-2L, (long)nextValue);
    }

    public void testDecrPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "decr";
        redis.set((Object)key, (Object)"12");
        Long newValue = redis.decr((Object)key);
        AssertJUnit.assertEquals((long)11L, (long)newValue);
        Long nextValue = redis.decr((Object)key);
        AssertJUnit.assertEquals((long)10L, (long)nextValue);
    }
}

