/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.framework.impl;

import java.util.Arrays;
import org.infinispan.rest.framework.LookupResult;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RegistrationException;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.framework.impl.ResourceManagerImpl;
import org.junit.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="rest.framework.ResourceManagerImplTest")
public class ResourceManagerImplTest {
    private ResourceManagerImpl resourceManager = new ResourceManagerImpl("root");

    @Test(expectedExceptions={RegistrationException.class}, expectedExceptionsMessageRegExp="ISPN.*Cannot register invocation 'HandlerB'.*")
    public void testShouldPreventOverlappingVariablePaths() {
        this.registerHandler("HandlerA", "/{pathA}");
        this.registerHandler("HandlerB", "/{pathB}");
    }

    public void testAllowRegistrationForDifferentMethods() {
        this.registerHandler("HandlerA", Method.GET, "/root/a/{pathA}");
        this.registerHandler("HandlerB", Method.POST, "/root/a/{pathA}");
    }

    @Test
    public void testLookupHandler() {
        this.registerHandler("CompaniesHandler", "/companies", "/companies/{company}", "/companies/{company}/{id}");
        this.registerHandler("StocksHandler", "/stocks/{stock}", "/stocks/{stock}/{currency}");
        this.registerHandler("DirectorsHandler", "/directors", "/directors/director", "/directors/director/{personId}");
        this.registerHandler("InfoHandler", "/info", "/info/jvm", "/info/jvm/{format}", "/info/jvm/threaddump", "/info/{format}/{encoding}");
        Assert.assertNull((Object)this.resourceManager.lookupResource(Method.GET, "/root/dummy"));
        Assert.assertNull((Object)this.resourceManager.lookupResource(Method.GET, "/root/stocks"));
        Assert.assertNull((Object)this.resourceManager.lookupResource(Method.GET, "/root/stocks/2/USD/1"));
        this.assertInvocation(this.resourceManager.lookupResource(Method.GET, "/root/stocks/2"), "StocksHandler");
        this.assertInvocation(this.resourceManager.lookupResource(Method.GET, "/root/stocks/2/USD"), "StocksHandler");
        this.assertInvocation(this.resourceManager.lookupResource(Method.GET, "/root/directors"), "DirectorsHandler");
        this.assertInvocation(this.resourceManager.lookupResource(Method.GET, "/root/directors/director"), "DirectorsHandler");
        this.assertInvocation(this.resourceManager.lookupResource(Method.GET, "/root/directors/director/John"), "DirectorsHandler");
        Assert.assertNull((Object)this.resourceManager.lookupResource(Method.GET, "/root/directors/1345"));
        Assert.assertNull((Object)this.resourceManager.lookupResource(Method.GET, "/root/directors/director/Tim/123"));
        this.assertInvocation(this.resourceManager.lookupResource(Method.GET, "/root/companies"), "CompaniesHandler");
        this.assertInvocation(this.resourceManager.lookupResource(Method.GET, "/root/info"), "InfoHandler");
        this.assertInvocation(this.resourceManager.lookupResource(Method.GET, "/root/info/jvm"), "InfoHandler");
        this.assertInvocation(this.resourceManager.lookupResource(Method.GET, "/root/info/jvm/json"), "InfoHandler");
        this.assertInvocation(this.resourceManager.lookupResource(Method.GET, "/root/info/json/zip"), "InfoHandler");
    }

    private void assertInvocation(LookupResult result, String name) {
        AssertJUnit.assertEquals((String)name, (String)result.getInvocation().getName());
    }

    private void registerHandler(String handlerName, Method method, String ... paths) {
        this.resourceManager.registerResource(() -> {
            Invocations.Builder builder = new Invocations.Builder();
            Arrays.stream(paths).forEach(p -> builder.invocation().method(method).path(p).name(handlerName).handleWith(restRequest -> null));
            return builder.create();
        });
    }

    private void registerHandler(String handlerName, String ... paths) {
        this.resourceManager.registerResource(() -> {
            Invocations.Builder builder = new Invocations.Builder();
            Arrays.stream(paths).forEach(p -> builder.invocation().methods(new Method[]{Method.GET, Method.HEAD, Method.POST}).path(p).name(handlerName).handleWith(restRequest -> null));
            return builder.create();
        });
    }
}

