/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.infinispan.rest.framework.ContentSource;

public class ByteBufContentSource
implements ContentSource {
    private final ByteBuf byteBuf;

    ByteBufContentSource(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    @Override
    public String asString() {
        return this.byteBuf.toString(StandardCharsets.UTF_8);
    }

    @Override
    public byte[] rawContent() {
        if (this.byteBuf != null) {
            if (this.byteBuf.hasArray()) {
                return this.byteBuf.array();
            }
            byte[] bufferCopy = new byte[this.byteBuf.readableBytes()];
            this.byteBuf.readBytes(bufferCopy);
            return bufferCopy;
        }
        return null;
    }
}

