/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.unix.Errors;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.infinispan.rest.NettyRestRequest;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.authentication.AuthenticationException;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.logging.RestAccessLoggingHandler;
import org.infinispan.util.logging.LogFactory;

public class Http20RequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    protected static final Log logger = (Log)LogFactory.getLog(Http20RequestHandler.class, Log.class);
    private final Authenticator authenticator;
    final RestAccessLoggingHandler restAccessLoggingHandler = new RestAccessLoggingHandler();
    protected final RestServer restServer;
    protected final RestServerConfiguration configuration;

    public Http20RequestHandler(RestServer restServer) {
        this.restServer = restServer;
        this.configuration = (RestServerConfiguration)restServer.getConfiguration();
        this.authenticator = restServer.getAuthenticator();
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        RestResponse response;
        NettyRestRequest restRequest = new NettyRestRequest(request);
        try {
            this.restAccessLoggingHandler.preLog(request);
            this.authenticator.challenge(restRequest, ctx);
            response = this.restServer.getRestDispatcher().dispatch(restRequest);
            if (response == null) {
                response = new NettyRestResponse.Builder().status(HttpResponseStatus.NOT_FOUND).build();
            }
            this.addCorrelatedHeaders(request, ((NettyRestResponse)response).getResponse());
        }
        catch (AuthenticationException authException) {
            response = new NettyRestResponse.Builder().status(HttpResponseStatus.UNAUTHORIZED).authenticate(authException.getAuthenticationHeader()).build();
        }
        catch (RestResponseException responseException) {
            logger.errorWhileResponding(responseException);
            response = new NettyRestResponse.Builder().status(responseException.getStatus()).entity(responseException.getText()).build();
        }
        NettyRestResponse nettyRestResponse = response;
        this.sendResponse(ctx, request, nettyRestResponse.getResponse());
    }

    private void addCorrelatedHeaders(FullHttpRequest request, FullHttpResponse response) {
        String streamId = request.headers().get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (streamId != null) {
            response.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
        }
        boolean isKeepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        HttpVersion httpVersion = response.protocolVersion();
        if ((httpVersion == HttpVersion.HTTP_1_1 || httpVersion == HttpVersion.HTTP_1_0) && isKeepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
    }

    protected void sendResponse(ChannelHandlerContext ctx, FullHttpRequest request, FullHttpResponse response) {
        ctx.executor().execute(() -> {
            this.restAccessLoggingHandler.log(ctx, request, response);
            ctx.writeAndFlush((Object)response);
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        if (e.getCause() instanceof TooLongFrameException) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else if (e instanceof Errors.NativeIoException) {
            logger.debug("Native IO Exception", e);
            ctx.close();
        } else {
            logger.uncaughtExceptionInThePipeline(e);
            ctx.close();
        }
    }
}

