/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.authentication.impl;

import io.netty.channel.ChannelHandlerContext;
import java.util.Base64;
import java.util.Optional;
import org.infinispan.rest.NettyRestRequest;
import org.infinispan.rest.authentication.AuthenticationException;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.SecurityDomain;

public class BasicAuthenticator
implements Authenticator {
    private final SecurityDomain domain;
    private final String authenticateHeader;

    public BasicAuthenticator(SecurityDomain domain, String realm) {
        this.domain = domain;
        this.authenticateHeader = realm != null ? String.format("Basic realm=\"%s\"", realm) : "Basic";
    }

    @Override
    public void challenge(NettyRestRequest request, ChannelHandlerContext ctx) throws AuthenticationException {
        String auth = request.getAuthorizationHeader();
        if (auth == null) {
            throw new AuthenticationException(Optional.of(this.authenticateHeader));
        }
        if (auth.length() > 5) {
            String type = auth.substring(0, 5);
            if ("basic".equals(type = type.toLowerCase())) {
                String cookie = auth.substring(6);
                cookie = new String(Base64.getDecoder().decode(cookie.getBytes()));
                String[] split = cookie.split(":");
                try {
                    request.setPrincipal(this.domain.authenticate(split[0], split[1]));
                    return;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
        throw new AuthenticationException(Optional.of(this.authenticateHeader));
    }
}

