/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.framework.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.rest.framework.Invocation;
import org.infinispan.rest.framework.LookupResult;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.ResourceManager;
import org.infinispan.rest.framework.impl.PathItem;
import org.infinispan.rest.framework.impl.ResourceNode;
import org.infinispan.rest.framework.impl.StringPathItem;

public class ResourceManagerImpl
implements ResourceManager {
    private final ResourceNode resourceTree;
    private final String rootPath;

    public ResourceManagerImpl(String rootPath) {
        this.rootPath = rootPath;
        this.resourceTree = new ResourceNode(new StringPathItem(rootPath), null);
    }

    @Override
    public void registerResource(ResourceHandler handler) {
        handler.getInvocations().forEach(invocation -> {
            Set<String> paths = invocation.paths();
            paths.stream().map(this::removeLeadSlash).forEach(path -> {
                List<PathItem> p = Arrays.stream(path.split("/")).map(PathItem::fromString).collect(Collectors.toList());
                this.resourceTree.insertPath((Invocation)invocation, p);
            });
        });
    }

    private String removeLeadSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    @Override
    public LookupResult lookupResource(Method method, String path, String action) {
        List pathItems = Arrays.stream(this.removeLeadSlash(path).split("/")).map(PathItem::fromString).collect(Collectors.toList());
        PathItem startPath = (PathItem)pathItems.iterator().next();
        if (!"*".equals(this.rootPath) && !this.rootPath.equals(startPath.getPath())) {
            return null;
        }
        return this.resourceTree.find(method, pathItems.subList(1, pathItems.size()), action);
    }
}

