/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.framework.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.rest.framework.Invocation;
import org.infinispan.rest.framework.LookupResult;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.impl.LookupResultImpl;
import org.infinispan.rest.framework.impl.PathInterpreter;
import org.infinispan.rest.framework.impl.PathItem;
import org.infinispan.rest.framework.impl.VariablePathItem;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

class ResourceNode {
    private static final Log logger = (Log)LogFactory.getLog(ResourceNode.class, Log.class);
    private final PathItem pathItem;
    private final Map<String, Invocation> invocationTable = new HashMap<String, Invocation>();
    private final Map<PathItem, ResourceNode> children = new HashMap<PathItem, ResourceNode>();

    ResourceNode(PathItem pathItem, Invocation invocation) {
        this.pathItem = pathItem;
        this.updateTable(invocation);
    }

    private void updateTable(Invocation invocation) {
        if (invocation != null) {
            String action = invocation.getAction();
            if (action == null) {
                invocation.methods().forEach(m -> {
                    String method = m.toString();
                    Invocation previous = this.invocationTable.put(method, invocation);
                    if (previous != null) {
                        throw logger.duplicateResource(invocation.getName(), (Method)((Object)m), this.pathItem.toString());
                    }
                });
            } else {
                invocation.methods().forEach(m -> this.invocationTable.put(m.toString() + "_" + action, invocation));
            }
        }
    }

    private ResourceNode insert(PathItem label, Invocation invocation) {
        if (!this.children.containsKey(label)) {
            ResourceNode value = new ResourceNode(label, invocation);
            this.children.put(label, value);
            return value;
        }
        return null;
    }

    void insertPath(Invocation invocation, List<PathItem> path) {
        this.insertPathInternal(this, invocation, path);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.dumpTree(stringBuilder, this, 0);
        return stringBuilder.toString();
    }

    private void dumpTree(StringBuilder builder, ResourceNode node, int ident) {
        for (int i = 0; i < ident; ++i) {
            builder.append("    ");
        }
        builder.append("/").append(node.pathItem);
        node.invocationTable.forEach((k, v) -> builder.append(" ").append((String)k).append(":").append(v));
        builder.append("\n");
        node.children.forEach((key, value) -> this.dumpTree(builder, (ResourceNode)value, ident + 1));
    }

    private void insertPathInternal(ResourceNode node, Invocation invocation, List<PathItem> path) {
        if (path.size() == 1) {
            PathItem next = path.iterator().next();
            if (next.getPath().isEmpty()) {
                this.updateTable(invocation);
                return;
            }
            ResourceNode child = node.children.get(next);
            if (child == null) {
                node.insert(next, invocation);
            } else {
                child.updateTable(invocation);
            }
        } else {
            PathItem pathItem = path.iterator().next();
            ResourceNode child = node.children.get(pathItem);
            if (child == null) {
                ResourceNode inserted = node.insert(pathItem, null);
                this.insertPathInternal(inserted, invocation, path.subList(1, path.size()));
            } else {
                this.insertPathInternal(child, invocation, path.subList(1, path.size()));
            }
        }
    }

    private ResourceNode findMatch(String path, Map<String, String> variables) {
        for (Map.Entry<PathItem, ResourceNode> e : this.children.entrySet()) {
            VariablePathItem vpi;
            Map<String, String> vars;
            if (!(e.getKey() instanceof VariablePathItem) || (vars = PathInterpreter.resolveVariables((vpi = (VariablePathItem)e.getKey()).getExpression(), path)).isEmpty()) continue;
            variables.putAll(vars);
            return e.getValue();
        }
        return null;
    }

    public LookupResult find(Method method, List<PathItem> path, String action) {
        ResourceNode current = this;
        HashMap<String, String> variables = new HashMap<String, String>();
        for (PathItem pathItem : path) {
            ResourceNode resourceNode = current.children.get(pathItem);
            if (resourceNode != null) {
                current = resourceNode;
                continue;
            }
            ResourceNode variableMatch = current.findMatch(pathItem.getPath(), variables);
            if (variableMatch == null) {
                return null;
            }
            current = variableMatch;
        }
        String dispatchMethod = action == null ? method.toString() : method.toString() + "_" + action;
        Invocation invocation = current.invocationTable.get(dispatchMethod);
        if (invocation == null) {
            return null;
        }
        return new LookupResultImpl(invocation, variables);
    }
}

