/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.framework.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.CacheControl;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.RestResponseBuilder;

public class SimpleRestResponse
implements RestResponse {
    private final Builder builder;

    private SimpleRestResponse(Builder builder) {
        this.builder = builder;
    }

    @Override
    public int getStatus() {
        return this.builder.getStatus();
    }

    @Override
    public Object getEntity() {
        return this.builder.getEntity();
    }

    public static class Builder
    implements RestResponseBuilder<Builder> {
        private Map<String, Object> headers = new HashMap<String, Object>();
        private int status;
        private Object entity;
        private CacheControl cacheControl;
        private MediaType type;
        private Date expires;
        private Date lastModified;
        private String tag;

        @Override
        public SimpleRestResponse build() {
            return new SimpleRestResponse(this);
        }

        @Override
        public Builder status(int status) {
            this.status = status;
            return this;
        }

        @Override
        public Builder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public Builder cacheControl(CacheControl cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        @Override
        public Builder header(String name, Object value) {
            this.headers.put(name, value);
            return this;
        }

        @Override
        public Builder contentType(MediaType type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder expires(Date expires) {
            this.expires = expires;
            return this;
        }

        @Override
        public Builder lastModified(Date lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public Builder eTag(String tag) {
            this.tag = tag;
            return this;
        }

        @Override
        public int getStatus() {
            return this.status;
        }

        @Override
        public Object getEntity() {
            return this.entity;
        }

        @Override
        public Object getHeader(String header) {
            return this.headers.get(header);
        }
    }
}

