/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.dataconversion.Gzip;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.BaseRestOperationsTest;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.search.entity.Person;
import org.infinispan.server.core.dataconversion.JsonTranscoder;
import org.infinispan.server.core.dataconversion.XMLTranscoder;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.RestOperationsTest")
public class RestOperationsTest
extends BaseRestOperationsTest {
    @Override
    void defineCaches(EmbeddedCacheManager cm) {
        super.defineCaches(cm);
        ConfigurationBuilder object = this.getDefaultCacheBuilder();
        object.encoding().key().mediaType("text/plain");
        object.encoding().value().mediaType("application/x-java-object");
        ConfigurationBuilder legacyStorageCache = this.getDefaultCacheBuilder();
        legacyStorageCache.encoding().key().mediaType("application/x-java-object;type=java.lang.String");
        cm.defineConfiguration("objectCache", object.build());
        cm.defineConfiguration("legacy", legacyStorageCache.build());
    }

    @Test
    public void shouldReadWriteToLegacyCache() throws Exception {
        this.putStringValueInCache("legacy", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "legacy", "test")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText("test");
    }

    @Test
    public void shouldConvertExistingSerializableObjectToJson() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("objectCache", "test".getBytes(), testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "objectCache", "test")).header(HttpHeader.ACCEPT, "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"_type\":\"" + TestClass.class.getName() + "\",\"name\":\"test\"}");
    }

    @Test
    public void shouldConvertExistingSerializableObjectToXml() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("objectCache", "test".getBytes(), testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "objectCache", "test")).header(HttpHeader.ACCEPT, "application/xml").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/xml");
        ResponseAssertion.assertThat(response).hasReturnedText("<?xml version=\"1.0\" ?><org.infinispan.rest.TestClass><name>test</name></org.infinispan.rest.TestClass>");
    }

    @Test
    public void shouldReadAsBinaryWithPojoCache() throws Exception {
        String cacheName = "pojoCache";
        String key = "test";
        TestClass value = new TestClass();
        value.setName("test");
        this.putValueInCache(cacheName, key, value);
        ContentResponse response = this.get(cacheName, key, "application/octet-stream");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldReadTextWithPojoCache() throws Exception {
        String cacheName = "pojoCache";
        String key = "k1";
        String value = "v1";
        this.putValueInCache(cacheName, key, value);
        ContentResponse response = this.get(cacheName, key, "text/plain");
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText(value);
    }

    @Test
    public void shouldReadByteArrayWithPojoCache() throws Exception {
        AdvancedCache cache = this.restServer().getCacheManager().getCache("pojoCache").getAdvancedCache().withEncoding(IdentityEncoder.class);
        cache.put((Object)"k1", (Object)"v1".getBytes());
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "pojoCache", "k1")).header(HttpHeader.ACCEPT, "application/octet-stream").send();
        ResponseAssertion.assertThat(response).hasReturnedBytes("v1".getBytes());
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldReadAsJsonWithPojoCache() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        this.putValueInCache("pojoCache", "test", testClass);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "pojoCache", "test")).header(HttpHeader.ACCEPT, "application/json").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("application/json");
        ResponseAssertion.assertThat(response).hasReturnedText("{\"_type\":\"org.infinispan.rest.TestClass\",\"name\":\"test\"}");
    }

    @Test
    public void shouldNegotiateFromPojoCacheWithoutAccept() throws Exception {
        TestClass testClass = new TestClass();
        testClass.setName("test");
        String cacheName = "pojoCache";
        String key = "k1";
        this.putValueInCache(cacheName, key, testClass);
        ContentResponse response = this.get(cacheName, key, null);
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
        ResponseAssertion.assertThat(response).hasReturnedText(testClass.toString());
    }

    @Test
    public void shouldWriteTextContentWithPjoCache() throws Exception {
        this.putStringValueInCache("pojoCache", "key1", "data");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "pojoCache", "key1")).header(HttpHeader.ACCEPT, "text/plain").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedText("data");
        ResponseAssertion.assertThat(response).hasContentType("text/plain");
    }

    @Test
    public void shouldWriteOctetStreamToDefaultCache() throws Exception {
        this.putBinaryValueInCache("default", "keyA", "<hey>ho</hey>".getBytes(), MediaType.APPLICATION_OCTET_STREAM);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "default", "keyA")).send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).hasReturnedBytes("<hey>ho</hey>".getBytes());
        ResponseAssertion.assertThat(response).hasContentType("application/octet-stream");
    }

    @Test
    public void shouldIgnoreDisabledCaches() throws Exception {
        this.putStringValueInCache("default", "K", "V");
        String url = String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "default", "K");
        ContentResponse response = this.client.newRequest(url).send();
        ResponseAssertion.assertThat(response).isOk();
        this.restServer().ignoreCache("default");
        response = this.client.newRequest(url).send();
        ResponseAssertion.assertThat(response).isServiceUnavailable();
        this.restServer().unignoreCache("default");
        response = this.client.newRequest(url).send();
        ResponseAssertion.assertThat(response).isOk();
    }

    @Test
    public void shouldDeleteExistingValueEvenWithoutMetadata() throws Exception {
        this.putValueInCache("default", "test".getBytes(), "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "default", "test")).method(HttpMethod.DELETE).send();
        ResponseAssertion.assertThat(response).isOk();
        Assertions.assertThat((Map)this.restServer().getCacheManager().getCache("default")).isEmpty();
    }

    @Test
    public void testCORSPreflight() throws Exception {
        this.putValueInCache("default", "key", "value");
        ContentResponse preFlight = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "default", "key")).method(HttpMethod.OPTIONS).header(HttpHeader.HOST, "localhost").header(HttpHeader.ORIGIN, "http://localhost:80").header("access-control-request-method", "GET").send();
        ResponseAssertion.assertThat(preFlight).isOk();
        ResponseAssertion.assertThat(preFlight).hasNoContent();
        ResponseAssertion.assertThat(preFlight).containsAllHeaders("access-control-allow-origin", "access-control-allow-methods");
    }

    @Test
    public void testCorsGET() throws Exception {
        this.putStringValueInCache("default", "test", "test");
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "default", "test")).header(HttpHeader.ORIGIN, "http://127.0.0.1:80").send();
        ResponseAssertion.assertThat(response).isOk();
        ResponseAssertion.assertThat(response).containsAllHeaders("access-control-allow-origin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompression() throws Exception {
        String payload = Util.getResourceAsString((String)"person.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.putStringValueInCache("default", "k", payload);
        HttpClient uncompressingClient = new HttpClient();
        try {
            uncompressingClient.start();
            uncompressingClient.getContentDecoderFactories().clear();
            ContentResponse response = uncompressingClient.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "default", "k")).header(HttpHeader.ACCEPT, "text/plain").send();
            ResponseAssertion.assertThat(response).hasNoContentEncoding();
            ResponseAssertion.assertThat(response).hasContentLength(payload.getBytes().length);
            this.client.getContentDecoderFactories().clear();
            response = uncompressingClient.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "default", "k")).header(HttpHeader.ACCEPT, "text/plain").header(HttpHeader.ACCEPT_ENCODING, "gzip").send();
            ResponseAssertion.assertThat(response).hasGzipContentEncoding();
            AssertJUnit.assertEquals((String)Gzip.decompress((byte[])response.getContent()), (String)payload);
        }
        finally {
            uncompressingClient.stop();
        }
    }

    @Test
    public void testReplaceExistingObject() throws Exception {
        String initialJson = "{\"_type\":\"org.infinispan.rest.TestClass\",\"name\":\"test\"}";
        String changedJson = "{\"_type\":\"org.infinispan.rest.TestClass\",\"name\":\"test2\"}";
        ContentResponse response = this.writeJsonToCache("key", initialJson, "objectCache");
        ResponseAssertion.assertThat(response).isOk();
        response = this.writeJsonToCache("key", changedJson, "objectCache");
        ResponseAssertion.assertThat(response).isOk();
        response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "objectCache", "key")).header(HttpHeader.ACCEPT, "application/json").send();
        JsonNode jsonNode = new ObjectMapper().readTree(response.getContentAsString());
        AssertJUnit.assertEquals((String)jsonNode.get("name").asText(), (String)"test2");
    }

    private ContentResponse writeJsonToCache(String key, String json, String cacheName) throws Exception {
        return this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), cacheName, key)).content((ContentProvider)new StringContentProvider(json)).header(HttpHeader.CONTENT_TYPE, "application/json").method(HttpMethod.PUT).send();
    }

    @Test
    public void testServerDeserialization() throws Exception {
        Person value = new Person();
        byte[] jbossMarshalled = new GenericJBossMarshaller().objectToByteBuffer((Object)value);
        byte[] jsonMarshalled = (byte[])new JsonTranscoder().transcode((Object)value, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_JSON);
        byte[] xmlMarshalled = (byte[])new XMLTranscoder().transcode((Object)value, MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_XML);
        byte[] javaMarshalled = new JavaSerializationMarshaller().objectToByteBuffer((Object)value);
        String expectError = "Class '" + value.getClass().getName() + "' blocked by deserialization white list";
        ContentResponse response1 = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "objectCache", "addr1")).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{jbossMarshalled})).header(HttpHeader.CONTENT_TYPE, "application/x-jboss-marshalling").method(HttpMethod.PUT).send();
        ResponseAssertion.assertThat(response1).isError();
        ResponseAssertion.assertThat(response1).containsReturnedText(expectError);
        ContentResponse response2 = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "objectCache", "addr2")).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{jsonMarshalled})).header(HttpHeader.CONTENT_TYPE, "application/json").method(HttpMethod.PUT).send();
        ResponseAssertion.assertThat(response2).isError();
        ResponseAssertion.assertThat(response2).containsReturnedText(expectError);
        ContentResponse response3 = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "objectCache", "addr3")).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{xmlMarshalled})).header(HttpHeader.CONTENT_TYPE, "application/xml").method(HttpMethod.PUT).send();
        ResponseAssertion.assertThat(response3).isError();
        ResponseAssertion.assertThat(response3).containsReturnedText(expectError);
        ContentResponse response4 = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer().getPort(), "objectCache", "addr4")).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{javaMarshalled})).header(HttpHeader.CONTENT_TYPE, "application/x-java-serialized-object").method(HttpMethod.PUT).send();
        ResponseAssertion.assertThat(response4).isError();
        ResponseAssertion.assertThat(response4).containsReturnedText(expectError);
    }

    @Test
    public void testGetExistingConfig() throws Exception {
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/configurations/objectCache", this.restServer().getPort())).send();
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = new ObjectMapper().readTree(response.getContentAsString());
        AssertJUnit.assertEquals((String)"application/x-java-object", (String)jsonNode.path("distributed-cache").path("encoding").path("value").path("media-type").asText());
    }

    @Test
    public void testConfigConverter() throws Exception {
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/v2/configurations?action=toJSON", this.restServer().getPort())).method(HttpMethod.POST).content((ContentProvider)new InputStreamContentProvider(((Object)((Object)this)).getClass().getResourceAsStream("/infinispan.xml"))).send();
        ResponseAssertion.assertThat(response).isOk();
        JsonNode jsonNode = new ObjectMapper().readTree(response.getContentAsString());
        AssertJUnit.assertEquals((int)2, (int)jsonNode.findValue("string-keyed-jdbc-store").size());
    }
}

