/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.framework;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.ResourceManager;
import org.infinispan.rest.framework.RestDispatcher;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.framework.impl.ResourceManagerImpl;
import org.infinispan.rest.framework.impl.RestDispatcherImpl;
import org.infinispan.rest.framework.impl.SimpleRequest;
import org.infinispan.rest.framework.impl.SimpleRestResponse;
import org.infinispan.rest.operations.exceptions.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="rest.framework.RestDispatcherTest")
public class RestDispatcherTest {
    @Test
    public void testDispatch() throws Exception {
        ResourceManagerImpl manager = new ResourceManagerImpl("ctx");
        manager.registerResource((ResourceHandler)new RootResource());
        manager.registerResource((ResourceHandler)new CounterResource());
        manager.registerResource((ResourceHandler)new MemoryResource());
        manager.registerResource((ResourceHandler)new EchoResource());
        RestDispatcherImpl restDispatcher = new RestDispatcherImpl((ResourceManager)manager);
        SimpleRequest restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/").build();
        RestResponse response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"Hello World!", (String)response.getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.POST).setPath("/ctx/counters/counter1").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/counters/counter1?action=increment").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((int)200, (int)response.getStatus());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/counters/counter1").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"counter1->1", (String)response.getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.POST).setPath("/ctx/jvm").build();
        this.assertNoResource((RestDispatcher)restDispatcher, (RestRequest)restRequest);
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/jvm/memory").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertTrue((Long.valueOf(response.getEntity().toString()) > 0L ? 1 : 0) != 0);
        restRequest = new SimpleRequest.Builder().setMethod(Method.HEAD).setPath("/ctx/jvm/memory").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertTrue((Long.valueOf(response.getEntity().toString()) > 0L ? 1 : 0) != 0);
        restRequest = new SimpleRequest.Builder().setMethod(Method.HEAD).setPath("/ctx/v2/java-memory").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertTrue((Long.valueOf(response.getEntity().toString()) > 0L ? 1 : 0) != 0);
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/context/var1/var2").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"var1,var2", (String)response.getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/context/var1/var2/var3?action=triple").build();
        response = restDispatcher.dispatch((RestRequest)restRequest);
        AssertJUnit.assertEquals((String)"triple(var1,var2,var3)", (String)response.getEntity().toString());
        restRequest = new SimpleRequest.Builder().setMethod(Method.GET).setPath("/ctx/context/var1/var2/var3?action=invalid").build();
        this.assertNoResource((RestDispatcher)restDispatcher, (RestRequest)restRequest);
    }

    private void assertNoResource(RestDispatcher dispatcher, RestRequest restRequest) {
        try {
            RestResponse response = dispatcher.dispatch(restRequest);
            if (response != null) {
                Assert.fail();
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            // empty catch block
        }
    }

    class RootResource
    implements ResourceHandler {
        RootResource() {
        }

        public Invocations getInvocations() {
            return new Invocations.Builder().invocation().method(Method.GET).path("/").handleWith(this::serveStaticResource).create();
        }

        private RestResponse serveStaticResource(RestRequest restRequest) {
            return new SimpleRestResponse.Builder().entity((Object)"Hello World!").build();
        }
    }

    class MemoryResource
    implements ResourceHandler {
        MemoryResource() {
        }

        public Invocations getInvocations() {
            return new Invocations.Builder().invocation().methods(new Method[]{Method.GET, Method.HEAD}).path("/jvm/memory").path("/v2/java-memory").handleWith(this::showMemory).create();
        }

        private RestResponse showMemory(RestRequest request) {
            return new SimpleRestResponse.Builder().entity((Object)String.valueOf(Runtime.getRuntime().freeMemory())).build();
        }
    }

    class CounterResource
    implements ResourceHandler {
        private final Map<String, AtomicInteger> counters = new HashMap<String, AtomicInteger>();

        CounterResource() {
        }

        public Invocations getInvocations() {
            return new Invocations.Builder().invocation().name("allCounters").method(Method.GET).path("/counters").handleWith(this::listAllCounters).invocation().name("addCounter").method(Method.POST).path("/counters/{name}").handleWith(this::addCounter).invocation().name("getCounter").method(Method.GET).path("/counters/{name}").handleWith(this::getCounter).invocation().name("incrementCounter").method(Method.GET).path("/counters/{name}").withAction("increment").handleWith(this::incrementCounter).create();
        }

        private RestResponse listAllCounters(RestRequest request) {
            SimpleRestResponse.Builder responseBuilder = new SimpleRestResponse.Builder();
            StringBuilder sb = new StringBuilder();
            this.counters.forEach((key, value) -> sb.append((String)key).append("->").append(value.get()));
            return responseBuilder.status(200).entity((Object)sb.toString()).build();
        }

        private RestResponse addCounter(RestRequest request) {
            SimpleRestResponse.Builder responseBuilder = new SimpleRestResponse.Builder();
            String newCounterName = (String)request.variables().get("name");
            if (newCounterName == null) {
                return responseBuilder.status(503).build();
            }
            this.counters.put(newCounterName, new AtomicInteger());
            return responseBuilder.status(200).build();
        }

        private RestResponse getCounter(RestRequest restRequest) {
            SimpleRestResponse.Builder responseBuilder = new SimpleRestResponse.Builder();
            String name = (String)restRequest.variables().get("name");
            AtomicInteger atomicInteger = this.counters.get(name);
            if (atomicInteger == null) {
                return responseBuilder.status(404).build();
            }
            return responseBuilder.status(200).entity((Object)(name + "->" + atomicInteger.get())).build();
        }

        private RestResponse incrementCounter(RestRequest request) {
            SimpleRestResponse.Builder responseBuilder = new SimpleRestResponse.Builder();
            String name = (String)request.variables().get("name");
            if (name == null) {
                return responseBuilder.status(404).build();
            }
            this.counters.get(name).incrementAndGet();
            return responseBuilder.status(200).build();
        }
    }

    class EchoResource
    implements ResourceHandler {
        EchoResource() {
        }

        public Invocations getInvocations() {
            return new Invocations.Builder().invocation().name("doubleVars").method(Method.GET).path("/context/{variable1}/{variable2}").handleWith(this::doubleVars).invocation().name("tripleVars").method(Method.GET).path("/context/{variable1}/{variable2}/{variable3}").withAction("triple").handleWith(this::tripleVarWithAction).create();
        }

        private RestResponse tripleVarWithAction(RestRequest restRequest) {
            SimpleRestResponse.Builder responseBuilder = new SimpleRestResponse.Builder();
            String variable1 = (String)restRequest.variables().get("variable1");
            String variable2 = (String)restRequest.variables().get("variable2");
            String variable3 = (String)restRequest.variables().get("variable3");
            String action = restRequest.getAction();
            return responseBuilder.entity((Object)(action + "(" + variable1 + "," + variable2 + "," + variable3 + ")")).build();
        }

        private RestResponse doubleVars(RestRequest restRequest) {
            SimpleRestResponse.Builder responseBuilder = new SimpleRestResponse.Builder();
            String variable1 = (String)restRequest.variables().get("variable1");
            String variable2 = (String)restRequest.variables().get("variable2");
            return responseBuilder.entity((Object)(variable1 + "," + variable2)).build();
        }
    }
}

