/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestChannelInitializer;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.impl.VoidAuthenticator;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.RestDispatcher;
import org.infinispan.rest.framework.impl.ResourceManagerImpl;
import org.infinispan.rest.framework.impl.RestDispatcherImpl;
import org.infinispan.rest.resources.CacheResource;
import org.infinispan.rest.resources.ConfigResource;
import org.infinispan.rest.resources.SplashResource;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;

public class RestServer
extends AbstractProtocolServer<RestServerConfiguration> {
    private Authenticator authenticator = new VoidAuthenticator();
    private RestDispatcher restDispatcher;
    private RestCacheManager<Object> restCacheManager;

    public RestServer() {
        super("REST");
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return null;
    }

    public ChannelInitializer<Channel> getInitializer() {
        return new NettyInitializers(new NettyInitializer[]{this.getRestChannelInitializer()});
    }

    public RestChannelInitializer getRestChannelInitializer() {
        return new RestChannelInitializer(this, this.transport);
    }

    Authenticator getAuthenticator() {
        return this.authenticator;
    }

    RestDispatcher getRestDispatcher() {
        return this.restDispatcher;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void stop() {
        super.stop();
        this.restCacheManager.stop();
    }

    protected void startInternal(RestServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        super.startInternal((ProtocolServerConfiguration)configuration, cacheManager);
        this.restCacheManager = new RestCacheManager(cacheManager, arg_0 -> ((RestServer)this).isCacheIgnored(arg_0));
        String rootContext = configuration.startTransport() ? configuration.contextPath() : "*";
        ResourceManagerImpl resourceManager = new ResourceManagerImpl(rootContext);
        resourceManager.registerResource(new CacheResource(this.restCacheManager, configuration));
        resourceManager.registerResource(new SplashResource());
        resourceManager.registerResource(new ConfigResource(cacheManager));
        this.restDispatcher = new RestDispatcherImpl(resourceManager);
    }

    public int getWorkerThreads() {
        return 1;
    }
}

