/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheSet;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.encoding.DataConversion;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.CacheControl;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.operations.CacheOperationsHelper;
import org.infinispan.rest.operations.exceptions.NoDataFoundException;
import org.infinispan.rest.operations.exceptions.NoKeyException;
import org.infinispan.rest.operations.exceptions.UnacceptableDataFormatException;
import org.infinispan.rest.operations.mediatypes.Charset;
import org.infinispan.rest.operations.mediatypes.EntrySetFormatter;
import org.infinispan.rest.operations.mediatypes.OutputPrinter;
import org.infinispan.rest.resources.CacheResourceQueryAction;
import org.infinispan.util.logging.LogFactory;

public class CacheResource
implements ResourceHandler {
    private static final MurmurHash3 hashFunc = MurmurHash3.getInstance();
    private static final Log logger = (Log)LogFactory.getLog(CacheResource.class, Log.class);
    private final RestCacheManager<Object> restCacheManager;
    private final RestServerConfiguration restServerConfiguration;
    private final CacheResourceQueryAction queryAction;

    public CacheResource(RestCacheManager<Object> restCacheManager, RestServerConfiguration restServerConfiguration) {
        this.restCacheManager = restCacheManager;
        this.restServerConfiguration = restServerConfiguration;
        this.queryAction = new CacheResourceQueryAction(restCacheManager);
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.PUT, Method.POST).path("/{cacheName}/{cacheKey}").handleWith(this::putValueToCache).invocation().methods(Method.GET, Method.HEAD).path("/{cacheName}/{cacheKey}").handleWith(this::getCacheValue).invocation().method(Method.DELETE).path("/{cacheName}/{cacheKey}").handleWith(this::deleteCacheValue).invocation().method(Method.DELETE).path("/{cacheName}").handleWith(this::clearEntireCache).invocation().method(Method.GET).path("/{cacheName}").handleWith(this::getCacheKeys).invocation().methods(Method.GET, Method.POST).path("/{cacheName}").withAction("search").handleWith(this.queryAction::search).create();
    }

    private NettyRestResponse getCacheKeys(RestRequest request) throws RestResponseException {
        try {
            String cacheName = request.variables().get("cacheName");
            String accept = request.getAcceptHeader();
            if (accept == null) {
                accept = "*/*";
            }
            MediaType contentType = this.negotiateMediaType(accept, cacheName);
            AdvancedCache<Object, Object> cache = this.restCacheManager.getCache(cacheName, MediaType.TEXT_PLAIN, MediaType.TEXT_PLAIN);
            CacheSet keys = cache.keySet();
            Charset charset = Charset.fromMediaType(accept);
            if (charset == null) {
                charset = Charset.UTF8;
            }
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
            responseBuilder.contentType(contentType);
            responseBuilder.header(HttpHeaderNames.CACHE_CONTROL.toString(), CacheControl.noCache());
            OutputPrinter outputPrinter = EntrySetFormatter.forMediaType(contentType);
            responseBuilder.entity(outputPrinter.print(cacheName, keys, charset));
            return responseBuilder.build();
        }
        catch (CacheException cacheException) {
            throw this.createResponseException(cacheException);
        }
    }

    private RestResponse deleteCacheValue(RestRequest request) throws RestResponseException {
        try {
            String cacheName = request.variables().get("cacheName");
            String key = request.variables().get("cacheKey");
            if (key == null) {
                throw new NoKeyException();
            }
            boolean useAsync = request.getPerformAsyncHeader();
            MediaType keyContentType = request.keyContentType();
            CacheEntry<Object, Object> entry = this.restCacheManager.getInternalEntry(cacheName, key, keyContentType, MediaType.MATCH_ALL);
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
            if (entry instanceof InternalCacheEntry) {
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                String etag = this.calcETAG(ice.getValue());
                String clientEtag = request.getEtagIfNoneMatchHeader();
                if (clientEtag == null || clientEtag.equals(etag)) {
                    responseBuilder.status(HttpResponseStatus.OK.code());
                    this.restCacheManager.remove(cacheName, key, keyContentType, useAsync);
                } else {
                    responseBuilder.status(HttpResponseStatus.PRECONDITION_FAILED.code());
                }
            }
            return responseBuilder.build();
        }
        catch (CacheException cacheException) {
            throw this.createResponseException(cacheException);
        }
    }

    private RestResponse putValueToCache(RestRequest request) {
        try {
            String cacheName = request.variables().get("cacheName");
            MediaType contentType = request.contentType();
            MediaType keyContentType = request.keyContentType();
            AdvancedCache<Object, Object> cache = this.restCacheManager.getCache(cacheName, keyContentType, contentType);
            String key = request.variables().get("cacheKey");
            if (key == null) {
                throw new NoKeyException();
            }
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
            if (request.method() == Method.POST && cache.containsKey((Object)key)) {
                return responseBuilder.status(HttpResponseStatus.CONFLICT.code()).entity("An entry already exists").build();
            }
            Object oldData = null;
            ContentSource contents = request.contents();
            if (contents == null) {
                throw new NoDataFoundException();
            }
            byte[] data = request.contents().rawContent();
            CacheEntry<Object, Object> entry = this.restCacheManager.getInternalEntry(cacheName, key, true, keyContentType, contentType);
            if (entry instanceof InternalCacheEntry) {
                String etag;
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                String etagNoneMatch = request.getEtagIfNoneMatchHeader();
                if (etagNoneMatch != null && etagNoneMatch.equals(etag = this.calcETAG(ice.getValue()))) {
                    responseBuilder.status(HttpResponseStatus.NOT_MODIFIED.code());
                    return responseBuilder.build();
                }
            }
            boolean useAsync = request.getPerformAsyncHeader();
            Long ttl = request.getTimeToLiveSecondsHeader();
            Long idle = request.getMaxIdleTimeSecondsHeader();
            return this.putInCache(responseBuilder, useAsync, cache, key, data, ttl, idle);
        }
        catch (IllegalStateException | CacheException e) {
            throw this.createResponseException(e);
        }
    }

    private RestResponse clearEntireCache(RestRequest request) throws RestResponseException {
        try {
            String cacheName = request.variables().get("cacheName");
            boolean useAsync = request.getPerformAsyncHeader();
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
            responseBuilder.status(HttpResponseStatus.OK.code());
            if (useAsync) {
                this.restCacheManager.getCache(cacheName).clearAsync();
            } else {
                this.restCacheManager.getCache(cacheName).clear();
            }
            return responseBuilder.build();
        }
        catch (CacheException cacheException) {
            throw this.createResponseException(cacheException);
        }
    }

    private NettyRestResponse getCacheValue(RestRequest request) throws RestResponseException {
        try {
            String cacheName = request.variables().get("cacheName");
            String accept = request.getAcceptHeader();
            if (accept == null) {
                accept = "*/*";
            }
            MediaType keyContentType = request.keyContentType();
            MediaType requestedMediaType = this.negotiateMediaType(accept, cacheName);
            String key = request.variables().get("cacheKey");
            if (key == null) {
                throw new NoKeyException();
            }
            String cacheControl = request.getCacheControlHeader();
            boolean returnBody = request.method() == Method.GET;
            CacheEntry<Object, Object> entry = this.restCacheManager.getInternalEntry(cacheName, key, keyContentType, requestedMediaType);
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
            responseBuilder.status(HttpResponseStatus.NOT_FOUND.code());
            if (entry instanceof InternalCacheEntry) {
                OptionalInt minFreshSeconds;
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                Date lastMod = CacheOperationsHelper.lastModified(ice);
                Date expires = ice.canExpire() ? new Date(ice.getExpiryTime()) : null;
                if (CacheOperationsHelper.entryFreshEnough(expires, minFreshSeconds = CacheOperationsHelper.minFresh(cacheControl))) {
                    Metadata meta = ice.getMetadata();
                    String etag = this.calcETAG(ice.getValue());
                    String ifNoneMatch = request.getEtagIfNoneMatchHeader();
                    String ifMatch = request.getEtagIfMatchHeader();
                    String ifUnmodifiedSince = request.getEtagIfUnmodifiedSinceHeader();
                    String ifModifiedSince = request.getEtagIfModifiedSinceHeader();
                    if (ifNoneMatch != null && ifNoneMatch.equals(etag)) {
                        return responseBuilder.status(HttpResponseStatus.NOT_MODIFIED).build();
                    }
                    if (ifMatch != null && !ifMatch.equals(etag)) {
                        return responseBuilder.status(HttpResponseStatus.PRECONDITION_FAILED).build();
                    }
                    if (CacheOperationsHelper.ifUnmodifiedIsBeforeEntryModificationDate(ifUnmodifiedSince, lastMod)) {
                        return responseBuilder.status(HttpResponseStatus.PRECONDITION_FAILED).build();
                    }
                    if (CacheOperationsHelper.ifModifiedIsAfterEntryModificationDate(ifModifiedSince, lastMod)) {
                        return responseBuilder.status(HttpResponseStatus.NOT_MODIFIED).build();
                    }
                    Object value = ice.getValue();
                    MediaType configuredMediaType = this.restCacheManager.getValueConfiguredFormat(cacheName);
                    this.writeValue(value, requestedMediaType, configuredMediaType, responseBuilder, returnBody);
                    responseBuilder.status(HttpResponseStatus.OK).lastModified(lastMod).eTag(etag).cacheControl(CacheOperationsHelper.calcCacheControl(expires)).expires(expires).timeToLive(meta.lifespan()).maxIdle(meta.maxIdle()).created(ice.getCreated()).lastUsed(ice.getLastUsed());
                    List<String> extended = request.parameters().get("extended");
                    if (extended != null && extended.size() > 0 && CacheOperationsHelper.supportsExtendedHeaders(this.restServerConfiguration, extended.iterator().next())) {
                        responseBuilder.clusterPrimaryOwner(this.restCacheManager.getPrimaryOwner(cacheName, key)).clusterNodeName(this.restCacheManager.getNodeName()).clusterServerAddress(this.restCacheManager.getServerAddress());
                    }
                }
            }
            return responseBuilder.build();
        }
        catch (CacheException cacheException) {
            throw this.createResponseException(cacheException);
        }
    }

    private void writeValue(Object value, MediaType requested, MediaType configuredMediaType, NettyRestResponse.Builder responseBuilder, boolean returnBody) {
        MediaType responseContentType = !requested.matchesAll() ? requested : (configuredMediaType == null ? (value instanceof byte[] ? MediaType.APPLICATION_OCTET_STREAM : MediaType.TEXT_PLAIN) : configuredMediaType);
        responseBuilder.contentType(responseContentType);
        if (returnBody) {
            responseBuilder.entity(value);
        }
    }

    private <V> String calcETAG(V value) {
        return String.valueOf(hashFunc.hash(value));
    }

    private RestResponse putInCache(NettyRestResponse.Builder responseBuilder, boolean useAsync, AdvancedCache<Object, Object> cache, Object key, byte[] data, Long ttl, Long idleTime) {
        Metadata metadata = CacheOperationsHelper.createMetadata(cache.getCacheConfiguration(), ttl, idleTime);
        if (useAsync) {
            cache.putAsync(key, (Object)data, metadata);
        } else {
            cache.put(key, (Object)data, metadata);
        }
        responseBuilder.header("etag", this.calcETAG(data));
        return responseBuilder.build();
    }

    private RestResponseException createResponseException(Throwable exception) {
        Throwable rootCauseException = this.getRootCauseException(exception);
        return new RestResponseException(HttpResponseStatus.INTERNAL_SERVER_ERROR, rootCauseException.getMessage(), rootCauseException);
    }

    private Throwable getRootCauseException(Throwable re) {
        if (re == null) {
            return null;
        }
        Throwable cause = re.getCause();
        if (cause != null) {
            return this.getRootCauseException(cause);
        }
        return re;
    }

    private MediaType tryNarrowMediaType(MediaType negotiated, AdvancedCache<?, ?> cache) {
        if (!negotiated.matchesAll()) {
            return negotiated;
        }
        MediaType storageMediaType = cache.getValueDataConversion().getStorageMediaType();
        if (storageMediaType == null) {
            return negotiated;
        }
        if (storageMediaType.equals((Object)MediaType.APPLICATION_OBJECT)) {
            return MediaType.TEXT_PLAIN;
        }
        if (storageMediaType.match(MediaType.APPLICATION_PROTOSTREAM)) {
            return MediaType.APPLICATION_JSON;
        }
        return negotiated;
    }

    private MediaType negotiateMediaType(String accept, String cacheName) throws UnacceptableDataFormatException {
        try {
            AdvancedCache<Object, Object> cache = this.restCacheManager.getCache(cacheName);
            DataConversion valueDataConversion = cache.getValueDataConversion();
            Optional<MediaType> negotiated = MediaType.parseList((String)accept).filter(arg_0 -> ((DataConversion)valueDataConversion).isConversionSupported(arg_0)).findFirst();
            return negotiated.map(m -> this.tryNarrowMediaType((MediaType)m, cache)).orElseThrow(() -> logger.unsupportedDataFormat(accept));
        }
        catch (EncodingException e) {
            throw new UnacceptableDataFormatException();
        }
    }
}

