/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.authentication.impl;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.SslHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;

public class ClientCertAuthenticator
implements Authenticator {
    @Override
    public CompletionStage<RestResponse> challenge(RestRequest request, ChannelHandlerContext ctx) {
        try {
            SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
            SSLSession session = sslHandler.engine().getSession();
            Subject subject = new Subject();
            subject.getPrincipals().add(session.getPeerPrincipal());
            request.setSubject(subject);
            return CompletableFuture.completedFuture(new NettyRestResponse.Builder().build());
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(HttpResponseStatus.UNAUTHORIZED).build());
        }
    }
}

