/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.cachemanager;

import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.security.auth.Subject;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listenable;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.rest.cachemanager.RestSourceMigrator;
import org.infinispan.rest.cachemanager.SecurityActions;
import org.infinispan.rest.logging.Log;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.util.logging.LogFactory;

public class RestCacheManager<V> {
    protected static final Log logger = (Log)LogFactory.getLog(RestCacheManager.class, Log.class);
    private final EmbeddedCacheManager instance;
    private final InternalCacheRegistry icr;
    private final Predicate<? super String> isCacheIgnored;
    private final boolean allowInternalCacheAccess;
    private final Map<String, AdvancedCache<Object, V>> knownCaches = new ConcurrentHashMap<String, AdvancedCache<Object, V>>(4, 0.9f, 16);
    private final RemoveCacheListener removeCacheListener;

    public RestCacheManager(EmbeddedCacheManager instance, Predicate<? super String> isCacheIgnored) {
        this.instance = instance;
        this.isCacheIgnored = isCacheIgnored;
        this.icr = (InternalCacheRegistry)SecurityActions.getGlobalComponentRegistry(instance).getComponent(InternalCacheRegistry.class);
        this.allowInternalCacheAccess = SecurityActions.getCacheManagerConfiguration(instance).security().authorization().enabled();
        this.removeCacheListener = new RemoveCacheListener();
        SecurityActions.addListener(instance, this.removeCacheListener);
    }

    public AdvancedCache<Object, V> getCache(String name, MediaType keyContentType, MediaType valueContentType, Subject subject) {
        if (this.isCacheIgnored.test(name)) {
            throw logger.cacheUnavailable(name);
        }
        if (keyContentType == null || valueContentType == null) {
            throw logger.missingRequiredMediaType(name);
        }
        this.checkCacheAvailable(name);
        String cacheKey = name + "-" + keyContentType.toString() + valueContentType.getTypeSubtype();
        AdvancedCache cache = this.knownCaches.get(cacheKey);
        if (cache == null) {
            cache = this.instance.getCache(name).getAdvancedCache();
            this.tryRegisterMigrationManager(cache);
            cache = cache.getAdvancedCache().withMediaType(keyContentType.toString(), valueContentType.toString()).withFlags(Flag.IGNORE_RETURN_VALUES);
            this.knownCaches.putIfAbsent(cacheKey, cache);
        }
        return subject == null ? cache : cache.withSubject(subject);
    }

    public AdvancedCache<Object, V> getCache(String name, Subject subject) {
        return this.getCache(name, MediaType.MATCH_ALL, MediaType.MATCH_ALL, subject);
    }

    private void checkCacheAvailable(String cacheName) {
        if (!this.instance.getCacheNames().contains(cacheName)) {
            throw logger.cacheNotFound(cacheName);
        }
        if (this.icr.isPrivateCache(cacheName)) {
            throw logger.requestNotAllowedToInternalCaches(cacheName);
        }
        if (!this.allowInternalCacheAccess && this.icr.isInternalCache(cacheName) && !this.icr.internalCacheHasFlag(cacheName, InternalCacheRegistry.Flag.USER)) {
            throw logger.requestNotAllowedToInternalCachesWithoutAuthz(cacheName);
        }
    }

    public CompletionStage<CacheEntry<Object, V>> getInternalEntry(String cacheName, Object key, MediaType keyContentType, MediaType mediaType, Subject subject) {
        return this.getInternalEntry(cacheName, key, false, keyContentType, mediaType, subject);
    }

    public CompletionStage<V> remove(String cacheName, Object key, MediaType keyContentType, Subject subject) {
        AdvancedCache<Object, V> cache = this.getCache(cacheName, keyContentType, MediaType.MATCH_ALL, subject);
        return cache.removeAsync(key);
    }

    public CompletionStage<CacheEntry<Object, V>> getPrivilegedInternalEntry(AdvancedCache<Object, V> cache, Object key, boolean skipListener) {
        cache = skipListener ? cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION) : cache;
        return SecurityActions.getCacheEntryAsync(cache, key);
    }

    public CompletionStage<CacheEntry<Object, V>> getInternalEntry(AdvancedCache<Object, V> cache, Object key, boolean skipListener) {
        return skipListener ? cache.withFlags(Flag.SKIP_LISTENER_NOTIFICATION).getCacheEntryAsync(key) : cache.getCacheEntryAsync(key);
    }

    public MediaType getValueConfiguredFormat(String cacheName) {
        return SecurityActions.getCacheConfiguration(this.getCache(cacheName, null)).encoding().valueDataType().mediaType();
    }

    public CompletionStage<CacheEntry<Object, V>> getInternalEntry(String cacheName, Object key, boolean skipListener, MediaType keyContentType, MediaType mediaType, Subject subject) {
        return this.getInternalEntry(this.getCache(cacheName, keyContentType, mediaType, subject), key, skipListener);
    }

    public String getNodeName() {
        Address addressToBeReturned = this.instance.getAddress();
        if (addressToBeReturned == null) {
            return "0.0.0.0";
        }
        return addressToBeReturned.toString();
    }

    public String getServerAddress() {
        Transport transport = this.instance.getTransport();
        if (transport instanceof JGroupsTransport) {
            return transport.getPhysicalAddresses().toString();
        }
        return "0.0.0.0";
    }

    public String getPrimaryOwner(String cacheName, Object key) {
        DistributionManager dm = SecurityActions.getDistributionManager(this.getCache(cacheName, null));
        if (dm == null) {
            return "0.0.0.0";
        }
        return dm.getCacheTopology().getDistribution(key).primary().toString();
    }

    public EmbeddedCacheManager getInstance() {
        return this.instance;
    }

    private void tryRegisterMigrationManager(AdvancedCache<?, ?> cache) {
        ComponentRegistry cr = SecurityActions.getCacheComponentRegistry(cache);
        RollingUpgradeManager migrationManager = (RollingUpgradeManager)cr.getComponent(RollingUpgradeManager.class);
        if (migrationManager != null) {
            migrationManager.addSourceMigrator(new RestSourceMigrator((Cache<String, ?>)cache));
        }
    }

    public void stop() {
        if (this.removeCacheListener != null) {
            SecurityActions.removeListener((Listenable)this.instance, this.removeCacheListener);
        }
    }

    @Listener
    class RemoveCacheListener {
        RemoveCacheListener() {
        }

        @CacheStopped
        public void cacheStopped(CacheStoppedEvent event) {
            RestCacheManager.this.knownCaches.keySet().stream().filter(k -> k.startsWith(event.getCacheName() + "-")).forEach(RestCacheManager.this.knownCaches::remove);
        }
    }
}

